{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit projoption;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Graphics, Controls;

type
  { TProjectOptions }

  TProjectOptions = class(TComponent)
  private
    FPicture: TPicture;
    FAppIcon: TIcon;
    FTitle: TCaption;
    FLanguage: string;
    FAppAutor: TCaption;
    FAppName: string;
    FMinVMajor: Integer;
    FMinVMinor: Integer;
    FMinVRevision: Integer;
    FExternalPath: string;
    FAutoCreateExternal: TStrings;
    FStartParametrs: string;
    FOnUpdateExternalPath: TNotifyEvent;
    procedure SetExternalPath(AValue: string);
  public
    ReadOnly: Boolean;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    function ExpandExternalPath: String;
    function ExpandPath(APath: string): String;
    property OnUpdateExternalPath: TNotifyEvent read FOnUpdateExternalPath write FOnUpdateExternalPath;
  published
    property Picture: TPicture read FPicture write FPicture;
    property Title: TCaption read FTitle write FTitle;
    property AppName: string read FAppName write FAppName;
    property Language: string read FLanguage write FLanguage;
    property AppIcon: TIcon read FAppIcon write FAppIcon;
    property AppAutor: TCaption read FAppAutor write FAppAutor;
    property MinVMajor: Integer read FMinVMajor write FMinVMajor;
    property MinVMinor: Integer read FMinVMinor write FMinVMinor;
    property MinVRevision: Integer read FMinVRevision write FMinVRevision;
    property ExternalPath: string read FExternalPath write SetExternalPath;
    property AutoCreateExternal: TStrings read FAutoCreateExternal write FAutoCreateExternal;
    property StartParametrs: string read FStartParametrs write FStartParametrs;
  end;



implementation

uses expandenvvar;

{TProjectOptions}

procedure TProjectOptions.SetExternalPath(AValue: string);
begin
  if FExternalPath <> AValue then
  begin
    FExternalPath := AValue;
    if Assigned(FOnUpdateExternalPath) then FOnUpdateExternalPath(Self);
  end;
end;

constructor TProjectOptions.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Name := 'ProjOption';
  FPicture := TPicture.Create;
  FAppIcon := TIcon.Create;
  ReadOnly := False;
  FMinVMajor := 0;
  FMinVMinor := 0;
  FMinVRevision := 0;
  FExternalPath := '';
  FAutoCreateExternal := TStringList.Create;
end;

destructor TProjectOptions.Destroy;
begin
  FPicture.Assign(nil);
  FPicture.Free;
  FAppIcon.Free;
  FAutoCreateExternal.Free;
  inherited Destroy;
end;

procedure TProjectOptions.Assign(Source: TPersistent);
var
  SourceOpt: TProjectOptions;
begin
  SourceOpt := TProjectOptions(Source);
  Picture.Assign(SourceOpt.Picture);
  AppIcon.Assign(SourceOpt.AppIcon);
  Title := SourceOpt.Title;
  AppAutor := SourceOpt.AppAutor;
end;

function TProjectOptions.ExpandExternalPath:String;
var
  SL: TStringList;
begin
  Result := '';
  SL := TStringList.Create;
  try
    SL.Delimiter:= ';';
    SL.DelimitedText := ExternalPath;
    if SL.Count > 0 then
    begin
      Result := ExpandEnvironmentVariables(SL.Strings[0]);
    end;
  finally
    SL.Free;
  end;

end;

function TProjectOptions.ExpandPath(APath: string): String;
begin
  Result := ExpandEnvironmentVariables(APath);
end;

end.

