{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit ProjOptForm;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, ExtDlgs, ComCtrls;

type

  { TProjectOptionForm }

  TProjectOptionForm = class(TForm)
    Bevel1: TBevel;
    Button1: TButton;
    Button10: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    StartParamEdit: TEdit;
    ExtModuleEdit: TEdit;
    Image1: TImage;
    Image2: TImage;
    Label1: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    LabelExternalPathComment2: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    LabelExternalPathComment1: TLabel;
    ExternalListBox: TListBox;
    MinVMajorEdit: TEdit;
    MinVMinorEdit: TEdit;
    MinVRevisionEdit: TEdit;
    OpenPictureDialog1: TOpenPictureDialog;
    OpenPictureDialog2: TOpenPictureDialog;
    PageControl1: TPageControl;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    SavePictureDialog1: TSavePictureDialog;
    SelectDirectoryDialog1: TSelectDirectoryDialog;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    procedure Button10Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
  private
    { private declarations }
  public
    { public declarations }
  end;


implementation

uses ProjectManager, SrvUsesUnits;

{$R *.lfm}

{ TProjectOptionForm }

procedure TProjectOptionForm.FormClose(Sender: TObject;
  var CloseAction: TCloseAction);
var
  S: string;
begin
  CloseAction := caHide;
  if ModalResult = mrOK then
  begin
    S := Trim(Edit1.Text);
    if S = '' then
    begin
      CloseAction := caNone;
      ShowMessage('Не указано имя программы');
      Edit1.SetFocus;
    end
    else
    begin
      if LastDelimiter(',.()/*-+="''|[]{}&^%$#@!~ ;:<>\', S) > 0 then
      begin
        CloseAction := caNone;
        ShowMessage('Недопустиимый символ в имени программы');
        Edit1.SetFocus;
      end
      else
        ProjManager.RenameProject(S);
    end;
  end;
end;

procedure TProjectOptionForm.Button1Click(Sender: TObject);
begin
  if OpenPictureDialog2.Execute then
    Image1.Picture.LoadFromFile(OpenPictureDialog2.FileName);
end;

procedure TProjectOptionForm.Button10Click(Sender: TObject);
begin
  if ExternalListBox.ItemIndex >= 0 then
    ExternalListBox.Items.Delete(ExternalListBox.ItemIndex);
end;

procedure TProjectOptionForm.Button2Click(Sender: TObject);
begin
  Image1.Picture.Clear;
end;

procedure TProjectOptionForm.Button3Click(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
    Image2.Picture.LoadFromFile(OpenPictureDialog1.FileName);
end;

procedure TProjectOptionForm.Button4Click(Sender: TObject);
begin
  Image2.Picture.Assign(nil);
end;

procedure TProjectOptionForm.Button7Click(Sender: TObject);
begin
  SavePictureDialog1.DefaultExt:= '.ico';
  SavePictureDialog1.FilterIndex := 6;
  if SavePictureDialog1.Execute then
    Image1.Picture.SaveToFile(SavePictureDialog1.FileName);
end;

procedure TProjectOptionForm.Button8Click(Sender: TObject);
begin
  if SelectDirectoryDialog1.Execute then
  begin
    if ExtModuleEdit.Text = '' then
      ExtModuleEdit.Text:= ExcludeTrailingPathDelimiter(SelectDirectoryDialog1.FileName)
    else
      ExtModuleEdit.Text:= ExtModuleEdit.Text + ';' + ExcludeTrailingPathDelimiter(SelectDirectoryDialog1.FileName);
  end;
end;

procedure TProjectOptionForm.Button9Click(Sender: TObject);
var
  I, N: Integer;
begin
  UnitForm := TUnitForm.Create(Self);
  ProjManager.GetExternalModule(UnitForm.ListBox1.Items);

  for I := 0 to ExternalListBox.Items.Count - 1 do
  begin
    N := UnitForm.ListBox1.Items.IndexOf(ExternalListBox.Items.Strings[I]);
    if N >= 0 then UnitForm.ListBox1.Items.Delete(N);
  end;
  if UnitForm.ShowModal = mrOK then
  begin
    if UnitForm.ListBox1.ItemIndex >= 0 then
      ExternalListBox.Items.Add(UnitForm.ListBox1.Items.Strings[UnitForm.ListBox1.ItemIndex]);
  end;
end;

end.

