unit MergeConf;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  ComCtrls, StdCtrls, ActnList, DOM, XMLRead, XMLWrite, projoption, FormDesig;

type

  { TMergeConfForm }

  TMergeConfForm = class(TForm)
    ActOpenMergConf: TAction;
    ActOpenMainConf: TAction;
    ActionList1: TActionList;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    ImageList1: TImageList;
    OpenDialog1: TOpenDialog;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel7: TPanel;
    SaveDialog1: TSaveDialog;
    Splitter1: TSplitter;
    TreeView1: TTreeView;
    TreeView2: TTreeView;
    procedure ActOpenMainConfExecute(Sender: TObject);
    procedure ActOpenMergConfExecute(Sender: TObject);
    procedure ActSendSelectionExecute(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure TreeView2Expanded(Sender: TObject; Node: TTreeNode);
    procedure TreeView2SelectionChanged(Sender: TObject);
  private
    ProjectOption1: TProjectOptions;
    ProjectOption2: TProjectOptions;
    procedure OpenConfig(ATree: TTreeview; FileName: string; var AProjOpt: TProjectOptions);
    function ObjToText(Instance: Tcomponent): string;
    procedure TextToObject(S: string; var Root: TComponent);
  public
    procedure ClearTreeItems(ATree: TTreeView);
    procedure Clear1;
    procedure Clear2;
    procedure ClearAll;
  end;

var
  MergeConfForm: TMergeConfForm;

implementation

uses ftpsend, httpsend, LResources,
  synautil, ProjectManager, AppConst, LCLType;

{$R *.lfm}

{ TMergeConfForm }

procedure TMergeConfForm.ActOpenMainConfExecute(Sender: TObject);
begin
  Clear1;
  OpenDialog1.InitialDir := GetUserDir;
  if OpenDialog1.Execute then
    OpenConfig(TreeView1, OpenDialog1.FileName, ProjectOption1);
end;

procedure TMergeConfForm.ActOpenMergConfExecute(Sender: TObject);
begin
  Clear2;
  OpenDialog1.InitialDir := GetUserDir;
  if OpenDialog1.Execute then
    OpenConfig(TreeView2, OpenDialog1.FileName, ProjectOption2);
end;

procedure TMergeConfForm.ActSendSelectionExecute(Sender: TObject);
var
  Node, PNode: TTreeNode;
  DestNode, PDestNode: TTreeNode;
  APath: string;
  PNodeObjDest, PNodeObjSource: PNodeObject;

  procedure MergeNode;
  begin
    PNodeObjDest := DestNode.Data;
    PNodeObjSource:= TreeView2.Selected.Data;
    if PNodeObjDest = nil then
    begin
      New(PNodeObjDest);
      PNodeObjDest^.ADesignHook := nil;
      DestNode.Data := PNodeObjDest;
    end;
    PNodeObjDest^.Code := PNodeObjSource^.Code;
    PNodeObjDest^.Obj:= PNodeObjSource^.Obj;
    PNodeObjDest^.ObjClassName:= PNodeObjSource^.ObjClassName;
  end;
begin
  Node := TreeView2.Selected;
  if (Node <> nil) and (Node.ImageIndex <> 0) then
  begin
    if (Node.Parent = nil) then
    begin
      ShowMessage('Этот узел не может быть обновлен');
      Exit;
    end;

    APath:= Node.Text;
    while Node.Parent <> nil do
    begin
      Node := Node.Parent;
      APath:= Node.Text + '/' + APath;
    end;
    DestNode := TreeView1.Items.FindNodeWithTextPath(APath);
    if DestNode <> nil then
    begin
      if DestNode.ImageIndex <> 0 then
      begin
        MergeNode;
      end;
    end
    else
    begin
      DestNode := TreeView1.Items.FindNodeWithText(Node.Text);
      if DestNode <> nil then
      begin
        if DestNode.ImageIndex <> 0 then
        begin
          DestNode.Selected := True;
          if Application.MessageBox('Переместить сюда?', 'Слияние', MB_YESNO) = IDYES then
          begin
            MergeNode;
          end;
        end;
      end
      else
      begin
        PNode := Node.Parent;
        PDestNode := TreeView1.Items.FindNodeWithText(PNode.Text);
        if PDestNode = nil then PDestNode := TreeView1.Items.GetFirstNode;
        DestNode := TreeView1.Items.AddChild(PDestNode, Node.Text);
        DestNode.ImageIndex := Node.ImageIndex;
        MergeNode;
      end;
    end;
    ShowMessage('Готово');
  end;
end;

procedure TMergeConfForm.Button3Click(Sender: TObject);
var
  Doc: TXMLDocument;
  RootNode, Node: TDOMElement;
  S, ProjectFile: string;
  MainNode: TTreeNode;

  procedure WriteTreeNode(XMLNode: TDOMElement; ObjectNode: TTreeNode);
  var
    SubNode, ObjXMLNode, CodeXMLNode, ChNode: TDOMElement;
    PNodeObj: PNodeObject;
  begin
    while ObjectNode <> nil do
    begin
      SubNode := Doc.CreateElement(ObjectNode.Text);
      SubNode['ImageIndex'] := IntToStr(ObjectNode.ImageIndex);
      XMLNode.AppendChild(SubNode);
      if ObjectNode.Data <> nil then
      begin
        PNodeObj := PNodeObject(ObjectNode.Data);
        ObjXMLNode := Doc.CreateElement('Object');
        ObjXMLNode['ClassName'] := PNodeObj^.ObjClassName;
        ObjXMLNode.TextContent := PNodeObj^.Obj;
        SubNode.AppendChild(ObjXMLNode);
        CodeXMLNode := Doc.CreateElement('Code');
        CodeXMLNode.TextContent := PNodeObj^.Code;
        SubNode.AppendChild(CodeXMLNode);
      end;
      if ObjectNode.Count > 0 then
      begin
        ChNode := Doc.CreateElement('Child');
        SubNode.AppendChild(ChNode);
        WriteTreeNode(ChNode, ObjectNode.GetFirstChild);
      end;
      ObjectNode := ObjectNode.GetNextSibling;
    end;
  end;

begin

  if ProjectOption1  <> nil then
  begin
    ProjectFile := '';
    if SaveDialog1.Execute then
        ProjectFile := SaveDialog1.FileName
    else Exit;

    if ProjectFile <> '' then
    begin
      Doc := TXMLDocument.Create;
      try
        RootNode := Doc.CreateElement('CrossEngineApp');
        RootNode['Version'] := '1';
        Doc.AppendChild(RootNode);
        S := ObjToText(ProjectOption1);
        Node := Doc.CreateElement('Options');
        Node.TextContent := S;
        RootNode.AppendChild(Node);
        Node := Doc.CreateElement('Metadata');
        RootNode.AppendChild(Node);
        MainNode := TreeView1.Items.GetFirstNode;
        if MainNode <> nil then
          WriteTreeNode(Node, MainNode);
        WriteXMLFile(Doc, ProjectFile);
      finally
        Doc.Free;
      end;
    end;
  end
  else ShowMessage('Нет открытого проекта');
end;

procedure TMergeConfForm.FormClose(Sender: TObject;
  var CloseAction: TCloseAction);
begin
  CloseAction := caFree;
end;

procedure TMergeConfForm.FormDestroy(Sender: TObject);
begin
  ClearAll;
  MergeConfForm := nil;
end;

procedure TMergeConfForm.FormResize(Sender: TObject);
begin
  Panel4.Width:= (ClientWidth - Panel3.Width) div 2;
end;

procedure TMergeConfForm.TreeView2Expanded(Sender: TObject; Node: TTreeNode);
var
  APath: string;
  EqvNode: TTreeNode;
begin
  APath:= Node.Text;
  while Node.Parent <> nil do
  begin
    Node := Node.Parent;
    APath:= Node.Text + '/' + APath;
  end;
  EqvNode := TreeView1.Items.FindNodeWithTextPath(APath);
  if EqvNode <> nil then EqvNode.Expand(False);
  //Node.Parent;
end;

procedure TMergeConfForm.TreeView2SelectionChanged(Sender: TObject);
var
  EqvNode: TTreeNode;
begin
  if TreeView2.Selected <> nil then
  begin
    EqvNode := TreeView1.Items.FindNodeWithText(TreeView2.Selected.Text);
    if EqvNode <> nil then EqvNode.Selected := True;
  end;
end;

procedure TMergeConfForm.OpenConfig(ATree: TTreeview; FileName: string; var AProjOpt: TProjectOptions);
var
  S, Code, Obj, ObjClassName: string;
  Doc: TXMLDocument;
  RootNode: TDOMElement;
  Node: TDOMNode;
  C: TComponent;
  PNodeObj: PNodeObject;
  MainNode: TTreeNode;
  SL: TStringList;
  Stream: TStream;
  FTP: TFTPSend;
  Prot, User, Pass, Host, Port, Path, Para: string;

const
  ErrorConfigFormat = 'Загрузка конфигурации не удалась. Не известный формат файла';

  procedure ReadMetadata(XMLNode: TDomNode; ObjNode: TTreeNode);
  var
    ANode: TTreeNode;
    XNode: TDOMElement;
    CodeXMLNode, ObjXMLNode, ChXMLNode: TDOMNode;
    IndStr: string;
    N: Integer;
    //ADesObject: TComponent;
    LFMType, LFMComponentName, LFMClassName: string;
  begin

    while XMLNode <> nil do
    begin
      ANode := ATree.Items.AddChild(ObjNode, XMLNode.NodeName);
      if SameText(ANode.Text, 'Main') or SameText(ANode.Text, 'Main_Form') then MainNode := ANode;
      XNode := XMLNode as TDOMElement;
      if XNode.hasAttribute('ImageIndex') then
      begin
        IndStr := XNode.AttribStrings['ImageIndex'];
        N := StrToInt(IndStr);
        ANode.ImageIndex := N;
        ANode.StateIndex := N;
        ANode.SelectedIndex := N;
      end;
      Code := '';
      Obj := '';
      ObjClassName := '';
      CodeXMLNode := XNode.FindNode('Code');
      if CodeXMLNode <> nil then Code := CodeXMLNode.TextContent;
      ObjXMLNode := XNode.FindNode('Object');
      if ObjXMLNode <> nil then
      begin
        Obj := ObjXMLNode.TextContent;
        ObjClassName := TDOMElement(ObjXMLNode).AttribStrings['ClassName'];
      end;
      if (Obj <> '') or (Code <> '') then
      begin
        New(PNodeObj);
        PNodeObj^.ADesignHook := nil;
        PNodeObj^.Obj := Obj;
        PNodeObj^.ObjClassName := ObjClassName;
        PNodeObj^.Code := Code;
        ANode.Data := PNodeObj;
        if Obj <> '' then
        begin
          ReadLFMHeader(Obj, LFMType, LFMComponentName, LFMClassName);
          //if LFMClassName = 'TDataModule' then
          //begin
          //  ADesObject := nil;
          //  AForm := nil;
          //  MergeManager.TextToDesignObj(OBJ, ADesObject, AForm, False);
          //  PNodeObj^.ADesignHook := TDesignerHook(AForm.Designer);
          //  MergeManager.CurrentDesignForm := nil;
          //  AForm.Visible := True;
          //  PNodeObj^.ADesignHook.DesignClose;
          //  Application.ProcessMessages;
          //  AForm.Hide;
          //end;
        end;
      end;
      ChXMLNode := XNode.FindNode('Child');
      if ChXMLNode <> nil then
      begin
        ChXMLNode := ChXMLNode.FirstChild;
        if ChXMLNode <> nil then ReadMetadata(ChXMLNode, ANode);
      end;
      XMLNode := XMLNode.NextSibling;
    end;
  end;
begin
  Stream := nil;
  try
    if Pos('http://', FileName) = 1 then
    begin
      SL := TStringList.Create;
      try
        HttpGetText(FileName, SL);
        Stream := TStringStream.Create(SL.Text);
      finally
        SL.Free;
      end;
    end
    else
    if Pos('ftp://', FileName) = 1 then
    begin
      FTP := TFTPSend.Create;
      try
        ParseURL(FileName, Prot, User, Pass, Host, Port, Path, Para);
        FTP.TargetHost := Host;
        FTP.TargetPort := Port;
        FTP.UserName := User;
        FTP.Password := Pass;
        if FTP.Login then
        begin
          if FTP.RetrieveFile(Path, False) then
          begin
            Stream := TMemoryStream.Create;
            FTP.DataStream.Seek(0, soFromBeginning);
            Stream.CopyFrom(FTP.DataStream, FTP.DataStream.Size);
            Stream.Seek(0, soFromBeginning);
          end;
          FTP.Logout;
        end;
      finally
        FTP.Free;
      end;
    end
    else
    begin
      if not FileExists(FileName) then Exception.Create('Файл ' + FileName + ' не найден');
      Stream := TFileStream.Create(FileName, fmOpenRead);
    end;

          Doc := nil;
	  if Stream <> nil then
	  begin
	      try
	        ReadXMLFile(Doc, Stream);
	        RootNode := Doc.DocumentElement;
	        if RootNode.TagName = 'CrossEngineApp' then
	        begin
	          Node := RootNode.FindNode('Options');
	          if Node <> nil then
	          begin
	            S := Node.TextContent;
	            AProjOpt := TProjectOptions.Create(nil);
	            C := AProjOpt;
	            TextToObject(S, C);
	            if AProjOpt.Language = 'DPASCAL' then AProjOpt.Language := ALterLanguage;
	          end
	          else Exception.Create(ErrorConfigFormat);
	          Node := RootNode.FindNode('Metadata');
	          if Node <> nil then
	          begin
	            Node := Node.FirstChild;
	            MainNode := nil;
	            ReadMetadata(Node, nil);
	            ATree.Items.GetFirstNode.Expand(False);
	            if MainNode <> nil then
	            begin
	              if MainNode.HasChildren then MainNode.Expand(False);
	            end;
	          end
	          else Exception.Create(ErrorConfigFormat);
	        end
	        else
	          Exception.Create(ErrorConfigFormat);
	      finally
	        if Doc <> nil then;
	          Doc.Free;
	      end;
	  end;
  finally
    if Stream <> nil then Stream.Free;
  end;
end;

function TMergeConfForm.ObjToText(Instance: Tcomponent): string;
var
  StrStream: TStringStream;
  BinStream: TMemoryStream;
  Writer: TWriter;
  S: string;
begin
  BinStream := TMemoryStream.Create;
  try
    StrStream := TStringStream.Create(s);
    try
      Writer := TWriter.Create(BinStream, 4096);
      try
        Writer.WriteDescendent(Instance, nil);
      finally
        Writer.Free;
      end;
      BinStream.Seek(0, soFromBeginning);
      ObjectBinaryToText(BinStream, StrStream, oteLFM);
      StrStream.Seek(0, soFromBeginning);
      Result:= StrStream.DataString;
    finally
      StrStream.Free;
    end;
  finally
    BinStream.Free;
  end;
end;

procedure TMergeConfForm.TextToObject(S: string; var Root: TComponent);
var
  StrStream:TStringStream;
  BinStream: TMemoryStream;
  Reader: TReader;
begin
  StrStream := TStringStream.Create(s);
  try
    BinStream := TMemoryStream.Create;
    try
          ObjectTextToBinary(StrStream, BinStream);
          BinStream.Seek(0, soFromBeginning);
          Reader := TReader.Create(BinStream, 4096);
          try
            Reader.ReadRootComponent(Root);
          finally
             Reader.Free;
          end;
    finally
      BinStream.Free;
    end;
  finally
    StrStream.Free;
  end;
end;

procedure TMergeConfForm.ClearTreeItems(ATree: TTreeView);
var
  FirstNode: TTreeNode;

  procedure ClearNode(Node: TTreeNode);
  var
    ChNode: TTreeNode;
    PNodeObj: PNodeObject;
  begin
    while Node <> nil do
    begin
      if Node.Data <> nil then
      begin
        PNodeObj:= PNodeObject(Node.Data);
        Dispose(PNodeObj);
        Node.Data := nil;
      end;
      if Node.HasChildren then
      begin
        ChNode := Node.GetFirstChild;
        ClearNode(ChNode);
      end;
      Node := Node.GetNextSibling;
    end;
  end;

begin
  FirstNode := ATree.Items.GetFirstNode;
  if FirstNode <> nil then
  begin
    ClearNode(FirstNode);
    ATree.Items.Clear;
  end;
end;

procedure TMergeConfForm.Clear1;
begin
  ProjectOption1.Free;
  ProjectOption1 := nil;
  ClearTreeItems(TreeView1);
end;

procedure TMergeConfForm.Clear2;
begin
  ProjectOption2.Free;
  ProjectOption2 := nil;
  ClearTreeItems(TreeView2);
end;

procedure TMergeConfForm.ClearAll;
begin
  Clear2;
  Clear1;
end;

end.

