{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit MDialog;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ComCtrls,
  StdCtrls, ActnList, Menus, Buttons, LCLType;

type

  TMDialogStyle = (mdsOpen, mdsSave);

  { TModuleDialog }

  TModuleDialog = class(TForm)
    ActCreateDir: TAction;
    ActDelNode: TAction;
    ActRenameNode: TAction;
    ActionList1: TActionList;
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    ListView1: TListView;
    NCreateDir: TMenuItem;
    NDelete: TMenuItem;
    MenuItem3: TMenuItem;
    NRenameNode: TMenuItem;
    PopupMenu1: TPopupMenu;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    procedure ActCreateDirExecute(Sender: TObject);
    procedure ActDelNodeExecute(Sender: TObject);
    procedure ActionList1Update(AAction: TBasicAction; var Handled: Boolean);
    procedure ActRenameNodeExecute(Sender: TObject);
    procedure Edit1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure FormCreate(Sender: TObject);
    procedure ListView1Edited(Sender: TObject; Item: TListItem;
      var AValue: string);
    procedure ListView1Editing(Sender: TObject; Item: TListItem;
      var AllowEdit: Boolean);
    procedure ListView1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ListView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    FDialogStyle: TMDialogStyle;
    FNodeFolder: TTreeNode;
    procedure SetFileName(Value: string);
    function GetFileName: string;
    procedure SetDialogStyle(Value: TMDialogStyle);
  public
    procedure LoadFileList(Node: TTreeNode);
    function Execute: Boolean;
    property FileName: string read GetFileName write SetFileName;
    property NodeFolder: TTreeNode read FNodeFolder;
    property DialogStyle: TMDialogStyle read FDialogStyle write SetDialogStyle;
  end;

var
  ModuleDialog: TModuleDialog;

implementation

uses ProjectManager;

{$R *.lfm}

{ TModuleDialog }

procedure TModuleDialog.Edit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then ModalResult := mrOk;
end;

procedure TModuleDialog.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  CloseAction := caHide;
end;

procedure TModuleDialog.ActCreateDirExecute(Sender: TObject);
var
  Node: TTreeNode;
  Item: TListItem;
  I, N: Integer;
  S: string;
  B: Boolean;
begin
  I := 1;
  B := False;
  S := '';
  while I < 1000 do
  begin
    S := 'NewFolder' + IntToStr(I);
    N := 0;
    while N < ListView1.Items.Count do
    begin
      if CompareText(ListView1.Items.Item[N].Caption, S) <> 0 then
      begin
        B := True;
        Break;
      end;
      Inc(N);
    end;
    if B then Break;

    Inc(I);
  end;

  Item := ListView1.Items.Add;
  Item.Caption := S;
  Item.ImageIndex := 0;
  Node := ProjManager.TreeObj.Items.AddChild(FNodeFolder, S);
  Node.ImageIndex := 0;
  Node.StateIndex := 0;
  Node.SelectedIndex := 0;
  Item.Data := Node;
end;

procedure TModuleDialog.ActDelNodeExecute(Sender: TObject);
var
  Node: TTreeNode;
begin
  if ListView1.Selected <> nil then
  begin
    if ListView1.Selected.Caption <> '...' then
    begin
      if ListView1.Selected.Data <> nil then
      begin
        if Application.MessageBox(PChar('Удалить ' + ListView1.Selected.Caption + '?'), 'Удаление', MB_YESNO or MB_ICONQUESTION) = IDYES then
        begin
          Node := TTreeNode(ListView1.Selected.Data);
          Node.Free;
          ListView1.Items.Delete(ListView1.ItemIndex);
        end;
      end;
    end;
  end;
end;

procedure TModuleDialog.ActionList1Update(AAction: TBasicAction;
  var Handled: Boolean);
var
  Node: TTreeNode;
begin
  if Action = ActDelNode then
  begin
    ActDelNode.Enabled := True;
    if ListView1.Selected = nil then ActDelNode.Enabled := False
    else
    if ListView1.Selected.Caption = '...' then ActDelNode.Enabled := False
    else
    if ListView1.Selected.Data <> nil then
    begin
      Node := TTreeNode(ListView1.Selected.Data);
      if Node.HasChildren then ActDelNode.Enabled := False;
    end;
  end
  else
  if Action = ActRenameNode then
  begin
    ActRenameNode.Enabled := True;
    if (ListView1.Selected <> nil) and (ListView1.Selected.Data <> nil) then
    begin
      Node := TTreeNode(ListView1.Selected.Data);
      if Node.Data <> nil then ActRenameNode.Enabled := False;
    end;
  end;
end;

procedure TModuleDialog.ActRenameNodeExecute(Sender: TObject);
var
  Node: TTreeNode;
begin
  if ListView1.Selected <> nil then
  begin
    Node := TTreeNode(ListView1.Selected.Data);
    if Node.Data = nil then
      ListView1.Selected.EditCaption;
  end;
end;

procedure TModuleDialog.FormCloseQuery(Sender: TObject; var CanClose: boolean);
var
  s: string;
  I: Integer;
begin
  CanClose := True;
  if (ModalResult = mrOK) and (Edit1.Text = '') then
    CanClose := False
  else
  begin
    s := Trim(Edit1.Text);
    I := LastDelimiter(' ;,:+/|\*&^#@!~''"', s);
    if I <> 0 then
    begin
      Application.MessageBox('Недопустимые символы или пробелы в имени объекта', 'Наименование объекта', MB_OK or MB_ICONEXCLAMATION);
      CanClose := False;
    end;
  end;
end;

procedure TModuleDialog.FormCreate(Sender: TObject);
begin
  FDialogStyle := mdsSave;
end;

procedure TModuleDialog.ListView1Edited(Sender: TObject; Item: TListItem;
  var AValue: string);
var
  Node: TTreeNode;
begin
  if SameText(AValue, 'external') then Raise( Exception.Create('External зарезервировано, использовать нельзя') );

  if Item.Data <> nil then
  begin
    Node := TTreeNode(Item.Data);
    Node.Text := AValue;
  end;
end;

procedure TModuleDialog.ListView1Editing(Sender: TObject; Item: TListItem;
  var AllowEdit: Boolean);
begin
  if ((Item.Caption = '...') or (Item.Caption = 'External')) then AllowEdit := False;
end;

procedure TModuleDialog.ListView1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
  begin
    if ListView1.Selected <> nil then LoadFileList(TTreeNode(ListView1.Selected.Data));
  end;
end;

procedure TModuleDialog.ListView1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Node: TTreeNode;
begin
  if ListView1.Selected <> nil then
  begin
    if ssDouble in Shift then
    begin
      Node := TTreeNode(ListView1.Selected.Data);
      if (Button1.Caption = 'Открыть') and (ListView1.Selected.Caption <> '...') then
      begin
        if Node.HasChildren then LoadFileList(Node)
        else ModalResult := mrOk;
      end
      else
      begin
        LoadFileList(Node);
      end;
    end
    else
    if ListView1.Selected.Caption <> '...' then
    begin
      if ((ListView1.Selected.Data <> nil) and (ssCtrl in Shift)) or (Button1.Caption = 'Открыть') then
      begin
        Node := TTreeNode(ListView1.Selected.Data);
        if Node.Data <> nil then Edit1.Text := ListView1.Selected.Caption;
      end;
    end;
  end;
end;

procedure TModuleDialog.SetFileName(Value: string);
begin
  Edit1.Text := Value;
end;

function TModuleDialog.GetFileName: string;
begin
  Result := Edit1.Text;
end;

procedure TModuleDialog.SetDialogStyle(Value: TMDialogStyle);
begin
  if FDialogStyle <> Value then
  begin
    FDialogStyle := Value;
    if FDialogStyle = mdsSave then
      Button1.Caption := 'Сохранить'
    else
      Button1.Caption := 'Открыть';
  end;
end;

procedure TModuleDialog.LoadFileList(Node: TTreeNode);
var
  Item: TListItem;
  ANode: TTreeNode;
begin
  FNodeFolder := Node;

  ListView1.Clear;
  ANode := ProjManager.TreeObj.Items.GetFirstNode;
  if Node <> ANode then
  begin
    Item := ListView1.Items.Add;
    Item.Data := Node.Parent;
    Item.Caption := '...';
    Item.ImageIndex := 5;
  end;
  ANode := Node.getFirstChild;

  while ANode <> nil do
  begin
    Item := ListView1.Items.Add;
    Item.Data := ANode;
    Item.Caption := ANode.Text;
    Item.ImageIndex := ANode.ImageIndex;
    ANode := ANode.getNextSibling;
  end;
  if ListView1.Items.Count > 0 then ListView1.ItemIndex := 0;
end;

function TModuleDialog.Execute: Boolean;
begin
  Result := False;
  LoadFileList(ProjManager.TreeObj.Items.GetFirstNode);
  if ShowModal = mrOK then Result := True;
end;

end.

