{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}

unit Main;

{$mode objfpc}{$H+}

interface

{$I SetComponent.inc}

uses
  Classes, SysUtils, FileUtil, UTF8Process, Forms, Controls, Graphics, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, ActnList, Buttons, FormDesig, ObjectInspector,
  TypInfo, PropEdits, Menus, Editor, AppConst, ComponentEditors, LResources,
  ObjInspStrConsts, synhighlighterpas, ProjectManager, LCLType, process,
  simpleipc, dpCompil, dpi_mettyps, dpUtils, XMLCyrDecode, XMLConf,
  dpCompilmsg, variants,lrAddFunctionLibrary;

type

  { TMainIDEDesForm }

  TMainIDEDesForm = class(TForm)
    ActChangeFormModule: TAction;
    ActInsertFrame: TAction;
    ActCloseAll: TAction;
    ActDebugTerminate: TAction;
    ActAboutBox: TAction;
    ActEnvOptions: TAction;
    ActFindInModules: TAction;
    ActCloseEditorPage: TAction;
    ActShowImportTypes: TAction;
    ActShowImportObject: TAction;
    ActShowImportConst: TAction;
    ActSaveModuleAsExternal: TAction;
    ActSaveAndCompile: TAction;
    ActShowImportClass: TAction;
    ActMergeApp: TAction;
    ActShowAllMethods: TAction;
    ActLazTypeAnalize: TAction;
    ActSetShift: TAction;
    ActVewProjManager: TAction;
    ActVewInspector: TAction;
    ActLoadFromUrl: TAction;
    ActRunTrace: TAction;
    ActNewModule: TAction;
    ActRedo: TAction;
    ActUndo: TAction;
    ActMasterForm: TAction;
    ActSaveIDEElements: TAction;
    ActUseUnitSrv: TAction;
    ActSaveProjectAs: TAction;
    ActSaveModuleAs: TAction;
    ActNewSurProject: TAction;
    ActRun: TAction;
    ActProjOptions: TAction;
    ActOpenProject: TAction;
    ActSaveProject: TAction;
    ActSaveModule: TAction;
    ActNewPasProject: TAction;
    ActNewFrame: TAction;
    ActLoadModuleFromFile: TAction;
    ActSaveInFile: TAction;
    ActNewDM: TAction;
    ActNewForm: TAction;
    ActionList1: TActionList;
    DManager: TDesignerManager;
    ImageList1: TImageList;
    MiddleImage: TImageList;
    LageImages: TImageList;
    MainImages: TImageList;
    MainMenu1: TMainMenu;
    MenuItem1: TMenuItem;
    MenuItem10: TMenuItem;
    MenuItem11: TMenuItem;
    MenuItem12: TMenuItem;
    MenuItem13: TMenuItem;
    MenuItem14: TMenuItem;
    MenuItem15: TMenuItem;
    MenuItem16: TMenuItem;
    MenuItem17: TMenuItem;
    MenuItem18: TMenuItem;
    MenuItem19: TMenuItem;
    MenuItem20: TMenuItem;
    MenuItem21: TMenuItem;
    MenuItem22: TMenuItem;
    MenuItem23: TMenuItem;
    MenuItem24: TMenuItem;
    MenuItem25: TMenuItem;
    MenuItem26: TMenuItem;
    MenuItem27: TMenuItem;
    MenuItem28: TMenuItem;
    MenuItem29: TMenuItem;
    MenuItem30: TMenuItem;
    MenuItem31: TMenuItem;
    MenuItem32: TMenuItem;
    MenuItem33: TMenuItem;
    MenuItem34: TMenuItem;
    MenuItem35: TMenuItem;
    MenuItem36: TMenuItem;
    MenuItem37: TMenuItem;
    MenuItem38: TMenuItem;
    MenuItem39: TMenuItem;
    MenuItem40: TMenuItem;
    MenuItem41: TMenuItem;
    MenuItem42: TMenuItem;
    MenuItem43: TMenuItem;
    MenuItem44: TMenuItem;
    MenuItem45: TMenuItem;
    MenuItem46: TMenuItem;
    MenuItem47: TMenuItem;
    MenuItem48: TMenuItem;
    MenuItem49: TMenuItem;
    MenuItem50: TMenuItem;
    MenuItem51: TMenuItem;
    MenuItem52: TMenuItem;
    MenuItem53: TMenuItem;
    MenuItem54: TMenuItem;
    MenuItem8: TMenuItem;
    NLastFiles: TMenuItem;
    PageControl1: TPageControl;
    Panel1: TPanel;
    Panel2: TPanel;
    Process1: TProcessUTF8;
    SaveProject: TMenuItem;
    MenuItem6: TMenuItem;
    NSaveModule: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem7: TMenuItem;
    MenuItem9: TMenuItem;
    NPasProject: TMenuItem;
    NNewPoject: TMenuItem;
    NNewDM: TMenuItem;
    NNewForm: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    DebugClient: TSimpleIPCClient;
    DebugServer: TSimpleIPCServer;
    SynPasSyn1: TSynPasSyn;
    SynPasSyn2: TSynPasSyn;
    ToolBar1: TToolBar;
    ToolBar2: TToolBar;
    ToolButton1: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    ToolButton14: TToolButton;
    ToolButton15: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    procedure ActAboutBoxExecute(Sender: TObject);
    procedure ActChangeFormModuleExecute(Sender: TObject);
    procedure ActCloseAllExecute(Sender: TObject);
    procedure ActCloseEditorPageExecute(Sender: TObject);
    procedure ActCloseEditorPageUpdate(Sender: TObject);
    procedure ActDebugTerminateExecute(Sender: TObject);
    procedure ActDebugTerminateUpdate(Sender: TObject);
    procedure ActEnvOptionsExecute(Sender: TObject);
    procedure ActFindInModulesExecute(Sender: TObject);
    procedure ActFindInModulesUpdate(Sender: TObject);
    procedure ActInsertFrameExecute(Sender: TObject);
    procedure ActLazTypeAnalizeExecute(Sender: TObject);
    procedure ActLoadFromUrlExecute(Sender: TObject);
    procedure ActLoadModuleFromFileExecute(Sender: TObject);
    procedure ActMasterFormExecute(Sender: TObject);
    procedure ActMergeAppExecute(Sender: TObject);
    procedure ActNewDMExecute(Sender: TObject);
    procedure ActNewFormExecute(Sender: TObject);
    procedure ActNewFrameExecute(Sender: TObject);
    procedure ActNewModuleExecute(Sender: TObject);
    procedure ActNewPasProjectExecute(Sender: TObject);
    procedure ActNewSurProjectExecute(Sender: TObject);
    procedure ActOpenProjectExecute(Sender: TObject);
    procedure ActProjOptionsExecute(Sender: TObject);
    procedure ActProjOptionsUpdate(Sender: TObject);
    procedure ActRedoExecute(Sender: TObject);
    procedure ActRedoUpdate(Sender: TObject);
    procedure ActRunExecute(Sender: TObject);
    procedure ActRunTraceExecute(Sender: TObject);
    procedure ActSaveAndCompileExecute(Sender: TObject);
    procedure ActSaveIDEElementsExecute(Sender: TObject);
    procedure ActSaveInFileExecute(Sender: TObject);
    procedure ActSaveModuleAsExecute(Sender: TObject);
    procedure ActSaveModuleAsExternalExecute(Sender: TObject);
    procedure ActSaveModuleAsUpdate(Sender: TObject);
    procedure ActSaveModuleExecute(Sender: TObject);
    procedure ActSaveModuleUpdate(Sender: TObject);
    procedure ActSaveProjectAsExecute(Sender: TObject);
    procedure ActSaveProjectExecute(Sender: TObject);
    procedure ActSetShiftExecute(Sender: TObject);
    procedure ActShowAllMethodsExecute(Sender: TObject);
    procedure ActShowImportClassExecute(Sender: TObject);
    procedure ActShowImportConstExecute(Sender: TObject);
    procedure ActShowImportObjectExecute(Sender: TObject);
    procedure ActShowImportTypesExecute(Sender: TObject);
    procedure ActUndoExecute(Sender: TObject);
    procedure ActUndoUpdate(Sender: TObject);
    procedure ActUseUnitSrvExecute(Sender: TObject);
    procedure ActVewInspectorExecute(Sender: TObject);
    procedure ActVewProjManagerExecute(Sender: TObject);
    procedure CompilAddMethod(AddMethod: TAddMethodProc);
    procedure DebugServerMessageQueued(Sender: TObject);
    procedure DebugServerMessage(Sender: TObject);
    procedure DManagerAfterAddComponent(AComponent, ARoot: TComponent);
    procedure DManagerDeleteComponent(AComponent, ARoot: TComponent);
    procedure DManagerFormActivate(ARoot: TComponent; AForm: TCustomForm);
    function DManagerGetClassResurce(AClassName: string): string;
    function DManagerGetComponentClass(AClassName: string): TComponentClass;
    procedure DManagerGetIcon(Source: TComponent; var Bmp: Graphics.TBitmap);
    function DManagerGetReadOnly(Sender: TComponent): Boolean;
    function DManagerIsIdeSysKey(Key: Word): Boolean;
    function DManagerIsObjNameExist(AName: string): Boolean;
    function DManagerIsVisualComponent(AComponent: TComponent): Boolean;
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure OnAddConst(AddConst: TAddConstProc);
    procedure OnScriptMessage(AMessage: TDpString);
    procedure OnScriptError(AMessage: TDpCompilerMessage);
    procedure PageControl1Change(Sender: TObject);

    function Call_GetSumProp(Instence: TObject; var Params: Variant): Variant;
    function Call_GetEngineVersion(Instence: TObject; var Params: Variant): Variant;
    function Call_CheckEngineVersion(Instence: TObject; var Params: Variant): Variant;
    function Call_DebugValue(Instence: TObject; var Params: Variant): Variant;
  private
    FActivePanel: TPanel;
    procedure CompButtonDown(Sender: TObject);
    function NewUnitCode(AUnitName: string; AComponent: TComponent; Lang: string): string;
    function GetNewUnitName: string;
    procedure MethodTypeDataToStr(TypeData: PTypeData; AMethodName,
          ARootName: string; var DeclStr, ImplStr: string);
    procedure CompoenentRenamed(AComponent: TComponent);
    procedure CompilAddScriptObj(AddObject: TAddObjectProc);
    procedure CompilAddImporters(AddImporter: TAddImporterProc);
    procedure EmbCompilMsg(AMessage: string);
    procedure OnMessageQueued(Sender: TObject);
    function GetProcDeclaration(Proc: TSuProc): string;
  protected
    procedure SetIntfImageList(ImageList: TImageList);
  public
    LastActiveForm: TCustomForm;
    Inspector: TObjectInspectorDlg;
    OldComponentName: string;
    NewComponentName: string;
    AppDir: string;
    SettingDir: string;
    EditorDefPos: TRect;
    UserDir: string;
    BreakPointList: TStringList;
    RegList: TList;
    EVarList: TStringList;
    procedure ShowDesignForm;
    procedure HistoryMenuClick(Sender: TObject);
    procedure UpdateHistoryMenu;
    function DefaultLanguage: string;
    function UnitExist(AUnitName: string): Boolean;
    function GetUnitSource(AUnitName: TDpString): TDpString;
    procedure RegComp(PanelName: string; AClass: TComponentClass);
    procedure ResetComponentButton;
    procedure GetComponentNames(TypeData:PTypeData; Proc: TGetStrProc);
    function GetComponent(const ComponentPath: String):TComponent;
    procedure SaveModule(PM: TPageModule);
    procedure NewForm(IsMain: Boolean);
    function CreateMethod(const AName: ShortString; ATypeInfo: PTypeInfo;
      APersistent: TPersistent; const APropertyPath: string): TMethod;
    procedure ShowMethod(const AName: String);
    function GetMethodName(const Method: TMethod; CheckOwner: TObject; OrigLookupRoot: TPersistent): String;
    procedure GetCompMethods(InstProp: PInstProp; const Proc: TGetStrProc);
    function MethodFromLookupRoot(const Method:TMethod):boolean;
    procedure AddBreakPoint(S: string);
    procedure DelBreakPoint(S: string);
    function MethodExists(const AName: String; InstProp: PInstProp;
      var MethodIsCompatible,MethodIsPublished,IdentIsMethod: boolean):boolean;

    procedure GetSelection(const ASelection: TPersistentSelectionList);
    procedure ReadInterfaceConfig;
    procedure OnChangeSelection(Sender: TObject);
    procedure OnInpectorPropertyModified(Sender: TObject);
    procedure OnInpectorEventModified(Sender: TObject);
    procedure PropHookSetSelection(const ASelection: TPersistentSelectionList);
    procedure OnInitIDEFileDialog(AFileDialog: TFileDialog);
    procedure OnStoreIDEFileDialog(AFileDialog: TFileDialog);
    procedure OnAppExeption(Sender: TObject; E: Exception);
  end;

  TComponentButton = class(TSpeedButton)
  public
    ComponentClass: TComponentClass;
  end;

  TMyComponentNamePropertyEditor = class(TStringPropertyEditor)
  public
    function GetAttributes: TPropertyAttributes; override;
    function GetEditLimit: Integer; override;
    function GetValue: ansistring; override;
    procedure SetValue(const NewValue: ansistring); override;
  end;

//procedure RegComponent(PanelName: string; AClass: TComponentClass);

var
  MainIDEDesForm: TMainIDEDesForm;

implementation

{$R *.lfm}
{$R laz_images.res}
//{$R lr_cairo_icon.res}

uses
  ComponentExport, SuFrame, RegCompEditors, dpRTTIutils, SrvUsesUnits,
  {$IFDEF IBX}IBCustomDataSet, IBDatabase, IB,{$ENDIF}
  SrvMastForm, XDBGrids, db, FrameListFrm, Translations, IDEDialogs, AbtBox,
  Toolwin, EnvOptions, SynEditHighlighter, CodeUtils, InfoFormUnit, LazUTF8,
  dpInfo, MergeConf, FindInModules, LangTransCode, dpi_parser, expandenvvar,
  LazFileUtils;

{procedure RegComponent(PanelName: string; AClass: TComponentClass);
begin
  MainIDEDesForm.RegComp(PanelName, AClass);
end;}

{ TMainIDEDesForm }

procedure ConvetToUTF8LocalConst;
var
  i:integer;
begin
  DefaultFormatSettings.ShortMonthNames[1]:='Январь';
  DefaultFormatSettings.ShortMonthNames[2]:='Февраль';
  DefaultFormatSettings.ShortMonthNames[3]:='Март';
  DefaultFormatSettings.ShortMonthNames[4]:='Апрель';
  DefaultFormatSettings.ShortMonthNames[5]:='Май';
  DefaultFormatSettings.ShortMonthNames[6]:='Июнь';
  DefaultFormatSettings.ShortMonthNames[7]:='Июль';
  DefaultFormatSettings.ShortMonthNames[8]:='Август';
  DefaultFormatSettings.ShortMonthNames[9]:='Сентябрь';
  DefaultFormatSettings.ShortMonthNames[10]:='Октябрь';
  DefaultFormatSettings.ShortMonthNames[11]:='Ноябрь';
  DefaultFormatSettings.ShortMonthNames[12]:='Декабрь';

  for i:=1 to 12 do
    DefaultFormatSettings.LongMonthNames[i] := DefaultFormatSettings.ShortMonthNames[i];

  DefaultFormatSettings.LongDayNames[1]:='Воскресенье';
  DefaultFormatSettings.LongDayNames[2]:='Понедельник';
  DefaultFormatSettings.LongDayNames[3]:='Вторник';
  DefaultFormatSettings.LongDayNames[4]:='Среда';
  DefaultFormatSettings.LongDayNames[5]:='Четверг';
  DefaultFormatSettings.LongDayNames[6]:='Пятница';
  DefaultFormatSettings.LongDayNames[7]:='Суббота';

  DefaultFormatSettings.ShortDayNames[1]:='Вс';
  DefaultFormatSettings.ShortDayNames[2]:='Пн';
  DefaultFormatSettings.ShortDayNames[3]:='Вт';
  DefaultFormatSettings.ShortDayNames[4]:='Ср';
  DefaultFormatSettings.ShortDayNames[5]:='Чт';
  DefaultFormatSettings.ShortDayNames[6]:='Пт';
  DefaultFormatSettings.ShortDayNames[7]:='Сб';
end;

procedure InitLocale;
begin
  DefaultFormatSettings.LongDateFormat:='dd.mm.yyyy';
  DefaultFormatSettings.ShortDateFormat:=DefaultFormatSettings.LongDateFormat;
  DefaultFormatSettings.DateSeparator:='.';
  DefaultFormatSettings.TimeSeparator:=':';
  DefaultFormatSettings.ThousandSeparator:=' ';
  DefaultFormatSettings.CurrencyString:='р.';

  ConvetToUTF8LocalConst;
end;


{ TComponentNamePropertyEditor }

function FindComponentProc(const AName: string): TComponent;
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to MainIDEDesForm.DManager.DesignCount - 1 do
  begin
    if SameText(MainIDEDesForm.DManager.ItemsRoot[I].Name, AName) then
    begin
      Result := MainIDEDesForm.DManager.ItemsRoot[I];
      Break;
    end;
  end;
end;

function TMyComponentNamePropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [];
end;

function TMyComponentNamePropertyEditor.GetEditLimit: Integer;
begin
  Result := MaxIdentLength;
end;

function TMyComponentNamePropertyEditor.GetValue: ansistring;
begin
  Result:=inherited GetValue;
end;

procedure TMyComponentNamePropertyEditor.SetValue(const NewValue: ansistring);
var
  AComponent: TComponent;

  function IsAValidIdent(const Ident: string; AllowDots: Boolean = False; StrictDots: Boolean = False): Boolean;
  const
    Alpha = ['A'..'Z', 'a'..'z', '_', #128..#255];
    AlphaNum = Alpha + ['0'..'9'];
    Dot = '.';
  var
    First: Boolean;
    I, Len: Integer;
    AIdent: string;
  begin
    AIdent := dp_UTF8ToAnsi(Ident);
    Len := Length(AIdent);
    if Len < 1 then
      Exit(False);
    First := True;
    for I := 1 to Len do
    begin
      if First then
      begin
        Result := AIdent[I] in Alpha;
        First := False;
      end
      else if AllowDots and (AIdent[I] = Dot) then
      begin
        if StrictDots then
        begin
          Result := I < Len;
          First := True;
        end;
      end
      else
        Result := AIdent[I] in AlphaNum;
      if not Result then
        Break;
    end;
  end;

begin
  if (not IsAValidIdent(NewValue)) or (NewValue='') then
    raise Exception.Create(Format(oisComponentNameIsNotAValidIdentifier, ['"',
      NewValue, '"']));
  AComponent := TComponent(GetComponent(0));
  MainIDEDesForm.OldComponentName := AComponent.Name;
  MainIDEDesForm.NewComponentName := NewValue;
  inherited SetValue(NewValue);
  PropertyHook.ComponentRenamed(AComponent);
end;


procedure TMainIDEDesForm.FormCreate(Sender: TObject);
var
  GUID: TGuid;
  VI: Integer;
  aName, aValue: string;
  SL: TStringList;
begin

  InitLocale;
  Application.UpdateFormatSettings := False;
  UserDir := GetUserDir;


  AppDir := ExtractFilePath(Application.ExeName);
  {$ifdef PORTABLEVERS}
  SettingDir:= AppDir;
  {$else}
    {$IfDef UNIX}
      SettingDir:= UserDir + '.DieselPascal' + DirectorySeparator;
    {$Else}
      SettingDir:= UserDir + 'DieselPascal' + DirectorySeparator;
    {$EndIf}
  {$EndIf}

  SetVersion(Application.ExeName, AppVersion, VMajor, VMinor, VRevision);


  EVarList := TStringList.Create;

  SL := TStringList.Create;
  try

    if FileExists(AppDir + 'evars.cfg') then
    begin
      SL.LoadFromFile(AppDir + 'evars.cfg');

      for VI := 0 to SL.Count - 1 do
      begin
        SL.GetNameValue(VI, aName, aValue);
        expandenvvar.SetEnvironmentVariable(UTF8UpperCase(aName), aValue);
        EVarList.Add(SL.Strings[VI]);
      end;
    end;

    if FileExists(SettingDir + 'evars.cfg') then
    begin
      SL.LoadFromFile(SettingDir + 'evars.cfg');
      for VI := 0 to SL.Count - 1 do
      begin
        SL.GetNameValue(VI, aName, aValue);
        expandenvvar.SetEnvironmentVariable(UTF8UpperCase(aName), aValue);
        EVarList.Add(SL.Strings[VI]);
      end;
    end;

  finally
    SL.Free;
  end;

  RegList := TList.Create;

  {$IFDEF UNIX}
    EditorDefaultFontName := 'DejaVu Sans Mono';
  {$Else}
    EditorDefaultFontName := 'Courier New';
  {$EndIf}
  EditorDefaultFontSize := 10;
  //FPrjOpt.SetEnveronmentVariable('DIESEL_SCRIPT_NAME', ConfigFile);
  expandenvvar.SetEnvironmentVariable('DIESEL_EXE_DIR', AppDir);
  //FPrjOpt.SetEnveronmentVariable('DIESEL_SCRIPT_DIR', ExtractFilePath(ConfigFile));
  expandenvvar.SetEnvironmentVariable('DIESEL_EXE_PID', IntToStr(GetProcessID));
  expandenvvar.SetEnvironmentVariable('DIESEL_LOCALSET_DIR', SettingDir);

  Top := 0;
  Left := 0;
  Width:= Screen.Width - BorderWidth * 2 - 14;
  Inspector := TObjectInspectorDlg.Create(Self);
  //Inspector.ShowComponentTree := False;
  Inspector.PropertyGrid.BackgroundColor := clWhite;
  Inspector.PropertyGrid.DefaultValueFont.Color := clNavy;
  Inspector.EventGrid.BackgroundColor := clWhite;
  Inspector.EventGrid.DefaultValueFont.Color := clNavy;
  Inspector.PropertyGrid.CheckboxForBoolean := True;
  Inspector.PropertyGrid.HighlightFont.Color := clWindowText;
  Inspector.ShowInfoBox := False;
  //Inspector.AvailPersistentComboBox.Visible:= True;
  Inspector.Show;
  FActivePanel := nil;
  RegComponent(@RegComp);
  RegisterPropEditors;
  RegisterComponentsEditors;
  DManager.ObjInspector := Inspector;
  DManager.PropEditHook.AddHandlerGetComponentNames(@GetComponentNames);
  DManager.PropEditHook.AddHandlerGetComponent(@GetComponent);
  DManager.PropEditHook.AddHandlerCreateMethod(@CreateMethod);
  DManager.PropEditHook.AddHandlerGetMethodName(@GetMethodName);
  DManager.PropEditHook.AddHandlerShowMethod(@ShowMethod);
  DManager.PropEditHook.AddHandlerGetCompatibleMethods(@GetCompMethods);
  DManager.PropEditHook.AddHandlerCompatibleMethodExists(@MethodExists);
  DManager.PropEditHook.AddHandlerMethodFromLookupRoot(@MethodFromLookupRoot);
  DManager.PropEditHook.AddHandlerComponentRenamed(@CompoenentRenamed);
  DManager.PropEditHook.AddHandlerSetSelection(@PropHookSetSelection);
  DManager.PropEditHook.AddHandlerGetSelection(@GetSelection);
  Inspector.OnSelectPersistentsInOI := @OnChangeSelection;
  Inspector.PropertyGrid.OnModified := @OnInpectorPropertyModified;
  Inspector.EventGrid.OnModified := @OnInpectorEventModified;
  {Classes.RegisterClass(TSuFrame);
  Classes.RegisterClass(TMenuItem);}
  RegisterFindGlobalComponentProc(@FindComponentProc);
  RegisterPropertyEditor(TypeInfo(AnsiString), TComponent, 'Name', TMyComponentNamePropertyEditor);
  ProjManager := TProjectManagerForm.Create(Self);
  Compil := TDpCompiler.Create(Self);
  Compil.UseTranscription := True;
  Compil.OnGetUnitSource := @GetUnitSource;
  Compil.OnAddObject := @CompilAddScriptObj;
  Compil.OnAddClassImporter:= @CompilAddImporters;
  Compil.OnAddConst:=@OnAddConst;
  Compil.OnAddMethod:=@CompilAddMethod;
  Compil.Compile;
  BreakPointList := TStringList.Create;
  InitIDEFileDialog := @OnInitIDEFileDialog;
  StoreIDEFileDialog := @OnStoreIDEFileDialog;
  Application.OnException := @OnAppExeption;
  CreateGUID(GUID);
  DebugServer.ServerID:= GUIDToString(GUID);
  {$IFDEF WINDOWS}
  DebugServer.Threaded := False;
  DebugServer.SynchronizeEvents := False;
  {$ENDIF}
  DebugServer.StartServer;
end;

procedure TMainIDEDesForm.FormDestroy(Sender: TObject);
begin
  RegList.Free;
  EVarList.Free;
  DManager.PropEditHook.RemoveHandlerGetComponentNames(@GetComponentNames);
  DManager.PropEditHook.RemoveHandlerGetComponent(@GetComponent);
  DManager.PropEditHook.RemoveHandlerCreateMethod(@CreateMethod);
  DManager.PropEditHook.RemoveHandlerGetMethodName(@GetMethodName);
  DManager.PropEditHook.RemoveHandlerShowMethod(@ShowMethod);
  DManager.PropEditHook.RemoveHandlerGetCompatibleMethods(@GetCompMethods);
  DManager.PropEditHook.RemoveHandlerCompatibleMethodExists(@MethodExists);
  DManager.PropEditHook.RemoveHandlerComponentRenamed(@CompoenentRenamed);
  DManager.PropEditHook.RemoveHandlerSetSelection(@PropHookSetSelection);
  DManager.PropEditHook.RemoveHandlerGetSelection(@GetSelection);
  Process1.CloseInput;
  Process1.CloseOutput;
  Process1.CloseStderr;
  Process1.Active := False;
  BreakPointList.Free;
  Inspector.Free;
  Inspector := nil;
  Process1.Free;
  Process1 := nil;
  Compil.Reset;
  Compil.Free;
  Compil := nil;
  {$IFDEF WINDOWS}
  while not Application.Terminated do
  begin
    Application.ProcessMessages;
    Application.Terminate;
  end;
  {$ENDIF}


end;

procedure TMainIDEDesForm.ActNewFormExecute(Sender: TObject);
begin
  NewForm(False);
end;

procedure TMainIDEDesForm.ActNewFrameExecute(Sender: TObject);
var
  Frame: TFrame;
  Form: TCustomForm;
  S, UName, Lang: string;
  PM: TPageModule;
begin
  if EditorForm = nil then CreateEditor;
  DManager.NewFrame(Frame, Form);
  UName := GetNewUnitName;
  Lang := DefaultLanguage;
  S := NewUnitCode(UName, Frame, Lang);
  PM := EditorForm.NewModule(Frame, Form, UName, S, Lang);
  PM.Modified := True;
  if not EditorForm.Active then EditorForm.Show;

  Form.Show;
end;

procedure TMainIDEDesForm.ActNewModuleExecute(Sender: TObject);
var
  S, UName, Lang: string;
  PM: TPageModule;
begin
  if EditorForm = nil then CreateEditor;
  UName := GetNewUnitName;
  Lang := DefaultLanguage;
  S := NewUnitCode(UName, nil, Lang);
  PM := EditorForm.NewModule(nil, nil, UName, S, Lang);
  PM.Modified := True;
  if not EditorForm.Active then EditorForm.Show;
end;

procedure TMainIDEDesForm.ActNewPasProjectExecute(Sender: TObject);
begin
  ProjManager.NewProject(BaseLanguage);
end;

procedure TMainIDEDesForm.ActNewSurProjectExecute(Sender: TObject);
begin
  ProjManager.NewProject(ALterLanguage);
end;

procedure TMainIDEDesForm.ActOpenProjectExecute(Sender: TObject);
begin
  ProjManager.LoadProject(False);
end;

procedure TMainIDEDesForm.ActProjOptionsExecute(Sender: TObject);
begin
  ProjManager.ProjectOptionsFormShow;
end;

procedure TMainIDEDesForm.ActProjOptionsUpdate(Sender: TObject);
begin
  TAction(Sender).Enabled := ProjManager.ProjectExist;
end;

procedure TMainIDEDesForm.ActRedoExecute(Sender: TObject);
begin
  if EditorForm <> nil then
  begin
    if EditorForm.ActivePageModule <> nil then
    begin
      if EditorForm.ActivePageModule.SynEdit.CanRedo then
        EditorForm.ActivePageModule.SynEdit.Redo;
    end;
  end;
end;

procedure TMainIDEDesForm.ActRedoUpdate(Sender: TObject);
begin
  if EditorForm = nil then
    ActRedo.Enabled := False
  else
  begin
    if EditorForm.ActivePageModule <> nil then
    begin
      ActRedo.Enabled := EditorForm.ActivePageModule.SynEdit.CanRedo;
    end
    else
      ActRedo.Enabled := False;
  end;
end;

procedure TMainIDEDesForm.ActRunExecute(Sender: TObject);
var
  AConfig, S: string;
  I: Integer;
  FlExist, UseFtp, UseHttp: Boolean;
  SL: TStringList;
begin
  if Process1.Running then
  begin
    if DebugClient.Active then
    begin
      EditorForm.HideExecMark;
      DebugClient.SendStringMessage('9:');
    end;
  end
  else
  begin
    if ProjManager.ProjectExist then
    begin
      UseFtp := False;
      UseHttp := False;

      if ProjManager.ProjectFile <> '' then
      begin
        FlExist := False;
        if (Pos('http://', ProjManager.ProjectFile) = 1) or (Pos('https://', ProjManager.ProjectFile) = 1) then
        begin
          FlExist:= True;
          UseHttp := True;
        end
        else
        if Pos('ftp://', ProjManager.ProjectFile) = 1 then
        begin
          FlExist:= True;
          UseFtp := True;
        end
        else
          FlExist := FileExists(ProjManager.ProjectFile);
      end;

      if (not UseFtp and not UseHttp) or (ProjManager.ProjectModified) then ProjManager.SaveProject;

      AConfig := '';
      if ProjManager.ProjectFile <> '' then
      begin
        if FlExist then
        begin
          AConfig := ProjManager.ProjectFile;
          if EditorForm = nil then CreateEditor;
          if DebugClient.Active then DebugClient.Disconnect;
          if not DebugServer.Active then DebugServer.StartServer(True);
          EditorForm.ListBox1.Clear;
          Process1.Parameters.Clear;
          S := AppDir;
          Process1.CurrentDirectory := S;
          Process1.Executable := S + 'CrossMachine';
          Process1.Parameters.Add(AConfig);
          Process1.Parameters.Add('D');
          Process1.Parameters.Add(DebugServer.ServerID);
          SL := TStringList.Create;
          try
            SL.Delimiter := ' ';
            SL.DelimitedText := ProjManager.ProjectOption.StartParametrs;
            for I := 0 to SL.Count - 1 do
              Process1.Parameters.Add(SL.Strings[I]);
          finally
            SL.Free;
          end;

          Process1.Execute;
        end;
      end;

    end;

  end;
end;

procedure TMainIDEDesForm.ActRunTraceExecute(Sender: TObject);
var
  AConfig: string;
  I: Integer;
  FlExist: Boolean;
begin
  if Process1.Running then
  begin
    if DebugClient.Active then
          DebugClient.SendStringMessage('8:');
  end
  else
  begin
    if ProjManager.ProjectExist then
    begin
      if ProjManager.ProjectModified then
      begin
        I := Application.MessageBox('Записать изменения?', '', MB_YESNOCANCEL or MB_ICONQUESTION);
        case I of
          IDYES: ProjManager.SaveProject;
          IDCANCEL: Exit;
        end;
      end;
      AConfig := '';
      if ProjManager.ProjectFile <> '' then
      begin
        if Pos('http://', ProjManager.ProjectFile) = 1 then
          FlExist:= True
        else
        if Pos('ftp://', ProjManager.ProjectFile) = 1 then
          FlExist:= True
        else
          FlExist:= FileExists(ProjManager.ProjectFile);

        if FlExist then
        begin
          if DebugClient.Active then DebugClient.Disconnect;
          if not DebugServer.Active then DebugServer.StartServer(True);
          AConfig := ProjManager.ProjectFile;
          if EditorForm = nil then CreateEditor;
          EditorForm.ListBox1.Clear;
          Process1.Parameters.Clear;
          Process1.Executable := 'CrossMachine';
          Process1.Parameters.Add(AConfig);
          Process1.Parameters.Add('T');
          Process1.Parameters.Add(DebugServer.ServerID);
          Process1.Execute;
        end;
      end;
    end;
  end;
end;

procedure TMainIDEDesForm.ActSaveAndCompileExecute(Sender: TObject);
var
  TempCompil: TDpCompiler;
  I: Integer;

  procedure CheckUseUnit(ANode: TTreeNode);
  var
    ChNode: TTreeNode;
  begin
    while ANode <> nil do
    begin
      if ANode.Data <> nil then
      begin
        if PNodeObject(ANode.Data)^.UseUnit = False then
          OnScriptMessage('Модуль ' + ANode.Text + ' ни где не используется');
      end;
      ChNode := ANode.GetFirstChild;
      if ChNode <> nil then CheckUseUnit(ChNode);

      ANode := ANode.GetNextSibling;
    end;
  end;

begin
  if ProjManager.ProjectExist then
  begin
    ProjManager.SaveProject(False);
  end;

  if not ProjManager.ProjectModified then
  begin
    TempCompil := TDpCompiler.Create(Self);
    try
      ProjManager.ClearUseUnit;

      TempCompil.SuLanguage := slPascal;
      if ProjManager.ProjectOption.Language = 'DPASCAL' then
         TempCompil.SuLanguage := slPPlus;
      TempCompil.OnGetUnitSource := @GetUnitSource;
      TempCompil.OnAddObject := @CompilAddScriptObj;
      TempCompil.OnAddClassImporter:= @CompilAddImporters;
      TempCompil.OnAddConst:=@OnAddConst;
      TempCompil.OnAddMethod:=@CompilAddMethod;
      TempCompil.OnError := @OnScriptError;
      TempCompil.OnCompilerMessage:=@OnScriptMessage;
      TempCompil.UseTranscription := True;

      TempCompil.Reset;
      EditorForm.ListBox1.Clear;

      if TempCompil.Compile then
        CheckUseUnit(ProjManager.TreeObj.Items.GetFirstNode);
    finally
      TempCompil.Free;
    end;
  end;
end;

procedure TMainIDEDesForm.ActSaveIDEElementsExecute(Sender: TObject);
var
  S: string;
  XMLConfig1: TXMLConfig;
begin
   S := SettingDir;
   if not DirectoryExists(S) then
   begin
     if not CreateDir(S) then
     begin
       ShowMessage('Can''not create dir ' + S);
       Exit;
     end;
   end;
   S := S + 'EnvOptions.xml';
   XMLConfig1 := TXMLConfig.Create(nil);
   try
     XMLConfig1.Filename := S;
     XMLConfig1.OpenKey('IDE/Main');
     XMLConfig1.SetValue('Left', Left);
     XMLConfig1.SetValue('Top', Top);
     XMLConfig1.SetValue('Width', Width);
     XMLConfig1.SetValue('Height', Height);
     XMLConfig1.CloseKey;

     XMLConfig1.OpenKey('IDE/Inpector');
     XMLConfig1.SetValue('Left', Inspector.Left);
     XMLConfig1.SetValue('Top', Inspector.Top);
     XMLConfig1.SetValue('Width', Inspector.Width);
     XMLConfig1.SetValue('Height', Inspector.Height);
     XMLConfig1.CloseKey;

     if EditorForm <> nil then
     begin
       EditorDefPos.Left := EditorForm.Left;
       EditorDefPos.Top := EditorForm.Top;
       EditorDefPos.Right := EditorForm.Width;
       EditorDefPos.Bottom := EditorForm.Height;

       XMLConfig1.OpenKey('IDE/Editor');
       XMLConfig1.SetValue('Left', EditorForm.Left);
       XMLConfig1.SetValue('Top', EditorForm.Top);
       XMLConfig1.SetValue('Width', EditorForm.Width);
       XMLConfig1.SetValue('Height', EditorForm.Height);
       XMLConfig1.CloseKey;
     end;

     XMLConfig1.OpenKey('IDE/ProjectManager');
     XMLConfig1.SetValue('Left', ProjManager.Left);
     XMLConfig1.SetValue('Top', ProjManager.Top);
     XMLConfig1.SetValue('Width', ProjManager.Width);
     XMLConfig1.SetValue('Height', ProjManager.Height);
     XMLConfig1.CloseKey;

     XMLConfig1.Flush;
   finally
     XMLConfig1.Free;
   end;
end;

procedure TMainIDEDesForm.ActSaveInFileExecute(Sender: TObject);
var
  PM: TPageModule;
  SL: TStringList;
  S: string;
  L: Integer;
begin
  if (EditorForm <> nil) and (EditorForm.PageControl1.PageCount > 0) then
  begin
    PM := TPageModule(EditorForm.PageControl1.ActivePage);
    ProjManager.SaveModuleInFile(PM);
  end;
end;

procedure TMainIDEDesForm.ActSaveModuleAsExecute(Sender: TObject);
var
  Module: TPageModule;
begin
  if EditorForm <> nil then
  begin
    Module := EditorForm.ActivePageModule;
    if Module <> nil then
    begin
      ProjManager.SaveModuleAs(Module);
    end;
  end;
end;

procedure TMainIDEDesForm.ActSaveModuleAsExternalExecute(Sender: TObject);
var
  Module: TPageModule;
begin
  if EditorForm <> nil then
  begin
    Module := EditorForm.ActivePageModule;
    if Module <> nil then
      ProjManager.SaveModuleAsExternal(Module, True);
  end;
end;

procedure TMainIDEDesForm.ActSaveModuleAsUpdate(Sender: TObject);
var
  E: Boolean;
  PM: TPageModule;
begin
  E := True;
  if EditorForm = nil then E := False
  else
  begin
    PM := EditorForm.ActivePageModule;
    if PM = nil then E := False;
  end;
  TAction(Sender).Enabled := E;
end;

procedure TMainIDEDesForm.ActSaveModuleExecute(Sender: TObject);
var
  Module: TPageModule;
begin
  if ProjManager.ReadOnly then
  begin
    ShowMessage('Этот файл нельзя модифицировать');
    Exit;
  end;
  if EditorForm <> nil then
  begin
    Module := EditorForm.ActivePageModule;
    if Module <> nil then
    begin
      if Module.ExtModule then
        ProjManager.SaveModuleAsExternal(Module, False)
      else
        ProjManager.SaveModule(Module);
    end;
  end;
end;

procedure TMainIDEDesForm.ActSaveModuleUpdate(Sender: TObject);
var
  E: Boolean;
  PM: TPageModule;
begin
  E := True;
  if EditorForm = nil then E := False
  else
  begin
      PM := EditorForm.ActivePageModule;
      if PM = nil then E := False
      else
        E := PM.Modified;
  end;
  TAction(Sender).Enabled := E;
end;

procedure TMainIDEDesForm.ActSaveProjectAsExecute(Sender: TObject);
begin
  ProjManager.SaveProject(True);
end;

procedure TMainIDEDesForm.ActSaveProjectExecute(Sender: TObject);
begin
  ProjManager.SaveProject;
end;

procedure TMainIDEDesForm.ActSetShiftExecute(Sender: TObject);
var
  F: TFileStream;
  S: TStringStream;
  SaveS: TStringStream;
  SaveF: TFileStream;
  Str, FileName, FileExt, NewFile: string;
begin
  if OpenDialog1.Execute then
  begin
    FileExt := ExtractFileExt(OpenDialog1.FileName);
    if FileExt <> '.lm9' then
    begin
      ShowMessage('Не поддерживаемый формат файла');
      Exit;
    end;
    FileName:= ExtractFileNameWithoutExt(OpenDialog1.FileName);
    NewFile := FileName + '.sm9';
    F := TFileStream.Create(OpenDialog1.FileName, fmOpenRead);
    S := TStringStream.Create('');
    try
      S.CopyFrom(F, F.Size);
      S.Seek(0, soFromBeginning);
      Str := EncodeStr(S.DataString);
      SaveF := TFileStream.Create(NewFile, fmCreate);
      SaveS := TStringStream.Create(Str);
      try
        SaveF.CopyFrom(SaveS, SaveS.Size);
      finally
        SaveS.Free;
      end;
    finally
      F.Free;
      S.Free;
    end;
    ShowMessage('Готово');
  end;
end;

procedure TMainIDEDesForm.ActShowAllMethodsExecute(Sender: TObject);
var
  I, N, M: Integer;
  Proc: TDpCustomProc;
  ProcParam: TIdentObject;
  WriteParamType: Boolean;
  S: string;
begin
  dpInfoForm := TdpInfoForm.Create(Self);

  for I := 0 to Compil.ExternalObject.Count - 1 do
  begin
    if Compil.ExternalObject.Items[I] is TDpCustomProc then
    begin
      Proc := TDpCustomProc(Compil.ExternalObject.Items[I]);
      if Proc.FIsFunction then
        S := 'function '
      else
        S := 'procedure ';
      S := S + Proc.OriginalName;
      if Proc.ParamCount > 0 then
      begin
        S := S + '(';
        for N := 0 to Proc.ParamCount - 1 do
        begin
          if Proc.Param[N].AsPointer then S := S + 'var ';
          S := S + Proc.Param[N].OriginalName;
          M := N + 1;
          WriteParamType := True;
          if M < Proc.ParamCount then
          begin
            if (Proc.Param[M].ValueType = Proc.Param[N].ValueType) and
               (Proc.Param[M].AsPointer = Proc.Param[N].AsPointer) then
              WriteParamType := False;
          end;

          if WriteParamType then
          begin
            S := S + ': ' + Proc.Param[N].ValueType.OriginalName;
            if N < Proc.ParamCount - 1 then S := S + '; '
          end
          else
            S := S + ', ';
        end;
        S := S + ')';
      end;
      if Proc.FIsFunction then
        S := S + ': ' + Proc.ValueType.OriginalName;
      dpInfoForm.Memo1.Append(S);
    end;
  end;
  dpInfoForm.Show;
end;

procedure TMainIDEDesForm.ActShowImportClassExecute(Sender: TObject);
var
  I, N, L: Integer;
  ProcList: TStringList;
  PropList: TStringList;
  Proc: TSuProc;
  SetObj: TSetObject;
  IProp: TClassIndexedProp;
  S: string;
  Props: TPropList;
begin
  dpInfoForm := TdpInfoForm.Create(Self);
  PropList := TStringList.Create;
  ProcList := TStringList.Create;
  try
    for I := 0 to Compil.TypeTable.Count - 1 do
    begin
      if Compil.TypeTable.Items[I].BaseType = btClass then
      begin
        if (Compil.TypeTable.Items[I].ValueClassType <> nil) and (Compil.TypeTable.Items[I].ValueClassType.ClassParent <> nil) then
          dpInfoForm.Memo1.Append(Compil.TypeTable.Items[I].OriginalName + ' = class (' + Compil.TypeTable.Items[I].ValueClassType.ClassParent.ClassName + ')')
        else
          dpInfoForm.Memo1.Append(Compil.TypeTable.Items[I].OriginalName);
        PropList.Clear;
        ProcList.Clear;
        for N := 0 to Compil.TypeTable.Items[I].ClassObjects.Count - 1 do
        begin
          if Compil.TypeTable.Items[I].ClassObjects.Items[N].IdentType = itProc then
          begin
            Proc :=  Compil.TypeTable.Items[I].ClassObjects.Items[N] as TSuProc;
            S := GetProcDeclaration(Proc);
            ProcList.Append('    ' + S);
          end
          else
          begin
            if Compil.TypeTable.Items[I].ClassObjects.Items[N] is TClassIndexedProp then
            begin
              IProp := Compil.TypeTable.Items[I].ClassObjects.Items[N] as TClassIndexedProp;
              S := IProp.OriginalName + '[';
              for L := 0 to IProp.Params.Count - 1 do
              begin
                if L > 0 then S := S + ',';
                S := S + TDpType(IProp.Params.Items[L]).OriginalName;
              end;
              S := S + ']: ' + IProp.ValueType.OriginalName;
              PropList.Append('    ' + S);
            end
            else
              PropList.Append('    ' + Compil.TypeTable.Items[I].ClassObjects.Items[N].OriginalName +
              ': ' + Compil.TypeTable.Items[I].ClassObjects.Items[N].ValueType.OriginalName);
          end;
        end;

        Props := TPropList.Create(Compil.TypeTable.Items[I].ValueClassType, tkProperties);
        try
          for N := 0 to Props.Count - 1 do
          begin
            S := '    ' + Props.Items[N]^.Name + ': ' + Props.Items[N]^.PropType^.Name;
            PropList.Append(S);
          end;
        finally
          Props.Free;
        end;

        PropList.Sort;
        ProcList.Sort;

        if PropList.Count > 0 then
          dpInfoForm.Memo1.Append(TrimRight(PropList.Text));
        if ProcList.Count > 0 then
          dpInfoForm.Memo1.Append(TrimRight(ProcList.Text));
        dpInfoForm.Memo1.Append('----------------------------------------------');
      end;
    end;

  finally
    ProcList.Free;
    PropList.Free;
    dpInfoForm.Show;
  end;

end;

procedure TMainIDEDesForm.ActShowImportConstExecute(Sender: TObject);
var
  I: Integer;
  S: string;
  ConstList: TStringList;
begin
  dpInfoForm := TdpInfoForm.Create(Self);
  ConstList := TStringList.Create;
  try
    for I := 0 to Compil.ExternalObject.Count - 1 do
    begin
      if Compil.ExternalObject.Items[I].IdentType = itConst then
      begin
        S := Compil.ExternalObject.Items[I].OriginalName + ' = ';
        if Compil.ExternalObject.Items[I].ValueType.BaseType = btString then
          S := S + '''' + VarToStr(Compil.ExternalObject.Items[I].Value) + ''''
        else
          S := S + VarToStr(Compil.ExternalObject.Items[I].Value);
        ConstList.Append(S);
      end;
    end;
    ConstList.Sort;
    dpInfoForm.Memo1.Lines.Assign(ConstList);
  finally
    ConstList.Free;
    dpInfoForm.Show;
  end;
end;

procedure TMainIDEDesForm.ActShowImportObjectExecute(Sender: TObject);
var
  I: Integer;
  S: string;
begin
  dpInfoForm := TdpInfoForm.Create(Self);
  try
    for I := 0 to Compil.ExternalObject.Count - 1 do
    begin
      if (Compil.ExternalObject.Items[I].ValueType.BaseType = btClass)
        and (Compil.ExternalObject.Items[I].IdentType = itVar) then
      begin
        S := Compil.ExternalObject.Items[I].OriginalName + ': ' + Compil.ExternalObject.Items[I].ValueType.OriginalName;
        dpInfoForm.Memo1.Lines.Append(S);
      end;
    end;
  finally
    dpInfoForm.Show;
  end;
end;

procedure TMainIDEDesForm.ActShowImportTypesExecute(Sender: TObject);
var
  I: Integer;
  TpList: TStringList;
begin
  dpInfoForm := TdpInfoForm.Create(Self);
  TpList := TStringList.Create;
  try
    for I := 0 to Compil.TypeTable.Count - 1 do
    begin
      if Compil.TypeTable.Items[I].BaseType <> btClass then
        TpList.Append(Compil.TypeTable.Items[I].OriginalName);
    end;
    TpList.Sort;
    dpInfoForm.Memo1.Lines.Assign(TpList);
  finally
    TpList.Free;
    dpInfoForm.Show;
  end;
end;

procedure TMainIDEDesForm.ActUndoExecute(Sender: TObject);
begin
  if EditorForm <> nil then
  begin
    if EditorForm.ActivePageModule <> nil then
    begin
      if EditorForm.ActivePageModule.SynEdit.CanUndo then
        EditorForm.ActivePageModule.SynEdit.Undo;
    end;
  end;
end;

procedure TMainIDEDesForm.ActUndoUpdate(Sender: TObject);
begin
  if EditorForm = nil then
  begin
    ActUndo.Enabled := False;
  end
  else
  begin
    if EditorForm.ActivePageModule <> nil then
    begin
      ActUndo.Enabled := EditorForm.ActivePageModule.SynEdit.CanUndo;
    end
    else
      ActUndo.Enabled:= False;
  end;

end;

procedure TMainIDEDesForm.ActUseUnitSrvExecute(Sender: TObject);
var
  PM: TPageModule;
  ExistList: TStringList;
  I: Integer;
begin
  if ProjManager.ProjectExist then
  begin
    if EditorForm <> nil then
    begin
      ExistList := TStringList.Create;
      try
        PM := EditorForm.ActivePageModule;
        PM.SynEdit.GetUnitList(ExistList);
        ExistList.Add(PM.Caption);
        for I := 0 to ExistList.Count - 1 do
          ExistList.Strings[I] := LowerCase(ExistList.Strings[I]);
        UnitForm := TUnitForm.Create(Self);
        ProjManager.GetModuleList(UnitForm.ListBox1.Items, ExistList);
        if UnitForm.ShowModal = mrOK then
        begin
          if UnitForm.ListBox1.ItemIndex >= 0 then
            PM.SynEdit.UsesUnits(UnitForm.ListBox1.Items[UnitForm.ListBox1.ItemIndex]);
        end;
        UnitForm.Free;
        PM.SynEdit.SetFocus;
      finally
        ExistList.Free;
      end;
    end;
  end;
end;

procedure TMainIDEDesForm.ActVewInspectorExecute(Sender: TObject);
begin
  Inspector.Show;
end;

procedure TMainIDEDesForm.ActVewProjManagerExecute(Sender: TObject);
begin
  ProjManager.Show;
end;

procedure TMainIDEDesForm.CompilAddMethod(AddMethod: TAddMethodProc);
begin
  AddMethod('function GetSumProp(V: Variant; SmallFormat: Boolean): string', @Call_GetSumProp);
  AddMethod('procedure GetEngineVersion(Out VMajor, VMinor, VRevision: Integer)', @Call_GetEngineVersion);
  AddMethod('function CheckEngineVersion(VMajor, VMinor, VRevision: Integer): Boolean', @Call_CheckEngineVersion);
  AddMethod('procedure DebugValue(V: Variant)', @Call_DebugValue);
end;

procedure TMainIDEDesForm.DebugServerMessageQueued(Sender: TObject);
begin
  DebugServer.ReadMessage;
end;

procedure TMainIDEDesForm.DebugServerMessage(Sender: TObject);
var
  S: string;
  I: Integer;
begin
  S := DebugServer.StringMessage;
  if S <> '' then
  begin
    if Pos('0:', S) = 1 then
    begin
      Delete(S, 1, 2);
      DebugClient.ServerID := S;
      DebugClient.Connect;
      if DebugClient.Active then
      begin
        for I := 0 to BreakPointList.Count - 1 do
          DebugClient.SendStringMessage('5:' + BreakPointList.Strings[I]);
        DebugClient.SendStringMessage('4:');
      end;
    end
    else
    if Pos('5:', S) = 1 then
    begin
      //Stop Execut On Unit=ExecutX, ExecuteY
      Delete(S, 1, 2);
      EditorForm.GoDebugPos(S);
    end
    else
    if Pos('9:', S) = 1 then
    begin
      if DebugClient.Active then
        DebugClient.Disconnect;
      EditorForm.HideExecMark;
      EditorForm.WriteDebugMessage('Выполнение программы завершено');
    end
    else
    if S = '7:' then
    begin
      if not EditorForm.Active then
      begin
        EditorForm.Show;
        //SetForegroundWindow(EditorForm.Handle);
      end;
    end
    else
    if Pos('3:', S) = 1 then
    begin
      Delete(S, 1, 2);
      ShowMessage('Error on debug application:'#13#10 + S);
    end
    else
    if Pos('11:', S) = 1 then
    begin
      Delete(S, 1, 3);
      EditorForm.WriteDebugMessage(S);
    end
    else
    begin
      Delete(S, 1, 2);
      EditorForm.WriteDebugMessage(S);
    end;
  end;
end;

procedure TMainIDEDesForm.ActNewDMExecute(Sender: TObject);
var
  DM: TDataModule;
  F: TCustomForm;
  S, UName, Lang: string;
  PM: TPageModule;
begin
  if EditorForm = nil then CreateEditor;
  DManager.NewDataModule(DM, F);
  UName := GetNewUnitName;
  Lang := DefaultLanguage;
  S := NewUnitCode(UName, DM, Lang);
  PM := EditorForm.NewModule(DM, F, UName, S, Lang);
  PM.Modified := True;
  if not EditorForm.Active then
    EditorForm.Show;
  F.Show;
end;

procedure TMainIDEDesForm.ActLoadModuleFromFileExecute(Sender: TObject);
var
  LFMFileName, Leng, AFileName: string;
  Code, Res: TStringList;
  L, I: Integer;
  DesObj: TComponent;
  DesForm: TCustomForm;
  PM: TPageModule;
begin
  OpenDialog1.DefaultExt := 'pas';
  OpenDialog1.Filter := 'Pascal|*.pas';
  Leng := BaseLanguage;

  if ProjManager.ProjectExist then
  begin
    if SameText(ProjManager.ProjectOption.Language, ALterLanguage) then
    begin
      Leng:= ALterLanguage;
      OpenDialog1.DefaultExt := 'dp';
      OpenDialog1.Filter := 'Diesel Pascal|*.dp';
    end;
  end;

  if OpenDialog1.Execute then
  begin
    Code := TStringList.Create;
    try
      Code.LoadFromFile(OpenDialog1.FileName);
      LFMFileName := OpenDialog1.FileName;
      AFileName:= ExtractFileName(LFMFileName);
      AFileName:= ExtractFileNameWithoutExt(AFileName);
      L := Length(LFMFileName);
      I := LastDelimiter('.', LFMFileName);
      Delete(LFMFileName, I, L - I + 1);
      LFMFileName := LFMFileName + '.lfm';
      if EditorForm = nil then CreateEditor;
      if FileExists(LFMFileName) then
      begin
        Res := TStringList.Create;
        try
          Res.LoadFromFile(LFMFileName);
          DManager.TextToDesignObj(Res.Text, DesObj, DesForm);
        finally
          Res.Free;
        end;
      end;
      PM := EditorForm.NewModule(DesObj, DesForm, AFileName, Code.Text, Leng);
      if PM <> nil then PM.Modified := True;
    finally
      Code.Free;
    end;
  end;
end;

procedure TMainIDEDesForm.ActMasterFormExecute(Sender: TObject);
var
  Frame: TFrame;
  Form: TCustomForm;
  S, UName, Lang: string;
  AParent: TWinControl;
  Grid: TxDBGrid;
  GBox: TGroupBox;
  Btn: TButton;
  TB: TToolBar;
  TBtn: TToolButton;
  Panel: TPanel;
  PPMenu: TPopupMenu;
  ActLst: TActionList;
  DS: TDataSource;
  I, ALeft, ATop: Integer;
  {$IFDEF IBX}
  IBDS: TIBDataSet;
  {$ENDIF}
begin
  MasterForm := TMasterForm.Create(Self);
  try
    if MasterForm.ShowModal = mrOK then
    begin
      Form := nil;
      AParent := nil;
      TB := nil;
      Grid := nil;
      Panel := nil;
      if EditorForm = nil then CreateEditor;
      if MasterForm.RadioGroup1.ItemIndex = 0 then
      begin
        if EditorForm = nil then CreateEditor;
        DManager.NewDesignPosLeft := EditorForm.Left;
        DManager.NewDesignPosTop := EditorForm.Top;
        Form := DManager.NewDesForm;
        //Form.Font.Quality := fqCleartype;
        if MasterForm.CheckBox10.Checked then
          Form.BorderStyle := bsNone;
        UName := GetNewUnitName;
        Lang := DefaultLanguage;
        S := NewUnitCode(UName, Form, Lang);
        AParent := Form;
      end
      else
      begin
        DManager.NewFrame(Frame, Form);
        //Frame.Font.Quality:= fqCleartype;
        UName := GetNewUnitName;
        Lang := DefaultLanguage;
        S := NewUnitCode(UName, Frame, Lang);
        AParent := Frame;
      end;
      if Form <> nil then
      begin
        EditorForm.NewModule(AParent, Form, UName, S, Lang);
        if MasterForm.CheckBox1.Checked then
        begin
          TB := TToolBar.Create(AParent);
          TB.Name := TDesignerHook(Form.Designer).UniqueName(TB.ClassName);
          TB.Parent := AParent;
          TB.Align := alTop;
          TB.ButtonWidth := 50;
          TB.ButtonHeight := 36;
          TB.AutoSize := True;
          if not MasterForm.CheckBox2.Checked and MasterForm.CheckBox9.Checked then
            TB.EdgeBorders:= [ebBottom]
          else
            TB.EdgeBorders:= [];
          TB.ShowHint := True;

          DManagerAfterAddComponent(TB, AParent);
          for I := 1 to 3 do
          begin
            TBtn := TToolButton.Create(AParent);
            TBtn.Name := TDesignerHook(Form.Designer).UniqueName(TBtn.ClassName);
            TBtn.Parent := TB;
            DManagerAfterAddComponent(TBtn, AParent);
          end;
        end;
        if MasterForm.CheckBox2.Checked then
        begin
          Panel := TPanel.Create(AParent);
          Panel.Name := TDesignerHook(Form.Designer).UniqueName(Panel.ClassName);
          Panel.Color := clGray;
          Panel.Font.Color := clWhite;
          Panel.Font.Size := 10;
          Panel.Font.Bold := True;
          Panel.Parent := AParent;
          Panel.Height := 26;
          Panel.Align:= alTop;
          Panel.BevelOuter := bvLowered;
          if TB <> nil then Panel.Top := TB.Height + 5;
          DManagerAfterAddComponent(Panel, AParent);
        end;
        if MasterForm.CheckBox6.Checked then
        begin
          Grid := TxDBGrid.Create(AParent);
          Grid.Name := TDesignerHook(Form.Designer).UniqueName(TxDBGrid.ClassName);
          Grid.Parent := AParent;
          Grid.Align:= alClient;
          Grid.ScrollBars := ssVertical;
          if MasterForm.CheckBox9.Checked then
            Grid.BorderStyle := bsNone;
          if Panel <> nil then Grid.LocateInfoPanel := Panel;
          DManagerAfterAddComponent(Grid, AParent);
        end;
        if MasterForm.CheckBox7.Checked then
        begin
          GBox := TGroupBox.Create(AParent);
          GBox.Name := TDesignerHook(Form.Designer).UniqueName(TGroupBox.ClassName);
          GBox.Height := 49;
          GBox.Parent := AParent;
          GBox.Align:= alBottom;
          DManagerAfterAddComponent(GBox, AParent);
          Btn := TButton.Create(AParent);
          Btn.Name := TDesignerHook(Form.Designer).UniqueName(TButton.ClassName);
          Btn.Width := 107;
          Btn.Parent := GBox;
          Btn.Top := 2;
          Btn.Left := GBox.ClientWidth - 8 - Btn.Width * 2;
          Btn.Caption:= 'OK';
          Btn.Anchors := [akTop, akRight];
          DManagerAfterAddComponent(Btn, AParent);
          Btn := TButton.Create(AParent);
          Btn.Name := TDesignerHook(Form.Designer).UniqueName(TButton.ClassName);
          Btn.Width := 107;
          Btn.Parent := GBox;
          Btn.Top := 2;
          Btn.Left := GBox.ClientWidth - 4 - Btn.Width;
          Btn.Caption:= 'отмена';
          Btn.Anchors := [akTop, akRight];
          DManagerAfterAddComponent(Btn, AParent);
        end;
        if MasterForm.CheckBox3.Checked then
        begin
          PPMenu := TPopupMenu.Create(AParent);
          PPMenu.Name := TDesignerHook(Form.Designer).UniqueName(TPopupMenu.ClassName);
          PPMenu.DesignInfo := LeftTopToDesignInfo(96, 104);
          DManagerAfterAddComponent(PPMenu, AParent);
          if Grid <> nil then Grid.PopupMenu := PPMenu;
        end;
        if MasterForm.CheckBox4.Checked then
        begin
          ActLst := TActionList.Create(AParent);
          ActLst.Name := TDesignerHook(Form.Designer).UniqueName(TActionList.ClassName);
          ActLst.DesignInfo :=  LeftTopToDesignInfo(160, 104);
          DManagerAfterAddComponent(ActLst, AParent);
        end;
        ALeft:= 96;
        ATop:= 104 + DManager.GridStep * 8;

        {$IFDEF IBX}
          IBDS := nil;
        {$ENDIF}
        if MasterForm.CheckBox8.Checked then
        begin
          {$IFDEF IBX}
          IBDS := TIBDataSet.Create(AParent);
          IBDS.Name := TDesignerHook(Form.Designer).UniqueName(TIBDataSet.ClassName);
          IBDS.DesignInfo :=  LeftTopToDesignInfo(ALeft, ATop);
          DManagerAfterAddComponent(IBDS, AParent);
          Inc(ALeft, DManager.GridStep * 8);
          {IBTR := TIBTransaction.Create(AParent);
          IBTR.Name := TDesignerHook(Form.Designer).UniqueName(TIBTransaction.ClassName);
          IBTR.DesignInfo :=  LeftTopToDesignInfo(ALeft, ATop);
          DManagerAfterAddComponent(IBTR, AParent);
          Inc(ALeft, DManager.GridStep * 8);}
          //IBDS.Transaction := IBTR;
          {$ENDIF}
        end;
        if MasterForm.CheckBox5.Checked then
        begin
          DS := TDataSource.Create(AParent);
          DS.Name := TDesignerHook(Form.Designer).UniqueName(TDataSource.ClassName);
          DS.DesignInfo :=  LeftTopToDesignInfo(ALeft, ATop);
          DManagerAfterAddComponent(DS, AParent);
          if Grid <> nil then Grid.DataSource := DS;
          {$IFDEF IBX}
          if IBDS <> nil then DS.DataSet := IBDS;
          {$ENDIF}
        end;
        TDesignerHook(Form.Designer).SetNonVisual;
        if not EditorForm.Active then EditorForm.Show;
        Form.Show;
        Form.Visible := False;
      end;
    end;
  finally
    MasterForm.Free;
  end;
end;

procedure TMainIDEDesForm.ActMergeAppExecute(Sender: TObject);
begin
  if MergeConfForm = nil then
    MergeConfForm := TMergeConfForm.Create(Self);
  MergeConfForm.Show;
end;

procedure TMainIDEDesForm.ActChangeFormModuleExecute(Sender: TObject);
var
  PM: TPageModule;
  AForm: TCustomForm;
begin
  if EditorForm <> nil then
  begin
    PM := EditorForm.ActivePageModule;
    if PM <> nil then
    begin
      AForm := PM.DesignForm;
      if AForm <> nil then
      begin
        if LastActiveForm = EditorForm then
          DManager.ShowForm(AForm)
        else EditorForm.Show;
      end
      else EditorForm.Show;
    end;
  end;
end;

procedure TMainIDEDesForm.ActAboutBoxExecute(Sender: TObject);
begin
  AboutBox := TAboutBox.Create(Self);
  AboutBox.ShowModal;
end;

procedure TMainIDEDesForm.ActCloseAllExecute(Sender: TObject);
begin
  ProjManager.CloseAll;
end;

procedure TMainIDEDesForm.ActCloseEditorPageExecute(Sender: TObject);
begin
  if EditorForm <> nil then
    EditorForm.CloseModule(EditorForm.ActivePageModule);
end;

procedure TMainIDEDesForm.ActCloseEditorPageUpdate(Sender: TObject);
begin
  if (EditorForm = nil) then
    TAction(Sender).Enabled:= False
  else
  begin
    if EditorForm.ActivePageModule = nil then
      TAction(Sender).Enabled:= False
    else
      TAction(Sender).Enabled:= True
  end;
end;

procedure TMainIDEDesForm.ActDebugTerminateExecute(Sender: TObject);
var
  B: Boolean;
  I: Integer;
begin
  if Process1.Running then
  begin
    B := Process1.Terminate(0);
    I := 0;

    while not B do
    begin
      B := Process1.Terminate(0);
      Application.ProcessMessages;
      Inc(I);
      if I >= 2 then Break;
    end;
    if DebugClient.Active then
       DebugClient.Disconnect;
    EditorForm.HideExecMark;
    if not B then ShowMessage('Не удается завершить процесс')
    else EditorForm.WriteDebugMessage('Процесс выполняемого приложения принудительно завершен');

  end;
end;

procedure TMainIDEDesForm.ActDebugTerminateUpdate(Sender: TObject);
begin
  if Process1.Running then
    TAction(Sender).ImageIndex:= 12
  else
  begin
    TAction(Sender).ImageIndex:= 13;
  end;
end;

procedure TMainIDEDesForm.ActEnvOptionsExecute(Sender: TObject);
var
  XMLConfig1: TXMLConfig;
  S, Ed: string;
  I: Integer;
begin
  EnvOptForm := TEnvOptForm.Create(Self);
  EnvOptForm.SynPasSyn1.Assign(SynPasSyn1);
  EnvOptForm.GridStepEdit.Value:= DManager.GridStep;
  if DManager.MoveObjectMethod = movObject then
    EnvOptForm.MoveOjbParam.ItemIndex:= 0
  else
    EnvOptForm.MoveOjbParam.ItemIndex:= 1;
  EnvOptForm.ShowHints.Checked := DManager.ShowHints;
  EnvOptForm.PaintGird.Checked := DManager.ShowGrid;
  EnvOptForm.FirstSelectThenDrag.Checked := DManager.FirstSelectThenDrag;

  if UserControlShift = [ssCtrl, ssShift] then
    EnvOptForm.RadioGroup1.ItemIndex:= 0
  else
  if UserControlShift = [ssCtrl, ssAlt] then
    EnvOptForm.RadioGroup1.ItemIndex:= 1
  else
    EnvOptForm.RadioGroup1.ItemIndex:= 2;


  case DManager.ControlKeyMove of
    ssCtrl: EnvOptForm.RadioGroup2.ItemIndex := 0;
    ssShift: EnvOptForm.RadioGroup2.ItemIndex := 1;
    ssAlt: EnvOptForm.RadioGroup2.ItemIndex := 2;
  end;

  case DManager.ControlKeyResize of
    ssCtrl: EnvOptForm.RadioGroup3.ItemIndex := 0;
    ssShift: EnvOptForm.RadioGroup3.ItemIndex := 1;
    ssAlt: EnvOptForm.RadioGroup3.ItemIndex := 2;
  end;

  EnvOptForm.SingleButtonBox.Checked := Application.TaskBarBehavior = tbSingleButton;
  EnvOptForm.FontEdit.Text := EditorDefaultFontName;
  EnvOptForm.FontSizeEdit.Text := IntToStr(EditorDefaultFontSize);
  EnvOptForm.ColorBox3.Selected := ReadOnlyEditorColor;
  EnvOptForm.CheckBox4.Checked := ReadOnlyGrayFont;

  EnvOptForm.TranscriptGroup.ItemIndex := LangID;

  EnvOptForm.IconSizeGroup.ItemIndex := IntfIconSize;

  if EnvOptForm.ShowModal = mrOK then
  begin
    EditorDefaultFontName := EnvOptForm.FontEdit.Text;
    EditorDefaultFontSize := StrToInt(EnvOptForm.FontSizeEdit.Text);
    ReadOnlyGrayFont := EnvOptForm.CheckBox4.Checked;
    ReadOnlyEditorColor:= EnvOptForm.ColorBox3.Selected;

    if Assigned(EditorForm) then
      EditorForm.UpdateEditorFont;

    if EnvOptForm.SingleButtonBox.Checked then
      Application.TaskBarBehavior := tbSingleButton
    else Application.TaskBarBehavior := tbMultiButton;

    DManager.GridStep := EnvOptForm.GridStepEdit.Value;
    if EnvOptForm.MoveOjbParam.ItemIndex = 0 then
    DManager.MoveObjectMethod := movObject
    else DManager.MoveObjectMethod := movKontur;
    DManager.ShowHints := EnvOptForm.ShowHints.Checked;
    DManager.ShowGrid := EnvOptForm.PaintGird.Checked;
    DManager.FirstSelectThenDrag := EnvOptForm.FirstSelectThenDrag.Checked;

    LangID:= EnvOptForm.TranscriptGroup.ItemIndex;
    IntfIconSize := EnvOptForm.IconSizeGroup.ItemIndex;


    S := SettingDir;
    if not DirectoryExists(S) then
    begin
      if not CreateDir(S) then
      begin
        ShowMessage('Can''not create dir ' + S);
        Exit;
      end;
    end;
    Ed:= S + 'SynColors.cfg';
    S := S + 'EnvOptions.xml';

    I := EnvOptForm.RadioGroup2.ItemIndex;
    case I of
      0: DManager.ControlKeyMove := ssCtrl;
      1: DManager.ControlKeyMove:= ssShift;
      2: DManager.ControlKeyMove:= ssAlt;
    end;

    I := EnvOptForm.RadioGroup3.ItemIndex;
    case I of
      0: DManager.ControlKeyResize := ssCtrl;
      1: DManager.ControlKeyResize := ssShift;
      2: DManager.ControlKeyResize := ssAlt;
    end;

    XMLConfig1 := TXMLConfig.Create(nil);
    try
      XMLConfig1.Filename := S;
      XMLConfig1.OpenKey('Designer');
      XMLConfig1.SetValue('GridStep', DManager.GridStep);
      XMLConfig1.SetValue('ShowGrid', DManager.ShowGrid);
      XMLConfig1.SetValue('FirstSelectThenDrag', DManager.FirstSelectThenDrag);
      XMLConfig1.SetValue('ShowHints', DManager.ShowHints);
      XMLConfig1.SetValue('MovObjMethod', Integer(DManager.MoveObjectMethod));
      XMLConfig1.SetValue('ControlKeyMove', Integer(DManager.ControlKeyMove));
      XMLConfig1.SetValue('ControlKeyResize', Integer(DManager.ControlKeyResize));
      XMLConfig1.SetValue('TaskBarBehavior', Integer(Application.TaskBarBehavior));
      XMLConfig1.CloseKey;
      XMLConfig1.OpenKey('Editor');
      XMLConfig1.SetValue('ControlKeyMode', EnvOptForm.RadioGroup1.ItemIndex);
      XMLConfig1.SetValue('FontName', EditorDefaultFontName);
      XMLConfig1.SetValue('FontSize', EditorDefaultFontSize);
      XMLConfig1.SetValue('ReadOnlyEditorColor', ReadOnlyEditorColor);
      XMLConfig1.SetValue('ReadOnlyGrayFont', ReadOnlyGrayFont);
      XMLConfig1.CloseKey;
      XMLConfig1.OpenKey('Language');
      XMLConfig1.SetValue('LangID', LangID);
      XMLConfig1.CloseKey;
      XMLConfig1.OpenKey('Interface');
      XMLConfig1.SetValue('IntfIconSize', IntfIconSize);
      XMLConfig1.CloseKey;

      XMLConfig1.Flush;
    finally
      XMLConfig1.Free;
    end;

    if EnvOptForm.RadioGroup1.ItemIndex = 0 then
      UserControlShift:= [ssCtrl, ssShift]
    else
    if EnvOptForm.RadioGroup1.ItemIndex = 1 then
      UserControlShift:= [ssCtrl, ssAlt]
    else
      UserControlShift:= [ssAlt, ssShift];



    SynPasSyn1.Assign(EnvOptForm.SynPasSyn1);
    if EditorForm <> nil then
      EditorForm.AssignDPascalHighlight;
    SynPasSyn1.SaveToFile(Ed);
  end;
  EnvOptForm.Free;
end;

procedure TMainIDEDesForm.ActFindInModulesExecute(Sender: TObject);
begin
  if not ProjManager.ProjectExist then Exit;

  if SearchInModuleForm = nil then
    SearchInModuleForm := TSearchInModuleForm.Create(Self);

  if (EditorForm <> nil) and (EditorForm.ActivePageModule <> nil) then
  begin
    if EditorForm.ActivePageModule.SynEdit.SelectionExist then
      SearchInModuleForm.Edit1.Text := EditorForm.ActivePageModule.SynEdit.SelText;
  end;
  SearchInModuleForm.Show;
end;

procedure TMainIDEDesForm.ActFindInModulesUpdate(Sender: TObject);
begin
  if ProjManager.ProjectExist then
    TAction(Sender).Enabled:= True
  else
    TAction(Sender).Enabled:= False;
end;

procedure TMainIDEDesForm.ActInsertFrameExecute(Sender: TObject);
var
  Node: TTreeNode;
  PNodeObj: PNodeObject;
begin
  FrameListForm := TFrameListForm.Create(Self);
  try
    ProjManager.GetFrameList(FrameListForm.ListBox1.Items);
    if FrameListForm.ShowModal = mrOK then
    begin
      Node := TTreeNode(FrameListForm.ListBox1.Items.Objects[FrameListForm.ListBox1.ItemIndex]);
      PNodeObj:= PNodeObject(Node.Data);
      //DManager.TextToFrame(PNodeObj^.Obj, Frame);
      DManager.AddFrame := PNodeObj^.Obj;
      //DManager.AddFrame.Align := alNone;
    end;
  finally
    FrameListForm.Free;
  end;
end;

procedure TMainIDEDesForm.ActLazTypeAnalizeExecute(Sender: TObject);
var
  PM: TPageModule;
  S: string;


  procedure AnalizeType(ATypeName: string);
  var
    I, Cnt: Integer;
    AType: TDpType;
    IO: TIdentObject;
    AClass: TClass;
  begin
    AType := Compil.FindType(ATypeName, nil, False);
    if AType <> nil then
    begin
      if InfoForm = nil then
        InfoForm := TInfoForm.Create(Self);

      InfoForm.Memo1.Append(AType.OriginalName);
      if AType.BaseType = btEnum then
      begin
        InfoForm.Memo1.Append('Перечисление (Enum)');
        InfoForm.Memo1.Append('MinVal ' + IntToStr(AType.MinVal));
        InfoForm.Memo1.Append('MaxVal ' + IntToStr(AType.MaxVal));
        S := '(';
        Cnt := AType.Atributes.Count - 1;
        for I := 0 to Cnt do
        begin
        IO := TIdentObject(AType.Atributes.Items[I]);
           if I > 0 then S := S + ', ';
           S := S + IO.OriginalName;
         end;
         S := S + ')';
         InfoForm.Memo1.Append(S);
      end
      else
      if AType.BaseType = btSet then
      begin
        InfoForm.Memo1.Append('Множество (Set)');
        if AType.ATypeInfo <> nil then
        begin
          S := GetTypeData(AType.ATypeInfo)^.CompType^.Name;
          InfoForm.Memo1.Append('Множество из ' + S);
          AnalizeType(S);
        end;
      end
      else
      if AType.BaseType = btClass then
      begin
        InfoForm.Memo1.Append('Класс');
        S := AType.OriginalName;
        AClass := AType.ValueClassType;
        AClass := AClass.ClassParent;
        while AClass <> nil do
        begin
          S := S + ', ' + AClass.ClassName;
          AClass := AClass.ClassParent;
        end;
        InfoForm.Memo1.Append('Иерархия: ' + S);
      end;
      InfoForm.Show;
    end;
  end;

begin
  if EditorForm <> nil then
  begin

    PM := EditorForm.ActivePageModule;
    if PM <> nil then
    begin
      if InfoForm <> nil then InfoForm.Memo1.Clear;
      S := PM.SynEdit.GetWordAtRowCol(PM.SynEdit.CaretXY);
      if S <> '' then  AnalizeType(S);
    end;
  end;
end;

procedure TMainIDEDesForm.ActLoadFromUrlExecute(Sender: TObject);
begin
  ProjManager.LoadFromUrl(False);
end;

procedure TMainIDEDesForm.DManagerAfterAddComponent(AComponent,
  ARoot: TComponent);
var
  PM: TPageModule;
  AWControl: TWinControl;
  I: Integer;

  procedure AddMenuItem(AItem: TMenuItem);
  var
    N: Integer;
  begin
    PM.SynEdit.AddComponent(ARoot, AItem);
    AItem.FreeNotification(DManager.GetDesignFormFromRoot(ARoot));
    N := 0;
    while N < AItem.Count do
    begin
      AddMenuItem(AItem.Items[N]);
      Inc(N);
    end;
  end;

begin
  ResetComponentButton;
  if EditorForm = nil then Exit;
  if AComponent <> nil then
  begin
    DManager.PropEditHook;
    PM := EditorForm.GetPageModuleOfRoot(ARoot);
    if PM <> nil then
    begin
      PM.SynEdit.AddComponent(ARoot, AComponent);
      if AComponent is TWinControl then
      begin
        AWControl := TWinControl(AComponent);
        if (AWControl.ControlCount > 0) and not
           (csOwnedChildrenNotSelectable in AWControl.ControlStyle) then
        begin
          I := 0;
          while I < AWControl.ControlCount do
          begin
            if (AWControl.Controls[I].Name <> '') and not
               (csSubComponent in AWControl.Controls[I].ComponentStyle) and not
               (csNoDesignSelectable in AWControl.Controls[I].ControlStyle) then
                  PM.SynEdit.AddComponent(ARoot, AWControl.Controls[I]);
            Inc(I);
          end;
        end;
      end
      else
      if AComponent is TActionList then
      begin
        I := 0;
        while I < TActionList(AComponent).ActionCount do
        begin
          TActionList(AComponent).Actions[I].FreeNotification(DManager.GetDesignFormFromRoot(ARoot));
          PM.SynEdit.AddComponent(ARoot, TActionList(AComponent).Actions[I]);
          Inc(I);
        end;
      end
      else
      if AComponent is TMenu then
      begin
        I := 0;

        while I < TMenu(AComponent).Items.Count do
        begin
          AddMenuItem(TMenu(AComponent).Items[I]);
          Inc(I);
        end;
      end;
    end;
  end;
end;

procedure TMainIDEDesForm.DManagerDeleteComponent(AComponent, ARoot: TComponent);
var  PM: TPageModule;
begin
  if EditorForm = nil then Exit;
  PM := EditorForm.GetPageModuleOfRoot(ARoot);
  if PM <> nil then
  begin
    PM.SynEdit.DelComponent(ARoot, AComponent);
  end;
end;

procedure TMainIDEDesForm.DManagerFormActivate(ARoot: TComponent;
  AForm: TCustomForm);
begin
  if EditorForm <> nil then EditorForm.ActivateByRoot(ARoot);
  LastActiveForm := AForm;
  {$IFDEF UNIX}
  Application.ProcessMessages;
  {$ENDIF}
  DManager.PaintCurentSelection;
end;

function TMainIDEDesForm.DManagerGetClassResurce(AClassName: string): string;
var
  SL: TStringList;
begin
  SL := TStringList.Create;
  try
    Result := ProjManager.GetFrameLFM(AClassName);
  finally
    SL.Free;
  end;
end;

function TMainIDEDesForm.DManagerGetComponentClass(AClassName: string
  ): TComponentClass;
var
  N, I: Integer;
  TabSheet: TTabSheet;
  Panel: TPanel;
begin
  Result := nil;
  I := 0;
  while I < PageControl1.PageCount do
  begin
    TabSheet := PageControl1.Pages[I];
    Panel := TPanel(TabSheet.Controls[0]);
    N := 1;
    while N < Panel.ControlCount do
    begin
      if TComponentButton(Panel.Controls[N]).ComponentClass.ClassName = AClassName then
      begin
        Result := TComponentButton(Panel.Controls[N]).ComponentClass;
        Break;
      end;
      Inc(N);
    end;
    if Result <> nil then Break;
    Inc(I);
  end;
end;

procedure TMainIDEDesForm.DManagerGetIcon(Source: TComponent;
  var Bmp: Graphics.TBitmap);
var
  I, N: Integer;
  Panel: TPanel;
  Button: TComponentButton;
begin
  I := 0;
  while I < PageControl1.PageCount do
  begin
    Panel := TPanel(PageControl1.Pages[I].Controls[0]);
    N := 0;
    while N < Panel.ControlCount do
    begin
      Button := TComponentButton(Panel.Controls[N]);
      if Button.ComponentClass = Source.ClassType then
      begin
        Bmp.Assign(Button.Glyph);
        Break;
      end;
      Inc(N);
    end;
    Inc(I);
  end;
end;

function TMainIDEDesForm.DManagerGetReadOnly(Sender: TComponent): Boolean;
var
  PM: TPageModule;
begin
  Result := ProjManager.ReadOnly;
  if not Result then
    if EditorForm <> nil then
    begin
      PM := EditorForm.ActivePageModule;
      Result := PM.ReadOnly;
    end;
end;

function TMainIDEDesForm.DManagerIsIdeSysKey(Key: Word): Boolean;
begin
  Result := False;
  if Key in [VK_F10, VK_F11, VK_F12] then Result := True;
end;

function TMainIDEDesForm.DManagerIsObjNameExist(AName: string): Boolean;
var
  I: Integer;
  PM: TPageModule;
begin
  Result := False;
  if EditorForm <> nil then
  begin
    for I := 0 to EditorForm.ModuleCount - 1 do
    begin
      PM := EditorForm.Modules[I];
      if PM.RootName <> '' then
      begin
        Result := SameText(PM.RootName, AName);
        if Result then Break;
      end;
    end;
  end;
  if not Result then Result := ProjManager.ObjectNameExist(AName);
end;

function TMainIDEDesForm.DManagerIsVisualComponent(AComponent: TComponent
  ): Boolean;
var
  I, N: Integer;
  Panel: TPanel;
  Button: TComponentButton;
begin
  Result := False;
  I := 0;
  while I < PageControl1.PageCount do
  begin
    Panel := TPanel(PageControl1.Pages[I].Controls[0]);
    N := 0;
    while N < Panel.ControlCount do
    begin
      Button := TComponentButton(Panel.Controls[N]);
      if Button.ComponentClass = AComponent.ClassType then
      begin
        Result := True;
        Break;
      end;
      Inc(N);
    end;
    Inc(I);
  end;
end;

procedure TMainIDEDesForm.FormClose(Sender: TObject;
  var CloseAction: TCloseAction);
begin
  CloseAction:= caFree;
  DManager.Active := False;
  Application.ProcessMessages;
end;

procedure TMainIDEDesForm.FormCloseQuery(Sender: TObject; var CanClose: boolean
  );
begin
  CanClose := True;
  if ProjManager.ProjectExist then
  begin
    ProjManager.CloseAll;
  end;
  Application.ProcessMessages;
  CanClose := not ProjManager.ProjectExist;
end;

procedure TMainIDEDesForm.FormShow(Sender: TObject);
begin
  ReadInterfaceConfig;
  ResetComponentButton;
  ProjManager.Show;
  Inspector.Show;
  Application.ProcessMessages;
  if Application.Params[1] <> '' then
  begin
    ProjManager.OpenConfigFile(Application.Params[1]);
  end
  else
  begin
    ProjManager.NewProject(ALterLanguage);
  end;
end;

procedure TMainIDEDesForm.OnAddConst(AddConst: TAddConstProc);
var
  VI: Integer;
  aName, aValue: string;
begin
  ScriptAddConst(AddConst);
  AddConst('ConfigPath', 'string', '');
  AddConst('DIESEL_SCRIPT_DIR', 'string', '');
  AddConst('DIESEL_EXE_DIR', 'string', '');
  AddConst('DIESEL_SCRIPT_NAME', 'string', '');
  AddConst('DIESEL_EXE_PID', 'DWORD', GetProcessID);
  for VI := 0 to EVarList.Count - 1 do
  begin
    if EVarList.Strings[VI] <> '' then
    begin
      EVarList.GetNameValue(VI, aName, aValue);
      if (aName <> '') and (aValue <> '') then
        AddConst(UTF8UpperCase(aName), 'string', aValue);
    end;
  end;
  EVarList.Clear;
end;

procedure TMainIDEDesForm.OnScriptMessage(AMessage: TDpString);
begin
  if EditorForm <> nil then
  begin
    EditorForm.WriteDebugMessage(AMessage);
    Application.ProcessMessages;
  end;
end;

procedure TMainIDEDesForm.OnScriptError(AMessage: TDpCompilerMessage);
begin
  if EditorForm <> nil then
  begin
    EditorForm.WriteDebugMessage(AMessage.MessageStr);
    Application.ProcessMessages;
  end;
end;

procedure TMainIDEDesForm.PageControl1Change(Sender: TObject);
begin
  ResetComponentButton;
end;

function TMainIDEDesForm.Call_GetSumProp(Instence: TObject; var Params: Variant
  ): Variant;
begin

end;

function TMainIDEDesForm.Call_GetEngineVersion(Instence: TObject;
  var Params: Variant): Variant;
begin

end;

function TMainIDEDesForm.Call_CheckEngineVersion(Instence: TObject;
  var Params: Variant): Variant;
begin

end;

function TMainIDEDesForm.Call_DebugValue(Instence: TObject; var Params: Variant
  ): Variant;
begin

end;

procedure TMainIDEDesForm.CompButtonDown(Sender: TObject);
begin
  DManager.AddComponentClass := TComponentButton(Sender).ComponentClass;
  ShowDesignForm;
end;

function TMainIDEDesForm.NewUnitCode(AUnitName: string; AComponent: TComponent; Lang: string): string;
var
  AClassName: string;
begin
  Result := GetKeyOfLangID(ID_Unit) + ' ' + AUnitName + ';'#13#10#13#10;

  if SameText(Lang, BaseLanguage) then
    Result := Result + GetKeyOfLangID(ID_Interface) + #13#10#13#10;

  if AComponent <> nil then
  begin
    if AComponent is TCustomForm then
      AClassName := 'TForm'
    else
    if AComponent is TSuFrame then
      AClassName := 'TSuFrame'
    else
    if AComponent is TFrame then
      AClassName := 'TFrame'
    else
    if AComponent is TDataModule then
      AClassName:= 'TDataModule';

    Result := Result + GetKeyOfLangID(ID_type) + #13#10;
    Result := Result + '  T' + AComponent.Name + ' = ' + GetKeyOfLangID(ID_class) + '(' + AClassName + ')'#13#10;
    Result := Result + '  ' + GetKeyOfLangID(ID_private) + #13#10 + '  ' + GetKeyOfLangID(ID_protected) + #13#10 + '  ' + GetKeyOfLangID(ID_public) + #13#10;
    Result := Result + '  ' + GetKeyOfLangID(ID_end) + ';'#13#10#13#10;
    Result := Result + GetKeyOfLangID(ID_var) + ' ' + AComponent.Name + ': T' + AComponent.Name + ';'#13#10#13#10;
  end;

  Result := Result + GetKeyOfLangID(ID_Implementation) + #13#10#13#10;
  Result := Result + GetKeyOfLangID(ID_end) + '.'#13#10;
end;

function TMainIDEDesForm.DefaultLanguage: string;
begin
  Result := ProjManager.DefaultLanguage;
end;

function TMainIDEDesForm.UnitExist(AUnitName: string): Boolean;
var
  I: Integer;
  S1, S2: string;
begin
  Result := False;
  if EditorForm = nil then Exit;
  S2 := UTF8LowerCase(AUnitName);
  for I := 0 to EditorForm.PageControl1.PageCount -1 do
  begin
    S1 := UTF8LowerCase(EditorForm.PageControl1.Page[I].Caption);
    if S1 = S2 then
    begin
      Result := True;
      Break;
    end;
  end;

  if not Result then
    Result := ProjManager.UnitExist(AUnitName);
end;

function TMainIDEDesForm.GetUnitSource(AUnitName: TDpString): TDpString;
var
  UtfName: string;
  Node: TTreeNode;
begin
  Result := '';

  if not ProjManager.ProjectExist then Exit;

  UtfName:= AUnitName;
  if UtfName = '!' then
  begin
    Result := PNodeObject(ProjManager.TreeObj.Items.GetFirstNode.Data)^.Code;
    PNodeObject(ProjManager.TreeObj.Items.GetFirstNode.Data)^.UseUnit := True;
    Exit;
  end;

  Node := ProjManager.GetModuleNode(UtfName);

  if (Node <> nil) and (Node.Data <> nil) then
  begin
    PNodeObject(Node.Data)^.UseUnit := True;
    Result := PNodeObject(Node.Data)^.Code;
  end;
end;

function TMainIDEDesForm.GetNewUnitName: string;
var
  I: Integer;
begin
  I := 1;
  while I < 1000 do
  begin
    Result := GetKeyOfLangID(ID_Unit) + IntToStr(I);
    if not UnitExist(Result) then Break;
    Inc(I);
  end;
end;

procedure TMainIDEDesForm.RegComp(PanelName: string; AClass: TComponentClass);
var
  N: Integer;
  Panel: TPanel;
  Button: TComponentButton;
  BmpFileName, BmpDir, S: string;
  TabSheet: TTabSheet;
  LRes: TLResource;
  Pic: TPicture;


  function CreateCompButton(APanel: TPanel): TComponentButton;
  begin
    Result := TComponentButton.Create(APanel);
    Result.GroupIndex := 1;
    Result.Width := 28;
    Result.Height := 28;
    Result.Top := 0;
    Result.Flat := True;
    Result.ShowHint := True;
    Result.Parent := Panel;
    Result.OnClick := @CompButtonDown;
  end;

  function GetPageOfName(AName: string): TTabSheet;
  var
    M: Integer;
  begin
    Result := nil;
    for M := 0 to PageControl1.PageCount - 1 do
    begin
      if PageControl1.Pages[M].Caption = AName then
      begin
        Result := PageControl1.Pages[M];
        Break;
      end;
    end;
  end;

begin
  if AClass = nil then
  begin
    Raise Exception.Create('Can not register component in ' + PanelName + ' ComponentClass = nil');
  end;

  Panel := nil;
  TabSheet := GetPageOfName(PanelName);
  if TabSheet = nil then
  begin
    Panel := TPanel.Create(Self);
    Panel.BevelOuter := bvNone;
    Panel.Left := 0;
    Panel.Top := 0;
    Panel.Align := alClient;

    TabSheet := PageControl1.AddTabSheet;
    TabSheet.Caption := PanelName;
    Panel.Parent := TabSheet;


    Button := CreateCompButton(Panel);
    Button.ComponentClass := nil;
    Button.Left := 0;
    Button.Top := 0;
    Button.Parent := Panel;
    ImageList1.GetBitmap(0, Button.Glyph);
  end
  else
  begin
    Panel := TPanel(TabSheet.Controls[0]);
    N := 1;
    while N < Panel.ControlCount do
    begin
      if TComponentButton(Panel.Controls[N]).ComponentClass = AClass then
      begin
        raise Exception.Create('The component a ' + AClass.ClassName + ' is already registered');
      end;
      Inc(N);
    end;
  end;

  Button := CreateCompButton(Panel);
  if Panel.ControlCount = 1 then
    Button.Left := 35
  else
    Button.Left := 15 + (Panel.ControlCount - 1) * 28 + 2;
  S := AClass.ClassName;
  S := Copy(s, 2, Length(s) - 1);
  Button.Hint := S;
  Button.ComponentClass := AClass;
  //RegisterClass(AClass);
  //if SameText(AClass.ClassName,'TlrCairoExport') then ShowMessage('export');
  LRes := LazarusResources.Find(AClass.ClassName);
  if (LRes <> nil) then // and Button.Glyph.LazarusResourceTypeValid(LRes.ValueType) then
  begin
    Pic := TPicture.Create;
    try

      Pic.LoadFromLazarusResource(AClass.ClassName);
      Button.Glyph.Assign(Pic.Bitmap);
    finally
      Pic.Free;
    end;
  end
  else
  begin
    BmpDir := AppDir + DirectorySeparator + 'Bmp' + DirectorySeparator + TabSheet.Caption + DirectorySeparator;
    BmpFileName := BmpDir + AClass.ClassName + '.bmp';
    if FileExists(BmpFileName) then
      Button.Glyph.LoadFromFile(BmpFileName)
    else
      ImageList1.GetBitmap(1, Button.Glyph);
  end;
end;

procedure TMainIDEDesForm.ResetComponentButton;
var
  Panel: TPanel;
begin
  if PageControl1.ActivePage = nil then Exit;
  Panel := TPanel(PageControl1.ActivePage.Controls[0]);
  if Panel.ControlCount > 0 then
    TSpeedButton(Panel.Controls[0]).Down := True;
end;

procedure TMainIDEDesForm.GetComponentNames(TypeData:PTypeData; Proc: TGetStrProc);
var
  C: TComponent;
  I, N: Integer;
begin
  I := 0;
  while I < DManager.DesignCount do
  begin
    C := TComponent(DManager.ItemsRoot[I]);
    N := 0;
    while N < C.ComponentCount do
    begin
      if C.Components[N].ClassType.InheritsFrom(TypeData^.ClassType ) then
      begin
        if DManager.PropEditHook.LookupRoot = C then
          Proc(C.Components[N].Name)
        else
          Proc(C.Name + '.' + C.Components[N].Name);
      end;
      Inc(N);
    end;
    Inc(I);
  end;
end;

function TMainIDEDesForm.GetComponent(const ComponentPath: String):TComponent;
var
  C: TComponent;
  N, L: Integer;
  AOwnerName, ACompName: string;
begin
  Result := nil;
  N := LastDelimiter('.', ComponentPath);
  L := Length(ComponentPath);
  if N > 0 then
  begin
    AOwnerName:= Copy(ComponentPath, 1, N - 1);
    ACompName:= Copy(ComponentPath, N + 1, L - N);
    C := DManager.GetDesignObjectByName(AOwnerName);
    if C <> nil then
    begin
      Result := C.FindComponent(ACompName);
    end;
  end
  else
  begin
    if DManager.PropEditHook.LookupRoot is TComponent then
    begin
      C := TComponent(DManager.PropEditHook.LookupRoot);
      Result := C.FindComponent(ComponentPath);
    end;
  end;
end;

procedure TMainIDEDesForm.SaveModule(PM: TPageModule);
begin

end;

procedure TMainIDEDesForm.NewForm(IsMain: Boolean);
var
  ALeft, ATop: Integer;
  Form: TCustomForm;
  S, UName, Lang: string;
  PM: TPageModule;
begin
  if EditorForm = nil then CreateEditor;
  EditorForm.Show;
  ALeft := EditorForm.Left;
  ATop := EditorForm.Top;
  DManager.NewDesignPosLeft := ALeft;
  DManager.NewDesignPosTop := ATop;
  Form := DManager.NewDesForm;
  if IsMain then
  begin
    UName:= 'Main';
    Form.Name := 'MainForm';
  end
  else UName := GetNewUnitName;
  Lang := DefaultLanguage;
  S := NewUnitCode(UName, Form, Lang);
  PM := EditorForm.NewModule(Form, Form, UName, S, Lang);
  DManager.ShowForm(Form);
  if IsMain then
  begin
    ProjManager.SaveModule(PM)
  end
  else
    PM.Modified := True;

end;

procedure TMainIDEDesForm.OnChangeSelection(Sender: TObject);
var
  P: TPersistent;
  S: string;
begin
  if Inspector.Selection.Count > 0 then
  begin
    P := Inspector.Selection.Items[0];
    if (P is TComponent) then
        DManager.OnExtChangeSelection(Inspector.Selection);
  end;
end;

procedure TMainIDEDesForm.MethodTypeDataToStr(TypeData: PTypeData;
         AMethodName, ARootName: string; var DeclStr, ImplStr: string);
var
  i, ParamCount, Len, Offset: integer;
  ParamType: TProcParamType;
  s, ParamString, ResultType, MethodDecl, ALang: string;
  IsFunct: Boolean;
  Flags: TParamFlags;
begin
  DeclStr := '';
  ImplStr := '';
  ALang := ProjManager.ProjectOption.Language;
  if TypeData=nil then exit;
  IsFunct := False;
  case TypeData^.MethodKind of
    mkProcedure:
    begin
      if ALang = ALterLanguage then
        case LangID of
          0: MethodDecl := 'method ';
          else MethodDecl := 'метод ';
        end
      else
        case LangID of
          0: MethodDecl := 'procedure ';
          else MethodDecl := 'процедура ';
        end;
    end;
    mkFunction:
    begin
      if ALang = ALterLanguage then
        case LangID of
          0: MethodDecl := 'method ';
          else MethodDecl := 'метод ';
        end
      else
        case LangID of
          0: MethodDecl := 'function ';
          else MethodDecl := 'функция ';
        end;
      IsFunct := True;
    end;
    mkConstructor:
      case LangID of
        0: MethodDecl := 'constructor ';
        else  MethodDecl := 'конструктор ';
      end;
    mkDestructor:
      case LangID of
        0: MethodDecl := 'destructor ';
        else MethodDecl := 'деструктор ';
      end;
    mkClassProcedure:
    begin
      if ALang = ALterLanguage then
        MethodDecl := 'class method '
      else
        MethodDecl := 'class procedure ';

    end;
    mkClassFunction:
    begin
     if ALang = ALterLanguage then
        MethodDecl := 'class method '
      else
        MethodDecl := 'class function ';
      IsFunct := True;
    end;
  end;

  DeclStr := MethodDecl + AMethodName;
  ImplStr := MethodDecl + ARootName + '.' + AMethodName;
  // transform TypeData into a ProcHead String
  ParamCount := TypeData^.ParamCount;
  //DebugLn(['TEventsCodeTool.MethodTypeDataToStr A ParamCount=',ParamCount]);
  Offset:=0;
  MethodDecl := '';
  if ParamCount>0 then begin
    MethodDecl := MethodDecl+'(';
    ParamString:='';
    for i:=0 to ParamCount - 1 do
    begin
      // read ParamFlags
      Len:={$IF FPC_FULLVERSION>=30000}SizeOf(TParamFlags){$ELSE}1{$ENDIF};
      ParamType.Flags:=[];
      Move(TypeData^.ParamList[Offset],ParamType.Flags,Len);
      inc(Offset,Len);

      // read ParamName
      Len := ord(TypeData^.ParamList[Offset]);
      inc(Offset);
      SetLength(ParamType.ParamName,Len);
      Move(TypeData^.ParamList[Offset],ParamType.ParamName[1],Len);
      inc(Offset,Len);
      if ParamType.ParamName = '' then begin
        if ParamCount>1 then
          case LangID of
            0: ParamType.ParamName := 'AValue'+IntToStr(ParamCount-i)
            else ParamType.ParamName := 'Значение'+IntToStr(ParamCount-i)
          end
        else
          case LangID of
            0: ParamType.ParamName := 'AValue';
            else ParamType.ParamName := 'Значение';
          end;
      end;

      // read ParamType
      Len := ord(TypeData^.ParamList[Offset]);
      inc(Offset);
      SetLength(ParamType.TypeName,Len);
      Move(TypeData^.ParamList[Offset],ParamType.TypeName[1],Len);
      inc(Offset,Len);

      if not (TypInfo.pfHidden in ParamType.Flags) then
      begin
        // build string
        if pfVar in ParamType.Flags then
          case LangID of
            0: s:='var '
            else S := 'перем ';
          end
        else if pfConst in ParamType.Flags then
          case LangID of
            0: s:='const ';
            else s:='конст ';
          end
        else if pfOut in ParamType.Flags then
          case LangID of
            0: s:='out ';
            else s:='возвр ';
          end
        else
          s:='';

        s:=s+ParamType.ParamName+': ';
        s:=s+ParamType.TypeName;
        if ParamString <> '' then s:='; '+s;
        ParamString:=ParamString+s;
      end;
    end;
    MethodDecl:=MethodDecl+ParamString+')';
  end;
  if IsFunct then
  begin
    Len:=ord(TypeData^.ParamList[Offset]);
    inc(Offset);
    SetLength(ResultType,Len);
    Move(TypeData^.ParamList[Offset],ResultType[1],Len);
    //inc(Offset,Len);
    if (ResultType<>'') then // e.g. $void
      MethodDecl:=MethodDecl+':'+ResultType;
  end;
  MethodDecl:=MethodDecl+';';
  DeclStr:= DeclStr + MethodDecl;
  ImplStr:=ImplStr + MethodDecl;
end;

function TMainIDEDesForm.CreateMethod(const AName: ShortString; ATypeInfo: PTypeInfo;
      APersistent: TPersistent; const APropertyPath: string): TMethod;

var
  DH: TDesignerHook;
  PM: TPageModule;
  ATypeData: PTypeData;
  ARootClassName, DeclStr, ImplStr, MetName: string;
  JMethod: TJITMethod;
  I: Integer;
begin

  if ProjManager.ReadOnly then Exit;

  if Compil.GetHandlerClass(ATypeInfo) = nil then
  begin
    Result.Code := nil;
    Result.Data := nil;
    ShowMessage('Обработчик события не поддерживается');
    Exit;
  end;

  MetName := AName;
  I := LastDelimiter('.', MetName);
  if I > 0 then Delete(MetName,1, I);
  DH := TDesignerHook(DManager.CurrentDesignForm.Designer);
  ATypeData := GetTypeData(ATypeInfo);
  JMethod := DH.MethodsHandlers.Find(MetName);
  if JMethod <> nil then
    Result := JMethod.Method
  else
    Result := DH.MethodsHandlers.Add(MetName, ATypeData).Method;
  //if EditorForm = nil then CreateEditor;
  PM := EditorForm.GetPageModuleOfRoot(TComponent(DManager.PropEditHook.LookupRoot));
  if PM <> nil then
  begin
    ARootClassName := DManager.GetRootClassName;
    MethodTypeDataToStr(ATypeData, MetName, ARootClassName, DeclStr, ImplStr);
    PM.SynEdit.CreateMethod(MetName, ARootClassName, DeclStr, ImplStr);
  end;
end;

function TMainIDEDesForm.GetMethodName(const Method: TMethod; CheckOwner: TObject; OrigLookupRoot: TPersistent): String;
begin
  if Method.Data <> nil then
    Result := TJITMethod(Method.Data).TheMethodName;
end;

procedure TMainIDEDesForm.ShowMethod(const AName: String);
var
  PM: TPageModule;
  ARootClassName: string;
begin
  PM := EditorForm.GetPageModuleOfRoot(TComponent(DManager.PropEditHook.LookupRoot));
  if PM <> nil then
  begin
    ARootClassName := DManager.GetRootClassName;
    PM.SynEdit.ShowMethod(AName, ARootClassName);
  end;
end;

procedure TMainIDEDesForm.GetCompMethods(InstProp: PInstProp; const Proc: TGetStrProc);
var
  DH: TDesignerHook;
  I: Integer;
  JITMEthod: TJITMethod;
  TypeData: PTypeData;
begin
  TypeData := GetTypeData(InstProp^.PropInfo^.PropType);
  //ShowMessage(InstProp^.PropInfo^.PropType^.Name);
  DH := TDesignerHook(DManager.CurrentDesignForm.Designer);
  for I := 0 to DH.MethodsHandlers.Count - 1 do
  begin
    JITMethod := DH.MethodsHandlers.Get(I);
    if JITMEthod.TypeData = TypeData then Proc(JITMEthod.TheMethodName);
  end;
end;

function TMainIDEDesForm.MethodFromLookupRoot(const Method: TMethod): boolean;
var
  DH: TDesignerHook;
begin
  Result := False;
  if Method.Data <> nil then
  begin
    //TJITMethod(Method.Data).;
    Result := True;
  end;
end;

procedure TMainIDEDesForm.AddBreakPoint(S: string);
begin
  BreakPointList.Add(S);
  if Process1.Running then
  begin
    if DebugClient.Active then
      DebugClient.SendStringMessage('5:' + S);
  end;
end;

procedure TMainIDEDesForm.DelBreakPoint(S: string);
var
  I: Integer;
begin
  I := BreakPointList.IndexOf(S);
  if I >= 0 then
    BreakPointList.Delete(I);
  if Process1.Running then
  begin
    if DebugClient.Active then
      DebugClient.SendStringMessage('6:' + S);
  end;
end;

function TMainIDEDesForm.MethodExists(const AName: String; InstProp: PInstProp;
      var MethodIsCompatible,MethodIsPublished,IdentIsMethod: boolean):boolean;
var
  DH: TDesignerHook;
  JMethod: TJITMethod;
  TypeData: PTypeData;
begin
  Result := False;
  MethodIsCompatible := False;
  MethodIsPublished := False;
  IdentIsMethod := False;
  TypeData := GetTypeData(InstProp^.PropInfo^.PropType);
  DH := TDesignerHook(DManager.CurrentDesignForm.Designer);
  JMethod := DH.MethodsHandlers.Find(AName);
  if JMethod <> nil then
  begin
    Result := True;
    MethodIsPublished:= True;
    IdentIsMethod := True;
    if JMethod.TypeData = TypeData then
    begin
      MethodIsCompatible := True;
    end;
  end;
end;

procedure TMainIDEDesForm.GetSelection(
  const ASelection: TPersistentSelectionList);
var
  I: Integer;
  //Selection: TDesigner
begin
  if DManager.CurrentDesignForm <> nil then
  begin
    for I := 0 to TDesignerHook(DManager.CurrentDesignForm.Designer).DesignerSelections.Count - 1 do
      ASelection.Add(TDesignerHook(DManager.CurrentDesignForm.Designer).DesignerSelections.Items[I]);
  end;
end;

procedure TMainIDEDesForm.ReadInterfaceConfig;
var
  S, DefFontN: string;
  L, T, H, W, I: Integer;
  XMLConfig1: TXMLConfig;
begin

  S := SettingDir + 'EnvOptions.xml';
  if FileExists(S) then
  begin
    XMLConfig1 := TXMLConfig.Create(nil);
    try
      XMLConfig1.Filename := S;
      XMLConfig1.OpenKey('IDE/Main');
      L := XMLConfig1.GetValue('Left', 0);
      Left := L;
      Top  := XMLConfig1.GetValue('Top', 0);
      W := XMLConfig1.GetValue('Width', Screen.Width);
      if L + W > Screen.Width then W := Screen.Width - L;
      Width := W;
      Height := XMLConfig1.GetValue('Height', 96);
      XMLConfig1.CloseKey;

      XMLConfig1.OpenKey('IDE/Inpector');
      L := XMLConfig1.GetValue('Left', 0);
      T := XMLConfig1.GetValue('Top', Top + Height + 38);
      W := XMLConfig1.GetValue('Width', 250);
      H := XMLConfig1.GetValue('Height', Screen.DesktopHeight - Inspector.Top - 74);
      XMLConfig1.CloseKey;

      if L > Screen.Width then L := Screen.Width - W;
      if L + W > Screen.Width then L := Screen.Width - W;
      if T + H > Screen.Height then H := Screen.Height - T;
      Inspector.Left := L;
      Inspector.Top  := T;
      Inspector.Width := W;
      Inspector.Height := H;

      XMLConfig1.OpenKey('IDE/ProjectManager');
      W := XMLConfig1.GetValue('Width', 250);
      L := XMLConfig1.GetValue('Left', Screen.Width - ProjManager.Width - 14);
      T := XMLConfig1.GetValue('Top', Inspector.Top);
      H := XMLConfig1.GetValue('Height', Inspector.Height);
      if L + W > Screen.Width then L := Screen.Width - W;
      if T + H > Screen.Height then H := Screen.Height - T;
      ProjManager.Width := W;
      ProjManager.Left := L;
      ProjManager.Top := T;
      ProjManager.Height := H;
      XMLConfig1.CloseKey;


      XMLConfig1.OpenKey('IDE/Editor');
      L := XMLConfig1.GetValue('Left', 260);
      T := XMLConfig1.GetValue('Top', Inspector.Top);
      W := XMLConfig1.GetValue('Width', 800);
      H := XMLConfig1.GetValue('Height', 600);
      XMLConfig1.CloseKey;
      EditorDefPos.Left := L;
      EditorDefPos.Top := T;
      EditorDefPos.Right := W;
      EditorDefPos.Bottom := H;

      I := L + W;
      if I > Screen.Width  then EditorDefPos.Right := Screen.Width - L;
      I := T + H;
      if I > Screen.Height then EditorDefPos.Bottom:= Screen.Height - T;

      if EditorForm <> nil then
      begin
        EditorForm.Left := EditorDefPos.Left;
        EditorForm.Top := EditorDefPos.Top;
        EditorForm.Width:= EditorDefPos.Right;
        EditorForm.Height := EditorDefPos.Bottom;
      end;

      XMLConfig1.OpenKey('Designer');
      DManager.GridStep := XMLConfig1.GetValue('GridStep', DManager.GridStep);
      DManager.ShowGrid := XMLConfig1.GetValue('ShowGrid', DManager.ShowGrid);
      DManager.FirstSelectThenDrag := XMLConfig1.GetValue('FirstSelectThenDrag', DManager.FirstSelectThenDrag);
      DManager.ShowHints := XMLConfig1.GetValue('ShowHints', DManager.ShowHints);
      I := XMLConfig1.GetValue('MovObjMethod', Integer(DManager.MoveObjectMethod));
      DManager.MoveObjectMethod := TMoveObjectMethod(I);
      I := XMLConfig1.GetValue('ControlKeyMove', Integer(DManager.ControlKeyMove));
      DManager.ControlKeyMove:= TShiftStateEnum(I);
      I := XMLConfig1.GetValue('ControlKeyResize', Integer(DManager.ControlKeyResize));
      DManager.ControlKeyResize:= TShiftStateEnum(I);
      I := XMLConfig1.GetValue('TaskBarBehavior', Integer(Application.TaskBarBehavior));
      Application.TaskBarBehavior := TTaskBarBehavior(I);
      XMLConfig1.CloseKey;

      XMLConfig1.OpenKey('Editor');
      I := XMLConfig1.GetValue('ControlKeyMode', 0);
      case I of
        0: UserControlShift:= [ssCtrl, ssShift];
        1: UserControlShift:= [ssCtrl, ssAlt];
        2: UserControlShift:= [ssShift, ssAlt];
      end;
      EditorDefaultFontName := XMLConfig1.GetValue('FontName', EditorDefaultFontName);
      EditorDefaultFontSize := XMLConfig1.GetValue('FontSize', 10);
      ReadOnlyGrayFont := XMLConfig1.GetValue('ReadOnlyGrayFont', True);
      ReadOnlyEditorColor := XMLConfig1.GetValue('ReadOnlyEditorColor', clWhite);
      XMLConfig1.CloseKey;

      XMLConfig1.OpenKey('Language');
      LangID := XMLConfig1.GetValue('LangID', 0);
      XMLConfig1.CloseKey;

      XMLConfig1.OpenKey('Interface');
      IntfIconSize := XMLConfig1.GetValue('IntfIconSize', 0);
      XMLConfig1.CloseKey;
      case IntfIconSize of
        0:
        begin
          SetIntfImageList(MainImages);
          Panel1.Width := 215;
          Panel1.Height := 62;
          ToolBar1.ButtonWidth := 24;
          ToolBar1.ButtonHeight := 24;
          ToolBar2.ButtonWidth := 24;
          ToolBar2.ButtonHeight := 24;
        end;
        1:
        begin
          SetIntfImageList(MiddleImage);
          Panel1.Width := Round(215 * 1.5);
          Panel1.Height := Round(62 * 1.5);
          ToolBar1.ButtonWidth:= Round(24 * 1.5);
          ToolBar1.ButtonHeight := Round(24 * 1.5);
          ToolBar2.ButtonWidth := Round(24 * 1.5);
          ToolBar2.ButtonHeight := Round(24 * 1.5);
        end;
        2:
        begin
          SetIntfImageList(LageImages);
          Panel1.Width := 215 * 2;
          Panel1.Height := 62 * 2;
          ToolBar1.ButtonWidth:= 24 * 2;
          ToolBar1.ButtonHeight := 24 * 2;
          ToolBar2.ButtonWidth := 24 * 2;
          ToolBar2.ButtonHeight := 24 * 2;
        end;
      end;

    finally
      XMLConfig1.Free;
    end;
  end
  else
  begin
    Inspector.Left := 0;
    Inspector.Top := Top + Height + 38;
    Inspector.Height := Screen.DesktopHeight - Inspector.Top - 74;
    ProjManager.Left:= Screen.Width - ProjManager.Width - 14;
    ProjManager.Top := Inspector.Top;
    ProjManager.Height := Inspector.Height;
    EditorDefPos.Left := Inspector.Left + Inspector.Width + 20;
    EditorDefPos.Top := Inspector.Top;
    EditorDefPos.Right := 800;
    EditorDefPos.Bottom := 600;
  end;

  S := SettingDir + 'SynColors.cfg';
  if FileExists(S) then
    SynPasSyn1.LoadFromFile(S);

  S := SettingDir + 'history.txt';
  if FileExists(S) then
  begin
    ProjManager.HistoryList.LoadFromFile(S);
    UpdateHistoryMenu;
  end;
end;

procedure TMainIDEDesForm.OnInpectorPropertyModified(Sender: TObject);
begin
  Application.ProcessMessages;
  DManager.PaintCurentSelection;
end;

procedure TMainIDEDesForm.OnInpectorEventModified(Sender: TObject);
begin
end;

procedure TMainIDEDesForm.PropHookSetSelection(
  const ASelection: TPersistentSelectionList);
begin
  Inspector.Selection := ASelection;
end;

procedure TMainIDEDesForm.OnInitIDEFileDialog(AFileDialog: TFileDialog);
begin

end;

procedure TMainIDEDesForm.OnStoreIDEFileDialog(AFileDialog: TFileDialog);
begin

end;

procedure TMainIDEDesForm.OnAppExeption(Sender: TObject; E: Exception);
var
  S: string;
  {$IFDEF IBX}
  SL: TStringList;
  SQLErrCode, IBErrCode: LongInt;
  {$ENDIF}
begin
  //Application.Flags:= Application.Flags + [AppHandlingException];
  if (not Application.Terminated) and (AppInitialized in Application.Flags) then
  begin
    Application.DisableIdleHandler;
    try
      S := E.Message;
      if FindInvalidUTF8Character(PChar(S), Length(S), False) > 0 then
        S := dp_AnsiToUTF8(S);

      {$IFDEF IBX}
      if E is EIBInterBaseError then
      begin
        SQLErrCode := EIBInterBaseError(E).SQLCode;
        IBErrCode:= EIBInterBaseError(E).IBErrorCode;
        if (SQLErrCode = -836) and ((IBErrCode = 335544517) or
        (IBErrCode = 335544848))  then
        begin
          SL := TStringList.Create;
          SL.Text:= S;
          if SL.Count > 2 then
            S := SL.Strings[2];
          SL.Free;

        end;
      end;
      {$ENDIF}

      Application.MessageBox(PChar(S), PChar(Application.Title), MB_OK or MB_ICONERROR);
    finally
      Application.EnableIdleHandler;
    end;
  end;
end;

procedure TMainIDEDesForm.CompoenentRenamed(AComponent: TComponent);
var
  PM: TPageModule;
  AOwner: TComponent;
begin
  {if not (AComponent is TControl) then
  begin
    //TDesignerHook(DManager.CurrentDesignForm.Designer).ComponentRenamed(AComponent);
  end;}
  PM := nil;
  Inspector.ComponentTree.BuildComponentNodes(True);
  //Inspector.ComponentTree.RebuildComponentNodes;
  if AComponent.Owner = nil then
    PM := EditorForm.GetPageModuleOfRoot(AComponent)
  else
  begin
    AOwner := AComponent.Owner;
    while AOwner.Owner <> nil do
    begin
      AOwner := AOwner.Owner;
    end;
    PM := EditorForm.GetPageModuleOfRoot(AOwner);
  end;
  if PM <> nil then
  begin
    NewComponentName := AComponent.Name;
    if PM.DesignObject <> PM.DesignForm then
      PM.DesignForm.Caption:= PM.DesignObject.Name;
    PM.SynEdit.RanameComponent(AComponent, NewComponentName, OldComponentName);
  end;
end;

procedure TMainIDEDesForm.CompilAddScriptObj(AddObject: TAddObjectProc);
begin
  AddScriptObj(AddObject);
end;

procedure TMainIDEDesForm.CompilAddImporters(AddImporter: TAddImporterProc);
begin
  AddImporters(AddImporter);
end;

procedure TMainIDEDesForm.EmbCompilMsg(AMessage: string);
begin
  if EditorForm = nil then CreateEditor;
  EditorForm.ListBox1.Items.Add(AMessage);
end;

procedure TMainIDEDesForm.OnMessageQueued(Sender: TObject);
begin
  DebugServer.ReadMessage;
end;

function TMainIDEDesForm.GetProcDeclaration(Proc: TSuProc): string;
var
  S: string;
  N, M: Integer;
  //ProcParam: TIdentObject;
  WriteParamType: Boolean;
begin
  Result := '';
  if Proc.FIsFunction then
    S := 'function '
  else
    S := 'procedure ';
  S := S + Proc.OriginalName;
  if Proc.ParamCount > 0 then
  begin
    S := S + '(';
    for N := 0 to Proc.ParamCount - 1 do
    begin
      if Proc.Param[N].AsPointer then S := S + 'var ';
      S := S + Proc.Param[N].OriginalName;
      M := N + 1;
      WriteParamType := True;
      if M < Proc.ParamCount then
      begin
        if (Proc.Param[M].ValueType = Proc.Param[N].ValueType) and
           (Proc.Param[M].AsPointer = Proc.Param[N].AsPointer) then
          WriteParamType := False;
      end;

      if WriteParamType then
      begin
        S := S + ': ' + Proc.Param[N].ValueType.OriginalName;
        if N < Proc.ParamCount - 1 then S := S + '; '
      end
      else
        S := S + ', ';
    end;
    S := S + ')';
  end;
  if Proc.FIsFunction then
    S := S + ': ' + Proc.ValueType.OriginalName;

  Result := S;
end;

procedure TMainIDEDesForm.SetIntfImageList(ImageList: TImageList);
begin
  ActionList1.Images := ImageList;
  MainMenu1.Images := ImageList;
  ToolBar1.Images := ImageList;
  ToolBar2.Images := ImageList;
end;

procedure TMainIDEDesForm.ShowDesignForm;
var
  PM: TPageModule;
  AForm: TCustomForm;
begin
  if EditorForm <> nil then
  begin
    PM := EditorForm.ActivePageModule;
    if PM <> nil then
    begin
      AForm := PM.DesignForm;
      if AForm <> nil then
          DManager.ShowForm(AForm)
    end;
  end;
end;

procedure TMainIDEDesForm.HistoryMenuClick(Sender: TObject);
var
  MI: TMenuItem;
begin
  MI := TMenuItem(Sender);
  if ProjManager.ProjectExist then
    ProjManager.CloseAll;
  if not ProjManager.ProjectExist then
    ProjManager.OpenConfigFile(MI.Caption);
end;

procedure TMainIDEDesForm.UpdateHistoryMenu;
var
  I: Integer;
  MI: TMenuItem;
begin
  for I := 0 to ProjManager.HistoryList.Count - 1 do
  begin
    MI := TMenuItem(ProjManager.HistoryList.Objects[I]);
    if MI = nil then
    begin
      MI := TMenuItem.Create(Self);
      MI.Caption := ProjManager.HistoryList.Strings[I];
      MI.OnClick := @HistoryMenuClick;
      NLastFiles.Add(MI);
      ProjManager.HistoryList.Objects[I] := MI;
    end;
  end;

  for I := 0 to ProjManager.HistoryList.Count - 1 do
  begin
    MI := TMenuItem(ProjManager.HistoryList.Objects[I]);
    if MI <> nil then
    begin
      MI.MenuIndex := I;
    end;
  end;
end;

initialization

{$I standard.lrs}
{$I additional.lrs}
{$I commoncontrols.lrs}
{$I system.lrs}
{$I datacontrols.lrs}
{$I dialogs.lrs}
{$I misc.lrs}
{$I visualdesign.lrs}
{$I DataAccess.lrs}


{$IFDEF LAZREPORT}
  {$I lr_register.lrs}
  {$I lr_PDF417icon.lrs}
{$ENDIF}

{$IFDEF IBX} {$I IBDBReg.lrs} {$ENDIF}

{$ifdef devartdac}
  {$I DADesign.lrs}
  {$ifdef IBDAC}
    {$I IBCDesign.lrs}
  {$endif}
{$endif}
{$I LazCairo.lrs}

{$IFDEF ZEOS}  {$I ZComponentReg.lrs} {$ENDIF}
{$IfDef ATOLKKM} {$I atolkkm.lrs} {$EndIf}
{$IfDef CHART} {$I tachart.lrs} {$EndIf}
{$IfDef FP_SPREADSHEET} {$I fpspreadsheetctrls.lrs} {$EndIf}
{$IFDEF WINDOWS} {$I lazactivex.lrs} {$EndIf}
TranslateResourceStrings('lclstrconsts.po');

end.

