unit IBCSQLEdits;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, DASQLEdits, SQLEditor, PropEdits, IBC, Forms;

type

  { TIBCSQLPropertyEditor }

  TIBCSQLPropertyEditor = class(TDASQLPropertyEditor)
  public
    constructor Create(Hook: TPropertyEditorHook; APropCount: Integer); override;
    destructor Destroy; override;
  end;

implementation

uses synhighlightersqlex;

{ TIBCSQLPropertyEditor }

constructor TIBCSQLPropertyEditor.Create(Hook: TPropertyEditorHook;
  APropCount: Integer);
begin
  inherited Create(Hook, APropCount);
  UseReturningField := True;
  MainMetadata := TIBCMetaData.Create(Application);
  SubMetadata := TIBCMetaData.Create(Application);
  PKeyMetadata := TIBCMetaData.Create(Application);
  IndexedColumn := TIBCMetaData.Create(Application);
  SqlDialect:= sqlFireBird;
end;

destructor TIBCSQLPropertyEditor.Destroy;
begin
  MainMetadata.Free;
  SubMetadata.Free;
  PKeyMetadata.Free;
  IndexedColumn.Free;
  inherited Destroy;
end;

end.

