{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit dpi_Xml;

{$mode objfpc}{$H+}

interface

uses SysUtils, Classes, dpCompil, TypInfo, Variants, XMLRead, XMLWrite, DOM,
  Dialogs, FileUtil, dpi_mettyps;

type

  { TXMLImport }

  TXMLImport = class(TClassImporter)
    function DOMAttr_DataTypeGet(Instance: Pointer): Variant;
    procedure DOMAttr_DataTypeSet(Instance: Pointer; AValue: Variant);
    function DOMAttr_IsID(Instance: Pointer): Variant;
    function DOMAttr_Name(Instance: Pointer): Variant;
    function DOMAttr_OwnerElement(Instance: Pointer): Variant;
    function DOMAttr_Specified(Instance: Pointer): Variant;
    function DOMAttr_ValueGet(Instance: Pointer): Variant;
    procedure DOMAttr_ValueSet(Instance: Pointer; AValue: Variant);
    function DOMCharacterData_AppendData(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMCharacterData_DeleteData(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMCharacterData_GetData(Instance: Pointer): Variant;
    function DOMCharacterData_GetLength(Instance: Pointer): Variant;
    function DOMCharacterData_InsertData(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMCharacterData_ReplaceData(Instance: TObject; var Params: Variant
      ): Variant;
    procedure DOMCharacterData_SetData(Instance: Pointer; AValue: Variant);
    function DOMCharacterData_SubstringData(Instance: TObject;
      var Params: Variant): Variant;
    function DOMDocumentType_Entities(Instance: Pointer): Variant;
    function DOMDocumentType_InternalSubset(Instance: Pointer): Variant;
    function DOMDocumentType_Name(Instance: Pointer): Variant;
    function DOMDocumentType_Notations(Instance: Pointer): Variant;
    function DOMDocumentType_PublicID(Instance: Pointer): Variant;
    function DOMDocumentType_SystemID(Instance: Pointer): Variant;
    function DOMDocument_CreateAttribute(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMDocument_CreateAttributeNS(Instance: TObject;
      var Params: Variant): Variant;
    function DOMDocument_CreateCDATASection(Instance: TObject;
      var Params: Variant): Variant;
    function DOMDocument_CreateComment(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMDocument_CreateDocumentFragment(Instance: TObject;
      var Params: Variant): Variant;
    function DOMDocument_CreateElement(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMDocument_CreateElementNS(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMDocument_CreateEntityReference(Instance: TObject;
      var Params: Variant): Variant;
    function DOMDocument_CreateProcessingInstruction(Instance: TObject;
      var Params: Variant): Variant;
    function DOMDocument_CreateTextNode(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMDocument_documentURIGet(Instance: Pointer): Variant;
    procedure DOMDocument_documentURISet(Instance: Pointer; AValue: Variant);
    function DOMDocument_GetDocType(Instance: Pointer): Variant;
    function DOMDocument_GetDocumentElement(Instance: Pointer): Variant;
    function DOMDocument_GetElementById(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMDocument_GetElementsByTagName(Instance: TObject;
      var Params: Variant): Variant;
    function DOMDocument_GetElementsByTagNameNS(Instance: TObject;
      var Params: Variant): Variant;
    function DOMDocument_GetImpl(Instance: Pointer): Variant;
    function DOMDocument_GetXMLVersion(Instance: Pointer): Variant;
    function DOMDocument_ImportNode(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMDocument_IndexOfNS(Instance: TObject; var Params: Variant
      ): Variant;
    procedure DOMDocument_SetXMLVersion(Instance: Pointer; AValue: Variant);
    function DOMDocument_XMLStandaloneGet(Instance: Pointer): Variant;
    procedure DOMDocument_XMLStandaloneSet(Instance: Pointer; AValue: Variant);
    function DOMElement_AttribStringsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMElement_AttribStringsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMElement_GetAttribute(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMElement_GetAttributeNode(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMElement_GetAttributeNodeNS(Instance: TObject;
      var Params: Variant): Variant;
    function DOMElement_GetAttributeNS(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMElement_GetElementsByTagName(Instance: TObject;
      var Params: Variant): Variant;
    function DOMElement_GetElementsByTagNameNS(Instance: TObject;
      var Params: Variant): Variant;
    function DOMElement_hasAttribute(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMElement_hasAttributeNS(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMElement_RemoveAttribute(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMElement_RemoveAttributeNode(Instance: TObject;
      var Params: Variant): Variant;
    function DOMElement_RemoveAttributeNS(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMElement_SetAttribute(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMElement_SetAttributeNode(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMElement_SetAttributeNodeNS(Instance: TObject;
      var Params: Variant): Variant;
    function DOMElement_SetAttributeNS(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMElement_TagName(Instance: Pointer): Variant;
    function DOMEntity_NotationName(Instance: Pointer): Variant;
    function DOMEntity_PublicID(Instance: Pointer): Variant;
    function DOMEntity_SystemID(Instance: Pointer): Variant;
    function DOMEntity_XMLVersion(Instance: Pointer): Variant;
    function DOMImplementation_CreateDocument(Instance: TObject;
      var Params: Variant): Variant;
    function DOMImplementation_CreateDocumentType(Instance: TObject;
      var Params: Variant): Variant;
    function DOMImplementation_HasFeature(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNamedNodeMap_GetLength(Instance: Pointer): Variant;
    function DOMNamedNodeMap_GetNamedItem(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNamedNodeMap_getNamedItemNS(Instance: TObject;
      var Params: Variant): Variant;
    function DOMNamedNodeMap_ItemGet(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNamedNodeMap_RemoveNamedItem(Instance: TObject;
      var Params: Variant): Variant;
    function DOMNamedNodeMap_removeNamedItemNS(Instance: TObject;
      var Params: Variant): Variant;
    function DOMNamedNodeMap_SetNamedItem(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNamedNodeMap_setNamedItemNS(Instance: TObject;
      var Params: Variant): Variant;
    function DOMNodeList_GetCount(Instance: Pointer): Variant;
    function DOMNodeList_ItemGet(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_AppendChild(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_ChildNodesGet(Instance: Pointer): Variant;
    function DOMNode_CloneNode(Instance: TObject; var Params: Variant): Variant;
    function DOMNode_CompareName(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_DetachChild(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_FindNode(Instance: TObject; var Params: Variant): Variant;
    function DOMNode_FirstChildGet(Instance: Pointer): Variant;
    function DOMNode_FlagsGet(Instance: Pointer): Variant;
    function DOMNode_GetAttributes(Instance: Pointer): Variant;
    function DOMNode_GetBaseURI(Instance: Pointer): Variant;
    function DOMNode_GetChildNodes(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_GetLastChild(Instance: Pointer): Variant;
    function DOMNode_GetLocalName(Instance: Pointer): Variant;
    function DOMNode_GetNamespaceURI(Instance: Pointer): Variant;
    function DOMNode_GetOwnerDocument(Instance: Pointer): Variant;
    function DOMNode_GetPrefix(Instance: Pointer): Variant;
    function DOMNode_GetTextContent(Instance: Pointer): Variant;
    function DOMNode_HasAttributes(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_HasChildNodes(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_InsertBefore(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_IsDefaultNamespace(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_IsSupported(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_LookupNamespaceURI(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_LookupPrefix(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_NextSiblingGet(Instance: Pointer): Variant;
    function DOMNode_NodeNameGet(Instance: Pointer): Variant;
    function DOMNode_NodeTypeGet(Instance: Pointer): Variant;
    function DOMNode_NodeValueGet(Instance: Pointer): Variant;
    procedure DOMNode_NodeValueSet(Instance: Pointer; AValue: Variant);
    function DOMNode_Normalize(Instance: TObject; var Params: Variant): Variant;
    function DOMNode_ParentNodeGet(Instance: Pointer): Variant;
    function DOMNode_PreviousSiblingGet(Instance: Pointer): Variant;
    function DOMNode_RemoveChild(Instance: TObject; var Params: Variant
      ): Variant;
    function DOMNode_ReplaceChild(Instance: TObject; var Params: Variant
      ): Variant;
    procedure DOMNode_SetPrefix(Instance: Pointer; AValue: Variant);
    procedure DOMNode_SetTextContent(Instance: Pointer; AValue: Variant);
    function DOMNode_TopLevel_InputEncoding(Instance: Pointer): Variant;
    function DOMNode_TopLevel_XMLEncoding(Instance: Pointer): Variant;
    function DOMNode_WithChilder_InternalAppend(Instance: TObject;
      var Params: Variant): Variant;
    function DOMNotation_PublicID(Instance: Pointer): Variant;
    function DOMNotation_SystemID(Instance: Pointer): Variant;
    function DOMProcessingInstruction_Data(Instance: Pointer): Variant;
    function DOMProcessingInstruction_Target(Instance: Pointer): Variant;
    function DOMText_IsElementContentWhitespace(Instance: TObject;
      var Params: Variant): Variant;
    function DOMText_SplitText(Instance: TObject; var Params: Variant): Variant;

    //Call Methods
    function Call_ReadXMLFile(Instance: TObject; var Params: Variant): Variant;
    function Call_ReadXMLFromStream(Instance: TObject; var Params: Variant): Variant;
    function Call_ReadXMLFromStreamURI(Instance: TObject; var Params: Variant): Variant;

    function Call_ReadXMLFragment(Instance: TObject; var Params: Variant): Variant;
    function Call_ReadXMLFragmentFromStream(Instance: TObject; var Params: Variant): Variant;
    function Call_ReadXMLFragmentFromStreamURI(Instance: TObject; var Params: Variant): Variant;

    function Call_ReadDTDFile(Instance: TObject; var Params: Variant): Variant;
    function Call_ReadDTDStream(Instance: TObject; var Params: Variant): Variant;
    function Call_ReadDTDStreamURI(Instance: TObject; var Params: Variant): Variant;

    function Call_WriteXMLFile(Instance: TObject; var Params: Variant): Variant;
    function Call_WriteXMLInStream(Instance: TObject; var Params: Variant): Variant;

    function Call_WriteXMLElement(Instance: TObject; var Params: Variant): Variant;
    function Call_WriteXMLElementStram(Instance: TObject; var Params: Variant): Variant;
    function XMLDocument_Create(Instance: TObject; var Params: Variant
      ): Variant;

  private
  protected
  public
    procedure AddMethods(AddMethod: TAddMethodProc); override;
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
       override;
    procedure RegisterPublic(AType: TDpType); override;
  end;

implementation

uses dpUtils;

{ TXMLImport }

function TXMLImport.DOMAttr_DataTypeGet(Instance: Pointer): Variant;
begin
  Result := TDOMAttr(Instance).DataType;
end;

procedure TXMLImport.DOMAttr_DataTypeSet(Instance: Pointer; AValue: Variant);
begin
  TDOMAttr(Instance).DataType := AValue;
end;

function TXMLImport.DOMAttr_IsID(Instance: Pointer): Variant;
begin
  Result := TDOMAttr(Instance).IsID;
end;

function TXMLImport.DOMAttr_Name(Instance: Pointer): Variant;
begin
  Result := TDOMAttr(Instance).Name;
end;

function TXMLImport.DOMAttr_OwnerElement(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMAttr(Instance).OwnerElement);
end;

function TXMLImport.DOMAttr_Specified(Instance: Pointer): Variant;
begin
  Result := TDOMAttr(Instance).Specified;
end;

function TXMLImport.DOMAttr_ValueGet(Instance: Pointer): Variant;
begin
  Result := TDOMAttr(Instance).Value;
end;

procedure TXMLImport.DOMAttr_ValueSet(Instance: Pointer; AValue: Variant);
begin

  TDOMAttr(Instance).Value := AValue;
end;

function TXMLImport.DOMCharacterData_AppendData(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TDOMCharacterData(Instance).AppendData(S);
end;

function TXMLImport.DOMCharacterData_DeleteData(Instance: TObject;
  var Params: Variant): Variant;
begin
  TDOMCharacterData(Instance).DeleteData(Params[0], Params[1]);
end;

function TXMLImport.DOMCharacterData_GetData(Instance: Pointer): Variant;
begin
  Result := TDOMCharacterData(Instance).Data;
end;

function TXMLImport.DOMCharacterData_GetLength(Instance: Pointer): Variant;
begin
  Result := TDOMCharacterData(Instance).Length;
end;

function TXMLImport.DOMCharacterData_InsertData(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[1];
  TDOMCharacterData(Instance).InsertData(Params[0], S);
end;

function TXMLImport.DOMCharacterData_ReplaceData(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[2];
  TDOMCharacterData(Instance).ReplaceData(Params[0], Params[1], S);
end;

procedure TXMLImport.DOMCharacterData_SetData(Instance: Pointer; AValue: Variant
  );
var
  S: string;
begin
  S := AValue;
  TDOMCharacterData(Instance).Data := S;
end;

function TXMLImport.DOMCharacterData_SubstringData(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TDOMCharacterData(Instance).SubstringData(Params[0], Params[1]);
end;

function TXMLImport.DOMDocumentType_Entities(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMDocumentType(Instance).Entities);
end;

function TXMLImport.DOMDocumentType_InternalSubset(Instance: Pointer): Variant;
begin
  Result := TDOMDocumentType(Instance).InternalSubset;
end;

function TXMLImport.DOMDocumentType_Name(Instance: Pointer): Variant;
begin
  Result := TDOMDocumentType(Instance).Name;
end;

function TXMLImport.DOMDocumentType_Notations(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TDOMDocumentType(Instance).Notations);
end;

function TXMLImport.DOMDocumentType_PublicID(Instance: Pointer): Variant;
begin
  Result := TDOMDocumentType(Instance).PublicID;
end;

function TXMLImport.DOMDocumentType_SystemID(Instance: Pointer): Variant;
begin
  Result := TDOMDocumentType(Instance).SystemID;
end;

function TXMLImport.DOMDocument_CreateAttribute(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TDOMDocument(Instance).CreateAttribute(S));
end;

function TXMLImport.DOMDocument_CreateAttributeNS(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TSuPtr(TDOMDocument(Instance).CreateAttributeNS(S1, S2));
end;

function TXMLImport.DOMDocument_CreateCDATASection(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TDOMDocument(Instance).CreateCDATASection(S));
end;

function TXMLImport.DOMDocument_CreateComment(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TDOMDocument(Instance).CreateComment(S));
end;

function TXMLImport.DOMDocument_CreateDocumentFragment(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TDOMDocument(Instance).CreateDocumentFragment);
end;

function TXMLImport.DOMDocument_CreateElement(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr( TDOMDocument(Instance).CreateElement(S) );
end;

function TXMLImport.DOMDocument_CreateElementNS(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TSuPtr(TDOMDocument(Instance).CreateElementNS(S1, S2));
end;

function TXMLImport.DOMDocument_CreateEntityReference(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TDOMDocument(Instance).CreateEntityReference(S));
end;

function TXMLImport.DOMDocument_CreateProcessingInstruction(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TSuPtr(TDOMDocument(Instance).CreateProcessingInstruction(S1, S2));
end;

function TXMLImport.DOMDocument_CreateTextNode(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TDOMDocument(Instance).CreateTextNode(S));
end;

function TXMLImport.DOMDocument_documentURIGet(Instance: Pointer): Variant;
begin
  Result := TDOMDocument(Instance).documentURI;
end;

procedure TXMLImport.DOMDocument_documentURISet(Instance: Pointer;
  AValue: Variant);
begin
  TDOMDocument(Instance).documentURI:= AValue;
end;

function TXMLImport.DOMDocument_GetDocType(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMDocument(Instance).DocType);
end;

function TXMLImport.DOMDocument_GetDocumentElement(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMDocument(Instance).DocumentElement);
end;

function TXMLImport.DOMDocument_GetElementById(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TDOMDocument(Instance).GetElementById(S));
end;

function TXMLImport.DOMDocument_GetElementsByTagName(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TDOMDocument(Instance).GetElementsByTagName(S));
end;

function TXMLImport.DOMDocument_GetElementsByTagNameNS(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: String;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TSuPtr(TDOMDocument(Instance).GetElementsByTagNameNS(S1, S2));
end;

function TXMLImport.DOMDocument_GetImpl(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMDocument(Instance).Impl);
end;

function TXMLImport.DOMDocument_GetXMLVersion(Instance: Pointer): Variant;
begin
  Result := TDOMDocument(Instance).XMLVersion;
end;

function TXMLImport.DOMDocument_ImportNode(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TDOMDocument(Instance).ImportNode(TDOMNode(TSuPtr(Params[0])), Params[1]));
end;

function TXMLImport.DOMDocument_IndexOfNS(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TDOMDocument(Instance).IndexOfNS(S, Params[1]);
end;

procedure TXMLImport.DOMDocument_SetXMLVersion(Instance: Pointer;
  AValue: Variant);
begin
  TDOMDocument(Instance).XMLVersion:= AValue;
end;

function TXMLImport.DOMDocument_XMLStandaloneGet(Instance: Pointer): Variant;
begin
  Result := TDOMDocument(Instance).XMLStandalone;
end;

procedure TXMLImport.DOMDocument_XMLStandaloneSet(Instance: Pointer;
  AValue: Variant);
begin
  TDOMDocument(Instance).XMLStandalone := AValue;
end;

function TXMLImport.DOMElement_AttribStringsGet(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
  US: UnicodeString;
begin
  S := Params[0];
  Result := TDOMElement(Instance).AttribStrings[S];
end;

function TXMLImport.DOMElement_AttribStringsSet(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  TDOMElement(Instance).AttribStrings[S1] := S2;
end;

function TXMLImport.DOMElement_GetAttribute(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TDOMElement(Instance).GetAttribute(S);
end;

function TXMLImport.DOMElement_GetAttributeNode(Instance: TObject;
  var Params: Variant): Variant;
var
  S: String;
begin
  S := Params[0];
  Result := TSuPtr(TDOMElement(Instance).GetAttributeNode(S));
end;

function TXMLImport.DOMElement_GetAttributeNodeNS(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: String;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TSuPtr( TDOMElement(Instance).GetAttributeNodeNS(S1, S2) );
end;

function TXMLImport.DOMElement_GetAttributeNS(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: String;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TDOMElement(Instance).GetAttributeNS(S1, S2);
end;

function TXMLImport.DOMElement_GetElementsByTagName(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr( TDOMElement(Instance).GetElementsByTagName(S) );
end;

function TXMLImport.DOMElement_GetElementsByTagNameNS(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TSuPtr(TDOMElement(Instance).GetElementsByTagNameNS(S1, S2));
end;

function TXMLImport.DOMElement_hasAttribute(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TDOMElement(Instance).hasAttribute(S);
end;

function TXMLImport.DOMElement_hasAttributeNS(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TDOMElement(Instance).hasAttributeNS(S1, S2);
end;

function TXMLImport.DOMElement_RemoveAttribute(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TDOMElement(Instance).RemoveAttribute(S);
end;

function TXMLImport.DOMElement_RemoveAttributeNode(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TDOMElement(Instance).RemoveAttributeNode(TDOMAttr(TSuPtr(Params[0]))) );
end;

function TXMLImport.DOMElement_RemoveAttributeNS(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  TDOMElement(Instance).RemoveAttributeNS(S1, S2);
end;

function TXMLImport.DOMElement_SetAttribute(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  TDOMElement(Instance).SetAttribute(S1, S2);
end;

function TXMLImport.DOMElement_SetAttributeNode(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TDOMElement(Instance).SetAttributeNode(TDOMAttr(TSuPtr(Params[0]))));
end;

function TXMLImport.DOMElement_SetAttributeNodeNS(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TDOMElement(Instance).SetAttributeNodeNS(TDOMAttr(TSuPtr(Params[0]))) );
end;

function TXMLImport.DOMElement_SetAttributeNS(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2, S3: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  S3 := Params[2];
  TDOMElement(Instance).SetAttributeNS(S1, S2, S3);
end;

function TXMLImport.DOMElement_TagName(Instance: Pointer): Variant;
begin
  Result := TDOMElement(Instance).TagName;
end;

function TXMLImport.DOMEntity_NotationName(Instance: Pointer): Variant;
begin
  Result := TDOMEntity(Instance).NotationName;
end;

function TXMLImport.DOMEntity_PublicID(Instance: Pointer): Variant;
begin
  Result := TDOMEntity(Instance).PublicID;
end;

function TXMLImport.DOMEntity_SystemID(Instance: Pointer): Variant;
begin
  Result := TDOMEntity(Instance).SystemID;
end;

function TXMLImport.DOMEntity_XMLVersion(Instance: Pointer): Variant;
begin
  Result := TDOMEntity(Instance).XMLVersion;
end;

function TXMLImport.DOMImplementation_CreateDocument(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TSuPtr(TDOMImplementation(Instance).CreateDocument(S1, S2, TDOMDocumentType(TSuPtr(Params[2]))));
end;

function TXMLImport.DOMImplementation_CreateDocumentType(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2, S3: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  S3 := Params[2];
  Result := TSuPtr(TDOMImplementation(Instance).CreateDocumentType(S1, S2, S3));
end;

function TXMLImport.DOMImplementation_HasFeature(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TDOMImplementation(Instance).HasFeature(S1, S2);
end;

function TXMLImport.DOMNamedNodeMap_GetLength(Instance: Pointer): Variant;
begin
  Result := TDOMNamedNodeMap(Instance).Length;
end;

function TXMLImport.DOMNamedNodeMap_GetNamedItem(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TDOMNamedNodeMap(Instance).GetNamedItem(S));
end;

function TXMLImport.DOMNamedNodeMap_getNamedItemNS(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TSuPtr(TDOMNamedNodeMap(Instance).getNamedItemNS(S1, S2));
end;

function TXMLImport.DOMNamedNodeMap_ItemGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TDOMNamedNodeMap(Instance).Item[Params[0]]);
end;

function TXMLImport.DOMNamedNodeMap_RemoveNamedItem(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TDOMNamedNodeMap(Instance).RemoveNamedItem(S));
end;

function TXMLImport.DOMNamedNodeMap_removeNamedItemNS(Instance: TObject;
  var Params: Variant): Variant;
var
    S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TSuPtr(TDOMNamedNodeMap(Instance).removeNamedItemNS(S1, S2));
end;

function TXMLImport.DOMNamedNodeMap_SetNamedItem(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TDOMNamedNodeMap(Instance).SetNamedItem(TDOMNode(TSuPtr(Params[0]))));
end;

function TXMLImport.DOMNamedNodeMap_setNamedItemNS(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TDOMNamedNodeMap(Instance).setNamedItemNS(TDOMNode(TSuPtr(Params[0]))));
end;

function TXMLImport.DOMNodeList_GetCount(Instance: Pointer): Variant;
begin
  Result := TDOMNodeList(Instance).Count;
end;

function TXMLImport.DOMNodeList_ItemGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TDOMNodeList(Instance).Item[Params[0]]);
end;

function TXMLImport.DOMNode_AppendChild(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).AppendChild(TDOMNode(TSuPtr(Params[0]))));
end;

function TXMLImport.DOMNode_ChildNodesGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).ChildNodes);
end;

function TXMLImport.DOMNode_CloneNode(Instance: TObject; var Params: Variant
  ): Variant;
var
  Deep: Boolean;
  ACloneOwner: TDOMDocument;
begin
  Deep:= Params[0];
  ACloneOwner := TDOMDocument(TSuPtr(Params[1]));
  Result := TSuPtr(TDOMNode(Instance).CloneNode(Deep, ACloneOwner));
end;

function TXMLImport.DOMNode_CompareName(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TDOMNode(Instance).CompareName(S);
end;

function TXMLImport.DOMNode_DetachChild(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).DetachChild(TDOMNode(TSuPtr(Params[0]))));
end;

function TXMLImport.DOMNode_FindNode(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TDOMNode(Instance).FindNode(S));
end;

function TXMLImport.DOMNode_FirstChildGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).FirstChild);
end;

function TXMLImport.DOMNode_FlagsGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(@TDOMNode(Instance).Flags);
end;

function TXMLImport.DOMNode_GetAttributes(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).Attributes);
end;

function TXMLImport.DOMNode_GetBaseURI(Instance: Pointer): Variant;
begin
  Result := TDOMNode(Instance).baseURI;
end;

function TXMLImport.DOMNode_GetChildNodes(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).GetChildNodes);
end;

function TXMLImport.DOMNode_GetLastChild(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).LastChild);
end;

function TXMLImport.DOMNode_GetLocalName(Instance: Pointer): Variant;
begin
  Result := TDOMNode(Instance).LocalName;
end;

function TXMLImport.DOMNode_GetNamespaceURI(Instance: Pointer): Variant;
begin
  Result := TDOMNode(Instance).NamespaceURI;
end;

function TXMLImport.DOMNode_GetOwnerDocument(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).OwnerDocument);
end;

function TXMLImport.DOMNode_GetPrefix(Instance: Pointer): Variant;
begin
  Result := TDOMNode(Instance).Prefix;
end;

function TXMLImport.DOMNode_GetTextContent(Instance: Pointer): Variant;
begin
  Result := TDOMNode(Instance).TextContent;
end;

function TXMLImport.DOMNode_HasAttributes(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TDOMNode(Instance).HasAttributes;
end;

function TXMLImport.DOMNode_HasChildNodes(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TDOMNode(Instance).HasChildNodes;
end;

function TXMLImport.DOMNode_InsertBefore(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).InsertBefore(TDOMNode(TSuPtr(Params[0])), TDOMNode(TSuPtr(Params[1]))));
end;

function TXMLImport.DOMNode_IsDefaultNamespace(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TDOMNode(Instance).IsDefaultNamespace(S);
end;

function TXMLImport.DOMNode_IsSupported(Instance: TObject; var Params: Variant
  ): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  Result := TDOMNode(Instance).IsSupported(S1, S2);
end;

function TXMLImport.DOMNode_LookupNamespaceURI(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TDOMNode(Instance).LookupNamespaceURI(S);
end;

function TXMLImport.DOMNode_LookupPrefix(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TDOMNode(Instance).LookupPrefix(S);
end;

function TXMLImport.DOMNode_NextSiblingGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).NextSibling);
end;

function TXMLImport.DOMNode_NodeNameGet(Instance: Pointer): Variant;
begin
  Result := TDOMNode(Instance).NodeName;
end;

function TXMLImport.DOMNode_NodeTypeGet(Instance: Pointer): Variant;
begin
  Result := TDOMNode(Instance).NodeType;
end;

function TXMLImport.DOMNode_NodeValueGet(Instance: Pointer): Variant;
begin
  Result := TDOMNode(Instance).NodeValue;
end;

procedure TXMLImport.DOMNode_NodeValueSet(Instance: Pointer; AValue: Variant);
var
  S: string;
begin
  S := AValue;
  TDOMNode(Instance).NodeValue := S;
end;

function TXMLImport.DOMNode_Normalize(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TDOMNode(Instance).Normalize;
end;

function TXMLImport.DOMNode_ParentNodeGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).ParentNode);
end;

function TXMLImport.DOMNode_PreviousSiblingGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).PreviousSibling);
end;

function TXMLImport.DOMNode_RemoveChild(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).RemoveChild(TDOMNode(TSuPtr(Params[0]))));
end;

function TXMLImport.DOMNode_ReplaceChild(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TDOMNode(Instance).ReplaceChild(TDOMNode(TSuPtr(Params[0])), TDOMNode(TSuPtr(Params[1]))));
end;

procedure TXMLImport.DOMNode_SetPrefix(Instance: Pointer; AValue: Variant);
begin
  TDOMNode(Instance).Prefix := AValue;
end;

procedure TXMLImport.DOMNode_SetTextContent(Instance: Pointer; AValue: Variant);
var
  S: string;
begin
  S := AValue;
  TDOMNode(Instance).TextContent := S;
end;

function TXMLImport.DOMNode_TopLevel_InputEncoding(Instance: Pointer): Variant;
begin
  Result := TDOMNode_TopLevel(Instance).InputEncoding;
end;

function TXMLImport.DOMNode_TopLevel_XMLEncoding(Instance: Pointer): Variant;
begin
  Result := TDOMNode_TopLevel(Instance).XMLEncoding;
end;

function TXMLImport.DOMNode_WithChilder_InternalAppend(Instance: TObject;
  var Params: Variant): Variant;
begin
  TDOMNode_WithChildren(Instance).InternalAppend(TDOMNode(TSuPtr(Params[0])));
end;

function TXMLImport.DOMNotation_PublicID(Instance: Pointer): Variant;
begin
  Result := TDOMNotation(Instance).PublicID;
end;

function TXMLImport.DOMNotation_SystemID(Instance: Pointer): Variant;
begin
  Result := TDOMNotation(Instance).SystemID;
end;

function TXMLImport.DOMProcessingInstruction_Data(Instance: Pointer): Variant;
begin
  Result := TDOMProcessingInstruction(Instance).Data;
end;

function TXMLImport.DOMProcessingInstruction_Target(Instance: Pointer): Variant;
begin
  Result := TDOMProcessingInstruction(Instance).Target;
end;

function TXMLImport.DOMText_IsElementContentWhitespace(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TDOMText(Instance).IsElementContentWhitespace;
end;

function TXMLImport.DOMText_SplitText(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TDOMText(Instance).SplitText(Params[0]) );
end;

function TXMLImport.Call_ReadXMLFile(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
  Doc: TXMLDocument;
begin
  S := Params[1];
  ReadXMLFile(Doc, S);
  Params[0] := TSuPtr(Doc);
end;

function TXMLImport.Call_ReadXMLFromStream(Instance: TObject;
  var Params: Variant): Variant;
var
  Doc: TXMLDocument;
  Strm: TStream;
begin
  Strm := TStream(TSuPtr(Params[1]));
  ReadXMLFile(Doc, Strm);
  Params[0] := TSuPtr(Doc);
end;

function TXMLImport.Call_ReadXMLFromStreamURI(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
  Doc: TXMLDocument;
begin
  S := Params[2];
  ReadXMLFile(Doc, TStream(TSuPtr(Params[1])), S);
  Params[0] := TSuPtr(Doc);
end;

function TXMLImport.Call_ReadXMLFragment(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[1];
  ReadXMLFragment(TDOMNode(TSuPtr(Params[0])), S);
end;

function TXMLImport.Call_ReadXMLFragmentFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  ReadXMLFragment(TDOMNode(TSuPtr(Params[0])), TStream(TSuPtr(Params[1])));
end;

function TXMLImport.Call_ReadXMLFragmentFromStreamURI(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[2];
  ReadXMLFragment(TDOMNode(TSuPtr(Params[0])), TStream(TSuPtr(Params[1])), S);
end;

function TXMLImport.Call_ReadDTDFile(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
  Doc: TXMLDocument;
begin
  S := Params[1];
  ReadDTDFile(Doc, S);
  Params[0] := TSuPtr(Doc);
end;

function TXMLImport.Call_ReadDTDStream(Instance: TObject; var Params: Variant
  ): Variant;
var
  Doc: TXMLDocument;
begin
  ReadDTDFile(Doc, TStream(TSuPtr(Params[1])));
  Params[0] := TSuPtr(Doc);
end;

function TXMLImport.Call_ReadDTDStreamURI(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
  Doc: TXMLDocument;
begin
  S := Params[2];
  ReadDTDFile(Doc, TStream(TSuPtr(Params[1])), S);
  Params[0] := TSuPtr(Doc);
end;

function TXMLImport.Call_WriteXMLFile(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[1];
  WriteXMLFile(TXMLDocument(TSuPtr(Params[0])), S);
end;

function TXMLImport.Call_WriteXMLInStream(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: TStream;
begin
  S := TStream(TSuPtr(Params[1]));
  WriteXMLFile(TXMLDocument(TSuPtr(Params[0])), S);
end;

function TXMLImport.Call_WriteXMLElement(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[1];
  WriteXML(TDOMNode(TSuPtr(Params[0])), S);
end;

function TXMLImport.Call_WriteXMLElementStram(Instance: TObject;
  var Params: Variant): Variant;
var
  S: TStream;
begin
  S := TStream(TSuPtr(Params[1]));
  WriteXML(TDOMNode(TSuPtr(Params[0])), S);
end;

function TXMLImport.XMLDocument_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TXMLDocument.Create);
end;

procedure TXMLImport.AddMethods(AddMethod: TAddMethodProc);
begin
  AddMethod('procedure ReadXMLFile(out ADoc: TXMLDocument; const AFilename: String)', @Call_ReadXMLFile);
  AddMethod('procedure ReadXMLFromStream(out ADoc: TXMLDocument; f: TStream)', @Call_ReadXMLFromStream);
  AddMethod('procedure ReadXMLFromStreamURI(out ADoc: TXMLDocument; f: TStream; const ABaseURI: String)', @Call_ReadXMLFromStreamURI);

  AddMethod('procedure ReadXMLFragment(AParentNode: TDOMNode; const AFilename: String)', @Call_ReadXMLFragment);
  AddMethod('procedure ReadXMLFragmentFromStream(AParentNode: TDOMNode; f: TStream)', @Call_ReadXMLFragmentFromStream);
  AddMethod('procedure ReadXMLFragmentFromStreamURI(AParentNode: TDOMNode; f: TStream; const ABaseURI: String)', @Call_ReadXMLFragmentFromStreamURI);

  AddMethod('procedure ReadDTDFile(out ADoc: TXMLDocument; const AFilename: String)', @Call_ReadDTDFile);
  AddMethod('procedure ReadDTDStream(out ADoc: TXMLDocument; f: TStream)', @Call_ReadDTDStream);
  AddMethod('procedure ReadDTDStreamURI(out ADoc: TXMLDocument; f: TStream; const ABaseURI: String)', @Call_ReadDTDStreamURI);

  AddMethod('procedure WriteXMLFile(doc: TXMLDocument; const AFileName: String)', @Call_WriteXMLFile);
  AddMethod('procedure WriteXMLInStream(doc: TXMLDocument; AStream: TStream)', @Call_WriteXMLInStream);

  AddMethod('procedure WriteXMLElement(Element: TDOMNode; const AFileName: String)', @Call_WriteXMLElement);
  AddMethod('procedure WriteXMLElementStram(Element: TDOMNode; AStream: TStream)', @Call_WriteXMLElementStram);
end;

procedure TXMLImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TNodeFlagEnum));
  AddType(TypeInfo(TNodeFlags));
  AddType(TypeInfo(TFilterResult));
  AddType(TypeInfo(TAttrDataType));
end;

procedure TXMLImport.AddSimpleTypes(AddType: TAddSimpleTypeProc);
begin
  AddType('DOMString', btString);
end;

procedure TXMLImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddClass(TDOMNode).ClassImporter := Self;
  AddClass(TDOMNode_WithChildren).ClassImporter := Self;
  AddClass(TDOMNode_TopLevel).ClassImporter := Self;
  AddClass(TDOMElement).ClassImporter := Self;
  AddClass(TDOMNodeList).ClassImporter := Self;
  AddClass(TDOMElementList);
  AddClass(TDOMNamedNodeMap).ClassImporter := Self;
  AddClass(TDOMCharacterData).ClassImporter := Self;
  AddClass(TDOMDocument).ClassImporter := Self;
  AddClass(TDOMDocumentFragment);
  AddClass(TXMLDocument).ClassImporter := Self;
  AddClass(TDOMAttr).ClassImporter := Self;
  AddClass(TDOMElement).ClassImporter := Self;
  AddClass(TDOMText).ClassImporter := Self;
  AddClass(TDOMCDATASection);
  AddClass(TDOMComment);

  AddClass(TDOMDocumentType).ClassImporter := Self;
  AddClass(TDOMNotation).ClassImporter := Self;
  AddClass(TDOMEntity).ClassImporter := Self;
  AddClass(TDOMEntityReference);
  AddClass(TDOMImplementation).ClassImporter := Self;
  AddClass(TDOMProcessingInstruction).ClassImporter := Self;
end;

procedure TXMLImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TDOMNode then
  begin
    AType.AddMethod('function GetChildNodes: TDOMNodeList', @DOMNode_GetChildNodes);
    AType.AddMethod('function InsertBefore(NewChild, RefChild: TDOMNode): TDOMNode', @DOMNode_InsertBefore);
    AType.AddMethod('function ReplaceChild(NewChild, OldChild: TDOMNode): TDOMNode', @DOMNode_ReplaceChild);
    AType.AddMethod('function DetachChild(OldChild: TDOMNode): TDOMNode', @DOMNode_DetachChild);
    AType.AddMethod('function RemoveChild(OldChild: TDOMNode): TDOMNode', @DOMNode_RemoveChild);
    AType.AddMethod('function AppendChild(NewChild: TDOMNode): TDOMNode', @DOMNode_AppendChild);
    AType.AddMethod('function HasChildNodes: Boolean', @DOMNode_HasChildNodes);
    AType.AddMethod('function CloneNode(deep: Boolean; ACloneOwner: TDOMDocument): TDOMNode', @DOMNode_CloneNode);
    AType.AddMethod('function IsSupported(const Feature, Version: DOMString): Boolean', @DOMNode_IsSupported);
    AType.AddMethod('function HasAttributes: Boolean', @DOMNode_HasAttributes);
    AType.AddMethod('procedure Normalize', @DOMNode_Normalize);
    AType.AddMethod('function LookupPrefix(const nsURI: DOMString): DOMString', @DOMNode_LookupPrefix);
    AType.AddMethod('function LookupNamespaceURI(const APrefix: DOMString): DOMString', @DOMNode_LookupNamespaceURI);
    AType.AddMethod('function IsDefaultNamespace(const nsURI: DOMString): Boolean', @DOMNode_IsDefaultNamespace);
    AType.AddMethod('function FindNode(const ANodeName: DOMString): TDOMNode', @DOMNode_FindNode);
    AType.AddMethod('function CompareName(const name: DOMString): Integer', @DOMNode_CompareName);

    AType.AddProp('NodeName', 'DOMString', @DOMNode_NodeNameGet);
    AType.AddProp('NodeValue', 'DOMString', @DOMNode_NodeValueGet, @DOMNode_NodeValueSet);
    AType.AddProp('NodeType', 'Integer', @DOMNode_NodeTypeGet);
    AType.AddProp('ParentNode', 'TDOMNode', @DOMNode_ParentNodeGet);
    AType.AddProp('FirstChild', 'TDOMNode', @DOMNode_FirstChildGet);
    AType.AddProp('LastChild', 'TDOMNode', @DOMNode_GetLastChild);
    AType.AddProp('ChildNodes', 'TDOMNodeList', @DOMNode_ChildNodesGet);
    AType.AddProp('PreviousSibling', 'TDOMNode', @DOMNode_PreviousSiblingGet);
    AType.AddProp('NextSibling', 'TDOMNode', @DOMNode_NextSiblingGet);
    AType.AddProp('Attributes', 'TDOMNamedNodeMap', @DOMNode_GetAttributes);
    AType.AddProp('OwnerDocument', 'TDOMDocument', @DOMNode_GetOwnerDocument);
    AType.AddProp('NamespaceURI', 'DOMString', @DOMNode_GetNamespaceURI);
    AType.AddProp('LocalName', 'DOMString', @DOMNode_GetLocalName);
    AType.AddProp('Prefix', 'DOMString', @DOMNode_GetPrefix, @DOMNode_SetPrefix);
    AType.AddProp('TextContent', 'DOMString', @DOMNode_GetTextContent, @DOMNode_SetTextContent);
    AType.AddProp('baseURI', 'DOMString', @DOMNode_GetBaseURI);
    AType.AddProp('Flags', 'TNodeFlags', @DOMNode_FlagsGet);
  end
  else
  if AType.ValueClassType = TDOMNode_WithChildren then
  begin
    AType.AddMethod('procedure InternalAppend(NewChild: TDOMNode)', @DOMNode_WithChilder_InternalAppend);
  end
  else
  if AType.ValueClassType = TDOMNode_TopLevel then
  begin
    AType.AddProp('InputEncoding', 'DOMString', @DOMNode_TopLevel_InputEncoding);
    AType.AddProp('XMLEncoding', 'DOMString', @DOMNode_TopLevel_XMLEncoding);
  end
  else
  if AType.ValueClassType = TDOMNodeList then
  begin
    AType.AddProp('Count', 'LongWord', @DOMNodeList_GetCount);
    AType.AddProp('Length', 'LongWord', @DOMNodeList_GetCount);
    AType.AddIndexedProp('Item', 'TDOMNode', 'LongWord', @DOMNodeList_ItemGet);
  end
  else
  if AType.ValueClassType = TDOMNamedNodeMap then
  begin
    AType.AddMethod('function GetNamedItem(const name: DOMString): TDOMNode', @DOMNamedNodeMap_GetNamedItem);
    AType.AddMethod('function SetNamedItem(arg: TDOMNode): TDOMNode', @DOMNamedNodeMap_SetNamedItem);
    AType.AddMethod('function RemoveNamedItem(const name: DOMString): TDOMNode', @DOMNamedNodeMap_RemoveNamedItem);
    AType.AddMethod('function getNamedItemNS(const namespaceURI, localName: DOMString): TDOMNode', @DOMNamedNodeMap_getNamedItemNS);
    AType.AddMethod('function setNamedItemNS(arg: TDOMNode): TDOMNode', @DOMNamedNodeMap_setNamedItemNS);
    AType.AddMethod('function removeNamedItemNS(const namespaceURI,localName: DOMString): TDOMNode', @DOMNamedNodeMap_removeNamedItemNS);

    AType.AddProp('Length', 'LongWord', @DOMNamedNodeMap_GetLength);
    AType.AddIndexedProp('Item', 'TDOMNode', 'LongWord', @DOMNamedNodeMap_ItemGet);
  end
  else
  if AType.ValueClassType = TDOMCharacterData then
  begin
    AType.AddProp('Length', 'LongWord', @DOMCharacterData_GetLength);
    AType.AddProp('Data', 'DOMString', @DOMCharacterData_GetData, @DOMCharacterData_SetData);
    AType.AddMethod('function SubstringData(offset, count: LongWord): DOMString', @DOMCharacterData_SubstringData);
    AType.AddMethod('procedure AppendData(const arg: DOMString)', @DOMCharacterData_AppendData);
    AType.AddMethod('procedure InsertData(offset: LongWord; const arg: DOMString)', @DOMCharacterData_InsertData);
    AType.AddMethod('procedure DeleteData(offset, count: LongWord)', @DOMCharacterData_DeleteData);
    AType.AddMethod('procedure ReplaceData(offset, count: LongWord; const arg: DOMString)', @DOMCharacterData_ReplaceData);
  end
  else
  if AType.ValueClassType = TDOMImplementation then
  begin
    AType.AddMethod('function HasFeature(const feature, version: DOMString): Boolean', @DOMImplementation_HasFeature);
    AType.AddMethod('function CreateDocumentType(const QualifiedName, PublicID, SystemID: DOMString): TDOMDocumentType', @DOMImplementation_CreateDocumentType);
    AType.AddMethod('function CreateDocument(const NamespaceURI, QualifiedName: DOMString; doctype: TDOMDocumentType): TDOMDocument', @DOMImplementation_CreateDocument);
  end
  else
  if AType.ValueClassType = TDOMDocument then
  begin
    AType.AddMethod('function IndexOfNS(const nsURI: DOMString; AddIfAbsent: Boolean = False): Integer', @DOMDocument_IndexOfNS);
    AType.AddMethod('function CreateElement(const tagName: DOMString): TDOMElement', @DOMDocument_CreateElement);
    AType.AddMethod('function CreateDocumentFragment: TDOMDocumentFragment', @DOMDocument_CreateDocumentFragment);
    AType.AddMethod('function CreateTextNode(const data: DOMString): TDOMText', @DOMDocument_CreateTextNode);
    AType.AddMethod('function CreateComment(const data: DOMString): TDOMComment', @DOMDocument_CreateComment);
    AType.AddMethod('function CreateCDATASection(const data: DOMString): TDOMCDATASection', @DOMDocument_CreateCDATASection);
    AType.AddMethod('function CreateProcessingInstruction(const target, data: DOMString): TDOMProcessingInstruction', @DOMDocument_CreateProcessingInstruction);
    AType.AddMethod('function CreateAttribute(const name: DOMString): TDOMAttr', @DOMDocument_CreateAttribute);
    AType.AddMethod('function CreateEntityReference(const name: DOMString): TDOMEntityReference', @DOMDocument_CreateEntityReference);
    AType.AddMethod('function GetElementsByTagName(const tagname: DOMString): TDOMNodeList', @DOMDocument_GetElementsByTagName);
    AType.AddMethod('function ImportNode(ImportedNode: TDOMNode; Deep: Boolean): TDOMNode', @DOMDocument_ImportNode);
    AType.AddMethod('function CreateElementNS(const nsURI, QualifiedName: DOMString): TDOMElement', @DOMDocument_CreateElementNS);
    AType.AddMethod('function CreateAttributeNS(const nsURI, QualifiedName: DOMString): TDOMAttr', @DOMDocument_CreateAttributeNS);
    AType.AddMethod('function GetElementsByTagNameNS(const nsURI, alocalName: DOMString): TDOMNodeList', @DOMDocument_GetElementsByTagNameNS);
    AType.AddMethod('function GetElementById(const ElementID: DOMString): TDOMElement', @DOMDocument_GetElementById);
    AType.AddProp('DocType', 'TDOMDocumentType', @DOMDocument_GetDocType);
    AType.AddProp('Impl', 'TDOMImplementation', @DOMDocument_GetImpl);
    AType.AddProp('DocumentElement', 'TDOMElement', @DOMDocument_GetDocumentElement);
    AType.AddProp('documentURI', 'DOMString', @DOMDocument_documentURIGet, @DOMDocument_documentURISet);
    AType.AddProp('XMLVersion', 'DOMString', @DOMDocument_GetXMLVersion, @DOMDocument_SetXMLVersion);
    AType.AddProp('XMLStandalone', 'Boolean', @DOMDocument_XMLStandaloneGet, @DOMDocument_XMLStandaloneSet);
  end
  else
  if AType.ValueClassType = TXMLDocument then
  begin
    AType.AddMethod('constructor Create', @XMLDocument_Create);
  end
  else
  if AType.ValueClassType = TDOMAttr then
  begin
    AType.AddProp('Name', 'DOMString', @DOMAttr_Name);
    AType.AddProp('Specified', 'Boolean', @DOMAttr_Specified);
    AType.AddProp('Value', 'DOMString', @DOMAttr_ValueGet, @DOMAttr_ValueSet);
    AType.AddProp('OwnerElement', 'TDOMElement', @DOMAttr_OwnerElement);
    AType.AddProp('IsID', 'Boolean', @DOMAttr_IsID);
    AType.AddProp('DataType', 'TAttrDataType', @DOMAttr_DataTypeGet, @DOMAttr_DataTypeSet);
  end
  else
  if AType.ValueClassType = TDOMElement then
  begin
    AType.AddMethod('function  GetAttribute(const name: DOMString): DOMString', @DOMElement_GetAttribute);
    AType.AddMethod('procedure SetAttribute(const name, value: DOMString)', @DOMElement_SetAttribute);
    AType.AddMethod('procedure RemoveAttribute(const name: DOMString)', @DOMElement_RemoveAttribute);
    AType.AddMethod('function  GetAttributeNode(const name: DOMString): TDOMAttr', @DOMElement_GetAttributeNode);
    AType.AddMethod('function SetAttributeNode(NewAttr: TDOMAttr): TDOMAttr', @DOMElement_SetAttributeNode);
    AType.AddMethod('function RemoveAttributeNode(OldAttr: TDOMAttr): TDOMAttr', @DOMElement_RemoveAttributeNode);
    AType.AddMethod('function  GetElementsByTagName(const name: DOMString): TDOMNodeList', @DOMElement_GetElementsByTagName);
    AType.AddMethod('function GetAttributeNS(const nsURI, aLocalName: DOMString): DOMString', @DOMElement_GetAttributeNS);
    AType.AddMethod('procedure SetAttributeNS(const nsURI, qualifiedName, value: DOMString)', @DOMElement_SetAttributeNS);
    AType.AddMethod('procedure RemoveAttributeNS(const nsURI, aLocalName: DOMString)', @DOMElement_RemoveAttributeNS);
    AType.AddMethod('function GetAttributeNodeNS(const nsURI, aLocalName: DOMString): TDOMAttr', @DOMElement_GetAttributeNodeNS);
    AType.AddMethod('function SetAttributeNodeNS(newAttr: TDOMAttr): TDOMAttr', @DOMElement_SetAttributeNodeNS);
    AType.AddMethod('function GetElementsByTagNameNS(const nsURI, aLocalName: DOMString): TDOMNodeList', @DOMElement_GetElementsByTagNameNS);
    AType.AddMethod('function hasAttribute(const name: DOMString): Boolean', @DOMElement_hasAttribute);
    AType.AddMethod('function hasAttributeNS(const nsURI, aLocalName: DOMString): Boolean', @DOMElement_hasAttributeNS);
    AType.AddMethod('function FindElement(aName: DOMString): TDomElement', @DOMNode_FindNode);

    AType.AddProp('TagName', 'DOMString', @DOMElement_TagName);
    AType.AddIndexedProp('AttribStrings', 'DOMString', 'DOMString', @DOMElement_AttribStringsGet, @DOMElement_AttribStringsSet);
  end
  else
  if AType.ValueClassType = TDOMText then
  begin
    AType.AddMethod('function SplitText(offset: LongWord): TDOMText', @DOMText_SplitText);
    AType.AddMethod('function IsElementContentWhitespace: Boolean', @DOMText_IsElementContentWhitespace);
  end
  else
  if AType.ValueClassType = TDOMDocumentType then
  begin
    AType.AddProp('Name', 'DOMString', @DOMDocumentType_Name);
    AType.AddProp('Entities', 'TDOMNamedNodeMap', @DOMDocumentType_Entities);
    AType.AddProp('Notations', 'TDOMNamedNodeMap', @DOMDocumentType_Notations);
    AType.AddProp('PublicID', 'DOMString', @DOMDocumentType_PublicID);
    AType.AddProp('SystemID', 'DOMString', @DOMDocumentType_SystemID);
    AType.AddProp('InternalSubset', 'DOMString', @DOMDocumentType_InternalSubset);
  end
  else
  if AType.ValueClassType = TDOMNotation then
  begin
    AType.AddProp('PublicID', 'DOMString', @DOMNotation_PublicID);
    AType.AddProp('SystemID', 'DOMString', @DOMNotation_SystemID);
  end
  else
  if AType.ValueClassType = TDOMEntity then
  begin
    AType.AddProp('PublicID', 'DOMString', @DOMEntity_PublicID);
    AType.AddProp('SystemID', 'DOMString', @DOMEntity_SystemID);
    AType.AddProp('NotationName', 'DOMString', @DOMEntity_NotationName);
    AType.AddProp('XMLVersion', 'DOMString', @DOMEntity_XMLVersion);
  end
  else
  if AType.ValueClassType = TDOMProcessingInstruction then
  begin
    AType.AddProp('Target', 'DOMString', @DOMProcessingInstruction_Target);
    AType.AddProp('Data', 'DOMString', @DOMProcessingInstruction_Data);
  end;
end;

end.

