unit dpi_VisualTech;

{$mode objfpc}{$H+}

interface

uses SysUtils, Classes, dpCompil, TypInfo, Variants, Controls;

type
  { TVisualTechImport }

  TVisualTechImport = class(TClassImporter)
    function BarCodeHook_BarCodeGet(Instance: Pointer): Variant;
    procedure BarCodeHook_BarCodeSet(Instance: Pointer; AValue: Variant);
    function CustomXDBGrid_ActivateFilter(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomXDBGrid_CheckSortingImage(Instance: TObject;
      var Params: Variant): Variant;
    function CustomXDBGrid_LocateStrGet(Instance: Pointer): Variant;
    procedure CustomXDBGrid_LocateStrSet(Instance: Pointer; AValue: Variant);
    function CustomXDBGrid_ResetFilter(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomXDBGrid_SelectedFieldGet(Instance: Pointer): Variant;
    procedure CustomXDBGrid_SelectedFieldSet(Instance: Pointer; AValue: Variant);

    function CustomXDBGrid_SelectedIndexGet(Instance: Pointer): Variant;
    procedure CustomXDBGrid_SelectedIndexSet(Instance: Pointer; AValue: Variant);

    function CustomXDBGrid_SelectedColumn(Instance: Pointer): Variant;
    function CustomXDBGrid_ShowFilterForm(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomXDBGrid_SortedFieldGet(Instance: Pointer): Variant;
    function FormsBar_ActivateForm(Instance: TObject; var Params: Variant
      ): Variant;
    function FormsBar_ActiveForm(Instance: Pointer): Variant;
    function FormsBar_AddForm(Instance: TObject; var Params: Variant): Variant;
    function FormsBar_CloseAll(Instance: TObject; var Params: Variant): Variant;
    function FormsBar_FormCount(Instance: Pointer): Variant;
    function FormsBar_InsertForm(Instance: TObject; var Params: Variant
      ): Variant;
    function FormsBar_InsertFormWithParent(Instance: TObject;
      var Params: Variant): Variant;
    function FormsBar_ItemsGet(Instance: TObject; var Params: Variant): Variant;
    function FormsBar_RemoveForm(Instance: TObject; var Params: Variant
      ): Variant;
    function FormsBar_ReplaceForm(Instance: TObject; var Params: Variant
      ): Variant;
    function FormsBar_SetActiveControl(Instance: TObject; var Params: Variant
      ): Variant;
    function xColumn_FieldGet(Instance: Pointer): Variant;
    procedure xColumn_FieldSet(Instance: Pointer; AValue: Variant);
    function xColumn_SortedGet(Instance: Pointer): Variant;
    procedure xColumn_SortedSet(Instance: Pointer; AValue: Variant);
    function xColumn_xFieldGet(Instance: Pointer): Variant;
    procedure xColumn_xFieldSet(Instance: Pointer; AValue: Variant);
    function xColumn_xSortedGet(Instance: Pointer): Variant;
    procedure xColumn_xSortedSet(Instance: Pointer; AValue: Variant);
    function xDBGridColumns_Add(Instence: TObject; var Params: Variant
      ): Variant;
    function xDBGridColumns_ItemsGet(Instence: TObject; var Params: Variant
      ): Variant;
    function xDBGridColumns_ItemsSet(Instence: TObject; var Params: Variant
      ): Variant;
    function xDBGridColumns_ResetSorted(Instance: TObject; var Params: Variant
      ): Variant;
    function XDBGrid_EditorModeGet(Instance: Pointer): Variant;
    procedure XDBGrid_EditorModeSet(Instance: Pointer; AValue: Variant);
  private
    function CustomXDBGrid_CellCursorPos(Instance: Pointer): Variant;
    function CustomXDBGrid_SelectedEditorRect(Instance: TObject;
      var Params: Variant): Variant;
    function CustomXGrid_ColGet(Instance: Pointer): Variant;
    function CustomXGrid_RowGet(Instance: Pointer): Variant;
    function FormsBar_FocusTimerEnabledGet(Instance: Pointer): Variant;
    procedure FormsBar_FocusTimerEnabledSet(Instance: Pointer; AValue: Variant);

  public
    EdtrRect: TRect;
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
       override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
  end;

implementation

uses xDBControls, XDBGrids, xGrids, db, xFormsBar, Forms, SuFrame, BarCodeHook;

type

  { TOnEditButtonClickHandler }

  TOnEditButtonClickHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Column: TxColumn; CCPos: TCellCursorPos);
  end;

  { TOnGetImageIndexFromField }

  TOnGetImageIndexFromFieldHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    function CallHandler(F: TField; ColIndex: integer): integer;
  end;

  { TxDBGridClickEventHandler }

  TxDBGridClickEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Column: TxColumn; CellPos: TCellCursorPos);
  end;

  { TxMovedEventHandler }

  TxMovedEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; FromIndex, ToIndex: integer);
  end;

  { TxDrawColumnCellEventHandler }

  TxDrawColumnCellEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; const Rect: TRect; DataCol: integer;
    Column: TxColumn; State: TxGridDrawState);
  end;

  {TSelectEditorEventHandler}

  TSelectEditorEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Column: TxColumn; var Editor: TWinControl);
  end;

function TSelectEditorEventHandler.GetHandlerAdres: Pointer;
begin
  Result:= @TSelectEditorEventHandler.CallHandler;
end;

procedure TSelectEditorEventHandler.CallHandler(Sender: TObject; Column: TxColumn; var Editor: TWinControl);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Column);
  Proc.Param[2].Value := TSuPtr(Editor);
  Proc.Exec;
  Editor := TWinControl(TSuPtr(Proc.Param[2].Value));
end;

{ TxDrawColumnCellEventHandler }

function TxDrawColumnCellEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TxDrawColumnCellEventHandler.CallHandler;
end;



procedure TxDrawColumnCellEventHandler.CallHandler(Sender: TObject;
  const Rect: TRect; DataCol: integer; Column: TxColumn; State: TxGridDrawState
  );
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(@Rect);
  Proc.Param[2].Value := DataCol;
  Proc.Param[3].Value := TSuPtr(Column);
  Proc.Param[3].Value := TSuPtr(@State);
  Proc.Exec;
end;

{ TxMovedEventHandler }

function TxMovedEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TxMovedEventHandler.CallHandler;
end;

procedure TxMovedEventHandler.CallHandler(Sender: TObject; FromIndex,
  ToIndex: integer);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := FromIndex;
  Proc.Param[2].Value := ToIndex;
  Proc.Exec;
end;

{ TxDBGridClickEventHandler }

function TxDBGridClickEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TxDBGridClickEventHandler.CallHandler;
end;

procedure TxDBGridClickEventHandler.CallHandler(Column: TxColumn;
  CellPos: TCellCursorPos);
begin
  Proc.Param[0].Value := TSuPtr(Column);
  Proc.Param[1].Value := CellPos;
  Proc.Exec;
end;

{ TOnGetImageIndexFromFieldHandler }

function TOnGetImageIndexFromFieldHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnGetImageIndexFromFieldHandler.CallHandler;
end;

function TOnGetImageIndexFromFieldHandler.CallHandler(F: TField; ColIndex: integer
  ): integer;
begin
  Proc.Param[0].Value := TSuPtr(F);
  Proc.Param[1].Value := ColIndex;
  Result := Proc.Value;
end;

{ TOnEditButtonClickHandler }

function TOnEditButtonClickHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnEditButtonClickHandler.CallHandler;
end;

procedure TOnEditButtonClickHandler.CallHandler(Sender: TObject;
  Column: TxColumn; CCPos: TCellCursorPos);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Column);
  Proc.Param[2].Value := CCPos;
  Proc.Exec;
end;

{ TVisualTechImport }

function TVisualTechImport.BarCodeHook_BarCodeGet(Instance: Pointer): Variant;
begin
  Result := TBarCodeHook(Instance).BarCode;
end;

procedure TVisualTechImport.BarCodeHook_BarCodeSet(Instance: Pointer;
  AValue: Variant);
begin
  TBarCodeHook(Instance).BarCode:= AValue;
end;

function TVisualTechImport.CustomXDBGrid_ActivateFilter(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomXDBGrid(Instance).ActivateFilter(Params[0], Params[1], Params[2], Params[3]);
end;

function TVisualTechImport.CustomXDBGrid_CheckSortingImage(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomXDBGrid(Instance).CheckSortingImage;
end;

function TVisualTechImport.CustomXDBGrid_LocateStrGet(Instance: Pointer
  ): Variant;
begin
  Result := TCustomXDBGrid(Instance).LocateStr;
end;

procedure TVisualTechImport.CustomXDBGrid_LocateStrSet(Instance: Pointer;
  AValue: Variant);
begin
  TCustomXDBGrid(Instance).LocateStr := AValue;
end;

function TVisualTechImport.CustomXDBGrid_ResetFilter(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomXDBGrid(Instance).ResetFilter;
end;

function TVisualTechImport.CustomXDBGrid_SelectedFieldGet(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr(TCustomXDBGrid(Instance).SelectedField);
end;

procedure TVisualTechImport.CustomXDBGrid_SelectedFieldSet(Instance: Pointer;
  AValue: Variant);
begin
  TCustomXDBGrid(Instance).SelectedField := TField(TSuPtr(AValue));
end;

function TVisualTechImport.CustomXDBGrid_SelectedIndexGet(Instance: Pointer
  ): Variant;
begin
  Result := TCustomXDBGrid(Instance).SelectedIndex;
end;

procedure TVisualTechImport.CustomXDBGrid_SelectedIndexSet(Instance: Pointer;
  AValue: Variant);
begin
  TCustomXDBGrid(Instance).SelectedIndex := AValue;
end;

function TVisualTechImport.CustomXDBGrid_SelectedColumn(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr(TCustomXDBGrid(Instance).SelectedColumn);
end;

function TVisualTechImport.CustomXDBGrid_ShowFilterForm(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomXDBGrid(Instance).ShowFilterForm(TField(TSuPtr(Params[0])), Params[1], Params[2]);
end;

function TVisualTechImport.CustomXDBGrid_SortedFieldGet(Instance: Pointer
  ): Variant;
begin
  Result := TCustomXDBGrid(Instance).SortedField;
end;

function TVisualTechImport.FormsBar_ActivateForm(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFormsBar(Instance).ActivateForm(TCustomForm(TSuPtr(Params[0])));
end;

function TVisualTechImport.FormsBar_ActiveForm(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TFormsBar(Instance).ActiveForm );
end;

function TVisualTechImport.FormsBar_AddForm(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFormsBar(Instance).AddForm(TCustomForm(TSuPtr(Params[0])), Params[1]);
end;

function TVisualTechImport.FormsBar_CloseAll(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFormsBar(Instance).CloseAll;
end;

function TVisualTechImport.FormsBar_FormCount(Instance: Pointer): Variant;
begin
  Result := TFormsBar(Instance).FormCount;
end;

function TVisualTechImport.FormsBar_InsertForm(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFormsBar(Instance).InsertForm(TCustomForm(TSuPtr(Params[0])), TCustomForm(TSuPtr(Params[1])), Params[2]);
end;

function TVisualTechImport.FormsBar_InsertFormWithParent(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFormsBar(Instance).InsertFormWithParent(TCustomForm(TSuPtr(Params[0])), TCustomForm(TSuPtr(Params[1])));
end;

function TVisualTechImport.FormsBar_ItemsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TFormsBar(Instance).Items[Params[0]] );
end;

function TVisualTechImport.FormsBar_RemoveForm(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFormsBar(Instance).RemoveForm(TCustomForm(TSuPtr(Params[0])));
end;

function TVisualTechImport.FormsBar_ReplaceForm(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFormsBar(Instance).ReplaceForm(TCustomForm(TSuPtr(Params[0])), TCustomForm(TSuPtr(Params[1])), Params[2]);
end;

function TVisualTechImport.FormsBar_SetActiveControl(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomFormsBar(Instance).SetActiveControl(TForm(TSuPtr(Params[0])), TWinControl(TSuPtr(Params[1])));
end;

function TVisualTechImport.xColumn_FieldGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TxColumn(Instance).Field);
end;

procedure TVisualTechImport.xColumn_FieldSet(Instance: Pointer; AValue: Variant
  );
begin
  TxColumn(Instance).Field := TField(TSuPtr(AValue));
end;

function TVisualTechImport.xColumn_SortedGet(Instance: Pointer): Variant;
begin
  Result := TxColumn(Instance).Sorted;
end;

procedure TVisualTechImport.xColumn_SortedSet(Instance: Pointer; AValue: Variant
  );
begin
  TxColumn(Instance).Sorted:= AValue;
end;

function TVisualTechImport.xColumn_xFieldGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TxColumn(Instance).xField);
end;

procedure TVisualTechImport.xColumn_xFieldSet(Instance: Pointer; AValue: Variant
  );
begin
  TxColumn(Instance).xField := TField(TSuPtr(AValue));
end;

function TVisualTechImport.xColumn_xSortedGet(Instance: Pointer): Variant;
begin
  Result := TxColumn(Instance).xSorted;
end;

procedure TVisualTechImport.xColumn_xSortedSet(Instance: Pointer;
  AValue: Variant);
begin
  TxColumn(Instance).xSorted:= AValue;
end;

function TVisualTechImport.xDBGridColumns_Add(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TxDBGridColumns(Instence).Add);
end;

function TVisualTechImport.xDBGridColumns_ItemsGet(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TxDBGridColumns(Instence).Items[Params[0]]);
end;

function TVisualTechImport.xDBGridColumns_ItemsSet(Instence: TObject;
  var Params: Variant): Variant;
begin
  TxDBGridColumns(Instence).Items[Params[0]] := TxColumn(TSuPtr(Params[1]));
end;

function TVisualTechImport.xDBGridColumns_ResetSorted(Instance: TObject;
  var Params: Variant): Variant;
begin
  TxDBGridColumns(Instance).ResetSorted;
end;

function TVisualTechImport.XDBGrid_EditorModeGet(Instance: Pointer): Variant;
begin
  Result := TxDBGrid(Instance).EditorMode;
end;

procedure TVisualTechImport.XDBGrid_EditorModeSet(Instance: Pointer;
  AValue: Variant);
begin
  TxDBGrid(Instance).EditorMode := AValue;
end;

function TVisualTechImport.CustomXDBGrid_CellCursorPos(Instance: Pointer
  ): Variant;
begin
  Result := TCustomXDBGrid(Instance).CellCursorPos;
end;

function TVisualTechImport.CustomXDBGrid_SelectedEditorRect(Instance: TObject;
  var Params: Variant): Variant;
begin
  EdtrRect := TCustomXDBGrid(Instance).SelectedEditorRect;
  Result := TSuPtr(@EdtrRect);
end;

function TVisualTechImport.CustomXGrid_ColGet(Instance: Pointer): Variant;
begin
  Result := TCustomXGrid(Instance).Col;
end;

function TVisualTechImport.CustomXGrid_RowGet(Instance: Pointer): Variant;
begin
  Result := TCustomXGrid(Instance).Row;
end;

function TVisualTechImport.FormsBar_FocusTimerEnabledGet(Instance: Pointer
  ): Variant;
begin
  Result := TFormsBar(Instance).FocusTimerEnabled;
end;

procedure TVisualTechImport.FormsBar_FocusTimerEnabledSet(Instance: Pointer;
  AValue: Variant);
begin
  TFormsBar(Instance).FocusTimerEnabled := AValue;
end;

procedure TVisualTechImport.AddTypes(AddType: TAddTypeProc);
begin
  {from xGrids}
  AddType(TypeInfo(TxGridOption));
  AddType(TypeInfo(TxGridOptions));
  AddType(TypeInfo(TxGridSaveOptions));
  AddType(TypeInfo(TxSaveOptions));
  AddType(TypeInfo(TxGridDrawState));
  AddType(TypeInfo(TxGridState));
  AddType(TypeInfo(TxColumnButtonStyle));
  AddType(TypeInfo(TxTitleStyle));
  AddType(TypeInfo(TxGridFlagsOption));
  AddType(TypeInfo(TxSortOrder));
  AddType(TypeInfo(TxCellHintPriority));
  AddType(TypeInfo(TxMouseWheelOption));
  {from xDBGrids}
  AddType(TypeInfo(TxGridStyle));
  AddType(TypeInfo(TCellCursorPos));
  AddType(TypeInfo(TxDBGridOption));
  AddType(TypeInfo(TxDbGridOptions));
  AddType(TypeInfo(TxDbGridExtraOption));
  AddType(TypeInfo(TxDbGridExtraOptions));

  {AddType(TypeInfo());
  AddType(TypeInfo());
  AdType(TypeInfo());}
end;

procedure TVisualTechImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  {xDBGrids}
  AddClass(TCustomXGrid).ClassImporter := Self;
  AddClass(TxColumnTitle);
  AddClass(TxColumn).ClassImporter := Self;
  AddClass(TxDBGridColumns).ClassImporter := Self;
  AddClass(TCustomXDBGrid).ClassImporter := Self;
  AddClass(TxDBGrid).ClassImporter := Self;
  {xDBControls}
  AddClass(TEmbededButton);
  AddClass(TxSpeedBtn);
  AddClass(TxBitBtn);
  AddClass(TEmbededLabel);
  AddClass(TCustomLabeledDBEdit);
  AddClass(TLabeledDBEdit);
  AddClass(TxLabeledEdit);
  AddClass(TCustomLabeledDBCombo);
  AddClass(TLabeledDBCombo);
  AddClass(TCustomLabeledDBLookupCombo);
  AddClass(TCustomDBEditButton);
  AddClass(TDBEditButton);
  AddClass(TxDBCheckBox);
  AddClass(TxEditButton);
  AddClass(TxLabeledCombo);
  AddClass(TLabeledDBLookupCombo);
  AddClass(TSuFrame);
  AddClass(TFormsBar).ClassImporter := Self;
  AddClass(TBarCodeHook).ClassImporter := Self;
end;

procedure TVisualTechImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TCustomXGrid then
  begin
    AType.AddProp('Col', 'integer', @CustomXGrid_ColGet);
    AType.AddProp('Row', 'integer', @CustomXGrid_RowGet);
  end
  else
  if AType.ValueClassType = TCustomXDBGrid then
  begin
    AType.AddProp('SelectedField', 'TField', @CustomXDBGrid_SelectedFieldGet, @CustomXDBGrid_SelectedFieldSet);
    AType.AddProp('SortedField', 'string', @CustomXDBGrid_SortedFieldGet);
    AType.AddProp('SelectedIndex', 'integer', @CustomXDBGrid_SelectedIndexGet, @CustomXDBGrid_SelectedIndexSet);
    AType.AddProp('SelectedColumn', 'TxColumn', @CustomXDBGrid_SelectedColumn);
    AType.AddProp('LocateStr', 'string', @CustomXDBGrid_LocateStrGet, @CustomXDBGrid_LocateStrSet);
    AType.AddProp('CellCursorPos', 'TCellCursorPos', @CustomXDBGrid_CellCursorPos);
    AType.AddMethod('procedure CheckSortingImage', @CustomXDBGrid_CheckSortingImage);
    AType.AddMethod('procedure ActivateFilter(FieldName, AValue: string; IsCaseInsensitive: Boolean = False; ContainingValue: Boolean = True)', @CustomXDBGrid_ActivateFilter);
    AType.AddMethod('procedure ResetFilter', @CustomXDBGrid_ResetFilter);
    AType.AddMethod('procedure ShowFilterForm(F: TField; ACaption, InputStr: string)', @CustomXDBGrid_ShowFilterForm);
    AType.AddMethod('function SelectedEditorRect: TRect', @CustomXDBGrid_SelectedEditorRect);
  end
  else
  if AType.ValueClassType = TxDBGrid then
  begin
    AType.AddProp('EditorMode', 'Boolean', @XDBGrid_EditorModeGet, @XDBGrid_EditorModeSet);
  end
  else
  if AType.ValueClassType = TxDBGridColumns then
  begin
    AType.AddMethod('function Add: TxColumn', @xDBGridColumns_Add);
    AType.AddMethod('procedure ResetSorted', @xDBGridColumns_ResetSorted);
    AType.AddIndexedProp('Items', 'TxColumn', 'Integer', @xDBGridColumns_ItemsGet, @xDBGridColumns_ItemsSet);
  end
  else
  if AType.ValueClassType = TxColumn then
  begin
    AType.AddProp('Field', 'TField', @xColumn_FieldGet, @xColumn_FieldSet);
    AType.AddProp('xField', 'TField', @xColumn_xFieldGet, @xColumn_xFieldSet);
    AType.AddProp('Sorted', 'TxSortOrder', @xColumn_SortedGet, @xColumn_SortedSet);
    AType.AddProp('xSorted', 'TxSortOrder', @xColumn_xSortedGet, @xColumn_xSortedSet);
  end
  else
  if AType.ValueClassType = TFormsBar then
  begin
    AType.AddMethod('procedure AddForm(AForm: TCustomForm; IconIndex: Integer = -1)', @FormsBar_AddForm);
    AType.AddMethod('procedure InsertForm(AForm, AfterForm: TCustomForm; IconIndex: Integer = -1)', @FormsBar_InsertForm);
    AType.AddMethod('procedure InsertFormWithParent(AForm, ParentForm: TCustomForm)', @FormsBar_InsertFormWithParent);
    AType.AddMethod('procedure ReplaceForm(NewForm, OldForm: TCustomForm; IconIndex: Integer = -1)', @FormsBar_ReplaceForm);
    AType.AddMethod('procedure RemoveForm(AForm: TCustomForm)', @FormsBar_RemoveForm);
    AType.AddMethod('procedure ActivateForm(AForm: TCustomForm)', @FormsBar_ActivateForm);
    AType.AddMethod('procedure CloseAll', @FormsBar_CloseAll);
    AType.AddMethod('procedure SetActiveControl(AForm: TCustomForm; AWinControl: TWinControl)', @FormsBar_SetActiveControl);

    AType.AddProp('FormCount', 'Integer', @FormsBar_FormCount);
    AType.AddProp('ActiveForm', 'TCustomForm', @FormsBar_ActiveForm);
    AType.AddProp('FocusTimerEnabled', 'Boolean', @FormsBar_FocusTimerEnabledGet, @FormsBar_FocusTimerEnabledSet);

    AType.AddIndexedProp('Items', 'TCustomForm', 'Integer', @FormsBar_ItemsGet);
  end
  else
  if AType.ValueClassType = TBarCodeHook then
  begin
    AType.AddProp('BarCode', 'string', @BarCodeHook_BarCodeGet, @BarCodeHook_BarCodeSet);
  end;
end;

procedure TVisualTechImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TOnEditButtonClick), TOnEditButtonClickHandler);
  RegisterHandler(TypeInfo(TOnGetImageIndexFromField), TOnGetImageIndexFromFieldHandler);
  RegisterHandler(TypeInfo(TxDBGridClickEvent), TxDBGridClickEventHandler);
  RegisterHandler(TypeInfo(TxMovedEvent), TxMovedEventHandler);
  RegisterHandler(TypeInfo(TxDrawColumnCellEvent), TxDrawColumnCellEventHandler);
  RegisterHandler(TypeInfo(TxDbGridSelEditorEvent), TSelectEditorEventHandler);
  {RegisterHandler(TypeInfo(), );
  RegisterHandler(TypeInfo(), );}

end;



end.

