{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit dpi_System;

{$mode objfpc}{$H+}

interface

uses SysUtils, Classes, dpCompil, TypInfo, Variants;

type

  { TSuSystemImport }

  TSuSystemImport = class(TClassImporter)
    function IniFile_CacheUpdatesGet(Instance: Pointer): Variant;
    procedure IniFile_CacheUpdatesSet(Instance: Pointer; AValue: Variant);
    function IniFile_CaseSensitiveGet(Instance: Pointer): Variant;
    procedure IniFile_CaseSensitiveSet(Instance: Pointer; AValue: Variant);
    function IniFile_Create(Instance: TObject; var Params: Variant): Variant;
    function IniFile_CreateStream(Instance: TObject; var Params: Variant
      ): Variant;
    function IniFile_DeleteKey(Instance: TObject; var Params: Variant): Variant;
    function IniFile_EraseSection(Instance: TObject; var Params: Variant
      ): Variant;
    function IniFile_EscapeLineFeeds(Instance: Pointer): Variant;
    function IniFile_FileName(Instance: Pointer): Variant;
    function IniFile_GetStream(Instance: Pointer): Variant;
    function IniFile_ReadSection(Instance: TObject; var Params: Variant
      ): Variant;
    function IniFile_ReadSectionRaw(Instance: TObject; var Params: Variant
      ): Variant;
    function IniFile_ReadSections(Instance: TObject; var Params: Variant
      ): Variant;
    function IniFile_ReadSectionValues(Instance: TObject; var Params: Variant
      ): Variant;
    function IniFile_ReadString(Instance: TObject; var Params: Variant
      ): Variant;
    function IniFile_SectionExists(Instance: TObject; var Params: Variant
      ): Variant;
    function IniFile_StripQuotesGet(Instance: Pointer): Variant;
    procedure IniFile_StripQuotesSet(Instance: Pointer; AValue: Variant);
    function IniFile_UpdateFile(Instance: TObject; var Params: Variant
      ): Variant;
    function IniFile_ValueExists(Instance: TObject; var Params: Variant
      ): Variant;
    function IniFile_WriteString(Instance: TObject; var Params: Variant
      ): Variant;
    function InputPipeStream_NumBytesAvailable(Instance: Pointer): Variant;
    function Process_CloseInput(Instence: TObject; var Params: Variant
      ): Variant;
    function Process_CloseOutput(Instence: TObject; var Params: Variant
      ): Variant;
    function Process_CloseStderr(Instence: TObject; var Params: Variant
      ): Variant;
    function Process_Execute(Instence: TObject; var Params: Variant): Variant;
    function Process_ExitStatus(Instance: Pointer): Variant;
    function Process_Handle(Instance: Pointer): Variant;
    function Process_InheritHandlesGet(Instance: Pointer): Variant;
    procedure Process_InheritHandlesSet(Instance: Pointer; AValue: Variant);
    function Process_Input(Instance: Pointer): Variant;
    function Process_Output(Instance: Pointer): Variant;
    function Process_ProcessHandle(Instance: Pointer): Variant;
    function Process_ProcessID(Instance: Pointer): Variant;
    function Process_Resume(Instence: TObject; var Params: Variant): Variant;
    function Process_Stderr(Instance: Pointer): Variant;
    function Process_Suspend(Instence: TObject; var Params: Variant): Variant;
    function Process_Terminate(Instence: TObject; var Params: Variant): Variant;
    function Process_ThreadHandle(Instance: Pointer): Variant;
    function Process_ThreadID(Instance: Pointer): Variant;
    function Process_WaitOnExit(Instence: TObject; var Params: Variant
      ): Variant;
  private
  protected
  public
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
       override;
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure RegisterPublic(AType: TDpType); override;
  end;

implementation

uses
  ExtCtrls, process, Pipes, IniFiles, FileUtil;

{ TSuSystemImport }

function TSuSystemImport.IniFile_CacheUpdatesGet(Instance: Pointer): Variant;
begin
  Result := TIniFile(Instance).CacheUpdates;
end;

procedure TSuSystemImport.IniFile_CacheUpdatesSet(Instance: Pointer;
  AValue: Variant);
begin
  TIniFile(Instance).CacheUpdates:= AValue;
end;

function TSuSystemImport.IniFile_CaseSensitiveGet(Instance: Pointer): Variant;
begin
  Result := TIniFile(Instance).CaseSensitive;
end;

procedure TSuSystemImport.IniFile_CaseSensitiveSet(Instance: Pointer;
  AValue: Variant);
begin
  TIniFile(Instance).CaseSensitive := AValue;
end;

function TSuSystemImport.IniFile_Create(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
  B: Boolean;
begin
  S := Params[0];
  B := Params[1];
  Result := TSuPtr( TIniFile.Create(S, B) );
end;

function TSuSystemImport.IniFile_CreateStream(Instance: TObject;
  var Params: Variant): Variant;
var
  Stream: TStream;
  B: Boolean;
begin
  Stream := TStream( TSuPtr(Params[0]) );
  B := Params[1];
  Result := TSuPtr( TIniFile.Create(Stream, B) );
end;

function TSuSystemImport.IniFile_DeleteKey(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIniFile(Instance).DeleteKey(Params[0], Params[1]);
end;

function TSuSystemImport.IniFile_EraseSection(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIniFile(Instance).EraseSection(Params[0]);
end;

function TSuSystemImport.IniFile_EscapeLineFeeds(Instance: Pointer): Variant;
begin
  Result := TIniFile(Instance).EscapeLineFeeds;
end;

function TSuSystemImport.IniFile_FileName(Instance: Pointer): Variant;
begin
  Result := TIniFile(Instance).FileName;
end;

function TSuSystemImport.IniFile_GetStream(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIniFile(Instance).Stream );
end;

function TSuSystemImport.IniFile_ReadSection(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIniFile(Instance).ReadSection(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TSuSystemImport.IniFile_ReadSectionRaw(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIniFile(Instance).ReadSectionRaw(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TSuSystemImport.IniFile_ReadSections(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIniFile(Instance).ReadSections(TStrings(TSuPtr(Params[0])));
end;

function TSuSystemImport.IniFile_ReadSectionValues(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIniFile(Instance).ReadSectionValues(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TSuSystemImport.IniFile_ReadString(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIniFile(Instance).ReadString(Params[0], Params[1], Params[2]);
end;

function TSuSystemImport.IniFile_SectionExists(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIniFile(Instance).SectionExists(Params[0]);
end;

function TSuSystemImport.IniFile_StripQuotesGet(Instance: Pointer): Variant;
begin
  Result := TIniFile(Instance).StripQuotes;
end;

procedure TSuSystemImport.IniFile_StripQuotesSet(Instance: Pointer;
  AValue: Variant);
begin
  TIniFile(Instance).StripQuotes := AValue;
end;

function TSuSystemImport.IniFile_UpdateFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIniFile(Instance).UpdateFile;
end;

function TSuSystemImport.IniFile_ValueExists(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result:= TIniFile(Instance).ValueExists(Params[0], Params[1]);
end;

function TSuSystemImport.IniFile_WriteString(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIniFile(Instance).WriteString(Params[0], Params[1], Params[2]);
end;

function TSuSystemImport.InputPipeStream_NumBytesAvailable(Instance: Pointer
  ): Variant;
begin
  Result := TInputPipeStream(Instance).NumBytesAvailable;
end;

function TSuSystemImport.Process_CloseInput(Instence: TObject;
  var Params: Variant): Variant;
begin
  TProcess(Instence).CloseInput;
end;

function TSuSystemImport.Process_CloseOutput(Instence: TObject;
  var Params: Variant): Variant;
begin
  TProcess(Instence).CloseOutput;
end;

function TSuSystemImport.Process_CloseStderr(Instence: TObject;
  var Params: Variant): Variant;
begin
  TProcess(Instence).CloseStderr;
end;

function TSuSystemImport.Process_Execute(Instence: TObject; var Params: Variant
  ): Variant;
begin
  TProcess(Instence).Execute;
end;

function TSuSystemImport.Process_ExitStatus(Instance: Pointer): Variant;
begin
  Result := TProcess(Instance).ExitStatus;
end;

function TSuSystemImport.Process_Handle(Instance: Pointer): Variant;
begin
  Result := TProcess(Instance).Handle;
end;

function TSuSystemImport.Process_InheritHandlesGet(Instance: Pointer): Variant;
begin
  Result := TProcess(Instance).InheritHandles;
end;

procedure TSuSystemImport.Process_InheritHandlesSet(Instance: Pointer;
  AValue: Variant);
begin
  TProcess(Instance).InheritHandles := AValue;
end;

function TSuSystemImport.Process_Input(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TProcess(Instance).Input);
end;

function TSuSystemImport.Process_Output(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TProcess(Instance).Output);
end;

function TSuSystemImport.Process_ProcessHandle(Instance: Pointer): Variant;
begin
  Result := TProcess(Instance).Handle;
end;

function TSuSystemImport.Process_ProcessID(Instance: Pointer): Variant;
begin
  Result := TProcess(Instance).ProcessID;
end;

function TSuSystemImport.Process_Resume(Instence: TObject; var Params: Variant
  ): Variant;
begin
  Result := TProcess(Instence).Resume;
end;

function TSuSystemImport.Process_Stderr(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TProcess(Instance).Stderr);
end;

function TSuSystemImport.Process_Suspend(Instence: TObject; var Params: Variant
  ): Variant;
begin
  Result := TProcess(Instence).Suspend;
end;

function TSuSystemImport.Process_Terminate(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TProcess(Instence).Terminate(Params[0]);
end;

function TSuSystemImport.Process_ThreadHandle(Instance: Pointer): Variant;
begin
  Result := TProcess(Instance).ThreadHandle;
end;

function TSuSystemImport.Process_ThreadID(Instance: Pointer): Variant;
begin
  Result := TProcess(Instance).ThreadID;
end;

function TSuSystemImport.Process_WaitOnExit(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TProcess(Instence).WaitOnExit;
end;

procedure TSuSystemImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddClass(TTimer);
  AddClass(TIdleTimer);
  AddClass(TInputPipeStream).ClassImporter := Self;
  AddClass(TOutputPipeStream);
  AddClass(TProcess).ClassImporter := Self;

  {form IniFiles}
  AddClass(TIniFile).ClassImporter := Self;
end;

procedure TSuSystemImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TIdleTimerAutoEvent));
  AddType(TypeInfo(TIdleTimerAutoEvents));
  AddType(TypeInfo(TProcessOption));
  AddType(TypeInfo(TShowWindowOptions));
  AddType(TypeInfo(TStartupOption));
  AddType(TypeInfo(TProcessPriority));
  AddType(TypeInfo(TProcessOptions));
  AddType(TypeInfo(TStartupOptions));

end;

procedure TSuSystemImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TProcess then
  begin
    AType.AddMethod('Procedure Execute', @Process_Execute);
    AType.AddMethod('procedure CloseInput', @Process_CloseInput);
    AType.AddMethod('procedure CloseOutput', @Process_CloseOutput);
    AType.AddMethod('procedure CloseStderr', @Process_CloseStderr);
    AType.AddMethod('Function Resume: Integer', @Process_Resume);
    AType.AddMethod('Function Suspend: Integer', @Process_Suspend);
    AType.AddMethod('Function Terminate (AExitCode : Integer): Boolean', @Process_Terminate);
    AType.AddMethod('Function WaitOnExit: Boolean', @Process_WaitOnExit);

    AType.AddProp('Handle', 'THandle', @Process_Handle);
    AType.AddProp('ProcessHandle', 'THandle', @Process_ProcessHandle);
    AType.AddProp('ThreadHandle', 'THandle', @Process_ThreadHandle);
    AType.AddProp('ProcessID', 'Integer', @Process_ProcessID);
    AType.AddProp('ThreadID', 'Integer', @Process_ThreadID);
    AType.AddProp('Input', 'TOutputPipeStream', @Process_Input);
    AType.AddProp('Output', 'TInputPipeStream', @Process_Output);
    AType.AddProp('Stderr', 'TinputPipeStream', @Process_Stderr);
    AType.AddProp('ExitStatus', 'Integer', @Process_ExitStatus);
    AType.AddProp('InheritHandles', 'Boolean', @Process_InheritHandlesGet, @Process_InheritHandlesSet);
  end
  else
  if AType.ValueClassType = TInputPipeStream then
  begin
    AType.AddProp('NumBytesAvailable', 'Integer', @InputPipeStream_NumBytesAvailable);
  end
  else
  if AType.ValueClassType = TIniFile then
  begin
    AType.AddMethod('constructor Create(const AFileName: string; AEscapeLineFeeds : Boolean = False)', @IniFile_Create);
    AType.AddMethod('constructor CreateStream(AStream: TStream; AEscapeLineFeeds : Boolean = False)', @IniFile_CreateStream);
    AType.AddMethod('function ReadString(const Section, Ident, Default: string): string', @IniFile_ReadString);
    AType.AddMethod('procedure WriteString(const Section, Ident, Value: String)', @IniFile_WriteString);
    AType.AddMethod('procedure ReadSection(const Section: string; Strings: TStrings)', @IniFile_ReadSection);
    AType.AddMethod('procedure ReadSectionRaw(const Section: string; Strings: TStrings)', @IniFile_ReadSectionRaw);
    AType.AddMethod('procedure ReadSections(Strings: TStrings)', @IniFile_ReadSections);
    AType.AddMethod('procedure ReadSectionValues(const Section: string; Strings: TStrings)', @IniFile_ReadSectionValues);
    AType.AddMethod('procedure EraseSection(const Section: string)', @IniFile_EraseSection);
    AType.AddMethod('procedure DeleteKey(const Section, Ident: String)', @IniFile_DeleteKey);
    AType.AddMethod('procedure UpdateFile', @IniFile_UpdateFile);

    AType.AddMethod('function SectionExists(const Section: string): Boolean', @IniFile_SectionExists);
    AType.AddMethod('function ValueExists(const Section, Ident: string): Boolean', @IniFile_ValueExists);
    AType.AddProp('FileName', 'string', @IniFile_FileName);
    AType.AddProp('EscapeLineFeeds', 'boolean', @IniFile_EscapeLineFeeds);
    AType.AddProp('CaseSensitive', 'Boolean', @IniFile_CaseSensitiveGet, @IniFile_CaseSensitiveSet);
    AType.AddProp('StripQuotes', 'Boolean', @IniFile_StripQuotesGet, @IniFile_StripQuotesSet);

    AType.AddProp('Stream', 'TStream', @IniFile_GetStream);
    AType.AddProp('CacheUpdates', 'Boolean', @IniFile_CacheUpdatesGet, @IniFile_CacheUpdatesSet);
  end;
end;

end.

