unit dpi_Chart;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo, Variants;

type

  { TChartImport }

  TChartImport = class(TClassImporter)
    function ChartSeriesList_Clear(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeriesList_Count(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeriesList_ItemsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_Add(Instance: TObject; var Params: Variant): Variant;
    function ChartSeries_AddNull(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_AddX(Instance: TObject; var Params: Variant): Variant;
    function ChartSeries_AddY(Instance: TObject; var Params: Variant): Variant;
    function ChartSeries_Clear(Instance: TObject; var Params: Variant): Variant;
    function ChartSeries_Count(Instance: TObject; var Params: Variant): Variant;
    function ChartSeries_Delete(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_FormattedMark(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_IsEmpty(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_LastValueIndex(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_ListSource(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_MaxXValue(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_MaxYValue(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_MinXValue(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_MinYValue(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_SetText(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_XValueGet(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_XValueSet(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_YValueGet(Instance: TObject; var Params: Variant
      ): Variant;
    function ChartSeries_YValueSet(Instance: TObject; var Params: Variant
      ): Variant;
    function Chart_AddSeries(Instance: TObject; var Params: Variant): Variant;
    function Chart_ClearSeries(Instance: TObject; var Params: Variant): Variant;
    function Chart_DeleteSeries(Instance: TObject; var Params: Variant
      ): Variant;
    function Chart_DisableRedrawing(Instance: TObject; var Params: Variant
      ): Variant;
    function Chart_EnableRedrawing(Instance: TObject; var Params: Variant
      ): Variant;
    function Chart_PaintOnCanvas(Instance: TObject; var Params: Variant
      ): Variant;
    function Chart_Prepare(Instance: TObject; var Params: Variant): Variant;
    function Chart_RemoveSeries(Instance: TObject; var Params: Variant
      ): Variant;
    function CustChartSource_CountGet(Instance: Pointer): Variant;
    function CustChartSource_FormatItem(Instance: TObject; var Params: Variant
      ): Variant;
    function CustChartSource_FormatItemXYText(Instance: TObject;
      var Params: Variant): Variant;
    function CustChartSource_XOfMax(Instance: TObject; var Params: Variant
      ): Variant;
    function CustChartSource_XOfMin(Instance: TObject; var Params: Variant
      ): Variant;
    function ListChartSource_Add(Instance: TObject; var Params: Variant
      ): Variant;
    function ListChartSource_Clear(Instance: TObject; var Params: Variant
      ): Variant;
    function ListChartSource_CopyFrom(Instance: TObject; var Params: Variant
      ): Variant;
    function ListChartSource_Delete(Instance: TObject; var Params: Variant
      ): Variant;
    function ListChartSource_SetText(Instance: TObject; var Params: Variant
      ): Variant;
    function ListChartSource_SetXValue(Instance: TObject; var Params: Variant
      ): Variant;
    function ListChartSource_SetYValue(Instance: TObject; var Params: Variant
      ): Variant;
    function ListChartSource_Sort(Instance: TObject; var Params: Variant
      ): Variant;
    function ListChartSource_SortedGet(Instance: Pointer): Variant;
    procedure ListChartSource_SortedSet(Instance: Pointer; AValue: Variant);
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
      override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure AddConsts(AddConst: TAddConstProc); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
  end;

implementation

uses TAGraph, TASeries, TASources, TADbSource, Graphics, TACustomSeries,
  TAChartUtils, TACustomSource, TAMultiSeries, TARadialSeries, TAChartAxis,
  TAChartAxisUtils, TAIntervalSources, TAStyles, TATransformations;

{ TChartImport }

function TChartImport.ChartSeriesList_Clear(Instance: TObject;
  var Params: Variant): Variant;
begin
  TChartSeriesList(Instance).Clear;
end;

function TChartImport.ChartSeriesList_Count(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TChartSeriesList(Instance).Count;
end;

function TChartImport.ChartSeriesList_ItemsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TChartSeriesList(Instance).Items[Params[0]] );
end;

function TChartImport.ChartSeries_Add(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TChartSeries(Instance).Add(Params[0], Params[1], Params[2]);
end;

function TChartImport.ChartSeries_AddNull(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TChartSeries(Instance).AddNull(Params[0], Params[1]);
end;

function TChartImport.ChartSeries_AddX(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TChartSeries(Instance).AddX(Params[0], Params[1], Params[2]);
end;

function TChartImport.ChartSeries_AddY(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TChartSeries(Instance).AddY(Params[0], Params[1], Params[2]);
end;

function TChartImport.ChartSeries_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TChartSeries(Instance).Clear;
end;

function TChartImport.ChartSeries_Count(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TChartSeries(Instance).Count;
end;

function TChartImport.ChartSeries_Delete(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TChartSeries(Instance).Delete(Params[0]);
end;

function TChartImport.ChartSeries_FormattedMark(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TChartSeries(Instance).FormattedMark(Params[0], Params[1], Params[2]);
end;

function TChartImport.ChartSeries_IsEmpty(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TChartSeries(Instance).IsEmpty;
end;

function TChartImport.ChartSeries_LastValueIndex(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TChartSeries(Instance).LastValueIndex;
end;

function TChartImport.ChartSeries_ListSource(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TChartSeries(Instance).ListSource );
end;

function TChartImport.ChartSeries_MaxXValue(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TChartSeries(Instance).MaxXValue;
end;

function TChartImport.ChartSeries_MaxYValue(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TChartSeries(Instance).MaxYValue;
end;

function TChartImport.ChartSeries_MinXValue(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TChartSeries(Instance).MinXValue;
end;

function TChartImport.ChartSeries_MinYValue(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TChartSeries(Instance).MinYValue;
end;

function TChartImport.ChartSeries_SetText(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TChartSeries(Instance).SetText(Params[0], Params[1]);
end;

function TChartImport.ChartSeries_XValueGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TChartSeries(Instance).XValue[Params[0]];
end;

function TChartImport.ChartSeries_XValueSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TChartSeries(Instance).XValue[Params[0]] := Params[1];
end;

function TChartImport.ChartSeries_YValueGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TChartSeries(Instance).YValue[Params[0]];
end;

function TChartImport.ChartSeries_YValueSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TChartSeries(Instance).YValue[Params[0]] := Params[1];
end;

function TChartImport.Chart_AddSeries(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TChart(Instance).AddSeries(TBasicChartSeries( TSuPtr( Params[0] ) ));
end;

function TChartImport.Chart_ClearSeries(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TChart(Instance).ClearSeries;
end;

function TChartImport.Chart_DeleteSeries(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TChart(Instance).DeleteSeries(TBasicChartSeries( TSuPtr(Params[0]) ));
end;

function TChartImport.Chart_DisableRedrawing(Instance: TObject;
  var Params: Variant): Variant;
begin
  TChart(Instance).DisableRedrawing;
end;

function TChartImport.Chart_EnableRedrawing(Instance: TObject;
  var Params: Variant): Variant;
begin
  TChart(Instance).EnableRedrawing;
end;

function TChartImport.Chart_PaintOnCanvas(Instance: TObject; var Params: Variant
  ): Variant;
var
  R: TRect;
  ACanvas: TCanvas;
begin
  ACanvas := TCanvas( TSuPtr( Params[0] ) );
  R.Left := Params[1];
  R.Top := Params[2];
  R.Right := Params[3];
  R.Bottom := Params[4];
  TChart(Instance).PaintOnCanvas(ACanvas, R);
end;

function TChartImport.Chart_Prepare(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TChart(Instance).Prepare;
end;

function TChartImport.Chart_RemoveSeries(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TChart(Instance).RemoveSeries(TBasicChartSeries( TSuPtr(Params[0]) ));
end;

function TChartImport.CustChartSource_CountGet(Instance: Pointer): Variant;
begin
  Result := TCustomChartSource(Instance).Count;
end;

function TChartImport.CustChartSource_FormatItem(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomChartSource(Instance).FormatItem(Params[0], Params[1], Params[2]);
end;

function TChartImport.CustChartSource_FormatItemXYText(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomChartSource(Instance).FormatItemXYText(Params[0], Params[1], Params[2], Params[3]);
end;

function TChartImport.CustChartSource_XOfMax(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomChartSource(Instance).XOfMax;
end;

function TChartImport.CustChartSource_XOfMin(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomChartSource(Instance).XOfMin;
end;

function TChartImport.ListChartSource_Add(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TListChartSource(Instance).Add(Params[0], Params[1], Params[2], Params[3]);
end;

function TChartImport.ListChartSource_Clear(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListChartSource(Instance).Clear;
end;

function TChartImport.ListChartSource_CopyFrom(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListChartSource(Instance).CopyFrom( TCustomChartSource( TSuPtr( Params[0] ) ) );
end;

function TChartImport.ListChartSource_Delete(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListChartSource(Instance).Delete(Params[0]);
end;

function TChartImport.ListChartSource_SetText(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListChartSource(Instance).SetText(Params[0], Params[1]);
end;

function TChartImport.ListChartSource_SetXValue(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TListChartSource(Instance).SetXValue(Params[0], Params[1]);
end;

function TChartImport.ListChartSource_SetYValue(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListChartSource(Instance).SetYValue(Params[0], Params[1]);
end;

function TChartImport.ListChartSource_Sort(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListChartSource(Instance).Sort;
end;

function TChartImport.ListChartSource_SortedGet(Instance: Pointer): Variant;
begin
  Result := TListChartSource(Instance).Sorted;
end;

procedure TChartImport.ListChartSource_SortedSet(Instance: Pointer;
  AValue: Variant);
begin
  TListChartSource(Instance).Sorted := AValue;
end;

procedure TChartImport.AddTypes(AddType: TAddTypeProc);
begin
  //AddType(TypeInfo(TReticuleMode));
  AddType(TypeInfo(TChartColor));
end;

procedure TChartImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddClass(TBasicChartSeries);
  AddClass(TCustomChartSeries);
  AddClass(TChartSeries).ClassImporter := Self;
  AddClass(TBasicChartTool);//.ClassImporter := Self;
  AddClass(TBasicPointSeries);
  AddClass(TBasicChartToolset);//.ClassImporter := Self;
  AddClass(TBasicChartSeriesEnumerator);//.ClassImporter := Self;
  AddClass(TChartSeriesList).ClassImporter := Self;
  AddClass(TBarSeries);
  AddClass(TPieSeries);
  AddClass(TAreaSeries);
  AddClass(TbubbleSeries).ClassImporter := Self;
  AddClass(TBoxAndWhiskerSeries);
  AddClass(TOpenHighLowCloseSeries);
  AddClass(TPolarSeries);
  AddClass(TChartAxis);
  //AddClass();
  AddClass(TLineSeries);
  AddClass(TManhattanSeries);
  AddClass(TConstantLine);
  AddClass(TUserDrawnSeries);
  AddClass(TChart).ClassImporter := Self;
  AddClass(TCustomChartSource).ClassImporter := Self;
  AddClass(TListChartSource).ClassImporter := Self;
  AddClass(TDbChartSource);//.ClassImporter := Self;
  AddClass(TIntervalChartSource);
  AddClass(TDateTimeIntervalChartSource);
  AddClass(TChartStyle);
  AddClass(TChartStyleEnumerator);
  AddClass(TChartStyleList);
  AddClass(TChartStyles);
  AddClass(TAxisTransform);
  AddClass(TChartAxisTransformations);
  AddClass(TLinearAxisTransform);
  AddClass(TAutoScaleAxisTransform);
  AddClass(TLogarithmAxisTransform);
  AddClass(TUserDefinedAxisTransform);
end;

procedure TChartImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TChart then
  begin
     AType.AddMethod('procedure PaintOnCanvas(ACanvas: TCanvas; RectLeft, RectTop, RectRight, RectBottom: Integer)', @Chart_PaintOnCanvas);
     AType.AddMethod('procedure AddSeries(ASeries: TBasicChartSeries)', @Chart_AddSeries);
     AType.AddMethod('procedure ClearSeries', @Chart_ClearSeries);
     AType.AddMethod('procedure DeleteSeries(ASeries: TBasicChartSeries)', @Chart_DeleteSeries);
     AType.AddMethod('procedure DisableRedrawing', @Chart_DisableRedrawing);
     AType.AddMethod('procedure EnableRedrawing', @Chart_EnableRedrawing);
     AType.AddMethod('procedure Prepare', @Chart_Prepare);
     AType.AddMethod('procedure RemoveSeries(ASeries: TBasicChartSeries)', @Chart_RemoveSeries);
  end
  else
  if AType.ValueClassType = TChartSeries then
  begin
    AType.AddMethod('function Add(AValue: Double; AXLabel: String = ''''; AColor: TColor = clTAColor): Integer', @ChartSeries_Add);
    AType.AddMethod('function AddNull(ALabel: String = ''''; AColor: TColor = clTAColor): Integer', @ChartSeries_AddNull);
    AType.AddMethod('function AddX(AX: Double; ALabel: String = ''''; AColor: TColor = clTAColor): Integer', @ChartSeries_AddX);
    AType.AddMethod('function AddY(AY: Double; ALabel: String = ''''; AColor: TColor = clTAColor): Integer', @ChartSeries_AddY);
    AType.AddMethod('procedure Clear', @ChartSeries_Clear);
    AType.AddMethod('function Count: Integer', @ChartSeries_Count);
    AType.AddMethod('procedure Delete(AIndex: Integer)', @ChartSeries_Delete);
    AType.AddMethod('function IsEmpty: Boolean', @ChartSeries_IsEmpty);
    AType.AddMethod('function ListSource: TListChartSource', @ChartSeries_ListSource);
    AType.AddMethod('function LastValueIndex: Integer', @ChartSeries_LastValueIndex);
    AType.AddMethod('function MaxXValue: Double', @ChartSeries_MaxXValue);
    AType.AddMethod('function MinXValue: Double', @ChartSeries_MinXValue);
    AType.AddMethod('function MaxYValue: Double', @ChartSeries_MaxYValue);
    AType.AddMethod('function MinYValue: Double', @ChartSeries_MinYValue);
    AType.AddMethod('procedure SetText(AIndex: Integer; AValue: String)', @ChartSeries_SetText);
    AType.AddMethod('function FormattedMark(AIndex: Integer; AFormat: String = ''''; AYIndex: Integer = 0): String', @ChartSeries_FormattedMark);
    AType.AddIndexedProp('XValue', 'Double', 'Integer', @ChartSeries_XValueGet, @ChartSeries_XValueSet);
    AType.AddIndexedProp('YValue', 'Double', 'Integer', @ChartSeries_YValueGet, @ChartSeries_YValueSet);
  end
  else
  if AType.ValueClassType = TChartSeriesList then
  begin
    AType.AddMethod('procedure Clear', @ChartSeriesList_Clear);
    AType.AddMethod('function Count: Integer', @ChartSeriesList_Count);
    AType.AddIndexedProp('Items', 'TBasicChartSeries', 'Integer', @ChartSeriesList_ItemsGet);
  end
  else
  if AType.ValueClassType = TCustomChartSource then
  begin
    AType.AddMethod('function FormatItem(const AFormat: String; AIndex, AYIndex: Integer): String', @CustChartSource_FormatItem);
    AType.AddMethod('function FormatItemXYText(const AFormat: String; AX, AY: Double; AText: String): String', @CustChartSource_FormatItemXYText);
    AType.AddMethod('function XOfMax: Double', @CustChartSource_XOfMax);
    AType.AddMethod('function XOfMin: Double', @CustChartSource_XOfMin);

    AType.AddProp('Count', 'Integer', @CustChartSource_CountGet);
  end
  else
  if AType.ValueClassType = TListChartSource then
  begin
    AType.AddMethod('function Add(AX, AY: Double; const ALabel: String = ''''; AColor: TChartColor = clTAColor): Integer', @ListChartSource_Add);
    AType.AddMethod('procedure Clear', @ListChartSource_Clear);
    AType.AddMethod('procedure CopyFrom(ASource: TCustomChartSource)', @ListChartSource_CopyFrom);
    AType.AddMethod('procedure Delete(AIndex: Integer)', @ListChartSource_Delete);
    AType.AddMethod('procedure SetText(AIndex: Integer; AValue: String)', @ListChartSource_SetText);
    AType.AddMethod('function SetXValue(AIndex: Integer; AValue: Double): Integer', @ListChartSource_SetXValue);
    AType.AddMethod('procedure SetYValue(AIndex: Integer; AValue: Double)', @ListChartSource_SetYValue);
    AType.AddMethod('procedure Sort', @ListChartSource_Sort);
    AType.AddProp('Sorted', 'Boolean', @ListChartSource_SortedGet, @ListChartSource_SortedSet);
  end;
end;

procedure TChartImport.AddConsts(AddConst: TAddConstProc);
begin
  AddConst('clTAColor', 'TColor', clTAColor);
end;

type
  { TChartAxisMarkToTextHandler }

  TChartAxisMarkToTextHandler = class(TDpEventHandler)
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(var AText: String; AMark: Double);
  end;

  { TTransformEventHandler }

  TTransformEventHandler = class(TDpEventHandler)
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(AX: Double; out AT: Double);
  end;

{ TTransformEventHandler }

function TTransformEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TTransformEventHandler.CallHandler;
end;

procedure TTransformEventHandler.CallHandler(AX: Double; out AT: Double);
begin
  Proc.Param[0].Value := AX;
  Proc.Param[1].Value := AT;
  Proc.Exec;
  AT := Proc.Param[1].Value;
end;

{ TChartAxisMarkToTextHandler }

function TChartAxisMarkToTextHandler.GetHandlerAdres: Pointer;
begin
  Result := @TChartAxisMarkToTextHandler.CallHandler;
end;

procedure TChartAxisMarkToTextHandler.CallHandler(var AText: String;
  AMark: Double);
begin
  Proc.Param[0].Value := AText;
  Proc.Param[1].Value := AMark;
  Proc.Exec;
  AText := Proc.Param[0].Value;
end;

procedure TChartImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TChartAxisMarkToTextEvent), TChartAxisMarkToTextHandler);
  RegisterHandler(TypeInfo(TTransformEvent), TTransformEventHandler);
end;

end.


