{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit AbtBox;

{$mode objfpc}{$H+}

interface

{$I SetComponent.inc}

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, ComCtrls;

type

  { TAboutBox }

  TAboutBox = class(TForm)
    Bevel1: TBevel;
    Bevel2: TBevel;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    ListBox1: TListBox;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Label5MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    MVersion: string;
    MMajor: Integer;
    MMinor: Integer;
    MRevision: Integer;
    { private declarations }
  public
    { public declarations }
  end;

var
  AboutBox: TAboutBox;

implementation

uses AppConst, LCLIntf;

{$R *.lfm}

{ TAboutBox }

procedure TAboutBox.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TAboutBox.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  CloseAction := caFree;
end;

procedure TAboutBox.FormCreate(Sender: TObject);
var
  AFileName: string;
begin
  {$IFDEF WINDOWS}
     AFileName := AppDir + 'CrossMachine.exe';
  {$ENDIF}
  {$IFDEF LINUX}
     AFileName := AppDir + 'CrossMachine';
  {$ENDIF}
  MVersion := '-';
  if FileExists(AFileName) then
  begin
    SetVersion(AFileName, MVersion, MMajor, MMinor, MRevision);
  end;
end;

procedure TAboutBox.FormShow(Sender: TObject);
begin
   Label3.Caption:= Label3.Caption + AppVersion;
   Label6.Caption := Label6.Caption + MVersion;
   {$IfDef PORTABLEVERS}
   Label3.Caption:= Label3.Caption + ' (портативная версия)';
   {$EndIf}
end;

procedure TAboutBox.Label5MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  OpenURL(Label5.Caption);
end;

end.

