unit SuFRImport;

interface

uses SysUtils, Classes, dpCompil, TypInfo, Controls, frxClass;

type

  { TFRImport }

  TFRImport = class(TClassImporter)
    {TfrxReport support}
    function TfrxReport_GetDataSet(Instence: TObject; var Params: Variant): Variant;
    function TfrxReport_LoadFromFile(Instence: TObject; var Params: Variant): Variant;
    function TfrxReport_LoadFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function TfrxReport_SaveToFile(Instence: TObject; var Params: Variant): Variant;
    function TfrxReport_ShowReport(Instence: TObject; var Params: Variant): Variant;
    function TfrxReport_DesignReport(Instence: TObject; var Params: Variant): Variant;
    function TfrxReport_AddFunction(Instence: TObject; var Params: Variant): Variant;
    function TfrxReport_GetTerminated(Instence: Pointer): Variant;
    procedure TfrxReport_SetTerminated(Instence: Pointer; AValue: Variant);
    function TfrxReport_GetVariables(Instence: Pointer): Variant;
    function TfrxReport_GetStyles(Instence: Pointer): Variant;
    function TfrxReport_DataSets(Instence: Pointer): Variant;
    {TfrxDataSet support}
    function TfrxDataSet_Open(Instence: TObject; var Params: Variant): Variant;
    function TfrxDataSet_Close(Instence: TObject; var Params: Variant): Variant;
    function TfrxDataSet_First(Instence: TObject; var Params: Variant): Variant;
    function TfrxDataSet_Next(Instence: TObject; var Params: Variant): Variant;
    function TfrxDataSet_Prior(Instence: TObject; var Params: Variant): Variant;
    function TfrxDataSet_Eof(Instence: TObject; var Params: Variant): Variant;
    function TfrxDataSet_FieldsCount(Instence: TObject; var Params: Variant): Variant;
    function TfrxDataSet_HasField(Instence: TObject; var Params: Variant): Variant;
    function TfrxDataSet_IsBlobField(Instence: TObject; var Params: Variant): Variant;
    function TfrxDataSet_RecordCount(Instence: TObject; var Params: Variant): Variant;
    function TfrxDataSet_GetFieldList(Instence: TObject; var Params: Variant): Variant;
    function TfrxDataSet_RecNo(Instence: Pointer): Variant;
    function TfrxDataSet_GetDisplayText(Instence: TObject; var Params: Variant): Variant;
    {TfrxVariables}
    function frxVariables_Add(Instence: TObject; var Params: Variant): Variant;
    function frxVariables_Insert(Instence: TObject; var Params: Variant): Variant;
    function frxVariables_IndexOf(Instence: TObject; var Params: Variant): Variant;
    function frxVariables_AddVariable(Instence: TObject; var Params: Variant): Variant;
    function frxVariables_DeleteCategory(Instence: TObject; var Params: Variant): Variant;
    function frxVariables_DeleteVariable(Instence: TObject; var Params: Variant): Variant;
    function frxVariables_GetCategoriesList(Instence: TObject; var Params: Variant): Variant;
    function frxVariables_GetVariablesList(Instence: TObject; var Params: Variant): Variant;
    function frxVariables_LoadFromFile(Instence: TObject; var Params: Variant): Variant;
    function frxVariables_LoadFromStream(Instence: TObject; var Params: Variant): Variant;
    function frxVariables_SaveToFile(Instence: TObject; var Params: Variant): Variant;
    function frxVariables_SaveToStream(Instence: TObject; var Params: Variant): Variant;
    function frxVairiables_ItemsGet(Instence: TObject; var Params: Variant): Variant;
    function frxVairiables_VariablesGet(Instence: TObject; var Params: Variant): Variant;
    function frxVariables_VariablesSet(Instence: TObject; var Params: Variant): Variant;
    {TfrxDataSets}
    function frxRepDataSets_Add(Instence: TObject; var Params: Variant): Variant;
    function frxRepDataSets_Find(Instence: TObject; var Params: Variant): Variant;
    function frxRepDataSets_FindByName(Instence: TObject; var Params: Variant): Variant;
    function frxRepDataSets_Delete(Instence: TObject; var Params: Variant): Variant;
    function frxRepDataSets_DeleteByName(Instence: TObject; var Params: Variant): Variant;
    function frxRepDataSets_ItemsGet(Instence: TObject; var Params: Variant): Variant;
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure AddConsts(AddConst: TAddConstProc); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
  end;

  TfrxGetValueHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(const VarName: String; var Value: Variant);
  end;

  TfrxNewGetValueHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; const VarName: String; var Value: Variant);
  end;

  { TfrxUserFunctionHandler }

  TfrxUserFunctionHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    function CallHandler(const AMethodName: String;
      var Params: Variant): Variant;
  end;

  TfrxClickObjectHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TfrxView;
      Button: TMouseButton; Shift: TShiftState; var Modified: Boolean);
  end;

implementation

uses frxVariables, frxDBSet, frxDesgn, frxPreview, dpEvntHadlrs,
  frxChBox, frxGradient, frxCross
  {frxExportPDF, frxExportHTML, frxExportXLS,
  frxExportXML, frxExportRTF, frxExportImage, frxExportODF, frxExportMail,
  frxExportTXT, frxExportCSV};

procedure TFRImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TfrxStretchMode));
  AddType(TypeInfo(TfrxShiftMode));
  AddType(TypeInfo(TfrxDuplexMode));
  AddType(TypeInfo(TfrxAlign));
  AddType(TypeInfo(TfrxFrameStyle));
  AddType(TypeInfo(TfrxFrameTypes));
  AddType(TypeInfo(TfrxHAlign));
  AddType(TypeInfo(TfrxVAlign));
  AddType(TypeInfo(TfrxRestrictions));
  AddType(TypeInfo(TfrxShapeKind));
  AddType(TypeInfo(TfrxPreviewButtons));
  AddType(TypeInfo(TfrxZoomMode));
  AddType(TypeInfo(TfrxPrintPages));
  //AddType(TypeInfo(TfrxDMPFontStyles));
  AddType(TypeInfo(TfrxRangeBegin));
  AddType(TypeInfo(TfrxRangeEnd));
  AddType(TypeInfo(TfrxFieldType));
  AddType(TypeInfo(TfrxFormatKind));

end;

procedure TFRImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddClass(TfrxStyles);
  AddClass(TfrxVariable);
  AddClass(TfrxVariables).ClassImporter := Self;
  AddClass(TfrxDataSet).ClassImporter := Self;
  AddClass(TfrxUserDataSet);
  AddClass(TfrxCustomDBDataSet);
  AddClass(TfrxDBDataSet);
  AddClass(TfrxDataSetItem);
  AddClass(TfrxReportDataSets).ClassImporter := Self;

  AddClass(TfrxComponent).ClassImporter := Self;
  AddClass(TfrxCustomEngine).ClassImporter := Self;
  AddClass(TfrxReport).ClassImporter := Self;

  AddClass(TfrxDesigner);
  AddClass(TfrxPreview);
  AddClass(TfrxCheckBoxObject);
  AddClass(TfrxGradientObject);
  AddClass(TfrxCrossObject);

  {AddClass(TfrxPDFExport);
  AddClass(TfrxHTMLExport);
  AddClass(TfrxXLSExport);
  AddClass(TfrxXMLExport);
  AddClass(TfrxRTFExport);
  AddClass(TfrxBMPExport);
  AddClass(TfrxJPEGExport);
  AddClass(TfrxTIFFExport);
  AddClass(TfrxGIFExport);
  AddClass(TfrxTXTExport);
  AddClass(TfrxCSVExport);
  AddClass(TfrxMailExport);
  AddClass(TfrxODFExport);
  AddClass(TfrxODSExport);
  AddClass(TfrxODTExport);}
end;

procedure TFRImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TfrxComponent then
  begin

  end
  else
  if AType.ValueClassType = TfrxReport then
  begin
    AType.AddMethod('function GetDataset(const Alias: String): TfrxDataset', @TfrxReport_GetDataSet);
    AType.AddMethod('function LoadFromFile(const FileName: String): Boolean', @TfrxReport_LoadFromFile);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @TfrxReport_LoadFromStream);
    AType.AddMethod('procedure SaveToFile(const FileName: String)', @TfrxReport_SaveToFile);
    AType.AddMethod('procedure ShowReport', @TfrxReport_ShowReport);
    AType.AddMethod('procedure DesignReport(ShowModal: Boolean = True; MDIChild: Boolean = False)', @TfrxReport_DesignReport);
    AType.AddMethod('procedure AddFunction(FunctionName, Category, Description: string)', @TfrxReport_AddFunction);

    AType.AddProp('Terminated', 'Boolean', @TfrxReport_GetTerminated, @TfrxReport_SetTerminated);
    AType.AddProp('Variables', 'TfrxVariables', @TfrxReport_GetVariables, nil);
    AType.AddProp('Styles', 'TfrxStyles', @TfrxReport_GetStyles, nil);
    AType.AddProp('DataSets', 'TfrxReportDataSets', @TfrxReport_DataSets);
  end
  else
  if AType.ValueClassType = TfrxDataSet then
  begin
    AType.AddMethod('procedure Open', @TfrxDataSet_Open);
    AType.AddMethod('procedure Close', @TfrxDataSet_Close);
    AType.AddMethod('procedure First', @TfrxDataSet_First);
    AType.AddMethod('procedure Next', @TfrxDataSet_Next);
    AType.AddMethod('procedure Prior', @TfrxDataSet_Prior);
    AType.AddMethod('function Eof: Boolean', @TfrxDataSet_Eof);
    AType.AddMethod('function FieldsCount: Integer', @TfrxDataSet_FieldsCount);
    AType.AddMethod('function HasField(const fName: String): Boolean', @TfrxDataSet_HasField);
    AType.AddMethod('function IsBlobField(const fName: String): Boolean', @TfrxDataSet_IsBlobField);
    AType.AddMethod('function RecordCount: Integer', @TfrxDataSet_RecordCount);
    AType.AddMethod('procedure GetFieldList(List: TStrings)', @TfrxDataSet_GetFieldList);
    AType.AddProp('RecNo', 'Integer', @TfrxDataSet_RecNo, nil);
    AType.AddIndexedProp('DisplayText', 'String', 'String', @TfrxDataSet_GetDisplayText, nil);
  end
  else
  if AType.ValueClassType = TfrxVariables then
  begin
    AType.AddMethod('function Add: TfrxVariable', @frxVariables_Add);
    AType.AddMethod('function Insert(Index: Integer): TfrxVariable', @frxVariables_Insert);
    AType.AddMethod('function IndexOf(const Name: String): Integer', @frxVariables_IndexOf);
    AType.AddMethod('procedure AddVariable(const ACategory, AName: String; const AValue: Variant)', @frxVariables_AddVariable);
    AType.AddMethod('procedure DeleteCategory(const Name: String)', @frxVariables_DeleteCategory);
    AType.AddMethod('procedure DeleteVariable(const Name: String)', @frxVariables_DeleteVariable);
    AType.AddMethod('procedure GetCategoriesList(List: TStrings; ClearList: Boolean = True)', @frxVariables_GetCategoriesList);
    AType.AddMethod('procedure GetVariablesList(const Category: String; List: TStrings)', @frxVariables_GetVariablesList);
    AType.AddMethod('procedure LoadFromFile(const FileName: String)', @frxVariables_LoadFromFile);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @frxVariables_LoadFromStream);
    AType.AddMethod('procedure SaveToFile(const FileName: String)', @frxVariables_SaveToFile);
    AType.AddMethod('procedure SaveToStream(Stream: TStream)', @frxVariables_SaveToStream);
    AType.AddIndexedProp('Items', 'TfrxVariable', 'Integer', @frxVairiables_ItemsGet);
    AType.AddIndexedProp('Variables', 'Variant', 'string', @frxVairiables_VariablesGet, @frxVariables_VariablesSet);
  end
  else
  if AType.ValueClassType = TfrxReportDataSets then
  begin
    AType.AddMethod('procedure Add(ds: TfrxDataSet)', @frxRepDataSets_Add);
    AType.AddMethod('function Find(ds: TfrxDataSet): TfrxDataSetItem', @frxRepDataSets_Find);
    AType.AddMethod('function FindByName(const Name: String): TfrxDataSetItem', @frxRepDataSets_FindByName);
    AType.AddMethod('procedure Delete(const Index: Integer)', @frxRepDataSets_Delete);
    AType.AddMethod('procedure DeleteByName(const Name: String)', @frxRepDataSets_DeleteByName);
    AType.AddIndexedProp('Items', 'TfrxDataSetItem', 'Integer', @frxRepDataSets_ItemsGet);
  end;
end;

procedure TFRImport.AddConsts(AddConst: TAddConstProc);
begin
  AddConst('fr01cm', 'Extended', fr01cm);
  AddConst('fr1cm', 'Extended', fr1cm);
  AddConst('fr01in', 'Extended', fr01in);
  AddConst('fr1in', 'Extended', fr1in);
  AddConst('fr1CharX', 'Extended', fr1CharX);
  AddConst('fr1CharY', 'Extended', fr1CharY);
  AddConst('clTransparent', 'Integer', clTransparent);
  AddConst('crHand', 'Integer', crHand);
  AddConst('crZoom', 'Integer', crZoom);
  AddConst('crFormat', 'Integer', crFormat);
end;

procedure TFRImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TfrxBeforePrintEvent), TSuNotifyHandler);
  RegisterHandler(TypeInfo(TfrxManualBuildEvent), TSuNotifyHandler);
  RegisterHandler(TypeInfo(TfrxMouseOverObjectEvent), TSuNotifyHandler);
  RegisterHandler(TypeInfo(TfrxRunDialogEvent), TSuNotifyHandler);
  RegisterHandler(TypeInfo(TfrxAfterDisconnectEvent), TSuNotifyHandler);
  RegisterHandler(TypeInfo(TfrxGetValueEvent), TfrxGetValueHandler);
  RegisterHandler(TypeInfo(TfrxNewGetValueEvent), TfrxNewGetValueHandler);
  RegisterHandler(TypeInfo(TfrxUserFunctionEvent), TfrxUserFunctionHandler);
  RegisterHandler(TypeInfo(TfrxClickObjectEvent), TfrxClickObjectHandler);
  RegisterHandler(TypeInfo(TfrxCheckEOFEvent), TObjVarBoolHandler);
  RegisterHandler(TypeInfo(TfrxPrintPageEvent), TSenderIntegerHandler);
end;

{TfrxReport support}

function TFRImport.TfrxReport_GetDataSet(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TfrxReport(Instence).GetDataset(Params[0]));
end;

function TFRImport.TfrxReport_LoadFromFile(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TfrxReport(Instence).LoadFromFile(Params[0]);
end;

function TFRImport.TfrxReport_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrxReport(Instance).LoadFromStream(TStream( TSuPtr( Params[0] )));
end;

function TFRImport.TfrxReport_SaveToFile(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxReport(Instence).SaveToFile(Params[0]);
end;

function TFRImport.TfrxReport_ShowReport(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxReport(Instence).ShowReport;
end;

function TFRImport.TfrxReport_DesignReport(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxReport(Instence).DesignReport(Boolean(Params[0]), Boolean(Params[1]));
end;

function TFRImport.TfrxReport_AddFunction(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxReport(Instence).AddFunction(Params[0], Params[1], Params[2]);
end;

function TFRImport.TfrxReport_GetTerminated(Instence: Pointer): Variant;
begin
  Result := TfrxReport(Instence).Terminated;
end;

procedure TFRImport.TfrxReport_SetTerminated(Instence: Pointer; AValue: Variant);
begin
  TfrxReport(Instence).Terminated := AValue;
end;

function TFRImport.TfrxReport_GetVariables(Instence: Pointer): Variant;
begin
  Result := TSuPtr(TfrxReport(Instence).Variables);
end;

function TFRImport.TfrxReport_GetStyles(Instence: Pointer): Variant;
begin
  Result := TSuPtr(TfrxReport(Instence).Styles);
end;

function TFRImport.TfrxReport_DataSets(Instence: Pointer): Variant;
begin
  Result := TSuPtr(TfrxReport(Instence).DataSets);
end;

{TfrxDataSet support}

function TFRImport.TfrxDataSet_Open(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxDataSet(Instence).Open;
end;

function TFRImport.TfrxDataSet_Close(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxDataSet(Instence).Close;
end;

function TFRImport.TfrxDataSet_First(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxDataSet(Instence).First;
end;

function TFRImport.TfrxDataSet_Next(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxDataSet(Instence).Next;
end;

function TFRImport.TfrxDataSet_Prior(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxDataSet(Instence).Prior;
end;

function TFRImport.TfrxDataSet_Eof(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TfrxDataSet(Instence).Eof
end;

function TFRImport.TfrxDataSet_FieldsCount(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TfrxDataSet(Instence).FieldsCount;
end;

function TFRImport.TfrxDataSet_HasField(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TfrxDataSet(Instence).HasField(Params[0]);
end;

function TFRImport.TfrxDataSet_IsBlobField(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TfrxDataSet(Instence).IsBlobField(Params[0]);
end;

function TFRImport.TfrxDataSet_RecordCount(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TfrxDataSet(Instence).RecordCount;
end;

function TFRImport.TfrxDataSet_GetFieldList(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxDataSet(Instence).GetFieldList(TStrings(TSuPtr(Params[0])));
end;

function TFRImport.TfrxDataSet_RecNo(Instence: Pointer): Variant;
begin
  Result := TfrxDataSet(Instence).RecNo;
end;

function TFRImport.TfrxDataSet_GetDisplayText(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TfrxDataSet(Instence).DisplayText[Params[0]]
end;

{TfrxVariables}
function TFRImport.frxVariables_Add(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TfrxVariables(Instence).Add);
end;

function TFRImport.frxVariables_Insert(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TfrxVariables(Instence).Insert(Params[0]))
end;

function TFRImport.frxVariables_IndexOf(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TfrxVariables(Instence).IndexOf(Params[0])
end;

function TFRImport.frxVariables_AddVariable(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxVariables(Instence).AddVariable(Params[0], Params[1], Params[2]);
end;

function TFRImport.frxVariables_DeleteCategory(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxVariables(Instence).DeleteCategory(Params[0]);
end;

function TFRImport.frxVariables_DeleteVariable(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxVariables(Instence).DeleteVariable(Params[0]);
end;

function TFRImport.frxVariables_GetCategoriesList(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxVariables(Instence).GetCategoriesList(TStrings(TSuPtr(Params[0])), Params[1]);
end;

function TFRImport.frxVariables_GetVariablesList(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxVariables(Instence).GetVariablesList(Params[0], TStrings(TSuPtr(Params[0])));
end;

function TFRImport.frxVariables_LoadFromFile(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxVariables(Instence).LoadFromFile(Params[0]);
end;

function TFRImport.frxVariables_LoadFromStream(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxVariables(Instence).LoadFromStream(TStream(TSuPtr(Params[0])));
end;

function TFRImport.frxVariables_SaveToFile(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxVariables(Instence).SaveToFile(Params[0]);
end;

function TFRImport.frxVariables_SaveToStream(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxVariables(Instence).SaveToStream(TStream(TSuPtr(Params[0])));
end;

function TFRImport.frxVairiables_ItemsGet(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TfrxVariables(Instence).Items[Params[0]])
end;

function TFRImport.frxVairiables_VariablesGet(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TfrxVariables(Instence).Variables[Params[0]]
end;

function TFRImport.frxVariables_VariablesSet(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxVariables(Instence).Variables[Params[0]] := Params[1]
end;

{TfrxReportDataSets}
function TFRImport.frxRepDataSets_Add(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxReportDataSets(Instence).Add(TfrxDataSet(TSuPtr(Params[0])));
end;

function TFRImport.frxRepDataSets_Find(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TfrxReportDataSets(Instence).Find(TfrxDataSet(TSuPtr(Params[0]))));
end;

function TFRImport.frxRepDataSets_FindByName(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TfrxReportDataSets(Instence).Find(string(Params[0])))
end;

function TFRImport.frxRepDataSets_Delete(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxReportDataSets(Instence).Delete(Integer(Params[0]));
end;

function TFRImport.frxRepDataSets_DeleteByName(Instence: TObject; var Params: Variant): Variant;
begin
  TfrxReportDataSets(Instence).Delete(string(Params[0]));
end;

function TFRImport.frxRepDataSets_ItemsGet(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TfrxReportDataSets(Instence).Items[Params[0]])
end;

{Support FR Event Handlers}

function TfrxGetValueHandler.GetHandlerAdres: Pointer;
begin
  Result := @TfrxGetValueHandler.CallHandler;
end;

procedure TfrxGetValueHandler.CallHandler(const VarName: String; var Value: Variant);
begin
  if Proc.ParamCount = 2 then
  begin
    Proc.Param[0].Value := Varname;
    Proc.Param[1].Value := Value;
    Proc.Exec;
    Value := Proc.Param[1].Value;
  end;
end;

function TfrxNewGetValueHandler.GetHandlerAdres: Pointer;
begin
  Result := @TfrxNewGetValueHandler.CallHandler;
end;

procedure TfrxNewGetValueHandler.CallHandler(Sender: TObject; const VarName: String; var Value: Variant);
begin
  if Proc.ParamCount = 3 then
  begin
    Proc.Param[0].Value := TSuPtr(Sender);
    Proc.Param[1].Value := Varname;
    Proc.Param[2].Value := Value;
    Value := Proc.Param[2].Value;
  end;
end;

function TfrxUserFunctionHandler.GetHandlerAdres: Pointer;
begin
  Result := @TfrxUserFunctionHandler.CallHandler;
end;

function TfrxUserFunctionHandler.CallHandler(const AMethodName: String;
  var Params: Variant): Variant;
begin
  if Proc.ParamCount = 2 then
  begin
    Proc.Param[0].Value := AMethodName;
    Proc.Param[1].Value := Params;
    Result := Proc.Value;
    Params := Proc.Param[1].Value;
  end;
end;

function TfrxClickObjectHandler.GetHandlerAdres: Pointer;
begin
  Result := @TfrxClickObjectHandler.CallHandler;
end;

procedure TfrxClickObjectHandler.CallHandler(Sender: TfrxView;
      Button: TMouseButton; Shift: TShiftState; var Modified: Boolean);
var
  P: PShiftState;
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Button;
  P := PShiftState(TSuPtr(Proc.Param[2].Value));
  P^ := Shift;
  Proc.Param[3].Value := Modified;
  Proc.Exec;
  Modified := Proc.Param[3].Value;
end;

end.

