unit LangTransCode;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, dpi_parser, AppConst;

function GetKeyOfLangID(TokenID: TIdentToken): string;
function GetTransName(OriginalName: string): string;

implementation

uses LazUTF8;

function GetKeyOfLangID(TokenID: TIdentToken): string;
begin
  Result := '';
  if LangID = 0 then
    case TokenID of
      ID_and: Result := 'and';
      ID_array: Result := 'array';
      ID_begin: Result := 'begin';
      ID_case: Result := 'case';
      ID_const: Result := 'const';
      ID_div: Result := 'div';
      ID_do: Result := 'do';
      ID_downto: Result := 'downto';
      ID_else: Result := 'else';
      ID_elseif: Result := 'elseif';
      ID_end: Result := 'end';
      ID_for: Result := 'for';
      ID_function: Result := 'function';
      ID_if: Result := 'if';
      ID_in: Result := 'in';
      ID_mod: Result := 'mod';
      ID_not: Result := 'not';
      ID_of: Result := 'of';
      ID_or: Result := 'or';
      ID_procedure: Result := 'procedure';
      ID_method: Result := 'method';
      ID_program: Result := 'program';
      ID_repeat: Result := 'repeat';
      ID_record: Result := 'record';
      ID_set: Result := 'set';
      ID_shl: Result := 'shl';
      ID_shr: Result := 'shr';
      ID_then: Result := 'then';
      ID_to: Result := 'to';
      ID_type: Result := 'type';
      ID_until: Result := 'until';
      ID_Break: Result := 'break';
      ID_Continue: Result := 'continue';
      ID_Exit: Result := 'Exit';
      ID_uses: Result := 'uses';
      ID_var: Result := 'var';
      ID_while: Result := 'while';
      ID_with: Result := 'with';
      ID_xor: Result := 'xor';
      ID_class: Result := 'class';
      ID_constructor: Result := 'constructor';
      ID_destructor: Result := 'destructor';
      ID_inherited: Result := 'inherited';
      ID_private: Result := 'private';
      ID_public: Result := 'public';
      ID_published: Result := 'published';
      ID_protected: Result := 'protected';
      ID_property: Result := 'property';
      ID_virtual: Result := 'virtual';
      ID_override: Result := 'override';
      ID_overload: Result := 'overload';
      ID_As: Result := 'as';
      ID_Is: Result := 'is';
      ID_Unit: Result := 'unit';
      ID_Try: Result := 'try';
      ID_Except: Result := 'except';
      ID_On: Result := 'on';
      ID_Finally: Result := 'finally';
      ID_External: Result := 'external';
      ID_Forward: Result := 'forward';
      ID_Export: Result := 'export';
      ID_Label: Result := 'label';
      ID_Goto: Result := 'goto';
      ID_Chr: Result := 'chr';
      //ID_Ord: Result := 'ord';
      ID_Interface: Result := 'interface';
      ID_Implementation: Result := 'implementation';
      ID_initialization: Result := 'initialization';
      ID_finalization: Result := 'finalization';
      ID_out: Result := 'out';
      ID_nil: Result := 'nil';
      ID_False: Result := 'False';
      ID_True: Result := 'True';
    end
  else
    case TokenID of
      ID_and: Result := KeyAnd;
      ID_array: Result := KeyArray;
      ID_begin: Result := KeyBegin;
      ID_case: Result := KeyCase;
      ID_const: Result := KeyConst;
      ID_div: Result := KeyDiv;
      ID_do: Result := KeyDo;
      ID_downto: Result := KeyDownto;
      ID_else: Result := KeyElse;
      ID_elseif: Result := KeyElseif;
      ID_end: Result := KeyEnd;
      ID_for: Result := KeyFor;
      ID_function: Result := KeyFunction;
      ID_if: Result := KeyIf;
      ID_in: Result := KeyIn;
      ID_mod: Result := KeyMod;
      ID_not: Result := KeyNot;
      ID_of: Result := KeyOf;
      ID_or: Result := KeyOr;
      ID_procedure: Result := KeyProcedure;
      ID_method: Result := KeyMethod;
      ID_program: Result := KeyProgram;
      ID_repeat: Result := KeyRepeat;
      ID_record: Result := KeyRecord;
      ID_set: Result := KeySet;
      ID_shl: Result := KeyShl;
      ID_shr: Result := KeyShr;
      ID_then: Result := KeyThen;
      ID_to: Result := KeyTo;
      ID_type: Result := KeyType;
      ID_until: Result := KeyUntil;
      ID_Break: Result := KeyBreak;
      ID_Continue: Result := KeyContinue;
      ID_Exit: Result := KeyExit;
      ID_uses: Result := KeyUses;
      ID_var: Result := KeyVar;
      ID_while: Result := KeyWhile;
      ID_with: Result := KeyWith;
      ID_xor: Result := KeyXor;
      ID_class: Result := KeyClass;
      ID_constructor: Result := KeyConstr;
      ID_destructor: Result := KeyDestr;
      ID_inherited: Result := KeyInherited;
      ID_private: Result := KeyPrivate;
      ID_public: Result := KeyPublic;
      ID_published: Result := KeyPublished;
      ID_protected: Result := KeyProtected;
      ID_property: Result := KeyProperty;
      ID_virtual: Result := KeyVirtual;
      ID_override: Result := KeyOverride;
      ID_overload: Result := KeyOverload;
      ID_As: Result := KeyAs;
      ID_Is: Result := KeyIs;
      ID_Unit: Result := KeyUnit;
      ID_Try: Result := KeyTry;
      ID_Except: Result := KeyExcept;
      ID_On: Result := KeyOn;
      ID_Finally: Result := KeyFinally;
      ID_External: Result := KeyExternal;
      ID_Forward: Result := KeyForward;
      ID_Export: Result := KeyExport;
      ID_Label: Result := KeyLabel;
      //ID_Goto: Result := keygo;
      ID_Chr: Result := KeyChr;
      //ID_Ord: Result := KeyOrd;
      ID_Interface: Result := KeyInterface;
      ID_Implementation: Result := KeyImplement;
      ID_initialization: Result := KeyInitializ;
      ID_finalization: Result := KeyFinaliz;
      ID_out: Result := KeyOut;
      ID_nil: Result := KeyNil;
      ID_False: Result := KeyFalse;
      ID_True: Result := KeyTrue;
    end;
end;

function GetTransName(OriginalName: string): string;
var
  S: string;
begin
  Result := '';
  if LangID = 0 then
    Result := OriginalName
  else
  begin
    S := UTF8LowerCase(OriginalName);
    if S = 'aowner' then Result := 'Владелец'
    else
    if S = 'create' then Result := 'Создать'
    else
    if S = 'destructor' then Result := 'Разрушить';
  end;
end;

end.

