unit dpi_Records;

{$mode objfpc}{$H+}
{$M+}

interface

uses
  Classes, SysUtils, dpCompil;

type

  { TRecordsImport }

  TRecordsImport = class(TClassImporter)
  private
    function TRect_Height(Instance: Pointer): Variant;
    function TRect_Width(Instance: Pointer): Variant;
  public
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure RegisterPublic(AType: TDpType); override;
  published
    function TPoint_X_Get(Instance: Pointer): Variant;
    function TPoint_Y_Get(Instance: Pointer): Variant;
    procedure TPoint_X_Set(Instance: Pointer; AValue: Variant);
    procedure TPoint_Y_Set(Instance: Pointer; AValue: Variant);
    function TRect_Left_Get(Instance: Pointer): Variant;
    procedure TRect_Left_Set(Instance: Pointer; AValue: Variant);
    function TRect_Top_Get(Instance: Pointer): Variant;
    procedure TRect_Top_Set(Instance: Pointer; AValue: Variant);
    function TRect_Right_Get(Instance: Pointer): Variant;
    procedure TRect_Right_Set(Instance: Pointer; AValue: Variant);
    function TRect_Bottom_Get(Instance: Pointer): Variant;
    procedure TRect_Bottom_Set(Instance: Pointer; AValue: Variant);
  end;

implementation

uses GraphMath, LCLType;

function TRecordsImport.TRect_Height(Instance: Pointer): Variant;
begin
  Result := PRect(Instance)^.Height;
end;

function TRecordsImport.TRect_Width(Instance: Pointer): Variant;
begin
  Result := PRect(Instance)^.Width;
end;

procedure TRecordsImport.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
begin
  AddRecord('TPoint', SizeOf(TPoint)).ClassImporter := Self;
  AddRecord('TRect', SizeOf(TRect)).ClassImporter := Self;
  AddRecord('TFormatSettings', SizeOf(TFormatSettings)).ClassImporter := Self;
end;

procedure TRecordsImport.RegisterPublic(AType: TDpType);
begin
  if AType.Name = 'tpoint' then
  begin
    AType.AddProp('X', 'Integer', @TPoint_X_Get,  @TPoint_X_Set);
    AType.AddProp('Y', 'Integer', @TPoint_Y_Get,  @TPoint_Y_Set);
  end
  else
  if AType.Name = 'trect' then
  begin
    AType.AddProp('Left', 'Integer', @TRect_Left_Get,  @TRect_Left_Set);
    AType.AddProp('Top', 'Integer', @TRect_Top_Get,  @TRect_Top_Set);
    AType.AddProp('Right', 'Integer', @TRect_Right_Get,  @TRect_Right_Set);
    AType.AddProp('Bottom', 'Integer', @TRect_Bottom_Get,  @TRect_Bottom_Set);
    AType.AddProp('Width', 'Integer', @TRect_Width);
    AType.AddProp('Height', 'Integer', @TRect_Height);
  end;
end;

{TPoint}

function TRecordsImport.TPoint_X_Get(Instance: Pointer): Variant;
begin
  Result := PPoint(Instance)^.X;
end;

function TRecordsImport.TPoint_Y_Get(Instance: Pointer): Variant;
begin
  Result := PPoint(Instance)^.Y;
end;

procedure TRecordsImport.TPoint_X_Set(Instance: Pointer; AValue: Variant);
begin
  PPoint(Instance)^.X := AValue;
end;

procedure TRecordsImport.TPoint_Y_Set(Instance: Pointer; AValue: Variant);
begin
  PPoint(Instance)^.Y := AValue;
end;

{TRect}

function TRecordsImport.TRect_Left_Get(Instance: Pointer): Variant;
begin
  Result := Prect(Instance)^.Left;
end;

procedure TRecordsImport.TRect_Left_Set(Instance: Pointer; AValue: Variant);
begin
  Prect(Instance)^.Left := AValue;
end;

function TRecordsImport.TRect_Top_Get(Instance: Pointer): Variant;
begin
  Result := Prect(Instance)^.Top;
end;

procedure TRecordsImport.TRect_Top_Set(Instance: Pointer; AValue: Variant);
begin
  Prect(Instance)^.Top := AValue;
end;

function TRecordsImport.TRect_Right_Get(Instance: Pointer): Variant;
begin
  Result := Prect(Instance)^.Right;
end;

procedure TRecordsImport.TRect_Right_Set(Instance: Pointer; AValue: Variant);
begin
  Prect(Instance)^.Right := AValue;
end;

function TRecordsImport.TRect_Bottom_Get(Instance: Pointer): Variant;
begin
  Result := Prect(Instance)^.Bottom;
end;

procedure TRecordsImport.TRect_Bottom_Set(Instance: Pointer; AValue: Variant);
begin
  Prect(Instance)^.Bottom := AValue;
end;

end.

