unit dpi_DevartDB;

interface

uses SysUtils, Classes, dpCompil, TypInfo, Variants;

{$M+}

type

  { TDevartDacImport }

  TDevartDacImport = class(TClassImporter)
    function Blob_Clear(Instence: TObject; var Params: Variant): Variant;
    function CustomDAUpdateSQL_GetSQL(Instence: TObject; var Params: Variant
      ): Variant;
    function CustomDAUpdateSQL_SetSQL(Instence: TObject; var Params: Variant
      ): Variant;
    function DATransaction_Commit(Instence: TObject; var Params: Variant
      ): Variant;
    function DATransaction_GetDefaultCloseAction(Instance: Pointer): Variant;
    function DATransaction_GetDefaultConnection(Instance: Pointer): Variant;
    function DATransaction_Rollback(Instence: TObject; var Params: Variant
      ): Variant;
    procedure DATransaction_SetDefaultCloseAction(Instance: Pointer;
      AValue: Variant);
    procedure DATransaction_SetDefaultConnection(Instance: Pointer;
      AValue: Variant);
    function DATransaction_StartTransaction(Instence: TObject;
      var Params: Variant): Variant;
    function SharedObject_Disconnect(Instence: TObject; var Params: Variant
      ): Variant;

  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
       override;
    //procedure AddConsts(AddConst: TAddConstProc); override;
    //procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
    //procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
  published

    {TCustomDAConnection}
    function CustomDAConnection_Connect(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_Disconnect(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_PerformConnect(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_AssignConnect(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_ParamByName(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_ExecSQL(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_ExecSQLEx(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_ExecProc(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_ExecProcEx(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_GetTableNames(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_GetDatabaseNames(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_GetStoredProcNames(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_StartTransaction(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_Commit(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_Rollback(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_ApplyUpdates(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_RemoveFromPool(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_MonitorMessage(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_InTransaction(Instence: Pointer): Variant;

    {TBlob}
    function Blob_Create(Instence: TObject; var Params: Variant): Variant;
    function Blob_FreeBlob(Instence: TObject; var Params: Variant): Variant;
    function Blob_IsEmpty(Instence: TObject; var Params: Variant): Variant;
    function Blob_Compress(Instence: TObject; var Params: Variant): Variant;
    function Blob_Defrag(Instence: TObject; var Params: Variant): Variant;
    function Blob_AddCR(Instence: TObject; var Params: Variant): Variant;
    function Blob_RemoveCR(Instence: TObject; var Params: Variant): Variant;
    function Blob_LoadFromStream(Instence: TObject; var Params: Variant): Variant;
    function Blob_SaveToStream(Instence: TObject; var Params: Variant): Variant;
    function Blob_LoadFromFile(Instence: TObject; var Params: Variant): Variant;
    function Blob_SaveToFile(Instence: TObject; var Params: Variant): Variant;
    function Blob_Assign(Instence: TObject; var Params: Variant): Variant;
    function Blob_EnableRollback(Instence: TObject; var Params: Variant): Variant;
    function Blob_Commit(Instence: TObject; var Params: Variant): Variant;
    function Blob_Cancel(Instence: TObject; var Params: Variant): Variant;
    function Blob_CanRollback(Instence: TObject; var Params: Variant): Variant;
    function Blob_SizeGet(Instence: Pointer): Variant;
    procedure Blob_SizeSet(Instence: Pointer; AValue: Variant);
    function Blob_AsStringGet(Instence: Pointer): Variant;
    procedure Blob_AsStringSet(Instence: Pointer; AValue: Variant);
    function Blob_RollbackEnabledGet(Instence: Pointer): Variant;
    procedure Blob_RollbackEnabledSet(Instence: Pointer; AValue: Variant);
    function Blob_GetUseRollback(Instence: Pointer): Variant;
    procedure Blob_SetUseRollback(Instence: Pointer; AValue: Variant);

    {TMemDataSet}
    {function MemDataSet_Prepare(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_UnPrepare(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_CheckPrepared(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_DeferredPost(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_CommitUpdates(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_CancelUpdates(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_RestoreUpdates(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_RevertRecord(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_SaveToXML(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_IsSequenced(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_GetBlob(Instence: TObject; var Params: Variant): Variant;}

    //TCustomDADataSet
    function DADataSet_Disconnected_Get(Instance: Pointer): Variant;
    function DADataSet_ParamCount_Get(Instance: Pointer): Variant;
    function DADataSet_MacroCount_Get(Instance: Pointer): Variant;
    function DADataSet_Lock(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_UnLock(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_Execute(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_ExecSQL(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_Executing(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_Fetching(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_FetchingAll(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_Fetched(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_BreakExec(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_RefreshRecord(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_SaveSQL(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_RestoreSQL(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_SQLSaved(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_AddWhere(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_DeleteWhere(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_SetOrderBy(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_GetOrderBy(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_DeferredPost(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_MacroByName(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_ParamByName(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_FindParam(Instence: TObject; var Params: Variant): Variant;
    function DADataSet_FindMacro(Instence: TObject; var Params: Variant): Variant;

    //TCustomDASQL
    function CustomDASQL_Prepare(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_UnPrepare(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_ParamByName(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_FindParam(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_FindMacro(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_Execute(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_ExecuteIters(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_Executing(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_WaitExecuting(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_MacroByName(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_Prepared(Instence: Pointer): Variant;

    //TCustomDAUpdateSQL
    function CustomDAUpdateSQL_Apply(Instence: TObject; var Params: Variant): Variant;
    function CustomDAUpdateSQL_ExecSQL(Instence: TObject; var Params: Variant): Variant;

    //TDAMetaData
    function DAMetaData_GetMetaDataKinds(Instence: TObject; var Params: Variant): Variant;
    function DAMetaData_GetRestrictions(Instence: TObject; var Params: Variant): Variant;

    //TDAScript
    function DAScript_Execute(Instence: TObject; var Params: Variant): Variant;
    function DAScript_ExecuteNext(Instence: TObject; var Params: Variant): Variant;
    function DAScript_ExecuteStream(Instence: TObject; var Params: Variant): Variant;
    function DAScript_ExecuteFile(Instence: TObject; var Params: Variant): Variant;
    function DAScript_BreakExec(Instence: TObject; var Params: Variant): Variant;
    function DAScript_ErrorOffset(Instence: TObject; var Params: Variant): Variant;

    function DAScript_ParamsGet(Instance: Pointer): Variant;
    function DAScript_AutoCommitGet(Instance: Pointer): Variant;
    procedure DAScript_AutoCommitSet(Instance: Pointer; AValue: Variant);
    function DAScript_StartPosGet(Instance: Pointer): Variant;
    function DAScript_EndPosGet(Instance: Pointer): Variant;
    function DAScript_StartLineGet(Instance: Pointer): Variant;
    function DAScript_EndLineGet(Instance: Pointer): Variant;
    function DAScript_StartOffsetGet(Instance: Pointer): Variant;
    function DAScript_EndOffsetGet(Instance: Pointer): Variant;

    function CustConnDlg_Execute(Instence: TObject; var Params: Variant): Variant;
    function CustConnDlg_GetServerList(Instence: TObject; var Params: Variant): Variant;

    function DAParams_ParamByName(Instence: TObject; var Params: Variant): Variant;
    function DAParams_FindParam(Instence: TObject; var Params: Variant): Variant;
    function DAParams_CreateParam(Instence: TObject; var Params: Variant): Variant;

    function DAParams_GetItem(Instence: TObject; var Params: Variant): Variant;
    function DAParams_SetItem(Instence: TObject; var Params: Variant): Variant;

    {DAAlerter}
    function DAAlerter_Stop(Instence: TObject; var Params: Variant): Variant;
    function DAAlerter_Start(Instence: TObject; var Params: Variant): Variant;
    function DAAlerter_SendEvent(Instence: TObject; var Params: Variant
      ): Variant;

    {DALoader}
    function DAColumns_GetColumn(Instence: TObject; var Params: Variant
      ): Variant;
    function DAColumns_SetColumn(Instence: TObject; var Params: Variant
      ): Variant;

    function DALoader_CreateColumns(Instence: TObject; var Params: Variant
      ): Variant;
    function DALoader_Load(Instence: TObject; var Params: Variant): Variant;
    function DALoader_LoadFromDataSet(Instence: TObject; var Params: Variant
      ): Variant;
    function DALoader_PutColumnData(Instence: TObject; var Params: Variant
      ): Variant;
    function DALoader_PutColumnDataOfName(Instence: TObject; var Params: Variant
      ): Variant;
  end;

implementation

uses DBAccess, DB, CRAccess, DAAlerter,// MemDS,
  DAScript, DASQLMonitor, MemData, CREncryption, DALoader;

type
  TOnSQLMonitorHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Text: string; Flag: TDATraceFlag);
  end;

  { TConnectChangeEventHandler }

  TConnectChangeEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Connecting: Boolean);
  end;

  { TBeforeExecuteEventHandler }

  TBeforeExecuteEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject);
  end;

  { TAfterExecuteEventHandler }

  TAfterExecuteEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Result: boolean);
  end;

  { TUpdateExecuteEventHandler }
  PStatementTypes = ^TStatementTypes;

  TUpdateExecuteEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TDataSet; StatementTypes: TStatementTypes;
      Params: TDAParams);
  end;

  { TBeforeFetchEventHandler }

  TBeforeFetchEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(DataSet: TCustomDADataSet; var Cancel: boolean);
  end;

  { TAfterFetchEventHandler }

  TAfterFetchEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(DataSet: TCustomDADataSet);
  end;

{ TAfterFetchEventHandler }

function TAfterFetchEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TAfterFetchEventHandler.CallHandler;
end;

procedure TAfterFetchEventHandler.CallHandler(DataSet: TCustomDADataSet);
begin
  Proc.Param[0].Value := TSuPtr(DataSet);
  Proc.Exec;
end;

{ TBeforeFetchEventHandler }

function TBeforeFetchEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TBeforeFetchEventHandler.CallHandler;
end;

procedure TBeforeFetchEventHandler.CallHandler(DataSet: TCustomDADataSet;
  var Cancel: boolean);
begin
  Proc.Param[0].Value := TSuPtr(DataSet);
  Proc.Param[1].Value := Cancel;
  Proc.Exec;
  Cancel := Proc.Param[1].Value;
end;

{ TUpdateExecuteEventHandler }

function TUpdateExecuteEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TUpdateExecuteEventHandler.CallHandler;
end;

procedure TUpdateExecuteEventHandler.CallHandler(Sender: TDataSet;
  StatementTypes: TStatementTypes; Params: TDAParams);
var
  PSet: PStatementTypes;
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  PSet := PStatementTypes(TSuPtr(Proc.Param[1]));
  PSet^ := StatementTypes;
  Proc.Param[1].Value := TSuPtr(PSet);
  Proc.Param[2].Value := TSuPtr(Params);
  Proc.Exec;
end;

{ TAfterExecuteEventHandler }

function TAfterExecuteEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TAfterExecuteEventHandler.CallHandler;
end;

procedure TAfterExecuteEventHandler.CallHandler(Sender: TObject; Result: boolean
  );
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Result;
  Proc.Exec;
end;

{ TBeforeExecuteEventHandler }

function TBeforeExecuteEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TBeforeExecuteEventHandler.CallHandler;
end;

procedure TBeforeExecuteEventHandler.CallHandler(Sender: TObject);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Exec;
end;

{ TConnectChangeEventHandler }

function TConnectChangeEventHandler.GetHandlerAdres: Pointer;
begin
  Result:= @TConnectChangeEventHandler.CallHandler;
end;

procedure TConnectChangeEventHandler.CallHandler(Sender: TObject;
  Connecting: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Connecting;
  Proc.Exec;
end;


function TOnSQLMonitorHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnSQLMonitorHandler.CallHandler;
end;

procedure TOnSQLMonitorHandler.CallHandler(Sender: TObject; Text: string; Flag: TDATraceFlag);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Text;
  Proc.Param[2].Value := Flag;
  Proc.Exec;
end;

{TDevartDacImport}

procedure TDevartDacImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TOnSQLEvent), TOnSQLMonitorHandler);
  RegisterHandler(TypeInfo(TConnectChangeEvent), TConnectChangeEventHandler);
  RegisterHandler(TypeInfo(TBeforeExecuteEvent), TBeforeExecuteEventHandler);
  RegisterHandler(TypeInfo(TAfterExecuteEvent), TAfterExecuteEventHandler);
  RegisterHandler(TypeInfo(TUpdateExecuteEvent), TUpdateExecuteEventHandler);
  RegisterHandler(TypeInfo(TBeforeFetchEvent), TBeforeFetchEventHandler);
  RegisterHandler(TypeInfo(TAfterFetchEvent), TAfterFetchEventHandler);
end;


function TDevartDacImport.Blob_Clear(Instence: TObject; var Params: Variant
  ): Variant;
begin
  TBlob(Instence).Clear;
end;

function TDevartDacImport.CustomDAUpdateSQL_GetSQL(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDAUpdateSQL(Instence).SQL[Params[0]]);
end;

function TDevartDacImport.CustomDAUpdateSQL_SetSQL(Instence: TObject;
  var Params: Variant): Variant;
begin
  TCustomDAUpdateSQL(Instence).SQL[Params[0]] := TStrings(TSuPtr(Params[1]));
end;

function TDevartDacImport.DATransaction_Commit(Instence: TObject;
  var Params: Variant): Variant;
begin
  TDATransaction(Instence).Commit;
end;

function TDevartDacImport.DATransaction_GetDefaultCloseAction(Instance: Pointer
  ): Variant;
begin
  Result := TDATransaction(Instance).DefaultCloseAction;
end;

function TDevartDacImport.DATransaction_GetDefaultConnection(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr(TDATransaction(Instance).DefaultConnection);
end;

function TDevartDacImport.DATransaction_Rollback(Instence: TObject;
  var Params: Variant): Variant;
begin
  TDATransaction(Instence).Rollback;
end;

procedure TDevartDacImport.DATransaction_SetDefaultCloseAction(
  Instance: Pointer; AValue: Variant);
begin
  TDATransaction(Instance).DefaultCloseAction := AValue;
end;

procedure TDevartDacImport.DATransaction_SetDefaultConnection(
  Instance: Pointer; AValue: Variant);
begin
   TDATransaction(Instance).DefaultConnection := TCustomDAConnection(TSuPtr(AValue));
end;

function TDevartDacImport.DATransaction_StartTransaction(Instence: TObject;
  var Params: Variant): Variant;
begin
  TDATransaction(Instence).StartTransaction;
end;

function TDevartDacImport.SharedObject_Disconnect(Instence: TObject;
  var Params: Variant): Variant;
begin
  TSharedObject(Instence).Disconnect;
end;

procedure TDevartDacImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TRefreshOption));
  AddType(TypeInfo(TDATraceFlag));
  AddType(TypeInfo(TMonitorOptions));
  AddType(TypeInfo(TConnectDialogOptionKind));
  AddType(TypeInfo(TCRHashAlgorithm));
  AddType(TypeInfo(TCREncDataHeader));
  AddType(TypeInfo(TCREncryptionAlgorithm));
  AddType(TypeInfo(TCRInvalidHashAction));
  AddType(TypeInfo(TCheckMode));
  AddType(TypeInfo(TRetryMode));
  AddType(TypeInfo(TDAColumnDataType));

  AddType(TypeInfo(TCRIsolationLevel));
  AddType(TypeInfo(TCRTransactionAction));
  AddType(TypeInfo(TParamDirection));
  AddType(TypeInfo(TStatementType));
  AddType(TypeInfo(TStatementTypes));

end;

procedure TDevartDacImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddClass(TSQLInfo);
  AddClass(TCustomDADataSet);
  AddClass(TMacros);
  AddClass(TMacro);
  AddClass(TDAParams).ClassImporter := Self;
  AddClass(TDAParam).ClassImporter := Self;
  AddClass(TDBMonitorOptions).ClassImporter := Self;
  AddClass(TSharedObject).ClassImporter := Self;

  AddClass(TCustomDAConnection).ClassImporter := Self;
  AddClass(TDATransaction).ClassImporter := Self;
  AddClass(TBlob).ClassImporter := Self;
 // AddClass(TMemDataSet).ClassImporter := Self;
  AddClass(TCustomDADataSet).ClassImporter := Self;
  AddClass(TCustomDASQL).ClassImporter := Self;
  AddClass(TDAScript).ClassImporter := Self;
  AddClass(TCustomDAUpdateSQL).ClassImporter := Self;
  AddClass(TDAMetaData).ClassImporter := Self;
  AddClass(TConnectDialogOption).ClassImporter := Self;
  AddClass(TCustomConnectDialog).ClassImporter := Self;
  AddClass(TDASQLGenerator);
  AddClass(TCREncryptor).ClassImporter := Self;
  AddClass(TDAAlerter).ClassImporter := Self;
  AddClass(TDAColumn);
  AddClass(TDAColumns).ClassImporter := Self;
  AddClass(TDALoader).ClassImporter := Self;
  AddClass(TCustomDASQLMonitor);
end;

procedure TDevartDacImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TDAParams then
  begin
    AType.AddMethod('function ParamByName(const Value: string): TDAParam', @DAParams_ParamByName);
    AType.AddMethod('function PN(const Value: string): TDAParam', @DAParams_ParamByName);
    AType.AddMethod('function FindParam(const Value: string): TDAParam', @DAParams_FindParam);
    AType.AddMethod('function CreateParam(FldType: TFieldType; const ParamName: string; ParamType: TParamType): TDAParam', @DAParams_CreateParam);
    AType.AddIndexedProp('Items', 'TDAParam', 'Integer', @DAParams_GetItem, @DAParams_SetItem);
  end
  else
  if AType.ValueClassType = TCustomDAConnection then
  begin
    AType.AddMethod('procedure Connect', @CustomDAConnection_Connect);
    AType.AddMethod('procedure Disconnect', @CustomDAConnection_Disconnect);
    AType.AddMethod('procedure PerformConnect(Retry: boolean = False)', @CustomDAConnection_PerformConnect);
    AType.AddMethod('procedure AssignConnect(Source: TCustomDAConnection)', @CustomDAConnection_AssignConnect);
    AType.AddMethod('function ParamByName(Name: string): TDAParam', @CustomDAConnection_ParamByName);
    AType.AddMethod('function ExecSQL(Text: string; const Params: array of variant): variant', @CustomDAConnection_ExecSQL);
    AType.AddMethod('function ExecSQLEx(Text: string; const Params: array of variant): variant', @CustomDAConnection_ExecSQLEx);
    AType.AddMethod('function ExecProc(Name: string; const Params: array of variant): variant', @CustomDAConnection_ExecProc);
    AType.AddMethod('function ExecProcEx(Name: string; const Params: array of variant): variant', @CustomDAConnection_ExecProcEx);
    AType.AddMethod('procedure GetTableNames(List: TStrings; AllTables: boolean = False)', @CustomDAConnection_GetTableNames);
    AType.AddMethod('procedure GetDatabaseNames(List: TStrings)', @CustomDAConnection_GetDatabaseNames);
    AType.AddMethod('procedure GetStoredProcNames(List: TStrings; AllProcs: boolean = False)', @CustomDAConnection_GetStoredProcNames);
    AType.AddMethod('procedure StartTransaction', @CustomDAConnection_StartTransaction);
    AType.AddMethod('procedure Commit', @CustomDAConnection_Commit);
    AType.AddMethod('procedure Rollback', @CustomDAConnection_Rollback);
    AType.AddMethod('procedure ApplyUpdates', @CustomDAConnection_ApplyUpdates);
    AType.AddMethod('procedure RemoveFromPool', @CustomDAConnection_RemoveFromPool);
    AType.AddMethod('procedure MonitorMessage(const Msg: string)', @CustomDAConnection_MonitorMessage);
    AType.AddProp('InTransaction', 'boolean', @CustomDAConnection_InTransaction);
  end
  else
  if AType.ValueClassType = TDATransaction then
  begin
    AType.AddMethod('procedure StartTransaction', @DATransaction_StartTransaction);
    AType.AddMethod('procedure Commit', @DATransaction_Commit);
    AType.AddMethod('procedure Rollback', @DATransaction_Rollback);
    AType.AddProp('DefaultConnection', 'TCustomDAConnection', @DATransaction_GetDefaultConnection, @DATransaction_SetDefaultConnection);
    AType.AddProp('DefaultCloseAction', 'TCRTransactionAction', @DATransaction_GetDefaultCloseAction, @DATransaction_SetDefaultCloseAction);
  end
  else
  if AType.ValueClassType = TBlob then
  begin
    AType.AddMethod('constructor Create(IsUnicode: boolean = False)', @Blob_Create);
    AType.AddMethod('procedure FreeBlob', @Blob_FreeBlob);
    AType.AddMethod('function IsEmpty: boolean', @Blob_IsEmpty);
    AType.AddMethod('procedure Compress', @Blob_Compress);
    AType.AddMethod('procedure Clear', @Blob_Clear);
    AType.AddMethod('procedure Defrag', @Blob_Defrag);
    AType.AddMethod('procedure AddCR', @Blob_AddCR);
    AType.AddMethod('procedure RemoveCR', @Blob_RemoveCR);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @Blob_LoadFromStream);
    AType.AddMethod('procedure SaveToStream(Stream: TStream)', @Blob_SaveToStream);
    AType.AddMethod('procedure LoadFromFile(const FileName: string)', @Blob_LoadFromFile);
    AType.AddMethod('procedure SaveToFile(const FileName: string)', @Blob_SaveToFile);
    AType.AddMethod('procedure Assign(Source: TBlob)', @Blob_Assign);
    AType.AddMethod('procedure EnableRollback', @Blob_EnableRollback);
    AType.AddMethod('procedure Commit', @Blob_Commit);
    AType.AddMethod('procedure Cancel', @Blob_Cancel);
    AType.AddMethod('function CanRollback: Boolean', @Blob_CanRollback);
    AType.AddProp('Size', 'Cardinal', @Blob_SizeGet, @Blob_SizeSet);
    AType.AddProp('AsString', 'string', @Blob_AsStringGet, @Blob_AsStringSet);
    AType.AddProp('RollbackEnabled', 'boolean', @Blob_RollbackEnabledGet, @Blob_RollbackEnabledSet);
    AType.AddProp('UseRollback', 'boolean', @Blob_GetUseRollback, @Blob_SetUseRollback);
  end
  else
  {if AType.ValueClassType = TMemDataSet then
  begin
    AType.AddMethod('procedure Prepare', MemDataSet_Prepare);
    AType.AddMethod('procedure UnPrepare', MemDataSet_UnPrepare);
    AType.AddMethod('procedure CheckPrepared', MemDataSet_CheckPrepared);
    AType.AddMethod('procedure DeferredPost', MemDataSet_DeferredPost);
    AType.AddMethod('procedure CommitUpdates', MemDataSet_CommitUpdates);
    AType.AddMethod('procedure CancelUpdates', MemDataSet_CancelUpdates);
    AType.AddMethod('procedure RestoreUpdates', MemDataSet_RestoreUpdates);
    AType.AddMethod('procedure RevertRecord', MemDataSet_RevertRecord);
    AType.AddMethod('procedure SaveToXML(const FileName: string)', MemDataSet_SaveToXML);
    AType.AddMethod('function IsSequenced: boolean', MemDataSet_IsSequenced);
    AType.AddMethod('function GetBlob(const FieldName: string): TBlob', MemDataSet_GetBlob);
  end
  else}
  if AType.ValueClassType = TCustomDADataSet then
  begin
    AType.AddProp('Disconnected', 'Boolean', @DADataSet_Disconnected_Get);
    AType.AddProp('ParamCount', 'Integer', @DADataSet_ParamCount_Get);
    AType.AddProp('MacroCount', 'Integer', @DADataSet_MacroCount_Get);

    AType.AddMethod('procedure Lock', @DADataSet_Lock);
    AType.AddMethod('procedure UnLock', @DADataSet_UnLock);
    AType.AddMethod('procedure Execute', @DADataSet_Execute);
    AType.AddMethod('procedure ExecSQL', @DADataSet_ExecSQL);
    AType.AddMethod('function Executing: Boolean', @DADataSet_Executing);
    AType.AddMethod('function Fetching: Boolean', @DADataSet_Fetching);
    AType.AddMethod('function FetchingAll: Boolean', @DADataSet_FetchingAll);
    AType.AddMethod('function Fetched: Boolean', @DADataSet_Fetched);
    AType.AddMethod('procedure BreakExec', @DADataSet_BreakExec);
    AType.AddMethod('procedure RefreshRecord', @DADataSet_RefreshRecord);
    AType.AddMethod('procedure SaveSQL', @DADataSet_SaveSQL);
    AType.AddMethod('procedure RestoreSQL', @DADataSet_RestoreSQL);
    AType.AddMethod('function SQLSaved: Boolean', @DADataSet_SQLSaved);
    AType.AddMethod('procedure AddWhere(Condition: string)', @DADataSet_AddWhere);
    AType.AddMethod('procedure DeleteWhere', @DADataSet_DeleteWhere);
    AType.AddMethod('procedure SetOrderBy(Fields: string)', @DADataSet_SetOrderBy);
    AType.AddMethod('function GetOrderBy: string', @DADataSet_GetOrderBy);
    AType.AddMethod('procedure DeferredPost', @DADataSet_DeferredPost);
    AType.AddMethod('function MacroByName(const Value: string): TMacro', @DADataSet_MacroByName);
    AType.AddMethod('function ParamByName(const Value: string): TDAParam', @DADataSet_ParamByName);
    AType.AddMethod('function PN(const Value: string): TDAParam', @DADataSet_ParamByName);
    AType.AddMethod('function FindParam(const Value: string): TDAParam', @DADataSet_FindParam);
    AType.AddMethod('function FindMacro(const Value: string): TMacro', @DADataSet_FindMacro);
  end
  else
  if AType.ValueClassType = TCustomDASQL then
  begin
    AType.AddMethod('function ParamByName(const Value: string): TDAParam', @CustomDASQL_ParamByName);
    AType.AddMethod('function PN(const Value: string): TDAParam', @CustomDASQL_ParamByName);
    AType.AddMethod('function FindParam(const Value: string): TDAParam', @CustomDASQL_FindParam);
    AType.AddMethod('procedure Prepare', @CustomDASQL_Prepare);
    AType.AddMethod('procedure UnPrepare', @CustomDASQL_UnPrepare);
    AType.AddMethod('procedure Execute', @CustomDASQL_Execute);
    AType.AddMethod('procedure ExecuteIters(Iters: integer)', @CustomDASQL_ExecuteIters);
    AType.AddMethod('function Executing: boolean', @CustomDASQL_Executing);
    AType.AddMethod('function WaitExecuting(TimeOut: integer = 0): boolean', @CustomDASQL_WaitExecuting);
    AType.AddMethod('function FindMacro(const Value: string): TMacro', @CustomDASQL_FindMacro);
    AType.AddMethod('function MacroByName(const Value: string): TMacro', @CustomDASQL_MacroByName);
    AType.AddProp('Prepared', 'boolean', @CustomDASQL_Prepared);
  end
  else
  if AType.ValueClassType = TCustomDAUpdateSQL then
  begin
    AType.AddMethod('procedure Apply(UpdateKind: TUpdateKind)', @CustomDAUpdateSQL_Apply);
    AType.AddMethod('procedure ExecSQL(UpdateKind: TUpdateKind)', @CustomDAUpdateSQL_ExecSQL);
    AType.AddIndexedProp('SQL', 'TStrings', 'TUpdateKind', @CustomDAUpdateSQL_GetSQL, @CustomDAUpdateSQL_SetSQL);
  end
  else
  if AType.ValueClassType = TDAMetaData then
  begin
    AType.AddMethod('procedure GetMetaDataKinds(List: TStrings)', @DAMetaData_GetMetaDataKinds);
    AType.AddMethod('procedure GetRestrictions(List: TStrings; const MetaDataKind: string)', @DAMetaData_GetRestrictions);
  end
  else
  if AType.ValueClassType = TDAScript then
  begin
    AType.AddMethod('procedure Execute', @DAScript_Execute);
    AType.AddMethod('function ExecuteNext: Boolean', @DAScript_ExecuteNext);
    AType.AddMethod('procedure ExecuteStream(Stream: TStream)', @DAScript_ExecuteStream);
    AType.AddMethod('procedure ExecuteFile(const FileName: string)', @DAScript_ExecuteFile);
    AType.AddMethod('procedure BreakExec', @DAScript_BreakExec);
    AType.AddMethod('function ErrorOffset: Int64', @DAScript_ErrorOffset);

    AType.AddProp('Params', 'TDAParams', @DAScript_ParamsGet);
    AType.AddProp('AutoCommit', 'Boolean', @DAScript_AutoCommitGet, @DAScript_AutoCommitSet);
    AType.AddProp('StartPos', 'Int64', @DAScript_StartPosGet);
    AType.AddProp('EndPos', 'Int64', @DAScript_EndPosGet);
    AType.AddProp('StartLine', 'Int64', @DAScript_StartLineGet);
    AType.AddProp('EndLine', 'Int64', @DAScript_EndLineGet);
    AType.AddProp('StartOffset', 'Int64', @DAScript_StartOffsetGet);
    AType.AddProp('EndOffset', 'Int64', @DAScript_EndOffsetGet);
  end
  else
  if AType.ValueClassType = TCustomConnectDialog then
  begin
    AType.AddMethod('function Execute: boolean', @CustConnDlg_Execute);
    AType.AddMethod('procedure GetServerList(List: TStrings)', @CustConnDlg_GetServerList);
  end
  else
  if AType.ValueClassType = TDAAlerter then
  begin
    AType.AddMethod('procedure Send(const EventName, Message: string)', @DAAlerter_SendEvent);
    AType.AddMethod('procedure Start', @DAAlerter_Start);
    AType.AddMethod('procedure Stop', @DAAlerter_Stop);
  end
  else
  if AType.ValueClassType = TDAColumns then
  begin
    AType.AddIndexedProp('Items', 'TDAColumn', 'Integer', @DAColumns_GetColumn, @DAColumns_SetColumn);
  end
  else
  if AType.ValueClassType = TDALoader then
  begin
    AType.AddMethod('procedure PutColumnData(Col: integer; Row: integer; const Value: variant)', @DALoader_PutColumnData);
    AType.AddMethod('procedure PutColumnDataOfName(const ColName: string; Row: integer; const Value: variant)', @DALoader_PutColumnDataOfName);
    AType.AddMethod('procedure Load', @DALoader_Load);
    AType.AddMethod('procedure CreateColumns', @DALoader_CreateColumns);
    AType.AddMethod('procedure LoadFromDataSet(DataSet: TDataSet)', @DALoader_LoadFromDataSet);
  end
  else
  if AType.ValueClassType = TSharedObject then
  begin
    AType.AddMethod('procedure Disconnect', @SharedObject_Disconnect);
  end;
end;

{TCustomDAConnection}

function TDevartDacImport.CustomDAConnection_Connect(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).Connect
end;

function TDevartDacImport.CustomDAConnection_Disconnect(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).Disconnect
end;

function TDevartDacImport.CustomDAConnection_PerformConnect(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).PerformConnect(Params[0]);
end;

function TDevartDacImport.CustomDAConnection_AssignConnect(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).AssignConnect(TCustomDAConnection(TSuPtr(Params[0])));
end;

function TDevartDacImport.CustomDAConnection_ParamByName(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDAConnection(Instence).ParamByName(Params[0]))
end;

function TDevartDacImport.CustomDAConnection_ExecSQL(Instence: TObject; var Params: Variant): Variant;
var
  V: Variant;
begin
  V := Params[1];
  Result := TCustomDAConnection(Instence).ExecSQL(Params[0], V)
end;

function TDevartDacImport.CustomDAConnection_ExecSQLEx(Instence: TObject; var Params: Variant): Variant;
var
  V: Variant;
begin
  V := Params[1];
  Result := TCustomDAConnection(Instence).ExecSQLEx(Params[0], V)
end;

function TDevartDacImport.CustomDAConnection_ExecProc(Instence: TObject; var Params: Variant): Variant;
var
  V: Variant;
begin
  V := Params[1];
  Result := TCustomDAConnection(Instence).ExecProc(Params[0], V)
end;

function TDevartDacImport.CustomDAConnection_ExecProcEx(Instence: TObject; var Params: Variant): Variant;
var
  V: Variant;
begin
  V := Params[1];
  Result := TCustomDAConnection(Instence).ExecProcEx(Params[0], V)
end;

function TDevartDacImport.CustomDAConnection_GetTableNames(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).GetTableNames(TStrings(TSuPtr(Params[0])), Params[1]);
end;

function TDevartDacImport.CustomDAConnection_GetDatabaseNames(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).GetDatabaseNames(TStrings(TSuPtr(Params[0])));
end;

function TDevartDacImport.CustomDAConnection_GetStoredProcNames(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).GetStoredProcNames(TSTrings(TSuPtr(Params[0])), Params[1]);
end;

function TDevartDacImport.CustomDAConnection_StartTransaction(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).StartTransaction
end;

function TDevartDacImport.CustomDAConnection_Commit(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).Commit
end;

function TDevartDacImport.CustomDAConnection_Rollback(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).Rollback
end;

function TDevartDacImport.CustomDAConnection_ApplyUpdates(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).ApplyUpdates
end;

function TDevartDacImport.CustomDAConnection_RemoveFromPool(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).RemoveFromPool
end;

function TDevartDacImport.CustomDAConnection_MonitorMessage(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).MonitorMessage(Params[0]);
end;

function TDevartDacImport.CustomDAConnection_InTransaction(Instence: Pointer): Variant;
begin
  Result := TCustomDAConnection(Instence).InTransaction
end;

{TBlob}
function TDevartDacImport.Blob_Create(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TBlob(Instence).Create(Params[0]));
end;

function TDevartDacImport.Blob_FreeBlob(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).FreeBlob
end;

function TDevartDacImport.Blob_IsEmpty(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TBlob(Instence).IsEmpty
end;

function TDevartDacImport.Blob_Compress(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).Compress
end;

function TDevartDacImport.Blob_Defrag(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).Defrag
end;

function TDevartDacImport.Blob_AddCR(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).AddCR
end;

function TDevartDacImport.Blob_RemoveCR(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).RemoveCR
end;

function TDevartDacImport.Blob_LoadFromStream(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).LoadFromStream(TStream(TSuPtr(Params[0])));
end;

function TDevartDacImport.Blob_SaveToStream(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).SaveToStream(TStream(TSuPtr(Params[0])));
end;

function TDevartDacImport.Blob_LoadFromFile(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).LoadFromFile(Params[0]);
end;

function TDevartDacImport.Blob_SaveToFile(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).SaveToFile(Params[0]);
end;

function TDevartDacImport.Blob_Assign(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).Assign(TBlob(TSuPtr(Params[0])));
end;

function TDevartDacImport.Blob_EnableRollback(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).EnableRollback
end;

function TDevartDacImport.Blob_Commit(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).Commit
end;

function TDevartDacImport.Blob_Cancel(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).Cancel
end;

function TDevartDacImport.Blob_CanRollback(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TBlob(Instence).CanRollback
end;

function TDevartDacImport.Blob_SizeGet(Instence: Pointer): Variant;
begin
  Result := TBlob(Instence).Size
end;

procedure TDevartDacImport.Blob_SizeSet(Instence: Pointer; AValue: Variant);
begin
  TBlob(Instence).Size := AValue
end;

function TDevartDacImport.Blob_AsStringGet(Instence: Pointer): Variant;
begin
  Result := TBlob(Instence).AsString
end;

procedure TDevartDacImport.Blob_AsStringSet(Instence: Pointer; AValue: Variant);
begin
  TBlob(Instence).AsString := AValue
end;

function TDevartDacImport.Blob_RollbackEnabledGet(Instence: Pointer): Variant;
begin
  Result := TBlob(Instence).RollbackEnabled
end;

procedure TDevartDacImport.Blob_RollbackEnabledSet(Instence: Pointer; AValue: Variant);
begin
  TBlob(Instence).RollbackEnabled := AValue
end;

function TDevartDacImport.Blob_GetUseRollback(Instence: Pointer): Variant;
begin
  Result := TBlob(Instence).UseRollback
end;

procedure TDevartDacImport.Blob_SetUseRollback(Instence: Pointer; AValue: Variant);
begin
  TBlob(Instence).UseRollback := AValue
end;

{TMemDataSet}

{function TDevartDacImport.MemDataSet_Prepare(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).Prepare;
end;

function TDevartDacImport.MemDataSet_UnPrepare(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).UnPrepare;
end;

function TDevartDacImport.MemDataSet_CheckPrepared(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).CheckPrepared;
end;

function TDevartDacImport.MemDataSet_DeferredPost(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).DeferredPost;
end;

function TDevartDacImport.MemDataSet_CommitUpdates(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).CommitUpdates
end;

function TDevartDacImport.MemDataSet_CancelUpdates(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).CancelUpdates
end;

function TDevartDacImport.MemDataSet_RestoreUpdates(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).RestoreUpdates
end;

function TDevartDacImport.MemDataSet_RevertRecord(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).RevertRecord
end;

function TDevartDacImport.MemDataSet_SaveToXML(Instence: TObject; var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TMemDataSet(Instence).SaveToXML(S);
end;

function TDevartDacImport.MemDataSet_IsSequenced(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TMemDataSet(Instence).IsSequenced
end;

function TDevartDacImport.MemDataSet_GetBlob(Instence: TObject; var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TMemDataSet(Instence).GetBlob(S));
end; }

{TCustomDADataSet}

function TDevartDacImport.DADataSet_Disconnected_Get(Instance: Pointer): Variant;
begin
  Result := TCustomDADataSet(Instance).Disconnected
end;

function TDevartDacImport.DADataSet_ParamCount_Get(Instance: Pointer): Variant;
begin
  Result := TCustomDADataSet(Instance).ParamCount
end;

function TDevartDacImport.DADataSet_MacroCount_Get(Instance: Pointer): Variant;
begin
  Result := TCustomDADataSet(Instance).MacroCount
end;

function TDevartDacImport.DADataSet_Lock(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).Lock
end;

function TDevartDacImport.DADataSet_UnLock(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).UnLock
end;

function TDevartDacImport.DADataSet_Execute(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).Execute
end;

function TDevartDacImport.DADataSet_ExecSQL(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).ExecSQL;
end;

function TDevartDacImport.DADataSet_Executing(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDADataSet(Instence).Executing;
end;

function TDevartDacImport.DADataSet_Fetching(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDADataSet(Instence).Fetching;
end;

function TDevartDacImport.DADataSet_FetchingAll(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDADataSet(Instence).FetchingAll;
end;

function TDevartDacImport.DADataSet_Fetched(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDADataSet(Instence).Fetched;
end;

function TDevartDacImport.DADataSet_BreakExec(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).BreakExec
end;

function TDevartDacImport.DADataSet_RefreshRecord(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).RefreshRecord
end;

function TDevartDacImport.DADataSet_SaveSQL(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).SaveSQL
end;

function TDevartDacImport.DADataSet_RestoreSQL(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).RestoreSQL
end;

function TDevartDacImport.DADataSet_SQLSaved(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDADataSet(Instence).SQLSaved
end;

function TDevartDacImport.DADataSet_AddWhere(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).AddWhere(Params[0]);
end;

function TDevartDacImport.DADataSet_DeleteWhere(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).DeleteWhere
end;

function TDevartDacImport.DADataSet_SetOrderBy(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).SetOrderBy(Params[0]);
end;

function TDevartDacImport.DADataSet_GetOrderBy(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDADataSet(Instence).GetOrderBy
end;

function TDevartDacImport.DADataSet_DeferredPost(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).DeferredPost
end;

function TDevartDacImport.DADataSet_MacroByName(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDADataSet(Instence).MacroByName(Params[0]))
end;

function TDevartDacImport.DADataSet_ParamByName(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDADataSet(Instence).ParamByName(Params[0]))
end;

function TDevartDacImport.DADataSet_FindParam(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDADataSet(Instence).FindParam(Params[0]));
end;

function TDevartDacImport.DADataSet_FindMacro(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDADataSet(Instence).FindMacro(Params[0]));
end;


{TCustomDASQL}

function TDevartDacImport.CustomDASQL_Prepare(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDASQL(Instence).Prepare
end;

function TDevartDacImport.CustomDASQL_UnPrepare(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDASQL(Instence).UnPrepare
end;

function TDevartDacImport.CustomDASQL_ParamByName(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDASQL(Instence).ParamByName(Params[0]))
end;

function TDevartDacImport.CustomDASQL_FindParam(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDASQL(Instence).FindParam(Params[0]))
end;

function TDevartDacImport.CustomDASQL_FindMacro(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDASQL(Instence).FindMacro(Params[0]))
end;

function TDevartDacImport.CustomDASQL_Execute(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDASQL(Instence).Execute
end;

function TDevartDacImport.CustomDASQL_ExecuteIters(Instence: TObject; var Params: Variant): Variant;
var
  I: Integer;
begin
  I := Params[0];
  TCustomDASQL(Instence).Execute(I);
end;

function TDevartDacImport.CustomDASQL_Executing(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDASQL(Instence).Executing
end;

function TDevartDacImport.CustomDASQL_WaitExecuting(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDASQL(Instence).WaitExecuting(Params[0])
end;

function TDevartDacImport.CustomDASQL_MacroByName(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDASQL(Instence).MacroByName(Params[0]));
end;

function TDevartDacImport.CustomDASQL_Prepared(Instence: Pointer): Variant;
begin
   Result := TCustomDASQL(Instence).Prepared
end;

{TCustomDAUpdateSQL}

function TDevartDacImport.CustomDAUpdateSQL_Apply(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAUpdateSQL(Instence).Apply(TUpdateKind(Params[0]));
end;

function TDevartDacImport.CustomDAUpdateSQL_ExecSQL(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAUpdateSQL(Instence).ExecSQL(TUpdateKind(Params[0]));
end;

{TDAMetaData}
function TDevartDacImport.DAMetaData_GetMetaDataKinds(Instence: TObject; var Params: Variant): Variant;
begin
  TDAMetaData(Instence).GetMetaDataKinds(TStrings(TSuPtr(Params[0])));
end;

function TDevartDacImport.DAMetaData_GetRestrictions(Instence: TObject; var Params: Variant): Variant;
begin
  TDAMetaData(Instence).GetRestrictions(TStrings(TSuPtr(Params[0])), Params[1]);
end;

{TDAScript}

function TDevartDacImport.DAScript_Execute(Instence: TObject; var Params: Variant): Variant;
begin
  TDAScript(Instence).Execute;
end;

function TDevartDacImport.DAScript_ExecuteNext(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TDAScript(Instence).ExecuteNext
end;

function TDevartDacImport.DAScript_ExecuteStream(Instence: TObject; var Params: Variant): Variant;
begin
  TDAScript(Instence).ExecuteStream(TStream(TSuPtr(Params[0])));
end;

function TDevartDacImport.DAScript_ExecuteFile(Instence: TObject; var Params: Variant): Variant;
begin
  TDAScript(Instence).ExecuteFile(Params[0]);
end;

function TDevartDacImport.DAScript_BreakExec(Instence: TObject; var Params: Variant): Variant;
begin
  TDAScript(Instence).BreakExec
end;

function TDevartDacImport.DAScript_ErrorOffset(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TDAScript(Instence).ErrorOffset
end;


function TDevartDacImport.DAScript_ParamsGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDAScript(Instance).Params)
end;

function TDevartDacImport.DAScript_AutoCommitGet(Instance: Pointer): Variant;
begin
  Result := TDAScript(Instance).AutoCommit
end;

procedure TDevartDacImport.DAScript_AutoCommitSet(Instance: Pointer; AValue: Variant);
begin
  TDAScript(Instance).AutoCommit := AValue
end;

function TDevartDacImport.DAScript_StartPosGet(Instance: Pointer): Variant;
begin
  Result := TDAScript(Instance).StartPos
end;

function TDevartDacImport.DAScript_EndPosGet(Instance: Pointer): Variant;
begin
  Result := TDAScript(Instance).EndPos
end;

function TDevartDacImport.DAScript_StartLineGet(Instance: Pointer): Variant;
begin
  Result := TDAScript(Instance).StartLine
end;

function TDevartDacImport.DAScript_EndLineGet(Instance: Pointer): Variant;
begin
  Result := TDAScript(Instance).EndLine
end;

function TDevartDacImport.DAScript_StartOffsetGet(Instance: Pointer): Variant;
begin
  Result := TDAScript(Instance).StartOffset
end;

function TDevartDacImport.DAScript_EndOffsetGet(Instance: Pointer): Variant;
begin
  Result := TDAScript(Instance).EndOffset
end;

function TDevartDacImport.CustConnDlg_Execute(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomConnectDialog(Instence).Execute;
end;

function TDevartDacImport.CustConnDlg_GetServerList(Instence: TObject;
  var Params: Variant): Variant;
begin
  TCustomConnectDialog(Instence).GetServerList(TStrings(TSuPtr(Params[0])));
end;

function TDevartDacImport.DAParams_ParamByName(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TDAParams(Instence).ParamByName(Params[0]));
end;

function TDevartDacImport.DAParams_FindParam(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TDAParams(Instence).FindParam(Params[0]));
end;

function TDevartDacImport.DAParams_CreateParam(Instence: TObject;
  var Params: Variant): Variant;
begin
 Result := TSuPtr(TDAParams(Instence).CreateParam(Params[0], Params[1], Params[2]));
end;

function TDevartDacImport.DAParams_GetItem(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TDAParams(Instence).Items[Params[0]]);
end;

function TDevartDacImport.DAParams_SetItem(Instence: TObject;
  var Params: Variant): Variant;
begin
  TDAParams(Instence).Items[Params[0]] := TDAParam(TSuPtr(Params[1]));
end;

function TDevartDacImport.DAAlerter_Stop(Instence: TObject; var Params: Variant
  ): Variant;
begin
  TDAAlerter(Instence).Stop;
end;

function TDevartDacImport.DAAlerter_Start(Instence: TObject; var Params: Variant
  ): Variant;
begin
  TDAAlerter(Instence).Start;
end;

function TDevartDacImport.DAAlerter_SendEvent(Instence: TObject;
  var Params: Variant): Variant;
begin
  TDAAlerter(Instence).SendEvent(Params[0], Params[1]);
end;

function TDevartDacImport.DAColumns_GetColumn(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TDAColumns(Instence).Items[Params[0]]);
end;

function TDevartDacImport.DAColumns_SetColumn(Instence: TObject;
  var Params: Variant): Variant;
begin
  TDAColumns(Instence).Items[Params[0]] := TDAColumn(TSuPtr(Params[1]));
end;

{DALoader}

function TDevartDacImport.DALoader_CreateColumns(Instence: TObject;
  var Params: Variant): Variant;
begin
  TDALoader(Instence).CreateColumns;
end;

function TDevartDacImport.DALoader_Load(Instence: TObject; var Params: Variant
  ): Variant;
begin
  TDALoader(Instence).Load;
end;

function TDevartDacImport.DALoader_LoadFromDataSet(Instence: TObject;
  var Params: Variant): Variant;
begin
  TDALoader(Instence).LoadFromDataSet(TDataSet(TSuPtr(Params[0])));
end;

function TDevartDacImport.DALoader_PutColumnData(Instence: TObject;
  var Params: Variant): Variant;
begin
  TDALoader(Instence).PutColumnData(TSuPtr(Params[0]), Params[1], Params[2]);
end;

function TDevartDacImport.DALoader_PutColumnDataOfName(Instence: TObject;
  var Params: Variant): Variant;
begin
  TDALoader(Instence).PutColumnData(string(Params[0]), Params[1], Params[2]);
end;

end.
