{**************************************************************************}
{ Библиотека работы с платёжными терминалами пластиковых карт              }
{ в стандарте, предоставляемым ГазПромБанком                               }
{ Free Pascal Compiler версии 2.7.1 и Lazarus 1.2 и выше.                  }
{ Лагунов Алексей (С) 2014  alexs75.at.yandex.ru                           }
{**************************************************************************}
{ Интерфейс к библиотеке EGate, создан на основе информации из официальной }
{ документации по API библиотеки.                                          }
{ Предназначено для работы с компилятором                                  }
{ Free Pascal Compiler версии 2.7.1 и Lazarus 1.2 и выше.                  }
{ Перевод для FPC Лагунов Алексей (С) 2014  alexs75.at.yandex.ru           }
{**************************************************************************}

unit egate_api;

{$mode objfpc}{$H+}

{ Признак необходимости в прямом обращении к функциям библиотеки. }
{ Иначе через класс TEGateLibrary из модуля egate_class           }
{.$DEFINE EG_DIRECT_PROC}

interface

uses
  Classes, SysUtils;

const
  {$IFDEF WINDOWS}
  libEGateName = 'emvgatessl.dll';
  {$ELSE}
  libEGateName = '/usr/local/lib64/libemvgate.so';
  //libEGateName = '/usr/lib64/libemvgate.so';
  {$ENDIF}

type
  //Типы используемых данных.
  TemvBool = ByteBool;
  TemvInt = Int32;
  TemvChar = PChar;
  TemvUnsignedChar = Byte;
  TemvUnsignedInt = UInt32;

type
  //Список функций egate.
  //Вспомогательные функции API
        {4.2.1.1 egGetVersion.
        Прототип:
          int egGetVersion();
        Описание:
          Возвращает целочисленное значение текущей версии библиотеки.
        Аргументы:
          Нет
        Возвращаемое значение:
          Целое число (int)  - значение текущей версии библиотеки в формате vv*1000000+rr*10000+bb*100+cc где,
             vv – двузначное число, определяющее главный номер версии (не более 99),
             rr –  двузначное число (не более 99),  определяющее номер релиза библиотеки,
             bb - двузначное число (не более 99), отвечающее   порядковый номер сборки из-за исправлений ошибок
             cc - двузначное число (не более 99), отвечающее за порядковый номер сборки из-за незначительных изменений
          Главный номер версии программы. Он означает принципиальные изменения на уровне идеологии или архитектуры.
          Номер релиза присваивается при изменении функциональности, возможностей с сохранением основной архитектуры или при незначительных улучшениях в интерфейсе программы.
          Номер сборки из-за исправлений ошибок. Как правило, это значение меняется при устранении недостатков или ошибок в программе.
          Номер сборки из-за незначительных изменений. Как правило, это значение меняется при внесении редакционных правок в исходные коды, не влияющих на функционал.
        Условие выполнения:
          Данная функция не имеет ограничений по порядку и количеству вызовов.}
  TegGetVersion = function:TemvInt; {$IFDEF UNIX} cdecl; {$ELSE} stdcall; {$ENDIF}

        {4.2.1.2 egGetVersionDescription.
        Прототип:
          const char* egGetVersionDescription();
        Описание:
          Возвращает текущую версию данной библиотеки в формате текстовой строки.
        Аргументы:
          Нет
        Возвращаемое значение:
          Указатель на строку (const char*)  - указатель на заканчивающуюся нулем ASCIIz  строку, содержащую текстовое представление текущей версии данной библиотеки.
        Условие выполнения:
          Данная функция не имеет ограничений по порядку и количеству вызовов.}
  TegGetVersionDescription = function : TemvChar; {$IFDEF UNIX} cdecl; {$ELSE} stdcall; {$ENDIF}

        {4.2.1.3 egGetLastError.
        Прототип:
          int egGetLastError(int nIdInst);
        Описание:
          Возвращает целочисленное значение кода системной ошибки при выполнении выполнения предыдущей операции. Нулевое значение данного кода соответствует успешному выполнению предыдущей операции. Иначе, возвращается код ошибки, описание которой вы можете получить с помощью функции egGetErrorDescription.
        Примечание:
          Данная функция является вспомогательной и используется, в основном, на этапе разработки приложений, применяющих данную библиотеку для авторизации платежей.
        Аргументы:
          nIdInst -  идентификатор объекта, обслуживающего авторизационные вызовы.
        Возвращаемое значение:
          Целое число (int)  - значение последней зафиксированной ошибки при выполнении предыдущей операции функциями данной библиотеки. Если аргумент  nIdInst  имеет нулевое значение, то возвращается глобальный код ошибки  последней выполненной операции при вызове функций библиотеки. При ненулевом значении аргумента nIdInst возвращается код ошибки в контексте конкретного объекта.
          Примечание: В большинстве случаев, код ответа будет соответствовать коду системной ошибки операционной системы. Иногда, вместо кода системной ошибки может вернуться код ошибки уровня данной библиотеки. В любом случае, текстовое описание этой ошибки можно получить с помощью функции egGetErrorDescription (см. п. 4.2.1.4).
        Условие выполнения:
          Данная функция не имеет ограничений по порядку и количеству вызовов.}
  TegGetLastError = function(nIdInst:TemvInt):TemvInt;{$IFDEF UNIX} cdecl; {$ELSE} stdcall; {$ENDIF}

      {4.2.1.4 egGetErrorDescription.
      Прототип:
        const char* egGetErrorDescription(int nErrCode);
      Описание:
        Возвращает описание кода ошибки в текстовом формате.
      Аргументы:
        nErrCode -  код ошибки, текстовое представление которой запрашивается.
      Возвращаемое значение:
        Указатель на строку (const char*)  - указатель на заканчивающуюся нулем ASCIIz  строку, содержащую текстовое представление описания кода ошибки.
      Условие выполнения:
        Данная функция не имеет ограничений по порядку и количеству вызовов.}
  TegGetErrorDescription = function(nErrCode:TemvInt):TemvChar;{$IFDEF UNIX} cdecl; {$ELSE} stdcall; {$ENDIF}

      {4.2.1.5 egDlgGetRecNumber.
      Прототип:
        const char* egDlgGetRecNumber(void);
      Описание:
        Возвращает номер документа в текстовом формате.
      Аргументы:
      -
      Возвращаемое значение:
        Указатель на строку (const char*)  - указатель на заканчивающуюся нулем ASCIIz  строку, содержащую текстовое представление номера документа.
      Условие выполнения:
        Данная функция не имеет ограничений по порядку и количеству вызовов.}
   TegDlgGetRecNumber = function:TemvChar;{$IFDEF UNIX} cdecl; {$ELSE} stdcall; {$ENDIF}

   //4.2.2 Основные функции API
       {4.2.2.1 egInitInstance.
       Прототип:
         int egInitInstance(const char* pszCfgFileName);
       Описание:
         Инициализирует очередной объект для обслуживания авторизационных запросов и возвращает его идентификатор отличный от ноля. Данный идентификатор, должен использоваться при вызове других функций API, требующих этот идентификатор.
       Аргументы:
         pszCfgFileName – указатель на строку,  которая содержит полный путь к конфигурационному файлу данной библиотеки. Если данный параметр равен 0, то авторизационный модуль будет пытаться открыть конфигурационный файл, имя которого egate.cfg.  Этот файл должен располагаться в системных каталогах операционной системы Win32. Если фай не будет найден, функция завершится с ошибкой.
       Возвращаемое значение:
         Целое число (int)  - уникальный идентификатор сеанса работы модуля авторизации. Случай возврата нулевого значения является ошибкой. Для определения причин возникновения ошибки воспользуйтесь вспомогательными функциями  egGetLastError и  egGetErrorDescription (см. п.п. 4.2.1.3, 4.2.1.3).
       Условие выполнения:
         Данная функция вызывается первой в цепочке вызовов функций API данной библиотеки.}
   TegInitInstance = function(pszCfgFileName:TemvChar):TemvInt; {$IFDEF UNIX} cdecl; {$ELSE} stdcall; {$ENDIF}

       {4.2.2.2 egReleaseInstance.
       Прототип:
         bool egReleaseInstance(int nIdInst);
       Описание:
         Освобождает ресурсы объекта обслуживания авторизационных запросов (по идентификатору) и закрывает его от дальнейшего использования.
       Аргументы:
         nIdInst -  уникальный идентификатор сеанса работы модуля авторизации, полученный с помощью функции egInitInstance (см.п.4.2.2.1).
       Возвращаемое значение:
         bool  - булевое значение. TRUE – соответствует положительному результату выполнения  данной функции. В ошибочной ситуации возвращается FALSE.
       Условие выполнения:
         Данная функция должна замыкать цепочку вызовов функций API данной библиотеки.}
   TegReleaseInstance = function(nIdInst:TemvInt):TemvBool; {$IFDEF UNIX} cdecl; {$ELSE} stdcall; {$ENDIF}

       {4.2.2.3 egAuthRequest
        4.2.2.4 egAuthRequestAsync
       Прототип:
         const char* egAuthRequest( int nIdInst,  int nProtId,  const char* pRequest);
         const char* egAuthRequestAsync( int nIdInst,  int nProtId,  const char* pRequest);
       Описание:
         egAuthRequest  - функция синхронного вызова авторизационного запроса.
         egAuthRequestAsync  - функция асинхронного вызова авторизационного запроса.
         Основная функция, которая обеспечивает выполнение всех операций авторизационного запроса от ККМ.  Возвращает управление после взаимодействия с ПЦ ГПБ. Процесс выполнения данной функции будет сопровождаться интерактивным  взаимодействием с кассиром (оператором) для ввода дополнительных параметров авторизационного запроса и, если необходимо, с клиентом при вводе пин-кода.
       Аргументы:
         nIdInst -  уникальный идентификатор сеанса работы модуля авторизации, полученный с помощью функции egInitInstance (см.п.4.2.2.1);
         nProtId - целое число, которое определяет номер протокола (тип формата запроса) по которому сформирован запрос. Для реализации простого протокола взаимодействия ККМ- ПЦ ГПБ, необходимо, чтобы  параметр nProtId принимал значение равное номеру протокола, для API 15 всегда равно 15..
         pRequest – указатель на заканчивающуюся нулем ASCIIz  строку, который содержит информацию об авторизационном запросе. Описание формата авторизационного запроса представлено в разделе  “Формат запроса” в описании соответствующего  протокола (см. 5.1.1 данного документа)
       Возвращаемое значение:
         Указатель на строку (const char*)  - указатель на заканчивающуюся нулем ASCIIz  строку, содержащую текстовое представление результата авторизационного запроса.  Описание формата авторизационного запроса представлено в разделе  “Формат ответа” в описании соответствующего  протокола (см. Ошибка: источник перёкрестной ссылки не найден данного документа).
       Примечание: Для функции egAuthRequestAsync при успешном завершении возвращаемое значение равно «530 START»
         Внимание! Нулевое значение, возвращаемое данной функцией, соответствует  ошибке времени выполнения данной операции. Значение кода ошибки можно получить с помощью функции egGetLastError (см. п. 4.2.1.3)
       Условие выполнения:
         Данная функция вызывается после выполнения инициализации описываемой библиотеки функцией  int egInitInstance  и используется до вызова завершающей функции egReleaseInstance.}
  TegAuthRequest = function(nIdInst, nProtId:TemvInt; pRequest:TemvChar):TemvChar; {$IFDEF UNIX} cdecl; {$ELSE} stdcall; {$ENDIF}
  TegAuthRequestAsync = function(nIdInst, nProtId:TemvInt; pRequest:TemvChar):TemvChar; {$IFDEF UNIX} cdecl; {$ELSE} stdcall; {$ENDIF}

      {4.2.2.5 egGetAuthReceipt.
      Прототип:
        const char* egGetAuthReceipt(int nIdInst);
      Описание:
        Функция получения форматированного набора данных, подготовленного для печати чека.
      Аргументы:
        nIdInst -  уникальный идентификатор сеанса работы модуля авторизации, полученный с помощью функции egInitInstance (см.п.4.2.2.1);
      Возвращаемое значение:
        Указатель на строку (const char*)  - указатель на заканчивающуюся нулем ASCIIz  строку, содержащую текстовое представление образа чека, отформатированного для печати на соответствующем чековом принтере ККМ.
        Внимание! Нулевое значение, возвращаемое данной функцией, соответствует  ошибке времени выполнения данной операции. Значение кода ошибки можно получить с помощью функции egGetLastError (см. п. 4.2.1.3)
      Условие выполнения:
        Данная функция вызывается после выполнения функции const char* egAuthRequest и при получении положительного ответа на запрос авторизации (код завершения – «000»).}
  TegGetAuthReceipt = function(nIdInst:TemvInt):TemvChar; {$IFDEF UNIX} cdecl; {$ELSE} stdcall; {$ENDIF}

      {4.2.2.6 egGetAuthResult.
      Прототип:
        const char* egGetAuthResult(int nIdInst);
      Описание:
        Функция получения форматированной строки, содержащей результаты авторизации.
      Аргументы:
        nIdInst -  уникальный идентификатор сеанса работы модуля авторизации, полученный с помощью функции egInitInstance (см.п.4.2.2.1);
      Возвращаемое значение:
        Указатель на строку (const char*)  - указатель на заканчивающуюся нулем ASCIIz  строку, содержащую форматированную строку с результатами авторизации.
        Внимание! Нулевое значение, возвращаемое данной функцией, соответствует  ошибке времени выполнения данной операции. Значение кода ошибки можно получить с помощью функции egGetLastError (см. п. 4.2.1.3)
        Пример форматированной строки см.
        Описание формата форматированной строки с результатами авторизации приведено в Ошибка: источник перёкрестной ссылки не найден
      Условие выполнения:
        Данная функция вызывается после выполнения функции const char* egAuthRequest и при получении положительного ответа на запрос авторизации (код завершения – «000»).}
  TegGetAuthResult = function(nIdInst:TemvInt):TemvChar; {$IFDEF UNIX} cdecl; {$ELSE} stdcall; {$ENDIF}

      {4.2.2.7 egGetOpStatus.
      Прототип:
        const char* egGetOpStatus (int nIdInst, bool bIsCansel);
      Описание:
        Функция получения статуса выполнения текущего авторизационного запроса.
      Аргументы:
        nIdInst -  уникальный идентификатор сеанса работы модуля авторизации, полученный с помощью функции egInitInstance (см.п.4.2.2.1);
        bIsCansel – флаг, указывающий на необходимость немедленного завершения текущего авторизационного запроса
      Возвращаемое значение:
        Указатель на строку (const char*)  - указатель на заканчивающуюся нулем ASCIIz  строку, содержащую статус выполнения текущего авторизационного запроса.
        Формат строки возвращаемого статуса:
        <Идентификатор><Состояние><Тело ответа/статуса>
          где
               <Идентификатор> - идентификатор возвращаемой строки текста
               <Состояние> - целочисленное значение состояния.
               <Тело ответа/статуса > - значение ответа или статуса

          <Идентификатор> может принимать два значения:
           ‘#’  - признак строки статуса
           ‘*’ – признак строки статуса во время режима работы с Mifare картами
           ‘&’  - признак строки ответа
          <Состояние> может принимать следующие значения:
            0 – Состояния до использования карты клиентом
            1 – Состояния между тем, как поднес клиент карту и перед вводом пин-кода.
            2 – Состояние после ввода пин-кода.
      Условие выполнения:
        Данная функция вызывается после выполнения функции const char* egAuthRequest и при получении специального ответа: «530 START».}
  TegGetOpStatus = function(nIdInst:TemvInt; bIsCansel:TemvBool):TemvChar; {$IFDEF UNIX} cdecl; {$ELSE} stdcall; {$ENDIF}


  //4.2.3 Функции для работы с Mifare картами

      {4.2.3.1 egMfAuthenticate
      Прототип:
        int egMfAuthenticate(unsigned char nSector, unsigned char KeyType, unsigned int KeyID)
      Описание:
        Функция аутентификации сектора карты Mifare
      Аргументы:
        nnSector -  уникальный целочисленный номер сектора карты из отрезка [0;15]
        KeyType – тип ключа (KEY_A - 0, KEY_B - 1)
        KeyID - уникальный целочисленный идентификатор ключа, который соответствует номеру ключа из файла mfkeys.txt
      Возвращаемое значение:
        Целое число (int)  - код, характеризующий результат выполнения данной операции. Значение всех возможных кодов представлено в Приложении 4.
      Условие выполнения:
        Данная функция вызывается после выполнения функции const char* egAuthRequest или функции const char* egAuthRequesta при получении специального ответа на запрос авторизации (код завершения – «951»).}
  TegMfAuthenticate = function(nSector, KeyType: TemvUnsignedChar; KeyID:TemvUnsignedInt):TemvInt;

      {4.2.3.2 egMfRead
      Прототип:
        int egMfRead (unsigned char nSector, unsigned char nBlockId, void *pBuffer, unsigned int nSizeBuffer)
      Описание:
        Функция чтения блока данных из сектора карты Mifare
      Аргументы:
        nSector -  уникальный целочисленный номер сектора карты из отрезка [0;15]
        nBlockId – уникальный целочисленный идентификатор блока сектора карты Mifare сектора карты из отрезка [0;4]
        pBuffer – буфер, в котором находятся прочтенные из блока данные
        nSizeBuffer – размер буфера, в котором находятся прочтенные из блока данные
      Возвращаемое значение:
        Целое число (int)  - код, характеризующий результат выполнения данной операции. Значение всех возможных кодов представлено в Приложении 4.
      Условие выполнения:
        Данная функция вызывается после выполнения функции int egMfAuthenticate при получении положительного ответа и перед выполнением функции int  egMfEndTr}
  TegMfRead = function(nSector, nBlockId:TemvUnsignedChar; var pBuffer; nSizeBuffer:TemvUnsignedInt):TemvInt;

      {4.2.3.3 egMfWrite
      Прототип:
        int egMfWrite(unsigned char nSector, unsigned char nBlockId, const void *pBuffer, unsigned int nSizeBuffer)
      Описание:
        Функция записи данных в блок сектора карты Mifare
      Аргументы:
        nSector -  уникальный целочисленный номер сектора карты из отрезка [0;15]
        nBlockId – уникальный целочисленный идентификатор блока сектора карты Mifare из отрезка [0;4]
        pBuffer – буфер, в котором находятся hex-данные (16 байт, 32 символа) для записи в блок сектора карты Mifare.
        nSizeBuffer – размер буфера, в котором находятся данные для записи в блок сектора карты Mifare.
      Возвращаемое значение:
        Целое число (int)  - код, характеризующий результат выполнения данной операции. Значение всех возможных кодов представлено в Приложении 4.
      Условие выполнения:
        Данная функция вызывается после выполнения функции int egMfAuthenticate при получении положительного ответа и перед выполнением функции int  egMfEndTr}
  TegMfWrite = function(nSector, nBlockId : TemvUnsignedChar; var pBuffer; nSizeBuffer:TemvUnsignedInt):TemvInt;

      {4.2.3.4 egMfEndTr
      Прототип:
        int egMfEndTr()
      Описание:
        Функция, завершающая сессию по работе с Mifare картами.
      Аргументы:
        -
      Возвращаемое значение:
        Целое число (int)  - код, характеризующий результат выполнения данной операции. Значение всех возможных кодов представлено в Приложении 4.
      Условие выполнения:
        Данная функция вызывается после выполнения функции int egMfAuthenticate при получении положительного ответа.}
  TegMfEndTr = function:TemvInt;


{$IFDEF EG_DIRECT_PROC}
const
  //Вспомогательные функции API
  egGetVersion : TegGetVersion = nil; //Получение идентификатора текущей версии библиотеки
  egGetVersionDescription : TegGetVersionDescription = nil; //Получение текстового представления  текущей версии библиотеки
  egGetLastError : TegGetLastError = nil; //Получение кода последней системной ошибки выполнения функций данного модуля.
  egGetErrorDescription : TegGetErrorDescription = nil; //Получение текстового описания системной ошибки по ее коду, полученному функцией egGetLastError.
  egDlgGetRecNumber : TegDlgGetRecNumber = nil;  //Получение номера документа с использованием диалогового окна.

  //Основные функции API
  egInitInstance : TegInitInstance = nil;       //Функция инициализации экземпляра библиотеки.
  egReleaseInstance : TegReleaseInstance = nil; //Освобождение ресурсов данного экземпляра библиотеки.
  egAuthRequest : TegAuthRequest = nil;         //Запуск на выполнение обработчика авторизационного запроса в синхронном режиме.
  egAuthRequestAsync : TegAuthRequest = nil;    //Запуск на выполнение обработчика авторизационного запроса в асинхронном режиме.
  egGetAuthReceipt : TegGetAuthReceipt = nil;   //Функция получения форматизированного набора данных, подготовленного для печати чека.
  egGetAuthResult : TegGetAuthResult = nil;     //Функция получения форматированной строки, содержащей результаты авторизации.
  egGetOpStatus  : TegGetOpStatus = nil;        //Функция получения статуса выполнения текущего авторизационного запроса.

  //Функции для работы с Mifare картами
  egMfAuthenticate : TegMfAuthenticate = nil;  //Функция аутентификации на секторе карты
  egMfRead : TegMfRead = nil;                  //Функция чтения блока данных из сектора, прошедшего аутентификацию
  egMfWrite : TegMfWrite = nil;                //Функция записи блока данных на сектор, прошедшего аутентификацию
  egMfEndTr : TegMfEndTr = nil;                //Завершение сессии для работы с Mifare картами
{$ENDIF}

//Вспомогательные функции
function Cp1251ToUTF8(S: string): string;
function UTF8ToCp1251(S: string): string;
implementation
uses
  {$IFNDEF MSWindows}
  iconvenc;
  {$ELSE}
  LazUTF8;
  {$endif}

function Cp1251ToUTF8(S: string): string;
begin
{$IFNDEF MSWindows}
  if S<>'' then
    Iconvert(S, Result, 'CP1251', 'UTF-8')
  else
    Result:='';
{$ELSE}
   //Result:=SysToUTF8(S);
   Result:=WinCPToUTF8(S);
{$endif}
end;

function UTF8ToCp1251(S: string): string;
begin
{$IFNDEF MSWindows}
   if S<>'' then
     Iconvert(S, Result, 'UTF-8', 'CP1251')
   else
     Result:='';
{$ELSE}
   Result:=UTF8ToSys(S);
{$endif}
end;

end.

