unit main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  ExtCtrls, StdCtrls, DBGrids, DbCtrls, xdbf, db, LCLType;

type

  { TForm1 }

  TForm1 = class(TForm)
    Bevel1: TBevel;
    Button1: TButton;
    Button2: TButton;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Label1: TLabel;
    Panel1: TPanel;
    xDbf1: TxDbf;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

uses xdbf_dbffile, xdbf_common;

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
begin
  xDbf1.SetRange(Edit1.Text, Edit2.Text);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  xDbf1.CancelRange;
end;

procedure TForm1.Edit3Change(Sender: TObject);
begin
  xDbf1.SearchKey(Edit3.Text, stGreater);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  ConfigPath, sPath: string;
begin
   sPath := Application.ExeName;
   ConfigPath:= ExtractFilePath(sPath);
   xDbf1.filePath := ConfigPath + 'DATA' + DirectorySeparator;
   sPath := ConfigPath+'DATA' + DirectorySeparator;
   DBFGlobals.DefaultOpenCodePage := 866;
   xDbf1.Active :=true;
   if not FileExists( sPath + 'ray.mdx') then
   xDbf1.AddIndex('NAME','NAME',[ixCaseInsensitive]);
   xDbf1.IndexName :='NAME';
end;

initialization
  {$I main.lrs}

end.

