{------------------------------------------------------------------------------}
{                                                                              }
{                              Yuriy Kopnin                                    }
{                            Package VisuaTech                                 }
{                                 LGPL                                         }
{                                                                              }
{------------------------------------------------------------------------------}

unit xColumnImageEdotors;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ValEdit,
  StdCtrls, PropEdits, types, ImgList, Grids;

type

  { TxColumnImagesForm }

  TxColumnImagesForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    ListBox1: TListBox;
    ValueListEditor1: TValueListEditor;
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure ListBox1DrawItem(Control: TWinControl; Index: Integer;
      ARect: TRect; State: TOwnerDrawState);
    procedure ListBox1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState
      );
    procedure ValueListEditor1DrawCell(Sender: TObject; aCol, aRow: Integer;
      aRect: TRect; aState: TGridDrawState);
    procedure ValueListEditor1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ValueListEditor1SelectCell(Sender: TObject; aCol, aRow: Integer;
      var CanSelect: Boolean);
  private
    FImages: TCustomImageList;
    procedure SetImages(Value: TCustomImageList);
  public
    property Images: TCustomImageList read FImages write SetImages;
  end;

  { TImagesIndexesProperty }

  TImagesIndexesProperty = class(TStringsPropertyEditor)
  public
     procedure Edit; override;
  end;

  { TxImagesIndexesProperty }

  TxImagesIndexesProperty = class(TStringsPropertyEditor)
  public
     procedure Edit; override;
  end;

var
  xColumnImagesForm: TxColumnImagesForm;

implementation

uses XDBGrids, LCLType;

{$R *.lfm}

{ TxImagesIndexesProperty }

procedure TxImagesIndexesProperty.Edit;
var
  Column: TxColumn;
begin
  Column := TxColumn(GetComponent(0));
  xColumnImagesForm := TxColumnImagesForm.Create(Application);
  xColumnImagesForm.ValueListEditor1.Strings.Assign(Column.xImagesIndexes);
  xColumnImagesForm.Images := Column.Grid.ImageList;
  if xColumnImagesForm.Images <> nil then
  begin
    xColumnImagesForm.ValueListEditor1.DefaultRowHeight := xColumnImagesForm.Images.Height + 4;
  end;
  try
    if xColumnImagesForm.ShowModal = mrOk then
    begin
      Column.xImagesIndexes.Assign(xColumnImagesForm.ValueListEditor1.Strings);
      Modified;
    end;
  finally
    xColumnImagesForm.Free;
  end;
end;

{ TxColumnImagesForm }

procedure TxColumnImagesForm.FormClose(Sender: TObject;
  var CloseAction: TCloseAction);
begin
  CloseAction := caHide;
end;

procedure TxColumnImagesForm.FormShow(Sender: TObject);
begin
  ValueListEditor1.Col := 0;
end;

procedure TxColumnImagesForm.ListBox1DblClick(Sender: TObject);
begin
  if ListBox1.ItemIndex >= 0 then
  begin
    ValueListEditor1.Cells[1, ValueListEditor1.Row] := IntToStr(ListBox1.ItemIndex);
  end;
end;

procedure TxColumnImagesForm.ListBox1DrawItem(Control: TWinControl;
  Index: Integer; ARect: TRect; State: TOwnerDrawState);
var
  ImageRect: TRect;
  S: string;
  txtStyle: TTextStyle;
begin
  ListBox1.Canvas.Brush.Color := clWhite;
  if odSelected in State then ListBox1.Canvas.Brush.Color := clSilver;
  ListBox1.Canvas.FillRect(ARect);
  ImageRect := ARect;
  InflateRect(ImageRect, -1, -1);
  ImageRect.Right := ImageRect.Left + Images.Width;
  Images.Draw(ListBox1.Canvas, ImageRect.Left, ImageRect.Top, Index);
  ImageRect.Left := ImageRect.Right + 4;
  ImageRect.Right := ARect.Right;
  S := IntToStr(Index);
  txtStyle.SingleLine := True;
  txtStyle.Wordbreak := True;
  txtStyle.Alignment := taCenter;
  txtStyle.Layout := tlCenter;
  txtStyle.EndEllipsis := False;
  ListBox1.Canvas.TextRect(ImageRect, 0, 0, S, txtStyle);
end;

procedure TxColumnImagesForm.ListBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
  begin
    Key := 0;
    if ListBox1.ItemIndex >= 0 then
    begin
      ValueListEditor1.Cells[1, ValueListEditor1.Row] := IntToStr(ListBox1.ItemIndex);
    end;
  end;
end;

procedure TxColumnImagesForm.ValueListEditor1DrawCell(Sender: TObject; aCol,
  aRow: Integer; aRect: TRect; aState: TGridDrawState);
var
  S: string;
  I: Integer;
begin
  if Images = nil then Exit;

  if ACol = 1 then
  begin
    S := ValueListEditor1.Values[ValueListEditor1.Keys[ARow]];
    if S <> '' then
    begin
      I := StrToInt(S);
      Images.Draw(ValueListEditor1.Canvas, ARect.Right - Images.Width - 2, ARect.Top + 2, I);
    end;
  end;
end;

procedure TxColumnImagesForm.ValueListEditor1KeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_DELETE) and (Shift = [ssCtrl]) then
  begin
    Key := 0;
    ValueListEditor1.DeleteRow(ValueListEditor1.Row);
  end;
end;

procedure TxColumnImagesForm.ValueListEditor1SelectCell(Sender: TObject; aCol,
  aRow: Integer; var CanSelect: Boolean);
begin
  if aCol = 1 then CanSelect := False;
end;

procedure TxColumnImagesForm.SetImages(Value: TCustomImageList);
var
  I: Integer;
begin
  if FImages <> Value then
  begin
    FImages := Value;
    if FImages <> nil then
    begin
      ListBox1.ItemHeight := FImages.Height + 2;
      I := 0;
      while I < FImages.Count do
      begin
        ListBox1.Items.Add(IntToStr(I));
        Inc(I);
      end;
    end;
  end;
end;

{ TImagesIndexesProperty }

procedure TImagesIndexesProperty.Edit;
var
  Column: TxColumn;
begin
  Column := TxColumn(GetComponent(0));
  xColumnImagesForm := TxColumnImagesForm.Create(Application);
  xColumnImagesForm.ValueListEditor1.Strings.Assign(Column.ImagesIndexes);
  xColumnImagesForm.Images := Column.Grid.ImageList;
  if xColumnImagesForm.Images <> nil then
  begin
    xColumnImagesForm.ValueListEditor1.DefaultRowHeight := xColumnImagesForm.Images.Height + 4;
  end;
  try
    if xColumnImagesForm.ShowModal = mrOk then
    begin
      Column.ImagesIndexes.Assign(xColumnImagesForm.ValueListEditor1.Strings);
      Modified;
    end;
  finally
    xColumnImagesForm.Free;
  end;
end;

end.

