unit designobjects;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs;

type
  TDesForm = class(TForm)
  private
    { private declarations }
  public
    procedure DesignerOpened(ADesigner: TIDesigner; Root: TComponent);
    procedure DesignerClosed;
    procedure ValidateRename(AComponent: TComponent; const CurName,
       NewName: string); override;
  end;

  TDesDataModule = class(TDataModule)
  public
    Designer: TIDesigner;
    procedure ValidateRename(AComponent: TComponent; const CurName,
       NewName: string); override;
  end;

implementation

uses FormDesig;

{$R *.lfm}

procedure TDesForm.DesignerOpened(ADesigner: TIDesigner; Root: TComponent);
begin
  SetDesigning(True, True);
  Designer := ADesigner;
  TDesignerHook(Designer).Form := Self;
  TDesignerHook(Designer).Root := Root;
end;

procedure TDesForm.DesignerClosed;
begin
  Designer := nil;
  SetDesigning(False, True);
end;

procedure TDesForm.ValidateRename(AComponent: TComponent; const CurName,
       NewName: string);
begin
  if csDestroying in ComponentState then Exit;

  if (Designer <> nil) and (csDesigning in ComponentState) and
  (CurName <> '') and (NewName <> '') then
    Designer.ValidateRename(AComponent, CurName, NewName);
end;

{TDesDataModule}

procedure TDesDataModule.ValidateRename(AComponent: TComponent; const CurName,
       NewName: string);
begin
  if csDestroying in ComponentState then Exit;

  if (Designer <> nil) and (csDesigning in ComponentState) and
  (CurName <> '') and (NewName <> '') then
    Designer.ValidateRename(AComponent, CurName, NewName);
end;

end.

