#!/bin/bash

function alse_setup()(
  function show_greetings() {
    echo " ";
    echo " Utility to install usual programs and tools for Astra Linux";
    echo " Copyright (c) 2021-2025 Alexey Kuryakin kouriakine@mail.ru";
    echo " Version: 20250113";
    echo "";
  };
  function show_title() {
    echo " ";
    echo " $*";
    echo " ";
  };
  function show_run() {
    local title="$1";
    shift;
    show_title "$title";
    echo "Run: $*";
    $*;
  };
  function skip_run() {
    local title="$1";
    shift;
    show_title "$title";
    echo "Skip: $*";
  };
  function execute(){
    echo "";
    echo "$(date +%Y.%m.%d-%H:%M:%S) - Execute: $*";
    echo "";
    "$@";
  };
  function skip(){
   true;
  };
  function sudo_mkdir_chmod(){
   execute sudo mkdir -p $1;
   execute sudo chmod $2 $1;
  };
  function make_opt_dirs(){
   sudo_mkdir_chmod /opt/daqgroup/development/projects 777;
   sudo_mkdir_chmod /opt/daqgroup/development/tools    777;
  };
  function install_packages() {
    show_run "Update packages…"                 sudo apt-get update;
    show_run "Upgrage packages…"                sudo apt-get dist-upgrade;
    show_run "Install Text tools…"              sudo apt-get install gucharmap;
    show_run "Install File tools… "             sudo apt-get install fdupes jdupes;
    show_run "Install Bash tools… "             sudo apt-get install zenity dialog;
    show_run "Install Network FS…"              sudo apt-get install cifs-utils sshfs;
    show_run "Install Network Tools…"           sudo apt-get install rsync remmina vino socat dnsutils;
    show_run "Install Sensors+Monitors…"        sudo apt-get install lm-sensors hddtemp conky-std sysstat stress;
    show_run "Install DoubleCommander…"         sudo apt-get install doublecmd-common doublecmd-gtk doublecmd-help-ru doublecmd-plugins;
    show_run "Install SerialPort tools…"        sudo apt-get install setserial minicom;
    show_run "Add $USER to dialout group…"      sudo usermod -aG dialout $USER && id $USER;
    show_run "Install System Cleaning tools…"   sudo apt-get install bleachbit;
    show_run "Install Math Tools…"              sudo apt-get install kcalc;
    show_run "Install Debian Tools…"            sudo apt-get install dpkg debconf debhelper lintian;
    show_run "Install Debian Utils…"            sudo apt-get install devscripts debsums;
    show_run "Install Tcl/Tk Tools…"            sudo apt-get install tcl tcl-doc tcl-dev tk tk-doc tk-dev;
    show_run "Install Developer Tools…"         sudo apt-get install dos2unix ncurses-base ncurses-bin ncurses-term ncurses-doc libncurses5-dev libtinfo-dev libmotif-common libmotif-dev libmrm4 libxm4 libxmu-headers libxmu-dev libxpm-dev libjpeg-dev;
    show_run "Install Fpcupdeluxe libs…"        sudo apt-get install make binutils build-essential gdb subversion zip unzip libx11-dev libgtk2.0-dev libgdk-pixbuf2.0-dev libcairo2-dev libpango1.0-dev;
    show_run "Install GTK Tools …"              sudo apt-get install libcairo2 libgail-common gnome-themes-standard;
    show_run "Install Makeself Tools…"          sudo apt-get install makeself zenity zip unzip xz-utils p7zip;
    show_run "Install Markdown Tools…"          sudo apt-get install markdown pandoc firefox firefox-astra;
    skip;
    skip_run "Install Wine… "                   sudo apt-get install winehq-staging winetricks;
    skip_run "Install Samba Server…"            sudo apt-get install samba fly-admin-samba winbind;
    skip_run "Install PlayOnLinux… "            sudo apt-get install playonlinux;
    skip_run "Install BlutoothManager… "        sudo apt-get install blueman;
    show_run "Update packages…"                 sudo apt-get update;
    show_run "Upgrage packages…"                sudo apt-get dist-upgrade;
  };  
  clear;
  show_greetings;
  make_opt_dirs;
  install_packages;
  show_title "Done";
);
alse_setup;
