#!/bin/bash

function firefox_backup()(
 function show_greetings(){
  echo " ";
  echo " Utility to make backup of Firefox configuration files";
  echo " Copyright (c) 2025 Alexey Kuryakin kouriakine@mail.ru";
  echo " Version: 20250110";
  echo "";
 };
 function show_title(){
  echo " ";
  echo " $*";
  echo " ";
 };
 function execute(){
  echo "";
  echo "$(date +%Y.%m.%d-%H:%M:%S) - Execute: $*";
  echo "";
  $*;
 };
 function skip(){
  true;
 };
 function list_add(){
  list="$list $*";
 };
 clear;
 show_greetings;
 local list=" ";
 list_add cert9.db key4.db logins.json;
 list_add places.sqlite favicons.sqlite permissions.sqlite formhistory.sqlite cookies.sqlite;
 skip list_add storage.sqlite content-prefs.sqlite protections.sqlite webappsstore.sqlite;
 local backup="$HOME/.mozilla/firefox_backup_$(date +%Y%m%d_%H%M%S).7z";
 local dir="`dirname $(find $HOME/.mozilla/firefox/ -maxdepth 2 -name cookies.sqlite | head -n 1)`";
 if [ -z "$dir" ]; then echo "Firefox profile is not found."; return 1; fi;
 if [ -d "$dir" ]; then
  if pushd $dir; then
   execute 7za a $backup *.sqlite *.db *.json;
  fi;
  popd;
 fi;
 if [ -e "$backup" ]; then echo ""; echo "Archive created: $backup"; fi;
 show_title "Done";
);
firefox_backup;
