#!/bin/bash

readonly libdim="/opt/dim/libdim.so";

function dump_libdim(){
 objdump -t $libdim | grep .text | awk '{print $6}' | sort | uniq;
};

function list_export(){
 cat $1 | grep external | grep -v WINDOWS | sed 's/.*name \x27//' | sed 's/\x27.*//';
};

main(){
 #dump_libdim;
 local nok=0;
 local ner=0;
 if [[ -n "$1" ]]; then
  exp="$(list_export $1)";
  for id in $exp; do
   local ex="$(dump_libdim | grep "^$id\$" 2>/dev/null)";
   if dump_libdim | grep $id >/dev/null 2>&1 && [[ "$ex" = "$id" ]]; then
    let nok+=1;
   else
    let ner+=1;
    1>&2 echo "Invalid: $id ($ex)";
   fi;
  done;
 fi;
 echo "Found $nok item(s), $ner error(s)."
};

main "$@";
