#!/bin/bash

##########################################################
# Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru
##########################################################

function note(){ return; };

function fatal(){
 local date="$(date +%Y.%m.%d-%H:%M:%S)"; local script="$(basename ${BASH_SOURCE[0]})";
 if which notify-send; then notify-send -t 30000 -i dialog-error "$date: $script" "$1"; fi;
 echo -ne "\n$1\n\n";
 exit 1;
};

note "Script identification.";
note "######################";
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

readonly targetdir="/srv/public/mirror/addons/astra-linux/astra-tools";
readonly xcopy="cp --preserve=mode,timestamps -fv";

declare -i nsucc=0;
declare -i nfail=0;

function succed(){ echo "SUCCED: $1"; let nsucc++; };
function failed(){ echo "FAILED: $1"; let nfail++; };

function call(){
 if $1; then
  succed "$1";
  true;
 else
  failed "$1";
  false;
 fi;
};

function update_product(){
 local product="$1"; echo "Update $product";
 local runfile="$(realpath $scriptHOME/$product/install-$product.run)";
 local bldfile="$(ls -1 $scriptHOME/$product/*-build-$product.tar.xz | sort | tail -n 1)";
 local srcfile="$(ls -1 $scriptHOME/../daqgroup/suite/*-$product.tar.xz | sort | tail -n 1)";
 if [ -e $bldfile ]; then bldfile="$(realpath $bldfile)"; fi;
 if [ -e $srcfile ]; then srcfile="$(realpath $srcfile)"; fi;
 echo "bldfile=$bldfile"; echo "srcfile=$srcfile";
 call "sudo $xcopy $runfile $targetdir/$product/";
 call "sudo $xcopy $bldfile $targetdir/$product/";
 call "sudo $xcopy $srcfile $targetdir/$product/";
 if [ "$product" = "daqgroup-crwlib" ]; then
  local suite="$(echo "$product" | sed 's/crwlib/suite/')";
  srcfile="$(ls -1 $scriptHOME/../daqgroup/suite/*-$suite.tar.xz | sort | tail -n 1)";
  if [ -e $srcfile ]; then srcfile="$(realpath $srcfile)"; fi; echo "srcfile=$srcfile";
  call "sudo $xcopy $srcfile $targetdir/$product/";
 fi;
};

function update_products(){
 local ask="Hello, $USER.";
 ask="$ask\nDo you want to run the script:";
 ask="$ask\n\n<big><b><span fgcolor='green'>$scriptname</span></b>?</big>";
 ask="$ask\n\n<b><span fgcolor='blue'>Confirm</span>?</b>";
 if zenity --question --text "$ask" --timeout 180 >/dev/null 2>&1; then
  note "Run $scriptname …";
 else
  return 0;
 fi;
 local date="$(date +%Y%m%d)";
 local time="$(date +%Y%m%d-%H%M%S)";
 echo "";
 echo "daqgroup-suite update $time …";
 echo "";
 for product in $*; do
  update_product $product;
 done;
 echo "$(date +%Y.%m.%d-%H:%M:%S) - Done $nsucc operations succed, $nfail failed.";
 echo "";
 if [ -t 0 ]; then
  read -t 180 -p "Press any key to continue …" -n 1;
 else
  local icon="dialog-ok-apply";
  if [ $nfail -gt 0 ]; then icon="dialog-error"; fi;
  local date="$(date +%Y.%m.%d-%H:%M:%S)"; local script="$(basename ${BASH_SOURCE[0]})";
  notify-send -t 300000 -i $icon "$date: $script" "Succed:$nsucc, Failed:$nfail.\nWork is Done.";
 fi;
}

function main(){
 local products="daqgroup-crwdaq daqgroup-crwkit daqgroup-crwlib";
 if [ -t 1 ]; then
  update_products $products;
 else
  update_products $products > $scriptHOME/$scriptbase.log;
 fi;
};

main "$@";

##############
## END OF FILE
##############
