unit testsort;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

interface
 
uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math,
 _crw_alloc, _crw_zm, _crw_sort;

procedure Test_sort;

implementation

procedure Test_sort;
const
 mm=250;
var
 A,B,index:array[0..mm-1] of LongInt;
 i:LongInt;
 D:array[0..10] of double; x:double;
begin
 //PlaySound('c:\crwexe\resource\sound\Привет.wav',0,SND_ASYNC+SND_FILENAME);
 //PlaySound('c:\crwexe\resource\sound\Привет.wav',0,SND_ASYNC+SND_FILENAME);
 for i:=0 to mm-1 do A[i]:=random(10000);
 writeln('************** Start test of _sort unit **************************');
 writeln(' Sorted=',isSortedArray(mm,A,nil));
 writeln(' Input array:'); for i:=0 to mm-1 do write(A[i],' ');
 writeln;
 //writeln('Press enter...'); readln;
 writeln;
 {
 call shellsort procedure
 }
 B:=A;
 Sort(mm,@B,CompareLongInts,KeyOfLongInts,SwapLongInts,nil);
 writeln(' ShellSort=',isSortedArray(mm,B,nil));
 writeln(' Output array:'); for i:=0 to mm-1 do write(B[i],' ');
 writeln;
 //writeln('Press enter...'); readln;
 writeln;
 {
 call quicksort procedure
 }
 B:=A;
 Sort(mm,@B,CompareLongInts,KeyOfLongInts,SwapLongInts,nil,smQuickSort);
 writeln(' QuickSort=',isSortedArray(mm,B,nil));
 writeln(' Output array:'); for i:=0 to mm-1 do write(B[i],' ');
 writeln;
 //writeln('Press enter...'); readln;
 writeln;
 {
 call shellsortindex procedure
 }
 Sort(mm,@A,CompareLongInts,KeyOfLongInts,nil,@index);
 writeln(' ShellSortIndex=',isSortedArray(mm,A,@index));
 writeln(' Output array:'); for i:=0 to mm-1 do write(A[index[i]],' ');
 writeln;
 //writeln('Press enter...'); readln;
 writeln;
 {
 call quicksortindex procedure
 }
 Sort(mm,@A,CompareLongInts,KeyOfLongInts,nil,@index,smQuickSort);
 writeln(' QuickSortIndex=',isSortedArray(mm,A,@index));
 writeln(' Output array:'); for i:=0 to mm-1 do write(A[index[i]],' ');
 writeln;
 //writeln('Press enter...'); readln;
 writeln;
 {
 call sortindex procedure
 }
 SortIndex(mm,A,@index);
 writeln(' SortIndex=',isSortedArray(mm,A,@index));
 writeln(' Output array:'); for i:=0 to mm-1 do write(A[index[i]],' ');
 writeln('FindIndex=',FindIndex(mm,A,155,@index));
 writeln;
 //writeln('Press enter...'); readln;
 writeln;
 {
 call sortindex procedure
 }
 SortIndex(mm,A,@index,smQuickSort);
 writeln(' SortIndex=',isSortedArray(mm,A,@index));
 writeln(' Output array:'); for i:=0 to mm-1 do write(A[index[i]],' ');
 writeln('FindIndex=',FindIndex(mm,A,155,@index));
 writeln;
 //writeln('Press enter...'); readln;
 writeln;
 {
 check quickfind
 }
 for i:=0 to 10 do D[i]:=i;
 for i:=0 to 9 do begin
  x:=i+0.5;
  if i<>QuickFind(11,@D,CompareDoubles,KeyOfDoubles,@x)
  then writeln('Error in FindXXXIndex');
 end;
 writeln('FindIndex=',FindIndex(11,D,5.5));
 x:=5;
 writeln('QuickSearch=',QuickSearch(11,@D,CompareDoubles,KeyOfDoubles,@x,i),' ',i);
 x:=5.5;
 writeln('QuickSearch=',QuickSearch(11,@D,CompareDoubles,KeyOfDoubles,@x,i),' ',i);
 writeln('**************  Stop test of _sort unit **************************');
end;

end.
