unit testdynar;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math,
 _crw_alloc, _crw_fpu, _crw_ef, _crw_zm, _crw_rtc, _crw_fifo, _crw_dynar;

procedure Test_DynAr;

implementation

procedure readln;
begin
end;

procedure Test_DynAr;
var vx:TDoubleVector; mx:TDoubleMatrix; i,j:LongInt;
 procedure PrintVx(vx:TDoubleVector);
 var i:integer;
 begin
  writeln('vx=[');
  for i:=0 to vx.Length-1 do write(' ',Format('%g',[vx[i]]));
  writeln;
  writeln(' ]');
  readln;
 end;
 procedure PrintMx(mx:TDoubleMatrix);
 var i,j:integer;
 begin
  writeln('mx[');
  for i:=mx.Origin to mx.Origin+mx.Rows-1 do begin
   for j:=mx.Origin to mx.Origin+mx.Columns-1 do write(' ',mx[i,j]:3:1);
   writeln;
  end;
  writeln(' ]');
  readln;
 end;
begin

 writeln('Vector test:');
 writeln('************');
 vx:=NewDoubleVector(0);
 //vx.Exceptions:=false;
 vx.Length:=20;
 for i:=0 to vx.Length-1 do vx[i]:=i+1.5;
 PrintVx(vx);
 vx.length:=10;
 PrintVx(vx);
 vx.length:=30;
 PrintVx(vx);
 Kill(vx);

 writeln('Matrix test:');
 writeln('************');
 mx:=NewDoubleMatrix(0,0);
 //mx.Exceptions:=false;
 printmx(mx);
 mx.rows:=8;
 mx.columns:=6;
 printmx(mx);
 mx.Origin:=1;
 for i:=1 to mx.rows do
 for j:=1 to mx.columns do mx[i,j]:=i+j/10;
 printmx(mx);
 mx.Origin:=0;
 printmx(mx);
 mx.rows:=9;
 printmx(mx);
 mx.rows:=5;
 printmx(mx);
 mx.rows:=9;
 printmx(mx);
 mx.columns:=8;
 printmx(mx);
 mx.columns:=4;
 printmx(mx);
 mx.columns:=8;
 printmx(mx);
 kill(mx);
end;

end.
