﻿---

[[toc]]

---

# Инструментарий crwkit

Инструментарий **crwkit** - это набор служебных программ для пакета **CRW-DAQ** группы **DaqGroup**.

Он расположен (логически) в папке **[/opt/crwkit](/opt/crwkit/)**.  
Это постоянная ссылка на физическую папку
**[/opt/daqgroup/suite/crwkit](/opt/daqgroup/suite/crwkit/)**,
положение которой может измениться со временем.

В набор **crwkit** входят программы, нужные для работы пакета **CRW-DAQ**,
но (возможно) имеющие и самостоятельный интерес.

---

## Обертка: unix = crwkit = crwrun

Все программы набора **crwkit** доступны через программу - **обертку**,  
имеющую следующие названия - синонимы: **unix**, **crwkit**, **crwrun**.  
Любая другая программа набора **crwkit** вызывается через эту обертку,  
например:

``` bash
unix dimsrv
crwrun dimtree
crwkit dimStat
```

Такое наименование возникло исторически. Сначала под **Windows** был создан пакет **UnixUtils**,
который вкключал программу-обертку **unix** и служил для добавления некоторых команд **UNIX**
в среде **Windows**. Затем при переходе под **Linux** пакет **UnixUtils** был переименован
в **crwkit**, но команду **unix** было решено оставить для совместимости с первоначальной
версией **UnixUtils**. Команда **crwrun** была добавлена для удобства.
Важно, что все три команды (**unix**, **crwkit**, **crwrun**) являются синонимами
и делаают в точности одно и то же. Конкретную обертку можно выбирать из соображений
удобства и улучшения читабельности сценариев обработки.

---

## Опции программы-обертки crwkit

Использование программы:

``` bash
unix   [-options] [command [arguments]]
crwrun [-options] [command [arguments]]
crwkit [-options] [command [arguments]]
```
Опции могут иметь короткую форму (**-h**) или длинную (**--help**).

| Опция             | Описание                                              |
|-------------------|-------------------------------------------------------|
| --version         | Печатает версию программы.                            |
| --copyright       | Печатает авторские права.                             |
| -h или --help     | Печатает справку.                                     |
| -l или --list     | Печатает список доступных команд.                     |
| -m или --manual   | Открывает эту инструкцию по **crwkit**.               |
| -c или --command  | Считать следующие аргументы командой для исполнения.  |

---

## Команды набора crwkit (таблица)

| Команда                   | Описание                                                                                 |
|---------------------------|------------------------------------------------------------------------------------------|
|                           | <b class="big memo">Оболочка crwkit</b>                                                  |
| **crwkit**                | Программа-обертка **crwkit** - ключ ко всем остальным программам.                        |
| **crwrun**                | Программа-обертка, синоним **crwkit**.                                                   |
| **unix**                  | Программа-обертка, синоним **crwkit**.                                                   |
| **crwrun.sh**             | Программа-обертка, синоним **crwkit**.                                                   |
|                           | <b class="big memo">Вспомогательные утилиты crwkit</b>                                   |
| **crwkit_root**           | Печатает путь домашней папки расположения **crwkit**.                                    |
| **unixroot**              | Печатает путь домашней папки расположения **crwkit**.                                    |
| **path**                  | Печатает пути **$PATH** поиска программ **crwkit**.                                      |
| **lsuart**                | Печатает список доступных **COM** портов.                                                |
| **crwdep**                | Проверяет зависимости (установленные пакеты), нужные для работы **crwdaq** & **crwkit**. |
|                           | <b class="big memo">Пакет CRW-DAQ</b>                                                    |
| **crwdaq**                | Пакет **CRW-DAQ** для создания систем сбора данных и управления экспериментами.          |
| **send2crwdaq**           | Программа (_send to crwdaq_) для посылки сообщений в Главную Консоль пакета **crwdaq**.  |
| **dimsrv**                | Сервер для публикации данных и связи по сети **DIM** в пакете **CRW-DAQ**.               |
| **dimcfg**                | Утилита (_DIM config_) для конфигурирования сервера **&DimSrv**.                         |
| **smiproxy**              | **Smi Proxy** - сервер прокси для Конечных Автоматов **SMI FSM** в пакете **CRW-DAQ**.   |
| **smiuisrv**              | **SmiUI Srv** - сервер контроля Конечных Автоматов **SMI FSM** в пакете **CRW-DAQ**.     |
| **uartterminalgui**       | **UART Terminal GUI** - графический терминал **COM** портов, как в пакете **CRW-DAQ**.   |
|                           | <b class="big memo">DIM</b> - _Distributed Information Management system_                |
| **checkDimServers**       | Проверяет число **DIM** серверов в сети.                                                 |
| **checkDns**              | Проверяет доступность **DIM DNS** сервера в сети.                                        |
| **did**                   | Программа просмотра (_display DIM_) сервисов **DIM**.                                    |
| **dim_demotest_client**   | Программа тестирования **DIM** (клиент).                                                 |
| **dim_demotest_server**   | Программа тестирования **DIM** (сервер).                                                 |
| **DimBridge**             | Программа-мост для **DIM** передачи данных **DIM**.                                      |
| **dim-cpl**               | Программа - Центр Управления для настройки **DIM**.                                      |
| **dimStat**               | Программа анализа статистики траффика в сети **DIM**.                                    |
| **dimstatgui**            | Графическая оболочка для удобства вызова **dimStat**.                                    |
| **dimmonitor**            | Графическая программа для мониторирования **DIM**.                                       |
| **dimtree**               | Программа просмотра данных (браузер) в сети **DIM**.                                     |
| **dns**                   | Программа - сервер имен **DNS** в сети **DIM**.                                          |
| **dim_send_command**      | Утилита для посылки сообщения (команды) **DIM** серверу.                                 |
|                           | <b class="big memo">SMI</b> - _State Manager Interface system_                |
| **smigengui**             | **Smi Generic GUI** - графическая утилита управления Конечными Автоматами **SMI FSM**.   |
| **dnsDebugging**          | Отладочная утилита для **SMI**.                                                          |
| **dnsExists**             | Утилита для проверки статуса (запущен или нет) сервера имен **DIM DNS**.                 |
| **dnsRunning**            | Утилита для проверки статуса (YES/NO) сервера имен **DIM DNS**.                          |
| **domainExists**          | Утилита для проверки статуса (yes/no) домена **SMI**, т.е. **FSM** сервера **smiSM**.    |
| **getDimVersions**        | Утилита печатает версии **DIM** серверов.                                                |
| **getDomainObjects**      | Утилита печатает список объектов в домене **SMI**.                                       |
| **getDomainObjectSets**   | Утилита печатает список наборов (_object set_) объектов в домена **SMI**.                |
| **getDomains**            | Утилита печатает список доменов **SMI**, работающих с данным сервером имен **DIM DNS**.  |
| **getObjectState**        | Утилита печатает состояние заданного объекта в домене **SMI**.                           |                                                                                          | **getSetObjects**         | Утилита печатает состояние наборов объектов в домене **SMI**.                            |
| **getSmiVersions**        | Утилита печатает версии серверов доменов **SMI**.                                        |
| **listDomain**            | Утилита печатает список объектов в домене **SMI**.                                       |
| **monObjects**            | Утилита для мониторинга объектов в домене **SMI**.                                       |
| **monObjectsServiceName** | Утилита для мониторинга объектов в домене **SMI**.                                       |
| **monObjectState**        | Утилита для мониторинга объектов в домене **SMI**.                                       |
| **proxyExists**           | Утилита проверяет наличие сервера прокси объекта **SMI**.                                |
| **smi_change_option**     | Утилита для настройки доменов **SMI**.                                                   |
| **smiChangeOption**       | Утилита для настройки доменов **SMI**.                                                   |
| **smiGen**                | Утилита генерации прототипа прокси объекта **SMI**.                                      |
| **smiGUI**                | Утилита наблюдения состояния объектов **SMI** с графическим интерфейсом.                 |
| **smiGUI.tcl**            | Утилита наблюдения состояния объектов **SMI** с графическим интерфейсом **tcl/tk**.      |
| **smiKill**               | Утилита для остановки работы сервера домена **SMI**.                                     |
| **smi_send_command**      | Утилита для посылки команд объектам **SMI** (Конечным Автоматам).                        |
| **smiSendCommand**        | Утилита для посылки команд объектам **SMI** (Конечным Автоматам).                        |
| **smiSM**                 | Программа - сервер домена **SMI**. Универсальный сервер для Конечных Автоматов **SMI**.  |
| **smiTrans**              | Транслятор языка **SML** для компиляции текстов **.sml** в объектные **.sobj** файлы.    |
| **tellMonObjects**        | Вспомогательная утилита для мониторинга объектов в домене **SMI**.                       |
|                           | <b class="big memo">Вспомогательные утилиты общего назначения</b>                        |
| **textmetadata**          | Программа проверки контрольных сумм конфиг.файлов.                                       |
| **say**                   | Синоним **speak**.                                                                       |
| **speak**                 | Программа речевого синтезатора на базе **RHVoice**.                                      |
| **speaker**               | Синоним **speak**.                                                                       |
| **barbmp**                | Программа рисует прямоугольник в файл (_bar bitmap_).                                    |
| **ledbmp**                | Рисует прямоугольник с текстом в файл (_LED bitmap_).                                    |
| **sercat**                | **serial cat** - консольный терминал **COM** портов.                                     |
| **sercatgui**             | **sercat GUI** - графический терминал **COM** портов.                                    |
| **fixeol**                | Исправляет (_fix_) разделители строк (_eol=end of line_) в заданных текстовых файлах.    |
| **fixeolzen**             | Графическая оболочка на основе **zenity** для программы **fixeol**.                      |
| **fixutf8**               | Исправляет (_fix_) формат заданных текстовых файлов, приводя кодировку к **UTF8**.       |
| **fixгеа8zen**            | Графическая оболочка на основе **zenity** для программы **fixгеа8**.                     |
| **lister**                | Программа для просмотра текстовых файлов и документов (для совместимости).               |
| **grun**                  | Программа для запуска других программ в различных режимах (_general run_).               |
| **pipeterm**              | Программа терминала (_pipe terminal_) для всех видов каналов (_task,pipe,tcp,com_).      |
| **borndefunct**           | Программа порождает (_born_) мертвый (_defunct_) зомби (_zombie_) процесс для тестов.    |
| **psdefunct**             | Показывает (как _ps_) мертвые (_defunct_) зомби (_zombie_) процессы для диагностики.     |
| **simpleipcsend**         | Посылка сообщения через простой канал **IPC** (_simple IPC send_) для связи процессов.   |
| **simpleipcrecv**         | Прием сообщений через простой канал **IPC** (_simple IPC receiver_) для связи процессов. |
| **png2ico**               | Конвертирует один или несколько файл(ов) **PNG** в файл **ICO**.                         |
| **getapppath**            | Программа поиска пути исполняемого файла по типу или расширению для открытия документа.  |
| **filecase**              | Программа группового переименования имен файлов/каталогов в нижний/верхний регистр.      |
| **filecasezen**           | Графическая оболочка на основе **zenity** для программы **filecase**.                    |
| **mousepos**              | Индикатор положения мыши **Mouse Position** для настройки графического окружения.        |
| **checksum**              | Программа вычисления и проверки контрольных сумм (_checksum_) для контроля целостности.  |
| **wintail**               | Программа (_window tail_) для просмотра журнальных файлов, т.е. **.log** файлов.         |
| **tooltip-notifier**      | Программа (_tooltip-notifier_) для вызова всплывающих уведомлений с разными натройками.  |
| **fpquitip**              | Синоним **tooltip-notifier** для совместимости со старыми версиями **CRW-DAQ**.          |
| **session-logout**        | Выход (завершение) текущей (графической) сессии (_session logout_).                      |
| **gif2bmp**               | Утилита (_GIF to BMP_) для преобразования изображения формата **GIF** в формат **BMP**.  |
| **printc**                | Утилита (_print color_) для консольной печати с выбором цвета, формата и т.д.            |
| **sendEmail**             | Программа для посылки электронного письма из консоли (синоним **sendemail**).            |
| **sendemail**             | Программа для посылки электронного письма из консоли (синоним **sendEmail**).            |
| **whichis**               | Расширенный поиск полного пути команды (_which is_), например **unix whichis dimStat**.  |
| **wanted**                | Расширенная версия **whichis** с дополнительным поиском каталогов **daqgroup**.          |
| **root**                  | Вызывает пакет анализа и обработки данных **ROOT** (_root_) от **CERN**.                 |
| **rootenv**               | Вызов команды в среде окружения, подготовленной для работы **ROOT** от **CERN**.         |
| **rootsys**               | Печатает корневой каталог расположения пакета **ROOT** (_root_) от **CERN**.             |
| **chwindow**              | Изменяет состояние окна (_change window_) с заданным заголовком и параметрами состояния. |
| **hidewindow**            | Прячет окно (_hide window_) с заданным заголовком (убирает с экрана и с панели задач).   |
| **showwindow**            | Показывает окно (_show window_) с заданным заголовком (рисует на экране и панели задач). |
| **minimizewindow**        | Минимизирует окно (_minimize window_) с заданным заголовком (убирает с экрана).          |
| **maximizewindow**        | Максимизирует окно (_maximize window_) с заданным заголовком (рисует на весь экран).     |
| **findwindow**            | Находит окно (_find window_) с заданным заголовком и печатает его характеристики.        |
| **listwindow**            | Выводит список окон (_list window_) с заданным заголовком [классом, файлом].             |
| **movewindow**            | Передвигает окно (_move window_) с заданным заголовком в заданное положение экрана.      |
| **killwindow**            | Убивает (закрывает) окно (_kill window_) с заданным заголовком/классом/процессом.        |
| **closewindow**           | Закрывает (убивает) окно (_close window_) с заданным заголовком/классом/процессом.       |
| **setforegroundwindow**   | Активизирует (перемещает наверх) окно с заданным заголовком (_set foreground window_).   |
| **msecnow**               | Печатает текущее время в миллисекундах (_milli seconds now_) для измерения времени.      |
| **dunstcfg**              | Конфигуратор для настройки системы всплывающих уведомлений **dunst**.                    |
| **colorcode**             | Печатает **RGB** код цвета по его имени в различных форматах.                            |
| **ldev-cpl**              | Программа загрузки/выгрузки/проверки драйверов (модулей ядра) для устройств **LCARD**.   |
| **lcard-cpl**             | Синоним **ldev-cpl**.                                                                    |
| **lsldev**                | Показывает список подключенных устройств **LCARD** с именами и серийными номерами.       |
| **lsldev**                | Синоним **lsldev**.                                                                      |
| **fc-alias**              | Выдает список псевдонимов шрифтов **sans**, **serif**, **monospace** и т.д.              |
| **cherry**                | Набор служебных (вспомогательных) команд (сценариев) разного назначения.                 |
| **catlnk**                | Утилита печатает содержимое файла - ярлыка **Рабочего Стола** (_Desktop Shortcut_).      |
| **crtlnk**                | Утилита для создания ярлыка **Рабочего Стола** - файла **.lnk** или **.desktop**.        |
| **wmquery**               | Выполняет запрос  **Менеджеру Окон** для управления окнами **Рабочего Стола**.           |
| **pasdoc**                | Программа генерации справки для кодов на языке **FreePascal**.                           |
| **pasdoc-man**            | Вызов справочной страницы **pasdoc**.                                                    |
| **pasdoc-pdf**            | Вызов справки **pasdoc** в формате **PDF**.                                              |
| **pasdoc-css**            | Работа с файлом стиля **pasdoc.css**.                                                    |
| **fpdoc-css**             | Работа с файлом стиля **fpdoc.css**.                                                     |
| **daqgroup-css**          | Печатает файл стиля **daqgroup.css**, используемый для документации.                     |
| **daqgroup-mime**         | Печатает файл настройки **daqgroup.mime**, используемый для определения типов файлов.    |
| **diesel-pascal**         | Вызов **Дизель Паскаля** - интерпретатора или среды разработки (зависит от опций).       |
| **pingwin**               | Команда **ping** в графической оболочке **DieselPascal**.                                |
| **pyvenv**                | Выполнение команд в виртуальной среде **Python** - _python virtual environment_.         |
| **wmquerygui**            | Графическая оболочка для команды **wmquery** работы с **Менеджером Окон**.               |
| **readcfg**               | Чтение секций или именованных параметров из файлов формата **INI** или **CFG**.          |
| **opcua-cpl**             | Программа - **Панель Управления** для **OPCUA**.                                         |
| **ansi**                  | Программа выводит в консоль цветной текст с использованием управляяющих кодов **ANSI**.  |
| **ansiman**               | Программа открывает справку для программы **ansi**.                                      |
| **dirchain**              | Программа печатает цепочку родительских каталогов для данного каталога или файла.        |
| **findlibso**             | Программа поиска библиотек **`lib*.so`**, зарегистрированных в системе.                  |
| **lsdbcl**                | Поиск клиентских библиотек **`lib*.so`** для **СУБД**: _list database client libraries_. |
| **fb-cpl**                | Программа (контрольная панель - _cpl_) управления сервером **Firebird**.                 |
| **flamerobin**            | Утилита для администрирования Баз Данных **Firebird**.                                   |
| **sqlook**                | Программа клиента на движке **DbApi** для чтения/обзора **Баз Данных** различных типов.  |
| **klogg-cpl**             | Программа настройки утилиты **klogg**.                                                   |
| **logroll**               | Утилита для ротации журнальных файлов (циклическое переименование и сжатие).             |
| **xmonsize**              | Утилита для определения размера экрана/монитора в системе **X** (_x monitor size_).      |
| **readini**               | Утилита для чтения секций и переменных из **INI** файла.                                 |
| **assoc**                 | Печатает **MIME** тип по ассоциации (расширению файла), как **Windows assoc**.           |
| **ftype**                 | Печатает обработчик для заданного **MIME** типа, как **Windows ftype**.                  |
| **find-app**              | Поиск приложения по короткому имени **.desktop** файла в системной базе данных.          |
| **find-icon**             | Поиск иконки по короткому имени в системной базе данных иконок.                          |
| **chkutf8**               | Проверка допустимости **UTF8** текстовых файлов с рекурсивным поиском в каталогах.       |
|                           |                                                                                          |

---

Успешного вам использования инструментария **crwkit**!

---

> CRW-DAQ Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru

---
