unit form_crwdaq;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 {$IFDEF UNIX} baseunix, unix, {$ENDIF}
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, Printers,
 lcltype, lclintf, PrintersDlgs, IniFiles,
 printer4lazarus,
 Form_CrwDaqSysChild, unit_crwdaq_common,
 Form_Calculator, Form_ListBoxSelection,
 Form_UartTerminal, Form_ConsoleWindow,
 Form_TextEditor, Form_CurveWindow,
 Form_SurfWindow, Form_CircuitWindow,
 Form_CalibDialog, Form_SpectrWindow,
 Form_DelphiProjectEditor, Form_LazarusProjectEditor, Form_CrwDaqBugList,
 Unit_ReadOldCrwFiles, Unit_ResourceMonitorConsole,
 Form_CrwDaqWatchDog, Form_VoicePreset,
 Form_MistimingService, Form_SecretService,
 Form_NsisWindow, form_texteditdialog,
 Unit_SystemConsole,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_environ, _crw_cmdargs, _crw_colors,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard, _crw_geoid,
 _crw_ef, _crw_ee, _crw_hash, _crw_hl, _crw_gloss,
 _crw_regexp, _crw_base32, _crw_base64, _crw_crypt,
 _crw_uart, _crw_pio, _crw_rfadata, _crw_daqreaddat,
 _crw_task, _crw_proc, _crw_polling, _crw_wmctrl, _crw_utf8,
 _crw_calib, _crw_uac, _crw_couple, _crw_riff, _crw_lttb,
 _crw_daqtags, _crw_daqsys, _crw_daqdev, _crw_crwdaq, _crw_syslog,
 _crw_adamdev, _crw_softdev, _crw_crwapiserver, _crw_sect, _crw_lngid,
 Unit_CrwDaqMessages, Unit_KeyBoardLayout, ptembed, _crw_uri,
 _crw_sesman, _crw_assoc, _crw_mimeapps, _crw_syscal,
 _crw_fpcup, _crw_pascalprojects, _crw_appmodal,
 _crw_appforms, _crw_apptools, _crw_apputils;

type

  { TFormCrwDaq }

  TFormCrwDaq = class(TMasterForm)
    {
    General purpose controls
    }
    ActionList: TActionList;
    MainMenu: TMainMenu;
    PanelMain: TPanel;
    ToolBar: TToolBar;
    StatusBar: TStatusBar;
    ImageList: TImageList;
    ImageList32: TImageList;
    TimerSecond: TTimer;
    TimerTick55: TTimer;
    OpenDialog: TOpenDialog;
    CommonOpenDialog: TOpenDialog;
    PrinterSetupDialog: TPrinterSetupDialog;
    TrayIconMain: TTrayIcon;
    PopupMenuTray: TPopupMenu;
    {
    Actions
    }
    ActionFileNewTextEditor: TAction;
    ActionFileNewCurveWindow: TAction;
    ActionFileNewDataAnalysisPlugin: TAction;
    ActionFileNewDataAcquisitionPlugin: TAction;
    ActionFileNewDaqCreator: TAction;
    ActionFileNewDaqConstructor: TAction;
    ActionFileNewProjectFromSample: TAction;
    ActionFileOpen: TAction;
    ActionFileSave: TAction;
    ActionFileSaveAs: TAction;
    ActionFilePrint: TAction;
    ActionFilePrinterSetup: TAction;
    ActionFileExit: TAction;
    ActionDaq: TAction;
    ActionDaqDevice: TAction;
    ActionDaqNavigator: TAction;
    ActionToolsCalculator: TAction;
    ActionToolsPlot2D: TAction;
    ActionToolsPlot3D: TAction;
    ActionToolsUartTerminal: TAction;
    ActionToolsPipeTerm: TAction;
    ActionToolsWmqueryGui: TAction;
    ActionToolsRegExpCalculator: TAction;
    ActionToolsLogViewer: TAction;
    ActionToolsDatabaseBrowser: TAction;
    ActionToolsCalibDialog: TAction;
    ActionToolsRecodeCodePage: TAction;
    ActionToolsRfaMendeleevTable: TAction;
    ActionToolsVoicePreset: TAction;
    ActionToolsKeyBoardLayout: TAction;
    ActionToolsDimGui: TAction;
    ActionToolsDimTree: TAction;
    ActionToolsOpcuaCpl: TAction;
    ActionToolsGnuplot: TAction;
    ActionToolsMousePos: TAction;
    ActionToolsRoot: TAction;
    ActionToolsExplorer: TAction;
    ActionToolsFileManager: TAction;
    ActionToolsTerminal: TAction;
    ActionToolsTaskmgr: TAction;
    ActionToolsConsoleUtilities: TAction;
    ActionToolsConsoleUtilitiesMode: TAction;
    ActionToolsCustomCommand0: TAction;
    ActionToolsCustomCommand1: TAction;
    ActionToolsCustomCommand2: TAction;
    ActionToolsCustomCommand3: TAction;
    ActionToolsCustomCommand4: TAction;
    ActionToolsCustomCommand5: TAction;
    ActionToolsCustomCommand6: TAction;
    ActionToolsCustomCommand7: TAction;
    ActionToolsCustomCommand8: TAction;
    ActionToolsCustomCommand9: TAction;
    ActionToolsCustomCommandEditor: TAction;
    ActionWindowsSelect: TAction;
    ActionWindowsHome: TAction;
    ActionWindowsPrev: TAction;
    ActionWindowsNext: TAction;
    ActionWindowsTile: TAction;
    ActionWindowsCascade: TAction;
    ActionWindowsMinimizeAll: TAction;
    ActionWindowsArrangeAll: TAction;
    ActionWindowsShowActive: TAction;
    ActionWindowsUpdate: TAction;
    ActionWindowsOpenSystemConsole: TAction;
    ActionWindowsOpenResourceMonitorConsole: TAction;
    ActionWindowsWatchDogControl: TAction;
    ActionWindowsMistimingService: TAction;
    ActionWindowsToggleMainMenu: TAction;
    ActionWindowsToggleToolBar: TAction;
    ActionWindowsToggleStatusBar: TAction;
    ActionWindowsToggleHideIconicSdiChildren: TAction;
    ActionWindowsToggleAwakeModal: TAction;
    ActionWindowsSecretService: TAction;
    ActionWindowsResetGuard: TAction;
    ActionHelpIndex: TAction;
    ActionHelpAbout: TAction;
    ActionHelpCrwDaqDoc: TAction;
    ActionHelpHandBook: TAction;
    ActionHelpDelphi: TAction;
    ActionHelpWin32Sdk: TAction;
    ActionHelpFpcup: TAction;
    ActionLinkHome: TAction;
    ActionLinkHomeDemo: TAction;
    ActionLinkHomePackages: TAction;
    ActionLinkHomeResource: TAction;
    ActionLinkHomeSettings: TAction;
    ActionLinkHomeSettingsCrwDaqIni: TAction;
    ActionLinkHomeSettingsCrwDaqCustmIni: TAction;
    ActionLinkHomePackagesAdmiLinkInstallAdmiLinkExe: TAction;
    ActionLinkHomeResourceToolsWinKeyLockIstallWinKeyLockExe: TAction;
    ActionLinkHomePackagesSpeechApiSpchApiExe: TAction;
    ActionLinkHomePackagesSpeechApiLhttsrurExe: TAction;
    ActionLinkHomePackagesSpeechApiLhttsengExe: TAction;
    ActionLinkHomePackagesOpcCoreInstallOpcCoreCmd: TAction;
    ActionLinkHomePackagesAdmilinkAdmilinkExe: TAction;
    ActionLinkHomePackagesCom0comInstallCom0comCmd: TAction;
    ActionLinkHomePackagesCom0comAddBinCom0comLm9: TAction;
    ActionLinkHomeResourceShellWmQueryGuiLm9: TAction;
    ActionLinkHomeResourceShellPingWinLm9: TAction;
    ActionLinkHomePackagesDieselPascalInstallDieselPascalCmd: TAction;
    ActionLinkHomePackagesMarkdownInstallMarkdownViewerAddonCmd: TAction;
    ActionLinkHomePackagesQdirInstallQdirCmd: TAction;
    ActionLinkHomeResourceCrwDaqUtilsLm9: TAction;
    ActionLinkHomeResourceDaqSiteDaqCreatorDaqCreatorLm9: TAction;
    ActionLinkHomeResourceDaqSiteDaqConstructorDaqConstructorHtm: TAction;
    ActionLinkHomeResourceDaqSiteDaqConfiguratorCfgConfiguratorLm9: TAction;
    ActionLinkHomeResourceDaqSiteDaqConfiguratorCrcConviguratorLm9: TAction;
    ActionLinkHomeResourceDaqSiteSmiServerSmiGenGuiLm9: TAction;
    ActionLinkHomeResourceDimSiteDim_cmdDimMonitorLm9: TAction;
    ActionLinkHomeResourceDimSiteDim_cmdDimStatGuiLm9: TAction;
    ActionLinkHomeResourceDaqSiteDimServerDim_benchmarkLm9: TAction;
    ActionLinkHomeResourceToolsUnitConverterUnitConverterHtm: TAction;
    ActionLinkHomeResourceToolsModbus: TAction;
    ActionLinkHomeResourceManualAdam: TAction;
    ActionLinkHttpCrwDaqSu: TAction;
    ActionLinkHttpAdmiLinkRu: TAction;
    ActionLinkMailToKouriakineMailRu: TAction;
    ActionTrayMinimize: TAction;
    ActionTrayTurnOff: TAction;
    ActionTrayTurnOn: TAction;
    ActionTrayRestore: TAction;
    ActionTrayOnAppRestore: TAction;
    ActionTrayExit: TAction;
    ActionOnActivateMainForm: TAction;
    {
    Menu items
    }
    MenuFile: TMenuItem;
    MenuFileNew: TMenuItem;
    MenuFileNewTextEditor: TMenuItem;
    MenuFileNewCurveWindow: TMenuItem;
    MenuFileNewSeparator1: TMenuItem;
    MenuFileNewDataAnalysisPlugin: TMenuItem;
    MenuFileNewDataAcquisitionPlugin: TMenuItem;
    MenuFileNewSeparator2: TMenuItem;
    MenuFileNewDaqCreator: TMenuItem;
    MenuFileNewDaqConstructor: TMenuItem;
    MenuFileNewProjectFromSample: TMenuItem;
    MenuFileOpen: TMenuItem;
    MenuFileSaveSeparator: TMenuItem;
    MenuFileSave: TMenuItem;
    MenuFileSaveAs: TMenuItem;
    MenuFilePrintSeparator: TMenuItem;
    MenuFilePrint: TMenuItem;
    MenuFilePrinterSetup: TMenuItem;
    MenuFileExitSeparator: TMenuItem;
    MenuFileExit: TMenuItem;
    MenuDaq: TMenuItem;
    MenuTools: TMenuItem;
    MenuToolsCalculator: TMenuItem;
    MenuToolsPlot2D: TMenuItem;
    MenuToolsPlot3D: TMenuItem;
    MenuToolsUartTerminal: TMenuItem;
    MenuToolsPipeTerm: TMenuItem;
    MenuToolsWmqueryGui: TMenuItem;
    MenuToolsRegExpCalculator: TMenuItem;
    MenuToolsLogViewer: TMenuItem;
    MenuToolsDatabaseBrowser: TMenuItem;
    MenuToolsCalibDialog: TMenuItem;
    MenuToolsRecodeCodePage: TMenuItem;
    MenuToolsRfaMendeleevTable: TMenuItem;
    MenuToolsVoicePreset: TMenuItem;
    MenuToolsKeyBoardLayout: TMenuItem;
    MenuToolsKeyBoardLayoutSeparator: TMenuItem;
    MenuToolsDimGui: TMenuItem;
    MenuToolsDimTree: TMenuItem;
    MenuToolsDimTreeSeparator: TMenuItem;
    MenuToolsOpcuaCpl: TMenuItem;
    MenuToolsOpcuaCplSeparator: TMenuItem;
    MenuToolsGnuplot: TMenuItem;
    MenuToolsMousePos: TMenuItem;
    MenuToolsRoot: TMenuItem;
    MenuToolsRootSeparator: TMenuItem;
    MenuToolsExplorer: TMenuItem;
    MenuToolsFileManager: TMenuItem;
    MenuToolsTerminal: TMenuItem;
    MenuToolsTaskmgr: TMenuItem;
    MenuToolsConsoleUtilities: TMenuItem;
    MenuToolsConsoleUtilitiesSeparator: TMenuItem;
    MenuToolsConsoleUtilitiesMode: TMenuItem;
    MenuToolsCustomCommandsSeparator: TMenuItem;
    MenuToolsCustomCommands: TMenuItem;
    MenuToolsCustomCommand0: TMenuItem;
    MenuToolsCustomCommand1: TMenuItem;
    MenuToolsCustomCommand2: TMenuItem;
    MenuToolsCustomCommand3: TMenuItem;
    MenuToolsCustomCommand4: TMenuItem;
    MenuToolsCustomCommand5: TMenuItem;
    MenuToolsCustomCommand6: TMenuItem;
    MenuToolsCustomCommand7: TMenuItem;
    MenuToolsCustomCommand8: TMenuItem;
    MenuToolsCustomCommand9: TMenuItem;
    MenuToolsCustomCommandEditorSeparator: TMenuItem;
    MenuToolsCustomCommandEditor: TMenuItem;
    MenuWindows: TMenuItem;
    MenuWindowsSelect: TMenuItem;
    MenuWindowsHome: TMenuItem;
    MenuWindowsPrev: TMenuItem;
    MenuWindowsNext: TMenuItem;
    MenuWindowsTile: TMenuItem;
    MenuWindowsCascade: TMenuItem;
    MenuWindowsMinimizeAll: TMenuItem;
    MenuWindowsArrangeAll: TMenuItem;
    MenuWindowsSelector: TMenuItem;
    MenuWindowsShowActive: TMenuItem;
    MenuItemBigSpace: TMenuItem;
    MenuWindowsUpdate: TMenuItem;
    MenuWindowsOpenSystemConsole: TMenuItem;
    MenuWindowsOpenResourceMonitorConsole: TMenuItem;
    MenuWindowsWatchDogControl: TMenuItem;
    MenuWindowsMistimingService: TMenuItem;
    MenuWindowsDaq: TMenuItem;
    MenuWindowsToggleMainMenu: TMenuItem;
    MenuWindowsToggleToolBar: TMenuItem;
    MenuWindowsToggleStatusBar: TMenuItem;
    MenuWindowsToggleHideIconicSdiChildren: TMenuItem;
    MenuWindowsToggleAwakeModal: TMenuItem;
    MenuWindowsSecretService: TMenuItem;
    MenuWindowsResetGuard: TMenuItem;
    MenuHelp: TMenuItem;
    MenuHelpIndex: TMenuItem;
    MenuHelpAboutSeparator: TMenuItem;
    MenuHelpAbout: TMenuItem;
    MenuHelpCrwDaqDoc: TMenuItem;
    MenuHelpHandBook: TMenuItem;
    MenuHelpDelphi: TMenuItem;
    MenuHelpWin32Sdk: TMenuItem;
    MenuHelpFpcup: TMenuItem;
    MenuLink: TMenuItem;
    MenuLinkHomeLinks: TMenuItem;
    MenuLinkHome: TMenuItem;
    MenuLinkHomeDemo: TMenuItem;
    MenuLinkHomePackages: TMenuItem;
    MenuLinkHomeResource: TMenuItem;
    MenuLinkHomeSettings: TMenuItem;
    MenuLinkHomeSettingsCrwDaqIni: TMenuItem;
    MenuLinkHomeSettingsCrwDaqCustmIni: TMenuItem;
    MenuLinkHomeSeparator1: TMenuItem;
    MenuLinkHomeInstall: TMenuItem;
    MenuLinkHomePackagesSpeechApiInstallSpchApiExe: TMenuItem;
    MenuLinkHomePackagesSpeechApiInstallLhttsrurExe: TMenuItem;
    MenuLinkHomePackagesSpeechApiInstallLhttsengExe: TMenuItem;
    MenuLinkHomePackagesAdmiLinkInstallAdmiLinkExe: TMenuItem;
    MenuLinkHomeOpcCoreInstallOpcCoreCmd: TMenuItem;
    MenuLinkHomePackagesQdirInstallQdirCmd: TMenuItem;
    MenuLinkHomePackagesCom0comInstallCom0comCmd: TMenuItem;
    MenuLinkHomePackagesCom0comAddBinCom0comLm9: TMenuItem;
    MenuLinkHomeResourceShellWmQueryGuiLm9: TMenuItem;
    MenuLinkHomeResourceShellPingWinLm9: TMenuItem;
    MenuLinkHomePackagesDieselPascalInstallDieselPascalCmd: TMenuItem;
    MenuLinkHomeResourceToolsWinKeyLockInstallLinkKeyLockExe: TMenuItem;
    MenuLinkHomePackagesMarkdownInstallMarkdownViewerAddonCmd: TMenuItem;
    MenuLinkHomeLaunch: TMenuItem;
    MenuLinkHomePackagesAdmilinkAdmilinkExe: TMenuItem;
    MenuLinkHomeResourceToolsUnitConverterUnitConverterHtm: TMenuItem;
    MenuLinkDaqSystemLinks: TMenuItem;
    MenuLinkHomeResourceCrw32UtilsLm9: TMenuItem;
    MenuLinkHomeResourceDaqSiteDaqCreatorDaqCreatorLm9: TMenuItem;
    MenuLinkHomeResourceDaqSiteDaqConstructorDaqConstructorHtm: TMenuItem;
    MenuLinkHomeResourceDaqSiteDaqConfiguratorCfgConfiguratorLm9: TMenuItem;
    MenuLinkHomeResourceDaqSiteDaqConfiguratorCrcConviguratorLm9: TMenuItem;
    MenuLinkHomeResourceDaqSiteSmiServerSmiGenGuiLm9: TMenuItem;
    MenuLinkHomeResourceDimSiteDim_cmdDimMonitorLm9: TMenuItem;
    MenuLinkHomeResourceDimSiteDim_cmdDimStatGuiLm9: TMenuItem;
    MenuLinkHomeResourceDaqSiteDimServerDim_benchmarkLm9: TMenuItem;
    MenuLinkHomeDaqSystemSeparator1: TMenuItem;
    MenuLinkHomeDaqSystemSeparator2: TMenuItem;
    MenuLinkHomeResourceToolsModbus: TMenuItem;
    MenuLinkHomeResourceManualAdam: TMenuItem;
    MenuLinkCrwDaqLinks: TMenuItem;
    MenuLinkHttpCrwDaqRu: TMenuItem;
    MenuLinkHttpAdmiLinkRu: TMenuItem;
    MenuLinkMailToKouriakineMailRu: TMenuItem;
    MenuCopyrightProof: TMenuItem;
    MenuTrayMinimize: TMenuItem;
    MenuTrayRestore: TMenuItem;
    MenuTrayExitSeparator: TMenuItem;
    MenuTrayExit: TMenuItem;
    {
    Toolbar buttons
    }
    ToolButtonFileNewTextEditor: TToolButton;
    ToolButtonFileNewCurveWindow: TToolButton;
    ToolButtonFileOpen: TToolButton;
    ToolButtonFileSaveSeparator: TToolButton;
    ToolButtonFileSave: TToolButton;
    ToolButtonFileSaveAs: TToolButton;
    ToolButtonFilePrintSeparator: TToolButton;
    ToolButtonFilePrint: TToolButton;
    ToolButtonFilePrinterSetup: TToolButton;
    ToolButtonFileExit: TToolButton;
    ToolButtonFileExitSeparator: TToolButton;
    ToolButtonDaqSeparator: TToolButton;
    ToolButtonDaq: TToolButton;
    ToolButtonDaqDevice: TToolButton;
    ToolButtonDaqNavigator: TToolButton;
    ToolButtonDaqClock: TToolButton;
    ToolButtonToolsSeparator: TToolButton;
    ToolButtonToolsVoicePreset: TToolButton;
    ToolButtonToolsVoicePresetSeparator: TToolButton;
    ToolButtonToolsConsoleUtilities: TToolButton;
    ToolButtonToolsCalculator: TToolButton;
    ToolButtonToolsPlot2D: TToolButton;
    ToolButtonToolsPlot3D: TToolButton;
    ToolButtonToolsUartTerminal: TToolButton;
    ToolButtonToolsPipeTerm: TToolButton;
    ToolButtonToolsWmqueryGui: TToolButton;
    ToolButtonToolsRegExpCalculator: TToolButton;
    ToolButtonToolsLogViewer: TToolButton;
    ToolButtonToolsDatabaseBrowser: TToolButton;
    ToolButtonToolsCalibDialog: TToolButton;
    ToolButtonToolsTaskMgrSeparator: TToolButton;
    ToolButtonToolsTaskmgr: TToolButton;
    ToolButtonToolsExplorer: TToolButton;
    ToolButtonToolsTerminal: TToolButton;
    ToolButtonToolsFileManager: TToolButton;
    ToolButtonWindowsMistimingService: TToolButton;
    ToolButtonWindowsOpenSystemConsoleSeparator: TToolButton;
    ToolButtonToolsDimGuiSeparator: TToolButton;
    ToolButtonToolsDimGui: TToolButton;
    ToolButtonToolsDimTree: TToolButton;
    ToolButtonToolsOpcuaCpl: TToolButton;
    ToolButtonToolsGnuplot: TToolButton;
    ToolButtonToolsRoot: TToolButton;
    ToolButtonToolsMousePosSeparator: TToolButton;
    ToolButtonToolsMousePos: TToolButton;
    ToolButtonWindowsSeparator: TToolButton;
    ToolButtonWindowsSelect: TToolButton;
    ToolButtonWindowsHome: TToolButton;
    ToolButtonWindowsPrev: TToolButton;
    ToolButtonWindowsNext: TToolButton;
    ToolButtonWindowsMinimizeAll: TToolButton;
    ToolButtonWindowsArrangeAll: TToolButton;
    ToolButtonWindowsUpdate: TToolButton;
    ToolButtonWindowsOpenSystemConsole: TToolButton;
    ToolButtonWindowsOpenResourceMonitorConsole: TToolButton;
    ToolButtonWindowsWatchDogControl: TToolButton;
    ToolButtonWindowsSecretService: TToolButton;
    ToolButtonWindowsResetGuard: TToolButton;
    ToolButtonHelpSeparator: TToolButton;
    ToolButtonHelpIndex: TToolButton;
    ToolButtonHelpCrwDaqDoc: TToolButton;
    ToolButtonHelpHandBook: TToolButton;
    ToolButtonGuardSeparator: TToolButton;
    {
    General purpose routines
    }
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormResize(Sender: TObject);
    procedure MenuWindowsSelectorClick(Sender: TObject);
    procedure ResizeStatusBar;
    procedure DoShowHint(Sender: TObject);
    procedure StatusBarDblClick(Sender: TObject);
    procedure UpdateCommands;
    procedure TimerSecondTimer(Sender: TObject);
    procedure TimerTick55Timer(Sender: TObject);
    procedure TrayIconMainClick(Sender: TObject);
    procedure TrayIconMainDblClick(Sender: TObject);
    {
    Messages
    }
    {$IFDEF WINDOWS}
    procedure HandleWMCopyData(var Msg: TMessage); message WM_COPYDATA;
    procedure HandleWMDisplayChange(var Msg:TMessage); message WM_DISPLAYCHANGE;
    procedure HandleWMQueryEndSession(var Msg: TMessage); message WM_QUERYENDSESSION;
    procedure HandleWMEndSession(var Msg: TMessage); message WM_ENDSESSION;
    {$ENDIF ~WINDOWS}
    {
    Actions implementation
    }
    procedure ActionListUpdate(Action: TBasicAction; var Handled: Boolean);
    procedure ActionFileNewTextEditorExecute(Sender: TObject);
    procedure ActionFileNewCurveWindowExecute(Sender: TObject);
    procedure ActionFileNewDataAnalysisPluginExecute(Sender: TObject);
    procedure ActionFileNewDataAcquisitionPluginExecute(Sender: TObject);
    procedure ActionFileNewDaqCreatorExecute(Sender: TObject);
    procedure ActionFileNewDaqConstructorExecute(Sender: TObject);
    procedure ActionFileNewProjectFromSampleExecute(Sender: TObject);
    procedure ActionFileOpenExecute(Sender: TObject);
    procedure OpenDialogTypeChange(Sender: TObject);
    procedure CommonOpenDialogTypeChange(Sender: TObject);
    procedure ActionFileSaveExecute(Sender: TObject);
    procedure ActionFileSaveAsExecute(Sender: TObject);
    procedure ActionFilePrintExecute(Sender: TObject);
    procedure ActionFilePrinterSetupExecute(Sender: TObject);
    procedure ActionFileExitExecute(Sender: TObject);
    procedure ActionDaqExecute(Sender: TObject);
    procedure ActionDaqDeviceExecute(Sender: TObject);
    procedure ActionDaqNavigatorExecute(Sender: TObject);
    procedure ActionToolsCalculatorExecute(Sender: TObject);
    procedure ActionToolsPlot2DExecute(Sender: TObject);
    procedure ActionToolsPlot3DExecute(Sender: TObject);
    procedure ActionToolsUartTerminalExecute(Sender: TObject);
    procedure ActionToolsPipeTermExecute(Sender: TObject);
    procedure ActionToolsWmqueryGuiExecute(Sender: TObject);
    procedure ActionToolsRegExpCalculatorExecute(Sender: TObject);
    procedure ActionToolsLogViewerExecute(Sender: TObject);
    procedure ActionToolsDatabaseBrowserExecute(Sender: TObject);
    procedure ActionToolsCalibDialogExecute(Sender: TObject);
    procedure ActionToolsRecodeCodePageExecute(Sender: TObject);
    procedure ActionToolsRfaMendeleevTableExecute(Sender: TObject);
    procedure ActionToolsKeyBoardLayoutExecute(Sender: TObject);
    procedure ActionToolsDimGuiExecute(Sender: TObject);
    procedure ActionToolsDimTreeExecute(Sender: TObject);
    procedure ActionToolsOpcuaCplExecute(Sender: TObject);
    procedure ActionToolsGnuplotExecute(Sender: TObject);
    procedure ActionToolsRootExecute(Sender: TObject);
    procedure ActionToolsExplorerExecute(Sender: TObject);
    procedure ActionToolsFileManagerExecute(Sender: TObject);
    procedure ActionToolsTerminalExecute(Sender: TObject);
    procedure ActionToolsTaskmgrExecute(Sender: TObject);
    procedure ActionToolsConsoleUtilitiesExecute(Sender: TObject);
    procedure ActionToolsConsoleUtilitiesModeExecute(Sender: TObject);
    procedure ActionToolsCustomCommand0Execute(Sender: TObject);
    procedure ActionToolsCustomCommand1Execute(Sender: TObject);
    procedure ActionToolsCustomCommand2Execute(Sender: TObject);
    procedure ActionToolsCustomCommand3Execute(Sender: TObject);
    procedure ActionToolsCustomCommand4Execute(Sender: TObject);
    procedure ActionToolsCustomCommand5Execute(Sender: TObject);
    procedure ActionToolsCustomCommand6Execute(Sender: TObject);
    procedure ActionToolsCustomCommand7Execute(Sender: TObject);
    procedure ActionToolsCustomCommand8Execute(Sender: TObject);
    procedure ActionToolsCustomCommand9Execute(Sender: TObject);
    procedure ActionToolsCustomCommandEditorExecute(Sender: TObject);
    procedure ActionToolsMousePosExecute(Sender: TObject);
    procedure ActionWindowsSelectExecute(Sender: TObject);
    procedure ActionWindowsHomeExecute(Sender: TObject);
    procedure ActionWindowsPrevExecute(Sender: TObject);
    procedure ActionWindowsNextExecute(Sender: TObject);
    procedure ActionWindowsTileExecute(Sender: TObject);
    procedure ActionWindowsCascadeExecute(Sender: TObject);
    procedure ActionWindowsMinimizeAllExecute(Sender: TObject);
    procedure ActionWindowsArrangeAllExecute(Sender: TObject);
    procedure ActionWindowsShowActiveExecute(Sender: TObject);
    procedure ActionWindowsUpdateExecute(Sender: TObject);
    procedure ActionWindowsOpenSystemConsoleExecute(Sender: TObject);
    procedure ActionWindowsOpenResourceMonitorConsoleExecute(Sender: TObject);
    procedure ActionWindowsWatchDogControlExecute(Sender: TObject);
    procedure ActionHelpIndexExecute(Sender: TObject);
    procedure ActionHelpAboutExecute(Sender: TObject);
    procedure ActionHelpCrwDaqDocExecute(Sender: TObject);
    procedure ActionHelpHandBookExecute(Sender: TObject);
    procedure ActionHelpDelphiExecute(Sender: TObject);
    procedure ActionHelpWin32SdkExecute(Sender: TObject);
    procedure ActionHelpFpcupExecute(Sender: TObject);
    procedure ActionToolsVoicePresetExecute(Sender: TObject);
    procedure ActionWindowsMistimingServiceExecute(Sender: TObject);
    procedure ActionWindowsToggleMainMenuExecute(Sender: TObject);
    procedure ActionWindowsToggleToolBarExecute(Sender: TObject);
    procedure ActionWindowsToggleStatusBarExecute(Sender: TObject);
    procedure ActionWindowsToggleHideIconicSdiChildrenExecute(Sender: TObject);
    procedure ActionWindowsToggleAwakeModalExecute(Sender: TObject);
    procedure ActionWindowsSecretServiceExecute(Sender: TObject);
    procedure ActionWindowsResetGuardExecute(Sender: TObject);
    procedure ActionLinkExecute(Sender: TObject);
    procedure ActionTrayMinimizeExecute(Sender: TObject);
    procedure ActionTrayRestoreExecute(Sender: TObject);
    procedure ActionTrayOnAppRestoreExecute(Sender: TObject);
    procedure ActionTrayExitExecute(Sender: TObject);
    procedure ActionTrayTurnOffExecute(Sender: TObject);
    procedure ActionTrayTurnOnExecute(Sender: TObject);
    procedure MenuCopyrightProofClick(Sender: TObject);
    procedure ActionOnActivateMainFormExecute(Sender: TObject);
  private
    { Private declarations }
    myVerboseLogon : Boolean;
    myCloseQueryCount : Integer;
    myDesktopLogoFile : LongString;
    myNtRights : LongString;
    myCmdList  : TText;
    myCmdCalc  : TExpressionEvaluator;
    myDefaultHint : LongString;
    myFileVerInfo : LongString;
    myGreetingBox : LongString;
    myDirPos : TPoint;
    myDirCls : LongString;
    myDirTit : LongString;
    myDirCap : LongString;
    myEnvironmentStrings : LongString;
    myTty0Counts : record
     Activate : QWord;
     Incoming : QWord;
     Accepted : QWord;
     Rejected : QWord;
     Refused  : QWord;
     Total    : QWord;
    end;
    myDpcBuff:TeeTokensBuffer;
    function  GetDesktopLogoFile:LongString;
    procedure SetDesktopLogoFile(aFileName:LongString);
    procedure EnterLogo;
    procedure LeaveLogo;
    procedure HideLogo;
    procedure KillLogo;
    function  GetBugListFile:LongString;
    procedure HandleApplicationExceptions(Sender: TObject; E: Exception);
    procedure HookAllPostMessages(var Msg: TMsg; var Handled: Boolean);
    function  HookAllSentMessages(var Message: TLMessage):Boolean;
    procedure ActionListUpdateAll(Action: TBasicAction; var Handled: Boolean);
    procedure ResourceLeakageLogMessage(const Msg:LongString);
    procedure HandleDeferredCallbackRequest(var Msg:TLMessage); message WM_CrwDaqDeferredCallbackRequest;
    procedure ExecuteDeferredCommands;
    procedure OnAsyncAppRestore(Data:PtrInt);
  public
    { Public declarations }
    function  VerboseLogon:Boolean;
    function  CloseQueryCount:Integer;
    function  CommonOpenDialogExecute(const aTitle,aFileName,aFilter:LongString; Params:LongString):LongString;
    function  CommonSelectDirectoryDialog(const aTitle,aDir,aOptions:LongString; Params:LongString):LongString;
    property  DesktopLogoFile:LongString read GetDesktopLogoFile write SetDesktopLogoFile;
    function  PostDeferredCommand(const Cmd:LongString):boolean;
    function  DeferredCommandCalculator:TExpressionEvaluator;
    procedure SdiChildrenMinimizeOrRestore;
    procedure UpdateMenuToolsConsoleUtilitiesModeCaption;
    procedure UpdateActionLinksState;
    procedure UpdateTitle(const aTitle:LongString);
    procedure ShowTrayIcon(aShow:Boolean);
    procedure UpdateTrayIconCaptions;
    procedure GoHome;
    procedure HandleSessionIpc(Line:LongString);
    procedure HandleApplicationOnIdle(Sender:TObject; var Done:Boolean);
  end;

const
 FormCrwDaq : TFormCrwDaq = nil;
 TrayIconPopupOnClick : Boolean = true;
 ProcessShutdownForce : Boolean = false;
 sb_Comment  = 0;
 sb_Rights   = 1;
 sb_DaqTime  = 2;
 sb_Memory   = 3;
 sb_DateTime = 4;
 sb_Language = 5;

function CRW_DAQ_SYS_PATH:LongString;

function ActionStdHandler(Action:TAction):Boolean;

implementation

{$R *.lfm}

uses
 form_createnewprojectfromsample,
 Form_CrwDaqLogo,
 Form_RegExpCalculator,
 Form_DatabaseBrowser,
 Form_RecodeCodePageDialog,
 Form_RfaMendeleevTable,
 Form_DaqControlDialog,
 Form_SurfByFormula;

function act_open(ee:TExpressionEvaluator; const args:LongString):double; forward;

procedure Initialize_SybSystems;
begin
 if InitSubSystems.Count>0 then begin
  FormCrwDaq.EnterLogo;
  InitSubSystems.Execute;
  InitSubSystems.Clear;
  FormCrwDaq.HideLogo;
  InitTooltip;
 end;
end;

procedure Finalize_SybSystems;
begin
 if DoneSubSystems.Count>0 then begin
  FormCrwDaq.LeaveLogo;
  DoneSubSystems.Execute;
  DoneSubSystems.Clear;
  FormCrwDaq.KillLogo;
  FreeTooltip;
 end;
end;

procedure ExecuteLogScript(LogType:LongString);
var task:TTask; cmd:LongString; TimeOut:Integer; ms:QWord;
begin
 try
  LogType:=Trim(LogType);
  if FormCrwDaq.VerboseLogon then begin
   UpdateStatusLine(RusEng('Выполняю сценарий ','Running script ')+LogType+' …');
   SafeApplicationProcessMessages;
  end;
  TimeOut:=SysGlossary.ReadIniLinkDef(SysIniFile,SectSystem,LogType+'Timeout',0);
  cmd:=SysGlossary.ReadIniPathDef(SysIniFile,SectSystem(1),LogType+'Script',HomeDir,'');
  cmd:=UnifyFileAlias(cmd,ua_FileDefLow);
  if IsEmptyStr(cmd) or not FileExists(cmd) then Exit;
  Echo(Format('Run %sScript "%s" …',[LogType,cmd]));
  task:=NewTask('',GetShellCmd(AnsiQuotedIfNeed(cmd)),HomeDir,'','',0);
  try
   ms:=GetTickCount64;
   if task.Run then begin
    Echo(Format('PID %d started: %s',[task.Pid,task.CmdLine]));
    if not task.Running(TimeOut) then begin
     ms:=GetTickCount64-ms;
     Echo(Format('PID %d stopped: exit code %d, exit status %d, after %u ms elapsed.',
                [task.Pid,task.ExitCode,task.ExitStatus,ms]));
    end;
   end else Echo(Format('Could not execute command: %s',[task.CmdLine]));
  finally
   Kill(task);
  end;
 except
  on E:Exception do BugReport(E,FormCrwDaq,'ExecuteLogScript');
 end;
end;

procedure ExecuteLogonScript;
begin
 ExecuteLogScript('Logon');
end;

procedure ExecuteLogoutScript;
begin
 ExecuteLogScript('Logout');
end;

procedure NiceSysLogNote(sev:Integer; msg:LongString);
var len:Integer; uln,oln:LongString;
begin
 len:=utf8_length(msg);
 if (len<=0) then Exit;
 uln:=StringOfChar('_',len);
 oln:=StringOfChar('^',len);
 if SysLogNotable(sev) then begin
  SysLogNote(0,sev,sdr_System,uln);
  SysLogNote(0,sev,sdr_System,msg);
  SysLogNote(0,sev,sdr_System,oln);
 end;
end;

procedure ExecuteSessionNoteLogin;
begin
 NiceSysLogNote(SeverityOfSysLogin,'Session Login.');
end;

procedure ExecuteSessionNoteLogout;
begin
 NiceSysLogNote(SeverityOfSysLogin,'Session Logout.');
end;

procedure ExecuteSystemStartupScript;
var list:TText; i:Integer;
begin
 try
  if FormCrwDaq.VerboseLogon then begin
   UpdateStatusLine(RusEng('Выполняю сценарий ','Running script ')+'StartupScript …');
   SafeApplicationProcessMessages;
  end;
  list:=ExtractListSection(SysIniFile,SectSystemStartupScript,efConfigNC);
  try
   for i:=list.Count-1 downto 0 do begin
    list[i]:=Trim(list[i]);
    if IsEmptyStr(list[i])
    then list.DelLn(i);
   end;
   if (list.Count>0) then SendToMainConsole(list.Text);
  finally
   Kill(list);
  end;
 except
  on E:Exception do BugReport(E,FormCrwDaq,'ExecuteSystemStartupScript');
 end;
end;

procedure ExecuteSessionLogoutSysLog;
var Line,Items,Item,cmd,arg:LongString; i:Integer;
begin
 if SysLog.Polling.Enabled then
 try
  while SessionManager.ReadIpcMessage(Line) do begin
   Line:=Trim(Line);
   if IsLexeme(Line,lex_AtCall) then begin
    cmd:=ExtractWord(1,Line,JustSpaces);
    arg:=Trim(SkipWords(1,Line,JustSpaces));
    if SameText(cmd,smc_Incoming) then begin
     Items:=StringReplace(arg,'@silent ','',[rfReplaceAll,rfIgnoreCase]);
     for i:=1 to WordCount(Items,EolnDelims) do begin
      Item:=ExtractWord(i,Items,EolnDelims);
      cmd:=ExtractWord(1,Item,JustSpaces);
      arg:=Trim(SkipWords(1,Item,JustSpaces));
      if IsLexeme(cmd,lex_AtCmnd) then begin
       if SameText(cmd,'@SysLog') then begin
        SystemCalculator.Eval(cmd+' '+arg);
       end;
      end;
     end;
    end;
   end;
  end;
  SysLog.Polling.WaitForLoop(1);
 except
  on E:Exception do BugReport(E,FormCrwDaq,'ExecuteSessionLogoutSysLog');
 end;
end;

function CrwDaqExitConfirmation:Boolean;
begin
 Result:=(SystemCalculator.Eval('_Crw_Force_Exit_')=1) or StandardExitConfirmation;
end;

procedure Init_StartupGoHome;
begin
 if IsUnix then ApplicationMainFormWnd(true);
 FormCrwDaq.GoHome;
 SystemConsole.Activate;
 SystemConsole.GoHome;
 SystemConsole.GoTail;
 if FormCrwDaq.VerboseLogon then SafeApplicationProcessMessages;
end;

procedure SetEnvVar(const aName,aValue:LongString);
begin
 if SetEnv(aName,aValue)
 then DebugOut(stdfDebug,Format('%s=%s',[aName,GetEnv(aName)]));
end;

 // Note: on Unix window handle available after message processing loop
 // is started so we have to delay CRW_DAQ_SYS_CLASS,CRW_DAQ_SYS_WND
 // assignment by placing it to InitSubsystems queue.
procedure Init_EnvWindowClass;
var wnd:HWND;
begin
 if FormCrwDaq.VerboseLogon then begin
  UpdateStatusLine(RusEng('Инициализирую переменные окружения','Initializing environment')+' …');
  SafeApplicationProcessMessages;
 end;
 if IsUnix and Assigned(FormCrwDaq) then begin
  wnd:=wmctrl.FindWindow(GetCurrentProcessId,'',FormCrwDaq.Caption);
  SetEnvVar('CRW_DAQ_SYS_CLASS',Format('%s',[GetWindowClassName(wnd)]));
  SetEnvVar('CRW_DAQ_SYS_WND',Format('%u',[wnd]));
 end;
 if IsWindows and Assigned(FormCrwDaq) then begin
  SetEnvVar('CRW_DAQ_SYS_CLASS',Format('%s',[GetWindowClassName(FormCrwDaq.Handle)]));
  SetEnvVar('CRW_DAQ_SYS_WND',Format('%u',[FormCrwDaq.Handle]));
 end;
end;

procedure Timer_UpdateDateTime;
begin
 SmartUpdate(FormCrwDaq.StatusBar, sb_DateTime, ' '+StdDateTimeStr(msecnow));
 FormCrwDaq.ActionToolsVoicePreset.Enabled:=UsesBlaster;
 Timer_Check_RTC_Monotonicity;
 GetTickCount64_Fallback;
end;

procedure Timer_UpdateAllocMemSize;
var Mem:SizeInt; MemStr:LongString;
const LastMem:SizeInt=0;
begin
 Mem:=GetAllocMemSize;
 if (Mem<>LastMem) then begin
  LastMem:=Mem;
  MemStr:=IntToStr(Mem);
  if (Length(MemStr)>3)  then System.Insert('.',MemStr,Length(MemStr)-2);
  if (Length(MemStr)>7)  then System.Insert('.',MemStr,Length(MemStr)-6);
  if (Length(MemStr)>11) then System.Insert('.',MemStr,Length(MemStr)-10);
  MemStr:=' '+LeftPad(MemStr,12);
  SmartUpdate(FormCrwDaq.StatusBar, sb_Memory, MemStr);
 end;
end;

procedure Timer_UpdateCommands;
begin
 FormCrwDaq.UpdateCommands;
end;

procedure Timer_CheckLocation;
begin
 with FormCrwDaq do
 if BorderStyle=bsSingle then begin
  if Left<>0 then Left:=0;
  if Top<>0 then Top:=0;
 end;
end;

procedure Timer_DaqClock;
const
 DaqClockCount : Integer = 0;
 DaqClockFreq            = 10000;
begin
 if Daq.Ok and Daq.AcqTimer.IsStart then begin
  FormCrwDaq.ToolButtonDaqClock.ImageIndex:=140+DaqClockCount;
  DaqClockCount:=(DaqClockCount+1) mod 12;
  if FormCrwDaq.ToolButtonDaqClock.Down then Sound(DaqClockFreq,1);
  FormCrwDaq.ActionToolsUartTerminal.Enabled:=false;
 end else begin
  FormCrwDaq.ToolButtonDaqClock.ImageIndex:=139;
  FormCrwDaq.ActionToolsUartTerminal.Enabled:=true;
 end;
end;

procedure GoFormToTop(Form:TForm; Index:Integer; var Terminate:Boolean; Custom:Pointer);
var R1,R2:TRect2I;
begin
 if Form.Visible then
 if (Form<>ApplicationMainForm) then
 if (Form.FormStyle=fsStayOnTop) then
 if (Form.WindowState<>wsMinimized) then
 if  not (fsModal in Form.FormState) then begin
  with TCustomForm(Custom) do begin
   R1:=Rect2I(Left,Top,Left+Width,Top+60);
   with Form do
   R2:=Rect2I(Left,Top,Left+Width,Top+Height);
   if not RectIsEmpty(RectIntersection(R1,R2)) then begin
    if Top + 30 < Screen.DesktopHeight div 2
    then Form.Top:=Screen.DesktopHeight-Form.Height-30
    else Form.Top:=30;
   end; 
  end;
 end;
end;

procedure Timer_SmartWindowLocation;
begin
 try
  if (Screen is TScreen) and
     (Screen.ActiveCustomForm is TCustomForm) and
     (fsModal in Screen.ActiveCustomForm.FormState)
  then ForEachForm(GoFormToTop,Screen.ActiveCustomForm);
 except
  on E:Exception do BugReport(E);
 end;
end;

procedure MakeModalTopMost(Form:TForm);
begin
 if Form.Visible then
 if Form.FormStyle=fsNormal then
 if (fsModal in Form.FormState) then begin
  MakeWindowTopMost(Form);
 end;
end;

procedure Timer_MakeModalTopMost;
begin
 try
  if (Screen is TScreen) and
     (Screen.ActiveCustomForm is TForm) and
     (fsModal in Screen.ActiveCustomForm.FormState)
  then MakeModalTopMost(Screen.ActiveCustomForm as TForm);
 except
  on E:Exception do BugReport(E);
 end;
end;

procedure Timer_ShowRights;
begin
 SmartUpdate(FormCrwDaq.StatusBar, sb_Rights,
             Format('%s:%s',[FormCrwDaq.myNtRights,Guard.LevelName[Guard.Level]]));
end;

procedure Timer_CheckCpuUsage;
const
 LastTickCount : QWORD = 0;
 LastProcKTime : Int64 = 0;
 LastProcUTime : Int64 = 0;
 MinImageIndex         = 181;
 MaxImageIndex         = 196;
var
 CurrTickCount : QWORD;
 CurrProcKTime : Int64;
 CurrProcUTime : Int64;
 CpuProcKern   : Double;
 CpuProcUser   : Double;
 CpuProcSumm   : Double;
 ImageIndex    : Integer;
begin
 try
  CurrTickCount:=GetTickCount64;
  if (CurrTickCount>LastTickCount)
  and GetProcessTimesAsFileTime(CurrProcKTime,CurrProcUTime) then begin
   CpuProcKern:=Max(0,Min(100,0.01*(CurrProcKTime-LastProcKTime)/(CurrTickCount-LastTickCount)));
   CpuProcUser:=Max(0,Min(100,0.01*(CurrProcUTime-LastProcUTime)/(CurrTickCount-LastTickCount)));
   CpuProcSumm:=Max(0,Min(100,CpuProcKern+CpuProcUser));
   ImageIndex:=MinImageIndex+Round((MaxImageIndex-MinImageIndex)*CpuProcSumm/100);
   if FormCrwDaq.Ok then begin
    FormCrwDaq.ToolButtonToolsTaskmgr.ImageIndex:=Max(MinImageIndex,Min(MaxImageIndex,ImageIndex));
    FormCrwDaq.ToolButtonToolsTaskmgr.Hint:=RusEng('Загрузка CPU ','CPU usage ')
                                          +Format('%3.0f',[CpuProcSumm])+'%';
   end;
  end else begin
   CurrTickCount:=0;
   CurrProcKTime:=0;
   CurrProcUTime:=0;
  end;
  LastTickCount:=CurrTickCount;
  LastProcKTime:=CurrProcKTime;
  LastProcUTime:=CurrProcUTime;
 except
  on E:Exception do BugReport(E,nil,'Timer_CheckCpuUsage');
 end;
end;

procedure Timer_DebugOutSetFifo;
begin
 DebugOutSetFifo(stdfDebug,DebugOutFifoSize,DebugOutFifoGrowFactor,DebugOutFifoGrowLimit);
 DebugOutSetFifo(stdfError,DebugOutFifoSize,DebugOutFifoGrowFactor,DebugOutFifoGrowLimit);
 DebugOutSetFifo(stdfReadIniLog,ReadIniLogFifoSize,ReadIniLogFifoGrowFactor,ReadIniLogFifoGrowLimit);
end;

procedure DoHideIconicSdiChildren(Form:TForm; Index:Integer; var Terminate:Boolean; Custom:Pointer);
begin
 if Assigned(Form) then
 try
  if Form.WindowState=wsMinimized then begin
   if Custom<>nil then begin
    if IsWindowVisible(Form.Handle) then begin
     //Echo('Hide SDI child: '+Form.Caption);
     ShowWindow(Form.Handle,SW_HIDE);
    end;
   end else begin
    if not IsWindowVisible(Form.Handle) then begin
     //Echo('Show SDI child: '+Form.Caption);
     ShowWindow(Form.Handle,SW_SHOW);
    end;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'DoHideIconicSdiChildren');
 end;
end;

procedure Timer_HideIconicSdiChildren;
begin
 if FormCrwDaq.ActionWindowsToggleHideIconicSdiChildren.Checked
 then SdiMan.ForEachChild(DoHideIconicSdiChildren,PtrIntToPointer(1));
end;

function NiceSdiCaption(const cap:LongString; MaxLen:Integer=42):LongString;
var s:LongString; w,len:Integer;
begin
 s:=cap;
 if LooksLikeFileName(s) then begin
  w:=FormCrwDaq.Canvas.TextWidth(StringOfChar('M',MaxLen));
  s:=MinimizeFileName(s,FormCrwDaq.Canvas,w,MaxLen);
 end;
 if utf8_valid(s) then len:=utf8_length(s) else len:=Length(s);
 if (len>MaxLen) then begin
  if utf8_valid(s)
  then s:=utf8_copy(s,1,MaxLen)
  else s:=copy(s,1,MaxLen);
  s:=s+ThreeDots;
 end;
 Result:=Trim(RusEng('Окно: ','View: ')+s);
end;

const LastActiveSdiCaption:LongString='';

procedure Timer_UpdateActiveSdiChild;
var Form:TFormCrwDaqSysChild; FormCap:LongString;
begin
 Form:=SdiMan.ActiveChild;
 //Form:=TFormCrwDaqSysChild.ActiveCrwChild;
 if Assigned(Form) then FormCap:=Form.Caption else FormCap:='';
 if (LastActiveSdiCaption=FormCap) or not Assigned(FormCrwDaq) then Exit;
 FormCrwDaq.MenuWindowsShowActive.Caption:=NiceSdiCaption(FormCap);
 LastActiveSdiCaption:=FormCap;
end;

procedure Timer_PollChildProcesses;
begin
 TTask.PollDetachedPids;
end;

procedure CrwDaqUpdateStatusLine(const aMessage:LongString);
begin
 SmartUpdate(FormCrwDaq.StatusBar, sb_Comment, aMessage);
end;

function TFormCrwDaq.VerboseLogon:Boolean;
begin
 if Assigned(Self) then Result:=myVerboseLogon else Result:=false;
end;

function TFormCrwDaq.CloseQueryCount:Integer;
begin
 if Assigned(Self) then Result:=myCloseQueryCount else Result:=0;
end;

function TFormCrwDaq.GetDesktopLogoFile:LongString;
begin
 if Assigned(Self) then Result:=myDesktopLogoFile else Result:='';
end;

procedure TFormCrwDaq.SetDesktopLogoFile(aFileName:LongString);
begin
 if Assigned(Self) then begin
  aFileName:=UnifyFileAlias(aFileName);
  if FileExists(aFileName)
  then myDesktopLogoFile:=aFileName
  else myDesktopLogoFile:='';
 end;
end;

procedure TFormCrwDaq.EnterLogo;
begin
 if Assigned(Self) then begin
  DoShowHint(Self);
  if SolidCrwDaqLogo then
  ShowFormCrwDaqLogo('CRW-DAQ LOGO',RusEng('Подождите, идет загрузка CRW-DAQ …',
                                           'Wait while initializing CRW-DAQ …'),
                                           DesktopLogoFile,true);
  Update;
  SafeApplicationProcessMessages;
 end;
end;

procedure TFormCrwDaq.LeaveLogo;
begin
 if Assigned(Self) then begin
  DoShowHint(Self);
  if SolidCrwDaqLogo then
  ShowFormCrwDaqLogo('CRW-DAQ LOGO',RusEng('Подождите, идет завершение CRW-DAQ …',
                                           'Wait while finalizing CRW-DAQ …'),
                                           DesktopLogoFile,true);
  Update;
  SafeApplicationProcessMessages;
 end;
end;

procedure TFormCrwDaq.HideLogo;
begin
 if Assigned(Self) then begin
  DoShowHint(Self);
  HideFormCrwDaqLogo;
  Update;
 end;
end;

procedure TFormCrwDaq.KillLogo;
begin
 if Assigned(Self) then begin
  DoShowHint(Self);
  HideFormCrwDaqLogo;
  KillFormCrwDaqLogo;
  Update;
 end;
end;

function TFormCrwDaq.GetBugListFile:LongString;
begin
 if Assigned(Self)
 then Result:=ForcePath(SessionManager.VarTmpDir,ForceExtension(ExtractFileName(ProgName),'.bug.log'))
 else Result:='';
end;

procedure TFormCrwDaq.HandleApplicationExceptions(Sender: TObject; E: Exception);
var p:TText; sn,sc,ec,em:LongString;
begin
 BugReport(E,Sender,'Application.OnException');
 if Assigned(Self) then
 try
  if Sender is TObject then sc:=Sender.ClassName else sc:='UNKNOWN';
  if Sender is TComponent then sn:=(Sender as TComponent).Name else sn:='UNKNOWN';
  if E is Exception then ec:=E.ClassName else ec:='UNKNOWN';
  if E is Exception then em:=E.Message else em:='UNKNOWN';
  P:=NewText;
  try
   P.Addln(Pad('',60,'*'));
   P.Addln(RusEng('ВНИМАНИЕ! ОБНАРУЖЕН СБОЙ!','ATTENSION! ERROR ALERT!'));
   P.Addln(Pad('',60,'*'));
   P.Addln(Format(RusEng('Объект "%s" класса "%s"','Object "%s" of class "%s"'),[sn,sc]));
   P.Addln(Format(RusEng('возбудил исключение "%s"','raise exception "%s"'),[ec]));
   P.Addln(Format(RusEng('с сообщением "%s".','with message "%s".'),[em]));
   P.Addln(Format(RusEng('Ошибка обнаружена %s - %s.','Error detected at %s-%s.'),
                  [GetDateStr(msecnow),GetTimeStr(msecnow)]));
   if SysLogNotable(SeverityOfHarmBugs)
   then SysLogNote(0,SeverityOfHarmBugs,sdr_System,
    Format('Object "%s" of class "%s" raise exception "%s" with message "%s".',
    [sn,sc,ec,em]));
   P.Addln(Pad('',60,'*'));
   P.Addln('');
   P.WriteFile(GetBugListFile,true);
   Echo(P.Text);
   SystemConsole.Activate;
   ExecuteSystemConsoleMonitoring(true);
   FormCrwDaqBugList.ErrorAlert(P);
  finally
   Kill(P);
  end;
 except
  on E:Exception do BugReport(E,Self,'HandleApplicationExceptions');
 end;
end;

procedure TFormCrwDaq.HookAllPostMessages(var Msg: TMsg; var Handled: Boolean);
begin
 inc(PostWindowsMessagesCount);
 if (Msg.Message=LM_KEYDOWN) then
 try
  if ActionToolsKeyBoardLayout.Checked then KeyBoardLayoutOnKeyDown(Msg);
 except
  on E:Exception do BugReport(E,Self);
 end;
end;

function TFormCrwDaq.HookAllSentMessages(var Message: TLMessage):Boolean;
begin
 Result:=false;
 inc(SentWindowsMessagesCount);
end;

procedure TFormCrwDaq.ResourceLeakageLogMessage(const Msg:LongString);
var E:Boolean; F:System.Text;
begin
 if Length(ResourceLeakageLogFile)=0 then begin
  if not ReadIniFilePath(SysIniFile,SectSystem,'ResourceLeakageLogFile',HomeDir,ResourceLeakageLogFile)
  then ResourceLeakageLogFile:='';
 end;
 if (ResourceLeakageLogFile<>'') then
 try
  if (DebugOutFileLimit>0) then
  if (GetFileSize(ResourceLeakageLogFile)>DebugOutFileLimit)
  then FileRename(ResourceLeakageLogFile,ResourceLeakageLogFile+'.old');
  SetInOutRes(0);
  E:=FileExists(ResourceLeakageLogFile);
  System.Assign(F,ResourceLeakageLogFile);
  if E then System.Append(F) else System.Rewrite(F);
  try
   if not E then begin
    System.Writeln(F,'Resource Leakage Log file');
    System.Writeln(F,'*************************');
   end;
   System.Writeln(F,Msg);
  finally
   System.Close(F);
   SetInOutRes(0);
  end;
 except
  on E:Exception do BugReport(E,Self,'ResourceLeakageLogMessage');
 end;
end;

procedure TFormCrwDaq.HandleDeferredCallbackRequest(var Msg:TLMessage);
begin
 if Ok then
 try
  HandleCrwDaqDeferredCallbackRequest(Msg);
 except
  on E:Exception do BugReport(E,Self);
 end;
end;

procedure TFormCrwDaq.ExecuteDeferredCommands;
begin
 if Ok then
 try
  while (myCmdList.Count>0) do
  try
   StrCopyBuff(myDpcBuff,myCmdList[0]);
   myCmdCalc.EvaluateLine(myDpcBuff);
  finally
   myCmdList.DelLn(0);
  end;
 except
  on E:Exception do BugReport(E,Self,'ExecuteDeferredCommands');
 end;
end;

procedure DoExecuteDeferredCommands(Sender:TObject);
begin
 if (Sender is TFormCrwDaq)
 then (Sender as TFormCrwDaq).ExecuteDeferredCommands;
end;

function  TFormCrwDaq.PostDeferredCommand(const Cmd:LongString):boolean;
begin
 Result:=False;
 if Ok then
 try
  myCmdList.AddLn(Cmd);
  Result:=PostCrwDaqDeferredCallbackRequest(Handle,DoExecuteDeferredCommands,Self);
 except
  on E:Exception do BugReport(E,Self,'PostDeferredCommand');
 end;
end;

function TFormCrwDaq.DeferredCommandCalculator:TExpressionEvaluator;
begin
 if Assigned(Self) then Result:=myCmdCalc else Result:=nil;
end;

procedure SetupIcon(const Param:LongString='');
var i,n,NumIcons:Integer; s:LongString; sil:LongString;
begin
 if Assigned(Application) then
 if FormCrwDaq.Ok then with FormCrwDaq do
 try
  sil:=SysGlossary.ReadIniParamDef(SysIniFile,SectSystem,'CrwDaqIconList','');
  NumIcons:=WordCount(sil,ScanSpaces); if (NumIcons<1) then Exit;
  n:=Max(0,SessionManager.SessionNb-1) mod NumIcons; s:='';
  if IsOption(Param,'-icon','--icon') and HasOptionValue(Param) then begin
   i:=StrToIntDef(GetOptionValue(Param),n);
   n:=Max(0,i) mod NumIcons;
  end;
  if InRange(n,0,NumIcons-1) then
  if SysGlossary.ReadIniPath(SysIniFile,SectSystem,'IconLibrary',HomeDir,s) then begin
   s:=UnifyFileAlias(AddPathDelim(s)+ExtractWord(n+1,sil,ScanSpaces));
   if FileExists(s) and FileIsReadable(s) then Icon.LoadFromFile(s);
  end;
  Application.Icon.Assign(Icon);
  TrayIconMain.Icon.Assign(Icon);
  if InRange(n,0,NumIcons-1) then ActionTrayRestore.ImageIndex:=234+n;
 except
  on E:Exception do BugReport(E,nil,'SetupIcon');
 end;
end;

procedure ProcessCmdLine(const aCmdLine:LongString);
var
 i,Ign  : Integer;
 aParam : LongString;
 Opts   : LongString;
 Icon   : LongString;
 function GetParamStr(P:PChar; var Param:LongString):PChar;
 var
  Len: Integer;
  Buffer: array[0..4095] of Char;
 begin
  while True do begin
   while (P[0] <> #0) and (P[0] <= ' ') do Inc(P);
   if (P[0] = QuoteMark) and (P[1] = QuoteMark) then Inc(P, 2) else Break;
  end;
  Len := 0;
  while (P[0] > ' ') and (Len < SizeOf(Buffer)) do
  if P[0] = QuoteMark then begin
   Inc(P);
   while (P[0] <> #0) and (P[0] <> QuoteMark) do begin
    Buffer[Len] := P[0];
    Inc(Len);
    Inc(P);
   end;
   if P[0] <> #0 then Inc(P);
  end else begin
   Buffer[Len] := P[0];
   Inc(Len);
   Inc(P);
  end;
  SetString(Param, Buffer, Len);
  Result := P;
 end;
 function TheParamStr(Index:Integer):LongString;
 var P:PChar;
 begin
  if (Index=0) then Result:=ProgName else begin
   P:=PChar(aCmdLine);
   while True do begin
    P:=GetParamStr(P,Result);
    if (Index=0) or (Result='') then Break;
    Dec(Index);
   end;
  end;
 end;
 procedure ProcessParameter(const Param:LongString);
 var Path:LongString;
 begin
  if (Ign>0) then begin
   Dec(Ign);
   Exit;
  end;
  if IsOption(Param) then begin
   // Process command line options …
   if IsOption(Param,'/?')
   or IsOption(Param,'-h')
   or IsOption(Param,'--help') then begin
    SystemCalculator.Eval('@async @help');
    SystemConsole.Activate;
   end;
   if IsOption(Param,'-number','--number')
   or IsOption(Param,'-session','--session') then begin
    Ign:=1;
    Exit;
   end;
   if IsOption(Param,'-icon','--icon') and HasOptionValue(Param) then Icon:=Param+' ';
   if IsOption(Param,'-r') then Opts:=Param+' ';
   if IsOption(Param,'-e') then Opts:=Param+' ';
   if IsOption(Param,'-d') then Opts:=Param+' ';
  end else begin
   // Process files with any specified path and extension …
   if IsNonEmptyStr(Param) then begin
    SendToMainConsole('@silent @async @open '+Icon+Opts+Param+EOL);
    Icon:='';
   end;
  end;
  Exit; // Skip old code!
  if Daq.Ok then
  if not Daq.Timer.IsStart then
  if IsSameText(ExtractFileExt(Param),'.cfg') then begin
   Path:=UnifyFileAlias(SmartFileRef(Param,'',ProgName));
   if not IsWildCard(Path) and FileExists(Path) then Daq.InitSession(Path);
  end;
 end;
begin
 try
  if FormCrwDaq.Ok then
  if FormCrwDaq.TimerTick55.Enabled then begin
   if (GetKeyState(VK_CONTROL) < 0) then Opts:='-r ' else
   if (GetKeyState(VK_MENU)    < 0) then Opts:='-e ' else
   if (GetKeyState(VK_SHIFT)   < 0) then Opts:='-d ' else Opts:='';
   Icon:=''; Ign:=0;
   for i:=1 to MaxInt do begin
    aParam:=Trim(TheParamStr(i));
    if Length(aParam)=0 then Break;
    if CanShowModal(nil,0)
    then ProcessParameter(aParam)
    else Echo(Format('Can''t execute "%s" just now.',[aParam]));
   end;
   if IsNonEmptyStr(Icon) then SendToMainConsole('@silent @async @open '+Icon+EOL);
  end;
 except
  on E:Exception do BugReport(E);
 end;
end;

procedure ProcessCmdLine1st;
begin
 CmdArgs.Delimiter:=' ';
 CmdArgs.QuoteChar:=QuoteMark;
 ProcessCmdLine(CmdArgs.DelimitedText); // System.CmdLine
end;

procedure AddCrwDaqSysPath(Index:LongInt; const TextLine:LongString; var Terminate:boolean; CustomData:Pointer);
var p:Integer; sn,sv,sd:LongString;
begin
 p:=ExtractNameValuePair(TextLine,sn,sv);
 if (p=0) or IsEmptyStr(sn) or IsEmptyStr(sv) then Exit;
 if (StrFetch(sn,1) in ['@','.']) then Exit; // Skip alias or extension!
 sd:=GetRealFilePathName(ExtractFilePath(UnifyFileAlias(SmartFileRef(sv,'',ProgName))));
 if DirExists(sd) then with TStringList(CustomData) do if (IndexOf(sd)<0) then Add(sd);
end;

function CRW_DAQ_SYS_PATH:LongString;
var
 SecList : TText;
 StrList : TStringList;
begin
 Result:='';
 try
  StrList:=Nil;
  SecList:=Nil;
  try
   StrList:=TStringList.Create;
   SecList:=ExtractListSection(SysIniFile,SectAtRun(1),efConfig);
   StrList.Add(GetRealFilePathName(HomeDir));
   SecList.ForEach(AddCrwDaqSysPath,StrList);
   Result:=StringReplace(StrList.Text,EOL,PathSep,[rfReplaceAll]);
  finally
   Kill(SecList);
   Kill(StrList);
  end;
 except
  on E:Exception do BugReport(E);
 end;
end;

function CRW_DAQ_SYS_LANG:LongString;
begin
 case Language of
  lng_RUSSIAN: Result:='RUSSIAN';
  else         Result:='ENGLISH';
 end;
 Result:=Format('%s,CP%d,CP%d,$%X,$%X,$%X,$%X',[Result,GetACP,GetOEMCP,
  GetSystemDefaultLangID,GetSystemDefaultLCID,GetUserDefaultLangId,GetUserDefaultLCID]);
end;

procedure Init_LanguageEnvir;
begin
 SetEnvVar('CRW_DAQ_SYS_LANG',CRW_DAQ_SYS_LANG);
end;

procedure Init_ProcessShutdownParameters;
{$IFDEF WINDOWS}var dwLevel,dwFlags:DWORD;{$ENDIF ~WINDOWS}
begin
 try
  {$IFDEF WINDOWS}
  dwFlags:=SHUTDOWN_NORETRY; dwLevel:=0;
  if ReadIniFileLongInt(SysIniFile,SectSystem,'ProcessShutdownLevel%d',LongInt(dwLevel))
  then SetProcessShutdownParameters(dwLevel,dwFlags);
  if GetProcessShutdownParameters(@dwLevel,@dwFlags)
  then DebugOut(stdfDebug,Format(EOL+'ProcessShutdownLevel = $%x'+EOL,[dwLevel]));
  ReadIniFileBoolean(SysIniFile,SectSystem,'ProcessShutdownForce%b',ProcessShutdownForce);
  {$ENDIF ~WINDOWS}
 except
  on E:Exception do BugReport(E,nil,'Init_ProcessShutdownParameters');
 end;
end;

function ReadRelease(n:Integer):LongString;
var p:TText; s:LongString;
begin
 Result:=''; s:='';
 if not SysGlossary.ReadIniPath(SysIniFile,SectSystem,'ReleaseFile',HomeDir,s)
 then s:=AddBackSlash(HomeDir)+'release.txt';
 Result:=UnifyFileAlias(s);
 if (Result<>'') and FileExists(Result) then begin
  p:=NewText;
  try
   p.ReadFile(Result);
   Result:=ExtractWord(1,p[0],ScanSpaces+['-',':','.']);
  finally
   Kill(p);
  end;
 end else Result:='Unknown';
 Result:=Pad(Copy(Result,1,n),n);
end;

procedure TFormCrwDaq.FormCreate(Sender: TObject);
var s:LongString; b:Boolean; i:Integer; d:LongInt; dw1,dw2:DWORD;
var fsz:packed record fs,gf,gl:LongInt; end; tp:TThreadPriority;
 procedure InitFSign;
 begin
  //FSign_PW:=Base32_Decode('ifis67m1pfoss4mqciyg4amjpoz8r7jckpozr55sftj8kh5upfoo',Base32_Alphabet_ID_zbase32);
  //FSign_IV:=Base32_Decode('ifysa3macih1h15iqjhsn45jpa',Base32_Alphabet_ID_zbase32);
  FSign_PW:='©kouriakine@mail.ru,Sarov,Russia';
  FSign_IV:='©Alexey.Kuryakin';
  FSign_EK:=ek_Blowfish;
  FSign_EM:=em_CBC;
 end;
begin
 InitFSign;
 b:=false; i:=0; d:=0; s:='';
 TheUACEchoProcedure:=StandardEchoProcedure;
 SysUtils.DefaultFormatSettings.DecimalSeparator:='.';
 {$IFDEF SKIP_DRAFT}
 Application.UpdateFormatSettings:=false;
 {$ENDIF ~SKIP_DRAFT}
 Application.OnException:=HandleApplicationExceptions;
 Application.OnActionUpdate:=ActionListUpdateAll;
 {$IFDEF SKIP_DRAFT}
 Application.OnMessage:=HookAllPostMessages;
 Application.HookMainWindow(HookAllSentMessages);
 {$ENDIF ~SKIP_DRAFT}
 /////////////////////////////////////////////////////////////////////////////////////////////
 myFileVerInfo:=GetFileVersionInfoAsText(ParamStr(0));
 myDefaultHint:='© 2001-2025 Alexey Kuryakin daqgroup@mail.ru';
 if ScanVarAlpha(svConfig,PChar(myFileVerInfo),'ProductVersion%a',s)<>nil
 then myDefaultHint:='ver '+s+' release '+ReadRelease(8)+' '+myDefaultHint;
 if ScanVarAlpha(svConfig,PChar(myFileVerInfo),'ProductName%a',s)<>nil
 then myDefaultHint:=s+' '+myDefaultHint else myDefaultHint:='CRW-DAQ '+myDefaultHint;
 SetEnv('CRW_DAQ_SYS_VERSION',myDefaultHint);
 myGreetingBox:='CRW-DAQ = data acquisition, process control and analysis system for Windows';
 myGreetingBox:=Pad('',Length(myGreetingBox),'*')+EOL
               +myDefaultHint+EOL+myGreetingBox+EOL
               +Pad('',Length(myGreetingBox),'*')+EOL;
 Echo(SysUtils.Trim(myGreetingBox));
 /////////////////////////////////////////////////////////////////////////////////////////////
 Echo(StdDateTimePrompt+RusEng('Начало сеанса CRWDAQ.','Start CRWDAQ session.'));
 SetupIcon;
 Caption:='crwdaq';
 Self.ShowHint:=true;
 Application.ShowHint:=true;
 Application.Icon.Assign(Icon);
 Application.OnHint:=DoShowHint;
 OnUpdateStatusLine:=CrwDaqUpdateStatusLine;
 TTask.LogNoteCommandPrefix:='@silent @log';
 {
 Служба Защиты Guard
 }
 Guard.Startup;
 if IsAdministrator then myNtRights:='Root' else myNtRights:='User';
 {
 Open TTY Port 0 for unix send2crwdaq income
 }
 SystemConsole.TtyListen(0);
 {
 Отложенная инициализация и завершение подсистем
 }
 InitSubSystems.Add(Init_System_Console);
 DoneSubSystems.Add(Done_System_Console);
 InitSubSystems.Add(Init_StartupGoHome);
 InitSubSystems.Add(Init_CpuFrequencyMHz);
 InitSubSystems.Add(Init_Sound_SubSystem);
 DoneSubSystems.Add(Done_Sound_SubSystem,true);
 InitSubSystems.Add(Init_Calculator_SubSystem);
 DoneSubSystems.Add(Done_Calculator_SubSystem,true);
 InitSubSystems.Add(Init_Thermocouple_SubSystem);
 DoneSubSystems.Add(Done_Thermocouple_SubSystem,true);
 InitSubSystems.Add(Init_IOPM_SubSystem);
 DoneSubSystems.Add(Done_IOPM_SubSystem,true);
 InitSubSystems.Add(Init_Rfa_SubSystem);
 DoneSubSystems.Add(Done_Rfa_SubSystem,true);
 InitSubSystems.Add(Init_ProcessShutdownParameters);
 InitSubSystems.Add(Init_EnvWindowClass);
 InitSubSystems.Add(Init_XdgMimeApps);
 InitSubSystems.Add(Init_CountryCodes);
 InitSubSystems.Add(Init_LanguageCodes);
 InitSubSystems.Add(Init_LanguageEnvir);
 InitSubSystems.Add(UriMan_InitServices);
 InitSubSystems.Add(Init_MistimingService);
 InitSubSystems.Add(Init_TextEditorsPalette);
 InitSubSystems.Add(Init_TextEditDialogsPalette);
 ConfirmExitList.Add(CrwDaqExitConfirmation,true);
 {
 Таймерные акции
 }
 SecondActions.Add(Timer_UpdateDateTime);
 SecondActions.Add(Timer_CheckConfigCache);
 SecondActions.Add(Timer_SayTime);
 SecondActions.Add(Timer_ShowRights);
 SecondActions.Add(Timer_DebugOutSetFifo);
 SecondActions.Add(Timer_PollChildProcesses);
 SecondActions.Add(Timer_CheckCpuUsage);
 SecondActions.Add(Initialize_SybSystems);
 SecondActions.Add(Timer_UpdateAllocMemSize);
 SecondActions.Add(Timer_UpdateActiveSdiChild);
 Tick55Actions.Add(Timer_UpdateCommands);
 Tick55Actions.Add(CheckPriorityClass);
 Tick55Actions.Add(Timer_HideIconicSdiChildren);
 //Tick55Actions.Add(Timer_Check_RTC_Monotonicity);
 {
 MaxTimerRecursionLevel
 }
 if ReadIniFileLongInt(SysIniFile,SectSystem,'MaxTimerRecursionLevel%d',d) then begin
  Tick55Actions.MaxLevel:=d;
  SecondActions.MaxLevel:=d;
  OnIdleActions.MaxLevel:=d;
  InitSubSystems.MaxLevel:=d;
  DoneSubSystems.MaxLevel:=d;
 end;
 {
 MaxAppProcMessagesLevel
 }
 if ReadIniFileLongInt(SysIniFile,'[System]','MaxAppProcMessagesLevel%d',d) then begin
  if (d>=0) then MaxApplicationProcessMessagesLevel:=d;
 end;
 if ReadIniFileBoolean(SysIniFile,SectSystem,'UseFixedPosSdiChildren%b',b) and b
 then SecondActions.Add(Timer_CheckFixedBoundsSdiChildren);
 {
 HideChildSdiFormMenu
 EnableSdiFormMenuMerge
 CursorActivateMainSdiForm
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem(1),'HideChildSdiFormMenu%b',b)
 then SdiMan.HideChildSdiFormMenu:=b;
 if ReadIniFileBoolean(SysIniFile,SectSystem(1),'EnableSdiFormMenuMerge%b',b)
 then SdiMan.EnableSdiFormMenuMerge:=b;
 if SdiMan.IsSdiMode then
 if ReadIniFileAlpha(SysIniFile,SectSystem,'CursorActivateMainSdiForm%a',s)
 then SdiMan.CursorActivateMainSdiForm:=StringToCursorDef(s,SdiMan.CursorActivateMainSdiForm);
 if SdiMan.IsSdiMode then BorderIcons:=BorderIcons-[biMaximize];
 {
 UsesFixFormatG
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem,'UsesFixFormatG%b',b)
 then UsesFixFormatG:=b;
 {
 Application.OnIdle actions
 }
 Application.AddOnIdleHandler(HandleApplicationOnIdle,true);
 {
 Инициализация системных переменных, необходимых на этом этапе.
 Остальное читается в процедуре MainStarter, когда форма уже создана.
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem,'UseReadIniLog%b',b) and b then begin
  fsz.fs:=0; fsz.gf:=0; fsz.gl:=0;
  if ReadIniFileRecord(SysIniFile,SectSystem,'ReadIniLogFifo%d;%d;%d',fsz) then begin
   if (fsz.fs>0) then ReadIniLogFifoSize:=Max(1024,Min(1024*1024*8,1024*fsz.fs));
   if (fsz.gf>0) then ReadIniLogFifoGrowFactor:=Max(1,Min(4,fsz.gf));
   if (fsz.gl>0) then ReadIniLogFifoGrowLimit:=Max(1024*1024,Min(1024*1024*128,1024*fsz.gl));
  end;
  OpenIniLogFile(SessionManager.VarTmpFile('readini.log'));
  DebugOutSetFifo(stdfReadIniLog,ReadIniLogFifoSize,ReadIniLogFifoGrowFactor,ReadIniLogFifoGrowLimit);
 end;
 if ReadIniFileAlpha(SysIniFile,SectSystem,'StartupSysLogLevel%a',s)
 then SysLog.TriggerLevel:=SysLog.StringToSeverity(s,SysLog.TriggerLevel);
 myVerboseLogon:=true;
 if ReadIniFileBoolean(SysIniFile,SectSystem,'VerboseLogon%b',b)
 then myVerboseLogon:=b;
 if ReadIniFileLongInt(SysIniFile,SectSystem,'TPolling.DefMsgPump%d',d)
 then TPolling.SetDefMsgPump(d<>0);
 if ReadIniFileLongInt(SysIniFile,SectSystem,'GetRealFilePathNameMode%d',d)
 then DefaultGetRealFilePathNameMode:=d;
 if ReadIniFileLongInt(SysIniFile,SectSystem,'ConfigCacheHoldingTime%d',d)
 then ConfigCacheHoldingTime:=Cardinal(d);
 if ReadIniFilePath(SysIniFile,SectSystem,'TempDir',HomeDir,s)
 then SetTempDir(s);
 if ReadIniFilePath(SysIniFile,SectSystem,'DebugFile',HomeDir,s) then begin
  fsz.fs:=0; fsz.gf:=0; fsz.gl:=0;
  if ReadIniFileRecord(SysIniFile,SectSystem,'DebugFifo%d;%d;%d',fsz) then begin
   if fsz.fs>0 then DebugOutFifoSize:=Max(1024,Min(1024*1024*8,1024*fsz.fs));
   if fsz.gf>0 then DebugOutFifoGrowFactor:=Max(1,Min(4,fsz.gf));
   if fsz.gl>0 then DebugOutFifoGrowLimit:=Max(1024*1024,Min(1024*1024*128,1024*fsz.gl));
  end;
  i:=DebugOutFifoPollPeriod; tp:=tpNormal;
  if ReadIniFilePolling(SysIniFile,SectSystem,'DebugOutPolling',i,tp) and (i>0)
  then DebugOutFifoPollPeriod:=Cardinal(i);
  DebugOutOpenFile(stdfDebug,s,DebugOutFifoSize,DebugOutFifoPollPeriod,true,true);
  DebugOutSetFifo(stdfDebug,DebugOutFifoSize,DebugOutFifoGrowFactor,DebugOutFifoGrowLimit);
 end;
 if ReadIniFileBoolean(SysIniFile,SectSystem,'UseKernelGetTickCount64%b',b)
 then UseKernelGetTickCount64:=b;
 if ReadIniFileBoolean(SysIniFile,SectSystem,'Check_RTC_Monotonicity%b',b)
 then Allow_Check_RTC_Monotonicity:=b;
 DebugOut(stdfDebug,StdDateTimePrompt+'Time functions report:');
 DebugOut(stdfDebug,Format('Check_RTC_Monotonicity  = %d',[Ord(Allow_Check_RTC_Monotonicity)]));
 DebugOut(stdfDebug,Format('UseKernelGetTickCount64 = %d',[Ord(UseKernelGetTickCount64)]));
 DebugOut(stdfDebug,Format('HasKernelGetTickCount64 = %d',[Ord(HasKernelGetTickCount64)]));
 DebugOut(stdfDebug,Format('IsKernelGetTickCount64  = %d',[Ord(IsKernelGetTickCount64)]));
 DebugOut(stdfDebug,Format('GetTickCount64_Standard = %d',[GetTickCount64_Standard]));
 DebugOut(stdfDebug,Format('GetTickCount64_Relevant = %d',[GetTickCount64_Relevant]));
 DebugOut(stdfDebug,Format('GetTickCount64_Fallback = %d',[GetTickCount64_Fallback]));
 DebugOut(stdfDebug,Format('IntMSecNow              = %d',[IntMSecNow]));
 DebugOut(stdfDebug,Format('MSecNow                 = %g',[MSecNow]));
 DebugOut(stdfDebug,EOL);
 if IsUnix then begin
  if ReadIniFileBoolean(SysIniFile,SectSystem(1),'prefer_proc_pid_stat%b',b)
  then glops_prefer_proc_pid_stat:=b;
 end;
 if ReadIniFileLongInt(SysIniFile,SectSystem,'ConfigCacheLimit%d',d)
 then ConfigCacheLimit:=abs(d)*1024;
 if ReadIniFilePath(SysIniFile,SectSystem,'HelpFile',HomeDir,s) and FileExists(s)
 then HelpFile:=s;
 Application.HelpFile:=HelpFile;
 if ReadIniFileAlpha(SysIniFile,SectSystem,'Language%a',s)
 then begin
  if IsSameText(s,'RUSSIAN') then Language:=lng_RUSSIAN else
  if IsSameText(s,'ENGLISH') then Language:=lng_ENGLISH else
  Language:=lng_ENGLISH;
 end;
 if ReadIniFileBoolean(SysIniFile,SectSystem,'FullScreenMode%b',b) and b then begin
  Left:=0;
  Top:=0;
  Width:=Screen.Width;
  Height:=Screen.Height;
  BorderIcons:=[];
  BorderStyle:=bsSingle;
  Tick55Actions.Add(Timer_CheckLocation);
 end else
 if ReadIniFileAlpha(SysIniFile,SectSystem,'StartWindowState%a',s) then begin
  if SameText(s,'NORMAL')    then WindowState:=wsNormal;
  if SameText(s,'MAXIMIZED') then WindowState:=wsMaximized;
  if SameText(s,'MINIMIZED') then WindowState:=wsMinimized;
 end;
 if ReadIniFileLongInt(SysIniFile,SectSystem,'CheckFixedBoundsMode%d',d) and (d<>0)
 then TFormCrwDaqSysChild.CheckFixedBoundsMode:=d;
 if ReadIniFileLongInt(SysIniFile,SectSystem,'FixedBoundsTolerancePX%d',d)
 then TFormCrwDaqSysChild.FixedBoundsTolerance.Left:=d;
 if ReadIniFileLongInt(SysIniFile,SectSystem,'FixedBoundsTolerancePY%d',d)
 then TFormCrwDaqSysChild.FixedBoundsTolerance.Top:=d;
 if ReadIniFileLongInt(SysIniFile,SectSystem,'FixedBoundsToleranceSX%d',d)
 then TFormCrwDaqSysChild.FixedBoundsTolerance.Width:=d;
 if ReadIniFileLongInt(SysIniFile,SectSystem,'FixedBoundsToleranceSY%d',d)
 then TFormCrwDaqSysChild.FixedBoundsTolerance.Height:=d;
 myDesktopLogoFile:='';
 if ReadIniFilePath(SysIniFile,SectSystem,'DesktopLogoFile',HomeDir,s) and FileExists(s)
 then DesktopLogoFile:=s;
 if ReadIniFileBoolean(SysIniFile,SectSystem,'SolidCrwDaqLogo%b',b)
 then SolidCrwDaqLogo:=b;
 if ReadIniFileBoolean(SysIniFile,SectSystem,'SafeToolBarSensors%b',b)
 then Form_CircuitWindow.SafeToolBarSensors:=b;
 CalibDialogMode:=ReadCalibDialogMode(SysIniFile,SectDaqSys);
 {UnixRoot}
 DebugOut(stdfDebug,'UnixRoot='+GetEnv('UnixRoot'));
 if not ReadIniFileBoolean(SysIniFile,SectSystem,'AlwaysUseLocalUnixRoot%b',b) then b:=false;
 if b or IsEmptyStr(GetEnv('UnixRoot')) or not DirExists(GetEnv('UnixRoot')) then
 if ReadIniFilePath(SysIniFile,SectSystem,'UnixRoot',HomeDir,s) then begin
  s:=Trim(s); if Length(s)>0 then s:=GetRealFilePathName(FExpand(DefaultPath(s,HomeDir)));
  s:=Trim(s); if Length(s)>0 then if not DirExists(s) then s:='';
  s:=Trim(s); if Length(s)>0 then SetEnv('UnixRoot',s);
  DebugOut(stdfDebug,'UnixRoot='+GetEnv('UnixRoot'));
 end;
 {regexp_default_options}
 if ReadIniFileString(SysIniFile,SectSystem,'regexp_default_options%s',s,efConfigNC) then begin
  DebugOut(stdfDebug,'Initial regexp_default_options = '+regexp_default_options);
  DebugOut(stdfDebug,'Reading regexp_default_options = '+s);
  TRegExpMaster.SetDefaultOptions(s);
  regexp_default_options:=TRegExpMaster.GetDefaultOptions;
  DebugOut(stdfDebug,'Applied regexp_default_options = '+regexp_default_options);
 end;
 {EvaluatorHasher}
 if ReadIniFileAlpha(SysIniFile,SectSystem,'EvaluatorHasher%a',s) then begin
  if not Str2Int(s,d) then d:=FindIndexOfHasher(s);
  ee_DefaultHasher:=GetHasherByIndex(d);
 end;
 {THashListHasher}
 if ReadIniFileAlpha(SysIniFile,SectSystem,'THashListHasher%a',s) then begin
  if not Str2Int(s,d) then d:=FindIndexOfHasher(s);
  HashList_DefaultHasher:=GetHasherByIndex(d);
  ReinitTags;
 end;
 {ApplicationHintPause}
 if ReadIniFileInteger(SysIniFile,SectSystem,'ApplicationHintPause%i',i) then
 if (i>=0) then Application.HintPause:=i;
 {ApplicationHintHidePause}
 if ReadIniFileInteger(SysIniFile,SectSystem,'ApplicationHintHidePause%i',i) then
 if (i>=0) then Application.HintHidePause:=i; 
 {MenuRightSpaceWidth}
 if ReadIniFileInteger(SysIniFile,SectSystem,'MenuRightSpaceWidth%i',i) then
 if (i in [0..20]) then MenuRightSpaceWidth:=i;
 {SoftDev.HandleDpcOnIdle}
 if ReadIniFileBoolean(SysIniFile,SectSystem,'SoftDev.HandleDpcOnIdle%b',b)
 then TSoftwareDevice.HandleDpcOnIdle:=b;
 {EnableSdiFormCodePills}
 if ReadIniFileBoolean(SysIniFile,SectSystem,'EnableSdiFormCodePills%b',b)
 then TFormCrwDaqSysChild.CodePillsEnabled:=b;
 {ConsoleAutoFocusInput}
 if ReadIniFileBoolean(SysIniFile,SectSystem,'ConsoleAutoFocusInput%b',b)
 then TFormConsoleWindow.ConsoleAutoFocusInput:=b;
 {ConsoleAutoEnableInput}
 if ReadIniFileBoolean(SysIniFile,SectSystem,'ConsoleAutoEnableInput%b',b)
 then TFormConsoleWindow.ConsoleAutoEnableInput:=b;
 {WM_GRAVITY_DEFAULT}
 if ReadIniFileInteger(SysIniFile,SectSystem(1),'WM_GRAVITY_DEFAULT%i',i) then
 if (i in [GDK_GRAVITY_MIN..GDK_GRAVITY_MAX]) then wmctrl.WM_GRAVITY_DEFAULT:=i;
 {UseWindowsPriorityClass}
 if not IsWindows then
 if ReadIniFileBoolean(SysIniFile,SectSystem(1),'UseWindowsPriorityClass%b',b)
 then TPolling.UseWindowsPriorityClass:=b;
 {TCircuitSensor.WorkerBitmapMode}
 if ReadIniFileInteger(SysIniFile,SectSystem,'TCircuitSensor.WorkerBitmapMode%i',i)
 then TCircuitSensor.WorkerBitmapMode:=i;
 {
 Макс. размер журнальных файлов
 }
 if ReadIniFileInteger(SysIniFile,SectSystem,'DebugOutFileLimit%i',i) and (i>0)
 then DebugOutFileLimit:=i shl 20;
 DebugOut(stdfDebug,Format('DebugOutFileLimit=%d',[DebugOutFileLimit shr 20]));
 if ReadIniFileInteger(SysIniFile,SectSystem,'GuardLogFileLimit%i',i) and (i>0)
 then GuardLogFileLimit:=i shl 20;
 DebugOut(stdfDebug,Format('GuardLogFileLimit=%d',[GuardLogFileLimit shr 20]));
 {
 AlwaysUseRunCommandEx
 RunCommandPipeSizeKb
 RunCommandSleepTime
 RunCommandTimeOut
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem,'AlwaysUseRunCommandEx%b',b)
 then if b then rcm_Selected:=rcm_Extended;
 if ReadIniFileInteger(SysIniFile,SectSystem,'RunCommandPipeSizeKb%i',i)
 then if (i>=0) then RunCommandPipeSizeDef:=i*KiloByte;
 if ReadIniFileInteger(SysIniFile,SectSystem,'RunCommandSleepTime%i',i)
 then if (i>=0) then RunCommandSleepTimeDef:=i;
 if ReadIniFileInteger(SysIniFile,SectSystem,'RunCommandTimeOut%i',i)
 then if (i>=0) then RunCommandTimeOutDef:=i;
 if ReadIniFileAlpha(SysIniFile,SectSystem,'RunCommandSwo%a',s)
 then RunCommandSwoDef:=StringToSwo(s,RunCommandSwoDef);
 {
 Отложенная инициализация DAQ-подсистемы.
 }
 if SubSystemTurnOn(SectDaqSys) then begin
  InitSubSystems.Add(Init_Daq_SubSystem);
  DoneSubSystems.Add(Done_Daq_SubSystem);
  ConfirmExitList.Add(ConfirmExit_Daq_SubSystem,true);
  Tick55Actions.Add(Timer_Daq_SubSystem);
  SecondActions.Add(Timer_DaqClock);
 end else begin
  ActionDaq.Visible:=false;
  ToolButtonDaqSeparator.Hide;
  ToolButtonDaqClock.Visible:=false;
 end;
 {
 Отложенная печать системной информации.
 }
 InitSubSystems.Add(EchoBriefSystemInfo);
 {
 Установка приоритета процесса
 }
 dw1:=NORMAL_PRIORITY_CLASS; dw2:=5000;
 if ReadIniFilePriorityClass(SysIniFile,SectSystem,'ProcessPriorityClass',dw1,dw2)
 then ForcePriorityClass(dw1,dw2);
 {
 Отложенная инициализация SystemTray
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem,'UsesSysTray%b',b) and b
 then SendToMainConsole('@silent @trayicon -visible 1'+EOL);
 if ReadIniFileBoolean(SysIniFile,SectSystem,'TrayIconPopupOnClick%b',b)
 then TrayIconPopupOnClick:=b;
 {
 Раздвигать окна если появилось модальное
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem,'SmartWindowLocation%b',b) and b
 then SecondActions.Add(Timer_SmartWindowLocation);
 {
 Делать модальные окна TopMost
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem,'MakeModalTopMost%b',b) and b
 then SecondActions.Add(Timer_MakeModalTopMost);
 {
 Сервис системного времени
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem,'MistimingService%b',b) and b
 then SecondActions.Add(CheckMistiming);
 {
 Command line parameters
 }
 DebugOut(stdfDebug,'');
 DebugOut(stdfDebug,'Command line:');
 DebugOut(stdfDebug,'*************');
 DebugOut(stdfDebug,GetCommandLine);
 for i:=0 to ParamCount do
 DebugOut(stdfDebug,Format('ParamStr(%d) = "%s"',[i,ParamStr(i)]));
 {
 Check patch code for Delphi 5.0 detected by VER130 definition, see
 http://docwiki.embarcadero.com/RADStudio/Seattle/en/Compiler_Versions
 }
 {$IFDEF VER130}
 DebugOut(stdfDebug,'');
 if PatchBug_cwChopCode<>$1F3F then begin
  DebugOut(stdfDebug,Format('PatchBug_cwChopCode=$%.4x - FAIL',[PatchBug_cwChopCode]));
  Echo(Format('WARNING: invalid PatchBug_cwChopCode=$%.4x',[PatchBug_cwChopCode]));
 end else begin
  DebugOut(stdfDebug,Format('PatchBug_cwChopCode=$%.4x - OK',[PatchBug_cwChopCode]));
 end;
 {$ENDIF}
 {
 UAC settings
 }
 {$IFDEF WINDOWS}
 DebugOut(stdfDebug,'');
 DebugOutText(stdfDebug,GetUACStatusAsText);
 {$ENDIF ~WINDOWS}
 DebugOut(stdfDebug,'');
 DebugOut(stdfDebug,'User: '+GetListOfUserMembership(',',true));
 {$IFDEF WINDOWS}
 DebugOut(stdfDebug,'Well known RID table:');
 DebugOutText(stdfDebug,GetListOfWellKnownRids(2));
 {$ENDIF ~WINDOWS}
 DebugOut(stdfDebug,'');
 {
 Инициализация системных шрифтов.
 }
 TheSystemFontsInit;
 {
 Системный фонт, читается, пока форма еще не видна на экране.
 }
 DebugOut(stdfDebug,'');
 DebugOut(stdfDebug,'Init system font.');
 DebugOut(stdfDebug,'*****************');
 ReadIniFileFont(StandardFont,SysIniFile,'[StandardFont]');
 SetStandardFont(Self);
 DebugOut(stdfDebug,Trim(GetFontAsText(Font)));
 {
 Фонт редактора.
 }
 DebugOut(stdfDebug,'');
 DebugOut(stdfDebug,'Init editor font.');
 DebugOut(stdfDebug,'*****************');
 ReadIniFileFont(DefaultEditorFont,SysIniFile,'[DefaultEditorFont]');
 DebugOut(stdfDebug,Trim(GetFontAsText(DefaultEditorFont)));
 {
 Фонт мнемосхем.
 }
 DebugOut(stdfDebug,'');
 DebugOut(stdfDebug,'Init Circuit font.');
 DebugOut(stdfDebug,'******************');
 ReadIniFileFont(DefaultCircuitFont,SysIniFile,'[DefaultCircuitFont]');
 DebugOut(stdfDebug,Trim(GetFontAsText(DefaultCircuitFont)));
 {
 Фонт окон кривых.
 }
 DebugOut(stdfDebug,'');
 DebugOut(stdfDebug,'Init curve window fonts.');
 DebugOut(stdfDebug,'************************');
 ReadIniFileFont(DefaultTimeAxisFont,SysIniFile,'[DefaultTimeAxisFont]');
 DebugOut(stdfDebug,Trim(GetFontAsText(DefaultTimeAxisFont)));
 {
 DefaultSansFont фонт.
 }
 DebugOut(stdfDebug,'');
 DebugOut(stdfDebug,'Init DefaultSansFont.');
 DebugOut(stdfDebug,'*********************');
 ReadIniFileFont(DefaultSansFont,SysIniFile,'[DefaultSansFont]');
 DebugOut(stdfDebug,Trim(GetFontAsText(DefaultSansFont)));
 {
 DefaultSansNarrowFont фонт.
 }
 DebugOut(stdfDebug,'');
 DebugOut(stdfDebug,'Init DefaultSansNarrowFont.');
 DebugOut(stdfDebug,'***************************');
 ReadIniFileFont(DefaultSansNarrowFont,SysIniFile,'[DefaultSansNarrowFont]');
 DebugOut(stdfDebug,Trim(GetFontAsText(DefaultSansNarrowFont)));
 {
 Инициализация контроля раскладки клавиатуры и таблица языковой поддержки
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem,'KeyBoardLayoutControl%b',b)
 then ActionToolsKeyBoardLayout.Checked:=b;
 {$IFDEF SKIP_DRAFT}
 DebugOut(stdfDebug,'');
 DebugOut(stdfDebug,'Language support.');
 DebugOut(stdfDebug,'*****************');
 with Languages do for i:=0 to Count-1 do DebugOut(stdfDebug,Format('%s, %s, %s',[Id[i],Ext[i],Name[i]]));
 {$ENDIF ~SKIP_DRAFT}
 {
 Ограничение на число модальных форм
 }
 if ReadIniFileLongInt(SysIniFile,SectSystem,'MaxNumberOfModalForms%d',d)
 then DefaultCanShowModalLimit:=Cardinal(d);
 {
 TextEditDialogMode
 }
 if ReadIniFileLongInt(SysIniFile,SectSystem,'TextEditDialogMode%d',d)
 then TFormTextEditDialog.DefaultEditorMode:=d;
 {
 UsesPhraseIterator
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem,'UsesPhraseIterator%b',b)
 then UsesPhraseIterator:=b;
 {
 Надо ли скрывать SDI окна
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem(1),'HideIconicSdiChildren%b',b)
 then ActionWindowsToggleHideIconicSdiChildren.Checked:=b;
 {
 }
 if ReadIniFileInteger(SysIniFile,SectSystem,'SleepAfterFormBornKill%i',i)
 then TMasterForm.SleepAfterBornKill:=Max(0,i);
 {
 Служба модальных окон AwakeModalWindows
 }
 if ReadIniFileLongInt(SysIniFile,SectSystem(1),'AwakeModalWindowsPeriod%d',d)
 then if (d>0) then AppModal.Interval:=d;
 if ReadIniFileInteger(SysIniFile,SectSystem(1),'AwakeModalWindowsFocus%i',i)
 then begin AppModal.WantFocus:=HasFlags(i,1); AppModal.GlobFocus:=HasFlags(i,2); end;
 if ReadIniFileInteger(SysIniFile,SectSystem(1),'AwakeModalWindowsMode%i',i)
 then begin AppModal.UsesPolling:=(i>1); AppModal.Started:=(i>0); end;
 ActionWindowsToggleAwakeModal.Checked:=AppModal.Started;
 {
 Использовать системные окна MessageBox для диалогов
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem,'UseSystemMessageBox%b',b)
 then UseSystemMessageBox:=b;
 {
 Использовать Edit('@set …')
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem,'UseEditSettings%b',b)
 then UseEditSettings:=b;
 {
 Использовать монитор для отслеживания изменения файлов в текстовых редакторах
 Timer_MonitorTextEditor
 }
 if ReadIniFileBoolean(SysIniFile,SectSystem,'Timer_MonitorTextEditor%b',b)
 then SecondActions.Add(Timer_MonitorTextEditor);
 {
 Read default DownSampling parameters
 }
 if ReadIniFileDownSampling(SysIniFile,SectSystem,'DefDownSamplingParams',DefDownSamplingParams) then begin
  DebugOut(stdfDebug,'');
  with DefDownSamplingParams do
  DebugOut(stdfDebug,Format('DefDownSamplingParams = %d, %d, %d, %g',[Method,Mode,AbsLen,PerPix]));
 end;
 {
 Чтение параметров Uart
 }
 uart.ReadConfig(SysIniFile,SectSystem);
 {
 Самотестирование ADAM
 }
 Adam_Test;
 {
 Сообщение о начале сеанса в файле учета ресурсов
 }
 ResourceLeakageLogMessage(Format('Enter %s at %s',[ExtractFileNameExt(ProgName),StdDateTimeStr(msecnow)]));
 {
 Инициализация сторожевого таймера
 }
 InitWatchDogTimer;
 {
 Инициализация палитры окон
 }
 ReadCurveWindowsPalette(SysIniFile);
 ReadSpectrWindowsPalette(SysIniFile);
 ReadSurfaceWindowsPalette(SysIniFile);
 {
 Подготовка SDI меню
 }
 PrepareCrwDaqSdiMenu(Self);
 {
 Инициализация меню
 }
 UpdateMenu(MenuFile,
            RusEng('Файл','File')+MenuRightSpace,
            RusEng('Меню операций с файлами.','File operations.'),
            0);
 UpdateMenu(MenuFileNew,
            RusEng('Создать','New'),
            RusEng('Меню создания нового окна','Menu to create new window'),
            0);
 UpdateMenu(MenuFileNewTextEditor,
            RusEng('Текстовое окно','Text editor'),
            RusEng('Создать новое окно с текстом','Create text editor'),
            ShortCut(Word('N'),[ssCtrl]));
 UpdateMenu(MenuFileNewCurveWindow,
            RusEng('Окно с кривыми','Curve window'),
            RusEng('Создать новое окно с кривыми','Create window with curves'),
            ShortCut(Word('N'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuFileNewDataAnalysisPlugin,
            RusEng('Утилиту анализа данных','Data analysis plugin'),
            RusEng('Создать новую утилиту анализа данных','Create new data analysis plugin'),
            ShortCut(Word('N'),[ssCtrl,ssShift]));
 UpdateMenu(MenuFileNewDataAcquisitionPlugin,
            RusEng('Утилиту сбора данных','Data acquisition plugin'),
            RusEng('Создать новую утилиту сбора данных','Create new data acquisition plugin'),
            ShortCut(Word('N'),[ssShift,ssAlt]));
 UpdateMenu(MenuFileNewDaqCreator,
            RusEng('Систему сбора данных с нуля - DAQ Creator','Data Acquisition System - DAQ Creator'),
            RusEng('Утилита для создания новой DAQ системы с нуля','Utility to create new DAQ system from scratch'),
            0);
 UpdateMenu(MenuFileNewDaqConstructor,
            RusEng('Элементы DAQ Системы - DAQ Constructor','Elements of DAQ System - DAQ Constructor'),
            RusEng('Утилита для конструирования элементов DAQ системы','Utility to construct elements of DAQ system'),
            0);
 UpdateMenu(MenuFileNewProjectFromSample,
            RusEng('Новый Проект по Образцу','New Project from Sample'),
            RusEng('Создать новый Проект по Образцу.','Create new Project from Sample.'),
            0);
 UpdateMenu(MenuFileOpen,
            RusEng('Открыть …','Open …'),
            RusEng('Открыть файл …','Open file …'),
            ShortCut(Word('O'),[ssCtrl]));
 UpdateMenu(MenuFileSave,
            RusEng('Сохранить','Save'),
            RusEng('Сохранить в файл','Save to file'),
            ShortCut(VK_F2,[]));
 UpdateMenu(MenuFileSaveAs,
            RusEng('Сохранить как …','Save as …'),
            RusEng('Сохранить в новый файл','Save to new file'),
            ShortCut(Word('S'),[ssCtrl,ssShift]));
 UpdateMenu(MenuFilePrint,
            RusEng('Печатать','Print'),
            RusEng('Напечатать содержимое окна','Print window'),
            ShortCut(Word('P'),[ssCtrl]));
 UpdateMenu(MenuFilePrinterSetup,
            RusEng('Уставки печати','Printer setup'),
            RusEng('Выбрать параметры принтера','Setup printer options'),
            ShortCut(Word('P'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuFileExit,
            RusEng('Выход','Exit'),
            RusEng('Выход из программы.','Exit from program.'),
            ShortCut(Word('X'), [ssAlt]));
 UpdateMenu(MenuDaq,
            RusEng('DAQ','DAQ')+MenuRightSpace,
            RusEng('Вызов контрольной панели DAQ-системы.','Call DAQ-system control panel.'),
            ShortCut(VK_F9,[]));
 UpdateMenu(MenuTools,
            RusEng('Инструменты','Tools')+MenuRightSpace,
            RusEng('Меню для инструментов.','Miscellaneous tools.'),
            0);
 UpdateMenu(MenuToolsCalculator,
            RusEng('Калькулятор','Calculator'),
            RusEng('Формульный калькулятор.','Expression evaluator.'),
            ShortCut(VK_F10, [ssCtrl]));
 UpdateMenu(MenuToolsPlot2D,
            RusEng('График 2D','2D plot'),
            RusEng('Построить график функции 2D.','2D function plot.'),
            ShortCut(VK_F10, [ssAlt]));
 UpdateMenu(MenuToolsPlot3D,
            RusEng('График 3D','3D plot'),
            RusEng('Построить график функции 3D.','3D function surface plot.'),
            ShortCut(VK_F10, [ssShift]));
 UpdateMenu(MenuToolsUartTerminal,
            RusEng('Терминал UART','UART terminal'),
            RusEng('Терминал COM-порта.','COM-port terminal.'),
            0);
 UpdateMenu(MenuToolsPipeTerm,
            RusEng('Терминал PIPE','PIPE terminal'),
            RusEng('Терминал каналов (PIPE,COM,TCP).','Pipeline terminal (PIPE,COM,TCP).'),
            0);
 UpdateMenu(MenuToolsWmqueryGui,
            RusEng('Утилита WmQueryGui','Utility WmQueryGui'),
            RusEng('Утилита WmQueryGui управляет Окнами Рабочего Стола.','Utility WmQueryGui to control Desktop Windows.'),
            0);
 UpdateMenu(MenuToolsRegExpCalculator,
            RusEng('RegExp Калькулятор','RegExp Calculator'),
            RusEng('Вычислитель Регулярных Выражений.','Regular Expressions Calculator.'),
            0);
 UpdateMenu(MenuToolsDatabaseBrowser,
            RusEng('Браузер Баз Данных','Database Browser'),
            RusEng('Браузер для просмотра Баз Данных.','Browser to view Database(s).'),
            0);
 UpdateMenu(MenuToolsLogViewer,
            RusEng('Журнал Событий Системы','System Log Viewer'),
            RusEng('Открыть Журнал Событий Системы.','Open System Log Viewer.'),
            0);
 UpdateMenu(MenuToolsCalibDialog,
            RusEng('Редактор калибровок','Calibration editor'),
            RusEng('Открыть окно редактора калибровок.','Open calibration editor.'),
            0);
 UpdateMenu(MenuToolsRecodeCodePage,
            RusEng('Перекодировка файлов','Recode codepage'),
            RusEng('Перекодировка файлов из одной кодовой страницы в другую.','Recode files from one codepage to another.'),
            0);
 UpdateMenu(MenuToolsRfaMendeleevTable,
            RusEng('База данных РФА','RFA database'),
            RusEng('Просмотр базы данных РФА.','Open RFA database.'),
            0);
 UpdateMenu(MenuToolsVoicePreset,
            RusEng('Контроль звука','Sound control'),
            RusEng('Параметры звуковой подсистемы.','Sound subsystem preset dialog.'),
            ShortCut(Word('V'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuToolsKeyBoardLayout,
            'RUS/ENG = Ctrl+Shift',
            RusEng('Переключение языка по Ctrl+Shift.','KeyBoard layout switch on Ctrl+Shift.'),
            0);
 UpdateMenu(MenuToolsDimGui,
            RusEng('Центр Управления DIM','DIM Control Center'),
            RusEng('Вызов диалога Центр Управления DIM.','Call DIM Control Center dialog.'),
            0);
 UpdateMenu(MenuToolsDimTree,
            RusEng('Утилита DIM Tree','DIM Tree utility'),
            RusEng('Вызов утилиты DIM Tree.','Call DIM Tree utility.'),
            0);
 UpdateMenu(MenuToolsOpcuaCpl,
            RusEng('Центр Управления OPCUA','OPCUA Control Center'),
            RusEng('Вызов диалога Центр Управления OPCUA.','Call OPCUA Control Center dialog.'),
            0);
 UpdateMenu(MenuToolsGnuPlot,
            RusEng('Утилита GNUPLOT','GNUPLOT utility'),
            RusEng('Вызов утилиты GNUPLOT для рисования научной графики.','Call GNUPLOT utility for science drawing.'),
            0);
 UpdateMenu(MenuToolsMousePos,
            RusEng('Утилита MousePos','MousePos utility'),
            RusEng('Вызов утилиты MousePos для отображения координат мыши.','Call MousePos utility for mouse position view.'),
            0);
 UpdateMenu(MenuToolsRoot,
            RusEng('Утилита ROOT (CERN)','ROOT (CERN) utility'),
            RusEng('Вызов утилиты ROOT (CERN).','Call ROOT (CERN) utility.'),
            0);
 UpdateMenu(MenuToolsExplorer,
            RusEng('Обозреватель','Explorer'),
            RusEng('Вызов Обозревателя Windows.','Call Windows Explorer.'),
            0);
 UpdateMenu(MenuToolsFileManager,
            RusEng('Файловый Менеджер','File Manager'),
            RusEng('Вызов Файлового Менеджера.','Call File Manager.'),
            0);
 UpdateMenu(MenuToolsTerminal,
            RusEng('Терминал CMD','Terminal CMD'),
            RusEng('Вызов консоли Tерминал CMD.','Call console Terminal CMD.'),
            0);
 UpdateMenu(MenuToolsTaskmgr,
            RusEng('Диспетчер задач','Task Manager'),
            RusEng('Вызов системного диспетчера задач.','Call system Task Manager.'),
            0);
 UpdateMenu(MenuToolsConsoleUtilities,
            RusEng('Консольные утилиты …','Console utilities …'),
            RusEng('Список полезных консольных утилит.','List of useful console utilities.'),
            0);
 UpdateMenu(MenuToolsConsoleUtilitiesMode,
            RusEng('Разрешить внешние утилиты.','Enable external utilities.'),
            RusEng('Разрешить\запретить запуск внешних консольных утилит.','Enable\forbid to run external console utilities.'),
            0);
 UpdateMenu(MenuToolsCustomCommands,
            RusEng('Пользовательские Команды …','Custom Commands …'),
            RusEng('Меню Пользовательских Команд.','Menu of Custom Commands.'),
            0);
 UpdateMenu(MenuToolsCustomCommand0,
            RusEng('Пользовательская Команда 0','Custom Command 0'),
            RusEng('Выполнить Пользовательскую Команду 0.','Run Custom Command 0.'),
            ShortCut(Word('0'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuToolsCustomCommand1,
            RusEng('Пользовательская Команда 1','Custom Command 1'),
            RusEng('Выполнить Пользовательскую Команду 1.','Run Custom Command 1.'),
            ShortCut(Word('1'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuToolsCustomCommand2,
            RusEng('Пользовательская Команда 2','Custom Command 2'),
            RusEng('Выполнить Пользовательскую Команду 2.','Run Custom Command 2.'),
            ShortCut(Word('2'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuToolsCustomCommand3,
            RusEng('Пользовательская Команда 3','Custom Command 3'),
            RusEng('Выполнить Пользовательскую Команду 3.','Run Custom Command 3.'),
            ShortCut(Word('3'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuToolsCustomCommand4,
            RusEng('Пользовательская Команда 4','Custom Command 4'),
            RusEng('Выполнить Пользовательскую Команду 4.','Run Custom Command 4.'),
            ShortCut(Word('4'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuToolsCustomCommand5,
            RusEng('Пользовательская Команда 5','Custom Command 5'),
            RusEng('Выполнить Пользовательскую Команду 5.','Run Custom Command 5.'),
            ShortCut(Word('5'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuToolsCustomCommand6,
            RusEng('Пользовательская Команда 6','Custom Command 6'),
            RusEng('Выполнить Пользовательскую Команду 6.','Run Custom Command 6.'),
            ShortCut(Word('6'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuToolsCustomCommand7,
            RusEng('Пользовательская Команда 7','Custom Command 7'),
            RusEng('Выполнить Пользовательскую Команду 7.','Run Custom Command 7.'),
            ShortCut(Word('7'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuToolsCustomCommand8,
            RusEng('Пользовательская Команда 8','Custom Command 8'),
            RusEng('Выполнить Пользовательскую Команду 8.','Run Custom Command 8.'),
            ShortCut(Word('8'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuToolsCustomCommand9,
            RusEng('Пользовательская Команда 9','Custom Command 9'),
            RusEng('Выполнить Пользовательскую Команду 9.','Run Custom Command 9.'),
            ShortCut(Word('9'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuToolsCustomCommandEditor,
            RusEng('Редактор Пользовательских Команд','Custom Command Editor'),
            RusEng('Редактор Пользовательских Команд.','Editor of Custom Commands.'),
            0);
 UpdateMenu(MenuWindows,
            RusEng('Окна','Windows')+MenuRightSpace,
            RusEng('Операции с окнами.','Window operations.'),
            0);
 UpdateMenu(MenuWindowsSelect,
            RusEng('Выбор окна …','Select …'),
            RusEng('Выбрать и показать окно.','Select and show window.'),
            ShortCut(VK_F6, []));
 UpdateMenu(MenuWindowsHome,
            RusEng('Вернуть ДОМОЙ …','Bring back HOME …'),
            RusEng('Вернуть Окна ДОМОЙ (в исходное место).','Bring Windows back HOME (to default place).'),
            ShortCut(VK_F6, [ssCtrl]));
 UpdateMenu(MenuWindowsPrev,
            RusEng('Предыдущее','Previous'),
            RusEng('Показать предыдущее окно.','Select previous window.'),
            ShortCut(VK_F6, [ssAlt]));
 UpdateMenu(MenuWindowsNext,
            RusEng('Следующее','Next'),
            RusEng('Показать следующее окно.','Select next window.'),
            ShortCut(VK_F6, [ssShift]));
 UpdateMenu(MenuWindowsTile,
            RusEng('Черепица','Tile'),
            RusEng('Расположить окна черепицей.','Tile windows on desktop.'),
            0);
 UpdateMenu(MenuWindowsCascade,
            RusEng('Каскад','Cascade'),
            RusEng('Расположить окна каскадом.','Cascade windows on desktop.'),
            0);
 UpdateMenu(MenuWindowsMinimizeAll,
            RusEng('Свернуть все','Minimize all'),
            RusEng('Свернуть все окна.','Minimize all windows.'),
            0);
 UpdateMenu(MenuWindowsArrangeAll,
            RusEng('Выстроить все','Arrange all'),
            RusEng('Выстроить все значки.','Arrange all icons.'),
            0);
 UpdateMenu(MenuWindowsShowActive,
            RusEng('Окно:','Window:'),
            RusEng('Показать активное окно.','Показать активное окно.'),
            0);
 UpdateMenu(MenuWindowsUpdate,
            RusEng('Обновить окно','Update window'),
            RusEng('Перерисовать окно.','Redraw current window.'),
            ShortCut(VK_F5,[]));
 MenuWindowsDaq.Caption:=GetDaqControlDialogCaption;
 UpdateMenu(MenuWindowsOpenSystemConsole,
            RusEng('Главная консоль','System console'),
            RusEng('Открыть окно "'+GetMainConsoleCaption('ru')+'".','Open "'+GetMainConsoleCaption('en')+'" window.'),
            ShortCut(Word('C'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuWindowsOpenResourceMonitorConsole,
            RusEng('Консоль монитора ресурсов','Resource monitor console'),
            RusEng('Открыть окно "КОНСОЛЬ МОНИТОРА РЕСУРСОВ".','Open "RESOURCE MONITOR CONSOLE" window.'),
            ShortCut(Word('R'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuWindowsWatchDogControl,
            RusEng('Цербер','Hell-hound'),
            RusEng('Открыть окно "СТОРОЖЕВОЙ ТАЙМЕР".','Open "WATCHDOG TIMER" window.'),
            ShortCut(Word('D'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuWindowsMistimingService,
            RusEng('Служба системного времени','System time service'),
            RusEng('Открыть окно "Служба системного времени".','Open "System time service" window.'),
            ShortCut(Word('W'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuWindowsToggleMainMenu,
            RusEng('Показывать основное меню','Show MainMenu'),
            RusEng('Показать\спрятать основное меню.','Show\hide MainMenu.'),
            ShortCut(Word('M'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuWindowsToggleToolBar,
            RusEng('Показывать инструменты','Show ToolBar'),
            RusEng('Показать\спрятать панель инструментов.','Show\hide ToolBar.'),
            ShortCut(Word('T'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuWindowsToggleStatusBar,
            RusEng('Показывать статус','Show StatusBar'),
            RusEng('Показать\спрятать статусную строку.','Show\hide StatusBar.'),
            ShortCut(Word('S'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuWindowsToggleHideIconicSdiChildren,
            RusEng('Прятать свернутые окна','Hide iconic windows'),
            RusEng('Прятать\сворачивать окна при закрытии.','Hide\minimize windows on close.'),
            ShortCut(Word('H'),[ssCtrl,ssAlt]));
 UpdateMenu(MenuWindowsToggleAwakeModal,
            RusEng('Будить модальные окна','Awake modal windows'),
            RusEng('Будить модальные окна, если они "спрятались".','Awake (open) modal windows if they hidden.'),
            0);
 UpdateMenu(MenuWindowsSecretService,
            RusEng('Служба Защиты CRW-DAQ','CRW-DAQ Guard Service'),
            RusEng('Открыть окно "Служба Защиты CRW-DAQ".','Open "CRW-DAQ Guard Service" window.'),
            ShortCut(VK_F11, []));
 UpdateMenu(MenuWindowsResetGuard,
            RusEng('Понизить уровень доступа','Decrease access level'),
            RusEng('Понизить уровень доступа на единицу.','Decrease access level by one.'),
            ShortCut(VK_F12, []));
 UpdateMenu(MenuHelp,
            RusEng('Справка','Help')+MenuRightSpace,
            RusEng('Меню справочного бюро.','Help menu.'),
            0);
 UpdateMenu(MenuHelpIndex,
            RusEng('Справка по CRW-DAQ','Help on CRW-DAQ'),
            RusEng('Открыть окно справки CRW-DAQ.','Open CRW-DAQ help window.'),
            ShortCut(VK_F1, []));
 UpdateMenu(MenuHelpAbout,
            RusEng('О программе','About program'),
            RusEng('Информация о программе и её авторе.','Information about program and author.'),
            ShortCut(VK_F1, [ssShift,ssAlt]));
 UpdateMenu(MenuHelpCrwDaqDoc,
            RusEng('Документация (crw-daq-doc)','Documentation (crw-daq-doc)'),
            RusEng('Документация по программе в удобном для печати формате.','Documentation on program in print friendly format.'),
            0);
 UpdateMenu(MenuHelpHandBook,
            RusEng('Справочник','HandBook'),
            RusEng('Вызов справочника по сопутствующим темам.','Handbook with usefull information.'),
            ShortCut(VK_F1, [ssCtrl,ssAlt]));
 UpdateMenu(MenuHelpDelphi,
            RusEng('Справка по Delphi','Help on Delphi'),
            RusEng('Вызов справочника по Delphi.','Call help on Delphi.'),
            ShortCut(VK_F1, [ssAlt]));
 UpdateMenu(MenuHelpWin32Sdk,
            RusEng('Справка по Win32','Help on Win32'),
            RusEng('Вызов справочника по Win32.','Call help on Win32.'),
            ShortCut(VK_F1, [ssShift]));
 UpdateMenu(MenuHelpFpcup,
            RusEng('Справка по Fpcup','Help on Fpcup'),
            RusEng('Вызов справочника по Fpcup/Lazarus/FreePascal.','Call help on Fpcup/Lazarus/FreePascal.'),
            0);
 UpdateMenu(MenuLink,
            RusEng('Ссылки','Links')+MenuRightSpace,
            RusEng('Коллекция полезных ссылок.','Collection of useful links.'),
            0);
 UpdateMenu(MenuLinkHomeLinks,
            RusEng('Дома …','Home …')+MenuRightSpace,
            RusEng('Коллекция полезных ссылок в домашнем каталоге.','Collection of useful links in Home directory.'),
            0);
 UpdateMenu(MenuLinkHomeInstall,
            RusEng('Установить …','Install …')+MenuRightSpace,
            RusEng('Коллекция ссылок инсталляторов.','Collection of installation links.'),
            0);
 UpdateMenu(MenuLinkHomeLaunch,
            RusEng('Запустить …','Launch …')+MenuRightSpace,
            RusEng('Запустить указанную утилиту.','Launch specified utility.'),
            0);
 UpdateMenu(MenuLinkDaqSystemLinks,
            RusEng('DAQ Система','Daq System')+MenuRightSpace,
            RusEng('Коллекция полезных ссылок DAQ Системы.','Collection of useful DAQ System links.'),
            0);
 ActionDaqDevice.Hint:=RusEng('Открыть Менеджер Устройств DAQ.','Open DAQ Device Manager.');
 ActionDaqNavigator.Hint:=RusEng('Открыть главное окно DAQ.','Open main window of DAQ.');
 MenuWindowsSelector.ImageIndex:=ActionWindowsSelect.ImageIndex;
 MenuWindowsSelector.Caption:=RusEng('Выбрать','Select');
 MenuWindowsSelector.Hint:=ActionWindowsSelect.Hint;
 ResizeStatusBar;
 SetAllButtonsCursor(Self,crHandPoint);
 TimerSecond.Enabled:=true;
 TimerTick55.Enabled:=true;
 UpdateTrayIconCaptions;
 DebugOut(stdfDebug,'');
 DebugOut(stdfDebug,'[Environment]');
 myEnvironmentStrings:=OriginalEnvironmentList.Text;
 SetEnvVar('CRW_DAQ_SYS_HOME_DIR',GetRealFilePathName(HomeDir));
 SetEnvVar('CRW_DAQ_SYS_EXE_FILE',GetRealFilePathName(ProgName));
 SetEnvVar('CRW_DAQ_SYS_INI_FILE',GetRealFilePathName(SysIniFile));
 SetEnvVar('CRW_DAQ_SYS_PATH',CRW_DAQ_SYS_PATH);
 SetEnvVar('CRW_DAQ_SYS_LANG',CRW_DAQ_SYS_LANG);
 SetEnvVar('CRW_DAQ_SYS_EXE_PID',Format('%d',[GetCurrentProcessId]));
 SetEnvVar('CRW_DAQ_SYS_EXE_TID',Format('%d',[GetCurrentThreadId]));
 SetEnvVar('CRW_DAQ_SYS_SESSION_NB',IntToStr(SessionManager.SessionNb));
 SetEnvVar('CRW_DAQ_SYS_SESSION_HEAD',SessionManager.SessionHead);
 SetEnvVar('CRW_DAQ_SYS_SESSION_ID',SessionManager.SessionId);
 {$IFDEF SKIP_DRAFT}
 SetEnvVar('CRW_DAQ_SYS_MESSAGE',Format('$%4.4x',[OneInstance.UniqueAppMessage]));
 {$ENDIF ~SKIP_DRAFT}
 SetEnvVar('CRW_DAQ_SYS_TITLE',SessionManager.TitlePidAtHost);
 UpdateTitle(GetEnv('CRW_DAQ_SYS_TITLE')); // Set unique window title to identify window
 SetEnvVar('CRW_DAQ_SYS_HANDLE',Format('%u',[Handle])); // Form handle,class for fast access
 if ReadIniFilePath(SysIniFile,SectSystem,'CRWTOOLKIT_ROOT',HomeDir,s) and DirExists(s)
 then SetEnv('CRWTOOLKIT_ROOT',GetRealFilePathName(s));
 SetEnv('CRW_DAQ_SYS_INIT_PATH',GetEnvVar('PATH'));
 PathAddDirEnvFromIni(SysIniFile,SectSystem(1),'PathAddToHead',ProgName,true);
 PathAddDirEnvFromIni(SysIniFile,SectSystem(1),'PathAddToTail',ProgName,false);
 ValidateEnvPathList('PATH,CRW_DAQ_SYS_PATH,CRW_DAQ_SYS_INIT_PATH');
 {
 Apply StartupDirectory
 }
 if ReadIniFilePath(SysIniFile,SectSystem,'StartupDirectory',HomeDir,s) then begin
  s:=GetRealFilePathName(DropBackSlash(s));
  if DirExists(s) then SetCurrDir(s);
  DebugOut(stdfDebug,'');
  DebugOut(stdfDebug,'SetCurrentDirectory: '+GetCurrDir);
  DebugOut(stdfDebug,'');
 end;
 {ToolbarConsoleUtilsMode}
 if not ReadIniFileBoolean(SysIniFile,SectSystem,'ToolbarConsoleUtilsMode%b',b) then b:=false;
 ActionToolsConsoleUtilitiesMode.Checked:=b and HasDieselPascalExe;
 ActionToolsConsoleUtilitiesMode.Enabled:=HasDieselPascalExe;
 UpdateMenuToolsConsoleUtilitiesModeCaption;
 {
 Регистрация очереди отложенных вызовов и отложенный анализ командной строки.
 }
 InitSubSystems.Add(ProcessCmdLine1st);
 RegisterCrwDaqDeferredCallback(DoExecuteDeferredCommands);
 myCmdList:=NewText(16,16);         myCmdList.Master:=@myCmdList;
 myCmdCalc:=NewExpressionEvaluator; myCmdCalc.Master:=@myCmdCalc;
 myCmdCalc.SetAction('open', act_open, RusEng('Открыть файл …','Open file …'));
 SystemCalculator.SetAction('open', act_open, RusEng('Открыть файл …','Open file …'));
 {
 Add pending logon\logout script execution procedures.
 }
 InitSubSystems.Add(ExecuteLogonScript);
 DoneSubSystems.Add(ExecuteLogoutScript);
 InitSubSystems.Add(ExecuteSystemStartupScript);
 InitSubSystems.Add(ExecuteSessionNoteLogin);
 DoneSubSystems.Add(ExecuteSessionNoteLogout,True);
 DoneSubSystems.Add(ExecuteSessionLogoutSysLog);
 {
 Update Link menu items state
 }
 UpdateActionLinksState;
 {
 Add Application.Restore handler
 }
 Application.AddOnRestoreHandler(ActionTrayOnAppRestoreExecute,false);
 {
 Action on activate main form.
 }
 SdiMan.ActionOnActivateMainForm:=ActionOnActivateMainForm;
end;

procedure TFormCrwDaq.ActionOnActivateMainFormExecute(Sender: TObject);
begin
 if Daq.Timer.isStart then ActionDaq.Execute;
 wmctrl.ActivateWindow(WmWnd);
end;

procedure TFormCrwDaq.FormDestroy(Sender: TObject);
begin
 myNtRights:='';
 myDefaultHint:='';
 myFileVerInfo:='';
 myGreetingBox:='';
 {$IFDEF SKIP_DRAFT}
 Application.UnhookMainWindow(HookAllSentMessages);
 {$ENDIF ~SKIP_DRAFT}
 DesktopLogoFile:='';
 DebugOutOpenFile(stdfDebug,'');
 OpenIniLogFile('');
 OnUpdateStatusLine:=nil;
 Kill(myCmdCalc);
 Kill(myCmdList);
 ResourceLeakageLogMessage(Format('Leave %s at %s',[ExtractFileNameExt(ProgName),StdDateTimeStr(msecnow)]));
 myEnvironmentStrings:='';
 AppModal.Started:=False;
end;

procedure CrwDaqForceExit;
begin
 SystemCalculator.Eval('_Daq_Force_Exit_=1');
 SystemCalculator.Eval('_Crw_Force_Exit_=1');
 Guard.Level:=Max(Guard.Level,ga_User);
end;

procedure TFormCrwDaq.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
 {$IFDEF WINDOWS}
 if IsSystemShuttingDown then if ProcessShutdownForce then CrwDaqForceExit;
 {$ENDIF ~WINDOWS}
 if Guard.CheckAction(ga_User,Self.ClassName+'.FormCloseQuery')<0 then CanClose:=False else begin
  Inc(myCloseQueryCount);
  try
   if (myCloseQueryCount=1) then begin
    if CanClose then FullTextEditorList.SaveAll;
    CanClose:=CanClose and ConfirmExitList.Execute;
   end else CanClose:=False;
  finally
   Dec(myCloseQueryCount);
  end;
 end;
end;

procedure TFormCrwDaq.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 TimerSecond.Enabled:=false;
 TimerTick55.Enabled:=false;
 Finalize_SybSystems;
end;

procedure TFormCrwDaq.FormResize(Sender: TObject);
begin
 if Ok then
 try
  ResizeStatusBar;
 except
  on E:Exception do BugReport(E,Self,'FormResize');
 end;
end;

procedure TFormCrwDaq.ResizeStatusBar;
var w:Integer; const dw=8;
begin
 if Ok then
 try
  w:=4;
  StatusBar.Panels[sb_Language].Width:=Canvas.TextWidth('RUS')+dw;
  inc(w,StatusBar.Panels[sb_Language].Width);
  StatusBar.Panels[sb_DateTime].Width:=Canvas.TextWidth(' 0001.01.01\00:00:00')+dw;
  inc(w,StatusBar.Panels[sb_DateTime].Width);
  StatusBar.Panels[sb_Memory].Width:=Canvas.TextWidth(' 0.000.000.000')+dw;
  inc(w,StatusBar.Panels[sb_Memory].Width);
  StatusBar.Panels[sb_DaqTime].Width:=Canvas.TextWidth(' 000000.0000')+dw;
  inc(w,StatusBar.Panels[sb_DaqTime].Width);
  StatusBar.Panels[sb_Rights].Width:=Canvas.TextWidth('root:guest')+dw;
  inc(w,StatusBar.Panels[sb_Rights].Width);
  StatusBar.Panels[sb_Comment].Width:=Width-w;
  StatusBar.Update;
 except
  on E:Exception do BugReport(E,Self,'ResizeStatusBar');
 end;
end;

procedure TFormCrwDaq.DoShowHint(Sender: TObject);
var AppHint:LongString;
begin
 if not Assigned(Self) then Exit;
 if Assigned(Application) then AppHint:=Application.Hint else AppHint:='';
 if (AppHint='') then AppHint:=myDefaultHint;
 UpdateStatusLine(' '+AppHint);
end;

procedure TFormCrwDaq.StatusBarDblClick(Sender: TObject);
begin
 if not Assigned(Self) then Exit;
 SendToMainConsole('@Silent @Memory Clear CfgCache,BmpCache'+EOL);
end;

procedure TFormCrwDaq.UpdateCommands;
var Child:TForm; HasWindow,HasWindows:Boolean;
begin
 if TMasterForm.IsMonitoringOnPause then Exit;
 try
  Child:=SdiMan.ActiveChild;
  HasWindow:=(SdiMan.ChildCount>0);
  HasWindows:=(SdiMan.ChildCount>1);
  if (Child is TFormCrwDaqSysChild)
  then TFormCrwDaqSysChild(Child).UpdateCommands
  else begin
   ActionFileSave.Enabled:=false;
   ActionFileSaveAs.Enabled:=false;
   ActionFilePrint.Enabled:=false;
  end;
  ActionWindowsUpdate.Enabled:=HasWindow;
  ActionWindowsSelect.Enabled:=HasWindows;
  ActionWindowsPrev.Enabled:=HasWindows;
  ActionWindowsNext.Enabled:=HasWindows;
  ActionWindowsTile.Enabled:=HasWindows and SdiMan.IsMdiMode;
  ActionWindowsCascade.Enabled:=HasWindows and SdiMan.IsMdiMode;
  ActionWindowsMinimizeAll.Enabled:=HasWindows;
  ActionWindowsArrangeAll.Enabled:=HasWindows;
  if ActionToolsKeyBoardLayout.Checked then KeyBoardLayoutCheck;
  SmartUpdate(StatusBar, sb_Language, UpcaseStr(KeyBoardLayoutExt));
  ActionWindowsToggleStatusBar.Checked:=StatusBar.Visible;
  ActionWindowsToggleToolBar.Checked:=ToolBar.Visible;
  ActionWindowsToggleMainMenu.Checked:=Assigned(Menu);
  if Assigned(FormDaqControlDialog) then begin
   ActionDaqDevice.Enabled:=FormDaqControlDialog.ActionDaqDevice.Enabled;
   ActionDaqNavigator.Enabled:=FormDaqControlDialog.ActionDaqNavigator.Enabled;
  end else begin
   ActionDaqDevice.Enabled:=false;
   ActionDaqNavigator.Enabled:=false;
  end;
 except
  on E:Exception do BugReport(E,Self,'UpdateCommands');
 end;
end;

procedure TFormCrwDaq.TimerSecondTimer(Sender: TObject);
const Recursion:Integer=0;
var k1,k2,u1,u2:Int64; b1,b2:boolean;
begin
 try
  inc(Recursion);
  try
   if Recursion=1 then begin
    b1:=GetThreadTimesAsFileTime(k1,u1);
    SecondActions.Execute;
    b2:=GetThreadTimesAsFileTime(k2,u2);
    if b1 and b2 then begin
     inc(TimerActionsCpuKernLoad,k2-k1);
     inc(TimerActionsCpuUserLoad,u2-u1);
    end;
   end;
  finally
   dec(Recursion);
  end;
 except
  on E:Exception do BugReport(E,Self,'TimerSecondTimer');
 end;
end;

procedure TFormCrwDaq.TimerTick55Timer(Sender: TObject);
const Recursion:Integer=0;
var k1,k2,u1,u2:Int64; b1,b2:boolean;
begin
 try
  inc(Recursion);
  try
   if Recursion=1 then begin
    b1:=GetThreadTimesAsFileTime(k1,u1);
    Tick55Actions.Execute;
    b2:=GetThreadTimesAsFileTime(k2,u2);
    if b1 and b2 then begin
     inc(TimerActionsCpuKernLoad,k2-k1);
     inc(TimerActionsCpuUserLoad,u2-u1);
    end;
   end;
  finally
   dec(Recursion);
  end;
 except
  on E:Exception do BugReport(E,Self);
 end;
end;

function Dump(const X:LongInt):LongString; overload;
begin
 SetString(Result,PChar(@X),SizeOf(X));
end;

function Dump(const X:TGUID):LongString; overload;
begin
 SetString(Result,PChar(@X),SizeOf(X));
end;

{$IFDEF WINDOWS}
function WMCopyDataExtract(const Msg:TMessage; var aData,aText:LongString; var aPid:LongInt):Integer;
const
 guidTFormCrw32 : TGUID = '{6B7826DD-B281-4BA9-B32F-AF78A24DEDA6}';
 guidSysConsole : TGUID = '{31D8A13A-7960-4162-9158-272335902CF6}';
var HeaderSize:LongInt; Msg_CopyDataStruct:PCOPYDATASTRUCT;
begin
 Result:=0;
 aData:=''; aText:=''; aPid:=0;
 if Msg.Msg <> WM_COPYDATA then Exit;
 Msg_CopyDataStruct:=PtrIntToPointer(Msg.lParam);
 if Msg_CopyDataStruct.dwData <> PtrUInt(GetCurrentProcessId) then Exit;
 HeaderSize:=SizeOf(guidTFormCrw32)+SizeOf(guidSysConsole)+SizeOf(aPid);
 if LongInt(Msg_CopyDataStruct.cbData) < HeaderSize then Exit;
 if LongInt(Msg_CopyDataStruct.cbData) > SystemConsole.Form.InpFifo.Size then Exit;
 SetString(aData,PChar(Msg_CopyDataStruct.lpData),Msg_CopyDataStruct.cbData);
 if Dump(guidTFormCrw32) = Copy(aData,1,SizeOf(guidTFormCrw32)) then begin
  if Dump(guidSysConsole) = Copy(aData,1+SizeOf(guidTFormCrw32),SizeOf(guidSysConsole)) then begin
   Move(aData[1+SizeOf(guidTFormCrw32)+SizeOf(guidSysConsole)],aPid,SizeOf(aPid));
   aText:=Copy(aData,1+HeaderSize,MaxInt);
   Result:=1;
   Exit;
  end;
 end;
 aData:='';
end;

 // https://docs.microsoft.com/en-us/windows/desktop/dataxchg/wm-copydata
 // An application sends the WM_COPYDATA message to pass data to another application.
 // WParam = A handle to the window passing the data.
 // LParam = A pointer to a COPYDATASTRUCT structure that contains the data to be passed.
 // Result = If the receiving application processes this message, it should return TRUE; otherwise, it should return FALSE.
procedure TFormCrwDaq.HandleWMCopyData(var Msg: TMessage);
var mData,mText,vText:LongString; mPid:LongInt;
var Msg_CopyDataStruct:PCOPYDATASTRUCT;
begin
 try
  try
   mData:=''; mText:=''; vText:=''; mPid:=0;
   Msg_CopyDataStruct:=PtrIntToPointer(Msg.lParam);
   case WMCopyDataExtract(Msg,mData,mText,mPid) of
    1: // Message to system console received.
     if SystemConsole.TtyListenCount(0)>0 then begin
      Echo(Format('%s: Received %d byte(s) from pid@%d, tty pid@%d',
          [StdDateTimeStr(mSecNow),Length(mText),mPid,GetWindowProcessId(Msg.wParam)]));
      vText:=ValidateEol(mText,1);
      if not SystemConsole.TtyShield then
      if SystemConsole.Form.InpFifo.PutText(vText)
      then Msg.Result:=Length(mText)
      else Raise ESystemConsole.Create(Format('System console fifo overflow (%d,%d,%d)',
       [Length(vText),SystemConsole.Form.InpFifo.Space,SystemConsole.Form.InpFifo.Size]));
     end;
    else begin
     Echo(Format('%s: Invalid WM_COPYDATA received ($%x,%d,%d,%d).',
         [StdDateTimeStr(mSecNow),Msg.Msg,Msg.wParam,Msg_CopyDataStruct.dwData,Msg_CopyDataStruct.cbData]));
    end;
   end;
  finally
   mData:='';
   mText:='';
   vText:='';
  end;
 except
  on E:Exception do BugReport(E,Self,'HandleWMCopyData');
 end;
end;

 // https://docs.microsoft.com/en-us/windows/desktop/gdi/wm-displaychange
 // The WM_DISPLAYCHANGE message is sent to all windows when the display resolution has changed.
 // WParam = The new image depth of the display, in bits per pixel.
 // LParam = The low-order word specifies the horizontal resolution of the screen.
 //          The high-order word specifies the vertical resolution of the screen.
 // Result = Not uses.
procedure TFormCrwDaq.HandleWMDisplayChange(var Msg:TMessage);
var BitsPerPix,HorResolut,VerResolut:LongInt;
begin
 if (Msg.Msg=WM_DISPLAYCHANGE) then
 try
  BitsPerPix:=Msg.WParam;
  HorResolut:=Msg.LParamLo;
  VerResolut:=Msg.LParamHi;
  SendToMainConsole('@silent @integrity WIN32:WM_DISPLAYCHANGE '+
             IntToStr(HorResolut)+' '+IntToStr(VerResolut)+' '+IntToStr(BitsPerPix)+EOL);
  SendToMainConsole('@silent @echo '+StdDateTimeStr(mSecNow)+': WIN32:WM_DISPLAYCHANGE - '+
             RusEng('разрешение экрана изменилось на ','display resolution changed to ')+
             IntToStr(HorResolut)+'x'+IntToStr(VerResolut)+'x'+IntToStr(BitsPerPix)+'.'+EOL);
  SendToMainConsole('@silent @view screen'+EOL);
 except
  on E:Exception do BugReport(E,Self,'HandleWMDisplayChange');
 end;
end;

 // https://docs.microsoft.com/en-us/windows/desktop/shutdown/wm-queryendsession
 // The WM_QUERYENDSESSION message is sent when the user chooses to end the session or when an application calls one
 // of the system shutdown functions. If any application returns zero, the session is not ended.
 // WParam = This parameter is reserved for future use.
 // LParam = 0         : the system is shutting down or restarting (it is not possible to determine which event is occurring).
 //          ENDSESSION_CLOSEAPP : The application is using a file that must be replaced, the system is being serviced, or system resources are exhausted.
 //          ENDSESSION_CRITICAL : The application is forced to shut down.
 //          ENDSESSION_LOGOFF   : The user is logging off.
 // Result = TRUE is default value to continue shutdown process, FALSE uses to terminate logoff/shutdown process.
procedure TFormCrwDaq.HandleWMQueryEndSession(var Msg: TMessage);
begin
 if (Msg.Msg=WM_QUERYENDSESSION) then
 try
  if ProcessShutdownForce then CrwDaqForceExit;
  SendToMainConsole('@silent @integrity WIN32:WM_QUERYENDSESSION '+
             Format('$%x $%x',[Msg.WParam,Msg.LParam])+EOL);
  SendToMainConsole('@silent @echo '+StdDateTimeStr(mSecNow)+': WIN32:WM_QUERYENDSESSION - '+
             RusEng('запрос на завершение сеанса ','query to end session ')+
             Format('$%x $%x',[Msg.WParam,Msg.LParam])+EOL);
  Msg.Result := Integer(CloseQuery and CallTerminateProcs);
 except
  on E:Exception do BugReport(E,Self,'HandleWMQueryEndSession');
 end;
end;
{$ENDIF ~WINDOWS}

const
 EndingSessionText     : LongString = '';
 EndingSessionTitle    : LongString = '';
 EndingSessionDeadline : Double     = 0;
 EndingSessionDelay    : Integer    = 0;
 EndingSessionDelayDef              = 2000;

procedure Timer_EndingSession;
var hWin:HWND;
begin
 if (EndingSessionText<>'') then
 if (EndingSessionTitle<>'') then
 if (EndingSessionDeadline>0) then
 try
  if mSecNow>EndingSessionDeadline then begin
   hWin:=wmctrl.FindWindow(0,EndingSessionTitle,'');
   if wmctrl.IsWindow(hWin) then wmctrl.CloseWindow(hwin);
  end;
 except
  on E:Exception do BugReport(E,nil,'Timer_EndingSession');
 end;
end;

procedure InitEndingSession(Deadline:Double);
var d:LongInt;
begin
 d:=0;
 if EndingSessionDelay=0 then begin
  EndingSessionDelay:=EndingSessionDelayDef;
  if ReadIniFileLongInt(SysIniFile,SectSystem,'EndingSessionDelay%d',d) then
  if d>0 then EndingSessionDelay:=d;
 end;
 if Deadline>0 then begin
  Tick55Actions.Add(Timer_EndingSession);
  EndingSessionText:=Format('Wait while ending session on process #%d …',[GetCurrentProcessId]);
  EndingSessionTitle:=Format('Ending session on process #%d …',[GetCurrentProcessId]);
  EndingSessionDeadline:=Deadline;
 end else begin
  Tick55Actions.Remove(Timer_EndingSession);
  EndingSessionText:='';
  EndingSessionTitle:='';
  EndingSessionDeadline:=0;
 end;
end;

{$IFDEF WINDOWS}
 // https://docs.microsoft.com/en-us/windows/desktop/shutdown/wm-endsession
 // The WM_ENDSESSION message is sent to an application after the system processes the results of the WM_QUERYENDSESSION message.
 // The WM_ENDSESSION message informs the application whether the session is ending.
 // WParam = If the session is being ended, this parameter is TRUE. Otherwise, it is FALSE.
 // LParam = ENDSESSION_CLOSEAPP : If wParam is TRUE, the application must shut down.
 //          ENDSESSION_CRITICAL : The application is forced to shut down.
 //          ENDSESSION_LOGOFF   : The user is logging off.
 // VCL reaction is: if TWMEndSession(Msg).EndSession then FTerminate := True;
procedure TFormCrwDaq.HandleWMEndSession(var Msg: TLMessage);
begin
 if (Msg.Msg=WM_ENDSESSION) then
 try
  SendToMainConsole('@silent @integrity WIN32:WM_ENDSESSION '+
             Format('$%x $%x',[Msg.WParam,Msg.LParam])+EOL);
  SendToMainConsole('@silent @echo '+StdDateTimeStr(mSecNow)+': WIN32:WM_ENDSESSION - '+
             RusEng('завершение сеанса ','end session ')+
             Format('$%x $%x',[Msg.WParam,Msg.LParam])+EOL);
  if TWMEndSession(Msg).EndSession then begin
   InitEndingSession(0); // To init Delay
   InitEndingSession(mSecNow+EndingSessionDelay);
   Application.MessageBox(PChar(EndingSessionText),PChar(EndingSessionTitle),MB_OK);
   InitEndingSession(0);
   CrwDaqForceExit;
   PostMessage(Handle,WM_CLOSE,0,0);
   SafeApplicationProcessMessages;
   Application.Terminate;
   System.Halt(0);
  end else begin
   InitEndingSession(0);
  end;
 except
  on E:Exception do BugReport(E,Self);
 end;
end;
{$ENDIF ~WINDOWS}

procedure TFormCrwDaq.ActionListUpdateAll(Action: TBasicAction; var Handled: Boolean);
begin
 Handled:=true;
end;

procedure TFormCrwDaq.ActionListUpdate(Action: TBasicAction; var Handled: Boolean);
begin
 Handled:=true;
end;

procedure TFormCrwDaq.ActionFileNewTextEditorExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionFileNewTextEditor)<0 then Exit;
 with NewTextEditor do if Ok then begin Width:=500; Height:=300; end;
end;

procedure TFormCrwDaq.ActionFileNewCurveWindowExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionFileNewCurveWindow)<0 then Exit;
 with NewCurveWindow do if Ok then begin Width:=500; Height:=300; end;
end;

procedure TFormCrwDaq.ActionFileNewDataAnalysisPluginExecute(Sender: TObject);
var aProject,Params:LongString;
begin
 if Guard.CheckAction(ga_Root,ActionFileNewDataAnalysisPlugin)<0 then Exit;
 Params:=ControlPosParams(Toolbar,'LB');
 Params:=Params+EOL+'@set Form.Width '+IntToStr(Toolbar.Width)+EOL;
 aProject:=CreateNewDataAnalysisPlugin(FavoritePascalProjectType,Params);
 if (aProject<>'') then {FindPascalProjectEditor(aProject,true,true)};
end;

procedure TFormCrwDaq.ActionFileNewDataAcquisitionPluginExecute(Sender: TObject);
var aProject:LongString;
begin
 if Guard.CheckAction(ga_Root,ActionFileNewDataAcquisitionPlugin)<0 then Exit;
 aProject:=CreateNewDataAcquisitionPlugin;
 if (aProject<>'') then FindTextEditor(aProject,true,true);
end;

procedure TFormCrwDaq.ActionFileNewProjectFromSampleExecute(Sender: TObject);
var Params:LongString;
begin
 if Guard.CheckAction(ga_Root,ActionFileNewProjectFromSample)<0 then Exit;
 Params:=ControlPosParams(ToolBar)+EOL+'@set Form.Width '+IntToStr(Width)+EOL;
 RunCreateNewProjectFromSample(Params);
end;

procedure TFormCrwDaq.ActionFileNewDaqCreatorExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionFileNewDaqCreator)<0 then Exit;
 SendToMainConsole('@silent @run DaqCreator'+EOL);
end;

procedure TFormCrwDaq.ActionFileNewDaqConstructorExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionFileNewDaqConstructor)<0 then Exit;
 SendToMainConsole('@silent @run DaqConstructor'+EOL);
end;

procedure OpenCrwDaqFileDialog(const FileName:LongString);
var Magic:Integer; Chunk:TRiffChunk; Key:LongString; Obj:TObject;
begin
 try
  Magic:=ReadFileSignature(FileName);
  case Magic of
   sig_RIFF:
    begin
     Chunk:=SelectRiffItemDialog(FileName);
     if Chunk.dwSign=sig_ITEM then
     case Chunk.dwFormID of
      sig_CRVW : LoadCurveWindowFromCRW(FileName,Chunk);
      sig_SURW : LoadSurfWindowFromCRW(FileName,Chunk);
      else Error(RusEng('Неизвестный тип ','Unknown type ')+
                 dwSign2Str(Chunk.dwSign)+' '+dwSign2Str(Chunk.dwFormID));
     end;
    end;
   sig_FBPR:
    begin
     Key:=SelectKeyFromResource(FileName);
     if (Key<>'') then begin
      Obj:=ReadObjectFromResource(FileName,Key);
      if Assigned(Obj) and not (Obj is TForm) then Kill(Obj);
     end;
    end;
   else Error(Format(RusEng('Неизвестная сигнатура файла %.8x',
                            'Unrecognized file signature %.8x'),[Magic]));
  end;
 except
  on E:Exception do BugReport(E,nil,'OpenCrwDaqFileDialog');
 end;
end;

procedure TFormCrwDaq.ActionFileOpenExecute(Sender: TObject);
var Ext,FName,Cmd:LongString;
 procedure OpenLm9File(Lm9:LongString; How:Integer);
 var exe,pat,rep:LongString;
 begin
  lm9:=UnifyFileAlias(lm9);
  exe:=''; pat:=''; rep:='';
  if FileExists(Lm9) then begin
   if IsUnix then begin
    exe:=GetAppPath('-e CrossMachine -t application/x-diesel -a .lm9');
    pat:='CrossMachine'; rep:='CrossDesigner';
   end;
   if IsWindows then begin
    exe:=GetAppPath('-e CrossMachine.exe -t VisualTech.DieselPascal.CrossMachine -a .lm9');
    pat:='CrossMachine.exe'; rep:='CrossDesigner.exe';
   end;
   if (How=0) and EndsText(pat,exe) then exe:=Copy(exe,1,Length(exe)-Length(pat))+rep;
   if (exe='') or not FileExists(exe) then begin
    Echo(RusEng('DieselPascal не найден.','DieselPascal not found.'));
    Exit;
   end;
   SendToMainConsole('@run '+AnsiQuotedIfNeed(exe)+' '+AnsiQuotedIfNeed(lm9)+EOL);
  end;
 end;
begin
 if Guard.CheckAction(ga_Guest,ActionFileOpen)<0 then Exit;
 try
  Ext:=''; FName:=''; Cmd:='';
  OpenDialog.Title:=RusEng('Файл\Открыть …','File\Open …');
  OpenDialog.Filter:=RusEng(
        'Архив CRW-DAQ - crw,daq,dat                |*.crw;*.daq;*.dat|'+
        'Конфигурация - cfg,ini,crc,cal,nsi         |*.cfg;*.ini;*.crc;*.cal;*.nsi|'+
        'Исполняемый - exe,com,bat,cmd,msi,lm9      |*.exe;*.com;*.bat;*.cmd;*.msi;*.lm9|'+
        'Программа - pas,dpr,lpr,inc,mac,c,h,asm,bas|*.pas;*.dpr;*.lpr;*.inc;*.mac;*.c;*.cpp;*.c++;*.h;*.hpp;*.h++;*.asm;*.bas|'+
        'Документ - txt,htm,doc,pdf,ppt,hlp,md      |*.txt;*.htm;*.html;*.doc;*.rtf;*.pdf;*.ps;*.ppt;*.pps;*.hlp;*.chm;*.md;*.mkd;*.markdown|'+
        'Рисунок - bmp,gif,jpg,png                  |*.bmp;*.gif;*.jpg;*.png|'+
        'Журнал - log,out                           |*.log;*.out|'+
        'Спектр - spd,pik                           |*.spd;*.pik|'+
        'ММедиа - wav,mp3,m3u,avi,vob,mpg           |*.wav;*.mp3;*.m3u;*.avi;*.vob;*.mpg|'+
        'Все - *.*                                  |*.*|'
        ,
        'Archive CRW-DAQ - crw,daq,dat              |*.crw;*.daq;*.dat|'+
        'Configuration - cfg,ini,crc,cal,nsi        |*.cfg;*.ini;*.crc;*.cal;*.nsi|'+
        'Executable - exe,com,bat,cmd,msi           |*.exe;*.com;*.bat;*.cmd;*.msi;*.lm9|'+
        'Programme - pas,dpr,lpr,inc,mac,c,h,asm,bas|*.pas;*.dpr;*.lpr;*.inc;*.mac;*.c;*.cpp;*.c++;*.h;*.hpp;*.h++;*.asm;*.bas|'+
        'Document - txt,htm,doc,pdf,ppt,hlp,md      |*.txt;*.htm;*.html;*.doc;*.rtf;*.pdf;*.ps;*.ppt;*.pps;*.hlp;*.chm;*.md;*.mkd;*.markdown|'+
        'Picture - bmp,gif,jpg,png                  |*.bmp;*.gif;*.jpg;*.png|'+
        'Journal - log,out                          |*.log;*.out|'+
        'Spectr - spd,pik                           |*.spd;*.pik|'+
        'MMedia - wav,mp3,m3u,avi,vob,mpg           |*.wav;*.mp3;*.m3u;*.avi;*.vob;*.mpg|'+
        'Any - *.*                                  |*.*|'
        );
  if IsEmptyStr(OpenDialog.FileName)
  then OpenDialogSelectType(OpenDialog,'*.crw')
  else OpenDialogSelectType(OpenDialog,OpenDialog.FileName);
  if ExecuteFileDialog(GuardOpenDialog(OpenDialog),ControlPosParams(ToolBar,'LB')) then begin
   FName:=UnifyFileAlias(OpenDialog.FileName);
   Ext:=TrimChars(ExtractFileExt(FName),['.',' '],[' ']);
   {CRW files}
   if WordIndex(Ext,'crw,daq',[','])>0 then begin
    if Guard.CheckAction(ga_Guest,Guard.GetActionName(ActionFileOpen)+'.crw')>=0
    then OpenCrwDaqFileDialog(FName);
   end else
   {DAT files}
   if WordIndex(Ext,'dat',[','])>0 then begin
    if Guard.CheckAction(ga_Guest,Guard.GetActionName(ActionFileOpen)+'.dat')>=0
    then ReadDatFiles(OpenDialog.Files.Text,ControlPosParams(ToolBar,'LB'));
   end else
   {TEXT files}
   if WordIndex(Ext,'txt,log,out,pik',[','])>0 then begin
    if Guard.CheckAction(ga_User,Guard.GetActionName(ActionFileOpen)+'.txt')>=0
    then FindTextEditor(FName,true,true);
   end else
   {CONFIG files}
   if WordIndex(Ext,'cfg',[','])>0 then begin
    if Guard.CheckAction(ga_Root,Guard.GetActionName(ActionFileOpen)+'.cfg')>=0 then
    if Daq.Timer.isStart then FindTextEditor(FName,true,true) else
    case ListBoxMenu(RusEng('Открыть конфигурацию','Open configuration'),
                     RusEng('Каким способом открыть?','How to open?'),
                     RusEng('Как текст'+EOL+'Как DAQ-систему','As text'+EOL+'As DAQ-system'))
    of
     0 : FindTextEditor(FName,true,true);
     1 : if not IsWildCard(FName) and FileExists(FName) then Daq.InitSession(FName);
    end;
   end else
   {CONFIG & PROGRAM files}
   if WordIndex(Ext,'cfg,ini,pas,mac,c,cpp,c++,h,hpp,h++,asm,bas',[','])>0 then begin
    if Guard.CheckAction(ga_Root,Guard.GetActionName(ActionFileOpen)+'.pas')>=0 then FindTextEditor(FName,true,true);
   end else
   {CRC files}
   if WordIndex(Ext,'crc',[','])>0 then begin
    if Guard.CheckAction(ga_Root,Guard.GetActionName(ActionFileOpen)+'.crc')>=0 then
    case ListBoxMenu(RusEng('Открыть мнемосхему','Open mnemonic diagram'),
                     RusEng('Каким способом открыть?','How to open?'),
                     RusEng('Как текст'+EOL+'Как изображение','As text'+EOL+'As picture'))
    of
     0 : FindTextEditor(FName,true,true);
     1 : NewCircuitWindowFromCrcFile(FName);
    end;
   end else
   {CAL files}
   if WordIndex(Ext,'cal',[','])>0 then begin
    if Guard.CheckAction(ga_User,Guard.GetActionName(ActionFileOpen)+'.cal')>=0 then
    case ListBoxMenu(RusEng('Открыть калибровку','Open calibration'),
                     RusEng('Каким способом открыть?','How to open?'),
                     RusEng('Как текст'+EOL+'Редактором калибровок','As text'+EOL+'Via calibration editor'))
    of
     0 : FindTextEditor(FName,true,true);
     1 : OpenFormCalibDialogFromFile(FName);
    end;
   end else
   {SPD files}
   if WordIndex(Ext,'spd',[','])>0 then begin
    if Guard.CheckAction(ga_User,Guard.GetActionName(ActionFileOpen)+'.spd')>=0 then
    if ActiveSpectrWindow.Ok then begin
     if not ActiveSpectrWindow.LoadSPD(FName) then SystemConsole.Activate;
    end else FindTextEditor(FName,true,true);
   end else
   {DPR files}
   if WordIndex(Ext,'dpr',[','])>0 then begin
    if Guard.CheckAction(ga_Root,Guard.GetActionName(ActionFileOpen)+'.dpr')>=0 then FindDelphiProjectEditor(FName,true,true);
   end else
   {LPR files}
   if WordIndex(Ext,'lpr',[','])>0 then begin
    if Guard.CheckAction(ga_Root,Guard.GetActionName(ActionFileOpen)+'.lpr')>=0 then FindLazarusProjectEditor(FName,true,true);
   end else
   {HTM files}
   if WordIndex(Ext,'htm,html',[','])>0 then begin
    if Guard.CheckAction(ga_User,Guard.GetActionName(ActionFileOpen)+'.htm')>=0 then
    case ListBoxMenu(RusEng('Открыть гипертекст','Open hypertext'),
                     RusEng('Каким способом открыть?','How to open?'),
                     RusEng('Как текст'+EOL+'Как гипертекст HTML','As text'+EOL+'As hypertext HTML'))
    of
     0 : FindTextEditor(FName,true,true);
     1 : SmartExecute(FName,SW_SHOWNORMAL,'open');
    end;
   end else
   {BAT files}
   if WordIndex(Ext,'bat,cmd',[','])>0 then begin
    if Guard.CheckAction(ga_Root,Guard.GetActionName(ActionFileOpen)+'.bat')>=0 then
    case ListBoxMenu(RusEng('Открыть командный файл','Open command batch'),
                     RusEng('Каким способом открыть?','How to open?'),
                     RusEng('Как текст'+EOL+'Как программу','As text'+EOL+'As program'))
    of
     0 : FindTextEditor(FName,true,true);
     1 : SmartExecute(Format('"%s" /c "%s"',[GetComSpec,FName]));
    end;
   end else
   {LM9 files}
   if WordIndex(Ext,'lm9',[','])>0 then begin
    if Guard.CheckAction(ga_Root,Guard.GetActionName(ActionFileOpen)+'.lm9')>=0 then
    case ListBoxMenu(RusEng('Открыть файл Дизель Паскаль','Open Diesel Pascal file'),
                     RusEng('Каким способом открыть?','How to open?'),
                     RusEng('Редактировать в Дизайнере'+EOL+'Исполнить как программу',
                            'Edit with Designer'+EOL+'Run with CrossMachine'))
    of
     0 : OpenLm9File(FName,0);
     1 : OpenLm9File(FName,1);
    end;
   end else
   {DOC files}
   if WordIndex(Ext,'doc,rtf,pdf,ps,wav,mp3,m3u,avi,vob,mpg,hlp,chm,md,mkd,markdown,ppt,pps',[','])>0 then begin
    if Guard.CheckAction(ga_User,Guard.GetActionName(ActionFileOpen)+'.doc')>=0 then
    SmartExecute(FName,SW_SHOWNORMAL,'open');
   end else
   {BMP files}
   if WordIndex(Ext,'bmp,gif,jpg,png',[','])>0 then begin
    if Guard.CheckAction(ga_User,Guard.GetActionName(ActionFileOpen)+'.bmp')>=0 then
    if SysGlossary.ReadIniParam(SysIniFile,SectHandlerList(1),'@open.bmp',Cmd)
    then SendToMainConsole(Cmd+' '+AnsiQuotedIfNeed(UnifyFileAlias(FName))+EOL)
    else Echo('Error: could not find handler on @open.bmp');
   end else
   {EXE files}
   if WordIndex(Ext,'exe,com',[','])>0 then begin
    if Guard.CheckAction(ga_Root,Guard.GetActionName(ActionFileOpen)+'.exe')>=0 then
    SmartExecute(FName);
   end else
   {MSI files}
   if WordIndex(Ext,'msi',[','])>0 then begin
    if Guard.CheckAction(ga_Root,Guard.GetActionName(ActionFileOpen)+'.msi')>=0 then
    SmartExecute(FName,SW_SHOWNORMAL,'open');
   end else
   {NSI files}
   if WordIndex(Ext,'nsi',[','])>0 then begin
    if Guard.CheckAction(ga_Root,Guard.GetActionName(ActionFileOpen)+'.nsi')>=0 then
    if not FindTextEditor(FName,false,true).Ok then NewFormNsisEditor(FName);
   end else
   {ANY other files}
   begin
    if Guard.CheckAction(ga_Root,Guard.GetActionName(ActionFileOpen)+'.etc')>=0 then
    case ListBoxMenu(RusEng('Открыть файл','Open file'),
                    RusEng('Каким способом открыть?','How to open?'),
                    RusEng('Как текст'+EOL+'Как программу','As text'+EOL+'As program'))
    of
     0 : FindTextEditor(FName,true,true);
     1 : SmartExecute(FName,SW_SHOWNORMAL,'open');
    end;
   end;
  end;
 except
  on E:Exception do BugReport(E,Self);
 end;
end;

function act_open(ee:TExpressionEvaluator; const args:LongString):double;
const
 Locked  : Boolean = False;
 op_Runs = $00000001; // File expected to run
 op_Edit = $00000002; // File expected to edit
 op_Name = $00000004; // File name should be selected in FileOpen dialog
 op_RelP = $00000008; // File has relative path
 op_NoEx = $00000010; // File has no extension
 op_Lock = $10000000; // Lock   open command to disable launch
 op_UnLk = $20000000; // Unlock open command to enable  launch
 op_Wild = $40000000; // File name contains wildcard *,?
 op_Miss = $80000000; // File missed (not exists)
 op_Open = op_Name or op_Wild; //  Expected FileOpen dialog
var
 arg:LongString;
 ops:LongString;
 ico:LongString;
 Ext:LongString;
 dev:TDaqDevice;
 opt:Cardinal;
 i  :Integer;
 // Check if section exists inside INI file
 function SectionExists(FName,Sect:LongString):Boolean;
 var Ini:TIniFile;
 begin
  Result:=False;
  try
   FName:=UnifyFileAlias(FName);
   if FileExists(FName) then
   if IsNonEmptyStr(Sect) then begin
    Ini:=TIniFile.Create(FName);
    try
     Result:=Ini.SectionExists(Sect);
    finally
     Ini.Free;
    end;
   end;
  except
   on E:Exception do BugReport(E,ee,'SectionExists');
  end;
 end;
 // Check if file is main config
 function IsMainCfg(const FName:LongString):Boolean;
 begin
  Result:=False;
  try
   Result:=Result or HasFlags(opt,op_Runs);
   Result:=Result or (Pos('!',Trim(ExtractFileName(FName)))=1);
   Result:=Result or (Pos('#',Trim(ExtractFileName(FName)))=1);
   Result:=Result or SectionExists(FName,'DAQ');
  except
   on E:Exception do BugReport(E,ee,'IsMainCfg');
  end;
 end;
 // Start DAQ system if one not started
 procedure StartDaqSystem(const s:LongString);
 var Path:LongString;
 begin
  if Daq.Ok then
  if not Daq.Timer.IsStart then
  if IsSameText(ExtractFileExt(s),'.cfg') then begin
   Path:=UnifyFileAlias(SmartFileRef(s,'.cfg',ProgName));
   if not IsWildCard(Path) and FileExists(Path) then Daq.InitSession(Path);
  end;
 end;
 // Call FileOpen dialog
 procedure OpenDialog(const FName:LongString);
 begin
  if IsNonEmptyStr(FName) then FormCrwDaq.OpenDialog.FileName:=Trim(FName);
  FormCrwDaq.ActionFileOpen.Execute;
 end;
 // Open CRW file
 procedure OpenCrwFile(const FName:LongString);
 begin
  OpenCrwDaqFileDialog(FName);
 end;
 // Open DAT file
 procedure OpenDatFile(const FName:LongString);
 begin
  ReadDatFiles(FName);
 end;
 // Open text file for edit
 procedure OpenTxtFile(const FName:LongString);
 begin
  FindTextEditor(FName,true,true);
 end;
 // Open CFG file
 procedure OpenCfgFile(const FName:LongString);
 begin
  if IsMainCfg(FName) then StartDaqSystem(FName) else OpenTxtFile(FName);
 end;
 // Open CRC file
 procedure OpenCrcFile(const FName:LongString);
 begin
  NewCircuitWindowFromCrcFile(FName);
 end;
 // Open CAL file
 procedure OpenCalFile(const FName:LongString);
 begin
  OpenFormCalibDialogFromFile(FName);
 end;
 // Open SPD file
 procedure OpenSpdFile(const FName:LongString);
 begin
  if ActiveSpectrWindow.Ok then begin
   if not ActiveSpectrWindow.LoadSPD(FName) then SystemConsole.Activate;
  end else OpenTxtFile(FName);
 end;
 // Open DPR file
 procedure OpenDprFile(const FName:LongString);
 begin
  FindDelphiProjectEditor(FName,true,true);
 end;
 // Open LPR file
 procedure OpenLprFile(const FName:LongString);
 begin
  FindLazarusProjectEditor(FName,true,true);
 end;
 // Open BAT file
 procedure OpenBatFile(const FName:LongString);
 begin
  SmartExecute(Format('"%s" /c "%s"',[GetComSpec,FName]));
 end;
 // Open BMP file
 procedure OpenBmpFile(const FName:LongString);
 var cmd:LongString;
 begin
  cmd:='';
  if SysGlossary.ReadIniParam(SysIniFile,SectHandlerList(1),'@open.bmp',cmd)
  then SendToMainConsole(cmd+' '+AnsiQuotedIfNeed(UnifyFileAlias(FName))+EOL)
  else Echo('Error: could not find handler on @open.bmp');
 end;
 // Open EXE file
 procedure OpenExeFile(const FName:LongString);
 begin
  SmartExecute(FName);
 end;
 // Open NSIS file for edit
 procedure OpenNsiFile(const FName:LongString);
 begin
  if not FindTextEditor(FName,false,true).Ok then NewFormNsisEditor(FName);
 end;
 // Open any file with Shell
 procedure OpenAnyFile(const FName:LongString);
 begin
  SmartExecute(FName,SW_SHOWNORMAL,'open');
 end;
 // Check if file has acceptable name: exist and not relative path.
 function IsAcceptableFileName(const FName:LongString; opt:Integer):Boolean;
 begin
  Result:=false;
  // No dialog & incomplete path disabled
  if ((opt and op_Open)=0) and ((opt and (op_RelP+op_NoEx))<>0) then begin
   SendToMainConsole('@silent @integrity CRW:@OPEN:Incomplete '+FName+EOL);
   Exit;
  end;
  // No dialog & missed files disabled
  if ((opt and op_Open)=0) and ((opt and op_Miss)<>0) then begin
   SendToMainConsole('@silent @integrity CRW:@OPEN:MissedFile '+FName+EOL);
   Exit;
  end;
  Result:=true;
 end;
begin
 Result:=0;
 if IsMainThread then
 if FormCrwDaq.Ok then
 try
  if (ee<>FormCrwDaq.DeferredCommandCalculator) then begin
   // Should execute command asynchronously to avoid deadlocks!
   Result:=Ord(FormCrwDaq.PostDeferredCommand('@open '+Trim(args)));
   Exit;
  end;
  arg:=ee.SmartArgs(args);
  if IsNonEmptyStr(arg) then begin
   opt:=0;
   ico:='';
   arg:=Trim(arg);
   while IsOption(arg) do begin
    ops:=ExtractFirstParam(arg);
    arg:=SkipFirstParam(arg);
    if IsOption(ops,'-icon') then begin
     if HasOptionValue(ops) then ico:=ops;
     continue;
    end;
    if HasChars(LowerCase(ops),['r']) then opt:=opt or op_Runs;
    if HasChars(LowerCase(ops),['e']) then opt:=opt or op_Edit;
    if HasChars(LowerCase(ops),['d']) then opt:=opt or op_Name;
    if HasChars(LowerCase(ops),['l']) then opt:=opt or op_Lock;
    if HasChars(LowerCase(ops),['u']) then opt:=opt or op_UnLk;
   end;
   if IsWildCard(arg)     then opt:=opt or op_Wild;
   if not FileExists(arg) then opt:=opt or op_Miss;
   if IsRelativePath(arg) then opt:=opt or op_RelP;
   if IsEmptyStr(ExtractFileExt(arg)) then opt:=opt or op_NoEx;
   Ext:=Trim(UpcaseStr(Copy(ExtractFileExt(arg),2,255)));
   {Lock/unlock command}
   if opt and op_UnLk <> 0 then Locked:=False;
   if Locked then begin
    Echo(RusEng('Команда "@open" ЗАБЛОКИРОВАНА!',
                'Command "@open" is LOCKED now!'));
    Result:=0;
    Exit;
   end;
   if opt and op_Lock <> 0 then Locked:=True;
   {Icon specified?}
   if IsNonEmptyStr(ico) then SetupIcon(ico);
   {File name specified?}
   if IsEmptyStr(arg) then begin
    Result:=1;
    Exit;
   end;
   {DAQ:\…}
   if IsSameText('DAQ:',ExtractWord(1,arg,DirDelimiters)) then begin
    if Guard.CheckAction(ga_User,'@open.DAQ')>=0 then
    if Daq.Timer.isStart then begin
     {DAQ:\DeviceList\Name\…}
     if IsSameText('DeviceList',ExtractWord(2,arg,DirDelimiters)) then begin
      dev:=FullDaqDeviceList.Find(ExtractWord(3,arg,DirDelimiters));
      if TObject(dev) is TDaqDevice then begin
       {DAQ:\DeviceList\Name\Calibration#n}
       for i:=0 to dev.NumCalibrations-1 do
       if FileExists(dev.Calibration[i].FileName) then
       if not IsWildCard(dev.Calibration[i].FileName) then
       if IsSameText(ExtractWord(4,arg,DirDelimiters),'Calibration#'+IntToStr(i)) then begin
        if opt and op_Edit <> 0 then OpenTxtFile(dev.Calibration[i].FileName) else
        if opt and op_Runs <> 0 then dev.EditCalibration(i) else
        dev.EditCalibration(i);
       end;
       {DAQ:\DeviceList\Name\PropertyDialog}
       if IsSameText(ExtractWord(4,arg,DirDelimiters),'PropertyDialog') then begin
        dev.OpenPropertyDialog;
       end;
       {DAQ:\DeviceList\Name\CommonPropertyDialog}
       if IsSameText(ExtractWord(4,arg,DirDelimiters),'CommmonPropertyDialog') then begin
        dev.OpenCommonPropertyDialog;
       end;
      end;
     end;
    end else Echo(RusEng('DAQ система недоступна!','DAQ system is not available!'));
   end else
   if IsAcceptableFileName(arg,opt) then begin
    {CRW files}
    if WordIndex(Ext,'CRW,DAQ',[','])>0 then begin
     if Guard.CheckAction(ga_Guest,'@open.CRW')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenCrwFile(arg) else
     if opt and op_Runs <> 0 then OpenCrwFile(arg) else
     OpenCrwFile(arg);
    end else
    {DAT files}
    if WordIndex(Ext,'DAT',[','])>0 then begin
     if Guard.CheckAction(ga_Guest,'@open.DAT')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenTxtFile(arg) else
     if opt and op_Runs <> 0 then OpenDatFile(arg) else
     OpenDatFile(arg);
    end else
    {TEXT files}
    if WordIndex(Ext,'TXT,LOG,OUT,PIK',[','])>0 then begin
     if Guard.CheckAction(ga_User,'@open.TXT')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenTxtFile(arg) else
     if opt and op_Runs <> 0 then OpenTxtFile(arg) else
     OpenTxtFile(arg);
    end else
    {CONFIG files}
    if WordIndex(Ext,'CFG',[','])>0 then begin
     if Guard.CheckAction(ga_User,'@open.CFG')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenTxtFile(arg) else
     if opt and op_Runs <> 0 then OpenCfgFile(arg) else
     OpenCfgFile(arg);
    end else
    {INI & PROGRAM files}
    if WordIndex(Ext,'INI,PAS,MAC,C,CPP,C++,H,HPP,H++,ASM,BAS',[','])>0 then begin
     if Guard.CheckAction(ga_Root,'@open.PAS')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenTxtFile(arg) else
     if opt and op_Runs <> 0 then OpenTxtFile(arg) else
     OpenTxtFile(arg);
    end else
    {CRC files}
    if WordIndex(Ext,'CRC',[','])>0 then begin
     if Guard.CheckAction(ga_Root,'@open.CRC')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenTxtFile(arg) else
     if opt and op_Runs <> 0 then OpenCrcFile(arg) else
     case ListBoxMenu(RusEng('Открыть мнемосхему','Open mnemonic diagram'),
                      RusEng('Каким способом открыть?','How to open?'),
                      RusEng('Как текст'+EOL+'Как изображение','As text'+EOL+'As picture'))
     of
      0 : OpenTxtFile(arg);
      1 : OpenCrcFile(arg);
     end;
    end else
    {CAL files}
    if WordIndex(Ext,'CAL',[','])>0 then begin
     if Guard.CheckAction(ga_User,'@open.CAL')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenTxtFile(arg) else
     if opt and op_Runs <> 0 then OpenCalFile(arg) else
     case ListBoxMenu(RusEng('Открыть калибровку','Open calibration'),
                      RusEng('Каким способом открыть?','How to open?'),
                      RusEng('Как текст'+EOL+'Редактором калибровок','As text'+EOL+'Via calibration editor'))
     of
      0 : OpenTxtFile(arg);
      1 : OpenCalFile(arg);
     end;
    end else
    {SPD files}
    if WordIndex(Ext,'SPD',[','])>0 then begin
     if Guard.CheckAction(ga_User,'@open.SPD')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenTxtFile(arg) else
     if opt and op_Runs <> 0 then OpenSpdFile(arg) else
     OpenSpdFile(arg);
    end else
    {DPR files}
    if WordIndex(Ext,'DPR',[','])>0 then begin
     if Guard.CheckAction(ga_Root,'@open.DPR')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenDprFile(arg) else
     if opt and op_Runs <> 0 then OpenDprFile(arg) else
     OpenDprFile(arg);
    end else
    {LPR files}
    if WordIndex(Ext,'LPR',[','])>0 then begin
     if Guard.CheckAction(ga_Root,'@open.LPR')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenLprFile(arg) else
     if opt and op_Runs <> 0 then OpenLprFile(arg) else
     OpenLprFile(arg);
    end else
    {HTM files}
    if WordIndex(Ext,'HTM,HTML',[','])>0 then begin
     if Guard.CheckAction(ga_User,'@open.HTM')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenTxtFile(arg) else
     if opt and op_Runs <> 0 then OpenAnyFile(arg) else
     case ListBoxMenu(RusEng('Открыть гипертекст','Open hypertext'),
                      RusEng('Каким способом открыть?','How to open?'),
                      RusEng('Как текст'+EOL+'Как гипертекст HTML','As text'+EOL+'As hypertext HTML'))
     of
      0 : OpenTxtFile(arg);
      1 : OpenAnyFile(arg);
     end;
    end else
    {BAT files}
    if WordIndex(Ext,'BAT,CMD',[','])>0 then begin
     if Guard.CheckAction(ga_Root,'@open.BAT')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenTxtFile(arg) else
     if opt and op_Runs <> 0 then OpenBatFile(arg) else
     case ListBoxMenu(RusEng('Открыть командный файл','Open command batch'),
                      RusEng('Каким способом открыть?','How to open?'),
                      RusEng('Как текст'+EOL+'Как программу','As text'+EOL+'As program'))
     of
      0 : OpenTxtFile(arg);
      1 : OpenBatFile(arg);
     end;
    end else
    {DOC files}
    if WordIndex(Ext,'DOC,RTF,PDF,PS,WAV,MP3,M3U,AVI,VOB,MPG,HLP,CHM,MD,MKD,MARKDOWN,PPT,PPS',[','])>0 then begin
     if Guard.CheckAction(ga_User,'@open.DOC')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenAnyFile(arg) else
     if opt and op_Runs <> 0 then OpenAnyFile(arg) else
     OpenAnyFile(arg);
    end else
    {BMP files}
    if WordIndex(Ext,'BMP,GIF,JPG,PNG',[','])>0 then begin
     if Guard.CheckAction(ga_User,'@open.BMP')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenBmpFile(arg) else
     if opt and op_Runs <> 0 then OpenAnyFile(arg) else
     OpenBmpFile(arg);
    end else
    {EXE files}
    if WordIndex(Ext,'EXE,COM',[','])>0 then begin
     if Guard.CheckAction(ga_Root,'@open.EXE')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenExeFile(arg) else
     if opt and op_Runs <> 0 then OpenExeFile(arg) else
     OpenExeFile(arg);
    end else
    {MSI files}
    if WordIndex(Ext,'MSI',[','])>0 then begin
     if Guard.CheckAction(ga_Root,'@open.MSI')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenAnyFile(arg) else
     if opt and op_Runs <> 0 then OpenAnyFile(arg) else
     OpenAnyFile(arg);
    end else
    {NSI files}
    if WordIndex(Ext,'NSI',[','])>0 then begin
     if Guard.CheckAction(ga_Root,'@open.NSI')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenNsiFile(arg) else
     if opt and op_Runs <> 0 then OpenAnyFile(arg) else
     OpenNsiFile(arg);
    end else
    {ANY other files}
    begin
     if Guard.CheckAction(ga_Root,'@open.ETC')>=0 then
     if opt and op_Open <> 0 then OpenDialog(arg) else
     if opt and op_Edit <> 0 then OpenTxtFile(arg) else
     if opt and op_Runs <> 0 then OpenAnyFile(arg) else
     case ListBoxMenu(RusEng('Открыть файл','Open file'),
                     RusEng('Каким способом открыть?','How to open?'),
                     RusEng('Как текст'+EOL+'Как программу','As text'+EOL+'As program'))
     of
      0 : OpenTxtFile(arg);
      1 : OpenAnyFile(arg);
     end;
    end;
   end;
   Result:=1;
   Exit;
  end;
  Echo('Syntax:');
  Echo(' @open -opts filename - Open file by given name, like File\Open menu.');
  Echo('  -opts - list of options:');
  Echo('  | -l - Lock          next @open commands to forbid Drag&Drop.');
  Echo('  | -u - Unlock this & next @open commands to enable Drag&Drop.');
  Echo('  | -r - Force file to run,  skip File\Open dialog if possible.');
  Echo('  | -e - Force file to edit, skip File\Open dialog if possible.');
  Echo('  | -d - Force standard File\Open dialog to edit file name.');
  Echo(' Notes:');
  Echo('  1) Startup LOCK flag value is OFF, Drag&Drop is allowed.');
  Echo('  2) -l,-u options is allowed inside CRW-DAQ console only.');
  Echo('  3) -l,-u options is not available from cmdline or Drag&Drop.');
  Echo('  4) Current @open … execution is disabled if LOCK flag is ON.');
  Echo('  5) -u option sets LOCK flag to OFF BEFORE current @open launch.');
  Echo('  6) -l option sets LOCK flag to ON  AFTER  current @open launch.');
  Echo('  7) @open FILE is depends on FILE extension, see examples below.');
  Echo('  8) File name should be FULL pathname,like c:\daq32\demo\test.cfg.');
  Echo('  9) File Drag&Drop to crwdaq.exe icon is equals to run "@open File".');
  Echo(' 10) File Drag&Drop with CTRL   button is equals to run "@open -r File".');
  Echo(' 11) File Drag&Drop with ALT    button is equals to run "@open -e File".');
  Echo(' 12) File Drag&Drop with SHIFT  button is equals to run "@open -d File".');
  Echo('Examples:');
  Echo(' Lock\Unlock protection:');
  Echo('  @open -l              - Lock @open commands');
  Echo('  …                     - Drag&Drop is disabled');
  Echo('  @open -u -l c:\x.crw  - protected @open call from CRW-DAQ inside');
  Echo('  …                     - Drag&Drop is still disabled');
  Echo('  @open -u              - Unlock @open commands');
  Echo('  …                     - Drag&Drop is enabled');
  Echo(' For CRW,DAQ,DAT files:');
  Echo('  @open c:\test.crw     - open test.crw as Curve Window');
  Echo('  @open -r c:\test.crw  - open test.crw as Curve Window');
  Echo('  @open -e c:\test.crw  - open test.crw as Curve Window');
  Echo('  @open -d c:\test.crw  - File\Open dialog to open test.crw');
  Echo(' For CFG files:');
  Echo('  @open c:\test.cfg     - open or run test.cfg if it is main config');
  Echo('                          Config detected as main in case of:');
  Echo('                          a)[DAQ] section present in file');
  Echo('                          b)File name start with !, like !test.cfg');
  Echo('                          c)File name start with #, like #test.cfg');
  Echo('  @open -r c:\test.cfg  - run  test.cfg, i.e. start DAQ system');
  Echo('  @open -e c:\test.cfg  - open test.cfg to edit as text file');
  Echo('  @open -d c:\test.cfg  - File\Open dialog to open test.cfg');
  Echo(' For CAL files:');
  Echo('  @open c:\test.cal     - query how to open test.cfg ');
  Echo('  @open -r c:\test.cal  - open test.cal to edit as calibraton dialog');
  Echo('  @open -e c:\test.cal  - open test.cal to edit as text file');
  Echo('  @open -d c:\test.cal  - File\Open dialog to open test.cal');
  Echo(' For CRC files:');
  Echo('  @open c:\test.crc     - query how to open test.crc ');
  Echo('  @open -r c:\test.crc  - open test.crc as Circuit Window to test');
  Echo('  @open -e c:\test.crc  - open test.crc to edit as text file');
  Echo('  @open -d c:\test.crc  - File\Open dialog to open test.crc');
  Echo(' For TXT,LOG,OUT,PIK,INI,PAS,MAC,C,CPP,C++,H,HPP,H++,ASM,BAS files:');
  Echo('  @open c:\test.txt     - open test.txt to edit as text file');
  Echo('  @open -r c:\test.txt  - open test.txt to edit as text file');
  Echo('  @open -e c:\test.txt  - open test.txt to edit as text file');
  Echo('  @open -d c:\test.txt  - File\Open dialog to open test.txt');
  Echo(' For DPR files:');
  Echo('  @open c:\test.dpr     - open test.dpr to edit as Delphi project');
  Echo('  @open -r c:\test.dpr  - open test.dpr to edit as Delphi project');
  Echo('  @open -e c:\test.dpr  - open test.dpr to edit as Delphi project');
  Echo('  @open -d c:\test.dpr  - File\Open dialog to open test.dpr');
  Echo(' For LPR files:');
  Echo('  @open c:\test.lpr     - open test.lpr to edit as Lazarus project');
  Echo('  @open -r c:\test.lpr  - open test.lpr to edit as Lazarus project');
  Echo('  @open -e c:\test.lpr  - open test.lpr to edit as Lazarus project');
  Echo('  @open -d c:\test.lpr  - File\Open dialog to open test.lpr');
  Echo(' For NSI files:');
  Echo('  @open c:\test.nsi     - open test.nsi to edit as NSIS project');
  Echo('  @open /r c:\test.nsi  - run  test.nsi as NSIS project, i.e. create installer');
  Echo('  @open /e c:\test.nsi  - open test.nsi to edit as NSIS project');
  Echo('  @open /d c:\test.nsi  - File\Open dialog to open test.nsi');
  Echo(' For HTM files:');
  Echo('  @open c:\test.htm     - query how to open test.htm ');
  Echo('  @open -r c:\test.htm  - open test.htm as HTML hypertext');
  Echo('  @open -e c:\test.htm  - open test.htm to edit as text file');
  Echo('  @open -d c:\test.htm  - File\Open dialog to open test.htm');
  Echo(' For BMP,GIF,JPG,PNG files:');
  Echo('  @open c:\test.bmp     - open test.bmp with MsPaint to edit');
  Echo('  @open -r c:\test.bmp  - open test.bmp with Shell, like Explorer');
  Echo('  @open -e c:\test.bmp  - open test.bmp with MsPaint to edit');
  Echo('  @open -d c:\test.bmp  - File\Open dialog to open test.bmp');
  Echo(' For DOC,RTF,PDF,PS,WAV,MP3,M3U,AVI,VOB,MPG,HLP,CHM,MD,MKD,MARKDOWN,PPT,PPS files:');
  Echo('  @open c:\test.doc     - open test.doc with Shell, like Explorer');
  Echo('  @open -r c:\test.doc  - open test.doc with Shell, like Explorer');
  Echo('  @open -e c:\test.doc  - open test.doc with Shell, like Explorer');
  Echo('  @open -d c:\test.doc  - File\Open dialog to open test.doc');
  Echo(' For BAT,CMD files:');
  Echo('  @open c:\test.bat     - query how to open test.bat ');
  Echo('  @open -r c:\test.bat  - run  test.bat as executable script');
  Echo('  @open -e c:\test.bat  - open test.bat to edit as text file');
  Echo('  @open -d c:\test.bat  - File\Open dialog to open test.bat');
  Echo(' For EXE,COM,MSI files:');
  Echo('  @open c:\test.exe     - run test.exe program');
  Echo('  @open -r c:\test.exe  - run test.exe program');
  Echo('  @open -e c:\test.exe  - run test.exe program');
  Echo('  @open -d c:\test.exe  - file dialog to open/run test.exe');
  Echo(' For any other files:');
  Echo('  @open c:\test.xxx     - query how to open test.xxx ');
  Echo('  @open -r c:\test.xxx  - run  test.xxx with Shell, like Explorer');
  Echo('  @open -e c:\test.xxx  - open test.xxx to edit as text file');
  Echo('  @open -d c:\test.xxx  - File\Open dialog to open test.xxx');
  Echo(' Special DAQ functions:');
  Echo('  @open DAQ:\DeviceList\&Dev\Calibration#0        - open dialog to edit calibration of DAQ device &Dev');
  Echo('  @open -e DAQ:\DeviceList\&Dev\Calibration#0     - open text window - edit calibration of device &Dev');
  Echo('  @open DAQ:\DeviceList\&Dev\PropertyDialog       - open dialog to edit DAQ device properties');
  Echo('  @open DAQ:\DeviceList\&Dev\PropertyDialog       - open dialog to edit DAQ device properties');
  Echo('  @open DAQ:\DeviceList\&Dev\CommonPropertyDialog - open dialog to edit common device properties');
  Result:=1;
 except
  on E:Exception do BugReport(E,ee,'act_open');
 end;
end;

procedure TFormCrwDaq.OpenDialogTypeChange(Sender: TObject);
begin
 OpenDialogTypeChangeStdExecute(OpenDialog);
end;

procedure TFormCrwDaq.CommonOpenDialogTypeChange(Sender: TObject);
begin
 OpenDialogTypeChangeStdExecute(CommonOpenDialog);
end;

procedure TFormCrwDaq.ActionFileSaveExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionFileSave)<0 then Exit;
 if (SdiMan.ActiveChild is TFormCrwDaqSysChild)
 then (SdiMan.ActiveChild as TFormCrwDaqSysChild).ActionFileSaveExecute(Sender);
end;

procedure TFormCrwDaq.ActionFileSaveAsExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionFileSaveAs)<0 then Exit;
 if (SdiMan.ActiveChild is TFormCrwDaqSysChild)
 then (SdiMan.ActiveChild as TFormCrwDaqSysChild).ActionFileSaveAsExecute(Sender);
end;

procedure TFormCrwDaq.ActionFilePrintExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionFilePrint)<0 then Exit;
 if (SdiMan.ActiveChild is TFormCrwDaqSysChild)
 then (SdiMan.ActiveChild as TFormCrwDaqSysChild).ActionFilePrintExecute(Sender);
end;

procedure TFormCrwDaq.ActionFilePrinterSetupExecute(Sender: TObject);
var Params:LongString; x,y:Integer;
begin
 if Guard.CheckAction(ga_Guest,ActionFilePrinterSetup)<0 then Exit;
 x:=0; y:=ToolButtonFilePrinterSetup.Height;
 Params:='@set Panel.Font   Name:PT_Mono\Size:12\Color:Navy\Style:[Bold]'+EOL
        +'@set ListBox.Font Name:PT_Mono\Size:12\Color:Black\Style:[Bold]'+EOL
        +'@set Form.Left '+IntToStr(x)+' relative '+Caption+' ToolButtonFilePrinterSetup'+EOL
        +'@set Form.Top  '+IntToStr(y)+' relative '+Caption+' ToolButtonFilePrinterSetup'+EOL;
 if HasPrintersDialog(1,Params) then PrinterSetupDialog.Execute else Exit;
 ExecutePrinterPageSettingsDialog(Params);
 ReportPrinterSettings(1+2); // Echo + $PRINTER
 SetEnvironLpPageIndents;    // $LP_PAGE_INDENTS
end;

procedure TFormCrwDaq.ActionFileExitExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_User,ActionFileExit)<0 then Exit;
 Close;
end;

procedure TFormCrwDaq.ActionToolsCalculatorExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionToolsCalculator)<0 then Exit;
 ExecuteCalculator;
end;

procedure TFormCrwDaq.ActionToolsPlot2DExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionToolsPlot2D)<0 then Exit;
 NewCurveWindowByFormula;
end;

procedure TFormCrwDaq.ActionToolsPlot3DExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionToolsPlot3D)<0 then Exit;
 NewSurfWindowByFormulaDialog(ControlPosParams(ToolButtonToolsPlot3d,'BR',-550,4));
end;

procedure TFormCrwDaq.ActionToolsUartTerminalExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsUartTerminal)<0 then Exit;
 ExecuteUartTerminal;
end;

procedure TFormCrwDaq.ActionToolsPipeTermExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsPipeTerm)<0 then Exit;
 if ActionStdHandler(ActionToolsPipeTerm) then Exit;
end;

procedure TFormCrwDaq.ActionToolsWmqueryGuiExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsWmqueryGui)<0 then Exit;
 if ActionStdHandler(ActionToolsWmqueryGui) then Exit;
end;

procedure TFormCrwDaq.ActionToolsRegExpCalculatorExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsRegExpCalculator)<0 then Exit;
 OpenRegExpCalculator;
end;

procedure TFormCrwDaq.ActionToolsDatabaseBrowserExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsDatabaseBrowser)<0 then Exit;
 OpenDatabaseBrowser;
end;

procedure TFormCrwDaq.ActionToolsLogViewerExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsLogViewer)<0 then Exit;
 if ActionStdHandler(ActionToolsLogViewer) then Exit;
end;

procedure TFormCrwDaq.ActionToolsCalibDialogExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_User,ActionToolsCalibDialog)<0 then Exit;
 OpenFormCalibDialog(NewCalibration,true);
end;

procedure TFormCrwDaq.ActionWindowsSelectExecute(Sender: TObject);
var Form:TForm; sx,sy,Params:LongString;
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsSelect)<0 then Exit;
 sx:=IntToStr(0); sy:=IntToStr(ToolButtonWindowsSelect.Height);
 Params:='@set Panel.Font   Name:PT_Mono\Size:12\Color:Navy\Style:[Bold]'+EOL
        +'@set ListBox.Font Name:PT_Mono\Size:12\Color:Black\Style:[Bold]'+EOL
        +'@set Form.Left '+sx+' relative '+Caption+' ToolButtonWindowsSelect'+EOL
        +'@set Form.Top  '+sy+' relative '+Caption+' ToolButtonWindowsSelect'+EOL;
 Form:=SdiMan.SelectChildDialog(RusEng('Выбор окна',
                                       'Window selection'),
                                RusEng('Какое окно надо активизировать?',
                                       'Which window you want to select:'),
                                       sm_ZOrder,Params);
 if (Form is TFormCrwDaqSysChild) then begin
  SdiMan.ActivateChild(Form);
  if not Form.Visible then Form.Show;
  if (Form.WindowState=wsMinimized) then Form.WindowState:=wsNormal;
 end;
end;

procedure TFormCrwDaq.ActionWindowsHomeExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsSelect)<0 then Exit;
 try
  GoHome;
  SystemConsole.GoHome;
  SystemConsole.GoTail;
  SystemConsole.Activate;
  OpenFormDaqControlDialog;
  BringToFront; if CanSetFocus then SetFocus;
 except
  on E:Exception do BugReport(E,Self,'ActionWindowsHomeExecute');
 end;
end;

procedure TFormCrwDaq.ActionWindowsPrevExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsPrev)<0 then Exit;
 if SdiMan.IsMdiMode then Previous else SdiMan.ActivateChildNext(-1);
end;

procedure TFormCrwDaq.ActionWindowsNextExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsNext)<0 then Exit;
 if SdiMan.IsMdiMode then Next else SdiMan.ActivateChildNext(+1);
end;

procedure TFormCrwDaq.ActionWindowsTileExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsTile)<0 then Exit;
 if SdiMan.IsMdiMode then Tile;
end;

procedure TFormCrwDaq.ActionWindowsCascadeExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsCascade)<0 then Exit;
 if SdiMan.IsMdiMode then Cascade;
end;

procedure NormalizeForm(Form:TForm; Index:Integer; var Terminate:Boolean; Custom:Pointer);
begin
 if biMinimize in Form.BorderIcons then Form.WindowState:=wsNormal;
end;

procedure MinimizedForm(Form:TForm; Index:Integer; var Terminate:Boolean; Custom:Pointer);
begin
 if biMinimize in Form.BorderIcons then Form.WindowState:=wsMinimized;
end;

procedure TFormCrwDaq.SdiChildrenMinimizeOrRestore;
begin
 if (SdiMan.ChildList.Minimized=0) then SdiMan.ChildList.Minimize else SdiMan.ChildList.Restore;
 ActionWindowsMinimizeAll.Checked:=(SdiMan.ChildList.Minimized>0);
end;

procedure TFormCrwDaq.ActionWindowsMinimizeAllExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsMinimizeAll)<0 then Exit;
 SdiChildrenMinimizeOrRestore;
 Exit; // Skip obsolete
 if ActionWindowsMinimizeAll.Checked
 then SdiMan.ForEachChild(NormalizeForm,nil,false)
 else SdiMan.ForEachChild(MinimizedForm,nil,true);
 ActionWindowsMinimizeAll.Checked:=not ActionWindowsMinimizeAll.Checked;
end;

procedure TFormCrwDaq.ActionWindowsArrangeAllExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsArrangeAll)<0 then Exit;
 if SdiMan.IsMdiMode then ArrangeIcons else SdiChildrenMinimizeOrRestore;
end;

procedure TFormCrwDaq.ActionWindowsUpdateExecute(Sender: TObject);
var Form:TFormCrwDaqSysChild;
begin
 Form:=SdiMan.ActiveChild;
 if (Form is TFormCrwDaqSysChild) then Form.RefreshWindow;
end;

procedure TFormCrwDaq.MenuWindowsSelectorClick(Sender: TObject);
begin
 ActionWindowsSelectExecute(Sender);
end;

procedure TFormCrwDaq.ActionWindowsShowActiveExecute(Sender: TObject);
var Form:TFormCrwDaqSysChild;
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsShowActive)<0 then Exit;
 Form:=SdiMan.ActiveChild;
 if Assigned(Form)
 then SdiMan.ActivateChild(Form)
 else ActionWindowsSelectExecute(Sender);
end;

procedure TFormCrwDaq.ActionHelpIndexExecute(Sender: TObject);
var fname:LongString; const HELP_FINDER=11; // From Windows
begin
 fname:='';
 if Guard.CheckAction(ga_Guest,ActionHelpIndex)<0 then Exit;
 if SysGlossary.ReadIniPath(SysIniFile,SectSystem,'ModernHelpFile',HomeDir,fname) and FileExists(fname) then begin
  if WordIndex(ExtractFileExt(fname),'.htm;.html',ScanSpaces)>0 then begin
   SendToMainConsole('@silent @run '+fname+EOL);
  end else begin
   SmartExecute(UnifyFileAlias(fname),1,'open');
  end;
 end else Application.HelpCommand(HELP_FINDER,0);
end;

procedure TFormCrwDaq.ActionHelpAboutExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionHelpAbout)<0 then Exit;
 Echo(SysUtils.Trim(myGreetingBox+myFileVerInfo));
 //Application.HelpJump('Topic_About');
 SystemConsole.Activate;
 SystemConsole.GoHome;
 SystemConsole.GoTail;
end;

procedure TFormCrwDaq.ActionHelpCrwDaqDocExecute(Sender: TObject);
var fname:LongString;
begin
 if Guard.CheckAction(ga_Guest,ActionHelpCrwDaqDoc)<0 then Exit;
 try
  fname:='';
  if SysGlossary.ReadIniPath(SysIniFile,SectSystem,'CrwDaqDocIndex',HomeDir,fname) and FileExists(fname) then begin
   if WordIndex(ExtractFileExt(fname),'.htm;.html',ScanSpaces)>0 then begin
    SendToMainConsole('@silent @run '+fname+EOL);
   end else begin
    if not SmartExecute(fname,SW_SHOWNORMAL,'open')
    then Echo(Format(RusEng('Не могу открыть "%s".','Could not open "%s".'),[fname]));
   end;
  end else Echo(RusEng('Не могу найти файл индекса.','Could not find index file.'));
 except
  on E:Exception do BugReport(E,Self,'ActionHelpCrwDaqDocExecute');
 end;
end;

procedure TFormCrwDaq.ActionHelpHandBookExecute(Sender: TObject);
var fname:LongString;
begin
 if Guard.CheckAction(ga_Guest,ActionHelpHandBook)<0 then Exit;
 try
  fname:='';
  if SysGlossary.ReadIniPath(SysIniFile,SectSystem,'HandBookIndex',HomeDir,fname) and FileExists(fname) then begin
   if WordIndex(ExtractFileExt(fname),'.htm;.html',ScanSpaces)>0 then begin
    SendToMainConsole('@silent @run '+fname+EOL);
   end else begin
    if not SmartExecute(fname,SW_SHOWNORMAL,'open')
    then Echo(Format(RusEng('Не могу открыть "%s".','Could not open "%s".'),[fname]));
   end;
  end else Echo(RusEng('Не могу найти файл справочника.','Could not find handbook file.'));
 except
  on E:Exception do BugReport(E,Self,'ActionHelpHandBookExecute');
 end;
end;

procedure TFormCrwDaq.ActionDaqExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionDaq)<0 then Exit;
 OpenFormDaqControlDialog;
end;

procedure TFormCrwDaq.ActionDaqDeviceExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionDaqDevice)<0 then Exit;
 SendToMainConsole('@silent @menu run FormDaqControlDialog.ActionDaqDevice'+EOL);
end;

procedure TFormCrwDaq.ActionDaqNavigatorExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionDaqNavigator)<0 then Exit;
 SendToMainConsole('@silent @menu run FormDaqControlDialog.ActionDaqNavigator'+EOL);
end;

procedure TFormCrwDaq.ActionToolsRecodeCodePageExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsRecodeCodePage)<0 then Exit;
 FormRecodeCodePageDialogExecute;
end;

procedure TFormCrwDaq.ActionToolsRfaMendeleevTableExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionToolsRfaMendeleevTable)<0 then Exit;
 FormRfaMendeleevTableExecute;
end;

procedure TFormCrwDaq.ActionToolsKeyBoardLayoutExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionToolsKeyBoardLayout)<0 then Exit;
 if Ok then
 try
  ActionToolsKeyBoardLayout.Checked:=not ActionToolsKeyBoardLayout.Checked;
 except
  on E:Exception do BugReport(E,Self);
 end;
end;

function ActionStdHandler(Action:TAction):Boolean;
var cmd:LongString;
begin
 Result:=false;
 try
  cmd:='';
  if Assigned(Action) then begin
   cmd:=SysGlossary.ReadIniParamDef(SysIniFile,SectActionList(1),Action.Name,'');
   if (cmd<>'') then cmd:=cmd+EOL;
  end;
  if (cmd<>'') then begin
   if (SendToMainConsole(cmd)>0)
   then Result:=true;
  end;
 except
  on E:Exception do BugReport(E,nil,'ActionStdHandler');
 end;
end;

procedure TFormCrwDaq.ActionToolsDimGuiExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsDimGui)<0 then Exit;
 if ActionStdHandler(ActionToolsDimGui) then Exit;
 if IsUnix then SendToMainConsole('@silent @run crwkit dim-cpl menu'+EOL);
 if IsWindows then SendToMainConsole('@silent @run -cd %Temp% /sw7 dim gui'+EOL);
end;

procedure TFormCrwDaq.ActionToolsDimTreeExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsDimTree)<0 then Exit;
 if ActionStdHandler(ActionToolsDimTree) then Exit;
 if IsUnix then SendToMainConsole('@silent @run crwkit DimTree'+EOL);
 if IsWindows then SendToMainConsole('@silent @run -cd %Temp% DimTree'+EOL);
end;

procedure TFormCrwDaq.ActionToolsOpcuaCplExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsOpcuaCpl)<0 then Exit;
 if ActionStdHandler(ActionToolsOpcuaCpl) then Exit;
 if IsUnix then SendToMainConsole('@silent @run crwkit opcua-cpl menu'+EOL);
 if IsWindows then SendToMainConsole('@silent @run -cd ~~ -sw7 resource\shell\opcua-cpl.bat'+EOL);
end;

procedure TFormCrwDaq.ActionToolsExplorerExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsExplorer)<0 then Exit;
 if ActionStdHandler(ActionToolsExplorer) then Exit;
 if IsUnix then SendToMainConsole('@silent @run -app "-c fly-fm -t inode/directory"'+EOL);
 if IsWindows then SendToMainConsole('@silent @run -cd .. explorer'+EOL);
end;

procedure TFormCrwDaq.ActionToolsFileManagerExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsFileManager)<0 then Exit;
 if ActionStdHandler(ActionToolsFileManager) then Exit;
 if IsUnix then SendToMainConsole('@silent @run $WantedFileManager'+EOL);
 if IsWindows then SendToMainConsole('@silent @run -cd .. filemanager'+EOL);
end;

procedure TFormCrwDaq.ActionToolsTerminalExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsTerminal)<0 then Exit;
 if ActionStdHandler(ActionToolsTerminal) then Exit;
 if IsUnix then SendToMainConsole('@silent @run x-terminal-emulator'+EOL);
 if IsWindows then SendToMainConsole('@silent @run cmd'+EOL);
end;

procedure TFormCrwDaq.ActionToolsTaskmgrExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsTaskmgr)<0 then Exit;
 if ActionStdHandler(ActionToolsTaskmgr) then Exit;
 if IsUnix then SendToMainConsole('@silent @run ksysguard'+EOL);
 if IsWindows then SendToMainConsole('@silent @run -cd %Temp% taskmgr.exe'+EOL);
end;

function FindRootExe:LongString;
begin
 Result:='';
 if IsWindows then begin
  Result:=SmartFileSearch('root.exe',DefaultPathVarStr);
  if not FileExists(Result) then Result:=ExtractWord(1,ReadRegistryString(
         HKEY_CLASSES_ROOT,'ROOTDEV.ROOT\shell\open\command',''),ScanSpaces);
  if not FileExists(Result) then Result:='';
 end;
 if IsUnix then begin
  if not RunCommand('unix which root',Result) then Result:='';
  Result:=TrimDef(Result,'/opt/crwkit/add/bin/root');
  if not FileExists(Result) then Result:='';
 end;
end;

procedure TFormCrwDaq.ActionToolsRootExecute(Sender: TObject);
var RootExe:LongString;
begin
 if Guard.CheckAction(ga_User,ActionToolsRoot)<0 then Exit;
 if ActionStdHandler(ActionToolsRoot) then Exit;
 RootExe:=FindRootExe;
 if IsEmptyStr(RootExe) then begin
  Echo(RusEng('Не найден root. Попробуйте загрузить с сайта.',
              'Not found root. Please download from Web site.'));
  SendToMainConsole('@silent @run WebBrowser http://root.cern/'+EOL);
 end else SendToMainConsole('@silent @run '+IfThen(IsWindows,RootExe+' -l','xterm -e unix root')+EOL);
end;

function FindGnuPlotExe:LongString;
begin
 Result:='';
 if IsWindows then begin
  if IsEmptyStr(Result) then Result:=SmartFileSearch('gnuplot.exe',DefaultPathVarStr);
  if IsEmptyStr(Result) then Result:=SmartFileSearch('wgnuplot.exe',DefaultPathVarStr);
  if not FileExists(Result) then Result:='';
 end;
 if IsUnix then begin
  if IsEmptyStr(Result) then Result:=SmartFileSearch('gnuplot',DefaultPathVarStr);
  if not FileExists(Result) then Result:='';
 end;
end;

procedure TFormCrwDaq.ActionToolsGnuplotExecute(Sender: TObject);
var GnuPlotExe:LongString;
begin
 if Guard.CheckAction(ga_User,ActionToolsGnuplot)<0 then Exit;
 if ActionStdHandler(ActionToolsGnuplot) then Exit;
 GnuPlotExe:=FindGnuPlotExe;
 if IsEmptyStr(GnuPlotExe) then begin
  Echo(RusEng('Не найден gnuplot. Попробуйте загрузить с сайта.',
              'Not found gnuplot. Please download from Web site.'));
  SendToMainConsole('@silent @run WebBrowser http://gnuplot.sourceforge.net/'+EOL);
 end else SendToMainConsole('@silent @run -cd '
          +FExpand(AddBackSlash(ExtractFilePath(GnuPlotExe))+'..\demo\')
          +' '+GnuPlotExe+EOL);
end;

procedure TFormCrwDaq.ActionToolsMousePosExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsMousePos)<0 then Exit;
 if ActionStdHandler(ActionToolsMousePos) then Exit;
 SendToMainConsole('@silent @run -cd %Temp% %CRW_DAQ_SYS_HOME_DIR%\Resource\Tools\MousePos\MousePos.exe'+EOL);
end;

procedure TFormCrwDaq.ActionToolsConsoleUtilitiesExecute(Sender: TObject);
var Menu:TText; i:Integer; lm9,cmd:LongString;
const Item:Integer=0;
begin
 if Guard.CheckAction(ga_Root,ActionToolsConsoleUtilities)<0 then Exit;
 if Ok then
 try
  lm9:='';
  if MenuToolsConsoleUtilitiesMode.Checked and MenuToolsConsoleUtilitiesMode.Enabled and HasDieselPascalExe then
  if SysGlossary.ReadIniPath(SysIniFile,SectSystem,'ToolbarConsoleUtilsCmnd',HomeDir,lm9) then if FileExists(lm9) then begin
   if ActionStdHandler(ActionToolsConsoleUtilities) then Exit;
   if IsWindows then cmd:='@silent @run -sw7 cmd /c start "Crw32 Console Utils" '+DoubleQuotedStr(lm9) else
   if IsUnix then cmd:='@silent @run -app "-e CrossMachine -t application/x-diesel -a .lm9" '+DoubleQuotedStr(lm9) else cmd:='';
   if (cmd<>'') then SendToMainConsole(cmd+EOL);
   Exit;
  end;
  Menu:=ExtractListSection(SysIniFile,SectConsoleUtilities(1),efLTrim+efRTrim+efDelCom);
  try
   for i:=Menu.Count-1 downto 0 do if Pos(':',Menu[i])=0 then Menu.DelLn(i);
   if ListBoxSelection(RusEng('Консольные утилиты','Console utilities'),
                       'crwdaq.ini [ConsoleUtilities]',Menu.Text,Item)=mrOk
   then SendToMainConsole(StringReplace(Trim(Copy(Menu[Item],Pos(':',Menu[Item])+1,MaxInt)),'|',EOL,[rfReplaceAll])+EOL);
  finally
   Kill(Menu);
  end;
 except
  on E:Exception do BugReport(E,Self);
 end;
end;

procedure TFormCrwDaq.ActionToolsConsoleUtilitiesModeExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsConsoleUtilitiesMode)<0 then Exit;
 MenuToolsConsoleUtilitiesMode.Checked:=not MenuToolsConsoleUtilitiesMode.Checked;
 UpdateMenuToolsConsoleUtilitiesModeCaption;
end;

procedure TFormCrwDaq.UpdateMenuToolsConsoleUtilitiesModeCaption;
begin
 if MenuToolsConsoleUtilitiesMode.Checked
 then MenuToolsConsoleUtilitiesMode.Caption:=RusEng('Внешние утилиты разрешены.','External utilities enabled.')
 else MenuToolsConsoleUtilitiesMode.Caption:=RusEng('Внешние утилиты запрещены.','External utilities disabled.');
end;

procedure TFormCrwDaq.ActionToolsCustomCommand0Execute(Sender: TObject);
begin
 if Guard.CheckAction(ga_User,ActionToolsCustomCommand0)<0 then Exit;
 if ActionStdHandler(ActionToolsCustomCommand0) then Exit;
end;

procedure TFormCrwDaq.ActionToolsCustomCommand1Execute(Sender: TObject);
begin
 if Guard.CheckAction(ga_User,ActionToolsCustomCommand1)<0 then Exit;
 if ActionStdHandler(ActionToolsCustomCommand1) then Exit;
end;

procedure TFormCrwDaq.ActionToolsCustomCommand2Execute(Sender: TObject);
begin
 if Guard.CheckAction(ga_User,ActionToolsCustomCommand2)<0 then Exit;
 if ActionStdHandler(ActionToolsCustomCommand2) then Exit;
end;

procedure TFormCrwDaq.ActionToolsCustomCommand3Execute(Sender: TObject);
begin
 if Guard.CheckAction(ga_User,ActionToolsCustomCommand3)<0 then Exit;
 if ActionStdHandler(ActionToolsCustomCommand3) then Exit;
end;

procedure TFormCrwDaq.ActionToolsCustomCommand4Execute(Sender: TObject);
begin
 if Guard.CheckAction(ga_User,ActionToolsCustomCommand4)<0 then Exit;
 if ActionStdHandler(ActionToolsCustomCommand4) then Exit;
end;

procedure TFormCrwDaq.ActionToolsCustomCommand5Execute(Sender: TObject);
begin
 if Guard.CheckAction(ga_User,ActionToolsCustomCommand5)<0 then Exit;
 if ActionStdHandler(ActionToolsCustomCommand5) then Exit;
end;

procedure TFormCrwDaq.ActionToolsCustomCommand6Execute(Sender: TObject);
begin
 if Guard.CheckAction(ga_User,ActionToolsCustomCommand6)<0 then Exit;
 if ActionStdHandler(ActionToolsCustomCommand6) then Exit;
end;

procedure TFormCrwDaq.ActionToolsCustomCommand7Execute(Sender: TObject);
begin
 if Guard.CheckAction(ga_User,ActionToolsCustomCommand7)<0 then Exit;
 if ActionStdHandler(ActionToolsCustomCommand7) then Exit;
end;

procedure TFormCrwDaq.ActionToolsCustomCommand8Execute(Sender: TObject);
begin
 if Guard.CheckAction(ga_User,ActionToolsCustomCommand8)<0 then Exit;
 if ActionStdHandler(ActionToolsCustomCommand8) then Exit;
end;

procedure TFormCrwDaq.ActionToolsCustomCommand9Execute(Sender: TObject);
begin
 if Guard.CheckAction(ga_User,ActionToolsCustomCommand9)<0 then Exit;
 if ActionStdHandler(ActionToolsCustomCommand9) then Exit;
end;

procedure TFormCrwDaq.ActionToolsCustomCommandEditorExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Root,ActionToolsCustomCommandEditor)<0 then Exit;
 if ActionStdHandler(ActionToolsCustomCommandEditor) then Exit;
end;

procedure TFormCrwDaq.ActionWindowsOpenSystemConsoleExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsOpenSystemConsole)<0 then Exit;
 SystemConsole.Activate;
 SystemConsole.GoHome;
 SystemConsole.GoTail;
end;

procedure TFormCrwDaq.ActionWindowsOpenResourceMonitorConsoleExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsOpenResourceMonitorConsole)<0 then Exit;
 OpenResourceMonitorConsole;
end;

procedure TFormCrwDaq.ActionWindowsWatchDogControlExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsWatchDogControl)<0 then Exit;
 OpenFormCrwDaqWatchDog(true,ControlPosParams(ToolButtonWindowsWatchDogControl,'BR',-250,4));
end;

procedure TFormCrwDaq.ActionWindowsMistimingServiceExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsMistimingService)<0 then Exit;
 OpenFormMistimingService(true,ControlPosParams(ToolButtonWindowsMistimingService,'BR',-350,4));
 SecondActions.Add(CheckMistiming);
end;

procedure TFormCrwDaq.ActionWindowsToggleMainMenuExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsToggleMainMenu)<0 then Exit;
 if Ok then
 try
  if Assigned(Menu) then Menu:=nil else Menu:=MainMenu;
 except
  on E:Exception do BugReport(E,Self);
 end;
end;

procedure TFormCrwDaq.ActionWindowsToggleToolBarExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsToggleToolBar)<0 then Exit;
 if Ok then
 try
  ToolBar.Visible:=not ToolBar.Visible;
 except
  on E:Exception do BugReport(E,Self);
 end;
end;

procedure TFormCrwDaq.ActionWindowsToggleStatusBarExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsToggleStatusBar)<0 then Exit;
 if Ok then
 try
  StatusBar.Visible:=not StatusBar.Visible;
 except
  on E:Exception do BugReport(E,Self);
 end;
end;

procedure TFormCrwDaq.ActionWindowsToggleHideIconicSdiChildrenExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsToggleHideIconicSdiChildren)<0 then Exit;
 if Ok then
 try
  ActionWindowsToggleHideIconicSdiChildren.Checked:=not ActionWindowsToggleHideIconicSdiChildren.Checked;
  SdiMan.ForEachChild(DoHideIconicSdiChildren,PtrIntToPointer(Ord(ActionWindowsToggleHideIconicSdiChildren.Checked)));
 except
  on E:Exception do BugReport(E,Self,'ActionWindowsToggleHideSdiIconicChildrenExecute');
 end;
end;

procedure TFormCrwDaq.ActionWindowsToggleAwakeModalExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionWindowsToggleAwakeModal)<0 then Exit;
 if Ok then
 try
  ActionWindowsToggleAwakeModal.Checked:=not ActionWindowsToggleAwakeModal.Checked;
  AppModal.Started:=ActionWindowsToggleAwakeModal.Checked;
 except
  on E:Exception do BugReport(E,Self,'ActionWindowsToggleAwakeModalExecute');
 end;
end;

procedure TFormCrwDaq.ActionWindowsSecretServiceExecute(Sender: TObject);
begin
 OpenFormSecretService(true);
end;

procedure TFormCrwDaq.ActionWindowsResetGuardExecute(Sender: TObject);
begin
 if Guard.Level>ga_Lock then begin
  Guard.Level:=Guard.Level-1;
  if (Guard.Level=ga_Lock) then ShowLockWarning;
 end;
end;

function TFormCrwDaq.CommonOpenDialogExecute(const aTitle,aFileName,aFilter:LongString; Params:LongString):LongString;
begin
 Result:='';
 if Ok then
 try
  Params:=Trim(Params);
  if not UseEditSettings then Params:='';
  CommonOpenDialog.Title:=aTitle;
  if IsEmptyStr(aFilter)
  then CommonOpenDialog.Filter:=RusEng('Все файлы (*.*)|*.*|','All files (*.*)|*.*|')
  else CommonOpenDialog.Filter:=StringReplace(aFilter,EOL,'',[rfReplaceAll]);
  if IsEmptyStr(aFileName)
  then CommonOpenDialog.FileName:=''
  else CommonOpenDialog.FileName:=UnifyFileAlias(aFileName);
  if IsEmptyStr(CommonOpenDialog.FileName)
  then OpenDialogSelectType(CommonOpenDialog,'*.*')
  else OpenDialogSelectType(CommonOpenDialog,CommonOpenDialog.FileName);
  if ExecuteFileDialog(GuardOpenDialog(CommonOpenDialog),Params) then begin
   Result:=CommonOpenDialog.Files.Text;
   mrVoice(mrOk);
  end else mrVoice(mrCancel);
 except
  on E:Exception do BugReport(E,Self,'CommonOpenDialogExecute');
 end;
end;

procedure SelectDirectoryDialogPosUpdate;
var wnd:HWND; R:TRect; Pos:TPoint; Pid:TPid;
var wClass,wTitle,arg,sg,sx,sy,sw,sh:LongString; gravity:Integer;
begin
 if (FormCrwDaq<>nil) then with FormCrwDaq do
 try
  Pos:=myDirPos; R:=Default(TRect);
  if (myDirCls<>'') and (myDirTit<>'') and ((Pos.x<>Low(Integer)) or (Pos.y<>Low(Integer))) then begin
   Pid:=GetCurrentProcessId; wClass:=myDirCls; wTitle:=myDirTit;
   wnd:=wmctrl.FindWindow(Pid,wClass,wTitle);
   if (wnd<>0) and (myDirCap<>wmctrl.WindowTitle(wnd))
   then wmctrl.SetWindowTitle(wnd,myDirCap);
   if not wmctrl.IsWindow(wnd) then Exit;
   R:=wmctrl.WindowBounds(wnd);
   if R.IsEmpty then Exit;
   gravity:=0;
   sg:=IntToStr(gravity);
   sx:=IntToStr(Pos.x);
   sy:=IntToStr(Pos.y);
   sw:=IntToStr(R.Width);
   sh:=IntToStr(R.Height);
   if (Pos.x=Low(Integer)) then sx:='*';
   if (Pos.y=Low(Integer)) then sy:='*';
   arg:=Format('%s,%s,%s,%s,%s',[sg,sx,sy,sw,sh]);
   if not wmctrl.MoveResizeWindow(wnd,arg) then Exit;
   Pid:=0; Pos:=Point(0,0); wClass:=''; wTitle:='';
   myDirPos:=Point(Low(Integer),Low(Integer));
  end;
 except
  on E:Exception do BugReport(E,nil,'SelectDirectoryDialogPosUpdate');
 end;
end;

function TFormCrwDaq.CommonSelectDirectoryDialog(const aTitle,aDir,aOptions:LongString; Params:LongString):LongString;
var aCaption,aRoot:LongString; aDirectory:String; sd:TSelectDirOpts;
begin
 Result:='';
 if Ok then
 try
  Params:=Trim(Params);
  if not UseEditSettings then Params:='';
  myDirPos:=Point(Low(Integer),Low(Integer));
  try
   myDirCap:=TrimDef(aTitle,'Select Directory');
   myDirCls:='';myDirTit:='';
   if (Params<>'') then begin
    myDirPos:=MessageDlgApplyParamsPos(Params);
    Tick55Actions.Add(SelectDirectoryDialogPosUpdate);
   end;
   aDirectory:=UnifyFileAlias(aDir);
   aDirectory:=GetRealFilePathName(aDirectory);
   aCaption:=aTitle; aRoot:=aDirectory; sd:=[];
   if (WordIndex('sdPrompt',aOptions,ScanSpaces)>0) then sd:=sd+[sdPrompt];
   if (WordIndex('sdAllowCreate',aOptions,ScanSpaces)>0) then sd:=sd+[sdAllowCreate];
   if (WordIndex('sdPerformCreate',aOptions,ScanSpaces)>0) then sd:=sd+[sdPerformCreate];
   if IsEmptyStr(aOptions) then begin
    myDirCls:=IfThen(IsUnix,wmctrl.IcccmClass,swc_DialogBox);
    myDirTit:=IfThen(GetACP=1251,'Обзор папок','Browse for Folder');
    myDirTit:=IfThen(IsUnix,aTitle,myDirTit);
    myDirTit:=IfThen(IsFpc,aTitle,myDirTit);
    if SelectDirectory(aCaption,aRoot,aDirectory) then begin
     Result:=aDirectory; mrVoice(mrOk);
    end else mrVoice(mrCancel);
   end else begin
    myDirCls:=IfThen(IsFpc,swc_DialogBox,'TSelectDirDlg');
    myDirCls:=IfThen(IsUnix,wmctrl.IcccmClass,myDirCls);
    myDirTit:='Select Directory';
    if SelectDirectory(aDirectory,sd,0) then begin
     Result:=aDirectory; mrVoice(mrOk);
    end else mrVoice(mrCancel);
   end;
  finally
   myDirCap:='';
   myDirCls:='';myDirTit:='';
   if (Params<>'') then begin
    myDirPos:=Point(Low(Integer),Low(Integer));
    Tick55Actions.Remove(SelectDirectoryDialogPosUpdate);
   end;
  end;
 except
  on E:Exception do BugReport(E,Self,'SelectDirectoryDialog');
 end;
end;

procedure OpenWinHelpTopicOnUnix(Topic:LongString);
var FName:LongString;
begin
 FName:='';
 if ReadIniFilePath(SysIniFile,SectSystem,Topic,HomeDir,FName) then begin
  SendToMainConsole('@run wine winhlp32.exe '+FName+EOL);
 end;
end;

procedure TFormCrwDaq.ActionHelpDelphiExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionHelpDelphi)<0 then Exit;
 {$IFDEF WINDOWS}
 if Ok then OpenWinHelpTopicByLink(HomeDir,SysIniFile,SectSystem,'DelphiHelpFile');
 {$ENDIF ~WINDOWS}
 {$IFDEF UNIX}
 OpenWinHelpTopicOnUnix('DelphiHelpFile');
 {$ENDIF ~UNIX}
end;

procedure TFormCrwDaq.ActionHelpWin32SdkExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionHelpWin32Sdk)<0 then Exit;
 {$IFDEF WINDOWS}
 if Ok then OpenWinHelpTopicByLink(HomeDir,SysIniFile,SectSystem,'Win32SdkHelpFile');
 {$ENDIF ~WINDOWS}
 {$IFDEF UNIX}
 OpenWinHelpTopicOnUnix('Win32SdkHelpFile');
 {$ENDIF ~UNIX}
end;

procedure TFormCrwDaq.ActionHelpFpcupExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionHelpFpcup)<0 then Exit;
 with Fpcup do LazHelp(IniFileLazIndex,'');
end;

procedure TFormCrwDaq.ActionToolsVoicePresetExecute(Sender: TObject);
begin
 if Guard.CheckAction(ga_Guest,ActionToolsVoicePreset)<0 then Exit;
 if Ok then FormVoicePresetExecute(false,ControlPosParams(ToolBar,'BT'));
end;

procedure TFormCrwDaq.ActionLinkExecute(Sender: TObject);
var s,exe,verb:LongString; isweb,iseml,ishome,isdir,istxt,userun:Boolean;
begin
 if Guard.CheckAction(ga_Root,Self.ClassName+'.ActionLink')<0 then Exit;
 if Ok then
 try
  userun:=true;
  s:=''; exe:=''; verb:='';
  if Sender is TAction then begin
   s:=Trim((Sender as TAction).Caption);
   if (WordIndex(ExtractFileExt(s),'.exe;.cmd;.bat',ScanSpaces)>0) and not IsWindows then begin
    SendToMainConsole('@silent @echo '+RusEng('Эта программа только для','This program only for')+' Windows: '+ExtractFileNameExt(s)+EOL);
    SendToMainConsole('@silent @voice fails'+EOL);
    Exit;
   end;
   ishome:=StartsWithTwinTildeDir(s);
   if ishome then s:=ReplaceTwinTildeDir(s,HomeDir);
   if ishome then s:=UnifyFileAlias(AdaptFileName(s));
   iseml:=(Pos('mailto:',s)>0) or HasListedExtension(s,'.eml');
   isdir:=ishome and (StrFetch(s,Length(s)) in ['\','/']) and DirExists(s);
   isweb:=(Pos('http://',s)>0) or (Pos('https://',s)>0) or HasListedExtension(s,'.htm;.html;.url;.md;.mkd;.markdown',';');
   istxt:=ishome and HasListedExtension(s,'.ini;.txt;.cfg;.crc;.sml',';');
   if isdir then exe:=AnsiQuotedIfNeed(GetEnv('WantedFileManager'));
   if isweb then exe:=AnsiQuotedIfNeed(GetEnv('WantedHtmlBrowser'));
   if iseml then exe:=AnsiQuotedIfNeed(GetEnv('WantedEmlClient'));
   if istxt then exe:=AnsiQuotedIfNeed(GetEnv('WantedTxtEditor'));
   if IsEmptyStr(exe) then verb:='open' else exe:=exe+' ';
   if userun then SendToMainConsole('@silent @run '+exe+s+EOL) else SmartExecute(exe+s,1,verb);
  end;
 except
  on E:Exception do BugReport(E,Self,'ActionLinkExecute');
 end;
end;

procedure TFormCrwDaq.ActionTrayExitExecute(Sender: TObject);
begin
 if not Ok then Exit;
 if ActionFileExit.Enabled then ActionFileExit.Execute;
end;

procedure TFormCrwDaq.ActionTrayRestoreExecute(Sender: TObject);
begin
 if not Ok then Exit;
 if (wmctrl.DesktopCount>1) then wmctrl.SwitchToDesktop(WmDesktop);
 Application.Restore;
 if Assigned(ApplicationMainForm)
 then ApplicationMainForm.BringToFront;
 if AppModal.Started then AppModal.AwakeModalWindows;
end;

procedure TFormCrwDaq.ActionTrayOnAppRestoreExecute(Sender: TObject);
begin
 if not Ok then Exit;
 Application.QueueAsyncCall(OnAsyncAppRestore,0);
 if AppModal.Started then AppModal.AwakeModalWindows;
end;

procedure TFormCrwDaq.OnAsyncAppRestore(Data:PtrInt);
begin
 if not Ok then Exit;
 if SdiMan.IsSdiMode then SdiMan.ChildList.MinimizeByFlags(sf_SdiNoRestore);
end;

procedure TFormCrwDaq.ActionTrayMinimizeExecute(Sender: TObject);
begin
 if not Ok then Exit;
 Application.Minimize;
end;

procedure TFormCrwDaq.ActionTrayTurnOnExecute(Sender: TObject);
begin
 if not Ok then Exit;
 if TrayIconMain.Visible then Exit;
 ShowTrayIcon(true);
end;

procedure TFormCrwDaq.ActionTrayTurnOffExecute(Sender: TObject);
begin
 if not Ok then Exit;
 if not TrayIconMain.Visible then Exit;
 ShowTrayIcon(false);
end;

procedure TFormCrwDaq.TrayIconMainClick(Sender: TObject);
begin
 if not Ok then Exit;
 if TrayIconPopupOnClick
 then PopupMenuTray.PopUp
 else ActionTrayRestore.Execute;
end;

procedure TFormCrwDaq.TrayIconMainDblClick(Sender: TObject);
begin
 if not Ok then Exit;
 ActionTrayRestore.Execute;
end;

procedure TFormCrwDaq.UpdateTrayIconCaptions;
var exe:LongString;
begin
 if Ok then
 try
  if TrayIconMain.Visible then begin
   exe:=ExtractFileNameExt(ProgName);
   TrayIconMain.Hint:=LowerCase(exe)+EOL+Caption;
   ActionTrayExit.Caption:=RusEng('Завершить работу ','Exit program ')+Caption;
   ActionTrayExit.Hint:=RusEng('Завершить Сеанс Программы ','Exit Session of Program ')+Caption;
   ActionTrayRestore.Caption:=RusEng('Показать окна ','Restore window ')+Caption;
   ActionTrayRestore.Hint:=RusEng('Показать (развернуть) окна ','Restore (show) windows of ')+Caption;
   ActionTrayMinimize.Caption:=RusEng('Свернуть окна ','Minimize windows of ')+Caption;
   ActionTrayMinimize.Hint:=RusEng('Свернуть все окна программы ','Minimize all forms of the program ')+Caption;
   ActionTrayTurnOn.Caption:=RusEng('Показать в Уведомлениях','Show Tray Icon');
   ActionTrayTurnOn.Hint:=RusEng('Показать программу в Области Уведомлений.','Show program Tray Icon.');
   ActionTrayTurnOff.Caption:=RusEng('Убрать из Уведомлений','Hide Tray Icon');
   ActionTrayTurnOff.Hint:=RusEng('Убрать программу из Области Уведомлений.','Remove program Tray Icon.');
  end;
 except
  on E:Exception do BugReport(E,Self,'UpdateTrayIconCaptions');
 end;
end;

// Hide Application icon from TaskBar. To use with TrayIcon.
procedure HideApplicationIconFromTaskBar(Hide:Boolean); forward;
procedure HandlePendingHideApplicationIconFromTaskBar; forward;
var LastPendingHideApplicationIconFromTaskBar:Integer=0;

procedure HideApplicationIconFromTaskBar(Hide:Boolean);
var GWL:Integer; wnd:HWND; Form:TForm;
begin
 if IsWindows then begin
  {$IFDEF WINDOWS}
  {$PUSH}
  {$WARN 5044 off : Symbol "$1" is not portable}
  GWL:=Windows.GetWindowLong(Application.Handle,GWL_EXSTYLE);
  if (Hide)
  then GWL:=GWL OR WS_EX_TOOLWINDOW AND NOT WS_EX_APPWINDOW
  else GWL:=GWL OR WS_EX_APPWINDOW AND NOT WS_EX_TOOLWINDOW;
  Windows.SetWindowLong(Application.Handle,GWL_EXSTYLE,GWL);
  {$POP}
  {$ELSE}
  GWL:=0;
  FakeNOP(GWL);
  {$ENDIF ~WINDOWS}
  LastPendingHideApplicationIconFromTaskBar:=0;
 end else
 if IsUnix then begin
  Form:=ApplicationMainForm;
  if not Assigned(Form) then Exit;
  if (Form is TMasterForm)
  then wnd:=TMasterForm(Form).WmWnd
  else wnd:=wmctrl.FindWindow(GetCurrentProcessId,wmctrl.IcccmClass,Form.Caption);
  if (wnd=0) then Exit;
  if Hide
  then wmctrl.SetWindowStateFlags(wnd,wsc_add,WSF_SKIP_TASKBAR)
  else wmctrl.SetWindowStateFlags(wnd,wsc_remove,WSF_SKIP_TASKBAR);
  if Hide
  then LastPendingHideApplicationIconFromTaskBar:=+1
  else LastPendingHideApplicationIconFromTaskBar:=-1;
  if not SecondActions.HasAction(HandlePendingHideApplicationIconFromTaskBar)
  then SecondActions.Add(HandlePendingHideApplicationIconFromTaskBar);
 end;
end;

procedure HandlePendingHideApplicationIconFromTaskBar;
begin
 if (LastPendingHideApplicationIconFromTaskBar<>0) then begin
  HideApplicationIconFromTaskBar(LastPendingHideApplicationIconFromTaskBar>0);
  LastPendingHideApplicationIconFromTaskBar:=0;
 end;
end;

procedure Timer_CheckTrayExitEnabled;
var Curr,Want:Boolean;
begin
 if Assigned(FormCrwDaq) then
 if FormCrwDaq.TrayIconMain.Visible then begin
  Want:=not Daq.Timer.isStart;
  Curr:=FormCrwDaq.ActionTrayExit.Enabled;
  if Want and (FormCrwDaq.CloseQueryCount>0) then Want:=false;
  if Want and (AppModal.ApplicationModalLevel>0) then Want:=false;
  if Want and (FormCrwDaq.WindowState=wsMinimized) then Want:=false;
  if Want and (wmctrl.DesktopCount>1) and (FormCrwDaq.WmDesktop<>wmctrl.ActiveDesktop) then Want:=false;
  if (Curr<>Want) then FormCrwDaq.ActionTrayExit.Enabled:=Want;
 end;
end;

procedure TFormCrwDaq.ShowTrayIcon(aShow:Boolean);
begin
 if Ok then
 try
  if aShow then begin
   TrayIconMain.Visible:=true;
   HideApplicationIconFromTaskBar(true);
   UpdateTrayIconCaptions;
   SecondActions.Add(Timer_CheckTrayExitEnabled);
  end else begin
   TrayIconMain.Visible:=false;
   HideApplicationIconFromTaskBar(false);
   SecondActions.Remove(Timer_CheckTrayExitEnabled);
  end;
 except
  on E:Exception do BugReport(E,Self,'ShowTrayIcon');
 end;
end;

procedure TFormCrwDaq.MenuCopyrightProofClick(Sender: TObject);
var fname:LongString;
begin
 if Guard.CheckAction(ga_Guest,Self.ClassName+'.MenuCopyrightProof')<0 then Exit;
 if Ok then
 try
  fname:='';
  if SysGlossary.ReadIniPath(SysIniFile,SectSystem,'CopyrightProof',HomeDir,fname)
  then SmartExecute(DefaultPath(fname,HomeDir),1,'open');
  Echo(SysUtils.Trim(myGreetingBox+myFileVerInfo));
  SystemConsole.Activate;
  SystemConsole.GoHome;
  SystemConsole.GoTail;
 except
  on E:Exception do BugReport(E,Self,'MenuCopyrightProofClick');
 end;
end;

procedure TFormCrwDaq.UpdateActionLinksState;
var i:Integer; Action:TAction; fn,ida:LongString;
begin
 if Ok then
 try
  ida:=ActionLinkHome.Name;
  for i:=0 to ActionList.ActionCount-1 do begin
   if (ActionList.Actions[i] is TAction)
   then Action:=(ActionList.Actions[i] as TAction)
   else Action:=nil;
   if (Action<>nil) then
   if SameText(Copy(Action.Name,1,Length(ida)),ida) then begin
    if StartsWithTwinTildeDir(Action.Caption) then begin
     fn:=ReplaceTwinTildeDir(Action.Caption,HomeDir);
     fn:=UnifyFileAlias(AdaptFileName(fn));
     if (@Action.OnExecute<>@ActionLinkHome.OnExecute) then Action.Enabled:=false;
     if Action.Enabled and not (FileExists(fn) or DirExists(fn)) then Action.Enabled:=false;
    end;
   end;
  end;
 except
  on E:Exception do BugReport(E,Self,'UpdateActionLinksState');
 end;
end;

procedure TFormCrwDaq.UpdateTitle(const aTitle:LongString);
var s:LongString;
begin
 if Ok then
 if (aTitle<>'') then
 try
  Caption:=aTitle;
  s:=SysUtils.ExtractFileName(ParamStr(0))+EOL+aTitle;
  if (Application.Title<>s) then begin
   Application.Title:=s;
   UpdateTrayIconCaptions;
  end;
 except
  on E:Exception do BugReport(E,Self,'UpdateTitle');
 end;
end;

procedure TFormCrwDaq.GoHome;
const DefSize:TPoint2I=(x:0;y:0);
const DefPos:TPoint2I=(x:0;y:0);
var act:LongString;
begin
 if Assigned(Self) then
 try
  act:='';
  if IsMainThread then begin
   if ReadIniFileString(SysIniFile,SectSystem(1),'Action:FormCrwDaq.GoHome%s',act,efConfigNC,svConfigNC) then begin
    if IsLexeme(act,lex_AtCmnd) then begin
     SendToMainConsole('@silent '+act+EOL);
     Exit;
    end;
   end;
   if (DefSize.x<=0) or (DefSize.y<=0) then begin
    if not ReadIniFileRecord(SysIniFile,SectSystem(1),'MainWindowDefaultPos%i;%i',DefPos)
    or not ReadIniFileRecord(SysIniFile,SectSystem(1),'MainWindowDefaultSize%i;%i',DefSize)
    then begin DefPos:=Point2I(167,0); DefSize:=Point2I(1200,100); end;
    DefSize.y:=Min(DefSize.y,Screen.Height);
    DefSize.x:=Min(DefSize.x,Screen.Width);
   end;
   if (DefSize.x>0) and (DefSize.y>0) then begin
    Self.Top:=DefPos.y;
    Self.Left:=DefPos.x;
    Self.Width:=DefSize.x;
    Self.Height:=DefSize.y;
   end;
  end;
 except
  on E:Exception do BugReport(E,Self,'GoHome');
 end;
end;

procedure TtyEcho(const Msg:LongString);
begin
 if SystemConsole.TtyVerbose then Echo(Msg);
end;

procedure TFormCrwDaq.HandleSessionIpc(Line:LongString);
var cmd,arg,tim,tmp:LongString; i,wc:Integer;
begin
 if Assigned(Self) and IsMainThread and IsNonEmptyStr(Line) then
 try
  Line:=Trim(Line);
  if IsLexeme(Line,lex_AtCall) then begin
   cmd:=ExtractWord(1,Line,JustSpaces);
   arg:=Trim(SkipWords(1,Line,JustSpaces));
   if SameText(cmd,smc_Activate) then begin
    Inc(myTty0Counts.Activate);
    // Activation from other instance.
    Visible:=true; WindowState:=wsNormal;
    BringToFront; if CanSetFocus then SetFocus;
    Echo(StdDateTimePrompt+RusEng('Получен внешний запрос на выполнение:','External request received for execution:'));
    Echo(Format(' %s',[arg]));
    SystemConsole.Activate;
    ProcessCmdLine(arg);
   end else
   if SameText(cmd,smc_Incoming) then begin
    Inc(myTty0Counts.Incoming);
    tim:=StdDateTimeStr(mSecNow);
    if (StrFetch(arg,1) in JustQuotes) and not HasChars(arg,EolnDelims) then begin
     tmp:=''; wc:=PhraseCount(arg,JustSpaces);
     for i:=1 to wc do tmp:=tmp+Trim(ExtractPhrase(i,arg,JustSpaces))+EOL;
     arg:=Trim(tmp); tmp:='';
    end;
    if IsNonEmptyStr(arg) then
    // Incoming message to system console.
    if (SystemConsole.TtyListenCount(0)<=0) then begin
     TtyEcho(Format('%s: tty0 @Incoming %d byte(s) rejected.',[tim,Length(arg)]));
     Inc(myTty0Counts.Rejected);
    end else
    if SystemConsole.TtyShield then begin
     TtyEcho(Format('%s: tty0 @Incoming %d byte(s) refused.',[tim,Length(arg)]));
     Inc(myTty0Counts.Refused);
    end else
    if SystemConsole.Form.InpFifo.PutText(ValidateEol(arg,1)) then begin
     TtyEcho(Format('%s: tty0 @Incoming %d byte(s) received.',[tim,Length(arg)]));
     Inc(myTty0Counts.Accepted);
    end else
    Raise ESystemConsole.Create(Format('System console fifo overflow (%d,%d,%d)',
     [Length(arg),SystemConsole.Form.InpFifo.Space,SystemConsole.Form.InpFifo.Size]));
   end;
  end;
 except
  on E:Exception do BugReport(E,Self,'HandleSessionIpc');
 end;
end;

procedure TFormCrwDaq.HandleApplicationOnIdle(Sender:TObject; var Done:Boolean);
begin
 try
  OnIdleActions.Execute;
 except
  on E:Exception do BugReport(E,Self,'HandleApplicationOnIdle');
 end;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_crwdaq;
begin
end;

procedure Free_form_crwdaq;
begin
end;

initialization

 Init_form_crwdaq;

finalization

 Free_form_crwdaq;

end.

//////////////
// END OF FILE
//////////////

