#!/bin/bash

###################################################
# Copyright (c) 2023 Alex Kuryakin daqgroup@mail.ru
###################################################
# Convert bmp/*.bmp to png/*.png and combine *.ico.
###################################################

function call(){
 echo $*;
      $*;
};

function ConvertBmpToPng(){
 local name="$(basename $1 .bmp)";
 # magenta=#ff00ff
 # purple=#800080
 local tcolor="magenta";
 if [[ "$name" == *"_5_"* ]]; then tcolor="purple"; fi;
 call convert $1 -transparent $tcolor png/$name.png;
};

function ConvertPngToIco(){
 call unix png2ico $1.ico --colors 16 png/$1_16.png png/$1_32.png png/$1_48.png;
};

function bmp2png2ico(){
 mkdir png;
 for i in bmp/*.bmp; do ConvertBmpToPng $i; done;
 for i in 0 1 2 3 4 5; do ConvertPngToIco crwdaq_$i; done;
 cp -f crwdaq_0.ico crwdaq.ico;
};

bmp2png2ico;
