@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:CheckArguments
if /I "%~1" == "-h"     ( 1>&2 call :Usage & goto :EOF )
if /I "%~1" == "--help" ( 1>&2 call :Usage & goto :EOF )

:Main
set /a count=0
set homedir=%~dp0
set searchdirs="%homedir%." "%homedir%.." "%homedir%..\.." "%homedir%..\..\.." "%UnixRoot%\add\bin"
call :SetSearchExeFiles fontreg enumfonts setclosemenu
call :SetSysFontsFolder sysfonts
call :InstallFonts %*
goto :EOF

rem ---------------------------------------------
rem call :Usage
rem show help screen by -h or --help option
rem ---------------------------------------------
:Usage
echo ################################################
echo Copyright(c) 2016 Alexey Kuryakin, Sarov Russia.
echo The script uses to setup/register Windows fonts.
echo ################################################
echo.
echo Usage:
echo  %~n0 [dir1] [dir2] ...
echo.
echo  dir1, dir2 ... - full path to the directories,
echo  where TTF, OTF, FON or TTC font files located.
echo  also install fonts from directory where script
echo  is located with subdirectories. System utility
echo  fontreg.exe should be located in script folder
echo  or subdirectories of .\, ..\, ..\..\ folders.
echo  also enumfonts,setclosemenu tools uses.
echo.
echo  %~n0 -h      Same as --help option
echo  %~n0 --help  Show this help screen
echo.
goto :EOF

rem ---------------------------------------------
rem call :SetSysFontsFolder sysfonts
rem Find & write to sysfonts environment variable
rem system fonts path, usually = C:\Windows\Fonts
rem so %sysfonts% contains system fonts directory
rem ---------------------------------------------
:SetSysFontsFolder
if "%~1" == "" goto :EOF
set %~1=%SystemRoot%\Fonts
for /F "delims=" %%i in ('"%enumfonts%" -p 2^>nul') do set %~1=%%~fi
echo %~1=!%~1!
goto :EOF

rem ---------------------------------------------
rem call :SetSearchExeFiles cmd1 cmd2 ...
rem Seach cmd1.exe, cmd2.exe, ... in PATH and in
rem %searchdirs%. If was found, set cmd1,cmd2,...
rem environment variables so %cmd1%,%cmd2% should
rem contains full path of commands that was found
rem ---------------------------------------------
:SetSearchExeFiles
if "%~1" == "" goto :EOF
set __adds_path__=
set __save_path__=%PATH%
for %%i in ( %searchdirs% ) do if exist "%%~fi" set __adds_path__=!__adds_path__!;%%~fi
if not "%__adds_path__%" == "" set __adds_path__=%__adds_path__:~1%
if not "%__adds_path__%" == "" path %PATH%;%__adds_path__% & path
call :SetSearchExeFilesLoop %*
path %__save_path__%
set __save_path__=
set __adds_path__=
goto :EOF
rem ---------------------------------------------
rem Uses internally by :SetSearchExeFiles routine
rem ---------------------------------------------
:SetSearchExeFilesLoop
if "%~1" == "" goto :EOF
call :SetSearchExeFile "%~1" %searchdirs%
call :SetSearchExeFilesLoop "%~2" "%~3" "%~4" "%~5" "%~6" "%~7" "%~8" "%~9"
goto :EOF
rem ---------------------------------------------
rem Uses internally by :SetSearchExeFiles routine
rem ---------------------------------------------
:SetSearchExeFile
if "%~1" == "" goto :EOF
set %~1=
for %%i in ( "%~1.exe" ) do (
 set %~1=%%~$PATH:i
 if not "!%~1!" == "" echo %~1=!%~1!
 if not "!%~1!" == "" goto :EOF
)
call :SetSearchExeFileLoop %*
goto :EOF
rem ---------------------------------------------
rem Uses internally by :SetSearchExeFiles routine
rem ---------------------------------------------
:SetSearchExeFileLoop
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if not "!%~1!" == "" goto :EOF
for /F "delims=" %%i in ('dir /B /S "%~2\%~1.exe" 2^>nul') do (
 set %~1=%%~fi
 echo %~1=!%~1!
 goto :EOF
)
call :SetSearchExeFileLoop "%~1" "%~3" "%~4" "%~5" "%~6" "%~7" "%~8" "%~9"
goto :EOF

rem ---------------------------------------------
rem call :RunExe exe args
rem Check if exe exists then run exe with an args
rem After execution print exit code in errorlevel
rem ---------------------------------------------
:RunExe
if "%~1" == "" goto :EOF
if not exist "%~f1" goto :EOF
%* & echo %~n1 return %errorlevel%.
goto :EOF

rem ---------------------------------------------
rem call :InstallFonts path1 path2 ...
rem Copy all fon,ttf,ttc,otf files to %sysfonts%\
rem for all path1, path2, ... with subdirectories
rem if path1,.. list not specified, use %homedir%
rem If count of fonts copied >0, call fontreg.exe
rem to register copied fonts in system for future
rem Also disable window close menu during execute
rem ---------------------------------------------
:InstallFonts
call :RunExe "%setclosemenu%" -d 1>nul 2>nul
call :CopyFonts %1 %2 %3 %4 %5 %6 %7 %8 %9
if "%~1" == "" call :CopyFonts "%homedir%"
echo %count% file^(s^) copied.
if not "%count%" == "0" call :RunExe "%fontreg%"
call :RunExe "%setclosemenu%" -e 1>nul 2>nul
call :Sleep 3 1>nul 2>nul
goto :EOF

rem ---------------------------------------------
rem call :CopyFonts path1 path2 ...
rem Copy all fon,ttf,ttc,otf files to %sysfonts%\
rem for all path1, path2, ... with subdirectories
rem Also increments the count of fonts was copied
rem Uses recursive calls to process all arguments
rem ---------------------------------------------
:CopyFonts
if "%~1" == "" goto :EOF
if exist "%~f1" for /F "delims=" %%i in ('dir /B /S "%~f1\*.fon" 2^>nul') do call :CopyFont "%%~fi"
if exist "%~f1" for /F "delims=" %%i in ('dir /B /S "%~f1\*.ttf" 2^>nul') do call :CopyFont "%%~fi"
if exist "%~f1" for /F "delims=" %%i in ('dir /B /S "%~f1\*.ttc" 2^>nul') do call :CopyFont "%%~fi"
if exist "%~f1" for /F "delims=" %%i in ('dir /B /S "%~f1\*.otf" 2^>nul') do call :CopyFont "%%~fi"
call :CopyFonts %2 %3 %4 %5 %6 %7 %8 %9
goto :EOF

rem ---------------------------------------------
rem call :CopyFont font.ttf
rem Copy font.ttf to %sysfonts%\ if one not exist
rem Also increments the count of fonts was copied
rem ---------------------------------------------
:CopyFont
if "%~1" == "" goto :EOF
if not exist "%~f1" goto :EOF
if "%sysfonts%" == "" goto :EOF
if not exist "%sysfonts%\" goto :EOF
if exist "%sysfonts%\%~nx1" goto :EOF
xcopy /Y /V /H /F /I "%~f1" "%sysfonts%\" && set /a count=count+1
goto :EOF

:Sleep
rem Usage = call :Sleep NumSeconds [StartMessage] [ProgressChar]
SetLocal EnableExtensions EnableDelayedExpansion
if not "%~2" == "" call :ShowSleepProgress %~2
if not "%~3" == "" (for /L %%i in (1,1,%1) do (call :SleepSilent 1 & call :ShowSleepProgress %~3)) else (call :SleepSilent %1)
EndLocal
goto :EOF

:SleepSilent
rem Usage = call :SleepSilent NumSeconds
SetLocal EnableExtensions EnableDelayedExpansion
set /a NumSeconds=%1+1
ping -n %NumSeconds% 127.0.0.1 > nul 2>&1
EndLocal
goto :EOF

:ShowSleepProgress
rem Usage = call :ShowSleepProgress Message
SetLocal EnableExtensions EnableDelayedExpansion
<nul set /p Dummy=%*
EndLocal
goto :EOF
