program server;

{$APPTYPE CONSOLE}

uses
  Windows, SysUtils, ShellApi, _dim;

var dev_data, serv_id, cmnd_id, start, updat:Integer;
    aux:array[0..80] of Char;
    name:array[0..84] of char;
    dns_ver : Integer = -1;
    no_link :Integer = -1;
    task_exit :Integer=-1;
    panic:integer=0;
 sched : Integer = 0;
 prio0 : Integer = 0;
 prio1 : Integer = 0;
 prio2 : Integer = 0;
{
function panic_handler(reason:integer):integer; cdecl;
begin
 Result:=0;
 if reason=DNS_KILL_DIS then begin
  Result:=1;
  panic:=1;
  dis_stop_serving;
  writeln('I don''t want to die!');
 end;
end;
}
procedure got_vers(var tag:TDimLong; data:Pointer; var size:Integer); cdecl;
begin
 if Integer(data^) = -1
 then writeln('DNS is dead')
 else writeln(Format('DNS vers: %d, tag:%d, size:%d',[Integer(data^),tag,size]));
 dns_ver:=Integer(data^);
end;

procedure got_task(var tag:TDimLong; data:Pointer; var size:Integer); cdecl;
begin
 if Integer(data^) = -1
 then writeln('task is free')
 else writeln(Format('task exit: %d, tag:%d, size:%d',[Integer(data^),tag,size]));
 task_exit:=Integer(data^);
end;

function CheckDns:Boolean;
begin
 dic_info_service_stamped('DIS_DNS/VERSION_NUMBER', ONCE_ONLY, 10, nil, 0, got_vers, 1, @no_link, 4 );
 Sleep(2000);
 Result:=dns_ver<>-1;
end;

function CheckTask(TaskName:AnsiString):Boolean;
begin
 dic_info_service(PChar(TaskName+'/EXIT'), ONCE_ONLY, 10, nil, 0, got_task, 1, @no_link, 4 );
 Sleep(2000);
 Result:=task_exit<>-1;
end;

procedure do_serv(var tag:TDimLong; var buff:Pointer; var size:Integer; var first:Integer); cdecl;
begin
 writeln('Serving:',tag,' Conn_id=',dis_get_conn_id,' tag=',tag);
 inc(dev_data);
 buff:=@dev_data;
 size:=sizeof(dev_data);
 writeln('Threads=',GetCurrentThreadID,' ',MainThreadID);
 //if Dim.dis_get_client(name)<>0
 //then writeln(Format('Client %s (%d) serv',[name, tag]))
 //else writeln(Format('Client %d serv',[tag]));
 if first>0 then begin
  if dis_get_client(name)<>0 then writeln('Register client---------------------- ',name);
  dis_set_client_exit_handler(dis_get_conn_id,tag);
 end;
end;

procedure do_cmnd(var tag:TDimLong; cmnd:Pointer; var size:Integer); cdecl;
begin
 writeln('Got Command:',PChar(cmnd),' tag=',tag,' size=',size);
 if(strcomp(cmnd,'RESET')=0)            then dev_data := 0;
 if(strcomp(cmnd,'CONFIGURE')=0)        then dev_data := 1;
 if(strcomp(cmnd,'START')=0)           then dev_data := 2;
 if(strcomp(cmnd,'STOP')=0)           then dev_data := 1;
 updat:=dis_update_service(serv_id);
 writeln('Updat:',updat);
 writeln('Threads=',GetCurrentThreadID,' ',MainThreadID);
 //if Dim.dis_get_client(name)<>0
 //then writeln(Format('Client %s (%d) cmnd',[name, tag]))
 //else writeln(Format('Client %d cmnd',[tag]));
end;

procedure client_exited(var code:Integer); cdecl;
begin
 if dis_get_client(name)<>0
 then writeln(Format('Client %s (%d) exited',[name, code]))
 else writeln(Format('Client %d exited',[code]));
end;

procedure exited(var code:Integer); cdecl;
begin
 if dis_get_client(name)<>0
 then writeln(Format('%s (%d) exited',[name, code]))
 else writeln(Format('%d exited',[code]));
end;

procedure dtq_rout(tag:TDimLong); cdecl;
begin
 writeln(Format('Timer:%d',[tag]));
end;

procedure echo(msg,br:AnsiString);
begin
 write(msg+br);
end;

begin
 //dim_set_panic_handler(panic_handler);
 while(true) do begin
        panic:=0;
        writeln('Start serving...');
        //dim_set_dns_node('main');
        dim_get_dns_node(aux);
        writeln('DIM_DNS_NODE=',aux);

        if not CheckDns then begin shellexecute(0,'open','..\dim\bin\dns.exe',nil,nil,sw_shownormal); sleep(5000); end;
        if not CheckDns then begin Sleep(2000); exit; end;

        writeln(Format('DnsPort=%d',[get_dns_port_number]));
        if get_node_name(aux)<> 0           then writeln(Format('NodeName=%s',[aux]));
        if get_dns_node_name(aux)<>0        then writeln(Format('DnsNodeName=%s',[aux]));
        if get_dns_accepted_domains(aux)<>0 then writeln(Format('DnsDomains=%s',[aux]));
        if dic_get_id(aux)<>0               then writeln(Format('DicId=%s',[aux]));

        dis_add_client_exit_handler(client_exited);
        dis_add_exit_handler(exited);

        dtq_start_timer(10,dtq_rout,1);
        write('Sleep...'); writeln(dtq_sleep(2));
        writeln('Elapsed: ',dtq_stop_timer(1));
        dtq_start_timer(10,dtq_rout,2);

   dev_data := 0;
   strpcopy(aux,Format('DEVICE/%s/DATA',[paramstr(1)]));
   //serv_id := Dim.dis_add_service(aux, 'I', @dev_data, sizeof(dev_data), nil, 0);
   serv_id := dis_add_service(aux, 'I', nil, 0, do_serv, 1);
   writeln('servid=',serv_id);

   strpcopy(aux,Format('DEVICE/%s/CMD',[paramstr(1)]));
   cmnd_id := dis_add_cmnd(aux, 'C', do_cmnd, 0);
   writeln('cmndid=',cmnd_id);

        if CheckTask(Paramstr(1)) then begin
         writeln('Could not start server: already started!');
         sleep(5000);
         exit;
        end;

   start := dis_start_serving( PChar(paramstr(1)) );
   writeln('start=',start);

        writeln('Set priority',
         dim_set_scheduler_class(2),
         dim_set_priority(1,2),
         dim_set_priority(2,2),
         dim_set_priority(3,2)
         );
        writeln('Get priority',
         dim_get_scheduler_class(sched),
         dim_get_priority(1,prio0),
         dim_get_priority(2,prio1),
         dim_get_priority(3,prio2)
         );
        writeln('scheduler_class=',sched);
        writeln('priority_0=',prio0);
        writeln('priority_1=',prio1);
        writeln('priority_2=',prio2);

   while panic=0 do begin
      sleep(1000);
      updat := dis_update_service(serv_id);
      writeln('updat=',updat);
   end;
        Sleep(5000);
 end;
end.

