 {
 Include FsmManager
 }
 {$I _var_FsmManager}
 {
 Variables for SmiuiSrv.
 }
 ShouldPollSmiuiSrv         : Boolean;  // Flag to poll SmiuiSrv
 ShouldPollSmiuiSrvDefFsm   : Boolean;  // Flag to use smiuisrv_default_fsm_poll
 smiuisrv_tab               : record    // SmiuiSrv data table
  fsm                       : Integer;  // FsmManager reference
  task                      : record    // Server task related data
   tid                      : Integer;  // SMIUISRV.EXE executable task id
   ExeFile                  : String;   // SMIUISRV.EXE executable file name
   CmdArgs                  : String;   // SMIUISRV command line arguments
   CmdLine                  : String;   // SMIUISRV command line to execute
   DnsNode                  : String;   // DNS node uses to run SMIUISRV.EXE
   FsmArgs                  : String;   // Arguments uses to initialize FSM
   FsmLine                  : String;   // Command line   to initialize FSM 
   Line                     : String;   // Temporary buffer for data reading
   Buff                     : String;   // Temporary buffer for data reading
   Display                  : Integer;  // DisplayMode
   StdInPipeSize            : Integer;  // StdInPipeSize  bytes buffer
   StdOutPipeSize           : Integer;  // StdOutPipeSize bytes buffer
   RecoveryPeriod           : Integer;  // RecoveryPeriod ms to recover task if not running
   RecoveryTimer            : Real;     // Recovery timer to check and recover SMIUISRV
   WatchdogTimer            : Real;     // Watchdog timer to detect server hanging
  end;
  TooltipSeverityDelays     : String;   // Tooltip delays for each severity code, ms: 60000,300000,86400000,86400000
  SmiuiSrvMessagesLogFile   : String;   // Log file for messages: $CRW_DAQ_VAR_TMP_DIR\smiuisrvmessages.log
  SmiTagPrefix              : String;   // Common prefix for all SMI FSM tags.
  SmiMenuFont               : String;   // Font uses for State/Acuin menu's, like: Name:PT_Mono\Size:14\Style:[Bold]
  tagLinks                  : Integer;  // Hash list reference of tag-fsm links
  //////////////////////////////////////// Data uses for refreshment:
  Last                      : record    //
   dns_node                 : Real;     // To refresh DNS_NODE
   dns_task                 : Real;     // To refresh DNS_TASK
   dns_pid                  : Real;     // To refresh DNS_PID
   dns_version              : Real;     // To refresh DNS_VERSION
  end;                                  //
  rexRefDomain              : Integer;  // RegExp for _DOMAIN_
  rexRefObject              : Integer;  // RegExp for _OBJECT_
  rexRefAction              : Integer;  // RegExp for _ACTION_
  rexRefState               : Integer;  // RegExp for _STATE_
  //////////////////////////////////////////////// SMI colors                   General                 Fallback
  color_default                     : Integer;  // Default (background)         _3DFace                 clSilver
  color_btnface                     : Integer;  // Button face (background)     _3DFace                 clSilver
  color_neutral                     : Integer;  // Neutral                      Silver                  clSilver
  color_dormant                     : Integer;  // Inactive                     FwStateOKNotPhysics     clAqua
  color_working                     : Integer;  // Active                       FwStateOKPhysics        clLime
  color_success                     : Integer;  // Success                      Lime                    clLime
  color_refused                     : Integer;  // Connection refused           FwAlarmWarnAck          clYellow
  color_offline                     : Integer;  // Offline, connection lost     FwAlarmFatalAck         clRed
  color_warning                     : Integer;  // Warning                      FwStateAttention1       clYellow
  color_trouble                     : Integer;  // Warning                      FwStateAttention2       clYellow
  color_online                      : Integer;  // Online, connected            FwStateOKPhysics        clLime
  color_error                       : Integer;  // Recoverable error            FwStateAttention3       clRed
  color_fatal                       : Integer;  // Fatal error                  FwAlarmFatalAck         clRed
  color_dead                        : Integer;  // Dead element                 FwDead                  clSilver
  color_edit                        : Integer;  // Edit element                 FwBackgroundInputText   clWhite
  color_text                        : Integer;  // Text element                 FwForegroundInputText   clBlack
  color_info                        : Integer;  // Info element                 FwTableSelection        clAqua
  color_alert: array[smi_severity_norm..smi_severity_fatal] of Integer; // Colors of Alert vs Severity
  //////////////////////////////////////////////// Commands:
  cmd_Exit                          : Integer;  // @Exit
  cmd_Sleep                         : Integer;  // @Sleep
  cmd_Memory                        : Integer;  // @Memory
  cmd_Errors                        : Integer;  // @Errors
  cmd_ProcessPriority               : Integer;  // @ProcessPriority
  cmd_ThreadPriority                : Integer;  // @ThreadPriority
  cmd_OnException                   : Integer;  // @OnException
  cmd_smiuisrv_send                 : Integer;  // @smiuisrv_send
  cmd_smiuisrv_restart              : Integer;  // @smiuisrv_restart
  cmd_smiuisrv_fsm_dump             : Integer;  // @smiuisrv_fsm_dump
  cmd_dim_dns_node                  : Integer;  // @dim_dns_node
  cmd_smiui_dns_version             : Integer;  // @smiui_dns_version
  cmd_smiui_current_state           : Integer;  // @smiui_current_state
  cmd_smiui_send_command            : Integer;  // @smiui_send_command
  cmd_smiui_ep_send_command         : Integer;  // @smiui_ep_send_command
  cmd_smiui_send_command_wait       : Integer;  // @smiui_send_command_wait
  cmd_smiui_ep_send_command_wait    : Integer;  // @smiui_ep_send_command_wait
  cmd_smiui_change_option           : Integer;  // @smiui_change_option
  cmd_smiui_change_option_wait      : Integer;  // @smiui_change_option_wait
  cmd_smiui_get_options             : Integer;  // @smiui_get_options
  cmd_smiui_number_of_objects       : Integer;  // @smiui_number_of_objects
  cmd_smiui_connect_domain          : Integer;  // @smiui_connect_domain
  cmd_smiui_book_connect_domain     : Integer;  // @smiui_book_connect_domain
  cmd_smiui_cancel_connect_domain   : Integer;  // @smiui_cancel_connect_domain
  cmd_smiui_shutdown_domain         : Integer;  // @smiui_shutdown_domain
  cmd_smiui_check_proxy             : Integer;  // @smiui_check_proxy
  cmd_smiui_kill                    : Integer;  // @smiui_kill
  cmd_smiui_book_statechange        : Integer;  // @smiui_book_statechange
  cmd_smiui_cancel_statechange      : Integer;  // @smiui_cancel_statechange
  cmd_smiui_book_smi_message        : Integer;  // @smiui_book_smi_message
  cmd_smiui_cancel_smi_message      : Integer;  // @smiui_cancel_smi_message
  cmd_smiui_book_user_message       : Integer;  // @smiui_book_user_message
  cmd_smiui_cancel_user_message     : Integer;  // @smiui_cancel_user_message
  cmd_smiui_list_domain_objects     : Integer;  // @smiui_list_domain_objects
  cmd_smiui_list_domain_objectsets  : Integer;  // @smiui_list_domain_objectsets
  cmd_smiui_book_objectsetchange    : Integer;  // @smiui_book_objectsetchange
  cmd_smiui_cancel_objectsetchange  : Integer;  // @smiui_cancel_objectsetchange
  cmd_smiui_connect_domain_handler  : Integer;  // @smiui_connect_domain_handler
  cmd_smiui_statechange_handler     : Integer;  // @smiui_statechange_handler
  cmd_smiui_smi_message_handler     : Integer;  // @smiui_smi_message_handler
  cmd_smiui_user_message_handler    : Integer;  // @smiui_user_message_handler
  cmd_smiui_objectsetchange_handler : Integer;  // @smiui_objectsetchange_handler
  cmd_smiui_report                  : Integer;  // @smiui_report
  cmd_smiui_errors                  : Integer;  // @smiui_errors
 end;
