 //
 // Include FsmManager
 //
 {$I _var_FsmManager.inc}
 //
 // Variables for SmiProxy.
 //
 ShouldPollSmiProxy         : Boolean;  // Flag to poll SmiProxy
 smi_proxy_tab              : record    // SmiProxy data table
  fsm                       : Integer;  // FsmManager reference
  dom                       : Integer;  // Domain reference
  obj                       : Integer;  // Object reference
  task                      : record    // Server task related data
   tid                      : Integer;  // SMIPROXY_EXE executable task id
   ExeFile                  : String;   // SMIPROXY_EXE executable file name
   CmdLine                  : String;   // SMI Proxy command line to execute
   SmlFile                  : String;   // SMIPROXY_SML SML source file name
   Line                     : String;   // Temporary buffer for data reading
   Buff                     : String;   // Temporary buffer for data reading
   Display                  : Integer;  // DisplayMode
   StdInPipeSize            : Integer;  // StdInPipeSize  bytes buffer
   StdOutPipeSize           : Integer;  // StdOutPipeSize bytes buffer
   RecoveryPeriod           : Integer;  // RecoveryPeriod ms to recover task if not running
   RecoveryTimer            : Real;     // Recovery timer to check and recover SMI Proxy
   WatchdogTimer            : Real;     // Watchdog timer to detect server hanging
  end;
  optDns                    : String;   // option -dns localhost        - DIM DNS node
  optDom                    : String;   // option -dom DOMAIN           - domain name
  optObj                    : String;   // option -obj DOMAIN::OBJECT   - object name
  optSet                    : String;   // option -set NOT_LOGGING      - initial object state/params
  optVol                    : Integer;  // option -vol 1                - volatile
  Handler                   : record    // User must handle actions when BUSY then call smi_terminate_action to go IDLE
   Stage                    : Integer;  // Handler processing stage DEAD,IDLE,READ,BUSY,TERM
   Count                    : Integer;  // Handler loop counter
   Action                   : String;   // Action  to execute (name only)
   Command                  : String;   // Command to execute (with all params)
   Uptimer                  : Real;     // Uses to measure uptime since state change
   Params                   : Integer;  // Text to receive action params
   TermTimer                : Real;     // Termination cycle timer
   TermCount                : Integer;  // Termination cycle count
   TermRepeater             : Integer;  // Termination repeater
   TermPeriod               : Integer;  // Termination period
  end;                                  //
  Prompt                    : String;   // Prompt like SMI => ...
  StateColorStamp           : Real;     // Uses to update state color
  StateColorAuto            : Boolean;  // Uses to update state color
  DefStateColor             : Integer;  // Default state color
  //////////////////////////////////////// Commands:
  cmd_Exit                  : Integer;  // @Exit
  cmd_Memory                : Integer;  // @Memory
  cmd_Errors                : Integer;  // @Errors
  cmd_ProcessPriority       : Integer;  // @ProcessPriority
  cmd_ThreadPriority        : Integer;  // @ThreadPriority
  cmd_OnException           : Integer;  // @OnException
  cmd_smi_attach            : Integer;  // @smi_attach
  cmd_smi_volatile          : Integer;  // @smi_volatile
  cmd_smi_get_state         : Integer;  // @smi_get_state
  cmd_smi_set_state         : Integer;  // @smi_set_state
  cmd_smi_set_par           : Integer;  // @smi_set_par
  cmd_smi_proxy_handler     : Integer;  // @smi_proxy_handler
  cmd_smi_get_action        : Integer;  // @smi_get_action
  cmd_smi_get_command       : Integer;  // @smi_get_command
  cmd_smi_get_next_par      : Integer;  // @smi_get_next_par
  cmd_smi_get_par_value     : Integer;  // @smi_get_par_value
  cmd_dim_dns_node          : Integer;  // @dim_dns_node
  cmd_smi_terminate_action  : Integer;  // @smi_terminate_action
  cmd_smi_errors            : Integer;  // @smi_errors
  cmd_smi_report            : Integer;  // @smi_report
  cmd_smi_restart           : Integer;  // @smi_restart
  cmd_smi_repost            : Integer;  // @smi_repost
  cmd_smi_proxy             : Integer;  // @smi_proxy
  //////////////////////////////////////// Tags:
  tagObjectName             : Integer;  // String
  tagObjectState            : Integer;  // String
  tagObjectDns              : Integer;  // String
  tagHandlerStage           : Integer;  // Integer
  tagHandlerCount           : Integer;  // Integer
  tagHandlerAction          : Integer;  // String
  tagHandlerCommand         : Integer;  // String
  tagHandlerUptime          : Integer;  // Real
 end;
