 {
 Standard routines for Diesel:
 function  DieselPascalAssocLm9Exe:String;
 function  DieselPascalDManagerExe:String;
 function  DieselPascalCrossMachineExe:String;
 function  DieselPascalCrossDesignerExe:String;
 function  HasDieselPascal:Boolean;
 function  EasyIpc_Valid(hIpc:Integer):Boolean;
 function  EasyIpc_Connected(hIpc:Integer):Boolean;
 function  EasyIpc_IsServer(hIpc:Integer):Boolean;
 function  EasyIpc_IsClient(hIpc:Integer):Boolean;
 function  EasyIpc_FileName(hIpc:Integer):String;
 function  EasyIpc_PipeName(hIpc:Integer):String;
 function  EasyIpc_HostName(hIpc:Integer):String;
 function  EasyIpc_BaseName(hIpc:Integer):String;
 function  EasyIpc_Handle(hIpc:Integer):Integer;
 function  EasyIpc_TimeOut(hIpc:Integer):Integer;
 function  EasyIpc_RxBuffSize(hIpc:Integer):Integer;
 function  EasyIpc_TxBuffSize(hIpc:Integer):Integer;
 function  EasyIpc_RxLost(hIpc:Integer):Real;
 function  EasyIpc_TxLost(hIpc:Integer):Real;
 function  EasyIpc_RxTotal(hIpc:Integer):Real;
 function  EasyIpc_TxTotal(hIpc:Integer):Real;
 function  EasyIpc_RxLength(hIpc:Integer):Integer;
 function  EasyIpc_TxLength(hIpc:Integer):Integer;
 function  EasyIpc_RxFifoLimit(hIpc:Integer):Integer;
 function  EasyIpc_TxFifoLimit(hIpc:Integer):Integer;
 function  EasyIpc_LogsHistory(hIpc:Integer):Integer;
 function  EasyIpc_LogsCount(hIpc:Integer):Integer;
 function  EasyIpc_LogsTextMove(hIpc:Integer):String;
 function  EasyIpc_LogsTextCopy(hIpc:Integer):String;
 function  EasyIpc_Clear(hIpc:Integer; What:String):Boolean;
 function  LM9_TabCount:Integer;
 function  LM9_TidByKey(key:String):Integer;
 function  LM9_KeyByTid(tid:Integer):String;
 function  LM9_IndexOfKey(key:String):Integer;
 function  LM9_KeyByIndex(i:Integer):String;
 function  LM9_IndexOfTid(tid:Integer):Integer;
 function  LM9_TidByIndex(i:Integer):Integer;
 function  LM9_IpcByKey(key:String):Integer;
 function  LM9_IpcByIndex(i:Integer):Integer;
 function  LM9_IpcByTid(tid:Integer):Integer;
 function  LM9_BufByKey(key:String):Integer;
 function  LM9_BufByIndex(i:Integer):Integer;
 function  LM9_BufByTid(tid:Integer):Integer;
 function  LM9_ParamsByKey(key:String):String;
 function  LM9_ParamsByIndex(i:Integer):String;
 function  LM9_ParamsByTid(tid:Integer):String;
 function  LM9_HasKey(key:String):Boolean;
 function  LM9_HasTid(tid:Integer):Boolean;
 function  LM9_Send(tid:Integer; data:String):Boolean;
 function  LM9_Post(tid:Integer; data:String):Boolean;
 procedure LM9_KeyFree(key:String);
 procedure LM9_TidFree(tid:Integer);
 function  LM9_Launch(lm9,arg,opt,inipar,ipcpar:String):Integer;
 procedure LM9_TabClear;
 procedure LM9_TabInit;
 procedure LM9_TabFree;
 procedure ClearStdDiesel;
 procedure InitStdDiesel;
 procedure FreeStdDiesel;
 procedure PollStdDiesel;
 }
 {
 DieselPascal Identification.
 }
 function DieselPascalAssocLm9Exe:String;
 begin
  DieselPascalAssocLm9Exe:=ParamStr('GetSystemAssocExe .lm9');
 end;
 function DieselPascalDManagerExe:String;
 begin
  if IsUnix
  then DieselPascalDManagerExe:=ParamStr('FileSearch DManager')
  else DieselPascalDManagerExe:=ParamStr('GetSystemFTypeExe VisualTech.DieselPascal.DManager');
 end;
 function DieselPascalCrossMachineExe:String;
 begin
  if IsUnix
  then DieselPascalCrossMachineExe:=ParamStr('FileSearch CrossMachine')
  else DieselPascalCrossMachineExe:=ParamStr('GetSystemFTypeExe VisualTech.DieselPascal.CrossMachine');
 end;
 function DieselPascalCrossDesignerExe:String;
 begin
  if IsUnix
  then DieselPascalCrossDesignerExe:=ParamStr('FileSearch CrossDesigner')
  else DieselPascalCrossDesignerExe:=ParamStr('GetSystemFTypeExe VisualTech.DieselPascal.CrossDesigner');
 end;
 function HasDieselPascal:Boolean;
 begin
  HasDieselPascal:=FileExists(DieselPascalAssocLm9Exe);
 end;
 {
 EasyIpc addon routines.
 }
 function EasyIpc_Valid(hIpc:Integer):Boolean;
 begin
  if (hIpc=0)
  then EasyIpc_Valid:=false
  else EasyIpc_Valid:=(EasyIpc_Ctrl(hIpc,'Connected')<>'');
 end;
 function EasyIpc_Connected(hIpc:Integer):Boolean;
 begin
  if (hIpc=0)
  then EasyIpc_Connected:=false
  else EasyIpc_Connected:=(Val(EasyIpc_Ctrl(hIpc,'Connected'))>0);
 end;
 function EasyIpc_IsServer(hIpc:Integer):Boolean;
 begin
  if (hIpc=0)
  then EasyIpc_IsServer:=false
  else EasyIpc_IsServer:=(Val(EasyIpc_Ctrl(hIpc,'IsServer'))>0);
 end;
 function EasyIpc_IsClient(hIpc:Integer):Boolean;
 begin
  if (hIpc=0)
  then EasyIpc_IsClient:=false
  else EasyIpc_IsClient:=(Val(EasyIpc_Ctrl(hIpc,'IsClient'))>0);
 end;
 function EasyIpc_FileName(hIpc:Integer):String;
 begin
  if (hIpc=0)
  then EasyIpc_FileName:=''
  else EasyIpc_FileName:=EasyIpc_Ctrl(hIpc,'FileName');
 end;
 function EasyIpc_PipeName(hIpc:Integer):String;
 begin
  if (hIpc=0)
  then EasyIpc_PipeName:=''
  else EasyIpc_PipeName:=EasyIpc_Ctrl(hIpc,'PipeName');
 end;
 function EasyIpc_HostName(hIpc:Integer):String;
 begin
  if (hIpc=0)
  then EasyIpc_HostName:=''
  else EasyIpc_HostName:=EasyIpc_Ctrl(hIpc,'HostName');
 end;
 function EasyIpc_BaseName(hIpc:Integer):String;
 begin
  if (hIpc=0)
  then EasyIpc_BaseName:=''
  else EasyIpc_BaseName:=EasyIpc_Ctrl(hIpc,'BaseName');
 end;
 function EasyIpc_Handle(hIpc:Integer):Integer;
 begin
  if (hIpc=0)
  then EasyIpc_Handle:=0
  else EasyIpc_Handle:=Val(EasyIpc_Ctrl(hIpc,'Handle'));
 end;
 function EasyIpc_TimeOut(hIpc:Integer):Integer;
 begin
  if (hIpc=0)
  then EasyIpc_TimeOut:=0
  else EasyIpc_TimeOut:=Val(EasyIpc_Ctrl(hIpc,'TimeOut'));
 end;
 function EasyIpc_RxBuffSize(hIpc:Integer):Integer;
 begin
  if (hIpc=0)
  then EasyIpc_RxBuffSize:=0
  else EasyIpc_RxBuffSize:=Val(EasyIpc_Ctrl(hIpc,'RxBuffSize'));
 end;
 function EasyIpc_TxBuffSize(hIpc:Integer):Integer;
 begin
  if (hIpc=0)
  then EasyIpc_TxBuffSize:=0
  else EasyIpc_TxBuffSize:=Val(EasyIpc_Ctrl(hIpc,'TxBuffSize'));
 end;
 function EasyIpc_RxLost(hIpc:Integer):Real;
 begin
  if (hIpc=0)
  then EasyIpc_RxLost:=0
  else EasyIpc_RxLost:=rValDef(EasyIpc_Ctrl(hIpc,'RxLost'),0);
 end;
 function EasyIpc_TxLost(hIpc:Integer):Real;
 begin
  if (hIpc=0)
  then EasyIpc_TxLost:=0
  else EasyIpc_TxLost:=rValDef(EasyIpc_Ctrl(hIpc,'TxLost'),0);
 end;
 function EasyIpc_RxTotal(hIpc:Integer):Real;
 begin
  if (hIpc=0)
  then EasyIpc_RxTotal:=0
  else EasyIpc_RxTotal:=rValDef(EasyIpc_Ctrl(hIpc,'RxTotal'),0);
 end;
 function EasyIpc_TxTotal(hIpc:Integer):Real;
 begin
  if (hIpc=0)
  then EasyIpc_TxTotal:=0
  else EasyIpc_TxTotal:=rValDef(EasyIpc_Ctrl(hIpc,'TxTotal'),0);
 end;
 function EasyIpc_RxLength(hIpc:Integer):Integer;
 begin
  if (hIpc=0)
  then EasyIpc_RxLength:=0
  else EasyIpc_RxLength:=Val(EasyIpc_Ctrl(hIpc,'RxLength'));
 end;
 function EasyIpc_TxLength(hIpc:Integer):Integer;
 begin
  if (hIpc=0)
  then EasyIpc_TxLength:=0
  else EasyIpc_TxLength:=Val(EasyIpc_Ctrl(hIpc,'TxLength'));
 end;
 function EasyIpc_RxFifoLimit(hIpc:Integer):Integer;
 begin
  if (hIpc=0)
  then EasyIpc_RxFifoLimit:=0
  else EasyIpc_RxFifoLimit:=Val(EasyIpc_Ctrl(hIpc,'RxFifoLimit'));
 end;
 function EasyIpc_TxFifoLimit(hIpc:Integer):Integer;
 begin
  if (hIpc=0)
  then EasyIpc_TxFifoLimit:=0
  else EasyIpc_TxFifoLimit:=Val(EasyIpc_Ctrl(hIpc,'TxFifoLimit'));
 end;
 function EasyIpc_LogsHistory(hIpc:Integer):Integer;
 begin
  if (hIpc=0)
  then EasyIpc_LogsHistory:=0
  else EasyIpc_LogsHistory:=Val(EasyIpc_Ctrl(hIpc,'LogsHistory'));
 end;
 function EasyIpc_LogsCount(hIpc:Integer):Integer;
 begin
  if (hIpc=0)
  then EasyIpc_LogsCount:=0
  else EasyIpc_LogsCount:=Val(EasyIpc_Ctrl(hIpc,'LogsCount'));
 end;
 function EasyIpc_LogsTextMove(hIpc:Integer):String;
 begin
  if (hIpc=0)
  then EasyIpc_LogsTextMove:=''
  else EasyIpc_LogsTextMove:=EasyIpc_Ctrl(hIpc,'LogsTextMove');
 end;
 function EasyIpc_LogsTextCopy(hIpc:Integer):String;
 begin
  if (hIpc=0)
  then EasyIpc_LogsTextCopy:=''
  else EasyIpc_LogsTextCopy:=EasyIpc_Ctrl(hIpc,'LogsTextCopy');
 end;
 function EasyIpc_Clear(hIpc:Integer; What:String):Boolean;
 begin
  if (hIpc=0) then EasyIpc_Clear:=false else begin
   if IsSameText(What,'*') or IsSameText(What,'All')
   then What:='RxLost,TxLost,RxFifo,TxFifo,TxTotal,TxTotal,Logs';
   sNul(EasyIpc_Ctrl(hIpc,'Clear='+What));
   EasyIpc_Clear:=true;
  end;
 end;
 {
 LM9 scripting engine.
 }
 function LM9_TabCount:Integer;
 begin
  LM9_TabCount:=HashList_Count(_LM9_TASK_CTRL_TABLE_);
 end;
 function LM9_TidByKey(key:String):Integer;
 begin
  LM9_TidByKey:=Val(key);
 end;
 function LM9_KeyByTid(tid:Integer):String;
 begin
  if (tid=0) then LM9_KeyByTid:='' else LM9_KeyByTid:=Str(tid);
 end; 
 function LM9_IndexOfKey(key:String):Integer;
 begin
  LM9_IndexOfKey:=HashList_IndexOf(_LM9_TASK_CTRL_TABLE_,key);
 end;
 function LM9_KeyByIndex(i:Integer):String;
 begin
  LM9_KeyByIndex:=HashList_GetKey(_LM9_TASK_CTRL_TABLE_,i);
 end;
 function LM9_IndexOfTid(tid:Integer):Integer;
 begin
  LM9_IndexOfTid:=LM9_IndexOfKey(LM9_KeyByTid(tid));
 end;
 function LM9_TidByIndex(i:Integer):Integer;
 begin
  LM9_TidByIndex:=LM9_TidByKey(LM9_KeyByIndex(i));
 end;
 function LM9_IpcByKey(key:String):Integer;
 begin
  LM9_IpcByKey:=HashList_GetLink(_LM9_TASK_CTRL_TABLE_,key);
 end;
 function LM9_IpcByIndex(i:Integer):Integer;
 begin
  LM9_IpcByIndex:=LM9_IpcByKey(LM9_KeyByIndex(i));
 end;
 function LM9_IpcByTid(tid:Integer):Integer;
 begin
  LM9_IpcByTid:=LM9_IpcByKey(LM9_KeyByTid(tid));
 end;
 function LM9_BufByKey(key:String):Integer;
 begin
  LM9_BufByKey:=Round(HashList_GetData(_LM9_TASK_CTRL_TABLE_,key));
 end;
 function LM9_BufByIndex(i:Integer):Integer;
 begin
  LM9_BufByIndex:=LM9_BufByKey(LM9_KeyByIndex(i));
 end;
 function LM9_BufByTid(tid:Integer):Integer;
 begin
  LM9_BufByTid:=LM9_BufByKey(LM9_KeyByTid(tid));
 end;
 function LM9_ParamsByKey(key:String):String;
 begin
  LM9_ParamsByKey:=HashList_GetPara(_LM9_TASK_CTRL_TABLE_,key);
 end;
 function LM9_ParamsByIndex(i:Integer):String;
 begin
  LM9_ParamsByIndex:=LM9_ParamsByKey(LM9_KeyByIndex(i));
 end;
 function LM9_ParamsByTid(tid:Integer):String;
 begin
  LM9_ParamsByTid:=LM9_ParamsByKey(LM9_KeyByTid(tid));
 end;
 function LM9_HasKey(key:String):Boolean;
 begin
  LM9_HasKey:=(LM9_IndexOfKey(key)>=0);
 end;
 function LM9_HasTid(tid:Integer):Boolean;
 begin
  LM9_HasTid:=LM9_HasKey(LM9_KeyByTid(tid));
 end;
 function LM9_Send(tid:Integer; data:String):Boolean;
 begin
  if (tid<>0) and (Length(data)>0)
  then LM9_Send:=EasyIpc_Send(LM9_IpcByTid(tid),data)
  else LM9_Send:=false;
 end;
 function LM9_Post(tid:Integer; data:String):Boolean;
 var buf:Integer;
 begin
  if (tid<>0) and (Length(data)>0) then begin
   buf:=LM9_BufByTid(tid);
   buf:=TextAppendString(buf,data);
   LM9_Post:=(text_numln(buf)>0);
  end else LM9_Post:=false;
 end;
 procedure LM9_KeyFree(key:String);
 var j,tid,ipc,buf:Integer;
 begin
  if (Length(key)>0) then
  if LM9_HasKey(key) then begin
   tid:=LM9_TidByKey(key);
   if (tid<>0) then begin
    if task_wait(tid,0) then bNul(task_kill(tid,1,0,_LM9_TASK_KILL_TIMEOUT_));
    if task_wait(tid,0) then bNul(task_kill(tid,0,0,0));
    bNul(task_free(tid));
   end;
   bNul(FileErase(CookieScan(LM9_ParamsByKey(key),'Caller.tmp',0)));
   ipc:=LM9_IpcByKey(key); if (ipc<>0) then bNul(easyipc_free(ipc));
   buf:=LM9_BufByKey(key); if (buf<>0) then bNul(text_free(buf));
   bNul(HashList_Delete(_LM9_TASK_CTRL_TABLE_,key));
  end;
  ShouldPollStdDiesel:=(LM9_TabCount>0);
 end;
 procedure LM9_TidFree(tid:Integer);
 begin
  if (tid<>0) then LM9_KeyFree(LM9_KeyByTid(tid));
 end;
 function LM9_Launch(lm9,arg,opt,inipar,ipcpar:String):Integer;
 var tid,ipc,buf,i,p:Integer; exe,cmd,tmp,par,ipcpipe:String; ms:Real;
  procedure CmdAdd(var cmd:String; s:String);
  begin
   if not IsEmptyStr(s) then
   if (cmd='') then cmd:=Trim(s) else cmd:=cmd+' '+Trim(s);
  end;
  function ipcname:String;
  var p:Integer;
  begin
   p:=Pos(EOL,ipcpar);
   if (p=0) then p:=Length(ipcpar)+1;
   ipcname:=ExtractWord(1,Copy(ipcpar,1,p-1));
  end;
  function ipcopts:String;
  var p:Integer;
  begin
   p:=Pos(EOL,ipcpar);
   if (p=0) then p:=Length(ipcpar)+1;
   ipcopts:=Copy(ipcpar,p+Length(EOL),Length(ipcpar));
  end;
 begin
  tid:=0; ipc:=0;
  exe:=''; cmd:=''; tmp:=''; par:=''; ipcpipe:='';
  if not IsEmptyStr(lm9) then begin
   lm9:=AdaptFileName(DefaultExtension(lm9,'.lm9'));
   if IsEmptyStr(ExtractFilePath(lm9)) then lm9:=ParamStr('FileSearch '+lm9);
   if not IsEmptyStr(lm9) then lm9:=DaqFileRef(lm9,'.lm9');
   if IsEmptyStr(exe) or not FileExists(exe) then exe:=DieselPascalAssocLm9Exe;
   if IsEmptyStr(exe) or not FileExists(exe) then exe:=DieselPascalCrossMachineExe;
   if IsEmptyStr(exe) or not FileExists(exe) then exe:='';
   if IsEmptyStr(lm9) or not FileExists(lm9) then lm9:='';
   if not IsEmptyStr(lm9) then 
   if not IsEmptyStr(exe) then begin
    CmdAdd(cmd,AnsiQuotedStr(exe,'"'));
    CmdAdd(cmd,AnsiQuotedStr(lm9,'"'));
    tmp:=CreateTempFile('ipc.tmp');
    CmdAdd(cmd,'--params='+tmp);
    ipcpipe:=Trim(ipcname);
    if not IsEmptyStr(ipcpipe) then begin
     ipcpipe:=Trim(ipcpipe)+'_'+ParamStr('CreateGUID nice');
     CmdAdd(cmd,'--easyipc=.\'+ipcpipe);
    end;
    CmdAdd(cmd,arg);
    ms:=mSecNow;
    par:='[Caller.Params]'+EOL
        +'Caller.DateTime='+GetDateTime(ms)+EOL
        +'Caller.TimeStamp='+Str(ms)+EOL
        +'Caller.PID='+Str(GetPid)+EOL
        +'Caller.CRW='+ParamStr('PROGNAME')+EOL
        +'Caller.DAQ='+ParamStr('DAQCONFIGFILE')+EOL
        +'Caller.PAS='+ProgramSourcePas+EOL
        +'Caller.DevName='+DevName+EOL
        +'Caller.CmdLine='+cmd+EOL
        +'Caller.EXE='+exe+EOL
        +'Caller.LM9='+lm9+EOL
        +'Caller.ARG='+arg+EOL
        +'Caller.IPC='+ipcpipe+EOL
        +'Caller.TMP='+tmp+EOL
        +'[]'+EOL
        +inipar;
    if f_reset(tmp,1)=0 then begin
     iNul(f_write(utf8_encode_ansi(par)));
     bNul(f_close);
    end;
    tid:=task_init(cmd);
    if (tid<>0) then begin
     buf:=text_new;
     if not IsEmptyStr(ipcpipe) then ipc:=EasyIpc_Init(ipcpipe,ipcopts);
     bNul(HashList_SetLink(_LM9_TASK_CTRL_TABLE_,LM9_KeyByTid(tid),ipc));
     bNul(HashList_SetPara(_LM9_TASK_CTRL_TABLE_,LM9_KeyByTid(tid),par));
     bNul(HashList_SetData(_LM9_TASK_CTRL_TABLE_,LM9_KeyByTid(tid),buf));
     if not IsEmptyStr(opt) then begin
      i:=0; p:=1;
      repeat
       i:=PosEx(EOL,opt,i+1);
       if (i>0) then begin
        sNul(task_ctrl(tid,Trim(Copy(opt,p,i-p))));
        p:=i+Length(EOL);
       end else begin
        if (p<=Length(opt)) then
        sNul(task_ctrl(tid,Trim(Copy(opt,p,Length(opt)-p+1))));
       end;
      until (i<=0);
     end;
     if task_run(tid) then begin
      Success('Run task #'+Str(tid)+':');
      Success(task_ctrl(tid,'CmdLine'));
     end else Problem('LM9_Launch: Fail run '+lm9);
    end else Problem('LM9_Launch: Fail init '+lm9);
   end;
  end;
  ShouldPollStdDiesel:=(LM9_TabCount>0);
  exe:=''; cmd:=''; tmp:=''; par:=''; ipcpipe:='';
  LM9_Launch:=tid;
 end; 
 procedure LM9_TabClear;
 begin
  _LM9_TASK_CTRL_TABLE_:=0;
 end;
 procedure LM9_TabInit;
 begin
  _LM9_TASK_KILL_TIMEOUT_:=1000;
  _LM9_TASK_CTRL_TABLE_:=HashList_Init(0);
 end;
 procedure LM9_TabFree;
 begin
  while (LM9_TabCount>0) do LM9_KeyFree(LM9_KeyByIndex(0));
  bNul(HashList_Free(_LM9_TASK_CTRL_TABLE_));
  LM9_TabClear;
 end; 
 {
 Clear standard Diesel.
 }
 procedure ClearStdDiesel;
 begin
  LM9_TabClear;
 end;
 {
 Initialize standard Diesel.
 }
 procedure InitStdDiesel;
 begin
  LM9_TabInit;
  if HasDieselPascal then Success('DieselPascal found.');
  LM9_Flag_RedirectRxToStdIn:=true;
  ShouldPollStdDiesel:=false;
 end;
 {
 Finalize standard Diesel.
 }
 procedure FreeStdDiesel;
 begin
  LM9_TabFree;
 end;
 {
 Poll standard Diesel.
 }
 procedure PollStdDiesel;
 var i,ipc,buf,rxl,len:Integer;
 begin
  for i:=0 to LM9_TabCount-1 do begin
   ipc:=LM9_IpcByIndex(i);
   if EasyIpc_Valid(ipc) then begin
    buf:=LM9_BufByIndex(i);
    if (text_numln(buf)>0) then begin
     bNul(EasyIpc_Send(ipc,text_tostring(buf)));
     ClearText(buf); 
    end;
    bNul(EasyIpc_Poll(ipc));
    if (EasyIpc_LogsCount(ipc)>0) then begin
     if DebugFlagEnabled(dfDetails)
     then Details('EasyIpc: '+EasyIpc_BaseName(ipc)+EOL+Trim(EasyIpc_LogsTextMove(ipc)))
     else sNul(EasyIpc_LogsTextMove(ipc));
    end;
    if LM9_Flag_RedirectRxToStdIn then begin
     rxl:=EasyIpc_RxLength(ipc);
     if (rxl>0) then begin
      len:=Round(devPost(devMySelf,utf8_decode_ansi(AdjustLineBreaks(EasyIpc_Recv(ipc,rxl)))));
      if (len=0) then Trouble('Fail LM9 RedirectRxToStdIn.') else begin
       if DebugFlagEnabled(dfDetails) then Details(StrFmt('IPC received %d bytes.',len));
      end;
     end;
    end;
   end;
  end;
 end;
