 {
 ************************************************************************************
 DIO-144 hardware driver.
 DIO-144 includes 6 Intel-8255 24-bit chips Ch0..Ch5, each chip include
  PortA(0..7 bit)
  PortB(8..15 bit)
  PortC, low  nibble(16..19 bit)
  PortC, high nibble(20..23 bit)
 Each of this ports may work for read or white.
 ************************************************************************************
 Configuration example:
  [TagList]
  DIO.Polling = integer 1 ; Enable DIO-144 polling
  [DeviceList]
  &DIO144 = device software program
  [&DIO144]
  Comment        = Digital input/output card DIO-144
  InquiryPeriod  = 1
  DevicePolling  = 10, tpNormal
  ProgramSource  = ..\DaqPas\_DIO144.pas
  DigitalInputs  = 144
  DigitalOutputs = 6
  DelayRunCount  = 1000        ; Switch on card with delay
  tagPolling     = DIO.Polling ; Tag to enable polling
  ;************** Hardware configuration
  Base           = $2C0 ; Base I/O address
  ;******************
  ; I8255 * A B CL CH  - chip port I/O mode table, 0=write, 1=read
  ;******************
  i8255#0 = 1 1  1  1  ; chip CH 0 - Input:A,B,CLo,CHi Output:none
  i8255#1 = 1 1  1  1  ; chip CH 1 - Input:A,B,CLo,CHi Output:none
  i8255#2 = 1 1  1  0  ; chip CH 2 - Input:A,B,CLo     Output:CH
  i8255#3 = 0 0  0  0  ; chip CH 2 - Input:none        Output:A,B,CLo,CHi
  i8255#4 = 1 1  1  1  ; chip CH 1 - Input:A,B,CLo,CHi Output:none
  i8255#5 = 0 0  0  0  ; chip CH 5 - Input:none        Output:A,B,CLo,CHi
  ;************ Digital input, up to 144 bits = 6 chips with 24 bits per chip
  Link DigitalInput   0 with curve DO.CH0  bit 0
  ...
  Link DigitalInput  24 with curve DO.CH1  bit 0
  ...
  Link DigitalInput  48 with curve DO.CH2  bit 0
  ...
  Link DigitalInput  72 with curve DO.CH3  bit 0
  ...
  Link DigitalInput  96 with curve DO.CH4  bit 0
  ...
  Link DigitalInput 144 with curve DO.CH5  bit 0
  ;************ Digital outputs, 6 chips with 24 bits per chip
  Link DigitalOutput 0 with curve DI.CH#0
  Link DigitalOutput 1 with curve DI.CH#1
  Link DigitalOutput 2 with curve DI.CH#2
  Link DigitalOutput 3 with curve DI.CH#3
  Link DigitalOutput 4 with curve DI.CH#4
  Link DigitalOutput 5 with curve DI.CH#5
 ************************************************************************************
 }
program _DIO144;
const
 id8255PortCLo = 1;  {Port C, low nibble}
 id8255PortB   = 2;  {Port B}
 id8255PortCHi = 8;  {Port C, high nibble}
 id8255PortA   = 16; {Port A}
 id8255PortC   = 9;  {Port C, low & high}
var
 b            : Boolean; { Temporary                          }
 Ok           : Boolean; { Is it Ok, can make polling?        }
 errors       : Integer; { Error counter                      }
 errorcode    : Integer; { Device error code                  }
 fixmaxavail  : Integer; { String manager control             }
 DIO          : record   { DIO-144 data                       }
  Init        : Boolean; { Initialization flag                }
  Count       : Integer; { Number of i8255                    }
  I8255       : array[0..5] of record { Intel 8255 chip data  }
   Base       : Integer; { I-8255 chip base address           }
   Mode       : Integer; { I-8255 chip I/O mode flags         }
  end;
 end;
 tagPolling   : Integer; { Tag to enable polling              }
 DelayRunCount: Integer; { Switch on card with delay          }
 s            : String;  { Temporary                          }
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:boolean;
 begin
  if Length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 var b:boolean;
 begin
  if Length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 begin
  s:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Initialize and check tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
 {
 Setup DIO-144 from config file.
 }
 procedure DIO_Setup(aBase:Integer);
 var i,j,sect,base,mode:Integer;
 begin
  DIO.Init:=false;
  for i:=0 to 5 do begin
   DIO.I8255[i].Base:=0;
   DIO.I8255[i].Mode:=0;
  end;
  if aBase>0 then begin
   for i:=0 to 5 do begin
    base:=aBase+i*4;
    mode:=128;
    sect:=ReadIniSection(text_new,28,'','');
    for j:=0 to text_numln(sect)-1 do begin
     s:=text_getln(sect,j);
     if WordCount(s)>=5 then
     if IsSameText(ExtractWord(1,s),'i8255#'+str(i)) then begin
      if Val(ExtractWord(2,s))=1 then mode:=ior(mode,id8255PortA);
      if Val(ExtractWord(3,s))=1 then mode:=ior(mode,id8255PortB);
      if Val(ExtractWord(4,s))=1 then mode:=ior(mode,id8255PortCLo);
      if Val(ExtractWord(5,s))=1 then mode:=ior(mode,id8255PortCHi);
      DIO.Count:=i+1;
     end;
    end;
    b:=text_free(sect);
    DIO.I8255[i].Base:=base;
    DIO.I8255[i].Mode:=mode;
   end;
  end else begin
   Trouble('Invalid Base=$'+HexL(aBase));
  end;
  if DIO.Count>0 then begin
   Success('DIO.Count = '+str(DIO.Count));
   for i:=0 to DIO.Count-1 do begin
    s:='';
    mode:=DIO.I8255[i].Mode;
    if iand(mode,id8255PortA)=0   then s:=s+'w' else s:=s+'r';
    if iand(mode,id8255PortB)=0   then s:=s+'w' else s:=s+'r';
    if iand(mode,id8255PortCLo)=0 then s:=s+'w' else s:=s+'r';
    if iand(mode,id8255PortCHi)=0 then s:=s+'w' else s:=s+'r';
    Success('i8255#'+str(i)+' = $'+HexW(DIO.I8255[i].Base)
                           +',  $'+HexB(DIO.I8255[i].Mode)
                           +' ('+s+')');
   end;
  end else begin
   Trouble('DIO.Count = 0');
  end;
  s:='';
 end;
 {
 Initialize DIO-144 for read or write
 }
 procedure DIO_Init;
 var b:Boolean; i,j,base,mode:Integer;
 begin
  if not DIO.Init then begin
   for i:=0 to DIO.Count-1 do begin
    base:=DIO.I8255[i].Base;
    mode:=DIO.I8255[i].Mode;
    j:=OutPortB(base+3,mode);
   end;
   DIO.Init:=true;
   Success('DIO initialized.');
  end;
 end;
 {
 Poll DIO-144, read/write data
 }
 procedure DIO_Poll;
 var b:Boolean; i,j,base,mode,portA,portB,portC,port:Integer;
 begin
  if DIO.Init then begin
   for i:=0 to DIO.Count-1 do begin
    base:=DIO.I8255[i].Base;
    mode:=DIO.I8255[i].Mode;
    if refdo(i)<>0 then begin
     if iand(mode,id8255PortA) <> 0 then portA:=InPortB(base+0) else portA:=0;
     if iand(mode,id8255PortB) <> 0 then portB:=InPortB(base+1) else portB:=0;
     if iand(mode,id8255PortC) <> 0 then portC:=InPortB(base+2) else portC:=0;
     if iand(mode,id8255PortCLo)= 0 then portC:=iand(portC,240);
     if iand(mode,id8255PortCHi)= 0 then portC:=iand(portC,15);
     port:=portA+ishift(portB,8)+ishift(portC,16);
     b:=putdo(i,time,port);
    end;
    if dimap(i*24,24)<>0 then begin
     port:=Round(diword(i*24,24));
     portA:=iand(port,255);
     portB:=iand(ishift(port,-8),255);
     portC:=iand(ishift(port,-16),255);
     if iand(mode,id8255PortA) <> id8255PortA then j:=OutPortB(base+0,portA);
     if iand(mode,id8255PortB) <> id8255PortB then j:=OutPortB(base+1,portB);
     if iand(mode,id8255PortC) <> id8255PortC then begin
      if iand(mode,id8255PortCLo) <> 0 then portC:=iand(portC,240); {low  nibble is 0}
      if iand(mode,id8255PortCHi) <> 0 then portC:=iand(portC,15);  {high nibble is 0}
      j:=OutPortB(base+2,portC);
     end;
    end;
   end;
  end;
 end;
begin
 {
 Actions on Start
 }
 if runcount=1 then begin
  {
  Initialize errors & variables
  }
  errors:=0;
  errorcode:=registererr(devname);
  ClearStrings;
  if reset('')<>0 then Trouble('Could not reset stdin!');
  if rewrite('')<>0 then Trouble('Could not rewrite stdout!');
  {
  Read config
  }
  tagPolling:=0;
  s:=ReadIni('tagPolling');
  if Length(s)>0 then InitTag(tagPolling,s,1);
  DelayRunCount:=Val(ReadIni('DelayRunCount'));
  DIO_Setup(Val(ReadIni('Base')));
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok') else Trouble('Start fails');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Actions on Stop
 }
 if isinf(runcount) then begin
  DIO.Init:=false;
  Success('Stop');
  ClearStrings;
 end else 
 {
 Actions on Polling
 }
 if Ok then begin
  {
  Make data acquisition only if polling enabled.
  }
  if RunCount>DelayRunCount then {after some delay}
  if (tagPolling=0) or (iGetTag(tagPolling)>0) then begin
   {
   if DIO is not initialized, make initialization.
   }
   if not DIO.Init then DIO_Init;
   {
   Poll DIO only if one already initialized.
   }
   if DIO.Init then DIO_Poll;
  end;
 end;
end.
