 {
 ***********************************************************************
 Daq Pascal application program DatSrv.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
|********************************************************
[]
 ***************************************************************************
 Универсальная программа сохранения данных в файл *.dat.
 Выполняет периодическое сохранение списка кривых в файл.
 Предполагается, что сохранение идет достаточно редко, скажем, раз в минуту.
 При сохранении данные записываются все, без потерь, то есть записываются
 исторические данные, а не только текущее значение.
 При этом предполагается, что кривые содержат данные (x,y), где x-время
 по часам DAQ, функция time (в частности, данные упорядочены по x).
 Утилиту НЕ СЛЕДУЕТ применять для данных других типов.
 За счет округления и упаковки объем сохраняемых данных сильно сокращается.
 При сохранении контролируется время CPU, чтобы не блокировать ресурсы на
 длительное время.
 ***************************************************************************
 Тег WriteEnableTag разрешает запись.
 Тег WriteErrorsTag считает ошибки записи.
 Список кривых для сохранения задается в виде
      CurveList = Curve1,Curve2,...Section1,Section2...
 где CurveN - имя кривой, SectionN - имя секции, содержащей список кривых
 ***************************************************************************
 Каталог сохранения задается переменной DataPath.
 Переменная SavePeriod задает период сохранения в секундах.
 Переменная TimeQuota задает максимальное время обработки за один вызов,
 чтобы не блокировать ресурсы надолго.
 Переменная DataFormat из набора (XY:ASCII,XY:HEX,XY:BASE64) задает формат
 сохранения данных.
 Данные сохраняются в суточный файл типа PPYYYYMMDD.DAT (QMS_20050819.DAT)
 где  PP         - префикс, задается переменной FilePrefix
      YYYY,MM,DD - год, месяц, день
 ***************************************************************************
 Пример конфигурации:
      [TagList]
      DATSRV.GATE     = integer 1
      DATSRV.BUGS     = real    0
      [DeviceList]
      &DATSRV = device software program
      [&DATSRV]
      Comment         = DAT server to save data to *.dat files
      InquiryPeriod   = 1
      DevicePolling   = 1000, tpNormal
      ProgramSource   = ~~\resource\daqsite\datserver\datsrv.pas
      OpenConsole     = 1
      DebugFlags      = 15
      StdInFifo       = 128
      StdOutFifo      = 1024
      IntegrityMode   = 2
      SavePeriod      = 300
      TimeQuota       = 100
      FilePrefix      = CRW-DAQ_
      DataPath        = ..\..\CRW-DAQ_DATA
      DataFormat      = XY:BASE64
      WriteEnableTag  = DATSRV.GATE
      WriteErrorsTag  = DATSRV.BUGS
      []
      [&DATSRV]
      CurveList       = QMS_CH0, QMS_CH1
      CurveList       = [QMS_Curves]     
      []
 ***************************************************************************
 }
program DATSRV;                  { DAT Server                       }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 maxndat       = 1024;           { Max. number of items to save     }
 maxbuff       = 256;            { Max. number of records per save  }
 idAwake       = 'Awake!';
 idFile        = 'File';
 idClear       = 'Clear';
 idCurve       = 'Curve';
 idReply       = 'Reply';
 idSender      = 'Sender';
 idFileMime    = 'FileMime';
 idReplyMime   = 'ReplyMime';
 idCurveList   = 'CurveList';
 idDataFormat  = 'DataFormat';
 idFileHeader  = '[CRW-DAQ DATA FILE]';
 idFormatList  = 'XY:ASCII,XY:HEX,XY:BASE64';
 idFormat      = '@Format=';
 fmtAscii      = 0;
 fmtHex        = 1;
 fmtBase64     = 2;
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 tagSave       : Integer;        { Button to save data              }
 tagSaveErr    : Integer;        { Error counter                    }
 fpath,fpref   : String;         { File path & prefix               }
 fname,sname   : String;         { File name & save file            }
 flast,fnice   : String;         { Last file name & nice name       }
 DataFormat    : Integer;        { See idFormatList                 }
 TimeQuota     : Integer;        { Max. time slice duration         }
 ndat          : integer;        { Number of items to save          }
 crvref        : array[1..maxndat] of Integer;
 tstamp        : array[1..maxndat] of Real;
 buff_x        : array[1..maxbuff] of Real;
 buff_y        : array[1..maxbuff] of Real;
 TextToSave    : Integer;
 AwakeCount    : Integer;
 SavePeriod    : Real;
 EnterTime     : Real;
 LastSave      : Real;
 IntegrityMode : Integer;

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 Fix file write error
 }
 procedure SaveErr(msg:string);
 begin
  Trouble(msg);
  bNul(rSetTag(tagSaveErr,rGetTag(tagSaveErr)+1));
 end;
 {
 Get file name corresponded to ms time.
 }
 function GetFName(ms:Real):String;
 begin
  GetFName:=AddPathDelim(fpath)+fpref+Str(GetDateAsNumber(ms))+'.dat';
 end;
 {
 Get nice (short) file name.
 }
 function GetNiceName(fn:String):String;
 begin
  fn:=MakeRelativePath(fn,ParamStr('DaqConfigPath'));
  if not IsRelativePath(fn) then fn:=ExtractFileName(fn)+ExtractFileExt(fn);
  GetNiceName:=fn;
 end;
 {
 Clear curve list and counter.
 }
 procedure ClearCurveList;
 var i:Integer;
 begin
  ndat:=0;
  for i:=1 to maxndat do crvref[i]:=0;
 end;
 {
 Read CurveList=C1,C2,...,[Sec1],[Sec2]
 Use recursion to read sections. 
 }
 procedure ReadCurveList(Section:String);
 var line,item:String; i,j,k,n,crv,txt:Integer;
 begin
  line:='';item:='';
  txt:=ReadIniSection(text_new,28,ParamStr('DaqConfigFile'),Section);
  for i:=0 to text_numln(txt)-1 do begin
   line:=Trim(text_getln(txt,i));
   if IsSameText(ExtractWord(1,line),idCurveList) then
   for j:=2 to WordCount(line) do begin
    item:=ExtractWord(j,line);
    crv:=RefFind('Curve '+item);
    if crv<>0 then begin
     n:=0;
     for k:=1 to ndat do if crv=crvref[k] then n:=n+1;
     if n=0 then
     if ndat<maxndat then begin
      crvref[ndat+1]:=crv;
      ndat:=ndat+1;
     end;
    end else
    if (pos('[',item)=1)and (pos(']',item)=Length(item))
    then ReadCurveList(item)
    else Trouble('Could not find curve '+item);
   end;
  end;
  bNul(text_free(txt));
  line:='';item:='';
 end;
 {
 Execute command: TextMetaData --add filename
 }
 procedure TextMetaDataAdd(filename:String; IntegrityMode:Integer);
 var tid:Integer; exe:string;
 begin
  exe:='';
  if not IsEmptyStr(filename) and FileExists(filename) then begin
   if IntegrityMode=1 then rNul(Eval('@system @async @silent @integrity --add '+filename)) else
   if IntegrityMode=2 then rNul(Eval('@system @async @silent @run -hide textmetadata --add '+filename));
   if IntegrityMode=3 then begin
    if IsUnix then exe:='unix textmetadata';
    if IsWindows then exe:=ParamStr('FileSearch textmetadata.exe');
    if not IsEmptyStr(exe) then begin 
     tid:=task_init(exe+' --add '+filename);
     sNul(task_ctrl(tid,'Display=0'));
     if task_run(tid)
     then Success('Run pid '+Str(task_pid(tid))+' by command '+task_ctrl(tid,'CmdLine'))
     else Trouble('Could not run command '+task_ctrl(tid,'CmdLine'));
     bNul(task_free(tid));
    end else Trouble('Could not find textmetadata');
   end;
  end;
  exe:='';
 end;
 {
 Write time stamp, original file name etc.
 }
 procedure WriteTimeStamp(ms:Real; fname:String);
 begin
  writeln('@TimeStamp='+Str(ms));
  writeln('@DateTime='+GetDateTime(ms));
  writeln('@OriginalHostName='+ParamStr('HostName'));
  writeln('@OriginalFileName='+fname);
  writeln('@OriginalConfigFile='+ParamStr('DaqConfigFile'));
 end;
 {
 Write CurveList=C1,C2,... in readable form
 }
 procedure WriteCurveList(Prefix:String);
 var s:String; i:Integer;
 begin
  s:='';
  for i:=1 to ndat do begin
   if Length(s)>0 then s:=s+',';
   s:=s+crvname(crvref[i]);
   if Length(s)>60 then begin
    writeln(Prefix+'CurveList='+s);
    s:='';
   end;
  end;
  if Length(s)>0 then writeln(Prefix+'CurveList='+s);
  s:='';
 end;
 {
 Get data from curve by index num as text with reference "ref"
 }
 procedure GetDataAsText(ref,num:Integer);
 var b:Boolean; n,m,i,j,len:Integer; s:String;
     crv,stamp,tb,tu,ms,x,y,t,mks:Real;
 begin
  n:=0;
  m:=0;
  s:='';
  mks:=mksecnow;
  crv:=crvref[num];
  stamp:=tstamp[num];
  if crvlock(crv) then begin
   len:=Round(crvlen(crv));
   if len>0 then
   if crvx(crv,len)>stamp then begin
    j:=Round(crvwhere(crv,stamp));
    n:=len-j+1;
    if n>maxbuff then begin
     AwakeCount:=AwakeCount+1;
     n:=maxbuff;
    end;
    for i:=1 to n do begin
     buff_x[i]:=crvx(crv,j);
     buff_y[i]:=crvy(crv,j);
     j:=j+1;
    end;
   end;
   b:=crvunlock(crv);
  end;
  mks:=mksecnow-mks;
  if n>0 then begin
   s:='';
   tb:=TimeBase;
   tu:=TimeUnits;
   b:=text_addln(ref,'['+crvname(crv)+']');
   b:=text_addln(ref,idFormat+ExtractWord(DataFormat+1,idFormatList));
   for i:=1 to n do begin
    x:=buff_x[i];
    y:=buff_y[i];
    t:=int(x*tu+tb);
    if x>stamp then begin
     stamp:=x;
     if DataFormat=fmtAscii then begin
      b:=text_addln(ref,Str(t)+chr(9)+Str(y));
     end else
     if DataFormat=fmtHex then begin
      s:=s+dump(t)+dump(y);
      if Length(s)>=64 then begin
       b:=text_addln(ref,hex_encode(s));
       s:='';
      end;
     end else
     if DataFormat=fmtBase64 then begin
      s:=s+dump(t)+dump(y);
      if Length(s)>=96 then begin
       b:=text_addln(ref,mime_encode(s));
       s:='';
      end;
     end;
     m:=m+1;
    end;
   end;
   if Length(s)>0 then begin
    if DataFormat=fmtHex    then b:=text_addln(ref,hex_encode(s));
    if DataFormat=fmtBase64 then b:=text_addln(ref,mime_encode(s));
    s:='';
   end;
   tstamp[num]:=stamp;
   if DebugFlagEnabled(dfViewExp) then
   ViewExp(strfix(m,3,0)+' point(s)++, '+crvname(crv)+
           ', dead time '+strfix(mks,4,0)+' mks');
  end;
  s:='';
 end;
 {
 Read curve from file.
 }
 function ReadCurveFromFile(Curve:Integer; FName:String):Integer;
 var line:string; ms,r,t,t0,tu,tb,y:Real; Inside:Boolean;
     i,n,fmt,Count,rsize,bugTime,bugData,bugSort,bugForm:Integer;
  procedure Report;
  begin
   Success(Str(n)+' line(s) processed, '+strfix(msecnow-t0,1,0)+' ms.');
  end;
  procedure AddPoint(t,y:Real);
  var b:Boolean; r,x:Real;
  begin
   if IsNan(t) then bugTime:=bugTime+1 else
   if IsNan(y) then bugData:=bugData+1 else begin
    x:=(t-tb)/tu;
    if crvlock(Curve) then begin
     if (crvlen(Curve)=0) or (x>crvx(Curve,crvlen(Curve)))
     then Count:=Count+Round(crvins(Curve,maxint,x,y))
     else bugSort:=bugSort+1;
     b:=crvunlock(Curve);
    end;
   end;
  end;
 begin
  line:='';
  Count:=0;
  bugTime:=0;
  bugData:=0;
  bugSort:=0;
  bugForm:=0;
  fmt:=maxint;
  t0:=msecnow;
  ms:=msecnow;
  tb:=TimeBase;
  tu:=TimeUnits;
  Inside:=false;
  rsize:=Length(dump(pi));
  if FileExists(FName) then begin
   if reset(FName)=0 then begin
    n:=0;
    while StdIn_Readln(line) and (msecnow-wdt_reset(true)<5000) do begin
     line:=Trim(line);
     if Length(line)>0 then begin
      if strFetch(line,1)='[' then begin
       if line[Length(line)]=']' then begin
        line:=Copy(line,2,Length(line)-2);
        Inside:=IsSameText(line,crvname(Curve));
       end;
      end else
      if Inside then begin
       if strFetch(line,1)='@' then begin
        if IsSameText(Copy(line,1,Length(idFormat)),idFormat) then begin
         line:=Copy(line,Length(idFormat)+1,255);
         for i:=fmtAscii to fmtBase64 do
         if IsSameText(line,ExtractWord(i+1,idFormatList))
         then fmt:=i;
        end;
       end else begin
        if fmt=fmtAscii then begin
         t:=rval(ExtractWord(1,line));
         y:=rval(ExtractWord(2,line));
         AddPoint(t,y);
        end else
        if fmt=fmtHex then begin
         line:=hex_decode(line);
         i:=1;
         while i+rsize*2-1 <= Length(line) do begin
          t:=dump2r(Copy(line,i,rsize));
          i:=i+rsize;
          y:=dump2r(Copy(line,i,rsize));
          i:=i+rsize;
          AddPoint(t,y);
         end;
        end else
        if fmt=fmtBase64 then begin
         line:=mime_decode(line);
         i:=1;
         while i+rsize*2-1 <= Length(line) do begin
          t:=dump2r(Copy(line,i,rsize));
          i:=i+rsize;
          y:=dump2r(Copy(line,i,rsize));
          i:=i+rsize;
          AddPoint(t,y);
         end;
        end else begin bugForm:=bugForm+1; writeln(line); end;
       end;
      end;
     end;
     n:=n+1;
     if n mod 1000 = 0 then Report;
     if msecnow-ms>TimeQuota then begin
      bNul(Sleep(1));
      ms:=msecnow;
     end;
    end;
    if Reset('')<>0 then Trouble('StdIn reset error!');
    if IoResult<>0 then Trouble('Read error: '+FName);
   end else begin
    Trouble('Reset error: '+FName);
    if Reset('')<>0 then Trouble('StdIn reset error!');
    if IoResult<>0 then Trouble('Read error: '+FName);
   end;
  end;
  Report;
  if bugTime+bugData+bugSort+bugForm>0
  then writeln(devname,' ? Found bugs, Time:',bugTime:1,' Data:',bugData:1,
                                     ' Sort:',bugSort:1,' Form:',bugForm:1);
  ReadCurveFromFile:=Count;
  line:='';
 end;
 {
 Analyse messages coming from StdIn:
  Awake!
  Clear Curve=QMS_CH0 Sender=&QMS_CRWSAVE Reply=Clear
  Load Curve=QMS_CH0 File=..\Data\QMS_20050820 Sender=&QMS_CRWSAVE Reply=Load
 }
 procedure AnalyseInput(var Data:String);
 var i,n,Curve,Sender:Integer; r:Real; Reply,FName:String;
 begin
  FName:='';
  Reply:='';
  if Length(Data)>0 then begin
   if IsSameText(ExtractWord(1,Data),idAwake) then Data:='';
   if IsSameText(ExtractWord(1,Data),idClear) then begin
    i:=2;
    Curve:=0;
    Sender:=0;
    while i<=WordCount(Data) do begin
     if IsSameText(ExtractWord(i,Data),idCurve) then begin
      Curve:=RefFind('Curve '+ExtractWord(i+1,Data));
      i:=i+2;
     end else
     if IsSameText(ExtractWord(i,Data),idSender) then begin
      Sender:=RefFind('Device '+ExtractWord(i+1,Data));
      i:=i+2;
     end else
     if IsSameText(ExtractWord(i,Data),idReply) then begin
      Reply:=ExtractWord(i+1,Data);
      i:=i+2;
     end else
     if IsSameText(ExtractWord(i,Data),idReplyMime) then begin
      Reply:=mime_decode(ExtractWord(i+1,Data));
      i:=i+2;
     end else
     begin
      Trouble('Unknown parameter '+ExtractWord(i,Data));
      i:=i+1;
     end;
    end;
    if Curve<>0 then
    for i:=1 to ndat do
    if crvref[i]=Curve then begin
     r:=crvdel(Curve,1,maxint);
     Success('Clear Curve='+crvname(Curve));
     if (Sender<>0) and (Length(Reply)>0) then begin
      r:=DevSend(Sender,Reply+EOL);
      if DebugFlagEnabled(dfViewExp) then
      ViewExp('Send '+Str(r)+' char(s) to '+RefInfo(Sender,'Name'));
     end;
    end;
    Data:='';
   end;
   if IsSameText(ExtractWord(1,Data),'Load') then begin
    i:=2;
    Curve:=0;
    Sender:=0;
    while i<=WordCount(Data) do begin
     if IsSameText(ExtractWord(i,Data),idCurve) then begin
      Curve:=RefFind('Curve '+ExtractWord(i+1,Data));
      i:=i+2;
     end else
     if IsSameText(ExtractWord(i,Data),idSender) then begin
      Sender:=RefFind('Device '+ExtractWord(i+1,Data));
      i:=i+2;
     end else
     if IsSameText(ExtractWord(i,Data),idReply) then begin
      Reply:=ExtractWord(i+1,Data);
      i:=i+2;
     end else
     if IsSameText(ExtractWord(i,Data),idReplyMime) then begin
      Reply:=mime_decode(ExtractWord(i+1,Data));
      i:=i+2;
     end else
     if IsSameText(ExtractWord(i,Data),idFile) then begin
      FName:=ExtractWord(i+1,Data);
      if Length(FName)>0 then FName:=DaqFileRef(FName,'.dat');
      i:=i+2;
     end else
     if IsSameText(ExtractWord(i,Data),idFileMime) then begin
      FName:=mime_decode(ExtractWord(i+1,Data));
      if Length(FName)>0 then FName:=DaqFileRef(FName,'.dat');
      i:=i+2;
     end else
     begin
      Trouble('Unknown parameter '+ExtractWord(i,Data));
      i:=i+1;
     end;
    end;
    if Curve<>0 then
    for i:=1 to ndat do
    if crvref[i]=Curve then begin
     if FileExists(FName) then begin
      n:=ReadCurveFromFile(Curve,FName);
      Success('Load Curve='+crvname(Curve)+' File='+FName);
      Success(Str(n)+' point(s) loaded');
      if (Sender<>0) and (Length(Reply)>0) then begin
       r:=DevSend(Sender,Reply+EOL);
       if DebugFlagEnabled(dfViewExp) then
       ViewExp('Send '+Str(r)+' char(s) to '+RefInfo(Sender,'Name'));
      end;
     end else Trouble('File not exists: '+FName);
    end;
    Data:='';
   end;
  end;
  FName:='';
  Reply:='';
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  fname:='';
  sname:='';
  fpath:='';
  fpref:='';
  flast:='';
  fnice:='';
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 var s:String; i:Integer;
 begin
  s:='';
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,MaxInt,0);
  {
  Initialize errors & strings, clear variables.
  }
  if reset('')<>0 then SaveErr('Stdin error!');
  if append('')<>0 then SaveErr('Stdout error!');
  {
  Read parameters from config file
  }
  InitTag( tagSave,       ReadIni('WriteEnableTag'), 1);
  InitTag( tagSaveErr,    ReadIni('WriteErrorsTag'), 2);
  {
  Read & check file path & prefix & data format
  }
  fpath:=AdaptFileName(ReadIni('DataPath'));
  if Length(fpath)>0 then fpath:=DaqFileRef(fpath,'');
  if IsWindows then fpath:=LoCaseStr(fpath);
  if MkDir(fpath)
  then Success('DataPath='+fpath)
  else Trouble('Data path INVALID: '+fpath);
  fpref:=LoCaseStr(ReadIni('FilePrefix'));
  Success('FilePrefix='+fpref);
  DataFormat:=fmtAscii;
  s:=ReadIni('DataFormat');
  for i:=fmtAscii to fmtBase64 do
  if IsSameText(s,ExtractWord(i+1,idFormatList))
  then DataFormat:=i;
  Success('DataFormat='+ExtractWord(DataFormat+1,idFormatList));
  TimeQuota:=iValDef(ReadIni('TimeQuota'),100);
  Success('TimeQuota='+Str(TimeQuota));
  IntegrityMode:=iValDef(ReadIni('IntegrityMode'),0);
  Success('IntegrityMode='+Str(IntegrityMode));
  {
  Read & check data list
  }
  ClearCurveList;
  ReadCurveList('['+devname+']');
  if ndat>0
  then WriteCurveList(devname+' : ')
  else Trouble('CurveList not found!');
  {
  Initialize polling variables & TextToSave
  }
  LastSave:=SecNow;
  SavePeriod:=rValDef(ReadIni('SavePeriod'),60);
  TextToSave:=text_new;
  s:='';
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  TextMetaDataAdd(flast,3);
  if append('')<>0 then SaveErr('Stdout error!');
  if reset('')<>0 then SaveErr('Stdin error!');
  bNul(text_free(TextToSave));
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 var i:Integer;
 begin
  if AwakeFlag then Success('Awoke, wdt='+Str(msecnow-wdt_reset(false))+' ms');
  {
  Save data
  }
  if iGetTag(tagSave)>0 then begin
   AwakeCount:=0;
   EnterTime:=msecnow;
   if (abs(secnow-LastSave)>SavePeriod) or AwakeFlag then begin
    LastSave:=secnow;
    if not MkDir(fpath) then Trouble('Could not mkdir '+fpath);
    fname:=GetFName(mSecNow);
    fnice:=GetNiceName(fname);
    if not FileExists(fname) then
    if Rewrite(fname)=0 then begin
     Writeln(idFileHeader);
     WriteTimeStamp(mSecNow,fname);
     WriteCurveList('');
     if Append('')<>0 then SaveErr('Stdout error!');
     if IoResult=0
     then Success('Header written.')
     else SaveErr('Write error: '+fname);
    end else begin
     if Append('')<>0 then SaveErr('Stdout error!');
     SaveErr('Create error: '+fname);
    end;
    ClearText(TextToSave);
    for i:=1 to ndat do begin
     if msecnow-EnterTime<TimeQuota
     then GetDataAsText(TextToSave,i)
     else AwakeCount:=AwakeCount+1;
    end;
    if AwakeCount>0 then
    if DevSend(devMySelf,idAwake+EOL)=0 then Trouble('DevSend fails!');
    if text_numln(TextToSave)>0 then
    if Append(fname)=0 then begin
     for i:=0 to text_numln(TextToSave)-1 do Writeln(text_getln(TextToSave,i));
     if Append('')<>0 then SaveErr('Stdout error!');
     if IoResult=0
     then Success(Str(text_numln(TextToSave))+' line(s) written to '+fnice+'.')
     else SaveErr('Write error: '+fname);
    end else begin
     if Append('')<>0 then SaveErr('Stdout error!');
     SaveErr('Append error: '+fname);
    end;
    ClearText(TextToSave);
    if flast<>fname then begin
     TextMetaDataAdd(flast,IntegrityMode);
     flast:=fname;
    end;
    sname:=fname;
   end;
  end;
  if SysTimer_Pulse(1000)>0 then begin
   if Length(sname)>0 then begin
    rNul(Eval('@system @async @silent @integrity SAVE.DAT '+sname));
    sname:='';
   end;
  end;
  {
  Handle button click.
  }
  if (ClickButton=1) then begin
   if ClickTag=tagSave then begin
    bNul(iSetTag(clicktag,Ord(iGetTag(clicktag)=0)));
    bNul(Voice(snd_Click));
   end;
   if ClickTag=tagSaveErr then begin
    bNul(iSetTag(clicktag,0));
    bNul(Voice(snd_Click));
   end;
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String;
 begin
  Data:=Trim(Data);
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @TextMetaDataAdd 3
   }
   if IsSameText(cmd,'@TextMetaDataAdd') then begin
    TextMetaDataAdd(flast,iValDef(arg,IntegrityMode));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  if Length(Data)>0 then AnalyseInput(Data);
  if Length(Data)>0 then Trouble('Unknown message: '+Data);
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
