---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Справка по &RS485Proxy

Здесь приводится справка по **[RS485Proxy](./)** - прокси-драйверу для устройств на шине **RS-485**.

**RS-485** является общей **шиной данных** (_data bus_), т.е. обеспечивает доступ
к **множеству** устройств через **одну** линию связи.
По этой причине доступ драйверов устройств к шине **RS-485** должен быть упорядочен,
т.е. запросы устройств должны быть выстроены в очередь.
Такой упорядоченный (последовательный) доступ к общему ресурсу (шине данных) называется **сериализацией**.
Сериализация гарантирует, что устройства будут опрашиваться последовательно (по очереди)
и не будут мешать друг другу в процессе опроса.
Сериализацию выполняет драйвер - **посредник** или **прокси** (_proxy_), который взаимодействует
с клиентскими драйверами устройств и выстраивает их запросы в очередь.

Таким образом, **&RS485Proxy** - это прокси-драйвер для сериализации доступа устройств к шине данных **RS-485**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="purpose"></a>

## Назначение

Драйвер **&RS485Proxy** реализует обмен данными по интерфейсу **RS485**.

**&RS485Proxy** полностью основан на коде **[&ModBusProxy](../modbusserver/)**.
В текущей версии поддерживается до **16** логических портов.
Это число легко изменить, задав константу **[MaxPortNum](rs485proxy.pas)**.
При этом значение не должно превышать **250**.

Драйвер **&RS485Proxy** является универсальным посредником (_proxy_), связующим звеном между подчиненными драйверами
и устройствами на шине **RS-485**.
Драйвер **&RS485Proxy** ничего не делает сам по себе, он лишь обеспечивает прием и передачу данных через порты
по интерфейсу **RS485**, выстраивая опросы от драйверов в очередь и предотвращая конфликты при наличии множества
устройств на каждом порте.
В то же время подчиненные драйверы напрямую не работают с физическими портами (**TCP**,**COM**),
они работают с логическими портами (номерами **1..16**).
Всю работу, связанную с физическими портами, берет на себя драйвер **&RS485Proxy**.

Подчиненные драйверы периодически посылают в консоль **&RS485Proxy** команду **`@RS485.Poll`** которая помещается
в очередь для последующего выполнения.
Когда приходит очередь, драйвер **&RS485Proxy** инициирует опрос физического порта,
связанного с указанным в запросе логическим портом и по результатам опроса посылает драйверу результат
в виде консольной команды **`@RS485.Reply`**, **`@RS485.Refuse`** или **`@RS485.TimeOut`**.

**&RS485Proxy** не требует регистрации драйверов, которые к нему обращаются, поскольку в каждом запросе
указывается имя (или ссылка) драйвера, которому надо передать ответ для последующей обработки.
Таким образом, драйверы устройств могут пользоваться услугами прокси-драйвера **&RS485Proxy** в довольно свободном режиме.
Например, драйвер устройств может обрабатывать ввод-вывод нескольких модулей на разных портах,
а разные драйверы устройств могут опрашивать один модуль.
Драйвер **&RS485Proxy** обеспечивает бесконфликтную сериализацию (выстраивание опросов в очередь).
Таким образом, подчиненные драйверы устройств могут сосредоточиться на обработке данных.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="config"></a>

# Конфигурирование

Конфигурирование прокси-драйвера **&RS485Proxy** состоит из двух действий:

- Создания конфигурации устройства прокси-драйвера,  
- Описания подключений портов в секции **Startup**.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Стандартная конфигурация

Наиболее простой и рекомендуемый в общем случае способ создания конфигурации устройства
прокси-драйвера **&RS485Proxy** - это включение в файл **DAQ**-конфигурации
стандартного (**[default](../default/rs485proxy.cfg)**)
файла **[конфигурации](rs485proxy.cfg)**:

``` ini
[ConfigFileList]
ConfigFile = ~~\resource\daqsite\default\rs485proxy.cfg
[]
```

Кроме этого в секцию **[\[&RS485Proxy.StartupScript\]](#startupscript)** **необходимо**
поместить команды для подключения портов **RS485**, тегов счётчиков и частот опроса.

Стандарная конфигурация объявляет устройство с именем **&RS485Proxy**, которое является стандартным именем
для клиента **RS485Proxy**. Поскольку этот клиент обслуживает много портов, в обычном случае в конфигурации
достаточно иметь один прокси-драйвер, который будет работать со всеми устройствами на портах **RS-485/422/232**.
При необходимости максимальное число портов можно увеличить.

Надо напомнить, что **[конфигурационные файлы](../../manual/crwdaq-cfg.htm)** позволяют переопределять параметры,
так что использование стандарной конфигурации ничем вас не ограничивает.
Стандартная конфигурация будет определять значения по умолчанию,
а явно заданные параметры - актуальные значения.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Шаблон конфигурации

Если же вы захотите сделать полностью свою настройку **&RS485Proxy**,
используйте такой шаблон:

``` ini
[DeviceList]
&RS485Proxy = device software program
[&RS485Proxy]
Comment       = RS485 PROXY MASTER.
InquiryPeriod = 0
DevicePolling = 4, tpTimeCritical
ProgramSource = ~~\resource\daqsite\rs485proxy\rs485proxy.pas
DebugFlags    = 3
OpenConsole   = 2
StdInFifo     = 512
StdOutFifo    = 512
StartingOrder = -1024
StoppingOrder = +1024
StartupScript = [&RS485Proxy.StartupScript]
FinallyScript = [&RS485Proxy.FinallyScript]
[]
```

Кроме этого в секцию **[\[&RS485Proxy.StartupScript\]](#startupscript)** **необходимо**
поместить команды для подключения портов **RS485**, тегов счётчиков и частот опроса.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="startupscript"></a>

## Секция [&RS485Proxy.StartupScript]

Таблица логических портов **RS485Proxy** задается в секции **`[&RS485Proxy.StartupScript]`**
через консольные **команды**, описанные ниже. Поэтому эта секция обязательно должна быть описана.
Хотя, строго говоря, все описание может генерироваться и динамически, через посылку сообщений.
При этом размер буфера **`StdInFifo`** должен быть достаточным для размещения таблиц
из секции **`StartupScript`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="startupscript_commands"></a>

### Команды конфигурации портов

В секции **[&RS485Proxy.StartupScript]** используются такие команды,
служащие для конфигурации портов, тегов и других параметров:

``` ini
@Reset
@View
@View port
@Port port decl
@PortErrorRates port Rx Tx
@PortErrorCounters port Rx Tx
@PortPollRates port Rx Tx
@PortPollCounters port Rx Tx
@PortByteRates port Rx Tx
@PortByteCounters port Rx Tx
@TimeGap port gap
```

где

+ **port** - логический порт, **1**..**16**;  
+ **decl** - описание порта, например:  
  **`tcp port 502 client localhost`** - описание **TCP** подключения,  
  **`com port 1 baudrate 9600 parity even databits 8 stopbits 1`** - описание **COM** порта;  
+ **Rx**/**Tx**   - имена тегов (типа **integer** или **real**) для накопления счётчиков приема/передачи;  
  счётчики **Counters** содержат суммарный счёт, **Rates** - счёт за последнюю секунду (т.е. **частоту**).  
  счётчики **Error**/**Poll**/**Byte** содержат счёт числа ошибок/опросов/байтов.  
  Например, **@PortPollRates port Rx Tx** задает теги частот опросов приемника и передатчика.  
+ **gap**  - временной зазор (пауза) между опросами, **мс**;  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @Reset

Команда **`@Reset`** очищает все таблицы портов и приводит клиент **RS485Proxy** в исходное состояние.  

С этой команды рекомендуется начинать описание таблиц портов клиента в секции **`StartupScript`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @View


Команда **`@View port`** служит для отображения (в консоли) таблицы данных для данного порта.
Если порт не указан, то в консоли отображается таблица всех портов.

Эта команда применяется для контроля задания таблиц при отладке.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @ZeroPortCounters

Команда **`@ZeroPortCounters`** очищает (обнуляет) все теги со счётчиками ошибок.  

Эту команду можно дать при старте, после инициализации всех таблиц портов.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @Port

Команда **`@Port port decl`** задает (декларирует, добавляет) порт таблицу логических портов.

**Логический порт** - это просто номер (индекс в таблице физических портов) для последующего подключения к нему устройств.
Каждый логический порт имеет номер **port** и определение **decl**.
В данной версии номера логических портов port занимают диапазон (**1**..**16**).
Определение **decl** может содержать описание порта **TCP** или **COM**, как описано в справке
по функции **[pipe_init](../../manual/daqpascalapi.htm#pipe_init)**.
При этом **TCP** подключение должно быть клиентским.

Например:

``` ini
@port 1 tcp port 5300 client localhost
# логический порт №1 использует TCP порт №5300
# TCP клиент соединяется с сервером localhost.

@port 2 com port 4 baudrate 9600 parity even databits 8 stopbits 1
# логический порт №2 использует COM порт №4, скорость 9600 бит/сек,
# контроль четности EVEN, 8 бит данных, 1 стоповый бит.
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Команда @PortPollRates
### Команда @PortByteRates
### Команда @PortErrorRates
### Команда @PortPollCounters
### Команда @PortByteCounters
### Команда @PortErrorCounters

Эти команды задают теги для счётчиков (_counters_) или частот (_rates_)
для числа опросов (_poll_), байтов (_bytes_) или ошибок (_errors_).

+ Командой **`@PortErrorCounters port Rx Tx Ex`** можно задать теги счётчиков ошибок данного порта **port**.  
+ Командой **`@PortErrorRates port Rx Tx Ex`** можно задать теги скорости счёта ошибок данного порта **port**.  

Здесь

- **port** - номер логического порта.  
- **Rx** - имя тега для счётчика ошибок приемника: неверный адрес, контрольна сумма и т.д.,  
- **Tx** - имя тега для счётчика ошибок передатчика, когда не удается отправить запрос.  
- **Ex** - имя тега для суммарного счётчика ошибок приемника и передатчика,  

Аналогично задаются теги для подсчёта траффика:

+ Командой **`@PortPollCounters port Rx Tx`** можно задать теги счётчиков запросов данного порта.  
+ Командой **`@PortPollRates port Rx Tx`** можно задать теги скорости поступления запросов данного порта.  
+ Командой **`@PortByteCounters port Rx Tx`** можно задать теги счётчиков потока байтов данного порта.  
+ Командой **`@PortByteRates port Rx Tx`** можно задать теги скорости счёта потока байтов данного порта.  

Теги счётчиков могут иметь тип **Integer** или **Real** (лучше **Real**).
При необходимости общего счётчика допустимо многократно ссылаться на один и тот же тег,
в этом случае счёта из разных источников будут складываться.

Использование тегов счётчиков является необязательным. Если счётчики не нужны, их можно не описывать.

В случае, если теги ошибок не указаны, будут инкрементироваться стандартные счётчики ошибок, общие для всех портов.
Эти стандартные ошибки влияют на статус **DAQ**-системы (улыбающийся человечек пожелтеет и покраснеет).
В случае, когда теги ошибок указаны, они будут инкрементироваться при ошибках на данном порте,
но при этом стандартные счётчики задействованы не будут (поэтому статус **DAQ**-системы при ошибках не изменится).
Это позволяет делать индивидуальную обработку ошибок, по выбору прикладного программиста.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Пример секции StartupScript

Например:

``` ini
[&RS485Proxy.StartupScript]
;--- Задание таблицы портов (порт,протокол,описание)
;--- Задание счётчиков приема/передачи/ошибок
;--- Логический порт 1
@Port 1 tcp port 5300 client localhost
@PortByteCounters 1 BYTECOUNT.RX BYTECOUNT.TX
@PortPollCounters 1 POLLCOUNT.RX POLLCOUNT.TX
@PortErrorCounters 1 BUGSCOUNT.RX BUGSCOUNT.TX
@PortByteRates 1 BYTERATE.RX BYTERATE.TX
@PortPollRates 1 POLLRATE.RX POLLRATE.TX
@PortErrorRates 1 BUGSRATE.RX BUGSRATE.TX
@TimeGap 1 0
;--- Логический порт 2
@Port 2 com port 4 baudrate 9600 parity even databits 8 stopbits 1
@PortByteCounters 2 BYTECOUNT.RX BYTECOUNT.TX
@PortPollCounters 2 POLLCOUNT.RX POLLCOUNT.TX
@PortErrorCounters 2 BUGSCOUNT.RX BUGSCOUNT.TX
@PortByteRates 2 BYTERATE.RX BYTERATE.TX
@PortPollRates 2 POLLRATE.RX POLLRATE.TX
@PortErrorRates 2 BUGSRATE.RX BUGSRATE.TX
@TimeGap 2 10
;--- Очистка счётчиков ошибок
@ZeroPortCounters
;--- Просмотр состояния
@View
[]
```
При этом не забудьте объявить теги для счётчиков в секции **[TagList]**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="poll_logic"></a>

# Логика работы RS485Proxy

Взаимодействие посредника **RS485Proxy** с клиентскими драйверами осуществляется через команды (сообщения).
Клиентские драверы не общаются с физическими портами напрямую, они посылают сообщения посреднику **RS485Proxy**.
Посредник в цикле опроса обрабатывает ссообщения, выстраивает их в очередь, посылает запросы в физические порты
и затем пересылает ответы клиентским драйверам - тоже в виде сообщений.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cmd_poll"></a>

## Команда @RS485.Poll

Работа клиента **&RS485Proxy** происходит в пассивном режиме ожидания запросов со стороны подчиненных драйверов.
Предполагается, что драйверы периодически посылают сообщение **`@RS485.Poll`** ... и ждут ответа.
При этом драйверы формируют полный запрос для устройства согласно протоколу обмена данных на него.
Клиент **&RS485Proxy** помещает принятый запрос в очередь для отправки в физический порт.
Для отказоустойчивости драйверы должны периодически (скажем, раз в минуту) проверять наличие ответа на посланный запрос
и генерировать новый запрос, если ответ все еще не пришел (эта ситуация возможна при перезапуске клиента **&RS485Proxy**).

Команда **`@RS485.Poll ref cid tot port uid $$dat//eol`** служит для инициирования операции опроса данных для данного порта.

``` ini
@RS485.Poll ref cid tot port uid $$dat//eol

# ref  - Числовая ссылка Reference или имя драйвера &Sender, инициировавшего опрос.
#        Ответное сообщение будут послано ему.
# cid  - Пользовательская команда (command id) - любое число,
#        идентифицирующее команду, которая возвращается в ответе.
# tot  - максимальное время ожидания ответа, ms, (0..MaxInt).
#        Если ответа на запрос не требуется, то следует указать 0.
#        В противном случае время ожидания должно быть положительным числом.
# port - Номер логического порта, (1..16).
#        Порт должен быть открыт командой @Port.
# uid  - идентификатор (адрес) устройства, (1..247).
# dat  - данные запроса (request).
# eol  - символ конца сообщение в двухсимвольном ASCII HEX-коде,
#        например: 0D - _CR, 0A - _LF или 0D0A - CRLF.
#        В качестве eol может использоваться сколько угодно символов,
#        например 26270D0A = &'CRLF, главное чтобы каждый символ был
#        закодирован в двухсимвольном ASCII HEX-коде.
```

Например:

``` ini
@RS485.Poll &demo.driver 33 200 1 5 $$@01//0D

# Инициировать опрос модуля с адресом 5, подключенного к порту 1,
# ждать не более 200 ms, ответ переслать драйверу &demo.driver.
# В запросе передается номер команды 33 для использования драйвером.
# Сообщение для отправки в устройство: @01CR.
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Команда @RS485.Reply
## Команда @RS485.Refuse
## Команда @RS485.TimeOut

В результате выполнения команды **`@RS485.Poll`** в ответ устройству **`&sender`**
посылается одно из следующих сообщений:  

- **`@RS485.Reply`** - опрос выполнен успешно, получен ответ;  
- **`@RS485.Refuse`** - опрос отклонен, вероятно обнаружена ошибка;  
- **`@RS485.TimeOut`** - время ожидания истекло, устройство не отвечает.  

``` ini
@RS485.Refuse  ref cid tim port uid   msg
@RS485.Reply   ref cid tim port uid $$ans
@RS485.TimeOut ref cid tim port uid $$dat

# ref    - reference, имя или ссылка устройства, пославшего ответ; значение должно быть ссылкой _&RS485Proxy_
# cid    - command id, идентификатор команды; значение должно совпадать с посланным
# tim    - измеренное время выполнения цикла запрос-ответ, ms; значение должно быть неотрицательным
# port   - логический порт, значение должно быть неотрицательным и совпадать с посланным
# uid    - адрес устройства, значение должно быть (1..247) и совпадать с посланным
# ans    - ответ устройства, возвращаемый при Reply
# req    - исходный запрос, возвращаемый при TimeOut
# msg    - строка с описанием причины, по которой запрос был отклонен - например, "Bad Port"= неверный номер порта
```

например:

``` ini
@RS485.Reply   1049090 33 10 1 5 $$@05
@RS485.TimeOut 1049090 33 210 1 5 $$@05
@RS485.Refuse &RS485Proxy 33 0 1 5 Bad Timeout 0

# здесь 1049090 - ссылка устройства &RS485Proxy
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

# Библиотека NetRS485

Библиотека **NetRS485** содержит 

- константы  **[_con_netrs485](_con_netrs485.inc)**,  
- переменные **[_var_netrs485.inc](_var_netrs485.inc)**,  
- функции    **[_fun_netrs485.inc](_fun_netrs485.inc)**,  

для включения в драйверы устройств, чтобы облегчить создание этих драйверов.

## Шаблон для включения NetRS485 в код драйверов устройств

Библиотека **NetRS485** включается аналогично другим модулям.

``` pascal
program DemoDriver485;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_NetRS485}              { NetRS485 constants               }
 ...
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_NetRS485}              { NetRS485 variables               }
 ...
 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_NetRS485}              { NetRS485 functions               }
 ...
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearNetRS485;
  ...
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  InitNetRS485;
  ...
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  FreeNetRS485;
  ...
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  PollNetRS485;
  ...
 end;
...
```

Кроме того, обработчик команд консоли **`StdIn_Processor`** должен,
в соответствии с логикой работы опрашиваемого устройства,

- периодически посылать команды опроса **`@RS485.Poll`**,  
- обрабатывать команды **`@RS485.Reply`**, **`@RS485.Refuse`**, **`@RS485.Timeout`**.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

 <img height=16 width=16 src="data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAAQhJREFUSEvtljEOgzAUQ3MvbsUJOA9XYMmJ2qFbp5q+YH2VINQSlgorjRz//+3QKSkvePT9reuaLFkV05xLwEdHk4XzHGBJyc9xPLjiPzEH+KzavRFkhafMk1kpNoLvXQIaXh/4I66ALVwBu9gMmKZpGIaUknZxRHHDIj1wQ4p0kXqAhlWOwK4cFlj8OoAy84RhYVIVhUiki9QD4kxE1NcBpHKtQwGyiF5u1g7gPwYYuAtvzzkVkR1R1XqAarZghm4IVZTYINja4/UAZiLoFtGwCBZwH+lh1qV6gKA+uzAprE3hNMOFOLIZ0ApXwC7+L+DEZ4tZw4/w9WV+/tNRv5jRcOF88vM95xfHjbs66Lo86gAAAABJRU5ErkJggg=="/>
 RS485Proxy Copyright (c) 2024-2025 DaqGroup <daqgroup@mail.ru>

 <img height=16 width=16 src="data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAAQhJREFUSEvtljEOgzAUQ3MvbsUJOA9XYMmJ2qFbp5q+YH2VINQSlgorjRz//+3QKSkvePT9reuaLFkV05xLwEdHk4XzHGBJyc9xPLjiPzEH+KzavRFkhafMk1kpNoLvXQIaXh/4I66ALVwBu9gMmKZpGIaUknZxRHHDIj1wQ4p0kXqAhlWOwK4cFlj8OoAy84RhYVIVhUiki9QD4kxE1NcBpHKtQwGyiF5u1g7gPwYYuAtvzzkVkR1R1XqAarZghm4IVZTYINja4/UAZiLoFtGwCBZwH+lh1qV6gKA+uzAprE3hNMOFOLIZ0ApXwC7+L+DEZ4tZw4/w9WV+/tNRv5jRcOF88vM95xfHjbs66Lo86gAAAABJRU5ErkJggg=="/>
 CRW-DAQ Copyright (c) 2001-2025 DaqGroup <daqgroup@mail.ru>.

---
