 {
 Demo program to speak via Speech Server as separate process.
 For working, it needs two COM objects to be installed:
 1)Freeware Microsoft Speech API 4.0 from URL:
   http://activex.microsoft.com/activex/controls/sapi/spchapi.exe
 2)Freeware speech engine Lernout&Hauspie Text-To-Speech from URL:
   http://activex.microsoft.com/activex/controls/agent2/lhttseng.exe - UK English
   http://activex.microsoft.com/activex/controls/agent2/lhttsrur.exe - Russin
 }
program demo_speak;
var r,tm:real; b,first:boolean;
 {
 Speak, i.e. send message to speech server.
 }
 procedure Speak(msg:String);
 var b:Boolean; ref:Integer;
 begin
  // On Unix SAPI tags is not supported yet.
  if IsUnix then while Pos('\',msg)>0 do msg:=Copy(msg,Pos('\',msg)+1);
  msg:=Trim(msg);
  if Length(msg)>0 then begin
   ref:=RefFind('Device &SpeakSrv');
   if ref<>0 then b:=DevSend(ref,'@speak='+msg+EOL)>0;
  end;
 end;
begin
 {
 Actions on start...
 }
 if runcount=1 then begin
  writeln(devname+' : Start.');
  {*** Open console window ***}
  b:=WinShow(ParamStr('Console '+devname));
  b:=WinSelect(ParamStr('Console '+devname));
  {*** Start timer ***}
  tm:=tm_new;
  b:=tm_addint(tm,10000);
  b:=tm_start(tm);
  first:=true;
  end else
 {
 Actions on stop...
 }
 if isinf(runcount) then begin
  writeln(devname+' : Stop.');
  {*** Free timer ***}
  b:=tm_free(tm);
 end else
 {
 Actions on poll...
 }
 begin
  {*** Each 10 sec speak time ***}
  if tm_event(tm) then begin
   {*** Speak few messages ***}
   if first then begin
    first:=false;
    b:=DevSendMsg('&SpeakSrv @Wait=1'+EOL)>0;
    Speak('\rst\Добрый день.');
    Speak('\spd=80\Этот пример иллюстрирует работу речевого синтезатора.');
    Speak('\pro=0\Для его работы необходимо установить Speech API.');
    Speak('\pro=1\Обратите внимание, что речевые сообщения выполняет сервер Speak Srv.');
    Speak('\rst\Я буду говорить сообщения каждые 10 секунд.');
   end;
   r:=Round(tm_gettime(tm)/timeunits);
   Speak('Прошло '+Str(r)+' секунд.');
   writeln(runcount:5:0,' ',r:5:0,' [sec]');
  end;
 end;
end.
