﻿---

[[toc]]

---

# Справка по DEMO_SHM

---

## Документация

**[Worksheet/](worksheet/)** - статьи по методам **IPC**.  
**[shm_xxx](../../../resource/manual/daqpascalapi.htm#shm_init)** - функции работы с Общей Памятью.

---

## Описание

**DEMO_SHM** - пример (демонстрационная конфигурация) по работе
с **Общей Памятью** - **SHM** = _shared memory_.

Общая память является одним из методов быстрого взаимодействия
между процессами - **IPC** = _inter process communication_.

При запуске серверная программа **[demo_shm](../daqpas/demo_shm_main_ctrl.pas)**
создает блок общей памяти (**DEMO_SHM_CLIENT**) и записывает в него параметры
сигнала "волны" (_wave_). Затем по кнопке **Start** запускается программа-клиент
**[demo_shm_client.exe](../utility/demo_shm_client.lpr)**. Этот клиент, используя
параметры из общей памяти, генерирует волновой сигнал **SIN**/**COS** и записывает
результат в общую память. Наконец, **DEMO_SHM** берет сигнал волны из общей памяти
и сохраняет его в кривые и теги для отображения и сохранения.

Обратите внимание, что серверная и клиентская программы используют один файл
**[shm_block_wave.inc](../daqpas/shm_block_wave.inc)** с описанием структуры
общей памяти, т.е. констант для смещений каждого элемента. Этот файл включается
в код как сервера, так и клиента, обеспечивая их согласованность. Константы для
смещений элементов используются для доступа к этим элементам в общей памяти
через единый **API**, одинаковый для всех языков.

Таким образом, пример **DEMO_SHM** иллюстрирует двусторонний обмен данными через
общую память. При этом используется **неблокирующий** механизм синхронизации
на основе атомарных счетчиков и "спекулятивного" чтения данных.
Этот метод состоит в том, что процесс-писатель инкрементирует атомарный счетчик
(в общей памяти) **ДО** и **ПОСЛЕ** записи данных. Процесс-читатель считывает
атомарный счетчик до и после чтения блока данных. Если счетчик нечетный (писатель
пишет) или за время чтения счетчик изменился (писатель успел записать свой блок),
то чтение данных считается "грязным" (_dirty_) и отбрасывается.
Чтение повторяется позже, пока не станет "чистым". Такой метод синхронизации не
требует дополнительных объектов (мютексов, семафоров) и не блокирует потоки,
однако требует высокой дисциплины от прикладного программиста.


Пример разработан с использованием функций 
**[shm_xxx](../../../resource/manual/daqpascalapi.htm#shm_init)**.
Достоинством этого **API** является то, что он универсален и одинаков
для **DaqPascal**, **FreePascal**, **Windows**/**Unix**.

---

> **CRW-DAQ** Copyright © 2001..2024 Alexey Kuryakin <daqgroup@mail.ru>

---
