 {
 ▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓
 ▓▓▓ Библиотека чтения файлов данных *.dat                           ▓▓▓
 ▓▓▓ Файлы имеют имя PPYYMMDD.DAT                                    ▓▓▓
 ▓▓▓ где PP - префикс имени файла                                    ▓▓▓
 ▓▓▓     YY - год (по модулю 100)                                    ▓▓▓
 ▓▓▓     MM - месяц                                                  ▓▓▓
 ▓▓▓     DD - день                                                   ▓▓▓
 ▓▓▓ В начале файла первой строкой идет заголовок                    ▓▓▓
 ▓▓▓  Time_mS C1 X2 C3                                               ▓▓▓
 ▓▓▓ где Time_mS     - имя времени (в глобальных миллисекундах)      ▓▓▓
 ▓▓▓     C1,C2,C3... - имена сохраненных кривых                      ▓▓▓
 ▓▓▓ далее в файле идут строки с данными, разделенными пробелами     ▓▓▓
 ▓▓▓ в первом слове идет гловальное время в миллисекундах            ▓▓▓
 ▓▓▓ в следующих словах строки - данные из кривых (по порядку).      ▓▓▓
 ▓▓▓ Пример файла:                                                   ▓▓▓
 ▓▓▓  Time_mS AK_TDIOD AK_T1 AK_T2 AK_T3 AK_T4 AK_T5                 ▓▓▓
 ▓▓▓  63110275202137 290.56 23.5 23.5 21 24.5 24.5                   ▓▓▓
 ▓▓▓  63110275207190 290.56 23.5 23.5 21 24.5 24.5                   ▓▓▓
 ▓▓▓  63110275212243 290.56 23.5 23.5 21 24.5 24.5                   ▓▓▓
 ▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓
 }
library READDAT;
{$I _sysdef}
uses winapi,dos,objects,_huge,_alloc,_str,_strings,_dosfn,_elfun,_crwdll,_matherr;
var
 first,last : record
  fname     : array[0..255] of char;
  pref      : string[2];
  syy       : string[2];
  smm       : string[2];
  sdd       : string[2];
  year      : longint;
  month     : longint;
  day       : longint;
  gtime     : double;
 end;
 crv        : array[1..255] of curveptr;
 nump       : array[1..255] of longint;
 syy        : string;
 smm        : string;
 sdd        : string;
 fname      : string;
 s          : string;
 cnum       : array[byte] of integer;
const
 header     : string  = '';
 numc       : integer = 0;
 iobugs     : double  = 0;
 timeunits  : double  = 1000*60;
 timename   : string  = '?';
 starttime  : double  = 0;
 StartPath            = 'c:\*.dat';
 clist      : string  = '';
 dnp                  = 1024*64;
 CrvColor             = Blue;
 CrvStyle             = $1F;
 {
 ▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓
 ▓▓▓ Основная процедура ▓▓▓
 ▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓
 }
procedure User_Defined_Script; export;
label quit;
var
 i,iy,im,id:longint; t:double;
 {
 Фиксировать ошибку при чтении файла
 }
 procedure iobug(code:integer);
 begin
  iobugs:=iobugs+1;
 end;
 {
 Процедура добавления точки в кривую
 }
 procedure AddPoint(c:curveptr; var np:longint; x,y:double);
 var c1:curve; i:longint;
 begin
  {
  Проверка - достаточен ли буфер для вставки точки. Если нет - надо его увеличить.
  }
  if np+1>c^.Length then begin {буфер оказался мал-надо его увеличить}
   {
   Создадим временную кривую и скопируем туда данные 
   }
   c1.Init(c^.length,c^.GetDescription,c^.GetColor,c^.GetStyle);
   if c^.length<>c1.length then iobug(1);
   for i:=1 to c1.length do begin
    c1.X(i)^:=c^.X(i)^;
    c1.Y(i)^:=c^.Y(i)^;
   end;
   {
   Удалим кривую и создадим новую с большим числом точек
   }
   c^.Done;
   c^.Init(np+dnp,c1.GetDescription,c1.GetColor,c1.GetStyle);
   if c^.length<>np+dnp then iobug(2);
   {
   Скопируем данные из временной кривой обратно и удалим временную кривую
   }
   for i:=1 to c^.length do begin
    if i>c1.length then begin
     c^.X(i)^:=0;
     c^.Y(i)^:=0;
    end else begin
     c^.X(i)^:=c1.X(i)^;
     c^.Y(i)^:=c1.Y(i)^;
    end;
   end;
   c1.done;
  end;
  {
  Добавить точку в кривую с проверкой монотонности и уплотнением
  }
  if np+1>c^.length then iobug(3) else begin
   { Добавление точки }
   inc(np);
   c^.x(np)^:=x;
   c^.y(np)^:=y;
   { Проверка монотонности }
   if (np>1) and (c^.x(np-1)^>c^.x(np)^) then iobug(4);
   { Уплотнение в случае если значение не изменилось }
   if (np>2) and (c^.y(np-1)^=y) and (c^.y(np-2)^=y) then begin
    dec(np);
    c^.x(np)^:=x;
    c^.y(np)^:=y;
   end;
  end;
 end;
 procedure ReadFile(fname:string);
 var f:text; s:string; c:curveptr; i,j:longint; t,y:double; DlgData:record w:word; f:double; s:string; end; Buff:PChar;
 begin
  assign(f,fname);
  reset(f);
  readln(f,s);
  if ioresult<>0 then iobug(5);
  if UpcaseStr(extractword(1,s,ScanSpaces))<>'TIME_MS' then iobug(6);
  if numc<1 then begin
   header:=s;
   clist:='';
   fillchar(cnum,sizeof(cnum),0);
   numc:=0;
   for i:=2 to wordcount(header,ScanSpaces) do begin
    if clist<>'' then clist:=clist+',';
    clist:=clist+ExtractWord(i,header,ScanSpaces);
   end;
   {
   Диалог ввода единиц времени и списка кривых
   }
   Buff:=Allocate(4096);
   DlgData.w:=5;
   DlgData.f:=timeunits;
   DlgData.s:=clist;
   if timeunits=1 then DlgData.w:=0;
   if timeunits=1000.0 then DlgData.w:=1;
   if timeunits=1000.0*60 then DlgData.w:=2;
   if timeunits=1000.0*60*60 then DlgData.w:=3;
   if timeunits=1000.0*60*60*24 then DlgData.w:=4;
   StrCopy(Buff,'Dialog 0   0   600  210 Единицы времени и список кривых'+CR);
   StrPCat(Buff,'Label  20  30  179  46  Единицы времени'+CR+
                'Radio  180 30  380  120 6'+CR+
                'МиллиСекунды'+CR+
                'Секунды'+CR+
                'Минуты'+CR+
                'Часы'+CR+
                'Сутки'+CR+
                'Другие единицы'+CR);
   StrPCat(Buff,'Label  20  50  179  66  в миллисекундах '+CR+
                'Input  20  70  159  86  %f'+CR);
   StrPCat(Buff,'Label  20  130 199  146 Имена вводимых кривых'+CR+
                'Input  20  150 580  166 %s'+CR);
   StrPCat(Buff,'Button 20  180 90   200 '+d2s(cm_Ok)+' Ладно'+CR+
                'Button 100 180 170  200 '+d2s(cm_Cancel)+' Закрыть');
   if DialogBox(Buff,@DlgData)=cm_Cancel then begin
    DlgData.w:=5;
    DlgData.f:=timeunits;
    DlgData.s:='';
   end;
   case DlgData.w of
    0:DlgData.f:=1;
    1:DlgData.f:=1000.0;
    2:DlgData.f:=1000.0*60;
    3:DlgData.f:=1000.0*60*60;
    4:DlgData.f:=1000.0*60*60*24;
   end;
   timeunits:=DlgData.f;
   clist:=DlgData.s; 
   Deallocate(Pointer(Buff));
   {
   }
   for i:=1 to wordcount(clist,ScanSpaces) do begin
    j:=wordindex(extractword(i,clist,ScanSpaces),header,ScanSpaces);
    if j>0 then begin
     inc(numc);
     cnum[numc]:=j;
    end;
   end;
   for i:=1 to numc do crv[i]^.Init(10000,extractword(cnum[i],header,ScanSpaces),CrvColor,CrvStyle);
  end else begin
   if s<>header then iobug(7);
  end;
  if numc>0 then
  while true do begin
   if eof(f) then break;
   readln(f,s);
   if ioresult<>0 then begin
    iobug(8);
    break;
   end;
   if not str2real(extractword(1,s,ScanSpaces),t) then iobug(9) else begin
    if starttime=0 then starttime:=first.gtime; { t ? };
    t:=t-starttime;
    for i:=1 to numc do begin
     if not str2real(extractword(cnum[i],s,ScanSpaces),y)
     then iobug(10)
     else AddPoint(crv[i],nump[i],t/timeunits,y);
    end;
   end;
  end;
  close(f);
 end;
begin
 {
 Init crv and nump
 }
 for i:=1 to 255 do begin
  crv[i]:=OutputCurve(i);
  nump[i]:=0;
  if Trouble(crv[i]=nil,'Нет памяти!') then goto quit;
 end;
 {
 Input first and last file name to view
 }
 StrPCopy(first.fname,StartPath);
 if FileOpenBox('Введите имя ПЕРВОГО файла для чтения',first.fname)=cm_Cancel then goto quit;
 StrCopy(last.fname,first.fname);
 if FileOpenBox('Введите имя ПОСЛЕДНЕГО файла для чтения',last.fname)=cm_Cancel then goto quit;
 {
 Find time of first file
 }
 first.pref:=copy(extractfilename(strpas(first.fname)),1,2);
 first.syy:=copy(extractfilename(strpas(first.fname)),3,2);
 first.smm:=copy(extractfilename(strpas(first.fname)),5,2);
 first.sdd:=copy(extractfilename(strpas(first.fname)),7,2);
 if Trouble(not str2long(first.syy,first.year), 'Недопустимый код года!')  then goto quit;
 if Trouble(not str2long(first.smm,first.month),'Недопустимый код месяца!') then goto quit;
 if Trouble(not str2long(first.sdd,first.day),  'Недопустимый код дня!')   then goto quit;
 first.year:=first.year+2000;
 {
 Find time of last file
 }
 with first do gtime:=DateTimeToMSec(year,month,day,00,00,00,00);
 last.pref:=copy(extractfilename(strpas(last.fname)),1,2);
 last.syy:=copy(extractfilename(strpas(last.fname)),3,2);
 last.smm:=copy(extractfilename(strpas(last.fname)),5,2);
 last.sdd:=copy(extractfilename(strpas(last.fname)),7,2);
 if Trouble(not str2long(last.syy,last.year), 'Недопустимый код года!')  then goto quit;
 if Trouble(not str2long(last.smm,last.month),'Недопустимый код месяца!') then goto quit;
 if Trouble(not str2long(last.sdd,last.day),  'Недопустимый код дня!')   then goto quit;
 last.year:=last.year+2000;
 with last do gtime:=DateTimeToMSec(year,month,day,00,00,00,00);
 if Trouble(first.pref<>last.pref,'Префикс первого и последнего файла не совпадают!') then goto quit;
 {
 Read file in cycle of year,month,day...
 } 
 for iy:=first.year to last.year do
 for im:=1 to 12 do 
 for id:=1 to 31 do begin
  t:=DateTimeToMSec(iy,im,id,00,00,00,00);
  if isnan(t) then continue;
  if (t<first.gtime) or (t>last.gtime) then continue;
  syy:=d2s(iy mod 100); while length(syy)<2 do syy:='0'+syy;
  smm:=d2s(im mod 100); while length(smm)<2 do smm:='0'+smm;
  sdd:=d2s(id mod 100); while length(sdd)<2 do sdd:='0'+sdd;
  fname:=addbackslash(extractfilepath(strpas(first.fname)))+first.pref+syy+smm+sdd+extractfileext(strpas(first.fname));
  if not fileexists(fname,anyfile and not (directory+volumeid)) then continue;
  ReadFile(fname);
  if numc<1 then goto quit;
 end;
 {
 Обрезать буферы по числу прочитаных точек
 }
 for i:=1 to numc do TruncateCurve(crv[i],1,nump[i]);
quit:
 Trouble(iobugs>0,'Обнаружены ошибки чтения файла! ('+f2s(iobugs)+')');
 {
 Задание имен и меток окна для результата
 }
 StrPCopy(WinName,'Данные '+extractfilename(strpas(first.fname))+'..'+extractfilename(strpas(last.fname)));
 s:='';
 for i:=1 to numc do begin
  if s<>'' then s:=s+',';
  s:=s+extractword(cnum[i],header,ScanSpaces);
  if length(s)>60 then begin
   s:=s+',...';
   break;
  end;
 end;
 if timeunits=1 then timename:='МиллиСекунд';
 if timeunits=1000 then timename:='Секунд';
 if timeunits=60*1000 then timename:='Минут';
 if timeunits=60*60*1000 then timename:='Часов';
 if timeunits=24*60*60*1000 then timename:='Суток';
 StrPCopy(WinTitle,^C'Кривые '+s+CR+^L' {??}');
 StrPCopy(WinLabel,^R'{'+timename+'}  '+CR+^C'Время отсчитывается от '+MSecToDateStr(starttime)+'-'+MSecToTimeStr(starttime));
end;
 {
 Список экспорта и инициализация библиотеки
 }
exports User_Defined_Script resident;
begin
end.
