﻿---

[[toc]]

---

# Справка по конфигурации demo_pycon

Конфигурация **[demo_pycon](../)** - это демонстрационная и тестовая программа,
показывающая, как можно использовать язык программирования **python**
для создания клиент-серверных приложений для **DAQ** системы.
Она использует библиотеку **[StdPyApp](../../../resource/daqsite/stdlib/include/_man_stdpyapp.htm)**.

Название происходит от **demo python console**, т.к. в основе взаимодействия
программы **python** и пакета **crwdaq** лежит консоль **stdin**/**stdout**,
переназначенная в анонимный канал связи.
Программа **python** читает команды и данные для обработки из консоли **stdin**,
которая подключена к каналу и работает в **асинхронном** (неблокирующем) режиме.
Результаты обработки передаются путем печати в консоль **stdout**, которая тоже
подключена к каналу связи.
За приемопередачу и обработку команд и данных на стороне **crwdaq** отвечает
клиентская программа на языке **daqpascal**.

Основным способом взаимодействия являются **команды** в формате **DaqScript**,
т.е. **`@Command Data`**. Признаком команды является символ **`@`**, за которым
следует непустой идентификатор команды, пробел и данные, формат которых зависит
от команды. Команда завершается маркером конца строки **EOL** (_end of line_).
Признак команды должен быть первым символом в строке.
Простые команды передают данные в виде списка значений, разделенных пробелами
и/или запятыми. Двоичные данные передаются в закодированном виде, например, в
виде **HEX** или **BASE64**. В ответ на клиентские запросы сервер отвечает
командами аналогичного формата.

Количество команд неограничено, скорость приемопердачи и анализа не зависит от
размера таблицы команд. Поэтому нет большого смысле делать чрезмерно сложные
команды, лучше позаботиться об их понятности (для этого надо давать легко
понятные имена).

В данном примере серверная программа **[demo_pycon.py](../daqpas/demo_pycon.py)**
вычисляет синусовую волну (**wave**) по требованию клиенской программы
**[demo_pycon_main_ctrl.pas](../daqpas/demo_pycon_main_ctrl.pas)**
на языке **DaqPascal**.
Кроме того, клиентская программа посылает запросы, нужные для оценки частоты
опросов **PollRate** и времени отклика **PingTime**.

---

## Некоторые команды протокола обмена demo_pycon

Здесь приведены некоторые команды программы **demo_pycon.py**.

``` bash
#################### некоторые команды: запросы > и ответы <
> @help            # справка по командам (для прикладных разработчиков)
> @wave t          # посылка запроса для расчета волны в момент времени t
< @wave t sin cos  # возврат результата расчета - волна t sin(t) cos(t)
> @para a f n      # уставка параметров amlitude,frequency,noise
< @para a f n      # возврат актуальных значений этих параметров
> @pingecho t      # посылка пинга для оценки времени отклика
< @pingecho t      # возврат пинга для оценки времени отклика
> @pollcount       # посылка запроса счетчика циклов
< @pollcount c     # возврат счетчика циклов c
#################### и так далее
```

---

Желаем приятного использования тестовой программы **demo_pycon**.

---

> **CRW-DAQ** *Copyright (c) 2001-2025 Alexey Kuryakin daqgroup@mail.ru*

---
