 {
 ***********************************************************************
 Daq Pascal application program DemoPaint.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
|********************************************************
[]
 }
program DemoPaint;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 tagSignal1 : Integer;           { Signal tag                       }
 tagSignal2 : Integer;           { Signal tag                       }
 tagSignal3 : Integer;           { Signal tag                       }
 tagSignal4 : Integer;           { Signal tag                       }
 tagSignal5 : Integer;           { Signal tag                       }
 tagSignal6 : Integer;           { Signal tag                       }
 tagSignal7 : Integer;           { Signal tag                       }
 tagSignal8 : Integer;           { Signal tag                       }
 tagAlarm1  : Integer;           { Alarm level tag                  }
 tagAlarm2  : Integer;           { Alarm level tag                  }
 valAlarm1  : Real;              { Alarm level                      }
 valAlarm2  : Real;              { Alarm level                      }
 nDev       : String;
 invr       : Integer;

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  nDev:='';
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  nDev:=ReadIni('tagPrefix');
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  InitTag(tagAlarm1,nDev+'.Alarm1', 2);
  InitTag(tagAlarm2,nDev+'.Alarm2', 2);
  InitTag(tagSignal1,nDev+'.Signal1',2);
  InitTag(tagSignal2,nDev+'.Signal2',2);
  InitTag(tagSignal3,nDev+'.Signal3',2);
  InitTag(tagSignal4,nDev+'.Signal4',2);
  InitTag(tagSignal5,nDev+'.Signal5',2);
  InitTag(tagSignal6,nDev+'.Signal6',2);
  InitTag(tagSignal7,nDev+'.Signal7',2);
  InitTag(tagSignal8,nDev+'.Signal8',2);
  valAlarm1:=MaxReal;
  valAlarm2:=MaxReal;
  invr:=0;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  nDev:='';
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 var i:Integer; t,v1,v2,v3,v4,v5,v6,v7,v8:Real;
 begin
  {
  Simulate signals...
  }
  t:=(mSecNow-FixmSecNow)/60000;
  v1:=100*(1+sin(2*pi*t+1+val(nDev)))/2;
  v2:=100*(1+cos(2*pi*t+2+val(nDev)))/2;
  v3:=100*(1+sin(2*pi*t*3+3+val(nDev)))/2;
  v4:=100*(1+cos(2*pi*t*3+4+val(nDev)))/2;
  v5:=100*(1+sin(2*pi*t+5+val(nDev)))/2;
  v6:=100*(1+cos(2*pi*t+6+val(nDev)))/2;
  v7:=100*(1+sin(2*pi*t*3+7+val(nDev)))/2;
  v8:=100*(1+cos(2*pi*t*3+8+val(nDev)))/2;
  bNul(rSetTag(tagSignal1,v1));
  bNul(rSetTag(tagSignal2,v2));
  bNul(rSetTag(tagSignal3,v3));
  bNul(rSetTag(tagSignal4,v4));
  bNul(rSetTag(tagSignal5,v5));
  bNul(rSetTag(tagSignal6,v6));
  bNul(rSetTag(tagSignal7,v7));
  bNul(rSetTag(tagSignal8,v8));
  {
  Update alarm1, alarm2...
  }
  if ShouldRefresh(valAlarm1,rGetTag(tagAlarm1))+
     ShouldRefresh(valAlarm2,rGetTag(tagAlarm2))>0
  then bNul(WinDraw('DemoPaint'+nDev+'|Eval=(alarm1='+Str(valAlarm1)+')+(alarm2='+Str(valAlarm2)+')'));
  {
  }
  if invr=1 then
  for i:=1 to 10000 do begin
   bNul(WinDraw('DemoPaint'+nDev+'|Eval=(alarm1='+Str(valAlarm1)+')+(alarm2='+Str(valAlarm2)+')'));
   invr:=0;
  end;
  {
  Handle buttons...
  }
  if ClickButton=1 then begin
   Success('Click detected:'+CRLF+ClickParams(''));
   if IsSameText(ClickSensor,'HELP') then begin
     Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
     bNul(Voice(snd_Click));
   end;
   if IsSameText(ClickSensor,'Alarm1') then begin
    StartEditTag(tagAlarm1,'Отредактируйте Alarm1');
    bNul(Voice(snd_Click));
   end;
   if IsSameText(ClickSensor,'Alarm2') then begin
    StartEditTag(tagAlarm2,'Отредактируйте Alarm2');
    bNul(Voice(snd_Click));
   end;
  end;
  {
  Edit tags...
  }
  if EditState=ef_Done then begin
   CheckEditTagUpdate(tagAlarm1,0,100);
   CheckEditTagUpdate(tagAlarm2,0,100);
  end;
  if EditState=ef_Done then begin
   Problem('Unknown tag edition!');
   sNul(Edit(''));
  end;
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Dialog error detected!');
   sNul(Edit(''));
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   }
   if IsSameText(cmd,'@test1') then begin
    invr:=1;
    writeln('test1 cmd OK...');
    //DevsendCmd(Reffind('Device &demopaint1'),'@test1');
    //DevsendCmd(Reffind('Device &demopaint2'),'@test1');
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
