 {
 ***********************************************************************
 MERA main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
 [@Help]
 |StdIn Command list: "@cmd=arg" or "@cmd arg"
 |********************************************************
 | @MenuCloseConfirmation - for internal use.
 | @MenuToolsConfirmation - for internal use.
 | @ActionDaqNavigator    - Open DAQ SYSTEM Navigator list
 | @WinHide w             - hide window w.
 | @WinShow w             - show window w.
 | @WinDraw w             - draw window w.
 | @WinSelect w           - select window w.
 | @Async c               - run command c asynchronous.
 | @Cmd.LoadIni           - load params from INI.
 | @Cmd.SaveIni           - save params to   INI.
 | @AssignTag t v         - assign value v to tag t.
 |********************************************************
 []
 }
program mera_main_ctrl;         { MERA main control program       }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_NetLibrary}            { NetLibrary constants             }
 SmilePeriod       = 1000;       { Polling period for smile face    }
 AwakePeriod       = 100;        { Period of checks to awake DatSrv }

type
 TTagRef    = record tag,nai,nao,ndi,ndo:Integer; val:Real; end;
 TMERAMainRec     = record      { Main control & GUI               }
  CMD              : record      { CoMmandDs to control GUI         }
   HELP            : TTagRef;    { Open Help                        }
   HOME            : TTagRef;    { Exec Home                        }
   OPEN            : TTagRef;    { Open DAT file(s)                 }
   SAVE            : TTagRef;    { Save DAT file(s)                 }
   LOADINI         : TTagRef;    { Load INI file                    }
   SAVEINI         : TTagRef;    { Save INI file                    }
   TOOLS           : TTagRef;    { Tools menu                       }
   SOUND           : TTagRef;    { Sound menu                       }
   SMILE           : TTagRef;    { Smile menu                       }
   CLOSE           : TTagRef;    { Close DAQ/CRW/WIN                }
  end;                           {                                  }
 end;                            {                                  }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_NetLibrary}            { NetLibrary variables             }
 MERA             : record      { All MERA data                   }
  MAIN             : TMERAMainRec; { Main control & GUI            }
  AwokeTime        : Real;       { Time when DatSrv last awoke      }
  DatSrvGate       : TTagRef;    { Save data to DatSrv              }
 end;                            {                                  }
 cmd_MenuCloseConfirmation:Integer;{ Command @MenuCloseConfirmation }
 cmd_MenuToolsConfirmation:Integer;{ Command @MenuToolsConfirmation }
 cmd_ActionDaqNavigator:Integer;   { Open DAQ SYSTEM Navigator list }
 cmd_WinHide       : Integer;    { Command @WinHide                 }
 cmd_WinShow       : Integer;    { Command @WinShow                 }
 cmd_WinDraw       : Integer;    { Command @WinDraw                 }
 cmd_WinSelect     : Integer;    { Command @WinSelect               }
 cmd_Async         : Integer;    { Command @Async                   }
 cmd_CmdLoadIni    : Integer;    { Command @Cmd.LoadIni             }
 cmd_CmdSaveIni    : Integer;    { Command @Cmd.SaveIni             }
 cmd_AssignTag     : Integer;    { Command @AssignTag               }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_NetLibrary}            { NetLibrary functions             }

 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var nv:Integer;
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Initilize MERA.MAIN record tags
 }
 procedure TMERAMainRec_Init(var Rec:TMERAMainRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.CMD.HELP.tag,    TagPrefix+'.CMD.HELP',      1);
   InitTag(Rec.CMD.HOME.tag,    TagPrefix+'.CMD.HOME',      1);
   InitTag(Rec.CMD.OPEN.tag,    TagPrefix+'.CMD.OPEN',      1);
   InitTag(Rec.CMD.SAVE.tag,    TagPrefix+'.CMD.SAVE',      1);
   InitTag(Rec.CMD.LOADINI.tag, TagPrefix+'.CMD.LOADINI',   1);
   InitTag(Rec.CMD.SAVEINI.tag, TagPrefix+'.CMD.SAVEINI',   1);
   InitTag(Rec.CMD.TOOLS.tag,   TagPrefix+'.CMD.TOOLS',     1);
   InitTag(Rec.CMD.SOUND.tag,   TagPrefix+'.CMD.SOUND',     1);
   InitTag(Rec.CMD.SMILE.tag,   TagPrefix+'.CMD.SMILE',     1);
   InitTag(Rec.CMD.CLOSE.tag,   TagPrefix+'.CMD.CLOSE',     1);
   Rec.CMD.CLOSE.val:=-1;
   Rec.CMD.TOOLS.val:=-1;
   Rec.CMD.SMILE.val:=GetErrCount(-2);
  end;
 end;
 {
 Nice tooltip notifier.
 }
 procedure NiceNotify(aText:String; aDelay:Integer);
 begin
  if Length(aText)>0 then begin
   ShowTooltip('text "'+aText+'" preset stdNotify delay '+Str(aDelay));
  end;
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 {
 Get text of Close menu items
 }
 function MenuCloseItem(MenuClose:Integer):String;
 begin
  if MenuClose=0 then MenuCloseItem:='Продолжить работу'                          else
  if MenuClose=1 then MenuCloseItem:='Рестарт сервера '+DatSrv                    else
  if MenuClose=2 then MenuCloseItem:='Рестарт сервера '+CronSrv                   else
  if MenuClose=3 then MenuCloseItem:='Рестарт сервера '+SpeakSrv                  else
  if MenuClose=4 then MenuCloseItem:='Рестарт сервера '+ModbusProxy               else
  if MenuClose=5 then MenuCloseItem:='Перезапустить сеанс АСУ'                    else
  if MenuClose=6 then MenuCloseItem:='Завершить текущий сеанс АСУ'                else
  if MenuClose=7 then MenuCloseItem:='Завершить работу АСУ и выйти из программы'  else
  if MenuClose=8 then MenuCloseItem:='Завершить работу АСУ и выключить компьютер' else
  MenuCloseItem:='';
 end;
 {
 Execute Close menu commands
 }
 procedure MenuCloseCmnd(MenuClose:Integer);
 begin
  if MenuClose=0 then NiceNotify('Желаю успешной работы',10000);
  if MenuClose=1 then Cron('@Eval @System @Async @Silent @Daq Compile '+DatSrv);
  if MenuClose=2 then Cron('@Eval @System @Async @Silent @Daq Compile '+CronSrv);
  if MenuClose=3 then Cron('@Eval @System @Async @Silent @Daq Compile '+SpeakSrv);
  if MenuClose=4 then Cron('@Eval @System @Async @Silent @Daq Compile '+ModbusProxy);
  if MenuClose=5 then Cron('@Shutdown Daq Restart');
  if MenuClose=6 then Cron('@Shutdown Daq Exit');
  if MenuClose=7 then Cron('@Shutdown Crw Exit');
  if MenuClose=8 then Cron('@Shutdown Win Exit');
 end;
 {
 Get text of Tools menu items
 }
 function MenuToolsItem(MenuTools:Integer):String;
 begin
  if MenuTools=0 then MenuToolsItem:='Вызвать окно справочной информации (HELP)'    else
  if MenuTools=1 then MenuToolsItem:='Параметры Установки - Загрузить из INI файла' else
  if MenuTools=2 then MenuToolsItem:='Параметры Установки - Сохранить в  INI файле' else
  if MenuTools=3 then MenuToolsItem:='Очистка счетчиков ошибок &ModbusProxy'        else
  if MenuTools=4 then MenuToolsItem:='Пока не реализована'                          else
  if MenuTools=5 then MenuToolsItem:='Пока не реализована'                          else
  if MenuTools=6 then MenuToolsItem:='Пока не реализована'                          else
  if MenuTools=7 then MenuToolsItem:='Пока не реализована'                          else
  MenuToolsItem:='';
 end;
 {
 Execute Tools menu commands
 }
 procedure MenuToolsCmnd(MenuTools:Integer);
 begin
  if MenuTools=0  then bNul(iSetTag(MERA.MAIN.CMD.HELP.tag,1));
  if MenuTools=1  then bNul(iSetTag(MERA.MAIN.CMD.LOADINI.tag,1));
  if MenuTools=2  then bNul(iSetTag(MERA.MAIN.CMD.SAVEINI.tag,1));
  if MenuTools=3  then DevSendCmd(devModbusProxy,'@ZeroPortCounters 0');
  if MenuTools=4  then NiceNotify('Желаю успешной работы',10000);
  if MenuTools=5  then NiceNotify('Желаю успешной работы',10000);
  if MenuTools=6  then NiceNotify('Желаю успешной работы',10000);
  if MenuTools=7  then NiceNotify('Желаю успешной работы',10000);
 end;
 {
 Awake DatSrv to enforce data save.
 }
 procedure AwakeDatSrv;
 begin
  MERA.AwokeTime:=mSecNow;
  DevSendCmd(devDatSrv,'  ');
 end;
 {
 MERA clear strings
 }
 procedure MERA_CLEAR;
 begin
 end;
 {
 MERA initialization
 }
 procedure MERA_INIT;
 var i:Integer;
 begin
  //
  // Initialize tags & devices...
  //
  TMERAMainRec_Init(MERA.MAIN, ReadIni('tagMERA')+'.MAIN');
  InitTag(mera.DatSrvGate.tag, 'DATSRV.GATE',    -1);
  //
  // Initialize values
  //
  MERA.AwokeTime:=0;
 end;
 {
 MERA finalization
 }
 procedure MERA_FREE;
 begin
 end;
 {
 MERA polling
 }
 procedure MERA_POLL;
 var nerrors:Real; i,ClickCurve:Integer;
 begin
  {
  Awake DatSrv to enforce data save.
  }
  if SysTimer_Pulse(AwakePeriod)>0 then begin
   bNul(iSetTag(MERA.DatSrvGate.tag,Ord(iGetTag(MERA.MAIN.CMD.SAVE.tag)<>0)));
  end;
  {
  Execute GUI commands
  }
  if iGetTag(MERA.MAIN.CMD.HELP.tag)<>0 then begin
   Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
   bNul(iSetTag(MERA.MAIN.CMD.HELP.tag,0));
  end;
  if iGetTag(MERA.MAIN.CMD.HOME.tag)<>0 then begin
   Cron('@cron.run MERA.MAIN.CTRL.HOME');
   bNul(iSetTag(MERA.MAIN.CMD.HOME.tag,0));
  end;
  if iGetTag(MERA.MAIN.CMD.OPEN.tag)<>0 then begin
   Cron('@FileOpenDialog '+
    URL_Packed(AddBackSlash(DaqFileRef(ReadIni('['+DatSrv+'] DataPath'),''))+'*.DAT;*.CRW'));
   bNul(iSetTag(MERA.MAIN.CMD.OPEN.tag,0));
  end;
  if iGetTag(MERA.MAIN.CMD.LOADINI.tag)<>0 then begin
   DevSendCmd(devMySelf,'@Cmd.LoadIni');
   bNul(iSetTag(MERA.MAIN.CMD.LOADINI.tag,0));
  end;
  if iGetTag(MERA.MAIN.CMD.SAVEINI.tag)<>0 then begin
   DevSendCmd(devMySelf,'@Cmd.SaveIni');
   bNul(iSetTag(MERA.MAIN.CMD.SAVEINI.tag,0));
  end;
  if iGetTag(MERA.MAIN.CMD.TOOLS.tag)<>0 then begin
   if EditState=0 then begin
    if Pos('?',Edit('(Команда "Инструменты"... ')
              +Edit(' Что выбираете:')
              +Edit(' '+MenuToolsItem(0))
              +Edit(' '+MenuToolsItem(1))
              +Edit(' '+MenuToolsItem(2))
              +Edit(' '+MenuToolsItem(3))
              +Edit(' '+MenuToolsItem(4))
              +Edit(' '+MenuToolsItem(5))
              +Edit(' '+MenuToolsItem(6))
              +Edit(' '+MenuToolsItem(7))
              +Edit(')MenuList MENU_'+NameTag(MERA.MAIN.CMD.TOOLS.tag)))>0
    then Warning('Error initializing MenuList!');
   end else Warning('Cannot edit right now!');
   bNul(iSetTag(MERA.MAIN.CMD.TOOLS.tag,0));
   MERA.MAIN.CMD.TOOLS.val:=-1;
  end;
  if iGetTag(MERA.MAIN.CMD.CLOSE.tag)<>0 then begin
   if EditState=0 then begin
    if Pos('?',Edit('(Команда "Закрыть"... ')
              +Edit(' Что выбираете:')
              +Edit(' '+MenuCloseItem(0))
              +Edit(' '+MenuCloseItem(1))
              +Edit(' '+MenuCloseItem(2))
              +Edit(' '+MenuCloseItem(3))
              +Edit(' '+MenuCloseItem(4))
              +Edit(' '+MenuCloseItem(5))
              +Edit(' '+MenuCloseItem(6))
              +Edit(' '+MenuCloseItem(7))
              +Edit(' '+MenuCloseItem(8))
              +Edit(')MenuList MENU_'+NameTag(MERA.MAIN.CMD.CLOSE.tag)))>0
    then Warning('Error initializing MenuList!');
   end else Warning('Cannot edit right now!');
   bNul(iSetTag(MERA.MAIN.CMD.CLOSE.tag,0));
   MERA.MAIN.CMD.CLOSE.val:=-1;
  end;
  {
  Handle Smile button state
  }
  if SysTimer_Pulse(SmilePeriod)>0 then begin
   nerrors:=GetErrCount(-2);
   if nerrors>MERA.MAIN.CMD.SMILE.val then bNul(iSetTag(MERA.MAIN.CMD.SMILE.tag,2)) else
   if iGetTag(MERA.MAIN.CMD.SMILE.tag)>1 then bNul(iSetTag(MERA.MAIN.CMD.SMILE.tag,1));
   MERA.MAIN.CMD.SMILE.val:=nerrors;
  end;
  {
  Edit tags...
  }
  if EditState=ef_Done then begin
   {
   Warning.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Warning') then begin
    sNul(Edit(''));
   end;
   {
   Information.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Information') then begin
    sNul(Edit(''));
   end;
   {
   CLOSE menu.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'MENU_'+NameTag(MERA.MAIN.CMD.CLOSE.tag)) then begin
    if Val(ExtractWord(2,Edit('?ans 0')))=1 then begin
     MERA.MAIN.CMD.CLOSE.val:=Val(Edit('?ans 1'));
     if MERA.MAIN.CMD.CLOSE.val>=0 then
     if (MERA.MAIN.CMD.CLOSE.val>0) then begin
      DevSendCmd(devMySelf,'@MenuCloseConfirmation '+UpCaseStr(StrReplace(StrReplace(
                 MenuCloseItem(Round(MERA.MAIN.CMD.CLOSE.val)),'  ',Dump(' '),3),'  ',Dump(' '),3)));
     end else begin
      MenuCloseCmnd(Round(MERA.MAIN.CMD.CLOSE.val));
      MERA.MAIN.CMD.CLOSE.val:=-1;
     end;
    end;
    sNul(Edit(''));
   end;
   {
   CLOSE menu (after confirmation).
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'YesNo_'+NameTag(MERA.MAIN.CMD.CLOSE.tag)) then begin
    if MERA.MAIN.CMD.CLOSE.val>=0 then
    if Val(ExtractWord(2,Edit('?ans 0')))=6 then MenuCloseCmnd(Round(MERA.MAIN.CMD.CLOSE.val));
    MERA.MAIN.CMD.CLOSE.val:=-1;
    sNul(Edit(''));
   end;
   {
   TOOLS menu.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'MENU_'+NameTag(MERA.MAIN.CMD.TOOLS.tag)) then begin
    if Val(ExtractWord(2,Edit('?ans 0')))=1 then begin
     MERA.MAIN.CMD.TOOLS.val:=Val(Edit('?ans 1'));
     if MERA.MAIN.CMD.TOOLS.val>=0 then
     if (MERA.MAIN.CMD.TOOLS.val>10) then begin
      DevSendCmd(devMySelf,'@MenuToolsConfirmation '+UpCaseStr(StrReplace(StrReplace(
                 MenuToolsItem(Round(MERA.MAIN.CMD.TOOLS.val)),'  ',Dump(' '),3),'  ',Dump(' '),3)));
     end else begin
      MenuToolsCmnd(Round(MERA.MAIN.CMD.TOOLS.val));
      MERA.MAIN.CMD.TOOLS.val:=-1;
     end;
    end;
    sNul(Edit(''));
   end;
   {
   TOOLS menu (after confirmation).
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'YesNo_'+NameTag(MERA.MAIN.CMD.TOOLS.tag)) then begin
    if MERA.MAIN.CMD.TOOLS.val>=0 then
    if Val(ExtractWord(2,Edit('?ans 0')))=6 then MenuToolsCmnd(Round(MERA.MAIN.CMD.TOOLS.val));
    MERA.MAIN.CMD.TOOLS.val:=-1;
    sNul(Edit(''));
   end;
  end;
  if EditState=ef_Done then begin
   Problem('Unknown tag edition!');
   sNul(Edit(''));
  end;
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Dialog error detected!');
   sNul(Edit(''));
  end;
  {
  Handle left button clicks...
  }
  if ClickButton=1 then begin
   {
   Toolbar buttons
   }
   ClickBitXorLocal(MERA.MAIN.CMD.HELP.tag,1);
   ClickBitXorLocal(MERA.MAIN.CMD.HOME.tag,1);
   ClickBitXorLocal(MERA.MAIN.CMD.OPEN.tag,1);
   ClickBitXorLocal(MERA.MAIN.CMD.SAVE.tag,1);
   ClickBitXorLocal(MERA.MAIN.CMD.LOADINI.tag,1);
   ClickBitXorLocal(MERA.MAIN.CMD.SAVEINI.tag,1);
   ClickBitXorLocal(MERA.MAIN.CMD.TOOLS.tag,1);
   ClickBitXorLocal(MERA.MAIN.CMD.SOUND.tag,1);
   ClickBitXorLocal(MERA.MAIN.CMD.CLOSE.tag,1);
   if ClickTag=MERA.MAIN.CMD.SAVE.tag then begin
    bNul(iSetTag(MERA.DatSrvGate.tag,Ord(iGetTag(MERA.MAIN.CMD.SAVE.tag)<>0)));
    if iGetTag(MERA.MAIN.CMD.SAVE.tag)<>0 then AwakeDatSrv;
   end;
   {
   Smile face button...
   }
   if ClickTag=MERA.MAIN.CMD.SMILE.tag then begin
    bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
    bNul(iSetTag(MERA.MAIN.CMD.SMILE.tag,0));
    bNul(Voice(snd_Click));
   end;
   {
   Plot & Tab windows
   }
   ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
   if ClickCurve<>0 then begin
    iNul(WinSelectByCurve(ClickCurve,ClickCurve));
    bNul(Voice(snd_Wheel));
   end;
   {
   Calibrations
   }
   if IsSameText(ExtractFileExt(ClickSensor),'.CAL') then begin
    bNul(CalibrOpenByCurve(RefFind('Curve '+ExtractFileName(ClickSensor))));
    bNul(Voice(snd_Click));
   end;
   {
   Cron actions
   }
   if IsSameText(Copy(Trim(ClickSensor),1,6),'@Cron.') then begin
    Cron(URL_Decode(ClickSensor));
    bNul(Voice(snd_Click));
   end;
   {
   Device messages
   }
   if IsSameText(Copy(Trim(ClickSensor),1,8),'@DevMsg+') then begin
    Cron(URL_Decode(ClickSensor));
    bNul(Voice(snd_Click));
   end;
   {
   User utilities: @...
   }
   if IsSameText('@Mod',Copy(ClickSensor,1,4)) then begin
    DevSendCmd(devModbusProxy,ClickSensor);
    bNul(Voice(snd_Click));
   end else
   if IsSameText('@',Copy(ClickSensor,1,1)) then begin
    DevSendCmd(devMySelf,url_decode(ClickSensor));
    bNul(Voice(snd_Click));
   end;
   //
   // MERAxx.CTRL sensors
   //
   if IsSameText(Copy(ClickSensor,1,4),'MERA') then
   if IsSameText(ExtractFileExt(ClickSensor),'.CTRL') then begin
    i:=0;
    while i<MaxInt do begin
     if IsEmptyStr(ParamStr('CIRWINNAME '+Str(i))) then i:=MaxInt else
     if Pos(UpcaseStr(ClickSensor),UpcaseStr(ParamStr('CIRWINNAME '+Str(i))))>0 then begin
      Cron('@WinSelect '+ParamStr('CIRWINNAME '+Str(i)));
      bNul(Voice(snd_Wheel));
      i:=MaxInt;
     end else i:=i+1;
    end;
   end;
  end;
  {
  Handle right button clicks...
  }
  if ClickButton=2 then begin
   SensorHelp(Url_Decode(ClickParams('Hint')));
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearNetLibrary;
  MERA_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  InitNetLibrary;
  MERA_INIT;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
  cmd_MenuCloseConfirmation:=RegisterStdInCmd('@MenuCloseConfirmation','@MenuCloseConfirmation - for internal use');
  cmd_MenuToolsConfirmation:=RegisterStdInCmd('@MenuToolsConfirmation','@MenuToolsConfirmation - for internal use');
  cmd_WinHide              :=RegisterStdInCmd('@WinHide','@WinHide w - hide window w');
  cmd_WinShow              :=RegisterStdInCmd('@WinShow','@WinShow w - show window w');
  cmd_WinDraw              :=RegisterStdInCmd('@WinDraw','@WinDraw w - draw window w');
  cmd_WinSelect            :=RegisterStdInCmd('@WinSelect','@WinSelect w - select window w');
  cmd_Async                :=RegisterStdInCmd('@Async','@Async c - run command c asynchronous');
  cmd_CmdLoadIni           :=RegisterStdInCmd('@Cmd.LoadIni','@Cmd.LoadIni - load params from INI');
  cmd_CmdSaveIni           :=RegisterStdInCmd('@Cmd.SaveIni','@Cmd.SaveIni - save params to   INI');
  cmd_AssignTag            :=RegisterStdInCmd('@AssignTag','@AssignTag t v - assign value v to tag t');
  cmd_ActionDaqNavigator   :=RegisterStdInCmd('@ActionDaqNavigator','@ActionDaqNavigator - Open Navigator list');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  FreeNetLibrary;
  MERA_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  PollNetLibrary;
  MERA_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer; n,tag,crv:Integer; r,a,b:Real;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @MenuCloseConfirmation
   }
   if (cmdid = cmd_MenuCloseConfirmation) then begin
    if MERA.MAIN.CMD.CLOSE.val>=0 then
    if EditState=0 then begin
    if Pos('?',Edit('(Вы действительно хотите:')
              +Edit(' ')
              +Edit(' '+arg)
              +Edit(' ')
              +Edit(' Эта операция может вызвать проблемы!')
              +Edit(')YesNo YesNo_'+NameTag(MERA.MAIN.CMD.CLOSE.tag)))>0
     then Problem('Could not initialize dialog!');
    end else Problem('Could not initialize dialog!');
    Data:='';
   end else
   {
   @MenuToolsConfirmation
   }
   if (cmdid = cmd_MenuToolsConfirmation) then begin
    if MERA.MAIN.CMD.TOOLS.val>=0 then
    if EditState=0 then begin
    if Pos('?',Edit('(Вы действительно хотите:')
              +Edit(' ')
              +Edit(' '+arg)
              +Edit(' ')
              +Edit(' Эта операция может вызвать проблемы!')
              +Edit(')YesNo YesNo_'+NameTag(MERA.MAIN.CMD.TOOLS.tag)))>0
     then Problem('Could not initialize dialog!');
    end else Problem('Could not initialize dialog!');
    Data:='';
   end else
   {
   @ActionDaqNavigator
   }
   if (cmdid = cmd_ActionDaqNavigator) then begin
    Cron('@Eval @System @Async @Silent @Menu run FormDaqControlDialog.ActionDaqNavigator');
    Data:='';
   end else
   {
   @WinHide DEMO.CTRL
   }
   if (cmdid = cmd_WinHide) then begin
    if Length(Trim(arg))>0 then bNul(WinHide(Trim(arg)));
    Data:='';
   end else
   {
   @WinShow DEMO.CTRL
   }
   if (cmdid = cmd_WinShow) then begin
    if Length(Trim(arg))>0 then bNul(WinShow(Trim(arg)));
    Data:='';
   end else
   {
   @WinDraw DEMO.CTRL
   }
   if (cmdid = cmd_WinDraw) then begin
    if Length(Trim(arg))>0 then bNul(WinDraw(Trim(arg)));
    Data:='';
   end else
   {
   @WinSelect DEMO.CTRL
   }
   if (cmdid = cmd_WinSelect) then begin
    if Length(Trim(arg))>0 then bNul(WinSelect(Trim(arg)));
    Data:='';
   end else
   {
   @Async @WinSelect DEMO.CTRL
   }
   if (cmdid = cmd_Async) then begin
    if Length(Trim(arg))>0 then DevSendCmd(devMySelf,Trim(arg));
    Data:='';
   end else
   {
   @Cmd.LoadIni
   }
   if (cmdid = cmd_CmdLoadIni) then begin
    iNul(CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @Cmd.SaveIni
   }
   if (cmdid = cmd_CmdSaveIni) then begin
    iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @AssignTag UH_NAMES T1/T2/T3
   }
   if (cmdid = cmd_AssignTag) then begin
    tag:=FindTag(ExtractWord(1,arg));
    if TypeTag(tag)>0 then UpdateTag(tag,Trim(SkipWords(1,arg)),_MinusInf,_PlusInf);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
