 {
 ***********************************************************************
 DEMO_LM9 main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
 [@Help]
 |StdIn Command list: "@cmd=arg" or "@cmd arg"
 |********************************************************
 | @SinWave n v   - set SinWave parameter (n) value (v)
 |********************************************************
 []
 }
program demo_lm9_main_ctrl;      { DEMO_LM9 main control program    }
{$T+}
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmilePeriod = 1000;             { Polling period for smile face    }
 AwakePeriod = 100;              { Period of checks to awake DatSrv }

type
 TTagRef = record tag,nai,nao,ndi,ndo:Integer; val:Real; end;
 TDEMO_LM9MainRec = record       { Main control & GUI               }
  CMD      : record              { CoMmandDs to control GUI         }
   HELP    : TTagRef;            { Open Help                        }
   HOME    : TTagRef;            { Exec Home                        }
   OPEN    : TTagRef;            { Open DAT file(s)                 }
   SAVE    : TTagRef;            { Save DAT file(s)                 }
   LOADINI : TTagRef;            { Load INI file                    }
   SAVEINI : TTagRef;            { Save INI file                    }
   TOOLS   : TTagRef;            { Tools menu                       }
   SOUND   : TTagRef;            { Sound menu                       }
   SMILE   : TTagRef;            { Smile menu                       }
   CLOSE   : TTagRef;            { Close DAQ/CRW/WIN                }
  end;                           {                                  }
 end;
                                 {                                  }
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 DEMO_LM9     : record           { All DEMO_LM9 data                 }
  MAIN       : TDEMO_LM9MainRec; { Main control & GUI               }
  AwokeTime  : Real;             { Time when DatSrv last awoke      }
  DatSrvGate : TTagRef;          { Save data to DatSrv              }
 end;                            {                                  }
 cmd_SinWave      : Integer;     { @SinWave                         }
 lm9              : Integer;     { LM9 task id                      }
 SinWaveGenerate  : TTagRef;     {                                  }
 SinWaveAmplitude : TTagRef;     {                                  }
 SinWaveFrequency : TTagRef;     {                                  }
 SinWavePhase     : TTagRef;     {                                  }
 SinWaveNoise     : TTagRef;     {                                  }
 SinWaveValue     : TTagRef;     {                                  }
 CosWaveValue     : TTagRef;     {                                  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Initilize DEMO_LM9.MAIN record tags
 }
 procedure TDEMO_LM9MainRec_Init(var Rec:TDEMO_LM9MainRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.CMD.HELP.tag,    TagPrefix+'.CMD.HELP',    1);
   InitTag(Rec.CMD.HOME.tag,    TagPrefix+'.CMD.HOME',    1);
   InitTag(Rec.CMD.OPEN.tag,    TagPrefix+'.CMD.OPEN',    1);
   InitTag(Rec.CMD.SAVE.tag,    TagPrefix+'.CMD.SAVE',    1);
   InitTag(Rec.CMD.LOADINI.tag, TagPrefix+'.CMD.LOADINI', 1);
   InitTag(Rec.CMD.SAVEINI.tag, TagPrefix+'.CMD.SAVEINI', 1);
   InitTag(Rec.CMD.TOOLS.tag,   TagPrefix+'.CMD.TOOLS',   1);
   InitTag(Rec.CMD.SOUND.tag,   TagPrefix+'.CMD.SOUND',   1);
   InitTag(Rec.CMD.SMILE.tag,   TagPrefix+'.CMD.SMILE',   1);
   InitTag(Rec.CMD.CLOSE.tag,   TagPrefix+'.CMD.CLOSE',   1);
   Rec.CMD.SMILE.val:=GetErrCount(-2);
  end;
 end;
 {
 Menu Close Starter to start editing.
 }
 procedure MenuCloseStarter;
 var i,n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Закрыть"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Продолжить работу текущего сеанса АСУ');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@tooltip text "Желаю успешной работы" preset stdNotify delay 15000');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и закрыть программу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Crw Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и продолжить работу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить сеанс АСУ и начать заново');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Restart');
   //////////////////////////////////////////
   for i:=1 to WordCount(EditGetWellKnownDevices(DevName)) do
   if (RefFind('device '+ExtractWord(i,EditGetWellKnownDevices(DevName)))<>0) then begin
    n:=n+EditAddInputLn('Перезапустить сервер '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
    n:=n+EditAddConfirm(EditGetLastInputLn);
    n:=n+EditAddCommand('@SysEval @Daq Compile '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
   end;
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс Windows');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Logout');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Restart');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выключить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Exit');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 530 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CLOSE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Close Handler to handle editing.
 }
 procedure MenuCloseHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_CLOSE'));
 end;
 {
 Menu Tools Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный  (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: детальный  (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@LoadIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SaveIni');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 375 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Tools Handler to handle editing.
 }
 procedure MenuToolsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 {
 Awake DatSrv to enforce data save.
 }
 procedure AwakeDatSrv;
 begin
  DEMO_LM9.AwokeTime:=mSecNow;
  DevPostCmd(devDatSrv,'  ');
 end;
 {
 Clear SinWave variables;
 }
 procedure SinWave_Clear;
 begin
  lm9:=0;
 end;
 {
 Free LM9 task running to process SinWave.
 }
 procedure SinWave_Free;
 begin
  if (lm9<>0) then begin
   LM9_TidFree(lm9);
   lm9:=0;
  end;
 end;
 {
 SinWave initialization.
 }
 procedure SinWave_Init;
 begin
  InitTag(SinWaveGenerate.tag,  'SinWaveGenerate',   1);
  InitTag(SinWaveAmplitude.tag, 'SinWaveAmplitude',  2);
  InitTag(SinWaveFrequency.tag, 'SinWaveFrequency',  2);
  InitTag(SinWavePhase.tag,     'SinWavePhase',      2);
  InitTag(SinWaveNoise.tag,     'SinWaveNoise',      2);
  InitTag(SinWaveValue.tag,     'SinWaveValue',      2);
  InitTag(CosWaveValue.tag,     'CosWaveValue',      2);
  SinWaveGenerate.val  := MaxReal;
  SinWaveAmplitude.val := MaxReal;
  SinWaveFrequency.val := MaxReal;
  SinWavePhase.val     := MaxReal;
  SinWaveNoise.val     := MaxReal;
  SinWaveValue.val     := MaxReal;
  CosWaveValue.val     := MaxReal;
 end;
 {
 Generate SinWaveValue if SinWaveGenerate flag.
 }
 procedure SinWave_Generate;
 var v,a,f,p,n,t:Real;
 begin
  if iGetTag(SinWaveGenerate.tag)<>0 then begin
   a:=rGetTag(SinWaveAmplitude.tag);
   f:=rGetTag(SinWaveFrequency.tag);
   p:=rGetTag(SinWavePhase.tag);
   n:=rGetTag(SinWaveNoise.tag)*random(-0.5,0.5);
   t:=(mSecNow-FixmSecNow)/1000;
   v:=a*sin(2*pi*f*t+p)+n;
   bNul(rSetTag(SinWaveValue.tag,v));
  end;
 end;
 {
 Update SinWave variables, i.e. send to LM9 if one changed.
 }
 procedure SinWave_Update;
 begin
  if (lm9<>0) then begin
   if ShouldRefresh(SinWaveGenerate.val,iGetTag(SinWaveGenerate.tag))>0
   then bNul(LM9_Post(lm9,StrFmt('@SinWave SinWaveGenerate %g',SinWaveGenerate.val)));
   if ShouldRefresh(SinWaveAmplitude.val,rGetTag(SinWaveAmplitude.tag))>0
   then bNul(LM9_Post(lm9,StrFmt('@SinWave SinWaveAmplitude %g',SinWaveAmplitude.val)));
   if ShouldRefresh(SinWaveFrequency.val,rGetTag(SinWaveFrequency.tag))>0
   then bNul(LM9_Post(lm9,StrFmt('@SinWave SinWaveFrequency %g',SinWaveFrequency.val)));
   if ShouldRefresh(SinWavePhase.val,rGetTag(SinWavePhase.tag))>0
   then bNul(LM9_Post(lm9,StrFmt('@SinWave SinWavePhase %g',SinWavePhase.val)));
   if ShouldRefresh(SinWaveNoise.val,rGetTag(SinWaveNoise.tag))>0
   then bNul(LM9_Post(lm9,StrFmt('@SinWave SinWaveNoise %g',SinWaveNoise.val)));
   if ShouldRefresh(SinWaveValue.val,rGetTag(SinWaveValue.tag))>0
   then bNul(LM9_Post(lm9,StrFmt('@SinWave SinWaveValue %g',SinWaveValue.val)));
   if ShouldRefresh(CosWaveValue.val,rGetTag(CosWaveValue.tag))>0
   then bNul(LM9_Post(lm9,StrFmt('@SinWave CosWaveValue %g',CosWaveValue.val)));
  end;
 end;
 {
 SinWave polling: 1) generate SinWave; 2) if LM9 task running, update tags if changed.
 }
 procedure SinWave_Poll;
 begin
  SinWave_Generate;
  if (lm9<>0) then begin
   if task_wait(lm9,0) then begin
    bNul(LM9_Post(lm9,'@RunCount '+Str(RunCount)));
    SinWave_Update;
   end else SinWave_Free;
  end;
 end;
 {
 Handle @SinWave message:
 @SinWave SinWaveGenerate 1
 @SinWave SinWaveAmplitude 100
 @SinWave SinWaveFrequency 0.1
 @SinWave SinWavePhase 0
 @SinWave SinWaveNoise 0.1
 @SinWave SinWaveValue 1.5
 @SinWave CosWaveValue 2.5
 @SinWave RefreshAll
 }
 procedure SinWave_Handle(arg:String);
 var w1,w2:String; tag:Integer;
 begin 
  Success(arg);
  w1:=ExtractWord(1,arg); tag:=FindTag(w1);
  w2:=ExtractWord(2,arg);
  if (tag<>0) and (tag=SinWaveGenerate.tag) then begin
   UpdateTag(SinWaveGenerate.tag,w2,_MinusInf,_PlusInf);
   SinWaveGenerate.val:=MaxReal;
  end else
  if (tag<>0) and (tag=SinWaveAmplitude.tag) then begin
   UpdateTag(SinWaveAmplitude.tag,w2,_MinusInf,_PlusInf);
   SinWaveAmplitude.val:=MaxReal;
  end else
  if (tag<>0) and (tag=SinWaveFrequency.tag) then begin
   UpdateTag(SinWaveFrequency.tag,w2,_MinusInf,_PlusInf);
   SinWaveFrequency.val:=MaxReal;
  end else
  if (tag<>0) and (tag=SinWavePhase.tag) then begin
   UpdateTag(SinWavePhase.tag,w2,_MinusInf,_PlusInf);
   SinWavePhase.val:=MaxReal;
  end else
  if (tag<>0) and (tag=SinWaveNoise.tag) then begin
   UpdateTag(SinWaveNoise.tag,w2,_MinusInf,_PlusInf);
   SinWaveNoise.val:=MaxReal;
  end else
  if (tag<>0) and (tag=CosWaveValue.tag) then begin
   UpdateTag(CosWaveValue.tag,w2,_MinusInf,_PlusInf);
   CosWaveValue.val:=MaxReal;
  end else
  if IsSameText(w1,'RefreshAll') then begin
   SinWaveGenerate.val  := MaxReal;
   SinWaveAmplitude.val := MaxReal;
   SinWaveFrequency.val := MaxReal;
   SinWavePhase.val     := MaxReal;
   SinWaveNoise.val     := MaxReal;
   SinWaveValue.val     := MaxReal;
   CosWaveValue.val     := MaxReal;
   SinWave_Update;
  end;
  w1:='';
  w2:='';
 end;
 {
 Launch DemoSinWaveControl.lm9 test program.
 }
 procedure SinWave_Launch;
 begin
  SinWave_Free;
  lm9:=LM9_Launch('DemoSinWaveControl',                // LM9 program name (located in SearchPath).
                  '1 2 3',                             // Command line arguments - just for DEMO.
                  'ProcessPriority=6',                 // Task options.
                  'Params',                            // Addon parameters - just for DEMO.
                  'ipc'+LineEnding+'LogsHistory=32');  // IPC channel description.
  DevPostCmdLocal('@SinWave RefreshAll'+LineEnding);   // Initial refreshment.
 end;
 {
 DEMO_LM9 clear strings
 }
 procedure DEMO_LM9_CLEAR;
 begin
  SinWave_Clear;
 end;
 {
 DEMO_LM9 initialization
 }
 procedure DEMO_LM9_INIT;
 begin
  //
  // Initialize tags & devices...
  //
  TDEMO_LM9MainRec_Init(DEMO_LM9.MAIN,ReadIni('tagDEMO_LM9')+'.MAIN');
  InitTag(DEMO_LM9.DatSrvGate.tag,'DATSRV.GATE',-1);
  SinWave_Init;
  //
  // Initialize values...
  //
  DEMO_LM9.AwokeTime:=0;
 end;
 {
 DEMO_LM9 finalization
 }
 procedure DEMO_LM9_FREE;
 begin
  SinWave_Free;
 end;
 {
 DEMO_LM9 polling
 }
 procedure DEMO_LM9_POLL;
 var nerrors:Real; ClickCurve:Integer;
 begin
  {
  SinWave polling.
  }
  SinWave_Poll;
  {
  Awake DatSrv to enforce data save.
  }
  if SysTimer_Pulse(AwakePeriod)>0 then begin
   bNul(iSetTag(DEMO_LM9.DatSrvGate.tag,Ord(iGetTag(DEMO_LM9.MAIN.CMD.SAVE.tag)<>0)));
  end;
  {
  Execute GUI commands
  }
  if iGetTag(DEMO_LM9.MAIN.CMD.HELP.tag)<>0 then begin
   Cron('@Browse '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
   bNul(iSetTag(DEMO_LM9.MAIN.CMD.HELP.tag,0));
  end;
  if iGetTag(DEMO_LM9.MAIN.CMD.HOME.tag)<>0 then begin
   Cron('@cron.run DEMO_LM9.MAIN.CTRL.HOME');
   bNul(iSetTag(DEMO_LM9.MAIN.CMD.HOME.tag,0));
  end;
  if iGetTag(DEMO_LM9.MAIN.CMD.OPEN.tag)<>0 then begin
   Cron('@FileOpenDialog '
   +URL_Packed(AddBackSlash(DaqFileRef(AdaptFileName(ReadIni('['+DatSrv+'] DataPath')),''))+'*.dat;*.crw'));
   bNul(iSetTag(DEMO_LM9.MAIN.CMD.OPEN.tag,0));
  end;
  if iGetTag(DEMO_LM9.MAIN.CMD.LOADINI.tag)<>0 then begin
   DevPostCmdLocal('@LoadIni');
   bNul(iSetTag(DEMO_LM9.MAIN.CMD.LOADINI.tag,0));
  end;
  if iGetTag(DEMO_LM9.MAIN.CMD.SAVEINI.tag)<>0 then begin
   DevPostCmdLocal('@SaveIni');
   bNul(iSetTag(DEMO_LM9.MAIN.CMD.SAVEINI.tag,0));
  end;
  if iGetTag(DEMO_LM9.MAIN.CMD.TOOLS.tag)<>0 then begin
   bNul(iSetTag(DEMO_LM9.MAIN.CMD.TOOLS.tag,0));
   MenuToolsStarter;
  end;
  if iGetTag(DEMO_LM9.MAIN.CMD.CLOSE.tag)<>0 then begin
   bNul(iSetTag(DEMO_LM9.MAIN.CMD.CLOSE.tag,0));
   MenuCloseStarter;
  end;
  {
  Handle Smile button state
  }
  if SysTimer_Pulse(SmilePeriod)>0 then begin
   nerrors:=GetErrCount(-2);
   if nerrors>DEMO_LM9.MAIN.CMD.SMILE.val then bNul(iSetTag(DEMO_LM9.MAIN.CMD.SMILE.tag,2)) else
   if iGetTag(DEMO_LM9.MAIN.CMD.SMILE.tag)>1 then bNul(iSetTag(DEMO_LM9.MAIN.CMD.SMILE.tag,1));
   DEMO_LM9.MAIN.CMD.SMILE.val:=nerrors;
  end;
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Warning, Information dialog completion.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
   {
   Menu CLOSE.
   }
   MenuCloseHandler;
   {
   Menu TOOLS.
   }
   MenuToolsHandler;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,KeyUp)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     //
     // Launch SinWaveControl.LM9 on Button.
     //
     if (ClickTag=SinWaveGenerate.tag) then begin
      bNul(Voice(snd_Click));
      SinWave_Launch;
     end;
     //
     // Toolbar buttons...
     //
     ClickBitXorLocal(DEMO_LM9.MAIN.CMD.HELP.tag,1);
     ClickBitXorLocal(DEMO_LM9.MAIN.CMD.HOME.tag,1);
     ClickBitXorLocal(DEMO_LM9.MAIN.CMD.OPEN.tag,1);
     ClickBitXorLocal(DEMO_LM9.MAIN.CMD.SAVE.tag,1);
     ClickBitXorLocal(DEMO_LM9.MAIN.CMD.LOADINI.tag,1);
     ClickBitXorLocal(DEMO_LM9.MAIN.CMD.SAVEINI.tag,1);
     ClickBitXorLocal(DEMO_LM9.MAIN.CMD.TOOLS.tag,1);
     ClickBitXorLocal(DEMO_LM9.MAIN.CMD.SOUND.tag,1);
     ClickBitXorLocal(DEMO_LM9.MAIN.CMD.CLOSE.tag,1);
     if ClickTag=DEMO_LM9.MAIN.CMD.SAVE.tag then begin
      bNul(iSetTag(DEMO_LM9.DatSrvGate.tag,Ord(iGetTag(DEMO_LM9.MAIN.CMD.SAVE.tag)<>0)));
      if iGetTag(DEMO_LM9.MAIN.CMD.SAVE.tag)<>0 then AwakeDatSrv;
     end;
     //
     // Smile face button...
     //
     if ClickTag=DEMO_LM9.MAIN.CMD.SMILE.tag then begin
      bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
      bNul(iSetTag(DEMO_LM9.MAIN.CMD.SMILE.tag,0));
      bNul(Voice(snd_Click));
     end;
     //
     // Select Plot & Tab windows by curve...
     //
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     //
     // Console commands: @url_encoded_sensor ...
     //
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Calibrations
     //
     if IsSameText(ExtractFileExt(ClickSensor),'.CAL') then begin
      bNul(CalibrOpenByCurve(RefFind('Curve '+ExtractFileName(ClickSensor))));
      bNul(Voice(snd_Click));
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  DEMO_LM9_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  DEMO_LM9_INIT;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then DevPostCmdLocal('@LoadIni');
  cmd_SinWave:=RegisterStdInCmd('@SinWave','');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then DevPostCmdLocal('@SaveIni');
  DEMO_LM9_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  DEMO_LM9_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @SinWave SinWaveAmplitude 100 
   }
   if (cmdid=cmd_SinWave) then begin
    SinWave_Handle(arg);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
