 {                                                                            
 ***********************************************************************
 Daq Pascal application program LAKESHORE_DRV.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @MenuToolsConfirmation - for internal use.
| @PrintCmdTable - Print Command Table state.
| @Simulate id v - Set simulation data v to id=(ARS,SRS, etc).
| @Setting id v  - Send command id with data v, id=(SRS).
| @Remote @cmd   - run @cmd remotely: send to DIM server
| @Edit id       - edit id (SRS)
| @BrowseHelp    - open help file in browser.
| @OpenConsole   - open driver console window.
| @MenuToolsOpen - open Menu Tools dialog.
| @LoadIni       - load params from INI file.
| @SaveIni       - save params to   INI file.
| @DimGuiClick   - handle remote click from DIM
|********************************************************
[]
 }
program LAKESHORE_DRV;              { LAKESHORE driver                     }
const
 {---------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}               { Include all Standard constants,  }
 {---------------------------------}{ And add User defined constants:  }
 st_NoReq           = 0;            { Status : No request sent         }
 st_WaitAns         = 1;            { Status : Waiting answer          }
 st_WaitGap         = 2;            { Status : Waiting time gap        }
 st_TimeOut         = 3;            { Status : TimeOut found           }
 
 cm_IdentificationQuery            = 1;          {                                  }
 cm_MonitorOutParameterCmd         = 2;          {                                  }
 cm_MonitorOutParameterQuery       = 3;          {                                  }
 cm_AutotuneCmd                    = 4;          {                                  } 
 cm_DiodeExcitationCurParCmd       = 5;          {                                  }
 cm_DiodeExcitationCurParrQuery    = 6;          {                                  }
 cm_InputFilterParameterCmd        = 7;          {                                  }
 cm_InputFilterParameterQuery      = 8;          {                                  }
 cm_HeaterOutputQuery1             = 9;          {                                  }
 cm_HeaterOutputQuery2             = 10;         {                                  }
 cm_HeaterSetupCmd                 = 11;         {                                  }
 cm_HeaterSetupQuery1              = 12;         {                                  }
 cm_HeaterSetupQuery2              = 13;         {                                  }
 cm_HeaterStatusQuery1             = 14;         {                                  }
 cm_HeaterStatusQuery2             = 15;         {                                  }
 cm_InputCurveNumberCmd            = 16;         {                                  }
 cm_InputCurveNumberQueryA         = 17;         {                                  }
 cm_InputCurveNumberQueryB         = 18;         {                                  }
 cm_InputTypeParameterCmd          = 19;         {                                  }
 cm_InputTypeParameterQueryA       = 20;         {                                  }
 cm_InputTypeParameterQueryB       = 21;         {                                  }
 cm_KelvinReadingQueryA            = 22;         {                                  }
 cm_KelvinReadingQueryB            = 23;         {                                  }
 cm_MinimumMaximumDataQuery        = 24;         {                                  }
 cm_ManualOutputCmd                = 25;         {                                  }
 cm_OutManualHeaterPowerOutQuery   = 26;         {                                  }
 cm_OutputModeCommand              = 27;         {                                  }
 cm_OutputModeQuery1               = 28;         {                                  }
 cm_OutputModeQuery2               = 29;         {                                  }
 cm_OutVoltPolarityCommand         = 30;         {                                  }
 cm_OutVoltPolarityQuery           = 31;         {                                  }
 cm_ControlLoopPIDValuesCmd        = 32;         {                                  }
 cm_ControlLoopPIDValuesQuery1     = 33;         {                                  }
 cm_ControlLoopPIDValuesQuery2     = 34;         {                                  }
 cm_ControlSetpointRampParCmd      = 35;         {                                  }
 cm_SetRampPar1                    = 36;         {                                  }
 cm_SetRamp1                       = 37;         {                                  }
 cm_RampRate1                      = 38;         {                                  }
 cm_SetRampPar2                    = 39;         {                                  }
 cm_SetRamp2                       = 40;         {                                  }
 cm_RampRate2                      = 41;         {                                  }
 cm_ControlSetpointRampStatQuery1  = 42;         {                                  }
 cm_ControlSetpointRampStatQuery2  = 43;         {                                  }
 cm_HeaterRangeCmd                 = 44;         {                                  }
 cm_HeaterRangeQuery1              = 45;         {                                  }
 cm_HeaterRangeQuery2              = 46;         {                                  }
 cm_InputReadingStatusQueryA       = 47;         {                                  }
 cm_InputReadingStatusQueryB       = 48;         {                                  }
 cm_ControlSetpointCmd             = 49;         {                                  }
 cm_ControlSetpointQuery1          = 50;         {                                  }
 cm_ControlSetpointQuery2          = 51;         {                                  }
 cm_SensorUnitsInputReadingQuery   = 52;         {                                  }
 cm_ThermocoupleJunctionTempQuery  = 53;         {                                  }
 cm_TemperatureLimitCmd            = 54;         {                                  }
 cm_TemperatureLimitQuery          = 55;         {                                  }
 cm_ControlTuningStatusQuery1      = 56;         {                                  }
 cm_ControlTuningStatusQuery2      = 57;         {                                  }
 cm_WarmupSupplyParameterCmd       = 58;         {                                  }
 cm_WarmupSupplyParameterQuery1    = 59;         {                                  }
 cm_WarmupSupplyParameterQuery2    = 60;         {                                  }
 cm_ControlLoopZoneTableParamCmd   = 61;         {                                  }
 cm_OutputZoneTableParameterQuery  = 62;         {                                  }
                                                 
 MaxCmdNum                         = 63;         { Max command id number            }
 ao_POLL_RATE                      = 0;          { Analog outputs...                }
 ao_ERROR_CNT                      = 1;          {                                  }
 ao_IdentificationQuery            = 6;          {                                  }
 ao_MonitorOutParameterQuery       = 20;         {                                  }
 ao_DiodeExcitationCurParrQuery    = 32;         {                                  }
 ao_InputFilterParameterQuery      = 35;         {                                  }
 ao_HeaterOutputQuery1             = 36;         {                                  }
 ao_HeaterOutputQuery2             = 37;         {                                  }
 ao_HeaterSetupQuery1              = 38;         {                                  }
 ao_HeatResist1                    = 39;         {                                  }
 ao_MaxCurrent1                    = 40;         {                                  }
 ao_HeaterSetupQuery2              = 41;         {                                  }
 ao_HeatResist2                    = 42;         {                                  }
 ao_MaxCurrent2                    = 43;         {                                  }
 ao_HeaterStatusQuery1             = 44;         {                                  }
 ao_HeaterStatusQuery2             = 45;         {                                  }
 ao_InputCurveNumberQueryA         = 46;         {                                  }
 ao_InputCurveNumberQueryB         = 47;         {                                  }
 ao_InputTypeParameterQueryA       = 48;         {                                  }
 ao_InputTypeParameterQueryB       = 49;         {                                  }
 ao_KelvinReadingQueryA            = 54;         {                                  }
 ao_KelvinReadingQueryB            = 55;         {                                  }
 ao_MinimumMaximumDataQuery        = 58;         {                                  }
 ao_OutManualHeaterPowerOutQuery   = 62;         {                                  }
 ao_OutputModeQuery1               = 66;         {                                  }
 ao_OutputModeQuery2               = 67;         {                                  }
 ao_OutVoltPolarityQuery           = 68;         {                                  }
 ao_ControlLoopPIDValuesQuery1     = 69;         {                                  }
 ao_ControlLoopPIDValuesQuery2     = 70;         {                                  }
 ao_SetRampPar1                    = 71;         {                                  }
 ao_SetRamp1                       = 72;         {                                  }
 ao_RampRate1                      = 73;         {                                  }
 ao_SetRampPar2                    = 74;         {                                  }
 ao_SetRamp2                       = 75;         {                                  }
 ao_RampRate2                      = 76;         {                                  }
 ao_ControlSetpointRampStatQuery1  = 77;         {                                  }
 ao_ControlSetpointRampStatQuery2  = 78;         {                                  }
 ao_HeaterRangeQuery1              = 79;         {                                  }
 ao_HeaterRangeQuery2              = 80;         {                                  }
 ao_InputReadingStatusQueryA       = 81;         {                                  }
 ao_InputReadingStatusQueryB       = 82;         {                                  }
 ao_ControlSetpointQuery1          = 85;         {                                  }
 ao_ControlSetpointQuery2          = 86;         {                                  }
 ao_SensorUnitsInputReadingQuery   = 87;         {                                  }
 ao_ThermocoupleJunctionTempQuery  = 88;         {                                  }
 ao_TemperatureLimitQuery          = 89;         {                                  }
 ao_ControlTuningStatusQuery1      = 90;         {                                  }
 ao_ControlTuningStatusQuery2      = 91;         {                                  }
 ao_WarmupSupplyParameterQuery1    = 92;         {                                  }
 ao_WarmupSupplyParameterQuery2    = 93;         {                                  }
 ao_OutputZoneTableParameterQuery  = 94;         {                                  }
 si_OFFLINE                        = 'OFFLINE';  { To identify offline state        }
 DelayOnStart                      = 1000;       { Delay before start polling       }
 UseCmdHash                        = false;      { Use CmdHash for fast search      }
 DimDeadline                       = 5000;       { Detect DIM server is dead        }

type
 {$I _typ_StdLibrary}            { Include all Standard types,         }
 
var
 {------------------------------}{ Declare uses program variables:     }
 {$I _var_StdLibrary}            { Include all Standard variables,     }
 {------------------------------}{ And add User defined variables:     }
 LS                    : record  { LAKESHORE data                      }
  Simulator        : Boolean;    { Simulator mode                      }
  ecTimeOut        : Integer;    { Error code: TimeOut                 }
  Com              : record      { COM port data                       }
   Port            : Integer;    {  Port number                        }
   Status          : Integer;    {  Status flag                        }
   TimeOut         : Integer;    {  TimeOut, ms                        }
   TimeGap         : Integer;    {  Time delay after poll, ms          }
   PollPeriod      : Integer;    { Poll period, ms                     }
   Req,Ans,Buf     : String;     {  Request, Answer                    }
   ReqTime,AnsTime : Real;       {  Request, Answer time, ms           }       
   LastPoll        : Real;       { Time of last poll, ms               }
   PollRate        : Integer;    { Poll rate, poll/sec                 }
  end;                           {                                     }
  Cmd              : record      {  Command cycle data                 }
   Num             : Integer;    {   Current command number            }
   Enabled         : array [1..MaxCmdNum] of Boolean; {                }
   Channel         : array [1..MaxCmdNum] of String;  {                }
   Acronym         : array [1..MaxCmdNum] of String;  {                }
   Leng            : array [1..MaxCmdNum] of Integer; {                }
   Comment         : array [1..MaxCmdNum] of String;  {                }
   OpData          : array [1..MaxCmdNum] of Real;    {                }
   OpBuff          : array [1..MaxCmdNum] of Real;    {                }
   Arg             : array [1..MaxCmdNum] of String;  {                }
   SimDat          : array [1..MaxCmdNum] of String;  {                }
   SimStr          : array [1..MaxCmdNum] of String;  {                }
   AoNum           : array [1..MaxCmdNum] of Integer; {                }
   Tag             : array [1..MaxCmdNum] of Integer; {                }
  end;                                         {                                     }
  CmdHash                        : Integer;    { Hash list ref. for fast search      }
  POLL_ENABLE                    : TTagRef;    {                                     }
  POLL_RATE                      : TTagRef;    {                                     }
  ERROR_CNT                      : TTagRef;    {                                     }
  ID_NAME                        : TTagRef;    {                                     }
  ID_IDN                         : TTagRef;    {                                     }
  ERR                            : TTagRef;    {                                     }
  SERVID                         : TTagRef;    { Server Identifier pid@hostname      }
  CLOCK                          : TTagRef;    { Server Date-Time                    }
  IdentificationQuery            : TTagRef;    {                                     }
  MonitorOutParameterQuery       : TTagRef;    {                                     }
  DiodeExcitationCurParrQuery    : TTagRef;    {                                     }
  InputFilterParameterQuery      : TTagRef;    {                                     }
  HeaterOutputQuery1             : TTagRef;    {                                     }
  HeaterOutputQuery2             : TTagRef;    {                                     }
  HeaterSetupQuery1              : TTagRef;    {                                     }
  HeatResist1                    : TTagRef;    {                                     }
  MaxCurrent1                    : TTagRef;    {                                     }
  HeaterSetupQuery2              : TTagRef;    {                                     }
  HeatResist2                    : TTagRef;    {                                     }
  MaxCurrent2                    : TTagRef;    {                                     }
  HeaterStatusQuery1             : TTagRef;    {                                     }
  InputCurveNumberQueryA         : TTagRef;    {                                     }
  InputCurveNumberQueryB         : TTagRef;    {                                     }
  HeaterStatusQuery2             : TTagRef;    {                                     }
  InputTypeParameterQueryA       : TTagRef;    {                                     }
  EnableInputA                   : TTagRef;    {                                     }
  InputTypeParameterQueryB       : TTagRef;    {                                     }
  EnableInputB                   : TTagRef;    {                                     }
  KelvinReadingQueryA            : TTagRef;    {                                     }
  KelvinReadingQueryB            : TTagRef;    {                                     }
  MinimumMaximumDataQuery        : TTagRef;    {                                     }
  OutManualHeaterPowerOutQuery   : TTagRef;    {                                     }
  OutputModeQuery1               : TTagRef;    {                                     }
  OutputMode1                    : TTagRef;    {                                     }
  ControlInput1                  : TTagRef;    {                                     }
  OutputModePowerup1             : TTagRef;    {                                     }
  ControlInput2                  : TTagRef;    {                                     }
  OutputMode2                    : TTagRef;    {                                     }
  OutputModeQuery2               : TTagRef;    {                                     }
  OutputModePowerup2             : TTagRef;    {                                     }
  OutVoltPolarityQuery           : TTagRef;    {                                     }
  ControlLoopPIDValuesQuery1     : TTagRef;    {                                     }
  PIDparP1                       : TTagRef;    {                                     }
  PIDparI1                       : TTagRef;    {                                     }
  PIDparD1                       : TTagRef;    {                                     }
  ControlLoopPIDValuesQuery2     : TTagRef;    {                                     }
  PIDparP2                       : TTagRef;    {                                     }
  PIDparI2                       : TTagRef;    {                                     }
  PIDparD2                       : TTagRef;    {                                     }
  SetRampPar1                    : TTagRef;    {                                     }
  SetRamp1                       : TTagRef;    {                                     }
  RampRate1                      : TTagRef;    {                                     }
  SetRampPar2                    : TTagRef;    {                                     }
  SetRamp2                       : TTagRef;    {                                     }
  RampRate2                      : TTagRef;    {                                     }
  ControlSetpointRampStatQuery1  : TTagRef;    {                                     }
  ControlSetpointRampStatQuery2  : TTagRef;    {                                     }
  HeaterRangeQuery1              : TTagRef;    {                                     }
  HeaterRangeQuery2              : TTagRef;    {                                     }
  InputReadingStatusQueryA       : TTagRef;    {                                     }
  InputReadingStatusQueryB       : TTagRef;    {                                     }
  ControlSetpointQuery1          : TTagRef;    {                                     }
  ControlSetpointQuery2          : TTagRef;    {                                     }
  SensorUnitsInputReadingQuery   : TTagRef;    {                                     }
  ThermocoupleJunctionTempQuery  : TTagRef;    {                                     }
  TemperatureLimitQuery          : TTagRef;    {                                     }
  ControlTuningStatusQuery1      : TTagRef;    {                                     }
  ActiveTune1                    : TTagRef;    {                                     }
  AtuneError1                    : TTagRef;    {                                     }
  AtuneStage1                    : TTagRef;    {                                     }
  AutoTune1                      : TTagRef;    {                                     }
  ControlTuningStatusQuery2      : TTagRef;    {                                     }
  ActiveTune2                    : TTagRef;    {                                     }
  AtuneError2                    : TTagRef;    {                                     }
  AtuneStage2                    : TTagRef;    {                                     }
  AutoTune2                      : TTagRef;    {                                     }
  HeaterStart1                   : TTagRef;    {                                     }
  HeaterStart2                   : TTagRef;    {                                     }
  SetTDX1                        : TTagRef;    {                                     }
  SetTDX2                        : TTagRef;    {                                     }
  WarmupSupplyParameterQuery1    : TTagRef;    {                                     }
  WarmupControl1                 : TTagRef;    {                                     }  
  WarmupOutput1                  : TTagRef;    {                                     }
  WarmupSupplyParameterQuery2    : TTagRef;    {                                     }  
  WarmupOutput2                  : TTagRef;    {                                     }
  WarmupControl2                 : TTagRef;    {                                     }
  ManualRangeButtonA             : TTagRef;    {                                     }
  ManualRangeButtonB             : TTagRef;    {                                     }
  AutoRangeA                     : TTagRef;    {                                     }
  AutoRangeB                     : TTagRef;    {                                     }
  OutputZoneTableParameterQuery  : TTagRef;    {                                     }
  ModelCode                      : Integer;    { Encoded model ranges (Tab index)    }
  DrvName                        : String;     { Model name like DCU01               }
  SelfId                         : String;     { Self pid@hostname                   }
 end;                                          {                                     }
 ColorNorm                       : Integer;    { Color in normal state: lime,aqua    }
 ColorWarn                       : Integer;    { Color in warning state: yellow      }
 cmd_DimTagUpdate                : Integer;    { @DimTagUpdate                       }
 cmd_Simulate                    : Integer;    { @Simulate                           }
 cmd_PrintCmdTable               : Integer;    { @PrintCmdTable                      }
 cmd_Setting                     : Integer;    { @Setting                            }
 cmd_Remote                      : Integer;    { @Remote                             }
 cmd_Edit                        : Integer;    { @Edit                               }
 cmd_BrowseHelp                  : Integer;    { @BrowseHelp                         }
 cmd_OpenConsole                 : Integer;    { @OpenConsole                        }
 cmd_MenuToolsOpen               : Integer;    { @MenuToolsOpen                      }
 cmd_LoadIni                     : Integer;    { @LoadIni                            }
 cmd_SaveIni                     : Integer;    { @SaveIni                            }
 cmd_MenuToolsConfirmation       : Integer;    { Command @MenuToolsConfirmation      }
 MenuToolsSelected               : Integer;    { MenuTools selected item index       }
                                                                       
 {------------------------------}{ Declare procedures & functions:     }
 {$I _fun_StdLibrary}            { Include all Standard functions,     }
 {------------------------------}{ And add User defined functions:     }

 {
 Nice tooltip notifier.
 }
 procedure NiceNotify(aText:String; aDelay:Integer);
 begin
  if Length(aText)>0 then begin
   ShowTooltip('text "'+aText+'" preset stdNotify delay '+Str(aDelay));
  end;
 end;
 
 {
 Post command to local/remote server.
 }
 procedure PostCmdLocal(cmd:String);
 begin
  DevPostCmd(devMySelf,cmd);
 end;
 procedure PostCmdRemote(cmd:String);
 begin
  Dim_GuiConsoleSend(DevName,cmd);
 end;
 
 {
 Check ModelCode is valid or return zero.
 }
 function CheckModelCode(ModelCode:Integer):Integer;
 begin
  if (ModelCode<1) then ModelCode:=0 else
  CheckModelCode:=ModelCode;
 end;
 
 {
 Check & return LAKESHORE ModelCode, nonzero if IDN detection was successful.
 }
 function LAKESHORE_ModelCode:Integer;
 begin
  LAKESHORE_ModelCode:=CheckModelCode(LS.ModelCode);
 end;
 
 {
 Parse IDN string like 'DCU01', find ModelCode.
 }
 function LAKESHORE_ParseIDN(IDN:String; silent:Boolean):Integer;
 var ModelCode:Integer;
 begin
  ModelCode:=0; IDN:=Trim(IDN);
  if not IsSameText(IDN,si_OFFLINE) then ModelCode:=1;
  if not silent then
  if CheckModelCode(ModelCode)>0 
  then Success('Detected IDN: '+IDN)
  else Problem('Fail detect IDN: '+IDN);
  LAKESHORE_ParseIDN:=ModelCode;
 end;
 
 {
 Unique string to identify MenuTools.
 }
 function MenuToolsIdent:String;
 begin
  MenuToolsIdent:=StrFmt('MENU_TOOLS_%s',DevName);
 end;
 
 {
 Get text of Tools menu items
 }
 function MenuToolsItem(MenuTools:Integer):String;
 begin
  if MenuTools=0  then MenuToolsItem:='@BrowseHelp             = Вызвать справочное окно (HELP)'   else
  if MenuTools=1  then MenuToolsItem:='@OpenConsole            = Открыть консольное окно драйвера' else
  if MenuTools=2  then MenuToolsItem:='@DebugFlags 3           = Режим отладки: нормальный'        else
  if MenuTools=3  then MenuToolsItem:='@DebugFlags 15          = Режим отладки: ввод-вывод'        else
  if MenuTools=4  then MenuToolsItem:='@DebugFlags 31          = Режим отладки: детальный'         else
  if MenuTools=5  then MenuToolsItem:='@Remote @LoadIni        = Загрузить Параметры из INI файла' else
  if MenuTools=6  then MenuToolsItem:='@Remote @SaveIni        = Сохранить Параметры в  INI файле' else
  if MenuTools=7  then MenuToolsItem:='@Remote @Setting SETP 0 = Response Time = 0  ms'            else
  if MenuTools=8  then MenuToolsItem:='@Remote @Setting AZ $FF = Response Time = 15 ms'            else
  if MenuTools=9  then MenuToolsItem:='@Edit AZ                = Уставка Response Time'            else
  if MenuTools=10 then MenuToolsItem:='@PrintCmdTable          = Печать состояния таблицы команд'  else
  MenuToolsItem:='';
 end;
 
 {
 Execute Tools menu commands
 }
 procedure MenuToolsCmnd(MenuTools:Integer);
 var Item:String;
 begin
  Item:=MenuToolsItem(MenuTools);
  if (Pos('@',Item)=1) and (Pos('=',Item)>0) then begin
   Item:=Trim(Copy(Item,1,Pos('=',Item)-1));
   DevPostCmd(DevMySelf,Item);
  end;
  Item:='';
 end;
 
 {
 Open MenuTools to edit. Detect number of items automatically.
 }
 procedure MenuToolsOpen;
 var i,err:Integer;
 begin
  i:=0; err:=0;
  if EditState=0 then begin
   err:=err+Pos('?',Edit('(Команда "Инструменты"... '));
   err:=err+Pos('?',Edit(' Что выбираете:'));
   while not IsEmptyStr(MenuToolsItem(i)) do begin
    err:=err+Pos('?',Edit(' '+MenuToolsItem(i)));
    i:=i+1;
   end;
   err:=err+Pos('?',Edit(')MenuList '+MenuToolsIdent));
   if err>0 then Warning('Error initializing MenuList!');
  end else Warning('Cannot edit right now!');
  MenuToolsSelected:=-1;
 end;
 
 {
 Find command by id (Acronym).
 }
 function LAKESHORE_Cmd_Find(id:String):Integer;
 var i,n:Integer;
 begin
  n:=0;
  if (Length(id)>0) then
  if UseCmdHash and (LS.CmdHash<>0) then begin
   n:=HashList_GetLink(LS.CmdHash,id);
  end else begin
   for i:=1 to MaxCmdNum do if n=0 then
   if IsSameText(id,LS.Cmd.Acronym[i])
   then n:=i;
  end;
  LAKESHORE_Cmd_Find:=n;
 end;
 
 {
 Initialize tag refreshment value.
 }
 procedure LAKESHORE_FillTag(tag:Integer; InitVal:Real);
  procedure Process(var R:TTagRef);
  begin
   if (R.tag=tag) then bNul(ShouldRefresh(R.val,InitVal)>0);
  end;
 begin
  if (TypeTag(tag)>0) then begin
   Process(LS.POLL_ENABLE);
   Process(LS.POLL_RATE);
   Process(LS.ERROR_CNT);
   Process(LS.ID_NAME);
   Process(LS.ID_IDN);
   Process(LS.IdentificationQuery);                  
   Process(LS.MonitorOutParameterQuery);             
   Process(LS.DiodeExcitationCurParrQuery); 
   Process(LS.InputFilterParameterQuery);            
   Process(LS.HeaterOutputQuery1);                    
   Process(LS.HeaterOutputQuery2);                    
   Process(LS.HeaterSetupQuery1);                     
   Process(LS.HeatResist1);                     
   Process(LS.MaxCurrent1);                     
   Process(LS.HeaterSetupQuery2);                     
   Process(LS.HeatResist2);                     
   Process(LS.MaxCurrent2);                     
   Process(LS.HeaterStatusQuery1);                    
   Process(LS.HeaterStatusQuery2);                    
   Process(LS.InputCurveNumberQueryA);                    
   Process(LS.InputCurveNumberQueryB);                    
   Process(LS.InputTypeParameterQueryA);              
   Process(LS.EnableInputA);              
   Process(LS.InputTypeParameterQueryB);              
   Process(LS.EnableInputB);              
   Process(LS.KelvinReadingQueryA);                   
   Process(LS.KelvinReadingQueryB);                   
   Process(LS.MinimumMaximumDataQuery);              
   Process(LS.OutManualHeaterPowerOutQuery);   
   Process(LS.OutputModeQuery1);                      
   Process(LS.OutputMode1);                      
   Process(LS.ControlInput1);                      
   Process(LS.OutputModePowerup1);                      
   Process(LS.OutputModeQuery2);                      
   Process(LS.OutputMode2);                      
   Process(LS.ControlInput2);                      
   Process(LS.OutputModePowerup2);                      
   Process(LS.OutVoltPolarityQuery);           
   Process(LS.ControlLoopPIDValuesQuery1);            
   Process(LS.PIDparP1);
   Process(LS.PIDparI1);
   Process(LS.PIDparD1);
   Process(LS.ControlLoopPIDValuesQuery2);            
   Process(LS.PIDparP2);
   Process(LS.PIDparI2);
   Process(LS.PIDparD2);
   Process(LS.SetRampPar1);    
   Process(LS.SetRamp1);    
   Process(LS.RampRate1);    
   Process(LS.SetRampPar2);    
   Process(LS.SetRamp2);    
   Process(LS.RampRate2);    
   Process(LS.ControlSetpointRampStatQuery1);       
   Process(LS.ControlSetpointRampStatQuery2);       
   Process(LS.HeaterRangeQuery1);                     
   Process(LS.HeaterRangeQuery2);                     
   Process(LS.InputReadingStatusQueryA);              
   Process(LS.InputReadingStatusQueryB);              
   Process(LS.ControlSetpointQuery1);                 
   Process(LS.ControlSetpointQuery2);                 
   Process(LS.SensorUnitsInputReadingQuery);         
   Process(LS.ThermocoupleJunctionTempQuery); 
   Process(LS.TemperatureLimitQuery);                
   Process(LS.ControlTuningStatusQuery1);             
   Process(LS.ActiveTune1);             
   Process(LS.AtuneError1);             
   Process(LS.AtuneStage1);             
   Process(LS.AutoTune1);             
   Process(LS.ControlTuningStatusQuery2);     
   Process(LS.ActiveTune2); 
   Process(LS.AtuneError2); 
   Process(LS.AtuneStage2);    
   Process(LS.AutoTune2);    
   Process(LS.HeaterStart1);    
   Process(LS.HeaterStart2);    
   Process(LS.SetTDX1);    
   Process(LS.SetTDX2);    
   Process(LS.WarmupSupplyParameterQuery1);          
   Process(LS.WarmupControl1);          
   Process(LS.WarmupOutput1);          
   Process(LS.WarmupSupplyParameterQuery2);          
   Process(LS.WarmupControl2);          
   Process(LS.WarmupOutput2);          
   Process(LS.ManualRangeButtonA);          
   Process(LS.ManualRangeButtonB);          
   Process(LS.AutoRangeA);          
   Process(LS.AutoRangeB);          
   Process(LS.OutputZoneTableParameterQuery);        
   Process(LS.SERVID);        
   Process(LS.CLOCK);        
  end;
 end;
 
 {
 Initialize tags.
 }
 procedure LAKESHORE_FillTags(InitVal:Real);
 begin
  LS.POLL_ENABLE.val                            :=InitVal;
  LS.POLL_RATE.val                              :=InitVal;
  LS.ERROR_CNT.val                              :=InitVal;
  LS.ID_NAME.val                                :=InitVal;
  LS.ID_IDN.val                                 :=InitVal;
  LS.SERVID.val                                 :=InitVal;
  LS.CLOCK.val                                  :=InitVal;
  LS.IdentificationQuery.val                    :=InitVal;
  LS.MonitorOutParameterQuery.val               :=InitVal;
  LS.DiodeExcitationCurParrQuery.val            :=InitVal;
  LS.InputFilterParameterQuery.val              :=InitVal;
  LS.HeaterOutputQuery1.val                     :=InitVal;
  LS.HeaterOutputQuery2.val                     :=InitVal;
  LS.HeaterSetupQuery1.val                      :=InitVal;
  LS.HeatResist1.val                            :=InitVal;
  LS.MaxCurrent1.val                            :=InitVal;
  LS.HeaterSetupQuery2.val                      :=InitVal;
  LS.HeatResist2.val                            :=InitVal;
  LS.MaxCurrent2.val                            :=InitVal;
  LS.HeaterStatusQuery1.val                     :=InitVal;
  LS.HeaterStatusQuery2.val                     :=InitVal;
  LS.InputCurveNumberQueryA.val                 :=InitVal;
  LS.InputCurveNumberQueryB.val                 :=InitVal;
  LS.InputTypeParameterQueryA.val               :=InitVal;
  LS.EnableInputA.val                           :=InitVal;
  LS.InputTypeParameterQueryB.val               :=InitVal;
  LS.EnableInputB.val                           :=InitVal;
  LS.KelvinReadingQueryA.val                    :=InitVal;
  LS.KelvinReadingQueryB.val                    :=InitVal;
  LS.MinimumMaximumDataQuery.val                :=InitVal;
  LS.OutManualHeaterPowerOutQuery.val           :=InitVal;
  LS.OutputModeQuery1.val                       :=InitVal;
  LS.OutputMode1.val                            :=InitVal;
  LS.ControlInput1.val                          :=InitVal;
  LS.OutputModePowerup1.val                     :=InitVal;
  LS.OutputModeQuery2.val                       :=InitVal;
  LS.OutputMode2.val                            :=InitVal;
  LS.ControlInput1.val                          :=InitVal;
  LS.OutputModePowerup2.val                     :=InitVal;
  LS.OutVoltPolarityQuery.val                   :=InitVal;
  LS.ControlLoopPIDValuesQuery1.val             :=InitVal;
  LS.PIDparP1.val                               :=InitVal;
  LS.PIDparI1.val                               :=InitVal;
  LS.PIDparD1.val                               :=InitVal;
  LS.ControlLoopPIDValuesQuery2.val             :=InitVal;
  LS.PIDparP2.val                               :=InitVal;
  LS.PIDparI2.val                               :=InitVal;
  LS.PIDparD2.val                               :=InitVal;
  LS.SetRampPar1.val                            :=InitVal;
  LS.SetRamp1.val                               :=InitVal;
  LS.RampRate1.val                              :=InitVal;
  LS.SetRampPar2.val                            :=InitVal;
  LS.SetRamp2.val                               :=InitVal;
  LS.RampRate2.val                              :=InitVal;
  LS.ControlSetpointRampStatQuery1.val          :=InitVal;
  LS.ControlSetpointRampStatQuery2.val          :=InitVal;
  LS.HeaterRangeQuery1.val                      :=InitVal;
  LS.HeaterRangeQuery2.val                      :=InitVal;
  LS.InputReadingStatusQueryA.val               :=InitVal;
  LS.InputReadingStatusQueryB.val               :=InitVal;
  LS.ControlSetpointQuery1.val                  :=InitVal;
  LS.ControlSetpointQuery2.val                  :=InitVal;
  LS.SensorUnitsInputReadingQuery.val           :=InitVal;
  LS.ThermocoupleJunctionTempQuery.val          :=InitVal;
  LS.TemperatureLimitQuery.val                  :=InitVal;
  LS.ControlTuningStatusQuery1.val              :=InitVal;
  LS.ActiveTune1.val                            :=InitVal;
  LS.AtuneError1.val                            :=InitVal;
  LS.AtuneStage1.val                            :=InitVal;
  LS.AutoTune1.val                              :=InitVal;
  LS.WarmupSupplyParameterQuery1.val            :=InitVal;
  LS.ActiveTune2.val                            :=InitVal; 
  LS.AtuneError2.val                            :=InitVal; 
  LS.AtuneStage2.val                            :=InitVal; 
  LS.AutoTune2.val                              :=InitVal; 
  LS.HeaterStart1.val                           :=InitVal; 
  LS.HeaterStart2.val                           :=InitVal; 
  LS.SetTDX1.val                                :=InitVal; 
  LS.SetTDX2.val                                :=InitVal; 
  LS.WarmupControl1.val                         :=InitVal;
  LS.WarmupOutput1.val                          :=InitVal;
  LS.WarmupSupplyParameterQuery2.val            :=InitVal;
  LS.WarmupControl2.val                         :=InitVal;
  LS.WarmupOutput2.val                          :=InitVal;
  LS.ManualRangeButtonA.val                     :=InitVal;
  LS.ManualRangeButtonB.val                     :=InitVal;
  LS.AutoRangeA.val                             :=InitVal;
  LS.AutoRangeB.val                             :=InitVal;
  LS.OutputZoneTableParameterQuery.val          :=InitVal;
 end;
 procedure LAKESHORE_InitTags(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   DIM_GuiClickInit(Prefix+'.DIMGUICLICK');
   InitTag(LS.POLL_ENABLE.tag,                    Prefix+'.POLL_ENABLE',                          1); 
   InitTag(LS.POLL_RATE.tag,                      Prefix+'.POLL_RATE',                            2);
   InitTag(LS.ERROR_CNT.tag,                      Prefix+'.ERROR_CNT',                            2);
   InitTag(LS.ID_NAME.tag,                        Prefix+'.ID_NAME',                              3);
   InitTag(LS.ID_IDN.tag,                         Prefix+'.ID_IDN',                               3);
   InitTag(LS.SERVID.tag,                         Prefix+'.SERVID',                               3);
   InitTag(LS.CLOCK.tag,                          Prefix+'.CLOCK',                                3);
   InitTag(LS.IdentificationQuery.tag,            Prefix+'.IdentificationQuery'                  ,2);
   InitTag(LS.MonitorOutParameterQuery.tag,       Prefix+'.MonitorOutParameterQuery'             ,2);
   InitTag(LS.DiodeExcitationCurParrQuery.tag,    Prefix+'.DiodeExcitationCurParrQuery'          ,2);
   InitTag(LS.InputFilterParameterQuery.tag,      Prefix+'.InputFilterParameterQuery'            ,2);
   InitTag(LS.HeaterOutputQuery1.tag,             Prefix+'.HeaterOutputQuery1'                   ,2);
   InitTag(LS.HeaterOutputQuery2.tag,             Prefix+'.HeaterOutputQuery2'                   ,2);
   InitTag(LS.HeaterSetupQuery1.tag,              Prefix+'.HeaterSetupQuery1'                    ,3);
   InitTag(LS.HeatResist1.tag,                    Prefix+'.HeatResist1'                          ,1);
   InitTag(LS.MaxCurrent1.tag,                    Prefix+'.MaxCurrent1'                          ,1);
   InitTag(LS.HeaterSetupQuery2.tag,              Prefix+'.HeaterSetupQuery2'                    ,3);
   InitTag(LS.HeatResist2.tag,                    Prefix+'.HeatResist2'                          ,1);
   InitTag(LS.MaxCurrent2.tag,                    Prefix+'.MaxCurrent2'                          ,1);
   InitTag(LS.HeaterStatusQuery1.tag,             Prefix+'.HeaterStatusQuery1'                   ,1);
   InitTag(LS.HeaterStatusQuery2.tag,             Prefix+'.HeaterStatusQuery2'                   ,1);
   InitTag(LS.InputCurveNumberQueryA.tag,         Prefix+'.InputCurveNumberQueryA'               ,1);
   InitTag(LS.InputCurveNumberQueryB.tag,         Prefix+'.InputCurveNumberQueryB'               ,1);
   InitTag(LS.InputTypeParameterQueryA.tag,       Prefix+'.InputTypeParameterQueryA'             ,3);
   InitTag(LS.EnableInputA.tag,                   Prefix+'.EnableInputA'                         ,1);
   InitTag(LS.InputTypeParameterQueryB.tag,       Prefix+'.InputTypeParameterQueryB'             ,3);
   InitTag(LS.EnableInputB.tag,                   Prefix+'.EnableInputB'                         ,1);
   InitTag(LS.KelvinReadingQueryA.tag,            Prefix+'.KelvinReadingQueryA'                  ,2);
   InitTag(LS.KelvinReadingQueryB.tag,            Prefix+'.KelvinReadingQueryB'                  ,2);
   InitTag(LS.MinimumMaximumDataQuery.tag,        Prefix+'.MinimumMaximumDataQuery'              ,2);
   InitTag(LS.OutManualHeaterPowerOutQuery.tag,   Prefix+'.OutManualHeaterPowerOutQuery'         ,2);
   InitTag(LS.OutputModeQuery1.tag,               Prefix+'.OutputModeQuery1'                     ,3);
   InitTag(LS.OutputMode1.tag,                    Prefix+'.OutputMode1'                          ,1);
   InitTag(LS.ControlInput1.tag,                  Prefix+'.ControlInput1'                        ,1);
   InitTag(LS.OutputModePowerup1.tag,             Prefix+'.OutputModePowerup1'                   ,1);
   InitTag(LS.OutputModeQuery2.tag,               Prefix+'.OutputModeQuery2'                     ,3);
   InitTag(LS.OutputMode2.tag,                    Prefix+'.OutputMode2'                          ,1);
   InitTag(LS.ControlInput2.tag,                  Prefix+'.ControlInput2'                        ,1);
   InitTag(LS.OutputModePowerup2.tag,             Prefix+'.OutputModePowerup2'                   ,1);
   InitTag(LS.OutVoltPolarityQuery.tag,           Prefix+'.OutVoltPolarityQuery'                 ,2);
   InitTag(LS.ControlLoopPIDValuesQuery1.tag,     Prefix+'.ControlLoopPIDValuesQuery1'           ,3);
   InitTag(LS.PIDparP1.tag,                       Prefix+'.PIDparP1'                             ,2);
   InitTag(LS.PIDparI1.tag,                       Prefix+'.PIDparI1'                             ,2);
   InitTag(LS.PIDparD1.tag,                       Prefix+'.PIDparD1'                             ,2);
   InitTag(LS.ControlLoopPIDValuesQuery2.tag,     Prefix+'.ControlLoopPIDValuesQuery2'           ,3);
   InitTag(LS.PIDparP2.tag,                       Prefix+'.PIDparP2'                             ,2);
   InitTag(LS.PIDparI2.tag,                       Prefix+'.PIDparI2'                             ,2);
   InitTag(LS.PIDparD2.tag,                       Prefix+'.PIDparD2'                             ,2);
   InitTag(LS.SetRampPar1.tag,                    Prefix+'.SetRampPar1'                          ,3);
   InitTag(LS.SetRamp1.tag,                       Prefix+'.SetRamp1'                             ,1);
   InitTag(LS.RampRate1.tag,                      Prefix+'.RampRate1'                            ,2);
   InitTag(LS.SetRampPar2.tag,                    Prefix+'.SetRampPar2'                          ,3);
   InitTag(LS.SetRamp2.tag,                       Prefix+'.SetRamp2'                             ,1);
   InitTag(LS.RampRate2.tag,                      Prefix+'.RampRate2'                            ,2);
   InitTag(LS.ControlSetpointRampStatQuery1.tag,  Prefix+'.ControlSetpointRampStatQuery1'        ,1);
   InitTag(LS.ControlSetpointRampStatQuery2.tag,  Prefix+'.ControlSetpointRampStatQuery2'        ,1);
   InitTag(LS.HeaterRangeQuery1.tag,              Prefix+'.HeaterRangeQuery1'                    ,1);
   InitTag(LS.HeaterRangeQuery2.tag,              Prefix+'.HeaterRangeQuery2'                    ,1);
   InitTag(LS.InputReadingStatusQueryA.tag,       Prefix+'.InputReadingStatusQueryA'             ,1);
   InitTag(LS.InputReadingStatusQueryB.tag,       Prefix+'.InputReadingStatusQueryB'             ,1);
   InitTag(LS.ControlSetpointQuery1.tag,          Prefix+'.ControlSetpointQuery1'                ,2);
   InitTag(LS.ControlSetpointQuery2.tag,          Prefix+'.ControlSetpointQuery2'                ,2);
   InitTag(LS.SensorUnitsInputReadingQuery.tag,   Prefix+'.SensorUnitsInputReadingQuery'         ,2);
   InitTag(LS.ThermocoupleJunctionTempQuery.tag,  Prefix+'.ThermocoupleJunctionTempQuery'        ,2);
   InitTag(LS.TemperatureLimitQuery.tag,          Prefix+'.TemperatureLimitQuery'                ,2);
   InitTag(LS.ControlTuningStatusQuery1.tag,      Prefix+'.ControlTuningStatusQuery1'            ,3);
   InitTag(LS.ActiveTune1.tag,                    Prefix+'.ActiveTune1'                          ,1);
   InitTag(LS.AtuneError1.tag,                    Prefix+'.AtuneError1'                          ,1);
   InitTag(LS.AtuneStage1.tag,                    Prefix+'.AtuneStage1'                          ,2);
   InitTag(LS.AutoTune1.tag,                      Prefix+'.AutoTune1'                            ,1);
   InitTag(LS.ControlTuningStatusQuery2.tag,      Prefix+'.ControlTuningStatusQuery2'            ,3);
   InitTag(LS.ActiveTune2.tag,                    Prefix+'.ActiveTune2'                          ,1);
   InitTag(LS.AtuneError2.tag,                    Prefix+'.AtuneError2'                          ,1);
   InitTag(LS.AtuneStage2.tag,                    Prefix+'.AtuneStage2'                          ,2);
   InitTag(LS.AutoTune2.tag,                      Prefix+'.AutoTune2'                            ,1);
   InitTag(LS.HeaterStart1.tag,                   Prefix+'.HeaterStart1'                         ,1);
   InitTag(LS.HeaterStart2.tag,                   Prefix+'.HeaterStart2'                         ,1);
   InitTag(LS.SetTDX1.tag,                        Prefix+'.SetTDX1'                              ,1);
   InitTag(LS.SetTDX2.tag,                        Prefix+'.SetTDX2'                              ,1);
   InitTag(LS.WarmupSupplyParameterQuery1.tag,    Prefix+'.WarmupSupplyParameterQuery1'          ,1);
   InitTag(LS.WarmupControl1.tag,                 Prefix+'.WarmupControl1'                       ,1);
   InitTag(LS.WarmupOutput1.tag,                  Prefix+'.WarmupOutput1'                        ,1);
   InitTag(LS.WarmupSupplyParameterQuery2.tag,    Prefix+'.WarmupSupplyParameterQuery2'          ,1);
   InitTag(LS.WarmupControl2.tag,                 Prefix+'.WarmupControl2'                       ,1);
   InitTag(LS.WarmupOutput2.tag,                  Prefix+'.WarmupOutput2'                        ,1);
   InitTag(LS.ManualRangeButtonA.tag,             Prefix+'.ManualRangeButtonA'                   ,1);
   InitTag(LS.ManualRangeButtonB.tag,             Prefix+'.ManualRangeButtonB'                   ,1);
   InitTag(LS.AutoRangeA.tag,                     Prefix+'.AutoRangeA'                           ,1);
   InitTag(LS.AutoRangeB.tag,                     Prefix+'.AutoRangeB'                           ,1);
   InitTag(LS.OutputZoneTableParameterQuery.tag,  Prefix+'.OutputZoneTableParameterQuery'        ,2);
   LAKESHORE_FillTags(-MaxReal);
   
   {
   Server Identifier.
   }
   if DIM_IsServerMode
   then LS.SelfId:=Str(getpid)+'@'+ParamStr('HostName')
   else LS.SelfId:=Str(getpid)+'@'+ParamStr('ComputerName');
   {
   Colors
   }
   ColorNorm:=StringToColor('Aqua');
   if DIM_IsServerMode then ColorNorm:=StringToColor('Lime');
   if DIM_IsClientMode then ColorNorm:=StringToColor('Lime');
   ColorWarn:=StringToColor('Yellow');
   bNul(SetTagColor(LS.SERVID.tag,ColorNorm));
   bNul(SetTagColor(LS.CLOCK.tag,ColorNorm));
   end;
 end;
 
 {
 Update DIM tag in server mode.
 }
 procedure UpdateDimTag(tag:Integer);
 var v:Real;
 begin
  if DIM_IsServerMode then
  if (TypeTag(tag)>0) then begin
   v:=GetStampOfTag(tag,_NaN);
   if not IsNan(v) then LAKESHORE_FillTag(tag,v);
   DIM_UpdateTag(tag,'');
  end;
 end;
 
 {
 Check if COM port opened.
 }
 function IsComPortOpened:Boolean;
 begin
  IsComPortOpened:=(ComSpace>=0);
 end;
 
 {
 Check command number is valid. 
 }
 function IsValidCmdNum(n:Integer):Boolean;
 begin
  IsValidCmdNum:=(n>=1) and (n<=MaxCmdNum);
 end;
 
 {
 Check if command (n) is query.
 }
 function IsQueryCmdNum(n:Integer):Boolean;
 begin
  if IsValidCmdNum(n)
  then
  begin 
   IsQueryCmdNum:=true
  end else IsQueryCmdNum:=false;
 end;
 
 {
 Enable/disable command n.
 }
 procedure EnableCmdNum(n:Integer; Enabled:Boolean);
 begin
  if IsValidCmdNum(n) then LS.Cmd.Enabled[n]:=Enabled;
 end;
 
 {
 Check if LAKESHORE polling enabled, with warning or not.
 }
 function LAKESHORE_CheckPolling(Warn:Integer):Boolean;
 var flag:Boolean; msg:String;
 begin
  msg:='';
  flag:=iGetTag(LS.POLL_ENABLE.tag)>0;
  if (Warn<>0) and not flag then begin
   msg:=StrFmt('Для изменения параметров %s надо включить Опрос.',sGetTag(LS.ID_NAME.tag));
   if iAnd(Warn,1)>0 then NiceNotify(msg,30);
   if iAnd(Warn,2)>0 then UnixWBox('Предупреждение',msg,600,20,15);
   if iAnd(Warn,4)>0 then Cron('@run /sw7 unix messagebox "Предупреждение" "'+msg+'" -t 15');
   if iAnd(Warn,8)>0 then Warning(msg);
  end;
  LAKESHORE_CheckPolling:=flag;
  msg:='';
 end;
 
 {
 Clear commands.
 }
 procedure LAKESHORE_Clear_Cmd;
 var i:Integer;
 begin
  for i:=1 to MaxCmdNum do begin
   LS.Cmd.Acronym[i]:='';
   LS.Cmd.Comment[i]:='';
   LS.Cmd.Enabled[i]:=False;
   LS.Cmd.Channel[i]:='';
   LS.Cmd.OpData[i] :=_NAN;
   LS.Cmd.OpBuff[i] :=_NAN;
   LS.Cmd.Arg[i]    :='';
   LS.Cmd.SimDat[i] :='';
   LS.Cmd.SimStr[i] :='';
   LS.Cmd.AoNum[i]  :=-1;
   LS.Cmd.Tag[i]    :=0;
  end;
 end;
 
 {
 Initialize commands.
 }
 procedure LAKESHORE_Init_Cmd;
 var delims:string;
  procedure AddHash(n:Integer; key:String);
  begin
   key:=Trim(key);
   if Length(key)>0 then
   if IsValidCmdNum(n) then
   if LS.CmdHash<>0 then
   bNul(HashList_SetLink(LS.CmdHash,key,n));
  end;
  procedure Add(n,AoNum:Integer; Info:String);
  var d:string;
  begin
   if IsValidCmdNum(n) then begin
   LS.Cmd.Acronym[n]:=ExtractWord(1,Info);
    if ExtractWord(2,Info) <> '0' then
    LS.Cmd.Acronym[n]:=ExtractWord(1,Info)+' '+ExtractWord(2,Info);
    LS.Cmd.Comment[n]:=ExtractWord(3,Info);
    LS.Cmd.Enabled[n]:=Val(ExtractWord(4,Info))>0;
    LS.Cmd.Channel[n]:='';
    if ExtractWord(2,Info) <> '0' then LS.Cmd.Channel[n]:=ExtractWord(2,Info);
    LS.Cmd.OpData[n]:=rVal(ExtractWord(5,Info));
    LS.Cmd.SimDat[n]:=ExtractWord(6,Info);
    LS.Cmd.Tag[n]:=FindTag(CrvName(RefAo(AoNum)));
    LS.Cmd.AoNum[n]:=AoNum;
    AddHash(n,LS.Cmd.Acronym[n]);
   end;
  end;
 begin
  delims:=worddelims(' ');
  LS.Cmd.Num:=1;
  // Command                             AoNum                               Acronym    Ch Comment                        En OpData SimDat      
    Add(cm_IdentificationQuery,            99,                               '*IDN?     0  IdentificationQuery            1  0      LSCI,MODEL335S,1234567/1234567,1.0');
    Add(cm_MonitorOutParameterCmd,         -1,                               'ANALOG    0  MonitorOutParameterCmd         0  0      0');
  { Add(cm_MonitorOutParameterQuery,       ao_MonitorOutParameterQuery,      'ANALOG?   0  MonitorOutParameterQuery       1  0      2,3,+0.0000,+0.0000,0'); }
    Add(cm_AutotuneCmd,                    -1,                               'ATUNE     0  AutotuneCmd                    0  0      0');
  { Add(cm_DiodeExcitationCurParCmd,       -1,                               'DIOCUR    0  DiodeExcitationCurParCmd       0  0      0'); }
  { Add(cm_DiodeExcitationCurParrQuery,    ao_DiodeExcitationCurParrQuery,   'DIOCUR?   0  DiodeExcitationCurParrQuery    1  0      0'); }
  { Add(cm_InputFilterParameterCmd,        -1,                               'FILTER    0  InputFilterParameterCmd        0  0      0'); }
  { Add(cm_InputFilterParameterQuery,      ao_InputFilterParameterQuery,     'FILTER?   0  InputFilterParameterQuery      1  0      0'); }
    Add(cm_HeaterOutputQuery1,             ao_HeaterOutputQuery1,            'HTR?      1  HeaterOutputQuery              1  0      10');
    Add(cm_HeaterOutputQuery2,             ao_HeaterOutputQuery2,            'HTR?      2  HeaterOutputQuery              1  0      20');
    Add(cm_HeaterSetupCmd,                 -1,                               'HTRSET    0  HeaterSetupCmd                 0  0      0');
    Add(cm_HeaterSetupQuery1,              ao_HeaterSetupQuery1,             'HTRSET?   1  HeaterSetupQuery               1  0      0,1,3,+0.100,1');
    Add(cm_HeaterSetupQuery2,              ao_HeaterSetupQuery2,             'HTRSET?   2  HeaterSetupQuery               1  0      0,2,1,+0.100,1');
    Add(cm_HeaterStatusQuery1,             ao_HeaterStatusQuery1,            'HTRST?    1  HeaterStatusQuery              1  0      +0');
    Add(cm_HeaterStatusQuery2,             ao_HeaterStatusQuery2,            'HTRST?    2  HeaterStatusQuery              1  0      +0');
    Add(cm_InputCurveNumberCmd,            -1,                               'INCRV     0  InputCurveNumberCmd            1  0      0');
    Add(cm_InputCurveNumberQueryA,         ao_InputCurveNumberQueryA,        'INCRV?    A  InputCurveNumberQuery          1  0      02');
    Add(cm_InputCurveNumberQueryB,         ao_InputCurveNumberQueryB,        'INCRV?    B  InputCurveNumberQuery          1  0      +0');
    Add(cm_InputTypeParameterCmd,          -1,                               'INTYPE    0  InputTypeParameterCmd          0  0      0');
    Add(cm_InputTypeParameterQueryA,       ao_InputTypeParameterQueryA,      'INTYPE?   A  InputTypeParameterQuery        1  0      1,0,0,0,1');
    Add(cm_InputTypeParameterQueryB,       ao_InputTypeParameterQueryB,      'INTYPE?   B  InputTypeParameterQuery        1  0      2,1,6,0,1');
    Add(cm_KelvinReadingQueryA,            ao_KelvinReadingQueryA,           'KRDG?     A  KelvinReadingQueryA            1  0      99');
    Add(cm_KelvinReadingQueryB,            ao_KelvinReadingQueryB,           'KRDG?     B  KelvinReadingQueryB            1  0      98');
  { Add(cm_MinimumMaximumDataQuery,        ao_MinimumMaximumDataQuery,       'MDAT?     0  MinimumMaximumDataQuery        1  0      +00.000,+294.47'); }
    Add(cm_ManualOutputCmd,                -1,                               'MOUT      0  ManualOutputCmd                0  0      0');
  { Add(cm_OutManualHeaterPowerOutQuery,   ao_OutManualHeaterPowerOutQuery,  'MOUT?     0  OutManualHeaterPowerOutQuery   1  0      +034.00'); }
    Add(cm_OutputModeCommand,              -1,                               'OUTMODE   0  OutputModeCommand              0  0      0');
    Add(cm_OutputModeQuery1,               ao_OutputModeQuery1,              'OUTMODE?  1  OutputModeQuery                1  0      1,1,1');
    Add(cm_OutputModeQuery2,               ao_OutputModeQuery2,              'OUTMODE?  2  OutputModeQuery                1  0      2,2,0');
    Add(cm_OutVoltPolarityCommand,         -1,                               'POLARITY  0  OutVoltPolarityCommand         0  0      0');
    Add(cm_OutVoltPolarityQuery,           ao_OutVoltPolarityQuery,          'POLARITY? 0  OutVoltPolarityQuery           1  0      +0');
    Add(cm_ControlLoopPIDValuesCmd,        -1,                               'PID       0  ControlLoopPIDValuesCmd        0  0      0');
    Add(cm_ControlLoopPIDValuesQuery1,     ao_ControlLoopPIDValuesQuery1,    'PID?      1  ControlLoopPIDValuesQuery      1  0      +0001.0,+0000.0,+000.0');
    Add(cm_ControlLoopPIDValuesQuery2,     ao_ControlLoopPIDValuesQuery2,    'PID?      2  ControlLoopPIDValuesQuery      1  0      +0032.1,+0010.0,+004.0');
    Add(cm_ControlSetpointRampParCmd,      -1,                               'RAMP      0  ControlSetpointRampParCmd      0  0      0');
    Add(cm_SetRampPar1,                    ao_SetRampPar1,                   'RAMP?     1  ControlSetpointRampParQuery    1  0      1,+100.0');
    Add(cm_SetRampPar2,                    ao_SetRampPar2,                   'RAMP?     2  ControlSetpointRampParQuery    1  0      1,+2.000');
    Add(cm_ControlSetpointRampStatQuery1,  ao_ControlSetpointRampStatQuery1, 'RAMPST?   1  ControlSetpointRampStatQuery   1  0      +0');
    Add(cm_ControlSetpointRampStatQuery2,  ao_ControlSetpointRampStatQuery2, 'RAMPST?   2  ControlSetpointRampStatQuery   1  0      +0');
    Add(cm_HeaterRangeCmd,                 -1,                               'RANGE     0  HeaterRangeCmd                 0  0      0');
    Add(cm_HeaterRangeQuery1,              ao_HeaterRangeQuery1,             'RANGE?    1  HeaterRangeQuery               1  0      +1');
    Add(cm_HeaterRangeQuery2,              ao_HeaterRangeQuery2,             'RANGE?    2  HeaterRangeQuery               1  0      +0');
    Add(cm_InputReadingStatusQueryA,       ao_InputReadingStatusQueryA,      'RDGST?    A  InputReadingStatusQuery        1  0      +000');
    Add(cm_InputReadingStatusQueryB,       ao_InputReadingStatusQueryB,      'RDGST?    B  InputReadingStatusQuery        1  0      +000');
    Add(cm_ControlSetpointCmd,             -1,                               'SETP      0  ControlSetpointCmd             0  0      0');
    Add(cm_ControlSetpointQuery1,          ao_ControlSetpointQuery1,         'SETP?     1  ControlSetpointQuery           1  0      +300.00');
    Add(cm_ControlSetpointQuery2,          ao_ControlSetpointQuery2,         'SETP?     2  ControlSetpointQuery           1  0      +00.000');
  { Add(cm_SensorUnitsInputReadingQuery,   ao_SensorUnitsInputReadingQuery,  'SRDG?     0  SensorUnitsInputReadingQuery   1  0      +0.5748'); }
  { Add(cm_ThermocoupleJunctionTempQuery,  ao_ThermocoupleJunctionTempQuery, 'TEMP?     0  ThermocoupleJunctionTempQuery  1  0      +00.000'); }
  { Add(cm_TemperatureLimitCmd,            -1,                               'TLIMIT    0  TemperatureLimitCmd            0  0      0'); }
    Add(cm_TemperatureLimitQuery,          ao_TemperatureLimitQuery,         'TLIMIT?   0  TemperatureLimitQuery          1  0      +0000');
    Add(cm_ControlTuningStatusQuery1,      ao_ControlTuningStatusQuery1,     'TUNEST?   1  ControlTuningStatusQuery       1  0      0,1,0,03');
    Add(cm_ControlTuningStatusQuery2,      ao_ControlTuningStatusQuery2,     'TUNEST?   2  ControlTuningStatusQuery       1  0      0,1,0,03');
  { Add(cm_WarmupSupplyParameterCmd,       -1,                               'WARMUP    0  WarmupSupplyParameterCmd       0  0      0'); }
  { Add(cm_WarmupSupplyParameterQuery1,    ao_WarmupSupplyParameterQuery1,   'WARMUP?   1  WarmupSupplyParameterQuery     1  0      0'); }
  { Add(cm_WarmupSupplyParameterQuery2,    ao_WarmupSupplyParameterQuery2,   'WARMUP?   2  WarmupSupplyParameterQuery     1  0      0'); }
  { Add(cm_ControlLoopZoneTableParamCmd,   -1,                               'ZONE      0  ControlLoopZoneTableParamCmd   0  0      0'); }
  { Add(cm_OutputZoneTableParameterQuery,  ao_OutputZoneTableParameterQuery, 'ZONE?     0  OutputZoneTableParameterQuery  1  0      0'); }
  delims:=worddelims(delims);
 end;
 
 {
 Print command table
 }
 procedure PrintCmdTable;
 var n:Integer;
 begin
  Success('Command table:');
  Success(StrFmt('%-2s ','Cm')
         +StrFmt('%-2s ','Ao')
         +StrFmt('%-12s ','Acro')
         +StrFmt('%-30s ','Comment')
         +StrFmt('%-2s ','En')
         +StrFmt('%1s ','Channel')
         );
  for n:=1 to MaxCmdNum do
  Success(StrFmt('%-2d ',n)
         +StrFmt('%-2d ',LS.Cmd.AoNum[n])
         +StrFmt('%-12s ',LS.Cmd.Acronym[n])
         +StrFmt('%-30s ',LS.Cmd.Comment[n])
         +StrFmt('%-2d ',Ord(LS.Cmd.Enabled[n]))
         +StrFmt('%1s ',LS.Cmd.Channel[n])
         );
 end;
 
 {
 Update ranges/formats by ModelCode.
 }
 function LAKESHORE_UpdateModel(ModelCode:Integer):Integer;
 begin
  ModelCode:=CheckModelCode(ModelCode);
  if ModelCode>0 then begin
  end;
  LAKESHORE_UpdateModel:=ModelCode;
 end;
 
 {
 Main command cycle.
 }
 procedure LAKESHORE_CMD_CYCLE;
  function ValidateCmdNum(Num:Integer):Integer;
  begin
   if IsValidCmdNum(Num)
   then ValidateCmdNum:=Num
   else ValidateCmdNum:=1;
  end;
  function NextCmdNum(Num:Integer):Integer;
  var i:Integer;
  begin
   i:=0;
   while (i<MaxCmdNum) do begin
    Num:=ValidateCmdNum(Num+1);
    if LS.Cmd.Enabled[Num]
    then i:=MaxCmdNum
    else i:=i+1;
   end; 
   NextCmdNum:=Num;
  end;
  procedure ClearRequest(Num,Status:Integer);
  begin
   LS.Com.Req:='';
   LS.Com.Ans:='';
   LS.Com.Buf:='';
   LS.Com.ReqTime:=0;
   LS.Com.AnsTime:=0;
   LS.Com.Status:=Status;
   LS.Cmd.Num:=ValidateCmdNum(Num);
  end;
  function ReqCmd(n:Integer):String;
  var s:String;
  begin
   s:='';
   if IsValidCmdNum(n) then begin
    if (LS.Cmd.OpData[n] = _NAN) then
    begin
     s:=LS.Cmd.Acronym[n];
     if (LS.Cmd.Arg[n] <> '') then
      s:=LS.Cmd.Acronym[n]+' '+LS.Cmd.Arg[n];
    end else begin
      s:=LS.Cmd.Acronym[n]
    end;
    if (Length(s)>0) then s:=s+CRLF;
   end;
   ReqCmd:=s;
   s:='';
  end;
  procedure PrepareRequest(n:Integer);
  begin
   if IsValidCmdNum(n) then begin
    LS.Com.Req:=ReqCmd(n);
   end;
  end;
  procedure UpdateIDN(data:String);
  var v:Real;
  begin
   if not IsEmptyStr(data) then begin
    LS.ModelCode:=LAKESHORE_UpdateModel(LAKESHORE_ParseIDN(data,iGetTag(LS.POLL_ENABLE.tag)=0));
    if (LAKESHORE_ModelCode=0) then data:=si_OFFLINE;
    if IsEmptyStr(data) then data:=si_OFFLINE;
    bNul(sSetTag(LS.ID_IDN.tag,data));
    if ShouldRefresh(LS.ID_IDN.val,GetStampOfTag(LS.ID_IDN.tag,_NaN))>0
    then UpdateDimTag(LS.ID_IDN.tag);
   end;
  end;
  procedure UpdateCmdValue(n:Integer; value:Real);
  var aonum,tag:Integer;
  begin
   if IsValidCmdNum(n) and not IsNan(value) and not IsInf(value) then begin
    tag:=LS.Cmd.Tag[n]; aonum:=LS.Cmd.AoNum[n];
    if TypeTag(tag)=1 then begin
     bNul(iSetTag(tag,round(value)));
     UpdateDimTag(tag);
    end;
    if TypeTag(tag)=2 then begin
     bNul(rSetTag(tag,value));
     UpdateDimTag(tag);
    end;
    if aonum>=0 then UpdateAo(aonum,time,value);
    LS.Cmd.OpData[n]:=value;
   end;
  end;  
  procedure DecodeData(n:Integer; data:String);
  var ans,st:String; v:Real; i,TDX:Integer; d:string;
  begin
   ans:='';
   if IsValidCmdNum(n) then begin
    if Length(data)>0 then begin
     if (n=cm_IdentificationQuery) then begin
      ans:=data;
      EnableCmdNum(n,false);
      UpdateIDN(ExtractWord(2,ans));
     end;     
     if (n=cm_KelvinReadingQueryA) then begin
      ans:=data;
      UpdateCmdValue(n,rVal(ExtractWord(1,ans)));
     end; 
     if (n=cm_KelvinReadingQueryB) then begin
      ans:=data;
      UpdateCmdValue(n,rVal(ExtractWord(1,ans)));
     end;
     if (n=cm_ControlSetpointQuery1) then begin
      ans:=data;
      UpdateCmdValue(n,rVal(ExtractWord(1,ans)));;
     end; 
     if (n=cm_ControlSetpointQuery2) then begin
      ans:=data;
      UpdateCmdValue(n,rVal(ExtractWord(1,ans)));
     end;
     if (n=cm_HeaterOutputQuery1) then begin
      ans:=data;
      UpdateCmdValue(n,rVal(ExtractWord(1,ans)));
     end;
     if (n=cm_HeaterOutputQuery2) then begin
      ans:=data;
      UpdateCmdValue(n,rVal(ExtractWord(1,ans)));
     end;
     if (n=cm_HeaterStatusQuery1) then begin
      ans:=data;
      if Val(ans) = 1 then ShowTooltip('text "Heater 1: heater open load"  preset stdWarning delay 15000'); 
      if Val(ans) = 2 then ShowTooltip('text "Heater 2: heater short"  preset stdWarning delay 15000');
      UpdateCmdValue(n,Val(ans));
     end;
     if (n=cm_HeaterStatusQuery2) then begin
      ans:=data;
      if Val(ans) = 1 then ShowTooltip('text "Heater 1: heater open load"  preset stdWarning delay 15000'); 
      if Val(ans) = 2 then ShowTooltip('text "Heater 2: heater short"  preset stdWarning delay 15000');
      UpdateCmdValue(n,Val(ans));
     end;    
     if (n=cm_InputCurveNumberQueryA) then begin
      ans:=data;
      UpdateCmdValue(n,Val(ExtractWord(1,ans)));
     end;   
     if (n=cm_InputCurveNumberQueryB) then begin
      ans:=data;
      UpdateCmdValue(n,Val(ExtractWord(1,ans)));
     end;
     if (n=cm_InputReadingStatusQueryA) then begin
      ans:=data;
      UpdateCmdValue(n,Val(ExtractWord(1,ans)));
     end;
     if (n=cm_InputReadingStatusQueryB) then begin
      ans:=data;
      UpdateCmdValue(n,Val(ExtractWord(1,ans)));
     end;     
     if (n=cm_HeaterRangeQuery1) then begin
      ans:=data;
      bNul(iSetTag(LS.HeaterStart1.tag,Val(ans)));
      UpdateDimTag(LS.HeaterStart1.tag);
      UpdateCmdValue(n,Val(ExtractWord(1,ans)));
     end;    
     if (n=cm_HeaterRangeQuery2) then begin
      ans:=data;
      bNul(iSetTag(LS.HeaterStart2.tag,Val(ans)));
      UpdateDimTag(LS.HeaterStart2.tag);
      UpdateCmdValue(n,Val(ExtractWord(1,ans)));
     end;
     if (n=cm_InputTypeParameterQueryA) then begin
      ans:=data;
      bNul(iSetTag(LS.EnableInputA.tag,Val(ExtractWord(1,ans))));
      bNul(iSetTag(LS.AutoRangeA.tag,Val(ExtractWord(2,ans))));
      bNul(iSetTag(LS.ManualRangeButtonA.tag,Val(ExtractWord(3,ans))));
      UpdateDimTag(LS.EnableInputA.tag);
      UpdateDimTag(LS.AutoRangeA.tag);
      UpdateDimTag(LS.ManualRangeButtonA.tag);
     end;
     if (n=cm_InputTypeParameterQueryB) then begin
      ans:=data;
      bNul(iSetTag(LS.EnableInputB.tag,Val(ExtractWord(1,ans))));
      bNul(iSetTag(LS.AutoRangeB.tag,Val(ExtractWord(1,ans))));
      bNul(iSetTag(LS.ManualRangeButtonB.tag,Val(ExtractWord(3,ans))));
      UpdateDimTag(LS.EnableInputB.tag);
      UpdateDimTag(LS.AutoRangeB.tag);
      UpdateDimTag(LS.ManualRangeButtonB.tag);
     end;
     if (n=cm_ControlLoopPIDValuesQuery1) then begin
      ans:=data;
      bNul(rSetTag(LS.PIDparP1.tag,rVal(ExtractWord(1,ans))));
      UpdateDimTag(LS.PIDparP1.tag);
      bNul(rSetTag(LS.PIDparI1.tag,rVal(ExtractWord(2,ans))));
      UpdateDimTag(LS.PIDparI1.tag);
      bNul(rSetTag(LS.PIDparD1.tag,rVal(ExtractWord(3,ans))));
      UpdateDimTag(LS.PIDparD1.tag);
     end;
     if (n=cm_ControlLoopPIDValuesQuery2) then begin
      ans:=data;
      bNul(rSetTag(LS.PIDparP2.tag,rVal(ExtractWord(1,ans))));
      UpdateDimTag(LS.PIDparP2.tag);
      bNul(rSetTag(LS.PIDparI2.tag,rVal(ExtractWord(2,ans))));
      UpdateDimTag(LS.PIDparI2.tag);
      bNul(rSetTag(LS.PIDparD2.tag,rVal(ExtractWord(3,ans))));
      UpdateDimTag(LS.PIDparD2.tag);
     end;    
     if (n=cm_WarmupSupplyParameterQuery1) then begin
      ans:=data;
      bNul(iSetTag(LS.WarmupControl1.tag,Val(ExtractWord(1,ans))));
      UpdateDimTag(LS.WarmupControl1.tag);
      bNul(iSetTag(LS.WarmupOutput1.tag,round(rVal(ExtractWord(2,ans)))));
      UpdateDimTag(LS.WarmupOutput1.tag);
     end; 
     if (n=cm_WarmupSupplyParameterQuery2) then begin
      ans:=data;
      bNul(iSetTag(LS.WarmupControl2.tag,Val(ExtractWord(1,ans))));
      UpdateDimTag(LS.WarmupControl2.tag);
      bNul(iSetTag(LS.WarmupOutput2.tag,round(rVal(ExtractWord(2,ans)))));
      UpdateDimTag(LS.WarmupOutput2.tag);
     end;     
     if (n=cm_OutputModeQuery1) then begin
      ans:=data;
      if (Val(ExtractWord(2,ans))=1) then TDX:=0 else TDX:=1;
      bNul(iSetTag(LS.OutputMode1.tag,Val(ExtractWord(1,ans))));
      UpdateDimTag(LS.OutputMode1.tag);      
      bNul(iSetTag(LS.ControlInput1.tag,Val(ExtractWord(2,ans))));
      UpdateDimTag(LS.ControlInput1.tag);
      bNul(iSetTag(LS.OutputModePowerup1.tag,Val(ExtractWord(3,ans))));
      UpdateDimTag(LS.OutputModePowerup1.tag);
      bNul(iSetTag(LS.SetTDX1.tag,TDX));
      UpdateDimTag(LS.SetTDX1.tag);
     end;     
     if (n=cm_OutputModeQuery2) then begin
      ans:=data;
      if (Val(ExtractWord(2,ans))=1) then TDX:=0 else TDX:=1;
      bNul(iSetTag(LS.OutputMode2.tag,Val(ExtractWord(1,ans))));
      UpdateDimTag(LS.OutputMode2.tag);
      bNul(iSetTag(LS.ControlInput2.tag,Val(ExtractWord(2,ans))));
      UpdateDimTag(LS.ControlInput2.tag);
      bNul(iSetTag(LS.OutputModePowerup2.tag,Val(ExtractWord(3,ans))));
      UpdateDimTag(LS.OutputModePowerup2.tag);
      bNul(iSetTag(LS.SetTDX2.tag,TDX));
      UpdateDimTag(LS.SetTDX2.tag);
     end;     
     if (n=cm_HeaterSetupQuery1) then begin
      ans:=data;
      bNul(iSetTag(LS.HeatResist1.tag,Val(ExtractWord(2,ans))));
      UpdateDimTag(LS.HeatResist1.tag);
      bNul(iSetTag(LS.MaxCurrent1.tag,Val(ExtractWord(3,ans))));
      UpdateDimTag(LS.MaxCurrent1.tag);
     end;     
     if (n=cm_HeaterSetupQuery2) then begin
      ans:=data;
      bNul(iSetTag(LS.HeatResist2.tag,Val(ExtractWord(2,ans))));
      UpdateDimTag(LS.HeatResist2.tag);
      bNul(iSetTag(LS.MaxCurrent2.tag,Val(ExtractWord(3,ans))));
      UpdateDimTag(LS.MaxCurrent2.tag);
     end;
     if (n=cm_SetRampPar1) then begin
      ans:=data;
      bNul(iSetTag(LS.SetRamp1.tag,Val(ExtractWord(1,ans))));
      UpdateDimTag(LS.SetRamp1.tag);
      bNul(rSetTag(LS.RampRate1.tag,rVal(ExtractWord(2,ans))));
      UpdateDimTag(LS.RampRate1.tag);
     end;     
     if (n=cm_SetRampPar2) then begin
      ans:=data;
      bNul(iSetTag(LS.SetRamp2.tag,Val(ExtractWord(1,ans))));
      UpdateDimTag(LS.SetRamp2.tag);
      bNul(rSetTag(LS.RampRate2.tag,rVal(ExtractWord(2,ans))));
      UpdateDimTag(LS.RampRate2.tag);
     end;     
     if (n=cm_ControlSetpointRampStatQuery1) then begin
      ans:=data;
      bNul(iSetTag(LS.ControlSetpointRampStatQuery1.tag,Val(ExtractWord(1,ans))));
      UpdateDimTag(LS.ControlSetpointRampStatQuery1.tag);
     end;   
     if (n=cm_ControlSetpointRampStatQuery2) then begin
      ans:=data;
      bNul(iSetTag(LS.ControlSetpointRampStatQuery2.tag,Val(ExtractWord(1,ans))));
      UpdateDimTag(LS.ControlSetpointRampStatQuery2.tag);
     end;   
     if (n=cm_ControlTuningStatusQuery1) then begin
      ans:=data;
      bNul(iSetTag(LS.ActiveTune1.tag,Val(ExtractWord(1,ans))));
      UpdateDimTag(LS.ActiveTune1.tag);
      if Val(ExtractWord(3,ans))=1 then  ShowTooltip('text "AutoTune Error"  preset stdWarning delay 15000');
      bNul(iSetTag(LS.AtuneError1.tag,Val(ExtractWord(3,ans))));
      UpdateDimTag(LS.AtuneError1.tag);    
      bNul(rSetTag(LS.AtuneStage1.tag,rVal(ExtractWord(4,ans))));
      UpdateDimTag(LS.AtuneStage1.tag);
     end;     
     if (n=cm_ControlTuningStatusQuery2) then begin
      ans:=data;
      bNul(iSetTag(LS.ActiveTune2.tag,Val(ExtractWord(1,ans))));
      UpdateDimTag(LS.ActiveTune2.tag);
      if Val(ExtractWord(3,ans))=1 then  ShowTooltip('text "AutoTune Error"  preset stdWarning delay 15000');
      bNul(iSetTag(LS.AtuneError2.tag,Val(ExtractWord(3,ans))));
      UpdateDimTag(LS.AtuneError2.tag);    
      bNul(rSetTag(LS.AtuneStage2.tag,rVal(ExtractWord(4,ans))));
      UpdateDimTag(LS.AtuneStage2.tag);
     end;
    end;
   ans:='';end;
  end;
  function HandleRequest(n:Integer; Ans:String):Boolean;
  var Handled:Boolean;
  begin
   Handled:=false;
   if IsValidCmdNum(n) and (Length(Ans)>0) then begin
    ViewImp('COM < '+Ans);
    DecodeData(n,Ans);
    Handled:=True;
   end;
   HandleRequest:=Handled;
  end;
  procedure PrintDetails;
  begin
   if iAnd(DebugFlags,dfDetails)>0 then Details('Run '+Str(RunCount)
    +', Cmd '+LS.Cmd.Acronym[LS.Cmd.Num]
    +', Enb '+Str(Ord(LS.Cmd.Enabled[LS.Cmd.Num]))
    +', Sta '+Str(LS.Com.Status)
    +', Req '+Trim(LS.Com.Req)
    +', Ans '+Trim(LS.Com.Ans)
    +', Buf '+Trim(LS.Com.Buf)
    );
  end;
  procedure UpdateOpData;
  var n:Integer;
  begin
   for n:=1 to MaxCmdNum do
   if not IsNan(LS.Cmd.OpBuff[n]) then begin
    if not IsQueryCmdNum(n) then begin
     LS.Cmd.OpData[n]:=LS.Cmd.OpBuff[n];
     EnableCmdNum(n,true);
    end;
    LS.Cmd.OpBuff[n]:=_NAN;
   end;
  end;
  procedure EnableIDN;
  begin
   //EnableCmdNum(cm_ARS,true);
  end;
  procedure ExecuteIdleActions;
  begin
   UpdateOpData;
   if (LAKESHORE_ModelCode=0) then EnableIDN;
  end;
  procedure DimRefreshTag(var R:TTagRef);
  var tag:Integer; v:Real;
  begin
   tag:=R.tag; v:=GetStampOfTag(tag,_NaN);
   if not IsNaN(v) then if ShouldRefresh(R.val,v)>0 then UpdateDimTag(tag);
  end;
 begin
  {
  COM port communication handler
  }
  if not DIM_IsClientMode then begin
   if IsComPortOpened then begin
    if iGetTag(LS.POLL_ENABLE.tag)>0 then begin
     LS.Cmd.Num:=ValidateCmdNum(LS.Cmd.Num);
     if iAnd(DebugFlags,dfDetails)>0 then PrintDetails;
     if LS.Com.Status=st_NoReq then begin
      ExecuteIdleActions;
      ClearRequest(LS.Cmd.Num,st_NoReq);
      if mSecNow>=LS.Com.LastPoll+LS.Com.PollPeriod then begin
       if LS.Cmd.Enabled[LS.Cmd.Num] then PrepareRequest(LS.Cmd.Num);
       if Length(LS.Com.Req)>0 then begin
        PurgeComPort;
        if ComWrite(LS.Com.Req) then begin
         ViewExp('COM > '+LS.Com.Req);
         LS.Com.Status:=st_WaitAns;
         LS.Com.ReqTime:=mSecNow;
        end else begin
         Trouble('Could not send request '+LS.Com.Req);
         ClearRequest(NextCmdNum(LS.Cmd.Num),st_NoReq);
        end;
        if LS.Com.Status=st_WaitAns
        then LS.Com.LastPoll:=mSecNow;
       end else ClearRequest(NextCmdNum(LS.Cmd.Num),st_NoReq);
      end;
     end else
     if LS.Com.Status=st_WaitAns then begin
      LS.Com.Ans:=LS.Com.Ans+ComRead(255);
      if (LS.Cmd.aonum[LS.Cmd.Num]<=0) then begin
       LS.Com.PollRate:=LS.Com.PollRate+1;
       LS.Com.Status:=st_WaitGap;
       LS.Com.AnsTime:=mSecNow;
       LS.Cmd.Enabled[LS.Cmd.Num]:=false;
       ClearRequest(NextCmdNum(LS.Cmd.Num)-4,st_NoReq);
      end else
      if (Length(LS.Com.Ans)>=3) then begin
       bNul(HandleRequest(LS.Cmd.Num,LS.Com.Ans));
       LS.Com.PollRate:=LS.Com.PollRate+1;
       LS.Com.Status:=st_WaitGap;
       LS.Com.AnsTime:=mSecNow;
      end else
      if mSecNow>LS.Com.ReqTime+LS.Com.TimeOut then begin
       LS.Com.Status:=st_TimeOut;
       if LS.Cmd.Enabled[LS.Cmd.Num] then LS.Com.Status:=st_WaitGap;
      end;
     end;
     if LS.Com.Status=st_WaitGap then begin
      if mSecNow>=LS.Com.AnsTime+LS.Com.TimeGap then begin
       if not IsQueryCmdNum(LS.Cmd.Num) then EnableCmdNum(LS.Cmd.Num,false);
       ClearRequest(NextCmdNum(LS.Cmd.Num),st_NoReq);
      end;
     end;
     if LS.Com.Status=st_TimeOut then begin
      Failure(LS.ecTimeOut,'TimeOut on command '+LS.Cmd.Acronym[LS.Cmd.Num]+' request '+Trim(LS.Com.Req));
      ClearRequest(NextCmdNum(LS.Cmd.Num),st_NoReq);
      EnableIDN;
     end;
    end else begin
     ClearRequest(NextCmdNum(0),st_NoReq);
     UpdateIDN(si_OFFLINE);
     EnableIDN;
    end;
   end;
  end;
  {
  Update DIM services
  }
  if DIM_IsServerMode then begin
   // Enforce update each 10 sec
   if SysTimer_Pulse(10000)>0 then LAKESHORE_FillTags(-MaxReal);
   DimRefreshTag(LS.POLL_ENABLE);                            
   DimRefreshTag(LS.POLL_RATE);                              
   DimRefreshTag(LS.ERROR_CNT);                              
   DimRefreshTag(LS.ID_NAME);                                
   DimRefreshTag(LS.ID_IDN); 
   DimRefreshTag(LS.IdentificationQuery);                    
   DimRefreshTag(LS.MonitorOutParameterQuery);               
   DimRefreshTag(LS.DiodeExcitationCurParrQuery);            
   DimRefreshTag(LS.InputFilterParameterQuery);              
   DimRefreshTag(LS.HeaterOutputQuery1);                     
   DimRefreshTag(LS.HeaterOutputQuery2);                     
   DimRefreshTag(LS.HeaterSetupQuery1);                      
   DimRefreshTag(LS.HeatResist1);                            
   DimRefreshTag(LS.MaxCurrent1);                            
   DimRefreshTag(LS.HeaterSetupQuery2);                      
   DimRefreshTag(LS.HeatResist2);                            
   DimRefreshTag(LS.MaxCurrent2);                            
   DimRefreshTag(LS.HeaterStatusQuery1);                     
   DimRefreshTag(LS.HeaterStatusQuery2);                     
   DimRefreshTag(LS.InputCurveNumberQueryA);                 
   DimRefreshTag(LS.InputCurveNumberQueryB);                 
   DimRefreshTag(LS.InputTypeParameterQueryA);               
   DimRefreshTag(LS.EnableInputA);                           
   DimRefreshTag(LS.InputTypeParameterQueryB);               
   DimRefreshTag(LS.EnableInputB);                           
   DimRefreshTag(LS.KelvinReadingQueryA);                    
   DimRefreshTag(LS.KelvinReadingQueryB);                    
   DimRefreshTag(LS.MinimumMaximumDataQuery);                
   DimRefreshTag(LS.OutManualHeaterPowerOutQuery);           
   DimRefreshTag(LS.OutputModeQuery1);                       
   DimRefreshTag(LS.OutputMode1);                            
   DimRefreshTag(LS.ControlInput1);                          
   DimRefreshTag(LS.OutputModePowerup1);                     
   DimRefreshTag(LS.OutputModeQuery2);                       
   DimRefreshTag(LS.OutputMode2);                            
   DimRefreshTag(LS.ControlInput1);                          
   DimRefreshTag(LS.OutputModePowerup2);                     
   DimRefreshTag(LS.OutVoltPolarityQuery);                                 
   DimRefreshTag(LS.ControlLoopPIDValuesQuery1);             
   DimRefreshTag(LS.PIDparP1);                               
   DimRefreshTag(LS.PIDparI1);                               
   DimRefreshTag(LS.PIDparD1);                               
   DimRefreshTag(LS.ControlLoopPIDValuesQuery2);             
   DimRefreshTag(LS.PIDparP2);                               
   DimRefreshTag(LS.PIDparI2);                               
   DimRefreshTag(LS.PIDparD2);                               
   DimRefreshTag(LS.SetRampPar1);                            
   DimRefreshTag(LS.SetRamp1);                               
   DimRefreshTag(LS.RampRate1);                              
   DimRefreshTag(LS.SetRampPar2);                            
   DimRefreshTag(LS.SetRamp2);                               
   DimRefreshTag(LS.RampRate2);                              
   DimRefreshTag(LS.ControlSetpointRampStatQuery1);          
   DimRefreshTag(LS.ControlSetpointRampStatQuery2);          
   DimRefreshTag(LS.HeaterRangeQuery1);                      
   DimRefreshTag(LS.HeaterRangeQuery2);                      
   DimRefreshTag(LS.InputReadingStatusQueryA);               
   DimRefreshTag(LS.InputReadingStatusQueryB);               
   DimRefreshTag(LS.ControlSetpointQuery1);                  
   DimRefreshTag(LS.ControlSetpointQuery2);                  
   DimRefreshTag(LS.SensorUnitsInputReadingQuery);           
   DimRefreshTag(LS.ThermocoupleJunctionTempQuery);          
   DimRefreshTag(LS.TemperatureLimitQuery);                  
   DimRefreshTag(LS.ControlTuningStatusQuery1);               
   DimRefreshTag(LS.ControlTuningStatusQuery2);               
   DimRefreshTag(LS.WarmupSupplyParameterQuery1);            
   DimRefreshTag(LS.WarmupControl1);                         
   DimRefreshTag(LS.WarmupOutput1);                          
   DimRefreshTag(LS.WarmupSupplyParameterQuery2);            
   DimRefreshTag(LS.WarmupControl2);                         
   DimRefreshTag(LS.WarmupOutput2);                          
   DimRefreshTag(LS.ManualRangeButtonA);                     
   DimRefreshTag(LS.ManualRangeButtonB);                     
   DimRefreshTag(LS.AutoRangeA);                             
   DimRefreshTag(LS.AutoRangeB);                             
   DimRefreshTag(LS.OutputZoneTableParameterQuery); 
   if ShouldRefresh(LS.CLOCK.val,GetStampOfTag(LS.CLOCK.tag,0))>0
   then DIM_UpdateTag(LS.CLOCK.tag,'');
   if ShouldRefresh(LS.SERVID.val,GetStampOfTag(LS.SERVID.tag,0))>0
   then DIM_UpdateTag(LS.SERVID.tag,'');   
  end;
 end;
 
 {
 Xor bit on click (local version).
 }
 procedure ClickTagXorLocal(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 
 procedure DevSendCmdTag(dev,tag:Integer; cmd,data:String; min,max:Real);
 var v:Real;
 begin
  if IsRefTag(tag) then
  if IsRefDevice(dev) then
  if not IsEmptyStr(cmd) then
  if not IsEmptyStr(data) then
  if TypeTag(tag)<=2 then begin
   v:=rVal(data);
   if (v<min) then begin v:=min; data:=Str(min); end;
   if (v>max) then begin v:=max; data:=Str(max); end;
   if IsNaN(v) then Trouble('Invalid tag edit') else
   if TypeTag(tag)=1 then DevPostCmd(devMySelf,cmd+','+Str(Round(v))) else
   if TypeTag(tag)=2 then DevPostCmd(devMySelf,cmd+','+Trim(data));
  end else
  if TypeTag(tag)=3 then begin
   DevPostCmd(devMySelf,cmd+' '+Trim(data));
  end;
 end;
 
 {
 Xor bit on click (remote version).
 }
 procedure ClickTagXorRemote(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   DIM_GuiClickSend(DIM_GuiClickBuff+'NewValue='+Str(iXor(iGetTag(tag),XorMask)));
   bNul(Voice(snd_Click));
  end;
 end;

 {
 Remote click.
 }
 procedure ClickTagRemote(tag:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   DIM_GuiClickSend(DIM_GuiClickBuff+'NewValue='+Str(iGetTag(tag)));
   bNul(Voice(snd_Click));
  end;
 end;
 
 {
 Menu Heater Range to start editing.
 }
 procedure MenuHeaterRange(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Heater Range"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Off');
   n:=n+EditAddInputLn('Low');
   n:=n+EditAddInputLn('Medium');
   n:=n+EditAddInputLn('High');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_HeaterRange'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end; 
 
 {
 Menu Curve Name to start editing.
 }
 procedure MenuCurveName(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Curve Name"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('None');
   n:=n+EditAddInputLn('DT-470');
   n:=n+EditAddInputLn('DT-670');
   n:=n+EditAddInputLn('DT-500-D*');
   n:=n+EditAddInputLn('DT-500-E1*');
   n:=n+EditAddInputLn('PT-100');
   n:=n+EditAddInputLn('PT-1000*');
   n:=n+EditAddInputLn('RX-102A-AA');
   n:=n+EditAddInputLn('Reserved');
   n:=n+EditAddInputLn('Reserved');
   n:=n+EditAddInputLn('Type K');
   n:=n+EditAddInputLn('Type E');
   n:=n+EditAddInputLn('Type T');
   n:=n+EditAddInputLn('AuFe 0.03%*');
   n:=n+EditAddInputLn('AuFe 0.07%');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CurveName'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;

 {
 Menu Input Range to start editing.
 }
 procedure MenuInputRange(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Input Range"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   case igettag(LS.EnableInputA.tag) of
       1: begin
           n:=n+EditAddInputLn('2.5V');
           n:=n+EditAddInputLn('10 V');
          end;
      2: begin
           n:=n+EditAddInputLn('10  Ohm');
           n:=n+EditAddInputLn('30  Ohm');
           n:=n+EditAddInputLn('100 Ohm');
           n:=n+EditAddInputLn('300 Ohm');
           n:=n+EditAddInputLn('1   kOhm');
           n:=n+EditAddInputLn('3   kOhm');
           n:=n+EditAddInputLn('10  kOhm');
          end;
      3: begin     
           n:=n+EditAddInputLn('10  Ohm');
           n:=n+EditAddInputLn('30  Ohm');
           n:=n+EditAddInputLn('100 Ohm');
           n:=n+EditAddInputLn('300 Ohm');
           n:=n+EditAddInputLn('1   kOhm');
           n:=n+EditAddInputLn('3   kOhm');
           n:=n+EditAddInputLn('10  kOhm');
           n:=n+EditAddInputLn('30  kOhm');
           n:=n+EditAddInputLn('100 kOhm');
          end;
      4: begin
           n:=n+EditAddInputLn('50 mv');
      end;
   end;
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_InputRange'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 
 {
 Menu Sensor Type to start editing.
 }
 procedure MenuSensorType(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Sensor Type"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Disabled');
   n:=n+EditAddInputLn('Diode');
   n:=n+EditAddInputLn('Platinum RTD');
   n:=n+EditAddInputLn('NTC RTD');
   n:=n+EditAddInputLn('Thermocouple');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_SensorType'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end; 
 
 {
 Menu Output Mode to start editing.
 }
 procedure MenuOutputMode(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Output Mode"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Off');
   n:=n+EditAddInputLn('Closed Loop PID');
   n:=n+EditAddInputLn('Zone');
   n:=n+EditAddInputLn('Open Loop');
   n:=n+EditAddInputLn('Monitor out');
   n:=n+EditAddInputLn('Warmup Supply');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_OutputMode'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end; 
 
 {
 Menu Control Input to start editing.
 }
 procedure MenuControlInput(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Control Input"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('None');
   n:=n+EditAddInputLn('Input A');
   n:=n+EditAddInputLn('Input B');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_ControlInput'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end; 
 
 {
 Menu Heater Resistance to start editing.
 }
 procedure MenuHeaterResistance(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Heater Resistance"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('25 Ohm');
   n:=n+EditAddInputLn('50 Ohm');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_HeaterResistance'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end; 
 
 {
 Menu Maximum heater output current to start editing.
 }
 procedure MenuMaxCurrent(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Maximum heater output current"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('User Specified');
   n:=n+EditAddInputLn('0.707 A');
   n:=n+EditAddInputLn('1 A');
   n:=n+EditAddInputLn('1.141 A');
   n:=n+EditAddInputLn('1.732 A');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_MaxCurrent'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 
 {
 GUI Handler to process user input...
 }
 procedure LAKESHORE_GUI_POLL;
 var ClickCurve,i,j:Integer; s:String;
  procedure ClickEditLAKESHORECmd(n:Integer);
  begin
   if IsValidCmdNum(n) then
    DevPostCmd(DevMySelf,'@Edit '+LS.Cmd.Acronym[n]);
   writeln('DevPostCmd @Edit '+LS.Cmd.Acronym[n]);
   bNul(Voice(snd_Click)); 
  end;
  
  procedure DevSendLAKESHORECmd(n:Integer; prefix,data:String);
  var v:Real;
  begin
   if IsValidCmdNum(n) then
   if not IsEmptyStr(data) then
   if TypeTag(LS.Cmd.Tag[n])=1 then begin
    v:=rVal(data);
    if isNan(v) then Problem('Invalid tag edit') else
    DevPostCmd(DevMySelf,prefix+LS.Cmd.Acronym[n]+' '+data);
   end else
   if TypeTag(LS.Cmd.Tag[n])=2 then begin
    v:=rVal(data);
    if isNan(v) then Problem('Invalid tag edit') else
    DevPostCmd(DevMySelf,prefix+LS.Cmd.Acronym[n]+' '+data);
   end else
   if TypeTag(LS.Cmd.Tag[n])=3 then begin
    DevPostCmd(DevMySelf,prefix+LS.Cmd.Acronym[n]+' '+data);
   end;
  end;
  procedure CheckEditLAKESHORECmd(n:Integer; prefix:String);
  var s:String;
  begin
   s:='';
   if IsValidCmdNum(n) then
   if CheckEditTag(LS.Cmd.Tag[n],s) then begin
    DevSendLAKESHORECmd(n,prefix+'@Setting ',s);
    sNul(Edit(''));
   end;
   s:='';
  end;
  procedure RefreshSetting(n:Integer; var S:TTagRef);
  begin
   if IsValidCmdNum(n) then begin
    if TypeTag(S.tag)>0 then
    if ShouldRefresh(S.val,GetStampOfTag(S.tag,0))>0 then
    DevPostCmd(DevMySelf,'@Setting '+LS.Cmd.Acronym[n]+' '+TagAsText(S.tag));
   end;
  end;
 begin
  s:='';
  DIM_GuiClickBuff:='';
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,KeyUp)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Copy GUI click to DIM buffer for remote execution.
   }
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle local clicks
     }
     if ClickIsLocal then begin
      {
      Handle sensor clicks...
      }
      if IsSameText(ClickSensor,'HELP') then begin
       Cron('@Browse '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
       bNul(Voice(snd_Click));
      end;
      if (ClickTag<>0) then begin
       if (ClickTag=LS.ID_IDN.tag) then begin
        DevPostCmd(DevMySelf,'@Remote @Setting IDN');
        bNul(Voice(snd_Click));
       end;
       ClickTagXorRemote(LS.POLL_ENABLE.tag,1);
       ClickTagXorRemote(LS.AutoTune1.tag,1);
       ClickTagXorRemote(LS.AutoTune2.tag,1);
       ClickTagXorRemote(LS.HeaterStart1.tag,1);
       ClickTagXorRemote(LS.HeaterStart2.tag,1);
       ClickTagXorRemote(LS.SetTDX1.tag,1);
       ClickTagXorRemote(LS.SetTDX2.tag,1);
       ClickTagRemote(LS.SetRamp1.tag);
       ClickTagRemote(LS.SetRamp2.tag);
       ClickTagRemote(LS.OutputModePowerup1.tag);
       ClickTagRemote(LS.OutputModePowerup2.tag);
       ClickTagRemote(LS.AutoRangeA.tag);
       ClickTagRemote(LS.AutoRangeB.tag);
       
       if (ClickTag=LS.Cmd.Tag[cm_ControlSetpointQuery1]) then if LAKESHORE_CheckPolling(1) then ClickEditLAKESHORECmd(cm_ControlSetpointQuery1);
       if (ClickTag=LS.Cmd.Tag[cm_ControlSetpointQuery2]) then if LAKESHORE_CheckPolling(1) then ClickEditLAKESHORECmd(cm_ControlSetpointQuery2);
       if (ClickTag=LS.RampRate1.tag) then if LAKESHORE_CheckPolling(1) then ClickEditLAKESHORECmd(cm_SetRampPar1);
       if (ClickTag=LS.RampRate2.tag) then if LAKESHORE_CheckPolling(1) then ClickEditLAKESHORECmd(cm_SetRampPar2);
       
       if (ClickTag=LS.PIDparP1.tag) then if LAKESHORE_CheckPolling(1) then StartEditTag(ClickTag,'Proportional:');
       if (ClickTag=LS.PIDparI1.tag) then if LAKESHORE_CheckPolling(1) then StartEditTag(ClickTag,'Integral:');
       if (ClickTag=LS.PIDparD1.tag) then if LAKESHORE_CheckPolling(1) then StartEditTag(ClickTag,'Derivative:');
       
       if (ClickTag=LS.PIDparP2.tag) then if LAKESHORE_CheckPolling(1) then StartEditTag(ClickTag,'Proportional:');
       if (ClickTag=LS.PIDparI2.tag) then if LAKESHORE_CheckPolling(1) then StartEditTag(ClickTag,'Integral:');
       if (ClickTag=LS.PIDparD2.tag) then if LAKESHORE_CheckPolling(1) then StartEditTag(ClickTag,'Derivative:');

     if ClickTag=LS.HeaterRangeQuery1.tag then begin // Menu Heater Range
      bNul(Voice(snd_Click));
      MenuHeaterRange(LS.HeaterRangeQuery1.tag);
     end;     
     if ClickTag=LS.HeaterRangeQuery2.tag then begin // Menu Heater Range
      bNul(Voice(snd_Click));
      MenuHeaterRange(LS.HeaterRangeQuery2.tag);
     end;    
     if ClickTag=LS.InputCurveNumberQueryA.tag then begin // Menu Curve Name
      bNul(Voice(snd_Click));
      MenuCurveName(LS.InputCurveNumberQueryA.tag);
     end;     
     if ClickTag=LS.InputCurveNumberQueryB.tag then begin // Menu Curve Name
      bNul(Voice(snd_Click));
      MenuCurveName(LS.InputCurveNumberQueryB.tag);
     end;
     if ClickTag=LS.ManualRangeButtonA.tag then begin // Menu Input Range
      bNul(Voice(snd_Click));
      MenuInputRange(LS.ManualRangeButtonA.tag);
     end;     
     if ClickTag=LS.ManualRangeButtonB.tag then begin // Menu Input Range
      bNul(Voice(snd_Click));
      MenuInputRange(LS.ManualRangeButtonB.tag);
     end;
     if ClickTag=LS.EnableInputA.tag then begin // Menu Sensor Type
      bNul(Voice(snd_Click));
      MenuSensorType(LS.EnableInputA.tag);
     end;     
     if ClickTag=LS.EnableInputB.tag then begin // Menu Sensor Type
      bNul(Voice(snd_Click));
      MenuSensorType(LS.EnableInputB.tag);
     end;     
     if ClickTag=LS.OutPutMode1.tag then begin // Menu Output Mode
      bNul(Voice(snd_Click));
      MenuOutputMode(LS.OutPutMode1.tag);
     end;     
     if ClickTag=LS.OutPutMode2.tag then begin // Menu Output Mode
      bNul(Voice(snd_Click));
      MenuOutputMode(LS.OutPutMode2.tag);
     end;     
     if ClickTag=LS.ControlInput1.tag then begin // Menu Control Input
      bNul(Voice(snd_Click));
      MenuControlInput(LS.ControlInput1.tag);
     end;     
     if ClickTag=LS.ControlInput2.tag then begin // Menu Control Input
      bNul(Voice(snd_Click));
      MenuControlInput(LS.ControlInput2.tag);
     end;     
     if ClickTag=LS.HeatResist1.tag then begin // Menu Heater Resistance
      bNul(Voice(snd_Click));
      MenuHeaterResistance(LS.HeatResist1.tag);
     end;     
     if ClickTag=LS.HeatResist2.tag then begin // Menu Heater Resistance
      bNul(Voice(snd_Click));
      MenuHeaterResistance(LS.HeatResist2.tag);
     end;  
     if ClickTag=LS.MaxCurrent1.tag then begin // Menu Maximum heater output current
      bNul(Voice(snd_Click));
      MenuMaxCurrent(LS.MaxCurrent1.tag);
     end;     
     if ClickTag=LS.MaxCurrent2.tag then begin // Menu Maximum heater output current
      bNul(Voice(snd_Click));
      MenuMaxCurrent(LS.MaxCurrent2.tag);
     end;
      
      end;
      {
      Select Plot & Tab windows by curve...
      }
      ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
      if IsRefCurve(ClickCurve) then begin
       iNul(WinSelectByCurve(ClickCurve,ClickCurve));
       bNul(Voice(snd_Wheel));
      end;
      {
      Console commands: @url_encoded_sensor ...
      }
      if (strFetch(ClickSensor,1)='@') then begin
       DevPostCmd(devMySelf,url_decode(ClickSensor));
       bNul(Voice(snd_Click));
      end;
     end;
     {
     Handle remote clicks comes from DIM via @DimGuiClick message.
     @DimGuiClick default handler decode and write events to FIFO,
     so we can find it as clicks and can handle it in usual way.
     }
     if ClickIsRemote then begin
      {
      Show time difference.
      }
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      {
      Handle remote console commands...
      }
      s:=Dim_GuiConsoleRecv(DevName,'');
      if (strFetch(s,1)='@') then DevPostCmd(devMySelf,s);
      {
      Handle remote sensor clicks...
      }
      if TypeTag(ClickTag)>0 then begin
       s:=ClickParams('NewValue');
       if Length(s)>0 then begin
        if (ClickTag=LS.AutoTune1.tag) then DevSendCmd(devMySelf,'@Setting ATUNE 1,3');     
        if (ClickTag=LS.AutoTune2.tag) then DevSendCmd(devMySelf,'@Setting ATUNE 2,3'); 
        if (ClickTag=LS.HeaterStart1.tag) then begin
         if igettag(LS.HeaterStart1.tag)>0 then DevSendCmd(devMySelf,'@Setting RANGE 1,0') else DevSendCmd(devMySelf,'@Setting RANGE 1,3');
        end;
        if (ClickTag=LS.HeaterStart2.tag) then begin
         if igettag(LS.HeaterStart2.tag)>0 then DevSendCmd(devMySelf,'@Setting RANGE 2,0') else DevSendCmd(devMySelf,'@Setting RANGE 2,3');
        end; 
        
        if (ClickTag=LS.SetTDX1.tag) then begin
         if igettag(LS.SetTDX1.tag)>0 then 
            DevSendCmd(devMySelf,'@Setting OUTMODE 1,'+str(igettag(LS.OutputMode1.tag))+',1,'+str(igettag(LS.OutputModePowerup1.tag))) 
         else 
            DevSendCmd(devMySelf,'@Setting OUTMODE 1,'+str(igettag(LS.OutputMode1.tag))+',2,'+str(igettag(LS.OutputModePowerup1.tag)));
        end;
        if (ClickTag=LS.SetTDX2.tag) then begin
         if igettag(LS.SetTDX2.tag)>0 then 
            DevSendCmd(devMySelf,'@Setting OUTMODE 1,'+str(igettag(LS.OutputMode1.tag))+',1,'+str(igettag(LS.OutputModePowerup2.tag))) 
         else 
            DevSendCmd(devMySelf,'@Setting OUTMODE 1,'+str(igettag(LS.OutputMode1.tag))+',2,'+str(igettag(LS.OutputModePowerup2.tag)));
        end;
        
        if ClickTag=LS.POLL_ENABLE.tag then UpdateTag(ClickTag,s,0,1);
        
        if (ClickTag=LS.SetRamp1.tag) then
        DevSendCmd(devMySelf,'@Setting RAMP 1,'+str(ixor(igettag(LS.SetRamp1.tag),1))+','+str(rgettag(LS.RampRate1.tag)));       
        if (ClickTag=LS.SetRamp2.tag) then
        DevSendCmd(devMySelf,'@Setting RAMP 2,'+str(ixor(igettag(LS.SetRamp2.tag),1))+','+str(rgettag(LS.RampRate2.tag)));      
       
        if (ClickTag=LS.OutputModePowerup1.tag) then
        DevSendCmd(devMySelf,'@Setting OUTMODE 1,'+str(igettag(LS.OutputMode1.tag))+','
        +str(igettag(LS.ControlInput1.tag))+','+str(ixor(igettag(LS.OutputModePowerup1.tag),1)));       
        if (ClickTag=LS.OutputModePowerup2.tag) then
        DevSendCmd(devMySelf,'@Setting OUTMODE 2,'+str(igettag(LS.OutputMode2.tag))+','
        +str(igettag(LS.ControlInput2.tag))+','+str(ixor(igettag(LS.OutputModePowerup2.tag),1))); 
        
        if (ClickTag=LS.AutoRangeA.tag) then
        DevSendCmd(devMySelf,'@Setting INTYPE A,'
        +str(igettag(LS.EnableInputA.tag))
        +','+str(ixor(igettag(LS.AutoRangeA.tag),1))
        +','+str(igettag(LS.ManualRangeButtonA.tag))+',0,1');    
        
        if (ClickTag=LS.AutoRangeB.tag) then
        DevSendCmd(devMySelf,'@Setting INTYPE B,'
        +str(igettag(LS.EnableInputB.tag))
        +','+str(ixor(igettag(LS.AutoRangeB.tag),1))
        +','+str(igettag(LS.ManualRangeButtonB.tag))+',0,1');
       end;
      end;
     end;
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   if CheckEditTag(LS.ControlSetpointQuery1.tag,s)  then DIM_GuiConsoleSend(DevName, '@Setting SETP 1 '+s);
   if CheckEditTag(LS.ControlSetpointQuery2.tag,s)  then DIM_GuiConsoleSend(DevName, '@Setting SETP 2 '+s);
   
   if CheckEditTag(LS.SetRampPar1.tag,s)  then DIM_GuiConsoleSend(DevName, '@Setting RAMP 1,'+str(igettag(LS.SetRamp1.tag))+' '+s);
   if CheckEditTag(LS.SetRampPar2.tag,s)  then DIM_GuiConsoleSend(DevName, '@Setting RAMP 2,'+str(igettag(LS.SetRamp2.tag))+' '+s);
   
   if CheckEditTag(LS.PIDparP1.tag,s)  then DIM_GuiConsoleSend(DevName, '@Setting PID 1,'
   +s+','+str(rgettag(LS.PIDparI1.tag))+','+str(rgettag(LS.PIDparD1.tag)));
   if CheckEditTag(LS.PIDparI1.tag,s)  then DIM_GuiConsoleSend(DevName, '@Setting PID 1,'
   +str(rgettag(LS.PIDparP1.tag))+','+s+','+str(rgettag(LS.PIDparD1.tag)));
   if CheckEditTag(LS.PIDparD1.tag,s)  then DIM_GuiConsoleSend(DevName, '@Setting PID 1,'
   +str(rgettag(LS.PIDparP1.tag))+','+str(rgettag(LS.PIDparI1.tag))+','+s); 
   
   if CheckEditTag(LS.PIDparP2.tag,s)  then DIM_GuiConsoleSend(DevName, '@Setting PID 2,'
   +s+','+str(rgettag(LS.PIDparI2.tag))+','+str(rgettag(LS.PIDparD2.tag)));
   if CheckEditTag(LS.PIDparI2.tag,s)  then DIM_GuiConsoleSend(DevName, '@Setting PID 2,'
   +str(rgettag(LS.PIDparP2.tag))+','+s+','+str(rgettag(LS.PIDparD2.tag)));
   if CheckEditTag(LS.PIDparD2.tag,s)  then DIM_GuiConsoleSend(DevName, '@Setting PID 2,'
   +str(rgettag(LS.PIDparP2.tag))+','+str(rgettag(LS.PIDparI2.tag))+','+s);
   
   // Menu HeaterRange
   if EditTestResultName(EditGetUID('MENU_HeaterRange'+str(LS.HeaterRangeQuery1.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting RANGE 1,'+s);
    end;
    EditReset;
   end;    

   // Menu HeaterRange
   if EditTestResultName(EditGetUID('MENU_HeaterRange'+str(LS.HeaterRangeQuery2.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting RANGE 2,'+s);
    end;
    EditReset;
   end;   
   
   // Menu Curve Name
   if EditTestResultName(EditGetUID('MENU_CurveName'+str(LS.InputCurveNumberQueryA.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting INCRV A,'+s);
    end;
    EditReset;
   end;    

   // Menu Curve Name
   if EditTestResultName(EditGetUID('MENU_CurveName'+str(LS.InputCurveNumberQueryB.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting INCRV B,'+s);
    end;
    EditReset;
   end;   
   
   // Menu Sensor Type
   if EditTestResultName(EditGetUID('MENU_SensorType'+str(LS.EnableInputA.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting INTYPE A,'+s+','+str(igettag(LS.AutoRangeA.tag))+','+str(igettag(LS.ManualRangeButtonA.tag))+',0,1');
    end;
    EditReset;
   end;    

   // Menu Sensor Type
   if EditTestResultName(EditGetUID('MENU_SensorType'+str(LS.EnableInputB.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting INTYPE B,'+s+','+str(igettag(LS.AutoRangeB.tag))+','+str(igettag(LS.ManualRangeButtonB.tag))+',0,1');
    end;
    EditReset;
   end;   
   
   // Menu Input Range
   if EditTestResultName(EditGetUID('MENU_InputRange'+str(LS.ManualRangeButtonA.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting INTYPE A,'+str(igettag(LS.EnableInputA.tag))+','+str(igettag(LS.AutoRangeA.tag))+','+s+',0,1');
    end;
    EditReset;
   end;    

   // Menu Input Range
   if EditTestResultName(EditGetUID('MENU_InputRange'+str(LS.ManualRangeButtonB.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting INTYPE B,'+str(igettag(LS.EnableInputB.tag))+','+str(igettag(LS.AutoRangeB.tag))+','+s+',0,1');
    end;
    EditReset;
   end;  
   
   // Menu Output Mode
   if EditTestResultName(EditGetUID('MENU_OutputMode'+str(LS.OutputMode1.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting OUTMODE 1,'+s+','+str(igettag(LS.ControlInput1.tag))+','+str(igettag(LS.OutputModePowerup1.tag)));
    end;
    EditReset;
   end;    

   // Menu Output Mode
   if EditTestResultName(EditGetUID('MENU_OutputMode'+str(LS.OutputMode2.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting OUTMODE 2,'+s+','+str(igettag(LS.ControlInput2.tag))+','+str(igettag(LS.OutputModePowerup2.tag)));
    end;
    EditReset;
   end;

   // Menu Control Input
   if EditTestResultName(EditGetUID('MENU_ControlInput'+str(LS.ControlInput1.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting OUTMODE 1,'+str(igettag(LS.OutputMode1.tag))+','+s+','+str(igettag(LS.OutputModePowerup1.tag)));
    end;
    EditReset;
   end;   
   
   // Menu Control Input
   if EditTestResultName(EditGetUID('MENU_ControlInput'+str(LS.ControlInput2.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting OUTMODE 2,'+str(igettag(LS.OutputMode2.tag))+','+s+','+str(igettag(LS.OutputModePowerup2.tag)));
    end;
    EditReset;
   end;    

   // Menu Heater Resistance
   if EditTestResultName(EditGetUID('MENU_HeaterResistance'+str(LS.HeatResist1.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex+1);
     DIM_GuiConsoleSend(DevName, '@Setting HTRSET 1,0,'+s+','+str(igettag(LS.MaxCurrent1.tag))+',0,1');
    end;
    EditReset;
   end;   
   
   // Menu Heater Resistance
   if EditTestResultName(EditGetUID('MENU_HeaterResistance'+str(LS.HeatResist2.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex+1);
     DIM_GuiConsoleSend(DevName, '@Setting HTRSET 2,0,'+s+','+str(igettag(LS.MaxCurrent2.tag))+',0,1');
    end;
    EditReset;
   end; 
   
   // Menu Maximum heater output current
   if EditTestResultName(EditGetUID('MENU_MaxCurrent'+str(LS.MaxCurrent1.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting HTRSET 1,0,'+str(igettag(LS.HeatResist1.tag))+','+s+',0,1');
    end;
    EditReset;
   end;   
   
   // Menu Maximum heater output current
   if EditTestResultName(EditGetUID('MENU_MaxCurrent'+str(LS.MaxCurrent2.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DIM_GuiConsoleSend(DevName, '@Setting HTRSET 2,0,'+str(igettag(LS.HeatResist2.tag))+','+s+',0,1');
    end;
    EditReset;
   end;       
   
   // TOOLS menu.
   if IsSameText(ExtractWord(1,Edit('?ans 0')),MenuToolsIdent) then begin
    if Val(ExtractWord(2,Edit('?ans 0')))=1 then begin
     MenuToolsSelected:=Val(Edit('?ans 1'));
     if MenuToolsSelected>=0 then
     if (MenuToolsSelected>80) then begin
      DevPostCmd(devMySelf,'@MenuToolsConfirmation '+UpCaseStr(StrReplace(StrReplace(
                 MenuToolsItem(MenuToolsSelected),'  ',Dump(' '),3),'  ',Dump(' '),3)));
     end else begin
      MenuToolsCmnd(MenuToolsSelected);
      MenuToolsSelected:=-1;
     end;
    end;
    sNul(Edit(''));
   end;

   // TOOLS menu (after confirmation).
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'YesNo_'+MenuToolsIdent) then begin
    if MenuToolsSelected>=0 then
    if Val(ExtractWord(2,Edit('?ans 0')))=6 then MenuToolsCmnd(MenuToolsSelected);
    MenuToolsSelected:=-1;
    sNul(Edit(''));
   end;
   {
   Warning, Information dialog completion.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'Warning') then sNul(Edit(''));
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'Information') then sNul(Edit(''));
   
  end;
  if EditState=ef_Done then begin
   Problem('Uncompleted edit detected!');
   sNul(Edit(''));
  end else
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Edit error detected!');
   sNul(Edit(''));
  end;
  DIM_GuiClickBuff:='';
  s:='';
 end;
 
 { 
 Handle data requests in simulation mode.
 }
 procedure LAKESHORE_Sim(Req:String);
 var cmd,arg,delims:String; rt,n:Integer;
 begin
  cmd:=''; arg:='';
  
  req:=copy(Req,1,Length(Req)-2);
  if Length(Req)>0 then begin
   ViewImp('COM < '+Req);
   if Length(Req)>0 then begin
    n:=LAKESHORE_Cmd_Find(Req);
    if IsValidCmdNum(n) then LS.Com.Ans:=LS.Cmd.SimDat[n];
    if Req='KRDG? A'    then LS.Com.Ans:='+'+str(293.39+random(-1,1));
    if Req='KRDG? B'    then LS.Com.Ans:='+'+str(320.100+random(-1,1));
    
    delims:=worddelims(',');
    if ExtractWord(1,req)='SETP 1'    then LS.Cmd.SimDat[cm_ControlSetpointQuery1]:=ExtractWord(2,req);
    if ExtractWord(1,req)='SETP 2'    then LS.Cmd.SimDat[cm_ControlSetpointQuery2]:=ExtractWord(2,req);
    if ExtractWord(1,req)='RANGE 1'   then LS.Cmd.SimDat[cm_HeaterRangeQuery1]:=ExtractWord(2,req); 
    if ExtractWord(1,req)='RANGE 2'   then LS.Cmd.SimDat[cm_HeaterRangeQuery2]:=ExtractWord(2,req);
    if ExtractWord(1,req)='INCRV A'   then LS.Cmd.SimDat[cm_InputCurveNumberQueryA]:=ExtractWord(2,req);
    if ExtractWord(1,req)='INCRV B'   then LS.Cmd.SimDat[cm_InputCurveNumberQueryB]:=ExtractWord(2,req);
    if ExtractWord(1,req)='INTYPE A'  then LS.Cmd.SimDat[cm_InputTypeParameterQueryA]:=ExtractWord(2,req)+','+ExtractWord(3,req)+','+ExtractWord(4,req)+','+ExtractWord(5,req)+','+ExtractWord(6,req);
    if ExtractWord(1,req)='INTYPE B'  then LS.Cmd.SimDat[cm_InputTypeParameterQueryB]:=ExtractWord(2,req)+','+ExtractWord(3,req)+','+ExtractWord(4,req)+','+ExtractWord(5,req)+','+ExtractWord(6,req);
    if ExtractWord(1,req)='RAMP 1'    then LS.Cmd.SimDat[cm_SetRampPar1]:=ExtractWord(2,req)+','+ExtractWord(3,req);
    if ExtractWord(1,req)='RAMP 2'    then LS.Cmd.SimDat[cm_SetRampPar2]:=ExtractWord(2,req)+','+ExtractWord(3,req);
    if ExtractWord(1,req)='OUTMODE 1' then LS.Cmd.SimDat[cm_OutputModeQuery1]:=ExtractWord(2,req)+','+ExtractWord(3,req)+','+ExtractWord(4,req);
    if ExtractWord(1,req)='OUTMODE 2' then LS.Cmd.SimDat[cm_OutputModeQuery2]:=ExtractWord(2,req)+','+ExtractWord(3,req)+','+ExtractWord(4,req);
    if ExtractWord(1,req)='PID 1'     then LS.Cmd.SimDat[cm_ControlLoopPIDValuesQuery1]:=ExtractWord(2,req)+','+ExtractWord(3,req)+','+ExtractWord(4,req);
    if ExtractWord(1,req)='PID 2'     then LS.Cmd.SimDat[cm_ControlLoopPIDValuesQuery2]:=ExtractWord(2,req)+','+ExtractWord(3,req)+','+ExtractWord(4,req);
    if ExtractWord(1,req)='HTRSET 1'  then LS.Cmd.SimDat[cm_HeaterSetupQuery1]:=ExtractWord(2,req)+','+ExtractWord(3,req)+','+ExtractWord(4,req)+','+ExtractWord(5,req)+','+ExtractWord(6,req);
    if ExtractWord(1,req)='HTRSET 2'  then LS.Cmd.SimDat[cm_HeaterSetupQuery2]:=ExtractWord(2,req)+','+ExtractWord(3,req)+','+ExtractWord(4,req)+','+ExtractWord(5,req)+','+ExtractWord(6,req);
    delims:=worddelims(delims);
    
    {Одобряем все запросы, без проверки}
    { LS.Com.Ans:=Copy(Req,1,Length(Req)-3)+CRLF; }
    LS.Com.Ans:=LS.Com.Ans+CRLF;
    
    {
    Send reply to requests
    }
    if Length(LS.Com.Ans)>0 then begin
     if ComWrite(LS.Com.Ans) then 
     begin 
      ViewExp('COM > '+LS.Com.Ans);
     end
     else Trouble('Could not send '+LS.Com.Ans);
    end;
   end;
  end;
  LS.Com.Req:='';
  LS.Com.Ans:='';
 end;

 {
 LAKESHORE cleanup.
 }
 procedure LAKESHORE_Clear;
 begin
  LAKESHORE_Clear_Cmd;
  LS.CmdHash:=0;
  LS.Com.Req:='';
  LS.Com.Ans:='';
  LS.Com.Buf:='';
  LS.ModelCode:=0;
  LS.DrvName:='';
  LS.SelfId:='';
 end;
 {
 LAKESHORE initialization.
 }
 procedure LAKESHORE_Init;
 var i:Integer;
 begin
  {
  Register error codes
  }
  LS.ecTimeOut:=RegisterErr(progname+': TimeOut');
  {
  Initialize variables
  }
  MenuToolsSelected:=-1;
  LS.Com.ReqTime:=0;
  LS.Com.AnsTime:=0;
  LS.Com.LastPoll:=0;
  LS.Com.Status:=st_NoReq;
  {
  Initialize command table.
  }
  LS.CmdHash:=HashList_Init(0);
  LAKESHORE_Init_Cmd;
  {
  Read ini file variables
  }
  LS.Simulator:=iValDef(ReadIni('Simulator'),0)<>0;
  if LS.Simulator
  then Success('Run simulator mode.')
  else Success('Run as driver mode.');
  LS.Com.Port:=iValDef(ReadIni('ComPort'),0);
  Success('ComPort = '+Str(LS.Com.Port));
  LS.Com.TimeOut:=iValDef(ReadIni('ComTimeOut'),250);
  Success('ComTimeOut = '+Str(LS.Com.TimeOut));
  LS.Com.TimeGap:=iValDef(ReadIni('ComTimeGap'),10);
  Success('ComTimeGap = '+Str(LS.Com.TimeGap));
  LS.Com.PollPeriod:=iValDef(ReadIni('PollPeriod'),100);
  Success('PollPeriod = '+Str(LS.Com.PollPeriod));
  LS.DrvName:=ReadIniVar('DrvName',28);
  Success('DrvName = '+LS.DrvName);
  LS.ModelCode:=LAKESHORE_UpdateModel(LAKESHORE_ParseIDN(LS.DrvName,false));
  {
  Initialize tags...
  }
  if not LS.Simulator then begin
   LAKESHORE_InitTags(ReadIni('tagPrefix'));
   bNul(sSetTag(LS.ID_IDN.tag,LS.DrvName));
  end;
  {
  Initialize COM port
  }
  if not DIM_IsClientMode then
  if ComOpen('[SerialPort-COM'+Str(LS.Com.Port)+']')
  then Success('COM port initialized.')
  else Trouble('COM port failed.');
 end;
 
 {
 LAKESHORE finalization.
 }
 procedure LAKESHORE_Free;
 begin
  bNul(ComClose);
  if (LS.CmdHash<>0) then begin
   bNul(HashList_Free(LS.CmdHash));
   LS.CmdHash:=0;
  end;
 end;
 
 {
 LAKESHORE polling.
 }
 procedure LAKESHORE_Poll;
 begin
  if LS.Simulator then begin
   if IsComPortOpened then begin
    LS.Com.Req:=LS.Com.Req+ComRead(255);
    if (Length(LS.Com.Req)>=3) then
    begin
     if (StrFetch(LS.Com.Req,Length(LS.Com.Req))=Chr(10)) then 
     begin
      LAKESHORE_Sim(LS.Com.Req);
     end;
    end;
   end;
  end else begin
   LAKESHORE_GUI_POLL;
   if not DIM_IsClientMode then begin
    if SysTimer_Pulse(1000)>0 then begin
     bNul(rSetTag(LS.ERROR_CNT.tag,GetErrCount(-1)));
     UpdateDimTag(LS.ERROR_CNT.tag);
     UpdateAo(ao_ERROR_CNT,time,GetErrCount(-1));
     bNul(rSetTag(LS.POLL_RATE.tag,LS.Com.PollRate));
     UpdateDimTag(LS.POLL_RATE.tag);
     UpdateAo(ao_POLL_RATE,time,LS.Com.PollRate);
     LS.Com.PollRate:=0;
     {
     Update Host Date-Time.
     }
     bNul(sSetTag(LS.SERVID.tag,LS.SelfId));
     bNul(sSetTag(LS.CLOCK.tag,GetDateTime(mSecNow)));
     bNul(SetTagColor(LS.SERVID.tag,ColorNorm));
     bNul(SetTagColor(LS.CLOCK.tag,ColorNorm));
    end;
    if mSecNow-FixmSecNow>DelayOnStart then
    LAKESHORE_CMD_CYCLE;
   end;
  end;
  if DIM_IsClientMode then begin
   if (ShouldRefresh(LS.CLOCK.dat,GetStampOfTag(LS.CLOCK.tag,0))>0) then begin
    bNul(SetTagColor(LS.SERVID.tag,ColorNorm));
    bNul(SetTagColor(LS.CLOCK.tag,ColorNorm));
    LS.CLOCK.tim:=mSecNow;
   end;
   if (SysTimer_Pulse(1000)>0) then
   if (mSecNow-LS.CLOCK.tim>DimDeadline) then begin
    bNul(sSetTag(LS.SERVID.tag,'Server Disconnected'));
    bNul(SetTagColor(LS.SERVID.tag,ColorWarn));
    bNul(SetTagColor(LS.CLOCK.tag,ColorWarn));
   end;
  end;
 end;
 
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  LAKESHORE_Clear;
 end;
 
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  LAKESHORE_Init;
  RunStartupScript;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
  cmd_DimTagUpdate          := RegisterStdInCmd('@DimTagUpdate',          '');
  cmd_Simulate              := RegisterStdInCmd('@Simulate',              '');
  cmd_PrintCmdTable         := RegisterStdInCmd('@PrintCmdTable',         '');
  cmd_Setting               := RegisterStdInCmd('@Setting',               '');
  cmd_Remote                := RegisterStdInCmd('@Remote',                '');
  cmd_Edit                  := RegisterStdInCmd('@Edit',                  '');
  cmd_BrowseHelp            := RegisterStdInCmd('@BrowseHelp',            '');
  cmd_OpenConsole           := RegisterStdInCmd('@OpenConsole',           '');
  cmd_MenuToolsOpen         := RegisterStdInCmd('@MenuToolsOpen',         '');
  cmd_LoadIni               := RegisterStdInCmd('@LoadIni',               '');
  cmd_SaveIni               := RegisterStdInCmd('@SaveIni',               '');
  cmd_MenuToolsConfirmation := RegisterStdInCmd('@MenuToolsConfirmation', '');
 end;
 
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  RunFinallyScript;
  LAKESHORE_Free;
 end;
 
 {
 User application Polling...
 }
 procedure PollApplication;
 var i,cs:Integer;
 begin
  LAKESHORE_Poll;
 end;
 
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid,tag,n,m:Integer; v:String;
  procedure SettingCmd(n:Integer; v:String);
  begin
   if IsValidCmdNum(n) then begin
    Success(cmd+' '+LS.Cmd.Acronym[n]+' '+v);
    LS.Cmd.Arg[n]:=v;
    EnableCmdNum(n,true);
   end;
  end;
  procedure CheckEditCmd(n,ch:Integer);
  begin
   if IsValidCmdNum(n) then
   if IsSameText(ExtractWord(1,arg)+' '+str(ch),LS.Cmd.Acronym[n])
   //or IsSameText(ExtractWord(1,arg),LS.Cmd.AnsHead[n]) 
   then
   StartEditTag(LS.Cmd.Tag[n],LS.Cmd.Acronym[n]+': '+LS.Cmd.Comment[n]);
  end;
  procedure UpdateLAKESHORECmd(n:Integer);
  begin
   if IsValidCmdNum(n) then
   if TypeTag(LS.Cmd.Tag[n])>=1 then
   if TypeTag(LS.Cmd.Tag[n])<=2 then
   DevPostCmd(DevMySelf,'@Setting '+LS.Cmd.Acronym[n]+' '+ TagAsText(LS.Cmd.Tag[n]));
  end;
  procedure OpenConsole(s:String);
  begin
   if IsEmptyStr(s) then s:=DevName;
   bNul(WinShow(ParamStr('Console '+s)));
   bNul(WinSelect(ParamStr('Console '+s)));
  end;
  procedure UpdateAoByTag(AoNum,tag:Integer);
  begin
   if (AoNum>=0) then begin
    if TypeTag(tag)=1 then UpdateAo(AoNum,time,iGetTag(tag));
    if TypeTag(tag)=2 then UpdateAo(AoNum,time,rGetTag(tag));
   end;
  end;
  procedure UpdateSettingsAfterLoadIni;
  begin
   if (iGetTag(LS.POLL_ENABLE.tag)<>0) then begin
   end;
  end;
  procedure CheckEdit(var n:Integer; s:String);
  begin
   if Pos('?',s)>0 then n:=n+1;
  end;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @DimTagUpdate tag
   }
   if (cmdid=cmd_DimTagUpdate) then begin
    if DIM_IsClientMode and not DIM_IsServerMode then begin
     tag:=FindTag(Trim(arg));
     if TypeTag(tag)>0 then begin
      if tag=LS.IdentificationQuery.tag              then UpdateAoByTag(ao_IdentificationQuery             ,tag);
      if tag=LS.MonitorOutParameterQuery.tag         then UpdateAoByTag(ao_MonitorOutParameterQuery        ,tag);
      if tag=LS.DiodeExcitationCurParrQuery.tag      then UpdateAoByTag(ao_DiodeExcitationCurParrQuery     ,tag);
      if tag=LS.InputFilterParameterQuery.tag        then UpdateAoByTag(ao_InputFilterParameterQuery       ,tag);
      if tag=LS.HeaterOutputQuery1.tag               then UpdateAoByTag(ao_HeaterOutputQuery1              ,tag);
      if tag=LS.HeaterOutputQuery2.tag               then UpdateAoByTag(ao_HeaterOutputQuery2              ,tag);
      if tag=LS.HeaterSetupQuery1.tag                then UpdateAoByTag(ao_HeaterSetupQuery1               ,tag);
      if tag=LS.HeatResist1.tag                      then UpdateAoByTag(ao_HeatResist1                     ,tag);
      if tag=LS.MaxCurrent1.tag                      then UpdateAoByTag(ao_MaxCurrent1                     ,tag);
      if tag=LS.HeaterSetupQuery2.tag                then UpdateAoByTag(ao_HeaterSetupQuery2               ,tag);
      if tag=LS.HeatResist2.tag                      then UpdateAoByTag(ao_HeatResist2                     ,tag);
      if tag=LS.MaxCurrent2.tag                      then UpdateAoByTag(ao_MaxCurrent2                     ,tag);
      if tag=LS.HeaterStatusQuery1.tag               then UpdateAoByTag(ao_HeaterStatusQuery1              ,tag);
      if tag=LS.HeaterStatusQuery2.tag               then UpdateAoByTag(ao_HeaterStatusQuery2              ,tag);
      if tag=LS.InputCurveNumberQueryA.tag           then UpdateAoByTag(ao_InputCurveNumberQueryA          ,tag);
      if tag=LS.InputCurveNumberQueryA.tag           then UpdateAoByTag(ao_InputCurveNumberQueryA          ,tag);
      if tag=LS.InputCurveNumberQueryB.tag           then UpdateAoByTag(ao_InputCurveNumberQueryB          ,tag);
      if tag=LS.InputTypeParameterQueryA.tag         then UpdateAoByTag(ao_InputTypeParameterQueryA        ,tag);
      if tag=LS.InputTypeParameterQueryB.tag         then UpdateAoByTag(ao_InputTypeParameterQueryB        ,tag);
      if tag=LS.KelvinReadingQueryA.tag              then UpdateAoByTag(ao_KelvinReadingQueryA             ,tag);
      if tag=LS.KelvinReadingQueryB.tag              then UpdateAoByTag(ao_KelvinReadingQueryB             ,tag);
      if tag=LS.MinimumMaximumDataQuery.tag          then UpdateAoByTag(ao_MinimumMaximumDataQuery         ,tag);
      if tag=LS.OutManualHeaterPowerOutQuery.tag     then UpdateAoByTag(ao_OutManualHeaterPowerOutQuery    ,tag);
      if tag=LS.OutputModeQuery1.tag                 then UpdateAoByTag(ao_OutputModeQuery1                ,tag);
      if tag=LS.OutputModeQuery2.tag                 then UpdateAoByTag(ao_OutputModeQuery2                ,tag);
      if tag=LS.OutVoltPolarityQuery.tag             then UpdateAoByTag(ao_OutVoltPolarityQuery            ,tag);
      if tag=LS.ControlLoopPIDValuesQuery1.tag       then UpdateAoByTag(ao_ControlLoopPIDValuesQuery1      ,tag);
      if tag=LS.ControlLoopPIDValuesQuery2.tag       then UpdateAoByTag(ao_ControlLoopPIDValuesQuery2      ,tag);
      if tag=LS.SetRampPar1.tag                      then UpdateAoByTag(ao_SetRampPar1                     ,tag);
      if tag=LS.SetRamp1.tag                         then UpdateAoByTag(ao_SetRamp1                        ,tag);
      if tag=LS.RampRate1.tag                        then UpdateAoByTag(ao_RampRate1                       ,tag);
      if tag=LS.SetRampPar2.tag                      then UpdateAoByTag(ao_SetRampPar2                     ,tag);
      if tag=LS.SetRamp2.tag                         then UpdateAoByTag(ao_SetRamp2                        ,tag);
      if tag=LS.RampRate2.tag                        then UpdateAoByTag(ao_RampRate2                       ,tag);
      if tag=LS.ControlSetpointRampStatQuery1.tag    then UpdateAoByTag(ao_ControlSetpointRampStatQuery1   ,tag);
      if tag=LS.ControlSetpointRampStatQuery2.tag    then UpdateAoByTag(ao_ControlSetpointRampStatQuery2   ,tag);
      if tag=LS.HeaterRangeQuery1.tag                then UpdateAoByTag(ao_HeaterRangeQuery1               ,tag);
      if tag=LS.HeaterRangeQuery2.tag                then UpdateAoByTag(ao_HeaterRangeQuery2               ,tag);
      if tag=LS.InputReadingStatusQueryA.tag         then UpdateAoByTag(ao_InputReadingStatusQueryA        ,tag);
      if tag=LS.InputReadingStatusQueryB.tag         then UpdateAoByTag(ao_InputReadingStatusQueryB        ,tag);
      if tag=LS.ControlSetpointQuery1.tag            then UpdateAoByTag(ao_ControlSetpointQuery1           ,tag);
      if tag=LS.ControlSetpointQuery2.tag            then UpdateAoByTag(ao_ControlSetpointQuery2           ,tag);
      if tag=LS.SensorUnitsInputReadingQuery.tag     then UpdateAoByTag(ao_SensorUnitsInputReadingQuery    ,tag);
      if tag=LS.ThermocoupleJunctionTempQuery.tag    then UpdateAoByTag(ao_ThermocoupleJunctionTempQuery   ,tag);
      if tag=LS.TemperatureLimitQuery.tag            then UpdateAoByTag(ao_TemperatureLimitQuery           ,tag);
      if tag=LS.ControlTuningStatusQuery1.tag        then UpdateAoByTag(ao_ControlTuningStatusQuery1       ,tag);
      if tag=LS.ControlTuningStatusQuery2.tag        then UpdateAoByTag(ao_ControlTuningStatusQuery2       ,tag);
      if tag=LS.WarmupSupplyParameterQuery1.tag      then UpdateAoByTag(ao_WarmupSupplyParameterQuery1     ,tag);
      if tag=LS.WarmupSupplyParameterQuery2.tag      then UpdateAoByTag(ao_WarmupSupplyParameterQuery2     ,tag);
      if tag=LS.OutputZoneTableParameterQuery.tag    then UpdateAoByTag(ao_OutputZoneTableParameterQuery   ,tag);
     end;                              
    end;                               
   end else                            
   {                                   
   @Setting SETP 20                  
   }
   if (cmdid=cmd_Setting) then begin
    if not LS.Simulator and not DIM_IsClientMode then begin
     n:=LAKESHORE_Cmd_Find(ExtractWord(1,arg));
     if IsValidCmdNum(n) then begin  
      v:=ExtractWord(2,arg)+','+ExtractWord(wordcount(arg),arg);
      if (n=cm_ControlSetpointCmd) then begin SettingCmd(n,v); end;
      if (n=cm_HeaterRangeCmd) then begin SettingCmd(n,v); end;     
      if (n=cm_AutotuneCmd) then begin SettingCmd(n,v); end;
      if (n=cm_InputCurveNumberCmd) then begin SettingCmd(n,v); end;
      if (n=cm_ControlSetpointRampParCmd) then begin 
       v:=ExtractWord(2,arg)+','+ExtractWord(3,arg)+','+ExtractWord(wordcount(arg),arg);
       SettingCmd(n,v);
      end;           
      if (n=cm_OutputModeCommand) then begin 
       v:=ExtractWord(2,arg)+','+ExtractWord(3,arg)+','+ExtractWord(4,arg)+','+ExtractWord(5,arg);
       SettingCmd(n,v);
      end;          
      if (n=cm_HeaterSetupCmd) then begin 
       v:=ExtractWord(2,arg)+','+ExtractWord(3,arg)+','+ExtractWord(4,arg)+','+ExtractWord(5,arg)+','+ExtractWord(6,arg)+','+ExtractWord(7,arg);
       SettingCmd(n,v);
      end;              
      if (n=cm_ControlLoopPIDValuesCmd) then begin 
       v:=ExtractWord(2,arg)+','+ExtractWord(3,arg)+','+ExtractWord(4,arg)+','+ExtractWord(5,arg);
       SettingCmd(n,v);
      end;      
      if (n=cm_InputTypeParameterCmd) then begin 
       v:=ExtractWord(2,arg)+','+ExtractWord(3,arg)+','+ExtractWord(4,arg)+','+ExtractWord(5,arg)+','+ExtractWord(6,arg)+','+ExtractWord(7,arg);
       SettingCmd(n,v);
      end;
     end;
    end;
    Data:='';
   end else 
   {
   @Edit SETP
   }
   if (cmdid=cmd_Edit) then begin
    if not LS.Simulator then begin
     n:=LAKESHORE_Cmd_Find(arg);
     if IsValidCmdNum(n) then begin
      
      if LAKESHORE_CheckPolling(1) then begin
       CheckEditCmd(n,Val(ExtractWord(2,arg)));
      end;
     end;
    end;
    Data:='';
   end else
   {
   @Simulate PZ 1.5 abs bar
   @Simulate KN 1234
   @Simulate TW 25
   @Simulate AZ 0
   -@Simulate MA 0.0
   -@Simulate ME 2.0
   -@Simulate PK 1.5
   }
   if (cmdid=cmd_Simulate) then begin
    if LS.Simulator then begin
     n:=LAKESHORE_Cmd_Find(ExtractWord(1,arg));
     if IsValidCmdNum(n) then begin
      //LS.Cmd.SimDat[n]:=rValDef(ExtractWord(2,arg),LS.Cmd.SimDat[n]);
      //Success(cmd+' '+LS.Cmd.Acronym[n]+' '+Str(LS.Cmd.SimDat[n]));
      LS.Cmd.SimStr[n]:=Trim(SkipWords(1,arg));
     end;
    end;
    Data:='';
   end else
   {
   @MenuToolsOpen
   }
   if (cmdid=cmd_MenuToolsOpen) then begin
    MenuToolsOpen;
    Data:='';
   end else
   {
   @MenuToolsConfirmation
   }
   if (cmdid = cmd_MenuToolsConfirmation) then begin
    if not LS.Simulator then begin
     if MenuToolsSelected>=0 then
     if EditState=0 then begin
      if Pos('?',Edit('(Вы действительно хотите:')
                +Edit(' ')
                +Edit(' '+arg)
                +Edit(' ')
                +Edit(' Эта операция может вызвать проблемы!')
                +Edit(')YesNo YesNo_'+MenuToolsIdent))>0
      then Problem('Could not initialize dialog!');
     end else Problem('Could not initialize dialog!');
    end;
    Data:='';
   end else
   {
   @BrowseHelp
   }
   if (cmdid=cmd_BrowseHelp) then begin
    rNul(Eval('@Global @Async @Silent @Run WebBrowser '+DaqFileRef(AdaptFileName(ReadIni('HelpFile')),'.htm')));
    Data:='';
   end else
   {
   @Remote
   }
   if (cmdid=cmd_Remote) then begin
    if not IsEmptyStr(arg) then PostCmdRemote(Trim(arg));
    Data:='';
   end else
   {
   @OpenConsole
   }
   if (cmdid=cmd_OpenConsole) then begin
    OpenConsole(arg);
    Data:='';
   end else
   {
   @PrintCmdTable
   }
   if (cmdid=cmd_PrintCmdTable) then begin
    PrintCmdTable;
    Data:='';
   end else
   {
   @LoadIni
   }
   if (cmdid=cmd_LoadIni) then begin
    if not LS.Simulator and not DIM_IsClientMode then begin
     iNul(CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg))));
     UpdateSettingsAfterLoadIni;
    end;
    Data:='';
   end else
   {
   @SaveIni
   }
   if (cmdid=cmd_SaveIni) then begin
    if not LS.Simulator and not DIM_IsClientMode then begin
     iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    end;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{<== Please never change this code ***}
{***************************************************}
