 {                                                                            
 ***********************************************************************
 Daq Pascal application program EDUTC_DRV.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @MenuToolsConfirmation - for internal use.
| @PrintCmdTable - Print Command Table state.
| @Simulate id v - Set simulation data v to id=(ARS,SRS, etc).
| @Setting id v  - Send command id with data v, id=(SRS).
| @Remote @cmd   - run @cmd remotely: send to DIM server
| @Edit id       - edit id (SRS)
| @BrowseHelp    - open help file in browser.
| @OpenConsole   - open driver console window.
| @MenuToolsOpen - open Menu Tools dialog.
| @LoadIni       - load params from INI file.
| @SaveIni       - save params to   INI file.
| @DimGuiClick   - handle remote click from DIM
|********************************************************
[]
 }
program EDUTC_DRV;                  { EDUTC driver                     }
const
 {---------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}               { Include all Standard constants,  }
 {---------------------------------}{ And add User defined constants:  }
 {$I _con_NetPfeiff}                { Include constants                }
 st_NoReq           = 0;            { Status : No request sent         }
 st_WaitAns         = 1;            { Status : Waiting answer          }
 st_WaitGap         = 2;            { Status : Waiting time gap        }
 st_TimeOut         = 3;            { Status : TimeOut found           }
 es_ERROR           = 'ERROR';      { Error string: error detected     }
 es_ERROR_CR        = 'ERROR CR';   { Error string: CR expected        }
 es_ERROR_ARG       = 'ERROR ARG';  { Error string: bad argument       }
 es_ERROR_LEN       = 'ERROR LEN';  { Error string: bad length         }
 es_ERROR_LRC       = 'ERROR LRC';  { Error string: bad checksum       }
 es_ERROR_DEF       = 'ERROR DEF';  { Error string: param doesnt exist }
 es_ERROR_RAN       = 'ERROR RAN';  { Error string: data out of range  }
 es_ERROR_LOG       = 'ERROR LOG';  { Error string: logic error        }
 
 dfStatist          = 32;           { DebugFlags - polling statistics  }
 cm_ERR             = 1;            {                                  }
 cm_Heating         = 2;            {                                  }
 cm_Standby         = 3;            {                                  }
 cm_RUTimeCtrl      = 4;            {                                  }
 cm_ErrorAckn       = 5;            {                                  }
 cm_PumpgStatn      = 6;            {                                  }
 cm_EnableVent      = 7;            {                                  }
 cm_CfgSpdSwPt      = 8;            {                                  }
 cm_CfgDO2          = 9;            {                                  }
 cm_MotorPump       = 10;           {                                  }
 cm_CfgDO1          = 11;           {                                  }
 cm_OpModeBKP       = 12;           {                                  }
 cm_SpdSetMode      = 13;           {                                  }
 cm_GasMode         = 14;           {                                  }
 cm_VentMode        = 15;           {                                  }
 cm_CfgAccA1        = 16;           {                                  }
 cm_CfgAccB1        = 17;           {                                  }
 cm_CfgAccA2        = 18;           {                                  }
 cm_CfgAccB2        = 19;           {                                  }
 cm_Press1HVen      = 20;           {                                  }
 cm_SealingGas      = 21;           {                                  }
 cm_CfgAO1          = 22;           {                                  }
 cm_CtrlVialnt      = 23;           {                                  }
 cm_IntSelLckd      = 24;           {                                  }
 cm_CfgDI1          = 25;           {                                  }
 cm_CfgDI2          = 26;           {                                  }
 cm_RemotePrio      = 27;           {                                  }
 cm_SpdSwPtAtt      = 28;           {                                  }
 cm_ErrorCode       = 29;           {                                  }
 cm_OvTempElec      = 30;           {                                  }
 cm_OvTempPump      = 31;           {                                  }
 cm_SetSpdAtt       = 32;           {                                  }
 cm_PumpAccel       = 33;           {                                  }
 cm_SetRotSpd       = 34;           {                                  }
 cm_ActualSpd       = 35;           {                                  }
 cm_DrvCurrent      = 36;           {                                  }
 cm_OpHrsPump       = 37;           {                                  }
 cm_FWVersion       = 38;           {                                  }
 cm_DrvVoltage      = 39;           {                                  }
 cm_OpHrsElec       = 40;           {                                  }
 cm_NominalSpd      = 41;           {                                  }
 cm_DrvPower        = 42;           {                                  }
 cm_PumpCycles      = 43;           {                                  }
 cm_TempElec        = 44;           {                                  }
 cm_TempPmpBot      = 45;           {                                  }
 cm_AccelDecel      = 46;           {                                  }
 cm_SealGasFlw      = 47;           {                                  }
 cm_TempBearng      = 48;           {                                  }
 cm_TempMotor       = 49;           {                                  }
 cm_ElecName        = 50;           {                                  }
 cm_HWVersion       = 51;           {                                  }
 cm_ErrHist1        = 52;           {                                  }
 cm_ErrHist2        = 53;           {                                  }
 cm_ErrHist3        = 54;           {                                  }
 cm_ErrHist4        = 55;           {                                  }
 cm_ErrHist5        = 56;           {                                  }
 cm_ErrHist6        = 57;           {                                  }
 cm_ErrHist7        = 58;           {                                  }
 cm_ErrHist8        = 59;           {                                  }
 cm_ErrHist9        = 60;           {                                  }
 cm_ErrHist10       = 61;           {                                  }
 cm_SetRotRPM       = 62;           {                                  }
 cm_ActualRPM       = 63;           {                                  }
 cm_NominalRPM      = 64;           {                                  }
 cm_RUTimeSVal      = 65;           {                                  }
 cm_SpdSwPt1        = 66;           {                                  }
 cm_SpdSVal         = 67;           {                                  }
 cm_PwrSVal         = 68;           {                                  }
 cm_SwOffBKP        = 69;           {                                  }
 cm_SwOnBKP         = 70;           {                                  }
 cm_StdbySVal       = 71;           {                                  }
 cm_SpdSwPt2        = 72;           {                                  }
 cm_VentSpd         = 73;           {                                  }
 cm_VentTime        = 74;           {                                  }
 cm_PrsSwPt1        = 75;           {                                  }
 cm_PrsSwPt2        = 76;           {                                  }
 cm_PrsSn1Name      = 77;           {                                  }
 cm_Pressure1       = 78;           {                                  }
 cm_PrsCorrPi1      = 79;           {                                  }
 cm_PrsSn2Name      = 80;           {                                  }
 cm_Pressure2       = 81;           {                                  }
 cm_PrsCorrPi2      = 82;           {                                  }
 cm_NomSpdConf      = 83;           {                                  }
 cm_SlgWrnThrs      = 84;           {                                  }
 cm_RS485Adr        = 85;           {                                  }
 cm_Pressure        = 86;           {                                  }
 cm_CtrName         = 87;           {                                  }
 cm_CtrSoftware     = 88;           {                                  }
 cm_ParamSet        = 90;           {                                  }
 cm_Servicelin      = 91;           {                                  }
 MaxCmdNum          = 92;           { Max command id number            }
                                    
 ao_POLL_RATE       = 0;            { Analog outputs...                }
 ao_ERROR_CNT       = 1;            {                                  }
 ao_PAR_Heating     = 2;            {                                  }
 ao_PAR_Standby     = 3;            {                                  }
 ao_PAR_RUTimeCtrl  = 4;            {                                  }
 ao_PAR_ErrorAckn   = 5;            {                                  }
 ao_PAR_PumpgStatn  = 6;            {                                  }
 ao_PAR_EnableVent  = 7;            {                                  }
 ao_PAR_CfgSpdSwPt  = 8;            {                                  }
 ao_PAR_CfgDO2      = 9;            {                                  }
 ao_PAR_MotorPump   = 10;           {                                  }
 ao_PAR_CfgDO1      = 11;           {                                  }
 ao_PAR_OpModeBKP   = 12;           {                                  }
 ao_PAR_SpdSetMode  = 13;           {                                  }
 ao_PAR_GasMode     = 14;           {                                  }
 ao_PAR_VentMode    = 15;           {                                  }
 ao_PAR_CfgAccA1    = 16;           {                                  }
 ao_PAR_CfgAccB1    = 17;           {                                  }
 ao_PAR_CfgAccA2    = 18;           {                                  }
 ao_PAR_CfgAccB2    = 19;           {                                  }
 ao_PAR_Press1HVen  = 20;           {                                  }
 ao_PAR_SealingGas  = 21;           {                                  }
 ao_PAR_CfgAO1      = 22;           {                                  }
 ao_PAR_CtrlVialnt  = 23;           {                                  }
 ao_PAR_IntSelLckd  = 24;           {                                  }
 ao_PAR_CfgDI1      = 25;           {                                  }
 ao_PAR_CfgDI2      = 26;           {                                  }
 ao_PAR_RemotePrio  = 27;           {                                  }
 ao_PAR_SpdSwPtAtt  = 28;           {                                  }
 ao_PAR_ErrorCode   = 29;           {                                  }
 ao_PAR_OvTempElec  = 30;           {                                  }
 ao_PAR_OvTempPump  = 31;           {                                  }
 ao_PAR_SetSpdAtt   = 32;           {                                  }
 ao_PAR_PumpAccel   = 33;           {                                  }
 ao_PAR_SetRotSpd   = 34;           {                                  }
 ao_PAR_ActualSpd   = 35;           {                                  }
 ao_PAR_DrvCurrent  = 36;           {                                  }
 ao_PAR_OpHrsPump   = 37;           {                                  }
 ao_PAR_FWVersion   = 38;           {                                  }
 ao_PAR_DrvVoltage  = 39;           {                                  }
 ao_PAR_OpHrsElec   = 40;           {                                  }
 ao_PAR_NominalSpd  = 41;           {                                  }
 ao_PAR_DrvPower    = 42;           {                                  }
 ao_PAR_PumpCycles  = 43;           {                                  }
 ao_PAR_TempElec    = 44;           {                                  }
 ao_PAR_TempPmpBot  = 45;           {                                  }
 ao_PAR_AccelDecel  = 46;           {                                  }
 ao_PAR_SealGasFlw  = 47;           {                                  }
 ao_PAR_TempBearng  = 48;           {                                  }
 ao_PAR_TempMotor   = 49;           {                                  }
 ao_PAR_ElecName    = 50;           {                                  }
 ao_PAR_HWVersion   = 51;           {                                  }
 ao_PAR_ErrHist1    = 52;           {                                  }
 ao_PAR_ErrHist2    = 53;           {                                  }
 ao_PAR_ErrHist3    = 54;           {                                  }
 ao_PAR_ErrHist4    = 55;           {                                  }
 ao_PAR_ErrHist5    = 56;           {                                  }
 ao_PAR_ErrHist6    = 57;           {                                  }
 ao_PAR_ErrHist7    = 58;           {                                  }
 ao_PAR_ErrHist8    = 59;           {                                  }
 ao_PAR_ErrHist9    = 60;           {                                  }
 ao_PAR_ErrHist10   = 61;           {                                  }
 ao_PAR_SetRotRPM   = 62;           {                                  }
 ao_PAR_ActualRPM   = 63;           {                                  }
 ao_PAR_NominalRPM  = 64;           {                                  }
 ao_PAR_RUTimeSVal  = 65;           {                                  }
 ao_PAR_SpdSwPt1    = 66;           {                                  }
 ao_PAR_SpdSVal     = 67;           {                                  }
 ao_PAR_PwrSVal     = 68;           {                                  }
 ao_PAR_SwOffBKP    = 69;           {                                  }
 ao_PAR_SwOnBKP     = 70;           {                                  }
 ao_PAR_StdbySVal   = 71;           {                                  }
 ao_PAR_SpdSwPt2    = 72;           {                                  }
 ao_PAR_VentSpd     = 73;           {                                  }
 ao_PAR_VentTime    = 74;           {                                  }
 ao_PAR_PrsSwPt1    = 75;           {                                  }
 ao_PAR_PrsSwPt2    = 76;           {                                  }
 ao_PAR_PrsSn1Name  = 77;           {                                  }
 ao_PAR_Pressure1   = 78;           {                                  }
 ao_PAR_PrsCorrPi1  = 79;           {                                  }
 ao_PAR_PrsSn2Name  = 80;           {                                  }
 ao_PAR_Pressure2   = 81;           {                                  }
 ao_PAR_PrsCorrPi2  = 82;           {                                  }
 ao_PAR_NomSpdConf  = 83;           {                                  }
 ao_PAR_SlgWrnThrs  = 84;           {                                  }
 ao_PAR_RS485Adr    = 85;           {                                  }
 ao_PAR_Pressure    = 86;           {                                  }
 ao_PAR_CtrName     = 87;           {                                  }
 ao_PAR_CtrSoftware = 88;           {                                  }
 ao_PAR_ParamSet    = 90;           {                                  }
 ao_PAR_Servicelin  = 91;           {                                  }
 do_POLLRATERX      = 101;          { DigitalOutput - Poll rate Rx     }
 do_POLLRATETX      = 102;          { DigitalOutput - Poll rate Tx     }
 do_POLLRATEEX      = 103;          { DigitalOutput - Poll rate Ex     }
 do_ERRORCOUNT      = 104;          { DigitalOutput - Error counter    }

 si_OFFLINE         = 'OFFLINE';    { To identify offline state        }
 DelayOnStart       = 1000;         { Delay before start polling       }

type
 {------------------------------}{ Declare uses program types:         }
 {$I _typ_StdLibrary}            { Include all Standard types,         }
 {------------------------------}{ And add User defined types:         }
 
var
 {------------------------------}{ Declare uses program variables:     }
 {$I _var_StdLibrary}            { Include all Standard variables,     }
 {------------------------------}{ And add User defined variables:     }
 {$I _var_NetPfeiff}             { Include constants                   }
 EDUTC             : record      { EDUTC data                          }
  Simulator        : Boolean;    { Simulator mode                      }
  Pfeiffer  : record             { Pfeiffer data record                }
   Port     : Integer;           { Logical Port on &PfeifferProxy      }
   UnitAdr  : Integer;           { Pfeiffer unit id                    }
   Timeout  : Integer;           { Pfeiffer timeout, ms                }
   Polling  : Integer;           { Pfeiffer polling period, ms         }
   Deadline : Integer;           { Pfeiffer deadline time, ms          }
   DrvName  : String;            { Model name like DCU01               }
   DelayOnStart : Integer;       { Command cycle delay on start        }
   Poll     : record             { Polling transaction data record     }
    ref     : Integer;           { Last sent device reference          }
    cid     : Integer;           { Last sent command id                }
    tim     : Real;              { Last polling time, ms               }
    port    : Integer;           { Last polling port                   }
    adr     : Integer;           { Last polling unit id                }
    par     : Integer;           { Last sent function id               }
    len     : Integer;           { Last sent lenity of registers       }
    dat     : String;            { Last sent PDU=(par+dat) data        }
    Rate    : record             { Poll rate on last second            }
     Rx     : Real;              { Rx poll rate - receiver             }
     Tx     : Real;              { Tx poll rate - transmitter          }
     Ex     : Real;              { Ex poll rate - errors               }
    end;                         {                                     }
   end;                          {                                     }
  end;                           {                                     }
  Cmd              : record      {  Command cycle data                 }
   Num      : Integer;           { Current running command number      }
   Enabled  : array [1..MaxCmdNum] of Boolean;  { Enable polling       }
   AoNum    : array [1..MaxCmdNum] of Integer;  { AoNum                }
   ParNum   : array [1..MaxCmdNum] of Integer;  { Pfeiffer Function Id }
   Comment  : array [1..MaxCmdNum] of String;   { Pfeiffer Comment     }
   Acronym  : array [1..MaxCmdNum] of String;   { Pfeiffer Acronym     }
   Min      : array [1..MaxCmdNum] of Integer;  { min of data          }
   Max      : array [1..MaxCmdNum] of Integer;  { max of data          }
   DType    : array [1..MaxCmdNum] of Integer;  { datatype             }
   Tag      : array [1..MaxCmdNum] of Integer;  { lenity of data       }
   OpData   : array [1..MaxCmdNum] of String;   { Operation data       }
   OpBuff   : array [1..MaxCmdNum] of String;   { Operation buffer     }
  end;                           {                                     }
  Sim       : record             { Simulator data                      }
   Param    : array [0..MaxCmdNum] of Integer;    {                    }
  end;                           {                                     }
  POLL_ENABLE      : TTagRef;    {                                     }
  POLL_RATE        : TTagRef;    {                                     }
  ERROR_CNT        : TTagRef;    {                                     }
  ID_NAME          : TTagRef;    {                                     }
  ID_IDN           : TTagRef;    {                                     }
  PAR_ERR          : TTagRef;    {                                     }
  PAR_Heating      : TTagRef;    {                                     }
  PAR_Standby      : TTagRef;    {                                     }
  PAR_RUTimeCtrl   : TTagRef;    {                                     }
  PAR_ErrorAckn    : TTagRef;    {                                     }
  PAR_PumpgStatn   : TTagRef;    {                                     }
  PAR_EnableVent   : TTagRef;    {                                     }
  PAR_CfgSpdSwPt   : TTagRef;    {                                     }
  PAR_CfgDO2       : TTagRef;    {                                     }
  PAR_MotorPump    : TTagRef;    {                                     }
  PAR_CfgDO1       : TTagRef;    {                                     }
  PAR_OpModeBKP    : TTagRef;    {                                     }
  PAR_SpdSetMode   : TTagRef;    {                                     }
  PAR_GasMode      : TTagRef;    {                                     }
  PAR_VentMode     : TTagRef;    {                                     }
  PAR_CfgAccA1     : TTagRef;    {                                     }
  PAR_CfgAccB1     : TTagRef;    {                                     }
  PAR_CfgAccA2     : TTagRef;    {                                     }
  PAR_CfgAccB2     : TTagRef;    {                                     }
  PAR_Press1HVen   : TTagRef;    {                                     }
  PAR_SealingGas   : TTagRef;    {                                     }
  PAR_CfgAO1       : TTagRef;    {                                     }
  PAR_CtrlVialnt   : TTagRef;    {                                     }
  PAR_IntSelLckd   : TTagRef;    {                                     }
  PAR_CfgDI1       : TTagRef;    {                                     }
  PAR_CfgDI2       : TTagRef;    {                                     }
  PAR_RemotePrio   : TTagRef;    {                                     }
  PAR_SpdSwPtAtt   : TTagRef;    {                                     }
  PAR_ErrorCode    : TTagRef;    {                                     }
  PAR_OvTempElec   : TTagRef;    {                                     }
  PAR_OvTempPump   : TTagRef;    {                                     }
  PAR_SetSpdAtt    : TTagRef;    {                                     }
  PAR_PumpAccel    : TTagRef;    {                                     }
  PAR_SetRotSpd    : TTagRef;    {                                     }
  PAR_ActualSpd    : TTagRef;    {                                     }
  PAR_DrvCurrent   : TTagRef;    {                                     }
  PAR_OpHrsPump    : TTagRef;    {                                     }
  PAR_FWVersion    : TTagRef;    {                                     }
  PAR_DrvVoltage   : TTagRef;    {                                     }
  PAR_OpHrsElec    : TTagRef;    {                                     }
  PAR_NominalSpd   : TTagRef;    {                                     }
  PAR_DrvPower     : TTagRef;    {                                     }
  PAR_PumpCycles   : TTagRef;    {                                     }
  PAR_TempElec     : TTagRef;    {                                     }
  PAR_TempPmpBot   : TTagRef;    {                                     }
  PAR_AccelDecel   : TTagRef;    {                                     }
  PAR_SealGasFlw   : TTagRef;    {                                     }
  PAR_TempBearng   : TTagRef;    {                                     }
  PAR_TempMotor    : TTagRef;    {                                     }
  PAR_ElecName     : TTagRef;    {                                     }
  PAR_HWVersion    : TTagRef;    {                                     }
  PAR_ErrHist1     : TTagRef;    {                                     }
  PAR_ErrHist2     : TTagRef;    {                                     }
  PAR_ErrHist3     : TTagRef;    {                                     }
  PAR_ErrHist4     : TTagRef;    {                                     }
  PAR_ErrHist5     : TTagRef;    {                                     }
  PAR_ErrHist6     : TTagRef;    {                                     }
  PAR_ErrHist7     : TTagRef;    {                                     }
  PAR_ErrHist8     : TTagRef;    {                                     }
  PAR_ErrHist9     : TTagRef;    {                                     }
  PAR_ErrHist10    : TTagRef;    {                                     }
  PAR_SetRotRPM    : TTagRef;    {                                     }
  PAR_ActualRPM    : TTagRef;    {                                     }
  PAR_NominalRPM   : TTagRef;    {                                     }
  PAR_RUTimeSVal   : TTagRef;    {                                     }
  PAR_SpdSwPt1     : TTagRef;    {                                     }
  PAR_SpdSVal      : TTagRef;    {                                     }
  PAR_PwrSVal      : TTagRef;    {                                     }
  PAR_SwOffBKP     : TTagRef;    {                                     }
  PAR_SwOnBKP      : TTagRef;    {                                     }
  PAR_StdbySVal    : TTagRef;    {                                     }
  PAR_SpdSwPt2     : TTagRef;    {                                     }
  PAR_VentSpd      : TTagRef;    {                                     }
  PAR_VentTime     : TTagRef;    {                                     }
  PAR_PrsSwPt1     : TTagRef;    {                                     }
  PAR_PrsSwPt2     : TTagRef;    {                                     }
  PAR_PrsSn1Name   : TTagRef;    {                                     }
  PAR_Pressure1    : TTagRef;    {                                     }
  PAR_PrsCorrPi1   : TTagRef;    {                                     }
  PAR_PrsSn2Name   : TTagRef;    {                                     }
  PAR_Pressure2    : TTagRef;    {                                     }
  PAR_PrsCorrPi2   : TTagRef;    {                                     }
  PAR_NomSpdConf   : TTagRef;    {                                     }
  PAR_SlgWrnThrs   : TTagRef;    {                                     }
  PAR_RS485Adr     : TTagRef;    {                                     }
  PAR_Pressure     : TTagRef;    {                                     }
  PAR_CtrName      : TTagRef;    {                                     }
  PAR_CtrSoftware  : TTagRef;    {                                     } 
  PAR_ParamSet     : TTagRef;    {                                     }            
  PAR_Servicelin   : TTagRef;    {                                     }            
  ModelCode        : Integer;    { Encoded model ranges (Tab index)    }
 end;                            {                                     }
 cmd_DimTagUpdate  : Integer;    { @DimTagUpdate                       }
 cmd_Simulate      : Integer;    { @Simulate                           }
 cmd_PrintCmdTable : Integer;    { @PrintCmdTable                      }
 cmd_Setting       : Integer;    { @Setting                            }
 cmd_Remote        : Integer;    { @Remote                             }
 cmd_Edit          : Integer;    { @Edit                               }
 cmd_BrowseHelp    : Integer;    { @BrowseHelp                         }
 cmd_OpenConsole   : Integer;    { @OpenConsole                        }
 cmd_MenuToolsOpen : Integer;    { @MenuToolsOpen                      }
 cmd_LoadIni       : Integer;    { @LoadIni                            }
 cmd_SaveIni       : Integer;    { @SaveIni                            }
 cmd_MenuToolsConfirmation:Integer;{ Command @MenuToolsConfirmation    }
 MenuToolsSelected : Integer;    { MenuTools selected item index       }
                                                                       
 {------------------------------}{ Declare procedures & functions:     }
 {$I _fun_StdLibrary}            { Include all Standard functions,     }
 {------------------------------}{ And add User defined functions:     }
 {$I _fun_NetPfeiff}             { Include functions                   }
 
 function IsValidCmdNum(Num:Integer):Boolean;
 begin
  IsValidCmdNum:=(1<=Num) and (Num<=MaxCmdNum);
 end;
 function ValidateCmdNum(Num:Integer):Integer;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then ValidateCmdNum:=Num
  else ValidateCmdNum:=1;
 end;
 
 function IsUsableCmdNum(Num:Integer):Boolean;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then IsUsableCmdNum:=True
  else IsUsableCmdNum:=False;
 end;
 
 function IsEnabledCmdNum(Num:Integer):Boolean;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then IsEnabledCmdNum:=(Num<>0) and EDUTC.Cmd.Enabled[Num]
  else IsEnabledCmdNum:=False;
 end;
 
 function NextEnabledCmdNum(Num:Integer):Integer;
 var i:Integer;
 begin
  i:=0;
  while (i<MaxCmdNum) do begin
   Num:=ValidateCmdNum(Num+1);
   if IsEnabledCmdNum(Num)
   then i:=MaxCmdNum
   else i:=i+1;
  end;
  NextEnabledCmdNum:=Num;
 end;
 
 {
 Answer Length by Command Number
 0 Bool, 1 Int, 2 Real, 4 String, 7 ShortInt
 }
 function DataFormatLength(cm:integer):Integer;
 var df:integer;
 begin
  df:=EDUTC.Cmd.DType[cm];
  case df of
   0: DataFormatLength:=6;  // boolean_old
   1: DataFormatLength:=6;  // u_integer
   2: DataFormatLength:=6;  // u_real
   3: DataFormatLength:=6;  // u_expo
   4: DataFormatLength:=6;  // string
   //5: Vector?;            
   6: DataFormatLength:=1;  // boolean_new
   7: DataFormatLength:=3;  // u_short_int
   9: DataFormatLength:=6;  // tms_old
   10:DataFormatLength:=6;  // u_expo_new
   11:DataFormatLength:=16; // string16
   12:DataFormatLength:=8;  // string8
  end;
 end;

 {
 Nice tooltip notifier.
 }
 procedure NiceNotify(aText:String; aDelay:Integer);
 begin
  if Length(aText)>0 then begin
   ShowTooltip('text "'+aText+'" preset stdNotify delay '+Str(aDelay));
  end;
 end;
 
 {
 Post command to local/remote server.
 }
 procedure PostCmdLocal(cmd:String);
 begin
  DevPostCmd(devMySelf,cmd);
 end;
 
 procedure PostCmdRemote(cmd:String);
 begin
  Dim_GuiConsoleSend(DevName,cmd);
 end;
 
 {
 Check ModelCode is valid or return zero.
 }
 function CheckModelCode(ModelCode:Integer):Integer;
 begin
  if (ModelCode<1) then ModelCode:=0 else
  CheckModelCode:=ModelCode;
 end;
 
 {
 Parse IDN string like 'TC110', find ModelCode.
 }
 function EDUTC_ParseIDN(IDN:String; silent:Boolean):Integer;
 var ModelCode:Integer;
 begin
  ModelCode:=0; IDN:=Trim(IDN);
  if not IsSameText(IDN,si_OFFLINE) then ModelCode:=1;
  if not silent then
  if CheckModelCode(ModelCode)>0 
  then Success('Detected IDN: '+IDN)
  else Problem('Fail detect IDN: '+IDN);
  EDUTC_ParseIDN:=ModelCode;
 end;
 
 {
 Find command by id (Acronym).
 }
 function EDUTC_Cmd_Find(id:String):Integer;
 var i,n:Integer;
 begin
  n:=0;
  if (Length(id)>0) then
   for i:=1 to MaxCmdNum do if n=0 then
   if IsSameText(id,EDUTC.Cmd.Acronym[i])
   then n:=i;
  EDUTC_Cmd_Find:=n;
 end;
 
 {
 Initialize tag refreshment value.
 }
 procedure EDUTC_FillTag(tag:Integer; InitVal:Real);
  procedure Process(var R:TTagRef);
  begin
   if (R.tag=tag) then bNul(ShouldRefresh(R.val,InitVal)>0);
  end;
 begin
  if (TypeTag(tag)>0) then begin
   Process(EDUTC.POLL_ENABLE);
   Process(EDUTC.POLL_RATE);
   Process(EDUTC.ERROR_CNT);
   Process(EDUTC.ID_NAME);
   Process(EDUTC.ID_IDN);
   Process(EDUTC.PAR_Heating);
   Process(EDUTC.PAR_Standby);
   Process(EDUTC.PAR_RUTimeCtrl);
   Process(EDUTC.PAR_ErrorAckn);
   Process(EDUTC.PAR_PumpgStatn);
   Process(EDUTC.PAR_EnableVent);
   Process(EDUTC.PAR_CfgSpdSwPt);
   Process(EDUTC.PAR_CfgDO2);
   Process(EDUTC.PAR_MotorPump);
   Process(EDUTC.PAR_CfgDO1);
   Process(EDUTC.PAR_OpModeBKP);
   Process(EDUTC.PAR_SpdSetMode);
   Process(EDUTC.PAR_GasMode);
   Process(EDUTC.PAR_VentMode);
   Process(EDUTC.PAR_CfgAccA1);
   Process(EDUTC.PAR_CfgAccB1);
   Process(EDUTC.PAR_CfgAccA2);
   Process(EDUTC.PAR_CfgAccB2);
   Process(EDUTC.PAR_Press1HVen);
   Process(EDUTC.PAR_SealingGas);
   Process(EDUTC.PAR_CfgAO1);
   Process(EDUTC.PAR_CtrlVialnt);
   Process(EDUTC.PAR_IntSelLckd);
   Process(EDUTC.PAR_CfgDI1);
   Process(EDUTC.PAR_CfgDI2);
   Process(EDUTC.PAR_RemotePrio);
   Process(EDUTC.PAR_SpdSwPtAtt);
   Process(EDUTC.PAR_ErrorCode);
   Process(EDUTC.PAR_OvTempElec);
   Process(EDUTC.PAR_OvTempPump);
   Process(EDUTC.PAR_SetSpdAtt);
   Process(EDUTC.PAR_PumpAccel);
   Process(EDUTC.PAR_SetRotSpd);
   Process(EDUTC.PAR_ActualSpd);
   Process(EDUTC.PAR_DrvCurrent);
   Process(EDUTC.PAR_OpHrsPump);
   Process(EDUTC.PAR_FWVersion);
   Process(EDUTC.PAR_DrvVoltage);
   Process(EDUTC.PAR_OpHrsElec);
   Process(EDUTC.PAR_NominalSpd);
   Process(EDUTC.PAR_DrvPower);
   Process(EDUTC.PAR_PumpCycles);
   Process(EDUTC.PAR_TempElec);
   Process(EDUTC.PAR_TempPmpBot);
   Process(EDUTC.PAR_AccelDecel);
   Process(EDUTC.PAR_SealGasFlw);
   Process(EDUTC.PAR_TempBearng);
   Process(EDUTC.PAR_TempMotor);
   Process(EDUTC.PAR_ElecName);
   Process(EDUTC.PAR_HWVersion);
   Process(EDUTC.PAR_ErrHist1);
   Process(EDUTC.PAR_ErrHist2);
   Process(EDUTC.PAR_ErrHist3);
   Process(EDUTC.PAR_ErrHist4);
   Process(EDUTC.PAR_ErrHist5);
   Process(EDUTC.PAR_ErrHist6);
   Process(EDUTC.PAR_ErrHist7);
   Process(EDUTC.PAR_ErrHist8);
   Process(EDUTC.PAR_ErrHist9);
   Process(EDUTC.PAR_ErrHist10);
   Process(EDUTC.PAR_SetRotSpd);
   Process(EDUTC.PAR_ActualSpd);
   Process(EDUTC.PAR_NominalSpd);
   Process(EDUTC.PAR_RUTimeSVal);
   Process(EDUTC.PAR_SpdSwPt1);
   Process(EDUTC.PAR_SpdSVal);
   Process(EDUTC.PAR_PwrSVal);
   Process(EDUTC.PAR_SwOffBKP);
   Process(EDUTC.PAR_SwOnBKP);
   Process(EDUTC.PAR_StdbySVal);
   Process(EDUTC.PAR_SpdSwPt2);
   Process(EDUTC.PAR_VentSpd);
   Process(EDUTC.PAR_VentTime);
   Process(EDUTC.PAR_PrsSwPt1);
   Process(EDUTC.PAR_PrsSwPt2);
   Process(EDUTC.PAR_PrsSn1Name);
   Process(EDUTC.PAR_Pressure1);
   Process(EDUTC.PAR_PrsCorrPi1);
   Process(EDUTC.PAR_PrsSn2Name);
   Process(EDUTC.PAR_Pressure2);
   Process(EDUTC.PAR_PrsCorrPi2);
   Process(EDUTC.PAR_NomSpdConf);
   Process(EDUTC.PAR_SlgWrnThrs);
   Process(EDUTC.PAR_RS485Adr);
   Process(EDUTC.PAR_Pressure);
   Process(EDUTC.PAR_CtrName);
   Process(EDUTC.PAR_CtrSoftware);
   Process(EDUTC.PAR_ParamSet);
   Process(EDUTC.PAR_Servicelin);
  end;           
 end;            
 
 {
 Initialize tags.
 }
 procedure EDUTC_FillTags(InitVal:Real);
 begin
  EDUTC.POLL_ENABLE.val     :=InitVal;
  EDUTC.POLL_RATE.val       :=InitVal;
  EDUTC.ERROR_CNT.val       :=InitVal;
  EDUTC.ID_NAME.val         :=InitVal;
  EDUTC.ID_IDN.val          :=InitVal;
  EDUTC.PAR_Heating.val     :=InitVal;
  EDUTC.PAR_Standby.val     :=InitVal;
  EDUTC.PAR_RUTimeCtrl.val  :=InitVal;
  EDUTC.PAR_ErrorAckn.val   :=InitVal;
  EDUTC.PAR_PumpgStatn.val  :=InitVal;
  EDUTC.PAR_EnableVent.val  :=InitVal;
  EDUTC.PAR_CfgSpdSwPt.val  :=InitVal;
  EDUTC.PAR_CfgDO2.val      :=InitVal;
  EDUTC.PAR_MotorPump.val   :=InitVal;
  EDUTC.PAR_CfgDO1.val      :=InitVal;
  EDUTC.PAR_OpModeBKP.val   :=InitVal;
  EDUTC.PAR_SpdSetMode.val  :=InitVal;
  EDUTC.PAR_GasMode.val     :=InitVal;
  EDUTC.PAR_VentMode.val    :=InitVal;
  EDUTC.PAR_CfgAccA1.val    :=InitVal;
  EDUTC.PAR_CfgAccB1.val    :=InitVal;
  EDUTC.PAR_CfgAccA2.val    :=InitVal;
  EDUTC.PAR_CfgAccB2.val    :=InitVal;
  EDUTC.PAR_Press1HVen.val  :=InitVal;
  EDUTC.PAR_SealingGas.val  :=InitVal;
  EDUTC.PAR_CfgAO1.val      :=InitVal;
  EDUTC.PAR_CtrlVialnt.val  :=InitVal;
  EDUTC.PAR_IntSelLckd.val  :=InitVal;
  EDUTC.PAR_CfgDI1.val      :=InitVal;
  EDUTC.PAR_CfgDI2.val      :=InitVal;
  EDUTC.PAR_RemotePrio.val  :=InitVal;
  EDUTC.PAR_SpdSwPtAtt.val  :=InitVal;
  EDUTC.PAR_ErrorCode.val   :=InitVal;
  EDUTC.PAR_OvTempElec.val  :=InitVal;
  EDUTC.PAR_OvTempPump.val  :=InitVal;
  EDUTC.PAR_SetSpdAtt.val   :=InitVal;
  EDUTC.PAR_PumpAccel.val   :=InitVal;
  EDUTC.PAR_SetRotSpd.val   :=InitVal;
  EDUTC.PAR_ActualSpd.val   :=InitVal;
  EDUTC.PAR_DrvCurrent.val  :=InitVal;
  EDUTC.PAR_OpHrsPump.val   :=InitVal;
  EDUTC.PAR_FWVersion.val   :=InitVal;
  EDUTC.PAR_DrvVoltage.val  :=InitVal;
  EDUTC.PAR_OpHrsElec.val   :=InitVal;
  EDUTC.PAR_NominalSpd.val  :=InitVal;
  EDUTC.PAR_DrvPower.val    :=InitVal;
  EDUTC.PAR_PumpCycles.val  :=InitVal;
  EDUTC.PAR_TempElec.val    :=InitVal;
  EDUTC.PAR_TempPmpBot.val  :=InitVal;
  EDUTC.PAR_AccelDecel.val  :=InitVal;
  EDUTC.PAR_SealGasFlw.val  :=InitVal;
  EDUTC.PAR_TempBearng.val  :=InitVal;
  EDUTC.PAR_TempMotor.val   :=InitVal;
  EDUTC.PAR_ElecName.val    :=InitVal;
  EDUTC.PAR_HWVersion.val   :=InitVal;
  EDUTC.PAR_ErrHist1.val    :=InitVal;
  EDUTC.PAR_ErrHist2.val    :=InitVal;
  EDUTC.PAR_ErrHist3.val    :=InitVal;
  EDUTC.PAR_ErrHist4.val    :=InitVal;
  EDUTC.PAR_ErrHist5.val    :=InitVal;
  EDUTC.PAR_ErrHist6.val    :=InitVal;
  EDUTC.PAR_ErrHist7.val    :=InitVal;
  EDUTC.PAR_ErrHist8.val    :=InitVal;
  EDUTC.PAR_ErrHist9.val    :=InitVal;
  EDUTC.PAR_ErrHist10.val   :=InitVal;
  EDUTC.PAR_SetRotSpd.val   :=InitVal;
  EDUTC.PAR_ActualSpd.val   :=InitVal;
  EDUTC.PAR_NominalSpd.val  :=InitVal;
  EDUTC.PAR_RUTimeSVal.val  :=InitVal;
  EDUTC.PAR_SpdSwPt1.val    :=InitVal;
  EDUTC.PAR_SpdSVal.val     :=InitVal;
  EDUTC.PAR_PwrSVal.val     :=InitVal;
  EDUTC.PAR_SwOffBKP.val    :=InitVal;
  EDUTC.PAR_SwOnBKP.val     :=InitVal;
  EDUTC.PAR_StdbySVal.val   :=InitVal;
  EDUTC.PAR_SpdSwPt2.val    :=InitVal;
  EDUTC.PAR_VentSpd.val     :=InitVal;
  EDUTC.PAR_VentTime.val    :=InitVal;
  EDUTC.PAR_PrsSwPt1.val    :=InitVal;
  EDUTC.PAR_PrsSwPt2.val    :=InitVal;
  EDUTC.PAR_PrsSn1Name.val  :=InitVal;
  EDUTC.PAR_Pressure1.val   :=InitVal;
  EDUTC.PAR_PrsCorrPi1.val  :=InitVal;
  EDUTC.PAR_PrsSn2Name.val  :=InitVal;
  EDUTC.PAR_Pressure2.val   :=InitVal;
  EDUTC.PAR_PrsCorrPi2.val  :=InitVal;
  EDUTC.PAR_NomSpdConf.val  :=InitVal;
  EDUTC.PAR_SlgWrnThrs.val  :=InitVal;
  EDUTC.PAR_RS485Adr.val    :=InitVal;
  EDUTC.PAR_Pressure.val    :=InitVal;
  EDUTC.PAR_CtrName.val     :=InitVal;
  EDUTC.PAR_CtrSoftware.val :=InitVal;
  EDUTC.PAR_ParamSet.val    :=InitVal;
  EDUTC.PAR_Servicelin.val  :=InitVal;
 end;   
        
 procedure EDUTC_InitTags(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   DIM_GuiClickInit(Prefix+'.DIMGUICLICK');
   InitTag(EDUTC.POLL_ENABLE.tag,      Prefix+'.POLL_ENABLE',     1); 
   InitTag(EDUTC.POLL_RATE.tag,        Prefix+'.POLL_RATE',       2);
   InitTag(EDUTC.ERROR_CNT.tag,        Prefix+'.ERROR_CNT',       2);
   InitTag(EDUTC.ID_NAME.tag,          Prefix+'.ID_NAME',         3);
   InitTag(EDUTC.ID_IDN.tag,           Prefix+'.ID_IDN',          3);
   
   InitTag(EDUTC.PAR_Heating.tag,      Prefix+'.PAR_Heating',     1);
   InitTag(EDUTC.PAR_Standby.tag,      Prefix+'.PAR_Standby',     1);
   InitTag(EDUTC.PAR_RUTimeCtrl.tag,   Prefix+'.PAR_RUTimeCtrl',  1);
   InitTag(EDUTC.PAR_ErrorAckn.tag,    Prefix+'.PAR_ErrorAckn',   1);
   InitTag(EDUTC.PAR_PumpgStatn.tag,   Prefix+'.PAR_PumpgStatn',  1);
   InitTag(EDUTC.PAR_EnableVent.tag,   Prefix+'.PAR_EnableVent',  1);
   InitTag(EDUTC.PAR_CfgSpdSwPt.tag,   Prefix+'.PAR_CfgSpdSwPt',  1);
   InitTag(EDUTC.PAR_CfgDO2.tag,       Prefix+'.PAR_CfgDO2',      1);
   InitTag(EDUTC.PAR_MotorPump.tag,    Prefix+'.PAR_MotorPump',   1);
   InitTag(EDUTC.PAR_CfgDO1.tag,       Prefix+'.PAR_CfgDO1',      1);
   InitTag(EDUTC.PAR_OpModeBKP.tag,    Prefix+'.PAR_OpModeBKP',   1);
   InitTag(EDUTC.PAR_SpdSetMode.tag,   Prefix+'.PAR_SpdSetMode',  1);
   InitTag(EDUTC.PAR_GasMode.tag,      Prefix+'.PAR_GasMode',     1);
   InitTag(EDUTC.PAR_VentMode.tag,     Prefix+'.PAR_VentMode',    1);
   InitTag(EDUTC.PAR_CfgAccA1.tag,     Prefix+'.PAR_CfgAccA1',    1);
   InitTag(EDUTC.PAR_CfgAccB1.tag,     Prefix+'.PAR_CfgAccB1',    1);
   InitTag(EDUTC.PAR_CfgAccA2.tag,     Prefix+'.PAR_CfgAccA2',    1);
   InitTag(EDUTC.PAR_CfgAccB2.tag,     Prefix+'.PAR_CfgAccB2',    1);
   InitTag(EDUTC.PAR_Press1HVen.tag,   Prefix+'.PAR_Press1HVen',  1);
   InitTag(EDUTC.PAR_SealingGas.tag,   Prefix+'.PAR_SealingGas',  1);
   InitTag(EDUTC.PAR_CfgAO1.tag,       Prefix+'.PAR_CfgAO1',      1);
   InitTag(EDUTC.PAR_CtrlVialnt.tag,   Prefix+'.PAR_CtrlVialnt',  1);
   InitTag(EDUTC.PAR_IntSelLckd.tag,   Prefix+'.PAR_IntSelLckd',  1);
   InitTag(EDUTC.PAR_CfgDI1.tag,       Prefix+'.PAR_CfgDI1',      1);
   InitTag(EDUTC.PAR_CfgDI2.tag,       Prefix+'.PAR_CfgDI2',      1);
   InitTag(EDUTC.PAR_RemotePrio.tag,   Prefix+'.PAR_RemotePrio',  1);
   InitTag(EDUTC.PAR_SpdSwPtAtt.tag,   Prefix+'.PAR_SpdSwPtAtt',  1);
   InitTag(EDUTC.PAR_ErrorCode.tag,    Prefix+'.PAR_ErrorCode',   3);
   InitTag(EDUTC.PAR_OvTempElec.tag,   Prefix+'.PAR_OvTempElec',  1);
   InitTag(EDUTC.PAR_OvTempPump.tag,   Prefix+'.PAR_OvTempPump',  1);
   InitTag(EDUTC.PAR_SetSpdAtt.tag,    Prefix+'.PAR_SetSpdAtt',   1);
   InitTag(EDUTC.PAR_PumpAccel.tag,    Prefix+'.PAR_PumpAccel',   1);
   InitTag(EDUTC.PAR_SetRotSpd.tag,    Prefix+'.PAR_SetRotSpd',   1);
   InitTag(EDUTC.PAR_ActualSpd.tag,    Prefix+'.PAR_ActualSpd',   1);
   InitTag(EDUTC.PAR_DrvCurrent.tag,   Prefix+'.PAR_DrvCurrent',  2);
   InitTag(EDUTC.PAR_OpHrsPump.tag,    Prefix+'.PAR_OpHrsPump',   1);
   InitTag(EDUTC.PAR_FWVersion.tag,    Prefix+'.PAR_FWVersion',   3);
   InitTag(EDUTC.PAR_DrvVoltage.tag,   Prefix+'.PAR_DrvVoltage',  2);
   InitTag(EDUTC.PAR_OpHrsElec.tag,    Prefix+'.PAR_OpHrsElec',   1);
   InitTag(EDUTC.PAR_NominalSpd.tag,   Prefix+'.PAR_NominalSpd',  1);
   InitTag(EDUTC.PAR_DrvPower.tag,     Prefix+'.PAR_DrvPower',    1);
   InitTag(EDUTC.PAR_PumpCycles.tag,   Prefix+'.PAR_PumpCycles',  1);
   InitTag(EDUTC.PAR_TempElec.tag,     Prefix+'.PAR_TempElec',    1);
   InitTag(EDUTC.PAR_TempPmpBot.tag,   Prefix+'.PAR_TempPmpBot',  1);
   InitTag(EDUTC.PAR_AccelDecel.tag,   Prefix+'.PAR_AccelDecel',  1);
   InitTag(EDUTC.PAR_SealGasFlw.tag,   Prefix+'.PAR_SealGasFlw',  1);
   InitTag(EDUTC.PAR_TempBearng.tag,   Prefix+'.PAR_TempBearng',  1);
   InitTag(EDUTC.PAR_TempMotor.tag,    Prefix+'.PAR_TempMotor',   1);
   InitTag(EDUTC.PAR_ElecName.tag,     Prefix+'.PAR_ElecName',    3);
   InitTag(EDUTC.PAR_HWVersion.tag,    Prefix+'.PAR_HWVersion',   3);
   InitTag(EDUTC.PAR_ErrHist1.tag,     Prefix+'.PAR_ErrHist1',    3);
   InitTag(EDUTC.PAR_ErrHist2.tag,     Prefix+'.PAR_ErrHist2',    3);
   InitTag(EDUTC.PAR_ErrHist3.tag,     Prefix+'.PAR_ErrHist3',    3);
   InitTag(EDUTC.PAR_ErrHist4.tag,     Prefix+'.PAR_ErrHist4',    3);
   InitTag(EDUTC.PAR_ErrHist5.tag,     Prefix+'.PAR_ErrHist5',    3);
   InitTag(EDUTC.PAR_ErrHist6.tag,     Prefix+'.PAR_ErrHist6',    3);
   InitTag(EDUTC.PAR_ErrHist7.tag,     Prefix+'.PAR_ErrHist7',    3);
   InitTag(EDUTC.PAR_ErrHist8.tag,     Prefix+'.PAR_ErrHist8',    3);
   InitTag(EDUTC.PAR_ErrHist9.tag,     Prefix+'.PAR_ErrHist9',    3);
   InitTag(EDUTC.PAR_ErrHist10.tag,    Prefix+'.PAR_ErrHist10',   3);
   InitTag(EDUTC.PAR_SetRotSpd.tag,    Prefix+'.PAR_SetRotSpd',   1);
   InitTag(EDUTC.PAR_ActualSpd.tag,    Prefix+'.PAR_ActualSpd',   1);
   InitTag(EDUTC.PAR_NominalSpd.tag,   Prefix+'.PAR_NominalSpd',  1);
   InitTag(EDUTC.PAR_RUTimeSVal.tag,   Prefix+'.PAR_RUTimeSVal',  1);
   InitTag(EDUTC.PAR_SpdSwPt1.tag,     Prefix+'.PAR_SpdSwPt1',    1);
   InitTag(EDUTC.PAR_SpdSVal.tag,      Prefix+'.PAR_SpdSVal',     2);
   InitTag(EDUTC.PAR_PwrSVal.tag,      Prefix+'.PAR_PwrSVal',     1);
   InitTag(EDUTC.PAR_SwOffBKP.tag,     Prefix+'.PAR_SwOffBKP',    1);
   InitTag(EDUTC.PAR_SwOnBKP.tag,      Prefix+'.PAR_SwOnBKP',     1);
   InitTag(EDUTC.PAR_StdbySVal.tag,    Prefix+'.PAR_StdbySVal',   2);
   InitTag(EDUTC.PAR_SpdSwPt2.tag,     Prefix+'.PAR_SpdSwPt2',    1);
   InitTag(EDUTC.PAR_VentSpd.tag,      Prefix+'.PAR_VentSpd',     1);
   InitTag(EDUTC.PAR_VentTime.tag,     Prefix+'.PAR_VentTime',    1);
   InitTag(EDUTC.PAR_PrsSwPt1.tag,     Prefix+'.PAR_PrsSwPt1',    1);
   InitTag(EDUTC.PAR_PrsSwPt2.tag,     Prefix+'.PAR_PrsSwPt2',    1);
   InitTag(EDUTC.PAR_PrsSn1Name.tag,   Prefix+'.PAR_PrsSn1Name',  3);
   InitTag(EDUTC.PAR_Pressure1.tag,    Prefix+'.PAR_Pressure1',   1);
   InitTag(EDUTC.PAR_PrsCorrPi1.tag,   Prefix+'.PAR_PrsCorrPi1',  2);
   InitTag(EDUTC.PAR_PrsSn2Name.tag,   Prefix+'.PAR_PrsSn2Name',  3);
   InitTag(EDUTC.PAR_Pressure2.tag,    Prefix+'.PAR_Pressure2',   1);
   InitTag(EDUTC.PAR_PrsCorrPi2.tag,   Prefix+'.PAR_PrsCorrPi2',  2);
   InitTag(EDUTC.PAR_NomSpdConf.tag,   Prefix+'.PAR_NomSpdConf',  1);
   InitTag(EDUTC.PAR_SlgWrnThrs.tag,   Prefix+'.PAR_SlgWrnThrs',  1);
   InitTag(EDUTC.PAR_RS485Adr.tag,     Prefix+'.PAR_RS485Adr',    1);
   InitTag(EDUTC.PAR_Pressure.tag,     Prefix+'.PAR_Pressure',    1);
   InitTag(EDUTC.PAR_CtrName.tag,      Prefix+'.PAR_CtrName',     3);
   InitTag(EDUTC.PAR_CtrSoftware.tag,  Prefix+'.PAR_CtrSoftware', 3);
   InitTag(EDUTC.PAR_ParamSet.tag,     Prefix+'.PAR_ParamSet',    1);
   InitTag(EDUTC.PAR_Servicelin.tag,   Prefix+'.PAR_Servicelin',  1);
   EDUTC_FillTags(-MaxReal);
  end;
 end;
 
 {
 Update DIM tag in server mode.
 }
 procedure UpdateDimTag(tag:Integer);
 var v:Real;
 begin
  if DIM_IsServerMode then
  if (TypeTag(tag)>0) then begin
   v:=GetStampOfTag(tag,_NaN);
   if not IsNan(v) then EDUTC_FillTag(tag,v);
   DIM_UpdateTag(tag,'');
  end;
 end;
 
 {
 Check if COM port opened.
 }
 function IsComPortOpened:Boolean;
 begin
  IsComPortOpened:=(ComSpace>=0);
 end;
 
 {
 Find the current Proxy device to send @Pfeiffer.Poll message.
 }
 function devTheProxy:Integer;
 begin
  if EDUTC.Simulator                  // In simulation mode
  then devTheProxy:=devMySelf         // send messages to himself
  else devTheProxy:=devPfeifferProxy; // otherwise use &PfeifferProxy
 end;
 
 {
 Check if communication port is opened or not.
 As long as we use Proxy device, check Port number & device reference.
 }
 function IsPortOpened:Boolean;
 begin
  IsPortOpened:=(EDUTC.Pfeiffer.Port>0) and (devTheProxy<>0);
 end;
 
 {
 Enable/disable command n.
 }
 procedure EnableCmdNum(n:Integer; Enabled:Boolean);
 begin
  if IsValidCmdNum(n) then EDUTC.Cmd.Enabled[n]:=Enabled;
 end;
 
 procedure HoldCmdOpData(Num:Integer; OpData:String);
 begin
  if IsUsableCmdNum(Num) then begin
   { EDUTC.Cmd.Enabled[Num]:=not IsNaN(OpData); }
   EnableCmdNum(Num,true);
   EDUTC.Cmd.OpBuff[Num]:=OpData;
  end;
 end;
 
 procedure ApplyCmdOpData(Num:Integer);
 begin
  if IsUsableCmdNum(Num) then
  if not (EDUTC.Cmd.OpBuff[Num]='') then begin
   EDUTC.Cmd.OpData[Num]:=EDUTC.Cmd.OpBuff[Num];
   EDUTC.Cmd.OpBuff[Num]:='';
  end;
 end;
 
 procedure ReleaseCmdOpData(Num:Integer);
 begin
  if IsUsableCmdNum(Num) then HoldCmdOpData(Num,EDUTC.Cmd.OpBuff[Num]);
 end;
 
 {
 Assign Pfeiffer last sent polling request record.
 }
 procedure AssignPfeifferPoll(ref,cid:Integer; tim:Real; port,adr:Integer;par,len:Integer; dat:String);
 begin
  EDUTC.Pfeiffer.Poll.ref:=ref;      EDUTC.Pfeiffer.Poll.cid:=cid;      EDUTC.Pfeiffer.Poll.tim:=tim;
  EDUTC.Pfeiffer.Poll.port:=port;    EDUTC.Pfeiffer.Poll.adr:=adr;      EDUTC.Pfeiffer.Poll.par:=par;
  EDUTC.Pfeiffer.Poll.len:=len;      EDUTC.Pfeiffer.Poll.dat:=dat;
 end;
 
 {
 Clear Pfeiffer polling request to be ready for next polling.
 }
 procedure ClearPfeifferPoll;
 begin
  EDUTC.Pfeiffer.Poll.cid:=0;
  EDUTC.Pfeiffer.Poll.dat:='';
 end;
 
 {
 Clear Pfeiffer poll rate counters.
 }
 procedure ClearPfeifferRate;
 begin
  EDUTC.pfeiffer.Poll.Rate.Rx:=0;
  EDUTC.pfeiffer.Poll.Rate.Tx:=0;
  EDUTC.pfeiffer.Poll.Rate.Ex:=0;
 end;
 
 {
 EDUTC Driver Command Cycle polling.
 }
 procedure EDUTC_CMD_POLL;
 
  procedure DimRefreshTag(var R:TTagRef);
  var tag:Integer; v:Real;
  begin
   tag:=R.tag; v:=GetStampOfTag(tag,_NaN);
   if not IsNaN(v) then if ShouldRefresh(R.val,v)>0 then UpdateDimTag(tag);
  end;
  
  {
  Update ranges/formats by ModelCode.
  }
  function EDUTC_UpdateModel(ModelCode:Integer):Integer;
  begin
   ModelCode:=CheckModelCode(ModelCode);
   if ModelCode>0 then begin
   end;
   EDUTC_UpdateModel:=ModelCode;
  end;
  
  {
  Check & return EDUTC ModelCode, nonzero if IDN detection was successful.
  }
  function EDUTC_ModelCode:Integer;
  begin
   EDUTC_ModelCode:=CheckModelCode(EDUTC.ModelCode);
  end;
  
  procedure EnableIDN;
  begin
   //EnableCmdNum(cm_IDNa,true);
  end;
  
  procedure UpdateIDN(data:String);
  var v:Real;
  begin
   if not IsEmptyStr(data) then begin
    EDUTC.ModelCode:=EDUTC_UpdateModel(EDUTC_ParseIDN(data,iGetTag(EDUTC.POLL_ENABLE.tag)=0));
    if (EDUTC_ModelCode=0) then data:=si_OFFLINE;
    if IsEmptyStr(data) then data:=si_OFFLINE;
    bNul(sSetTag(EDUTC.ID_IDN.tag,data));
    if ShouldRefresh(EDUTC.ID_IDN.val,GetStampOfTag(EDUTC.ID_IDN.tag,_NaN))>0
    then UpdateDimTag(EDUTC.ID_IDN.tag);
   end;
  end;
  {
  Send @Pfeiffer.Poll ... command to &PfeifferProxy and save sent request data in Pfeiffer.Poll record.
  }
  procedure PollPfeifferProxy(cid:Integer);
  var dev,ref,tot,port,adr,len,par:Integer; dat:String;
  begin
   if (EDUTC.Cmd.OpData[cid] = '') then
    dat:='=?' 
   else 
    dat:=EDUTC.Cmd.OpData[cid];
   ApplyCmdOpData(cid);
   dev:=devTheProxy;
   ref:=devMySelf;
   tot:=EDUTC.Pfeiffer.Timeout;
   port:=EDUTC.Pfeiffer.Port;
   adr:=EDUTC.Pfeiffer.UnitAdr;
   par:=EDUTC.Cmd.ParNum[cid];
   len:=DataFormatLength(cid);
    
   if DevSend(dev,Pfeiffer_proxy_poll('@Pfeiffer.Poll',ref,cid,tot,port,adr,par,len,dat)+EOL)>0 then begin
    if DebugFlagEnabled(dfViewExp) then ViewExp('COM: '+Pfeiffer_proxy_nice('@Pfeiffer.Poll',ref,cid,tot,port,adr,par,len,dat,32));
    AssignPfeifferPoll(dev,cid,mSecNow,port,adr,par,len,dat);
    EDUTC.Pfeiffer.Poll.Rate.Tx:=EDUTC.Pfeiffer.Poll.Rate.Tx+1;
   end else begin
    Trouble('Fail to send command '+Str(cid));
    ClearPfeifferPoll;
   end;
   EDUTC.Cmd.OpData[cid]:='';
   dat:='';
  end; 
 begin
  if IsPortOpened then begin
   if IsValidCmdNum(EDUTC.Pfeiffer.Poll.cid) then begin
    {
    Request in progress, waiting @Pfeiffer.Reply/@Pfeiffer.Refuse/@Pfeiffer.Timeout.
    Handle Deadline if was no responce for too long time: repeat polling again.
    }
    if (mSecNow>EDUTC.Pfeiffer.Poll.tim+EDUTC.Pfeiffer.Deadline) then begin
     EDUTC.Pfeiffer.Poll.Rate.Ex:=EDUTC.Pfeiffer.Poll.Rate.Ex+1;
     Trouble('Deadline detected, repeat polling again...');
     PollPfeifferProxy(EDUTC.Pfeiffer.Poll.cid);
    end;
   end else begin
    //
    // If request is cleared, send new @Pfeiffer.Poll request by timer.
    //
    if (mSecNow>=EDUTC.Pfeiffer.Poll.tim+EDUTC.Pfeiffer.Polling) then begin
     UpdateIDN(si_OFFLINE);
     EnableIDN;
     EDUTC.Cmd.Num:=NextEnabledCmdNum(EDUTC.Cmd.Num);
     if IsEnabledCmdNum(EDUTC.Cmd.Num)
     then PollPfeifferProxy(EDUTC.Cmd.Num);
    end;
   end;
   {
   Update Poll Rate.
   }
   if SysTimer_Pulse(1000)>0 then begin
    UpdateDo(do_POLLRATERX,time,EDUTC.Pfeiffer.Poll.Rate.Rx);
    UpdateDo(do_POLLRATETX,time,EDUTC.Pfeiffer.Poll.Rate.Tx);
    UpdateDo(do_POLLRATEEX,time,EDUTC.Pfeiffer.Poll.Rate.Ex);
    UpdateDo(do_ERRORCOUNT,time,GetErrCount(-1));
    if DebugFlagEnabled(dfStatist) then
    Success('PollRate: Rx='+Str(EDUTC.Pfeiffer.Poll.Rate.Rx)
                   +'  Tx='+Str(EDUTC.Pfeiffer.Poll.Rate.Tx)
                   +'  Ex='+Str(EDUTC.Pfeiffer.Poll.Rate.Ex));
    ClearPfeifferRate;
   end;
   
   if DIM_IsServerMode then begin
    // Enforce update each 10 sec
    if SysTimer_Pulse(10000)>0 then EDUTC_FillTags(-MaxReal);
    DimRefreshTag(EDUTC.POLL_ENABLE);
    DimRefreshTag(EDUTC.POLL_RATE);
    DimRefreshTag(EDUTC.ERROR_CNT);
    DimRefreshTag(EDUTC.ID_IDN);
    DimRefreshTag(EDUTC.ID_NAME);
    
    DimRefreshTag(EDUTC.PAR_Heating);
    DimRefreshTag(EDUTC.PAR_Standby);
    DimRefreshTag(EDUTC.PAR_RUTimeCtrl);
    DimRefreshTag(EDUTC.PAR_ErrorAckn);
    DimRefreshTag(EDUTC.PAR_PumpgStatn);
    DimRefreshTag(EDUTC.PAR_EnableVent);
    DimRefreshTag(EDUTC.PAR_CfgSpdSwPt);
    DimRefreshTag(EDUTC.PAR_CfgDO2);
    DimRefreshTag(EDUTC.PAR_MotorPump);
    DimRefreshTag(EDUTC.PAR_CfgDO1);
    DimRefreshTag(EDUTC.PAR_OpModeBKP);
    DimRefreshTag(EDUTC.PAR_SpdSetMode);
    DimRefreshTag(EDUTC.PAR_GasMode);
    DimRefreshTag(EDUTC.PAR_VentMode);
    DimRefreshTag(EDUTC.PAR_CfgAccA1);
    DimRefreshTag(EDUTC.PAR_CfgAccB1);
    DimRefreshTag(EDUTC.PAR_CfgAccA2);
    DimRefreshTag(EDUTC.PAR_CfgAccB2);
    DimRefreshTag(EDUTC.PAR_Press1HVen);
    DimRefreshTag(EDUTC.PAR_SealingGas);
    DimRefreshTag(EDUTC.PAR_CfgAO1);
    DimRefreshTag(EDUTC.PAR_CtrlVialnt);
    DimRefreshTag(EDUTC.PAR_IntSelLckd);
    DimRefreshTag(EDUTC.PAR_CfgDI1);
    DimRefreshTag(EDUTC.PAR_CfgDI2);
    DimRefreshTag(EDUTC.PAR_RemotePrio);
    DimRefreshTag(EDUTC.PAR_SpdSwPtAtt);
    DimRefreshTag(EDUTC.PAR_ErrorCode);
    DimRefreshTag(EDUTC.PAR_OvTempElec);
    DimRefreshTag(EDUTC.PAR_OvTempPump);
    DimRefreshTag(EDUTC.PAR_SetSpdAtt);
    DimRefreshTag(EDUTC.PAR_PumpAccel);
    DimRefreshTag(EDUTC.PAR_SetRotSpd);
    DimRefreshTag(EDUTC.PAR_ActualSpd);
    DimRefreshTag(EDUTC.PAR_DrvCurrent);
    DimRefreshTag(EDUTC.PAR_OpHrsPump);
    DimRefreshTag(EDUTC.PAR_FWVersion);
    DimRefreshTag(EDUTC.PAR_DrvVoltage);
    DimRefreshTag(EDUTC.PAR_OpHrsElec);
    DimRefreshTag(EDUTC.PAR_NominalSpd);
    DimRefreshTag(EDUTC.PAR_DrvPower);
    DimRefreshTag(EDUTC.PAR_PumpCycles);
    DimRefreshTag(EDUTC.PAR_TempElec);
    DimRefreshTag(EDUTC.PAR_TempPmpBot);
    DimRefreshTag(EDUTC.PAR_AccelDecel);
    DimRefreshTag(EDUTC.PAR_SealGasFlw);
    DimRefreshTag(EDUTC.PAR_TempBearng);
    DimRefreshTag(EDUTC.PAR_TempMotor);
    DimRefreshTag(EDUTC.PAR_ElecName);
    DimRefreshTag(EDUTC.PAR_HWVersion);
    DimRefreshTag(EDUTC.PAR_ErrHist1);
    DimRefreshTag(EDUTC.PAR_ErrHist2);
    DimRefreshTag(EDUTC.PAR_ErrHist3);
    DimRefreshTag(EDUTC.PAR_ErrHist4);
    DimRefreshTag(EDUTC.PAR_ErrHist5);
    DimRefreshTag(EDUTC.PAR_ErrHist6);
    DimRefreshTag(EDUTC.PAR_ErrHist7);
    DimRefreshTag(EDUTC.PAR_ErrHist8);
    DimRefreshTag(EDUTC.PAR_ErrHist9);
    DimRefreshTag(EDUTC.PAR_ErrHist10);
    DimRefreshTag(EDUTC.PAR_SetRotRPM);
    DimRefreshTag(EDUTC.PAR_ActualRPM);
    DimRefreshTag(EDUTC.PAR_NominalRPM);
    DimRefreshTag(EDUTC.PAR_RUTimeSVal);
    DimRefreshTag(EDUTC.PAR_SpdSwPt1);
    DimRefreshTag(EDUTC.PAR_SpdSVal);
    DimRefreshTag(EDUTC.PAR_PwrSVal);
    DimRefreshTag(EDUTC.PAR_SwOffBKP);
    DimRefreshTag(EDUTC.PAR_SwOnBKP);
    DimRefreshTag(EDUTC.PAR_StdbySVal);
    DimRefreshTag(EDUTC.PAR_SpdSwPt2);
    DimRefreshTag(EDUTC.PAR_VentSpd);
    DimRefreshTag(EDUTC.PAR_VentTime);
    DimRefreshTag(EDUTC.PAR_PrsSwPt1);
    DimRefreshTag(EDUTC.PAR_PrsSwPt2);
    DimRefreshTag(EDUTC.PAR_PrsSn1Name);
    DimRefreshTag(EDUTC.PAR_Pressure1);
    DimRefreshTag(EDUTC.PAR_PrsCorrPi1);
    DimRefreshTag(EDUTC.PAR_PrsSn2Name);
    DimRefreshTag(EDUTC.PAR_Pressure2);
    DimRefreshTag(EDUTC.PAR_PrsCorrPi2);
    DimRefreshTag(EDUTC.PAR_NomSpdConf);
    DimRefreshTag(EDUTC.PAR_SlgWrnThrs);
    DimRefreshTag(EDUTC.PAR_RS485Adr);
    DimRefreshTag(EDUTC.PAR_Pressure);
    DimRefreshTag(EDUTC.PAR_CtrName);
    DimRefreshTag(EDUTC.PAR_CtrSoftware);
    DimRefreshTag(EDUTC.PAR_ParamSet);
    DimRefreshTag(EDUTC.PAR_Servicelin);
   end;
  end;
 end;
 
 procedure UpdateCmdValue(n:Integer; ans:String);
 var v:Real;
 begin
  if IsValidCmdNum(n) and not IsNan(v) then begin
   if TypeTag(EDUTC.Cmd.Tag[n])=1 then begin
    bNul(iSetTag(EDUTC.Cmd.Tag[n],trunc(val(ans))));
    UpdateAo(EDUTC.Cmd.AoNum[n],time,iGetTag(EDUTC.Cmd.Tag[n]));
   end else if TypeTag(EDUTC.Cmd.Tag[n])=2 then begin
    bNul(rSetTag(EDUTC.Cmd.Tag[n],rval(ans)));
    UpdateAo(EDUTC.Cmd.AoNum[n],time,rGetTag(EDUTC.Cmd.Tag[n]));
   end else if TypeTag(EDUTC.Cmd.Tag[n])=3 then begin
    bNul(sSetTag(EDUTC.Cmd.Tag[n],ans));
   end;
  end;
 end; 
 
 {
 Main pfeiffer command handler to process pfeiffer device reply.
 cid   - (in)  command id number.
 par   - (in)  pfeiffer function id.
 saddr - (in)  zero-based start address of registers to read/write.
 len   - (in)  data lenity, i.e. number of r/w registers or single register r/w value.
 dat   - (in)  raw coils/registers data array.
 }
 procedure EDUTC_OnCommand(cid,par,len:Integer; dat:String);
 var addr,offs,nao,ndo:Integer; r:Real;
 begin
  if IsValidCmdNum(cid) then begin 
   UpdateCmdValue(cid,dat);
   // Если пришла определенная комманда - что-то делаем
   if (cid>1) then
    ReleaseCmdOpData(cid)
   else
    Trouble('Unexpected command '+Str(cid));
  end;
 end;
 
 {
 Data handler on @Pfeiffer.Reply event. Process reply comes from Pfeiffer device.
 }
 procedure EDUTC_OnReply(ref,cid,tim,port,adr,par,len:Integer; raw:String);
 var dat:String;
 begin
  dat:=''; // Check is coming reply corresponded to sent request
  if not IsValidCmdNum(cid) then Trouble('Bad reply command '+Str(cid)) else
  if (port<>EDUTC.Pfeiffer.Poll.port) then Trouble('Bad reply port '+Str(port)) else
  if (adr<>EDUTC.Pfeiffer.Poll.adr) then Trouble('Bad reply unit id '+Str(adr)) else
  if (cid<>EDUTC.Pfeiffer.Poll.cid) then Trouble('Bad reply command id '+Str(cid)) else
  if (ref<>EDUTC.Pfeiffer.Poll.ref) then Trouble('Bad reply device '+RefInfo(ref,'Name')) else
  if (Pfeiffer_un_except(par)<>EDUTC.Pfeiffer.Poll.par) then Trouble('Bad reply function id '+str(par)) else begin
    if (len<>EDUTC.Pfeiffer.Poll.len) then 
     Trouble('Bad reply len '+Str(len)) else 
     begin
      dat:=copy(raw,3,length(raw));
      EDUTC.Pfeiffer.Poll.Rate.Rx:=EDUTC.Pfeiffer.Poll.Rate.Rx+1;
      EDUTC_OnCommand(cid,par,len,dat); 
     end;
  end;
  raw:='';
 end;
 
 {
 Data handler on @Pfeiffer.Poll event.
 This procedure calls in simulation mode only.
 }
 procedure EDUTC_OnSimPoll(ref,cid,tim,port,adr,par,len:Integer;dat:String);
 begin
  if not IsValidCmdNum(cid) then Trouble('Bad reply command '+Str(cid)) else
  if (port<>EDUTC.Pfeiffer.Poll.port) then Trouble('Bad reply port '+Str(port)) else
  if (adr<>EDUTC.Pfeiffer.Poll.adr) then Trouble('Bad reply unit id '+Str(adr)) else
  if (cid<>EDUTC.Pfeiffer.Poll.cid) then Trouble('Bad reply command id '+Str(cid)) else
  if (ref<>EDUTC.Pfeiffer.Poll.ref) then Trouble('Bad reply device '+RefInfo(ref,'Name')) else
  if (Pfeiffer_un_except(par)<>EDUTC.Pfeiffer.Poll.par) then Trouble('Bad reply function id '+str(par)) else begin
   len:=EDUTC.Pfeiffer.Poll.len;
   if (len<>EDUTC.Pfeiffer.Poll.len) then Trouble('Bad reply len '+Str(len)) else begin
    if DebugFlagEnabled(dfDetails) then Details('Simulate polling '+Str(cid));

    if dat<>'$$=?' then begin EDUTC.Sim.Param[cid]:=val(stringreplace(dat,'$$','',rfReplaceAll)); end;
    dat:=str(EDUTC.Sim.Param[cid]);
    dat:=LeftPad(dat,len,'0');
    
    DevSendCmdLocal(Pfeiffer_proxy_poll('@Pfeiffer.Reply',devMySelf,cid,0,port,adr,par,len,dat));
   end;
  end;
 end;
 
 {
 EDUTC Driver Simulator mode polling.
 This procedure calls in simulation mode only.
 }
 procedure EDUTC_SIM_POLL;
 var i:Integer;
 begin
  if EDUTC.Simulator then begin
   for i:=1 to MaxCmdNum do begin
    if not (EDUTC.Cmd.DType[i] = 7) then
     EDUTC.Sim.Param[i]:=round(EDUTC.Sim.Param[i]+random(-1,1));
    if EDUTC.Sim.Param[i]<0 then EDUTC.Sim.Param[i]:=0;
   end;
  end;
 end;
 
 {
 Check if EDUTC polling enabled, with warning or not.
 }
 function EDUTC_CheckPolling(Warn:Integer):Boolean;
 var flag:Boolean; msg:String;
 begin
  msg:='';
  flag:=iGetTag(EDUTC.POLL_ENABLE.tag)>0;
  if (Warn<>0) and not flag then begin
   msg:=StrFmt('Для изменения параметров %s надо включить Опрос.',sGetTag(EDUTC.ID_NAME.tag));
   if iAnd(Warn,1)>0 then NiceNotify(msg,30);
   if iAnd(Warn,2)>0 then UnixWBox('Предупреждение',msg,600,20,15);
   if iAnd(Warn,4)>0 then Cron('@run -sw7 unix messagebox "Предупреждение" "'+msg+'" -t 15');
   if iAnd(Warn,8)>0 then Warning(msg);
  end;
  EDUTC_CheckPolling:=flag;
  msg:='';
 end;
 
 procedure AddCommand(n,AoNum:Integer;Enabled:Boolean;  Info:String);
 begin
  if IsValidCmdNum(n) then begin
   EDUTC.Cmd.AoNum[n]:=AoNum;
   EDUTC.Cmd.Acronym[n]:=ExtractWord(1,Info);
   EDUTC.Cmd.ParNum[n]:=val(ExtractWord(2,Info));
   EDUTC.Cmd.Comment[n]:=ExtractWord(3,Info);
   EDUTC.Cmd.Enabled[n]:=Enabled;
   EDUTC.Cmd.OpData[n]:='';
   EDUTC.Cmd.OpBuff[n]:='';
   EDUTC.Cmd.Min[n]:=Val(ExtractWord(5,Info));
   EDUTC.Cmd.Max[n]:=Val(ExtractWord(6,Info));
   EDUTC.Cmd.DType[n]:=Val(ExtractWord(7,Info));
   EDUTC.Cmd.Tag[n]:=FindTag(CrvName(RefAo(AoNum)));
  end;
 end;
 
 {
 Command table cleanup and initialization.
 }
 procedure ClearCmdTable;
 var Num:Integer;
 begin
  EDUTC.Cmd.Num:=0;     
  for Num:=1 to MaxCmdNum do AddCommand(Num,0,false,'');
 end;
 {
 Initialize commands.
 }
 procedure EDUTC_Init_Cmd;
 begin
  EDUTC.Cmd.Num:=1;
  // Command                 AoNum               Read    Acronym     ParN Comment                OpData Min Max     Type
  // Control commands                                                                                               
  AddCommand(cm_Heating,     ao_PAR_Heating,     True,  'Heating     001  Heating                0      0   1       0');
  AddCommand(cm_Standby,     ao_PAR_Standby,     True,  'Standby     002  Standby                0      0   1       0');
  AddCommand(cm_RUTimeCtrl,  ao_PAR_RUTimeCtrl,  True,  'RUTimeCtrl  004  Run-upTimeControl      0      0   1       0');
  AddCommand(cm_ErrorAckn,   ao_PAR_ErrorAckn,   True,  'ErrorAckn   009  ErrorAcknowledgement   0      1   1       0');
  AddCommand(cm_PumpgStatn,  ao_PAR_PumpgStatn,  True,  'PumpgStatn  010  PumpgStation           0      0   1       0');
  AddCommand(cm_EnableVent,  ao_PAR_EnableVent,  True,  'EnableVent  012  EnableVenting          0      0   1       0');
  AddCommand(cm_CfgSpdSwPt,  ao_PAR_CfgSpdSwPt,  True,  'CfgSpdSwPt  017  ConfigRotSpdSwitchPnt  0      0   1       7');
  AddCommand(cm_CfgDO2,      ao_PAR_CfgDO2,      True,  'CfgDO2      019  ConfigOutputDO2        0      0   22      7');
  AddCommand(cm_MotorPump,   ao_PAR_MotorPump,   True,  'MotorPump   023  MotorPump              0      0   1       0');
  AddCommand(cm_CfgDO1,      ao_PAR_CfgDO1,      True,  'CfgDO1      024  ConfigOutputDO1        0      0   22      7');
  AddCommand(cm_OpModeBKP,   ao_PAR_OpModeBKP,   True,  'OpModeBKP   025  OperationModeBackingP  0      0   3       7');
  AddCommand(cm_SpdSetMode,  ao_PAR_SpdSetMode,  True,  'SpdSetMode  026  RotationSpeedSetingMo  0      0   1       7');
  AddCommand(cm_GasMode,     ao_PAR_GasMode,     True,  'GasMode     027  GasMode                0      0   2       7');
  AddCommand(cm_VentMode,    ao_PAR_VentMode,    True,  'VentMode    030  VentingMode            0      0   2       7');
  { AddCommand(cm_CfgAccA1,    ao_PAR_CfgAccA1,    True,  'CfgAccA1    035  ConfigAccessoryConA1   0      0   14      7'); }
  { AddCommand(cm_CfgAccB1,    ao_PAR_CfgAccB1,    True,  'CfgAccB1    036  ConfigAccessoryConB1   0      0   14      7'); }
  { AddCommand(cm_CfgAccA2,    ao_PAR_CfgAccA2,    True,  'CfgAccA2    037  ConfigAccessoryConA2   0      0   14      7'); }
  { AddCommand(cm_CfgAccB2,    ao_PAR_CfgAccB2,    True,  'CfgAccB2    038  ConfigAccessoryConB2   0      0   14      7'); }
  AddCommand(cm_Press1HVen,  ao_PAR_Press1HVen,  True,  'Press1HVen  041  EnableIntegratedHVSen  0      0   3       7');
  AddCommand(cm_SealingGas,  ao_PAR_SealingGas,  True,  'SealingGas  050  SealingGas             0      0   1       0');
  AddCommand(cm_CfgAO1,      ao_PAR_CfgAO1,      True,  'CfgAO1      055  ConfigOutputAO1        0      0   8       7');
  { AddCommand(cm_CtrlVialnt,  ao_PAR_CtrlVialnt,  True,  'CtrlVialnt  060  ControlViaInterface    0      1   255     7'); }
  { AddCommand(cm_IntSelLckd,  ao_PAR_IntSelLckd,  True,  'IntSelLckd  061  IntSelLckd             0      0   1       0'); }
  AddCommand(cm_CfgDI1,      ao_PAR_CfgDI1,      True,  'CfgDI1      062  ConfigInputDI1         0      0   7       7');
  AddCommand(cm_CfgDI2,      ao_PAR_CfgDI2,      True,  'CfgDI2      063  ConfigInputDI2         0      0   7       7');
                                                                                                 
  // Status Request                                                                              
  { AddCommand(cm_RemotePrio,  ao_PAR_RemotePrio,  True,  'RemotePrio  300  RemotePriority         0      0   1       0'); }
  AddCommand(cm_SpdSwPtAtt,  ao_PAR_SpdSwPtAtt,  True,  'SpdSwPtAtt  302  RotationSpeedSwitchPR  0      0   1       0');
  AddCommand(cm_ErrorCode,   ao_PAR_ErrorCode,   True,  'ErrorCode   303  ErrorCode              0      0   0       4');
  AddCommand(cm_OvTempElec,  ao_PAR_OvTempElec,  True,  'OvTempElec  304  OvertemperatureEDU     0      0   1       0');
  AddCommand(cm_OvTempPump,  ao_PAR_OvTempPump,  True,  'OvTempPump  305  OvertemperaturePump    0      0   0       0');
  AddCommand(cm_SetSpdAtt,   ao_PAR_SetSpdAtt,   True,  'SetSpdAtt   306  TargetSpeedReached     0      0   0       0');
  AddCommand(cm_PumpAccel,   ao_PAR_PumpAccel,   True,  'PumpAccel   307  PumpAccelerating       0      0   1       0');
  AddCommand(cm_SetRotSpd,   ao_PAR_SetRotSpd,   True,  'SetRotSpd   308  SetRotationSpeed       0      0   999999  1');
  AddCommand(cm_ActualSpd,   ao_PAR_ActualSpd,   True,  'ActualSpd   309  ActialRotationSpeed    0      0   999999  1');
  AddCommand(cm_DrvCurrent,  ao_PAR_DrvCurrent,  True,  'DrvCurrent  310  DriveCurrent           0      1   9999.99 2');
  AddCommand(cm_OpHrsPump,   ao_PAR_OpHrsPump,   True,  'OpHrsPump   311  OperatingHoursPump     0      0   65535   1');
  AddCommand(cm_FWVersion,   ao_PAR_FWVersion,   True,  'FWVersion   312  FirmwareVersionEDU     0      0   0       4');
  AddCommand(cm_DrvVoltage,  ao_PAR_DrvVoltage,  True,  'DrvVoltage  313  DriveVoltage           0      0   9999.99 2');
  AddCommand(cm_OpHrsElec,   ao_PAR_OpHrsElec,   True,  'OpHrsElec   314  OperatingHoursEDU      0      0   65535   1');
  AddCommand(cm_NominalSpd,  ao_PAR_NominalSpd,  True,  'NominalSpd  315  NominalRotationSpeed   0      0   999999  1');
  AddCommand(cm_DrvPower,    ao_PAR_DrvPower,    True,  'DrvPower    316  DrivePower             0      0   999999  1');
  { AddCommand(cm_PumpCycles,  ao_PAR_PumpCycles,  True,  'PumpCycles  319  PumpCycles             0      0   65535   1'); }
  AddCommand(cm_TempElec,    ao_PAR_TempElec,    True,  'TempElec    326  TemperatureElectronic  0      0   999999  1');
  AddCommand(cm_TempPmpBot,  ao_PAR_TempPmpBot,  True,  'TempPmpBot  330  TemperaturePumpBottom  0      0   999999  1');
  AddCommand(cm_AccelDecel,  ao_PAR_AccelDecel,  True,  'AccelDecel  336  Acceleration/Decelera  0      0   999999  1');
  AddCommand(cm_SealGasFlw,  ao_PAR_SealGasFlw,  True,  'SealGasFlw  337  SealingGasFlow         0      0   999999  1');
  AddCommand(cm_TempBearng,  ao_PAR_TempBearng,  True,  'TempBearng  342  TemperatureBearing     0      0   999999  1');
  AddCommand(cm_TempMotor,   ao_PAR_TempMotor,   True,  'TempMotor   346  TemperatureMotor       0      0   999999  1');
  { AddCommand(cm_ElecName,    ao_PAR_ElecName,    True,  'ElecName    349  NameOfElectronicDrive  0      0   0       4'); }
  { AddCommand(cm_HWVersion,   ao_PAR_HWVersion,   True,  'HWVersion   354  HardwareVersionEDU     0      0   0       4'); }
  { AddCommand(cm_ErrHist1,    ao_PAR_ErrHist1,    True,  'ErrHist1    360  ErrorCodeHistory1      0      0   0       4'); }
  { AddCommand(cm_ErrHist2,    ao_PAR_ErrHist2,    True,  'ErrHist2    361  ErrorCodeHistory2      0      0   0       4'); }
  { AddCommand(cm_ErrHist3,    ao_PAR_ErrHist3,    True,  'ErrHist3    362  ErrorCodeHistory3      0      0   0       4'); }
  { AddCommand(cm_ErrHist4,    ao_PAR_ErrHist4,    True,  'ErrHist4    363  ErrorCodeHistory4      0      0   0       4'); }
  { AddCommand(cm_ErrHist5,    ao_PAR_ErrHist5,    True,  'ErrHist5    364  ErrorCodeHistory5      0      0   0       4'); }
  { AddCommand(cm_ErrHist6,    ao_PAR_ErrHist6,    True,  'ErrHist6    365  ErrorCodeHistory6      0      0   0       4'); }
  { AddCommand(cm_ErrHist7,    ao_PAR_ErrHist7,    True,  'ErrHist7    366  ErrorCodeHistory7      0      0   0       4'); }
  { AddCommand(cm_ErrHist8,    ao_PAR_ErrHist8,    True,  'ErrHist8    367  ErrorCodeHistory8      0      0   0       4'); }
  { AddCommand(cm_ErrHist9,    ao_PAR_ErrHist9,    True,  'ErrHist9    368  ErrorCodeHistory9      0      0   0       4'); }
  { AddCommand(cm_ErrHist10,   ao_PAR_ErrHist10,   True,  'ErrHist10   369  ErrorCodeHistory10     0      0   0       4'); }
  AddCommand(cm_SetRotRPM,   ao_PAR_SetRotRPM,   True,  'SetRotRPM   397  SetRotationSpeed       0      0   999999  1');
  AddCommand(cm_ActualRPM,   ao_PAR_ActualRPM,   True,  'ActualRPM   398  ActualRotationSpeed    0      0   999999  1');
  AddCommand(cm_NominalRPM,  ao_PAR_NominalRPM,  True,  'NominalRPM  399  NominalRotationSpeed   0      0   999999  1');
                                                                                                 
  // Set value settings                                                                          
  AddCommand(cm_RUTimeSVal,  ao_PAR_RUTimeSVal,  True,  'RUTimeSVal  700  SetValueRun-upTime     0      0   0       1');
  AddCommand(cm_SpdSwPt1,    ao_PAR_SpdSwPt1,    True,  'SpdSwPt1    701  RotationSpeedSwitchP1  0      0   0       1');
  AddCommand(cm_SpdSVal,     ao_PAR_SpdSVal,     True,  'SpdSVal     707  SetValueInRotationSpd  0      0   0       2');
  AddCommand(cm_PwrSVal,     ao_PAR_PwrSVal,     True,  'PwrSVal     708  SetValuePowerConsumpt  0      0   0       7');
  AddCommand(cm_SwOffBKP,    ao_PAR_SwOffBKP,    True,  'SwOffBKP    710  BackingPumpSwitchOff   0      0   1000    1');
  AddCommand(cm_SwOnBKP,     ao_PAR_SwOnBKP,     True,  'SwOnBKP     711  BackingPumpSwitchOn    0      0   1000    1');
  AddCommand(cm_StdbySVal,   ao_PAR_StdbySVal,   True,  'StdbySVal   717  SetValueRotSpdAtStdby  0      20  100     2');
  AddCommand(cm_SpdSwPt2,    ao_PAR_SpdSwPt2,    True,  'SpdSwPt2    719  RotationSpeedSwitchP2  0      5   97      1');
  AddCommand(cm_VentSpd,     ao_PAR_VentSpd,     True,  'VentSpd     720  VentingRotSpdAtDelVen  0      40  98      7');
  AddCommand(cm_VentTime,    ao_PAR_VentTime,    True,  'VentTime    721  VentingTimeAtDelayedV  0      6   3600    1');
  { AddCommand(cm_PrsSwPt1,    ao_PAR_PrsSwPt1,    True,  'PrsSwPt1    730  PressureSwitchPoint1   0      0   0       10'); }
  { AddCommand(cm_PrsSwPt2,    ao_PAR_PrsSwPt2,    True,  'PrsSwPt2    732  PressureSwitchPoint2   0      0   0       10'); }
  { AddCommand(cm_PrsSn1Name,  ao_PAR_PrsSn1Name,  True,  'PrsSn1Name  739  NameSensor1            0      0   0       4'); }
  { AddCommand(cm_Pressure1,   ao_PAR_Pressure1,   True,  'Pressure1   740  PressureValue1         0      0   0       10'); }
  { AddCommand(cm_PrsCorrPi1,  ao_PAR_PrsCorrPi1,  True,  'PrsCorrPi1  742  CorrectionFactor1      0      0   0       2'); }
  { AddCommand(cm_PrsSn2Name,  ao_PAR_PrsSn2Name,  True,  'PrsSn2Name  749  NameSensor2            0      0   0       4'); }
  { AddCommand(cm_Pressure2,   ao_PAR_Pressure2,   True,  'Pressure2   750  PressureValue2         0      0   0       10'); }
  { AddCommand(cm_PrsCorrPi2,  ao_PAR_PrsCorrPi2,  True,  'PrsCorrPi2  752  CorretionFactor2       0      0   0       2'); }
  { AddCommand(cm_NomSpdConf,  ao_PAR_NomSpdConf,  True,  'NomSpdConf  777  NominalRotSpdConfirm   0      0   1500    1'); }
  { AddCommand(cm_SlgWrnThrs,  ao_PAR_SlgWrnThrs,  True,  'SlgWrnThrs  791  SealingGasFlowWarning  0      5   200     1'); }
  AddCommand(cm_RS485Adr,    ao_PAR_RS485Adr,    True,  'RS485Adr    797  RS-485interfaceAddress 0      1   255     1');
                                                                                                 
  // Additional patameter for the DCU                                                            
  AddCommand(cm_Pressure,    ao_PAR_Pressure,    True,  'Pressure    340  ActualPressureValue    0      0   0       7');
  { AddCommand(cm_CtrName,     ao_PAR_CtrName,     True,  'CtrName     350  DisplayType            0      0   0       4'); }
  { AddCommand(cm_CtrSoftware, ao_PAR_CtrSoftware, True,  'CtrSoftware 351  DisplaySoftwareVersion 0      0   0       4'); }
  AddCommand(cm_ParamSet,    ao_PAR_ParamSet,    True,  'ParamSet    794  ParameterSet           0      0   1       7');
  AddCommand(cm_Servicelin,  ao_PAR_Servicelin,  True,  'Servicelin  795  InsertServiceLine      0      0   0       7');
 end;
 {
 Print command table
 }
 procedure PrintCmdTable;
 var n:Integer; en:string;
 begin
  
  Success('Command table:');
  Success(StrFmt('%-2s ','Cm')
         +StrFmt('%-2s ','Ao')
         +StrFmt('%-12s ','Acro')
         +StrFmt('%-3s ','Num')
         +StrFmt('%-25s ','Comment')
         +StrFmt('%-4s ','En')
         +StrFmt('%6s ','OpData')
         +StrFmt('%6s ','Min')
         +StrFmt('%6s ','Max')
         +StrFmt('%-2s ','Type')
         );
  for n:=1 to MaxCmdNum do
  begin
  if (EDUTC.Cmd.Enabled[n]) then en:='+' else en:='-';
  Success(StrFmt('%-2d ',n)
         +StrFmt('%-2d ',EDUTC.Cmd.AoNum[n])
         +StrFmt('%-12s ',EDUTC.Cmd.Acronym[n])
         +StrFmt('%3d ',EDUTC.Cmd.ParNum[n])
         +StrFmt('%-25s ',EDUTC.Cmd.Comment[n])
         +StrFmt('%-4s ',en)
         +StrFmt('%6s ',EDUTC.Cmd.OpData[n])
         +StrFmt('%6d ',EDUTC.Cmd.Min[n])
         +StrFmt('%6d ',EDUTC.Cmd.Max[n])
         +StrFmt('%2d ',EDUTC.Cmd.DType[n])
         );
   end;
 end;
 
 {
 Update ranges/formats by ModelCode.
 }
 function EDUTC_UpdateModel(ModelCode:Integer):Integer;
 begin
  ModelCode:=CheckModelCode(ModelCode);
  if ModelCode>0 then begin
  end;
  EDUTC_UpdateModel:=ModelCode;
 end;
 
 {
 Xor bit on click (local version).
 }
 procedure ClickTagXorLocal(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 
 {
 Xor bit on click (remote version).
 }
 procedure ClickTagXorRemote(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   DIM_GuiClickSend(DIM_GuiClickBuff+'NewValue='+Str(iXor(iGetTag(tag),XorMask)));
   bNul(Voice(snd_Click));
  end;
 end;
 
 {
 Menu Configuration output DO to start editing.
 }
 procedure MenuConfDO(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Configuration output DO"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Rotation speed switch point reached');
   n:=n+EditAddInputLn('No error');
   n:=n+EditAddInputLn('Error');
   n:=n+EditAddInputLn('Warning');
   n:=n+EditAddInputLn('Error and/or warning');
   n:=n+EditAddInputLn('Set rotation speed reached');
   n:=n+EditAddInputLn('Pump on');
   n:=n+EditAddInputLn('Pump accelerating');
   n:=n+EditAddInputLn('Pump decelerating');
   n:=n+EditAddInputLn('Always "0"');
   n:=n+EditAddInputLn('Always "1"');
   n:=n+EditAddInputLn('Remote priority active');
   n:=n+EditAddInputLn('Heating');
   n:=n+EditAddInputLn('Backing pump');
   n:=n+EditAddInputLn('Sealing gas');
   n:=n+EditAddInputLn('Pumping station');
   n:=n+EditAddInputLn('Pump rotates');
   n:=n+EditAddInputLn('Pump does not rotate');
   n:=n+EditAddInputLn('Pressure switch point 1 underrun');
   n:=n+EditAddInputLn('Pressure switch point 2 underrun');
   n:=n+EditAddInputLn('Fore-vacuum valve, delayed');
   n:=n+EditAddInputLn('Backing pump standby');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_ConfDO'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end; 
  
 {
 Menu Operation mode backing pump to start editing.
 }
 procedure MenuOpMode(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Operation mode backing pump"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Continuous operation');
   n:=n+EditAddInputLn('Intermittent operation');
   n:=n+EditAddInputLn('Delayed switching on');
   n:=n+EditAddInputLn('Delayed interval operation');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_OpMode'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end; 
 
 {
 Menu Gas Mode to start editing.
 }
 procedure MenuGasMode(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Gas Mode"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Heavy gases');
   n:=n+EditAddInputLn('Light gases');
   n:=n+EditAddInputLn('Hhlium');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_GasMode'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;  
 
 {
 Menu Vent Mode to start editing.
 }
 procedure MenuVentMode(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Configuration heating output"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Delayed venting');
   n:=n+EditAddInputLn('No venting');
   n:=n+EditAddInputLn('Direct venting');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_VentMode'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;  
 
 {
 Menu Enable integrated HV Sensor to start editing.
 }
 procedure MenuPress1HVen(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Enable integrated HV Sensor"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Off');
   n:=n+EditAddInputLn('On');
   n:=n+EditAddInputLn('On, when rotation speed switch point reached');
   n:=n+EditAddInputLn('On, when pressure switch point underrun');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_Press1HVen'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;   
 
 {
 Menu Configuration output AO to start editing.
 }
 procedure MenuCfgAO(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Configuration output AO"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Actual rotation speed');
   n:=n+EditAddInputLn('Output');
   n:=n+EditAddInputLn('Current');
   n:=n+EditAddInputLn('Always 0 V');
   n:=n+EditAddInputLn('Always 10 V');
   n:=n+EditAddInputLn('Pressure value 1');
   n:=n+EditAddInputLn('Pressure value 2');
   n:=n+EditAddInputLn('Fore-vacuum control');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CfgAO'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;    
 
 {
 Menu Configuration DI to start editing.
 }
 procedure MenuCfgDI(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Configuration DI"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Deactivated');
   n:=n+EditAddInputLn('Enable venting');
   n:=n+EditAddInputLn('Heating');
   n:=n+EditAddInputLn('Sealing gas');
   n:=n+EditAddInputLn('Run-up time monitoring');
   n:=n+EditAddInputLn('Rotation speed mode');
   n:=n+EditAddInputLn('Motor');
   n:=n+EditAddInputLn('Enable HV sensor 1');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CfgDI'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end; 
 
 {
 Menu Parameter Set to start editing.
 }
 procedure MenuParamSet(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Parameter Set"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Basic parameter set');
   n:=n+EditAddInputLn('Extended parameter set');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CfgParamSet'+str(tag)),Str(iGetTag(tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;   
 
 {
 Handle data requests in simulation mode. 
 }
 procedure EDUTC_Sim(Req:String);
 var cmd,arg:String; rt:Integer;
 begin
 end;
 
 {
 GUI Handler to process user input...
 }
 procedure EDUTC_GUI_POLL;
 var ClickCurve:Integer; s:String;
 begin
  s:='';
  DIM_GuiClickBuff:='';
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,KeyUp)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Copy GUI click to DIM buffer for remote execution.
   }
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle local clicks
     }
     if ClickIsLocal then begin
      {
      Handle sensor clicks...
      }
      if IsSameText(ClickSensor,'HELP') then begin
       Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
       bNul(Voice(snd_Click));
      end;
      if (ClickTag<>0) then begin
       if (ClickTag=EDUTC.ID_IDN.tag) then begin
        DevPostCmd(DevMySelf,'@Remote @Setting IDN');
        bNul(Voice(snd_Click));
       end;
       ClickTagXorRemote(EDUTC.POLL_ENABLE.tag,1);
       
       ClickTagXorRemote(EDUTC.PAR_RUTimeCtrl.tag,1);
       ClickTagXorRemote(EDUTC.PAR_Standby.tag,1);
       ClickTagXorRemote(EDUTC.PAR_PumpgStatn.tag,1);
       ClickTagXorRemote(EDUTC.PAR_MotorPump.tag,1);
       ClickTagXorRemote(EDUTC.PAR_Heating.tag,1);
       ClickTagXorRemote(EDUTC.PAR_EnableVent.tag,1);
       ClickTagXorRemote(EDUTC.PAR_SealingGas.tag,1);
       ClickTagXorRemote(EDUTC.PAR_SpdSetMode.tag,1);
       ClickTagXorRemote(EDUTC.PAR_ParamSet.tag,1);
       
       if (ClickTag=EDUTC.PAR_RUTimeSVal.tag) then if EDUTC_CheckPolling(1) then StartEditTag(ClickTag,'Set Value Run-up Time:');
       if (ClickTag=EDUTC.PAR_SpdSwPt1.tag) then if EDUTC_CheckPolling(1) then StartEditTag(ClickTag,'Rotation Speed Switch P1:');
       if (ClickTag=EDUTC.PAR_SpdSVal.tag) then if EDUTC_CheckPolling(1) then StartEditTag(ClickTag,'Set Value In Rotation Spd:');
       if (ClickTag=EDUTC.PAR_PwrSVal.tag) then if EDUTC_CheckPolling(1) then StartEditTag(ClickTag,'Set Value Power Consumpt:');
       if (ClickTag=EDUTC.PAR_SwOffBKP.tag) then if EDUTC_CheckPolling(1) then StartEditTag(ClickTag,'Backing Pump Switch Off:');
       if (ClickTag=EDUTC.PAR_SwOnBKP.tag) then if EDUTC_CheckPolling(1) then StartEditTag(ClickTag,'Backing Pump Switch On:');
       if (ClickTag=EDUTC.PAR_StdbySVal.tag) then if EDUTC_CheckPolling(1) then StartEditTag(ClickTag,'Set Value Rot Spd At Stdby:');
       if (ClickTag=EDUTC.PAR_SpdSwPt2.tag) then if EDUTC_CheckPolling(1) then StartEditTag(ClickTag,'Rotation Speed Switch P2:');
       if (ClickTag=EDUTC.PAR_VentSpd.tag) then if EDUTC_CheckPolling(1) then StartEditTag(ClickTag,'Venting Rot Spd At Del Ven:');
       if (ClickTag=EDUTC.PAR_VentTime.tag) then if EDUTC_CheckPolling(1) then StartEditTag(ClickTag,'Venting Time At Delayed V:');
       if (ClickTag=EDUTC.PAR_RS485Adr.tag) then if EDUTC_CheckPolling(1) then StartEditTag(ClickTag,'Set RS-485 interface Address:');
       if (ClickTag=EDUTC.PAR_Servicelin.tag) then if EDUTC_CheckPolling(1) then StartEditTag(ClickTag,'Insert Service Line:');
       
       if ClickTag=EDUTC.PAR_CfgDO1.tag then begin // Menu CfgDO1
        bNul(Voice(snd_Click));
        MenuConfDO(EDUTC.PAR_CfgDO1.tag);
       end; 
       
       if ClickTag=EDUTC.PAR_CfgDO2.tag then begin // Menu CfgDO2
        bNul(Voice(snd_Click));
        MenuConfDO(EDUTC.PAR_CfgDO2.tag);
       end;   
  
       if ClickTag=EDUTC.PAR_OpModeBKP.tag then begin // Menu OpModeBKP
        bNul(Voice(snd_Click));
        MenuOpMode(EDUTC.PAR_OpModeBKP.tag);
       end;   
       
       if ClickTag=EDUTC.PAR_GasMode.tag then begin // Menu Gas Mode
        bNul(Voice(snd_Click));
        MenuGasMode(EDUTC.PAR_GasMode.tag);
       end;   
       
       if ClickTag=EDUTC.PAR_VentMode.tag then begin // Menu Vent Mode
        bNul(Voice(snd_Click));
        MenuVentMode(EDUTC.PAR_VentMode.tag);
       end;     
       
       if ClickTag=EDUTC.PAR_Press1HVen.tag then begin // Menu Press1HVen
        bNul(Voice(snd_Click));
        MenuPress1HVen(EDUTC.PAR_Press1HVen.tag);
       end;     
       
       if ClickTag=EDUTC.PAR_CfgAO1.tag then begin // Menu CfgAO1
        bNul(Voice(snd_Click));
        MenuCfgAO(EDUTC.PAR_CfgAO1.tag);
       end;      
       
       if ClickTag=EDUTC.PAR_CfgDI1.tag then begin // Menu CfgDI1
        bNul(Voice(snd_Click));
        MenuCfgDI(EDUTC.PAR_CfgDI1.tag);
       end;      
       
       if ClickTag=EDUTC.PAR_CfgDI2.tag then begin // Menu CfgDI2
        bNul(Voice(snd_Click));
        MenuCfgDI(EDUTC.PAR_CfgDI2.tag);
       end;   
       
       if ClickTag=EDUTC.PAR_ParamSet.tag then begin // Menu ParamSet
        bNul(Voice(snd_Click));
        MenuParamSet(EDUTC.PAR_ParamSet.tag);
       end;      
      end;
      {
      Select Plot & Tab windows by curve...
      }
      ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
      if IsRefCurve(ClickCurve) then begin
       iNul(WinSelectByCurve(ClickCurve,ClickCurve));
       bNul(Voice(snd_Wheel));
      end;
      {
      Console commands: @url_encoded_sensor ...
      }
      if (strFetch(ClickSensor,1)='@') then begin
       DevPostCmd(devMySelf,url_decode(ClickSensor));
       bNul(Voice(snd_Click));
      end;
     end;
     {
     Handle remote clicks comes from DIM via @DimGuiClick message.
     @DimGuiClick default handler decode and write events to FIFO,
     so we can find it as clicks and can handle it in usual way.
     }
     if ClickIsRemote then begin
     writeln('Remote');
      {
      Show time difference.
      }
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      {
      Handle remote console commands...
      }
      s:=Dim_GuiConsoleRecv(DevName,'');
      if (strFetch(s,1)='@') then DevPostCmd(devMySelf,s);
      {
      Handle remote sensor clicks...
      }
      if TypeTag(ClickTag)>0 then begin
       s:=ClickParams('NewValue');
       if Length(s)>0 then begin
        if ClickTag=EDUTC.POLL_ENABLE.tag    then UpdateTag(ClickTag,s,0,1);
        if ClickTag=EDUTC.PAR_RUTimeCtrl.tag then EDUTC.Cmd.OpData[cm_RUTimeCtrl]:=s;
        if ClickTag=EDUTC.PAR_Standby.tag    then EDUTC.Cmd.OpData[cm_Standby]:=s;
        if ClickTag=EDUTC.PAR_PumpgStatn.tag then EDUTC.Cmd.OpData[cm_PumpgStatn]:=s;
        if ClickTag=EDUTC.PAR_MotorPump.tag  then EDUTC.Cmd.OpData[cm_MotorPump]:=s;
        if ClickTag=EDUTC.PAR_Heating.tag    then EDUTC.Cmd.OpData[cm_Heating]:=s;
        if ClickTag=EDUTC.PAR_EnableVent.tag then EDUTC.Cmd.OpData[cm_EnableVent]:=s;
        if ClickTag=EDUTC.PAR_SealingGas.tag then EDUTC.Cmd.OpData[cm_SealingGas]:=s;
        if ClickTag=EDUTC.PAR_SpdSetMode.tag then EDUTC.Cmd.OpData[cm_SpdSetMode]:=s;
        if ClickTag=EDUTC.PAR_ParamSet.tag   then EDUTC.Cmd.OpData[cm_ParamSet]:=s;
       end;
      end;
     end;
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   if CheckEditTag(EDUTC.PAR_RUTimeSVal.tag,s) then EDUTC.Cmd.OpData[cm_RUTimeSVal]:=s;
   if CheckEditTag(EDUTC.PAR_SpdSwPt1.tag,s)   then EDUTC.Cmd.OpData[cm_SpdSwPt1]:=s;
   if CheckEditTag(EDUTC.PAR_SpdSVal.tag,s)    then EDUTC.Cmd.OpData[cm_SpdSVal]:=s;
   if CheckEditTag(EDUTC.PAR_PwrSVal.tag,s)    then EDUTC.Cmd.OpData[cm_PwrSVal]:=s;
   if CheckEditTag(EDUTC.PAR_SwOffBKP.tag,s)   then EDUTC.Cmd.OpData[cm_SwOffBKP]:=s;
   if CheckEditTag(EDUTC.PAR_SwOnBKP.tag,s)    then EDUTC.Cmd.OpData[cm_SwOnBKP]:=s;
   if CheckEditTag(EDUTC.PAR_StdbySVal.tag,s)  then EDUTC.Cmd.OpData[cm_StdbySVal]:=s;
   if CheckEditTag(EDUTC.PAR_SpdSwPt2.tag,s)   then EDUTC.Cmd.OpData[cm_SpdSwPt2]:=s;
   if CheckEditTag(EDUTC.PAR_VentSpd.tag,s)    then EDUTC.Cmd.OpData[cm_VentSpd]:=s;
   if CheckEditTag(EDUTC.PAR_VentTime.tag,s)   then EDUTC.Cmd.OpData[cm_VentTime]:=s;
   if CheckEditTag(EDUTC.PAR_RS485Adr.tag,s)   then EDUTC.Cmd.OpData[cm_RS485Adr]:=s;
   if CheckEditTag(EDUTC.PAR_Servicelin.tag,s) then EDUTC.Cmd.OpData[cm_Servicelin]:=s;
   // Menu CfgDO1
   if EditTestResultName(EditGetUID('MENU_ConfDO'+str(EDUTC.PAR_CfgDO1.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     EDUTC.Cmd.OpData[cm_CfgDO1]:=s;
    end;
    EditReset;
   end;  
   // Menu CfgDO2
   if EditTestResultName(EditGetUID('MENU_ConfDO'+str(EDUTC.PAR_CfgDO2.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     EDUTC.Cmd.OpData[cm_CfgDO2]:=s;
    end;
    EditReset;
   end;
   // Menu OpModeBKP
   if EditTestResultName(EditGetUID('MENU_OpMode'+str(EDUTC.PAR_OpModeBKP.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     EDUTC.Cmd.OpData[cm_OpModeBKP]:=s;
    end;
    EditReset;
   end;    
   // Menu Gas Mode
   if EditTestResultName(EditGetUID('MENU_GasMode'+str(EDUTC.PAR_GasMode.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     EDUTC.Cmd.OpData[cm_GasMode]:=s;
    end;
    EditReset;
   end;     
   // Menu Vent Mode
   if EditTestResultName(EditGetUID('MENU_VentMode'+str(EDUTC.PAR_VentMode.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     EDUTC.Cmd.OpData[cm_VentMode]:=s;
    end;
    EditReset;
   end;     
   // Menu Press1HVen
   if EditTestResultName(EditGetUID('MENU_Press1HVen'+str(EDUTC.PAR_Press1HVen.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     EDUTC.Cmd.OpData[cm_Press1HVen]:=s;
    end;
    EditReset;
   end;      
   // Menu CfgAO1
   if EditTestResultName(EditGetUID('MENU_CfgAO'+str(EDUTC.PAR_CfgAO1.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     EDUTC.Cmd.OpData[cm_CfgAO1]:=s;
    end;
    EditReset;
   end;       
   // Menu CfgDI1
   if EditTestResultName(EditGetUID('MENU_CfgDI'+str(EDUTC.PAR_CfgDI1.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     EDUTC.Cmd.OpData[cm_CfgDI1]:=s;
    end;
    EditReset;
   end;     
   // Menu CfgDI2
   if EditTestResultName(EditGetUID('MENU_CfgDI'+str(EDUTC.PAR_CfgDI2.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     EDUTC.Cmd.OpData[cm_CfgDI2]:=s;
    end;
    EditReset;
   end;      
   // Menu ParamSet
   if EditTestResultName(EditGetUID('MENU_CfgParamSet'+str(EDUTC.PAR_ParamSet.tag))) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     EDUTC.Cmd.OpData[cm_ParamSet]:=s;
    end;
    EditReset;
   end; 
   {
   Warning, Information dialog completion.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'Warning') then sNul(Edit(''));
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'Information') then sNul(Edit(''));
   
  end;
  if EditStateDone then begin
   Problem('Uncompleted edit detected!');
   sNul(Edit(''));
  end else
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Edit error detected!');
   sNul(Edit(''));
  end;
  DIM_GuiClickBuff:='';
  s:='';
 end;
 
 //
 // EDUTC cleanup.
 //
 procedure EDUTC_Clear;
 begin
  EDUTC.Simulator:=False;
  EDUTC.Pfeiffer.Port:=0;
  EDUTC.Pfeiffer.UnitAdr:=0;
  EDUTC.Pfeiffer.Timeout:=0;
  EDUTC.Pfeiffer.Polling:=0;
  EDUTC.Pfeiffer.Deadline:=0;
  ClearPfeifferPoll;
  ClearPfeifferRate;
  ClearCmdTable;
 end;
 //
 // EDUTC initialization.
 //
 procedure EDUTC_Init;
 var i:Integer;
 begin
  //
  // Read ini file variables
  //
  EDUTC_InitTags(ReadIni('tagPrefix'));
  EDUTC.Simulator:=iValDef(ReadIni('Simulator'),0)<>0;
  Success('Simulator='+Str(Ord(EDUTC.Simulator)));
  EDUTC.Pfeiffer.Port:=iValDef(ReadIni('PfeifferPort'),1);
  Success('PfeifferPort='+Str(EDUTC.Pfeiffer.Port));
  EDUTC.Pfeiffer.UnitAdr:=iValDef(ReadIni('DeviceAdress'),10);
  Success('DeviceAdress='+Str(EDUTC.Pfeiffer.UnitAdr));
  EDUTC.Pfeiffer.Polling:=iValDef(ReadIni('PfeifferPolling'),1000);
  Success('PfeifferPolling='+Str(EDUTC.Pfeiffer.Polling));
  EDUTC.Pfeiffer.Timeout:=iValDef(ReadIni('PfeifferTimeout'),500);
  Success('PfeifferTimeout='+Str(EDUTC.Pfeiffer.Timeout));
  EDUTC.Pfeiffer.Deadline:=iValDef(ReadIni('PfeifferDeadline'),60000);
  Success('PfeifferDeadline='+Str(EDUTC.Pfeiffer.Deadline));
  EDUTC.Pfeiffer.DelayOnStart:=iValDef(ReadIni('DelayOnStart'),1000);
  EDUTC.Pfeiffer.DrvName:=ReadIniVar('DrvName',28);
  Success('DrvName = '+EDUTC.Pfeiffer.DrvName);
  EDUTC.ModelCode:=EDUTC_UpdateModel(EDUTC_ParseIDN(EDUTC.Pfeiffer.DrvName,false));
  //
  // Initialize Cmd command table & clear Poll record.
  //
  ClearPfeifferPoll;
  ClearPfeifferRate;
  EDUTC_Init_Cmd;
 end;
 //
 // EDUTC finalization.
 //
 procedure EDUTC_Free;
 begin
  ClearPfeifferPoll;
  ClearPfeifferRate;
  ClearCmdTable;
 end;
 //
 // EDUTC polling.
 //
 procedure EDUTC_Poll;
 begin
  if EDUTC.Simulator then
   if IsPortOpened then begin
    EDUTC_SIM_POLL;
   end;
   
  if not DIM_IsClientMode then begin
   if iGetTag(EDUTC.POLL_ENABLE.tag)>0 then begin
    if SysTimer_Pulse(1000)>0 then begin
     bNul(rSetTag(EDUTC.ERROR_CNT.tag,GetErrCount(-1)));
     UpdateDimTag(EDUTC.ERROR_CNT.tag);
     UpdateAo(ao_ERROR_CNT,time,GetErrCount(-1));
     bNul(rSetTag(EDUTC.POLL_RATE.tag,EDUTC.Pfeiffer.Poll.Rate.Rx));
     UpdateDimTag(EDUTC.POLL_RATE.tag);
     UpdateAo(ao_POLL_RATE,time,EDUTC.Pfeiffer.Poll.Rate.Rx);
     EDUTC.Pfeiffer.Poll.Rate.Rx:=0;
    end;
    
    if mSecNow-FixmSecNow>EDUTC.Pfeiffer.DelayOnStart then EDUTC_CMD_POLL;
   end;
   EDUTC_GUI_POLL;
  end; 
 end;
 //
 // Clear user application strings...
 //
 procedure ClearApplication;
 begin
  ClearNetPfeiffer;
  EDUTC_Clear;
 end;
 //
 // User application Initialization...
 //
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  EDUTC_Init;
  InitNetPfeiffer;
  RunStartupScript;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
  cmd_DimTagUpdate          := RegisterStdInCmd('@DimTagUpdate',          '');
  cmd_Simulate              := RegisterStdInCmd('@Simulate',              '');
  cmd_PrintCmdTable         := RegisterStdInCmd('@PrintCmdTable',         '');
  cmd_Setting               := RegisterStdInCmd('@Setting',               '');
  cmd_Remote                := RegisterStdInCmd('@Remote',                '');
  cmd_Edit                  := RegisterStdInCmd('@Edit',                  '');
  cmd_BrowseHelp            := RegisterStdInCmd('@BrowseHelp',            '');
  cmd_OpenConsole           := RegisterStdInCmd('@OpenConsole',           '');
  cmd_MenuToolsOpen         := RegisterStdInCmd('@MenuToolsOpen',         '');
  cmd_LoadIni               := RegisterStdInCmd('@LoadIni',               '');
  cmd_SaveIni               := RegisterStdInCmd('@SaveIni',               '');
  cmd_MenuToolsConfirmation := RegisterStdInCmd('@MenuToolsConfirmation', '');
 end;
 //
 // User application Finalization...
 //
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  RunFinallyScript;
  FreeNetPfeiffer;
  EDUTC_Free;
 end;
 //
 // User application Polling...
 //
 procedure PollApplication;
 var i,cs:Integer;
 begin
  PollNetPfeiffer;
  EDUTC_Poll;
 end;
 //
 // Process data coming from standard input...
 //
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,dat:String; cmdid,tag,n,m,ref,cid,tim,port,adr,par,len:Integer;
  procedure OpenConsole(s:String);
  begin
   if IsEmptyStr(s) then s:=DevName;
   bNul(WinShow(ParamStr('Console '+s)));
   bNul(WinSelect(ParamStr('Console '+s)));
  end;
  procedure UpdateAoByTag(AoNum,tag:Integer);
  begin
   if (AoNum>=0) then begin
    if TypeTag(tag)=1 then UpdateAo(AoNum,time,iGetTag(tag));
    if TypeTag(tag)=2 then UpdateAo(AoNum,time,rGetTag(tag));
   end;
  end;
  procedure UpdateSettingsAfterLoadIni;
  begin 
   if (iGetTag(EDUTC.POLL_ENABLE.tag)<>0) then begin
    //DevPostCmd(DevMySelf,'@Setting AZ '+TagAsText(EDUTC.PAR_AZ.tag));
   end;
  end; 
  procedure CheckEdit(var n:Integer; s:String);
  begin
   if Pos('?',s)>0 then n:=n+1;
  end;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  dat:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @DimTagUpdate tag
   }
   if (cmdid=cmd_DimTagUpdate) then begin
    if DIM_IsClientMode and not DIM_IsServerMode then begin
     tag:=FindTag(Trim(arg));
     if TypeTag(tag)>0 then begin
      if tag=EDUTC.POLL_RATE.tag       then UpdateAoByTag(ao_POLL_RATE      ,tag);
      if tag=EDUTC.PAR_Heating.tag     then UpdateAoByTag(ao_PAR_Heating    ,tag);
      if tag=EDUTC.PAR_Standby.tag     then UpdateAoByTag(ao_PAR_Standby    ,tag);
      if tag=EDUTC.PAR_RUTimeCtrl.tag  then UpdateAoByTag(ao_PAR_RUTimeCtrl ,tag);
      if tag=EDUTC.PAR_ErrorAckn.tag   then UpdateAoByTag(ao_PAR_ErrorAckn  ,tag);
      if tag=EDUTC.PAR_PumpgStatn.tag  then UpdateAoByTag(ao_PAR_PumpgStatn ,tag);
      if tag=EDUTC.PAR_EnableVent.tag  then UpdateAoByTag(ao_PAR_EnableVent ,tag);
      if tag=EDUTC.PAR_CfgSpdSwPt.tag  then UpdateAoByTag(ao_PAR_CfgSpdSwPt ,tag);
      if tag=EDUTC.PAR_CfgDO2.tag      then UpdateAoByTag(ao_PAR_CfgDO2     ,tag);
      if tag=EDUTC.PAR_MotorPump.tag   then UpdateAoByTag(ao_PAR_MotorPump  ,tag);
      if tag=EDUTC.PAR_CfgDO1.tag      then UpdateAoByTag(ao_PAR_CfgDO1     ,tag);
      if tag=EDUTC.PAR_OpModeBKP.tag   then UpdateAoByTag(ao_PAR_OpModeBKP  ,tag);
      if tag=EDUTC.PAR_SpdSetMode.tag  then UpdateAoByTag(ao_PAR_SpdSetMode ,tag);
      if tag=EDUTC.PAR_GasMode.tag     then UpdateAoByTag(ao_PAR_GasMode    ,tag);
      if tag=EDUTC.PAR_VentMode.tag    then UpdateAoByTag(ao_PAR_VentMode   ,tag);
      if tag=EDUTC.PAR_CfgAccA1.tag    then UpdateAoByTag(ao_PAR_CfgAccA1   ,tag);
      if tag=EDUTC.PAR_CfgAccB1.tag    then UpdateAoByTag(ao_PAR_CfgAccB1   ,tag);
      if tag=EDUTC.PAR_CfgAccA2.tag    then UpdateAoByTag(ao_PAR_CfgAccA2   ,tag);
      if tag=EDUTC.PAR_CfgAccB2.tag    then UpdateAoByTag(ao_PAR_CfgAccB2   ,tag);
      if tag=EDUTC.PAR_Press1HVen.tag  then UpdateAoByTag(ao_PAR_Press1HVen ,tag);
      if tag=EDUTC.PAR_SealingGas.tag  then UpdateAoByTag(ao_PAR_SealingGas ,tag);
      if tag=EDUTC.PAR_CfgAO1.tag      then UpdateAoByTag(ao_PAR_CfgAO1     ,tag);
      if tag=EDUTC.PAR_CtrlVialnt.tag  then UpdateAoByTag(ao_PAR_CtrlVialnt ,tag);
      if tag=EDUTC.PAR_IntSelLckd.tag  then UpdateAoByTag(ao_PAR_IntSelLckd ,tag);
      if tag=EDUTC.PAR_CfgDI1.tag      then UpdateAoByTag(ao_PAR_CfgDI1     ,tag);
      if tag=EDUTC.PAR_CfgDI2.tag      then UpdateAoByTag(ao_PAR_CfgDI2     ,tag);
      if tag=EDUTC.PAR_RemotePrio.tag  then UpdateAoByTag(ao_PAR_RemotePrio ,tag);
      if tag=EDUTC.PAR_SpdSwPtAtt.tag  then UpdateAoByTag(ao_PAR_SpdSwPtAtt ,tag);
      if tag=EDUTC.PAR_ErrorCode.tag   then UpdateAoByTag(ao_PAR_ErrorCode  ,tag);
      if tag=EDUTC.PAR_OvTempElec.tag  then UpdateAoByTag(ao_PAR_OvTempElec ,tag);
      if tag=EDUTC.PAR_OvTempPump.tag  then UpdateAoByTag(ao_PAR_OvTempPump ,tag);
      if tag=EDUTC.PAR_SetSpdAtt.tag   then UpdateAoByTag(ao_PAR_SetSpdAtt  ,tag);
      if tag=EDUTC.PAR_PumpAccel.tag   then UpdateAoByTag(ao_PAR_PumpAccel  ,tag);
      if tag=EDUTC.PAR_SetRotSpd.tag   then UpdateAoByTag(ao_PAR_SetRotSpd  ,tag);
      if tag=EDUTC.PAR_ActualSpd.tag   then UpdateAoByTag(ao_PAR_ActualSpd  ,tag);
      if tag=EDUTC.PAR_DrvCurrent.tag  then UpdateAoByTag(ao_PAR_DrvCurrent ,tag);
      if tag=EDUTC.PAR_OpHrsPump.tag   then UpdateAoByTag(ao_PAR_OpHrsPump  ,tag);
      if tag=EDUTC.PAR_FWVersion.tag   then UpdateAoByTag(ao_PAR_FWVersion  ,tag);
      if tag=EDUTC.PAR_DrvVoltage.tag  then UpdateAoByTag(ao_PAR_DrvVoltage ,tag);
      if tag=EDUTC.PAR_OpHrsElec.tag   then UpdateAoByTag(ao_PAR_OpHrsElec  ,tag);
      if tag=EDUTC.PAR_NominalSpd.tag  then UpdateAoByTag(ao_PAR_NominalSpd ,tag);
      if tag=EDUTC.PAR_DrvPower.tag    then UpdateAoByTag(ao_PAR_DrvPower   ,tag);
      if tag=EDUTC.PAR_PumpCycles.tag  then UpdateAoByTag(ao_PAR_PumpCycles ,tag);
      if tag=EDUTC.PAR_TempElec.tag    then UpdateAoByTag(ao_PAR_TempElec   ,tag);
      if tag=EDUTC.PAR_TempPmpBot.tag  then UpdateAoByTag(ao_PAR_TempPmpBot ,tag);
      if tag=EDUTC.PAR_AccelDecel.tag  then UpdateAoByTag(ao_PAR_AccelDecel ,tag);
      if tag=EDUTC.PAR_SealGasFlw.tag  then UpdateAoByTag(ao_PAR_SealGasFlw ,tag);
      if tag=EDUTC.PAR_TempBearng.tag  then UpdateAoByTag(ao_PAR_TempBearng ,tag);
      if tag=EDUTC.PAR_TempMotor.tag   then UpdateAoByTag(ao_PAR_TempMotor  ,tag);
      if tag=EDUTC.PAR_ElecName.tag    then UpdateAoByTag(ao_PAR_ElecName   ,tag);
      if tag=EDUTC.PAR_HWVersion.tag   then UpdateAoByTag(ao_PAR_HWVersion  ,tag);
      if tag=EDUTC.PAR_ErrHist1.tag    then UpdateAoByTag(ao_PAR_ErrHist1   ,tag);
      if tag=EDUTC.PAR_ErrHist2.tag    then UpdateAoByTag(ao_PAR_ErrHist2   ,tag);
      if tag=EDUTC.PAR_ErrHist3.tag    then UpdateAoByTag(ao_PAR_ErrHist3   ,tag);
      if tag=EDUTC.PAR_ErrHist4.tag    then UpdateAoByTag(ao_PAR_ErrHist4   ,tag);
      if tag=EDUTC.PAR_ErrHist5.tag    then UpdateAoByTag(ao_PAR_ErrHist5   ,tag);
      if tag=EDUTC.PAR_ErrHist6.tag    then UpdateAoByTag(ao_PAR_ErrHist6   ,tag);
      if tag=EDUTC.PAR_ErrHist7.tag    then UpdateAoByTag(ao_PAR_ErrHist7   ,tag);
      if tag=EDUTC.PAR_ErrHist8.tag    then UpdateAoByTag(ao_PAR_ErrHist8   ,tag);
      if tag=EDUTC.PAR_ErrHist9.tag    then UpdateAoByTag(ao_PAR_ErrHist9   ,tag);
      if tag=EDUTC.PAR_ErrHist10.tag   then UpdateAoByTag(ao_PAR_ErrHist10  ,tag);
      if tag=EDUTC.PAR_SetRotRPM.tag   then UpdateAoByTag(ao_PAR_SetRotRPM  ,tag);
      if tag=EDUTC.PAR_ActualRPM.tag   then UpdateAoByTag(ao_PAR_ActualRPM  ,tag);
      if tag=EDUTC.PAR_NominalRPM.tag  then UpdateAoByTag(ao_PAR_NominalRPM ,tag);
      if tag=EDUTC.PAR_RUTimeSVal.tag  then UpdateAoByTag(ao_PAR_RUTimeSVal ,tag);
      if tag=EDUTC.PAR_SpdSwPt1.tag    then UpdateAoByTag(ao_PAR_SpdSwPt1   ,tag);
      if tag=EDUTC.PAR_SpdSVal.tag     then UpdateAoByTag(ao_PAR_SpdSVal    ,tag);
      if tag=EDUTC.PAR_PwrSVal.tag     then UpdateAoByTag(ao_PAR_PwrSVal    ,tag);
      if tag=EDUTC.PAR_SwOffBKP.tag    then UpdateAoByTag(ao_PAR_SwOffBKP   ,tag);
      if tag=EDUTC.PAR_SwOnBKP.tag     then UpdateAoByTag(ao_PAR_SwOnBKP    ,tag);
      if tag=EDUTC.PAR_StdbySVal.tag   then UpdateAoByTag(ao_PAR_StdbySVal  ,tag);
      if tag=EDUTC.PAR_SpdSwPt2.tag    then UpdateAoByTag(ao_PAR_SpdSwPt2   ,tag);
      if tag=EDUTC.PAR_VentSpd.tag     then UpdateAoByTag(ao_PAR_VentSpd    ,tag);
      if tag=EDUTC.PAR_VentTime.tag    then UpdateAoByTag(ao_PAR_VentTime   ,tag);
      if tag=EDUTC.PAR_PrsSwPt1.tag    then UpdateAoByTag(ao_PAR_PrsSwPt1   ,tag);
      if tag=EDUTC.PAR_PrsSwPt2.tag    then UpdateAoByTag(ao_PAR_PrsSwPt2   ,tag);
      if tag=EDUTC.PAR_PrsSn1Name.tag  then UpdateAoByTag(ao_PAR_PrsSn1Name ,tag);
      if tag=EDUTC.PAR_Pressure1.tag   then UpdateAoByTag(ao_PAR_Pressure1  ,tag);
      if tag=EDUTC.PAR_PrsCorrPi1.tag  then UpdateAoByTag(ao_PAR_PrsCorrPi1 ,tag);
      if tag=EDUTC.PAR_PrsSn2Name.tag  then UpdateAoByTag(ao_PAR_PrsSn2Name ,tag);
      if tag=EDUTC.PAR_Pressure2.tag   then UpdateAoByTag(ao_PAR_Pressure2  ,tag);
      if tag=EDUTC.PAR_PrsCorrPi2.tag  then UpdateAoByTag(ao_PAR_PrsCorrPi2 ,tag);
      if tag=EDUTC.PAR_NomSpdConf.tag  then UpdateAoByTag(ao_PAR_NomSpdConf ,tag);
      if tag=EDUTC.PAR_SlgWrnThrs.tag  then UpdateAoByTag(ao_PAR_SlgWrnThrs ,tag);
      if tag=EDUTC.PAR_RS485Adr.tag    then UpdateAoByTag(ao_PAR_RS485Adr   ,tag);
      if tag=EDUTC.PAR_Pressure.tag    then UpdateAoByTag(ao_PAR_Pressure   ,tag);
      if tag=EDUTC.PAR_CtrName.tag     then UpdateAoByTag(ao_PAR_CtrName    ,tag);
      if tag=EDUTC.PAR_CtrSoftware.tag then UpdateAoByTag(ao_PAR_CtrSoftware,tag);
      if tag=EDUTC.PAR_ParamSet.tag    then UpdateAoByTag(ao_PAR_ParamSet   ,tag);
      if tag=EDUTC.PAR_Servicelin.tag  then UpdateAoByTag(ao_PAR_Servicelin ,tag);
     end;                              
    end;                               
   end else  
   {
   @Pfeiffer.Reply ref cid tim port adr act par len $$dat
   }
   if IsSameText(cmd,'@Pfeiffer.Reply') then begin
    { dat:=''; }
    if Pfeiffer_proxy_reply(cmd,arg,ref,cid,tim,port,adr,par,len,dat)
    then EDUTC_OnReply(ref,cid,tim,port,adr,par,len,dat)
    else Trouble('Bad '+cmd+' format');
    ClearPfeifferPoll;
    Data:='';
   end else
   {
   @Pfeiffer.Poll ref cid tim port adr par $$dat
   This message uses in simulation mode only
   }
   if IsSameText(cmd,'@Pfeiffer.Poll') then begin
    if pfeiffer_proxy_reply(cmd,arg,ref,cid,tim,port,adr,par,len,dat)
    then EDUTC_OnSimPoll(ref,cid,tim,port,adr,par,len,dat)
    else Trouble('Bad '+cmd+' format');
    Data:='';
   end else
   {
   @Pfeiffer.Refuse ...
   }
   if IsSameText(cmd,'@Pfeiffer.Refuse') then begin
    EDUTC.Pfeiffer.Poll.Rate.Ex:=EDUTC.Pfeiffer.Poll.Rate.Ex+1;
    if Pfeiffer_proxy_reply(cmd,arg,ref,cid,tim,port,adr,par,len,dat)
    then Trouble(Pfeiffer_proxy_nice(cmd,ref,cid,tim,port,adr,par,len,dat,64))
    else Trouble(cmd+' '+arg);
    ClearPfeifferPoll;
    Data:='';
   end else
   {
   @Pfeiffer.Timeout ...
   }
   if IsSameText(cmd,'@Pfeiffer.Timeout') then begin
    EDUTC.Pfeiffer.Poll.Rate.Ex:=EDUTC.Pfeiffer.Poll.Rate.Ex+1;
    if Pfeiffer_proxy_reply(cmd,arg,ref,cid,tim,port,adr,par,len,dat)
    then Trouble(Pfeiffer_proxy_nice(cmd,ref,cid,tim,port,adr,par,len,dat,64))
    else Trouble(cmd+' '+arg);
    ClearPfeifferPoll;
    //EnableIDN;
    Data:='';
   end else   
   {
   @BrowseHelp
   }
   if (cmdid=cmd_BrowseHelp) then begin
    rNul(Eval('@Global @Async @Silent @Run WebBrowser '+DaqFileRef(ReadIni('HelpFile'),'.htm')));
    Data:='';
   end else
   {
   @Remote
   }
   if (cmdid=cmd_Remote) then begin
    if not IsEmptyStr(arg) then PostCmdRemote(Trim(arg));
    Data:='';
   end else
   {
   @OpenConsole
   }
   if (cmdid=cmd_OpenConsole) then begin
    OpenConsole(arg);
    Data:='';
   end else
   {
   @PrintCmdTable
   }
   if (cmdid=cmd_PrintCmdTable) then begin
    PrintCmdTable;
    Data:='';
   end else
   {
   @LoadIni
   }
   if (cmdid=cmd_LoadIni) then begin
    if not EDUTC.Simulator and not DIM_IsClientMode then begin
     iNul(CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg))));
     UpdateSettingsAfterLoadIni;
    end;
    Data:='';
   end else
   {
   @SaveIni
   }
   if (cmdid=cmd_SaveIni) then begin
    if not EDUTC.Simulator and not DIM_IsClientMode then begin
     iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    end;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{*************************************************** }
{*************************************************** }
{***                                             *** }
{***  MMM    MMM        AAA   IIII   NNN    NN   *** }
{***  MMMM  MMMM       AAAA    II    NNNN   NN   *** }
{***  MM MMMM MM      AA AA    II    NN NN  NN   *** }
{***  MM  MM  MM     AA  AA    II    NN  NN NN   *** }
{***  MM      MM    AAAAAAA    II    NN   NNNN   *** }
{***  MM      MM   AA    AA   IIII   NN    NNN   *** }
{***                                             *** }
{*************************************************** }
{$I _std_main}{<== Please never change this code *** }
{*************************************************** }
