program sin_server;
const
 snd_Click   = 'Click';   { Sound on button click            }
 snd_Fails   = 'Fails';   { Sound on operation failure       }
 dfTrouble   = 1;         { DebugFlags - Trouble             }
 dfSuccess   = 2;         { DebugFlags - Success             }
 dfViewExp   = 4;         { DebugFlags - ViewExp             }
 dfViewImp   = 8;         { DebugFlags - ViewImp             }
 DimSrv      = '&DimSrv'; { DIM server device name           }
var
 b           : Boolean;   { Temporary                        }
 s           : String;    { Temporary                        }
 Ok          : Boolean;   { Program initialization is Ok?    }
 errors      : Integer;   { Program error counter            }
 errorcode   : Integer;   { Error code for this device       }
 fixmaxavail : Integer;   { String manager leak control      }
 DebugFlags  : Integer;   { Debug bit flags                  }
 StdIn       : Record     { Standard input data:             }
  Line       : String;    { Incoming line                    }
  Cmnd,Data  : String;    { Cmnd or Cmnd=Data                }
 end;
 Click       : Record     { Click event information:         }
  Cmnd,Data  : String;    { Cmnd or Cmnd=Data                }
  Button     : Integer;   { Clicked button                   }
  Sensor     : String;    { Clicked sensor name              }
  Device     : String;    { Clicked sensor device name       }
  Window     : String;    { Clicked sensor window name       }
  Curve      : String;    { Clicked sensor curve  name       }
  Tag        : String;    { Clicked sensor tag    name       }
  Value      : String;    { Clicked sensor tag old value     }
  Guard      : String;    { Guard level Lock/Guest/User/Root }
  User       : String;    { User name                        }
  Host       : String;    { Host name                        }
  IP         : String;    { IP address                       }
  MAC        : String;    { MAC address                      }
  newValue   : String;    { Clicked sensor tag new value     }
 end;
 tagStart    : Integer;   { Start button                     }
 tagFreq     : Integer;   { Frequency value                  }
 tagAmpl     : Integer;   { Amplitude value                  }
 tagNoise    : Integer;   { Noise value                      }
 tagClick    : Integer;   { Sensor click information         }
 tagNotify   : Integer;   { Sensor click notification        }
 tagPostBox  : Integer;   { Shared data path                 }
 devDimSrv   : Integer;   { Dim server reference             }
 x,y         : Real;      { Temporary                        }
 {
 Dialog with warning message
 }
 procedure Warning(msg:string);
 var b:boolean;
 begin
  if editstate=0 
  then msg:=edit('('+msg)+edit(')Warning')
  else b:=Echo(msg);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if iand(DebugFlags,dfViewImp)<>0 then
  if length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if iand(DebugFlags,dfViewExp)<>0 then
  if length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Check I/O status.
 }
 function IoError:boolean;
 begin
  IoError:=false;
  if ioresult<>0 then begin
   Trouble('I/O error.');
   IoError:=true;
  end;
 end;
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var s:string):boolean;
 begin
  StdIn_Readln:=false;
  if not IoError then 
  if not eof then begin
   readln(s);
   if not IoError then StdIn_Readln:=true;
  end;
 end;
 {
 Speak, i.e. send message to speech server.
 }
 procedure Speak(msg:String);
 var b:Boolean; ref:Integer;
 begin
  msg:=Trim(msg);
  if Length(msg)>0 then begin
   ref:=RefFind('Device &SpeakSrv');
   if ref<>0 then b:=DevSend(ref,'@speak='+msg+EOL)>0;
  end;
 end;
 {
 Post message to DIM server.
 }
 procedure DIM_Post(msg:String);
 begin
  if Length(msg)>0 then
  if devPost(devDimSrv,msg)=0
  then Trouble('Failed devPost to '+DimSrv);
 end;
 {
 Post message to DIM server to update tag.
 Post also new tag value if data specified.
 }
 procedure DIM_UpdateTag(tag:Integer; data:String);
 begin
  if TypeTag(tag)>0 then begin
   if Length(data)=0
   then DIM_Post('##'+Str(tag)+EOL)
   else DIM_Post('##'+Str(tag)+'='+mime_encode(data)+EOL);
  end;
 end;
 {
 Convert string lines with EOL delimeters into text.
 }
 function StringToText(s:String):Integer;
 var t,p:Integer; b:Boolean;
 begin
  t:=text_new;
  while Length(s)>0 do begin
   p:=Pos(EOL,s);
   if p=0 then p:=Length(s)+1;
   if p>1 then b:=text_addln(t,Copy(s,1,p-1));
   s:=Copy(s,p+Length(EOL));
  end;
  StringToText:=t;
 end;
 {
 Compare guard levels.
 -1 if g1 less then  g2
  0 if g1 equavalent g2
 +1 if g1 more tehn  g2
 }
 function CompareGuards(g1,g2:String):Integer;
 const GuardList='LOCK,GUEST,USER,ROOT';
 var p,p1,p2:Integer;
 begin
  p1:=pos(UpCaseStr(Trim(g1)),GuardList);
  p2:=pos(UpCaseStr(Trim(g2)),GuardList);
  if (p1=0) or (p2=0) then p:=-1 else p:=sign(p2-p1);
  CompareGuards:=p;
 end;
 {
 Check if given (Guard,User,Host,IP,MAC) set have access rights.
 }
 function GrantAccess(Guard,User,Host,IP,MAC:String):Boolean;
 var t,i:Integer; w1,w2,w3,w4,w5:String; g,g1,g2,g3,g4,g5:Boolean;
 begin
  g:=false;
  w1:='';w2:='';w3:='';w4:='';w5:='';
  t:=ReadIniSection(text_new,16,'',ReadIni('TrustedUsers'));
  for i:=0 to text_numln(t)-1 do
  if WordCount(text_getln(t,i))=5 then begin
   w1:=ExtractWord(1,text_getln(t,i));  if w1='.' then w1:=ParamStr('Guard');
   w2:=ExtractWord(2,text_getln(t,i));  if w2='.' then w2:=ParamStr('UserName');
   w3:=ExtractWord(3,text_getln(t,i));  if w3='.' then w3:=ParamStr('HostName');
   w4:=ExtractWord(4,text_getln(t,i));  if w4='.' then w4:=ParamStr('IPAddress');
   w5:=ExtractWord(5,text_getln(t,i));  if w5='.' then w5:=ExtractWord(1,ParamStr('MACAddress'));
   g1:=IsSameText(w1,'*') or (CompareGuards(w1,Guard)>=0);
   g2:=IsSameText(w2,'*') or IsSameText(w2,User);
   g3:=IsSameText(w3,'*') or IsSameText(w3,Host);
   g4:=IsSameText(w4,'*') or IsSameText(w4,IP);
   g5:=IsSameText(w5,'*') or IsSameText(w5,ExtractWord(1,MAC));
   if g1 and g2 and g3 and g4 and g5 then g:=true;
  end;
  b:=text_free(t);
  w1:='';w2:='';w3:='';w4:='';w5:='';
  GrantAccess:=g;
 end;
 {
 Update tag with new value and with range checking.
 }
 procedure UpdateTag(tag:Integer; newValue:String; min,max:Real);
 var rValue:Real;
 begin
  rValue:=0;
  case TypeTag(tag) of
   0:;
   1:begin
      rValue:=rVal(newValue);
      if rValue<min then rValue:=_Nan;
      if rValue>max then rValue:=_Nan;
      if not IsNan(rValue) then b:=iSetTag(tag,Round(rValue));
     end;
   2:begin
      rValue:=rVal(newValue);
      if rValue<min then rValue:=_Nan;
      if rValue>max then rValue:=_Nan;
      if not IsNan(rValue) then b:=rSetTag(tag,rValue);
     end;
   3:b:=sSetTag(tag,newValue);
  end;
  if TypeTag(tag)>0 then begin
   if not IsNan(rValue) then begin
    DIM_UpdateTag(tag,'');
    DIM_UpdateTag(tagNotify,'Ok');
   end else begin
    DIM_UpdateTag(tagNotify,'Invalid Value="'+newValue+'" in tag "'+NameTag(tag)+'".');
   end;
  end;
 end;
 {
 Handle remote sensor click.
 }
 procedure HandleRemoteClick(Button:Integer;Sensor,Device,Window,Value,Curve,Tag,
                             Guard,User,Host,IP,MAC,newValue:String);
 begin
  if Button=1 then begin
   if IsSameText(Sensor,'SIN_START') then UpdateTag(tagStart,newValue,0,1);
   if IsSameText(Sensor,'SIN_FREQ')  then UpdateTag(tagFreq, newValue,0,10);
   if IsSameText(Sensor,'SIN_AMPL')  then UpdateTag(tagAmpl, newValue,0,100);
   if IsSameText(Sensor,'SIN_NOISE') then UpdateTag(tagNoise,newValue,0,10);
   Speak('Пользователь '+User+' нажал сенсор '+Sensor);
  end;
 end;
 {
 Decode full sensor click information from long string...
 }
 procedure DecodeClick(s:String);
 var t,i,p:Integer;
 begin
  Click.Button:=0;
  Click.Cmnd:='';    Click.Data:='';    Click.Sensor:='';  Click.Device:='';
  Click.Window:='';  Click.Value:='';   Click.Curve:='';   Click.Tag:='';
  Click.Guard:='';   Click.User:='';    Click.Host:='';    Click.IP:='';
  Click.MAC:='';     Click.newValue:='';
  t:=StringToText(s);
  if IsSameText(text_getln(t,0),'@click') then begin
   for i:=1 to text_numln(t)-1 do begin
    p:=Pos('=',text_getln(t,i)); if p=0 then p:=Length(text_getln(t,i))+1;
    Click.Cmnd:=Copy(text_getln(t,i),1,p-1);
    Click.Data:=Copy(text_getln(t,i),p+1);
    if IsSameText(Click.Cmnd,'Button')   then Click.Button:=Val(Click.Data);
    if IsSameText(Click.Cmnd,'Sensor')   then Click.Sensor:=Click.Data;
    if IsSameText(Click.Cmnd,'Device')   then Click.Device:=Click.Data;
    if IsSameText(Click.Cmnd,'Window')   then Click.Window:=Click.Data;
    if IsSameText(Click.Cmnd,'Value')    then Click.Value:=Click.Data;
    if IsSameText(Click.Cmnd,'Curve')    then Click.Curve:=Click.Data;
    if IsSameText(Click.Cmnd,'Tag')      then Click.Tag:=Click.Data;
    if IsSameText(Click.Cmnd,'User')     then Click.User:=Click.Data;
    if IsSameText(Click.Cmnd,'Host')     then Click.Host:=Click.Data;
    if IsSameText(Click.Cmnd,'IP')       then Click.IP:=Click.Data;
    if IsSameText(Click.Cmnd,'MAC')      then Click.MAC:=Click.Data;
    if IsSameText(Click.Cmnd,'Guard')    then Click.Guard:=Click.Data;
    if IsSameText(Click.Cmnd,'newValue') then Click.newValue:=Click.Data;
   end;
  end;
  b:=text_free(t);
  if Click.Button<>0 then begin
   if GrantAccess(Click.Guard,Click.User,Click.Host,Click.IP,Click.MAC)
   then HandleRemoteClick(Click.Button, Click.Sensor, Click.Device, Click.Window,
                          Click.Value,  Click.Curve,  Click.Tag,    Click.Guard,
                          Click.User,   Click.Host,   Click.IP,     Click.MAC,
                          Click.newValue)
   else DIM_UpdateTag(tagNotify,'DENY '+Click.Guard+':'+Click.User+'@'+
                                        Click.Host+' ('+Click.IP+')!');
  end;
  Click.Cmnd:='';    Click.Data:='';    Click.Sensor:='';  Click.Device:='';
  Click.Window:='';  Click.Value:='';   Click.Curve:='';   Click.Tag:='';
  Click.Guard:='';   Click.User:='';    Click.Host:='';    Click.IP:='';
  Click.MAC:='';     Click.newValue:='';
 end;
 {
 Analyse data coming from standard input.
 }
 procedure StdIn_Process(s:string);
 var p:Integer;
 begin
  ViewImp(s);
  p:=pos('=',s); if p=0 then p:=Length(s)+1;
  StdIn.Cmnd:=Trim(Copy(s,1,p-1));
  StdIn.Data:=Trim(Copy(s,p+1));
  if IsSameText('@click',StdIn.Cmnd) then begin
   if Length(StdIn.Data)=0
   then StdIn.Data:=sGetTag(tagClick)
   else StdIn.Data:=Trim(mime_decode(StdIn.Data));
   if Length(StdIn.Data)>0 then DecodeClick(crypt_decode(StdIn.Data,'crw-daq.ru'));
   b:=sSetTag(tagClick,'');
  end;
  StdIn.Cmnd:='';
  StdIn.Data:='';
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 begin
  s:='';
  StdIn.Line:='';    StdIn.Cmnd:='';    StdIn.Data:='';
  Click.Cmnd:='';    Click.Data:='';    Click.Sensor:='';  Click.Device:='';
  Click.Window:='';  Click.Value:='';   Click.Curve:='';   Click.Tag:='';
  Click.Guard:='';   Click.User:='';    Click.Host:='';    Click.IP:='';
  Click.MAC:='';     Click.newValue:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Initialize and check tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
begin
 {
 Initialization actions on Start...
 }
 if runcount=1 then begin
  {
  Initialize errors...
  }
  errors:=0;
  errorcode:=registererr(devname);
  {
  Clear and initialize variables...
  }
  ClearStrings;
  DebugFlags:=val(ReadIni('DebugFlags'));
  Success('Start mmTimer='+Str(eval('@system @mmtimer 1'))+' [ms].');
  {
  Open console window...
  }
  if val(ReadIni('OpenConsole'))>0 then begin
   s:=ParamStr('Console '+devname);
   b:=winshow(s);
   b:=windraw(s+'|top=317|left=167|Width=600|Height=317');
   b:=winselect(s);
   if val(ReadIni('OpenConsole'))>1 then b:=winhide(s);
  end;
  {
  Initialize tags...
  }
  InitTag(tagStart,		'sin_start',		1);
  InitTag(tagFreq,		'sin_freq',		2);
  InitTag(tagAmpl,		'sin_ampl',		2);
  InitTag(tagNoise,		'sin_noise',		2);
  InitTag(tagClick,		'sin_click',		3);
  InitTag(tagNotify,	'sin_notify',		3);
  InitTag(tagPostBox,	'sin_postbox',		3);
  {
  Initialize DIM device reference...
  }
  devDimSrv:=RefFind('Device '+DimSrv);
  if devDimSrv=0 then Trouble('Could not find '+DimSrv);
  {
  Set shared data path
  }
  s:=ReadIni('PostBox');
  if Length(s)>0 then begin
   s:=DaqFileRef(s,'');
   if pos(':',s)=2 then begin
    s:='\\'+ParamStr('HostName')+'\'+Copy(s,1,1)+'$'+Copy(s,3);
    s:=AddBackSlash(s);
    if not FileExists(s)
    then b:=Echo(devname+' ! Postbox "'+s+'" is not shared!');
   end;
  end;
  b:=sSetTag(tagPostBox,s);
  DIM_UpdateTag(tagPostBox,'');
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok.') else Trouble('Start Fails.');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop...
 }
 if isinf(runcount) then begin
  Success('Stop mmTimer='+Str(eval('@system @mmtimer 0'))+' [ms].');
  ClearStrings;
  Success('Stop.');
 end else
 {
 Actions on Poll
 }
 if Ok then begin
  {
  Check standard I/O errors...
  }
  if ioresult<>0 then b:=fixerror(errorcode);
  {
  Process standard input...
  }
  while StdIn_Readln(StdIn.Line) do StdIn_Process(StdIn.Line);
  {
  Generate sin and cos waves
  }
  if igettag(tagStart)>0 then begin
   x:=time;
   y:=rGetTag(tagAmpl)*sin(2*pi*x*rGetTag(tagFreq))+rGetTag(tagNoise)*Random(-1,1);
   b:=putao(0,x,y);
   y:=rGetTag(tagAmpl)*cos(2*pi*x*rGetTag(tagFreq))+rGetTag(tagNoise)*Random(-1,1);
   b:=putao(1,x,y);
  end;
 end;
end.
