@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem **************************************
rem SRS DG645 devices config generator
rem **************************************

chcp 65001 & rem Set CodePage UTF8

:Main
call :InitializeVariables
pushd "%~dp0" && call :DG645Devices
popd
goto :EOF

:SetUnixPath
for /f "tokens=* delims=" %%a in ('unix path') do set "%%a"
goto :EOF

:InitializeVariables
set hdwcfg=%~n0_hdw.cfg
set simcfg=%~n0_sim.cfg
set diccfg=%~n0_dic.cfg
set discfg=%~n0_dis.cfg
set devmsg=devPostMsg
set tabcrc=..\Circuits\%~n0_link.crc
set /a numhdwcfg=0
set /a CTRL_TOP=0
set /a CTRL_LEFT=700
set /a CTRL_TOP_STEP=100
set /a TABCRC_TOP=0
set /a TABCRC_STEP=90
goto :EOF

:DG645Devices
call :DeleteFiles %hdwcfg% %simcfg% %tabcrc% %diccfg% %discfg%
rem   Device     Facility DevName Identitier COM  TcpPort IPClient       Polling Priority   DevLabel
call :DG645      DGCS     DG645   G1         1    5025    172.21.4.240   4       tpHighest  G1
call :DG645      DGCS     DG645   G2         2    5025    172.21.1.240   4       tpHighest  G2
call :DG645      DGCS     DG645   G3         3    5025    172.21.2.240   4       tpHighest  G3
call :DG645      DGCS     DG645   G4         4    5025    172.21.3.240   4       tpHighest  G4
type %hdwcfg%
goto :EOF

:DG645
call :DG645_SET %*
call :DG645_HDW %* >> %hdwcfg%
call :DG645_SIM %* >> %simcfg%
call :DG645_DIC %* >> %diccfg%
call :DG645_DIS %* >> %discfg%
call :DG645_TABCRC >> %tabcrc%
set /a CTRL_TOP+=CTRL_TOP_STEP
goto :EOF

:DG645_SET
set "FN=%~1"       &shift     & :: Facility name
set "DEV=%~1"      &shift     & :: Device Name
set "IDEN=%~1"     &shift     & :: Identifier
set "ComPort=%~1"  &shift     & :: Virtual COM Port number
set "TcpPort=%~1"  &shift     & :: Baudrate COM
set "IP=%~1"       &shift     & :: IP
set "Polling=%~1"  &shift     & :: Polling connection
set "Priority=%~1" &shift     & :: Priority connection
set "DevLabel=%~1" &shift     & :: Name device in label
set "FCP=%FN:.=/%"            & :: Facility DIM  path, i.e. FACN name with . to / replacement
set "FCF=%FN:.=_%"            & :: Facility file name, i.e. FACN name with . to _ replacement
goto :EOF

:DG645_HDW
echo ;***************************
echo ;***Driver for %FN%.%DEV%***
echo ;***************************
echo [SerialPort-COM%ComPort%]
echo PipeLine = Tcp Port %TcpPort% Client %IP% Polling %Polling% Priority %Priority%
echo []
echo [DeviceList]
echo ^&%FN%.%DEV%.%IDEN%.CTRL = device software Program
echo [^&%FN%.%DEV%.%IDEN%.CTRL]
echo Comment           = Hardware driver for DG645 sensor
echo InquiryPeriod     = 0
echo DevicePolling     = 10, tpHigher
echo ProgramSource     = ..\DaqPas\DG645_drv.pas
echo DigitalFifo       = 1024
echo AnalogFifo        = 1024
echo DebugFlags        = 3
echo OpenConsole       = 2
echo Simulator         = 0
echo ComPort           = %ComPort%
echo ComTimeOut        = 250
echo ComTimeGap        = 0
echo PollPeriod        = 10
echo DrvName           = undefined
echo tagPrefix         = %FN%.%DEV%.%IDEN%
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%IDEN%.CustomParameters.TagList]
echo CustomIniFileRef  = ..\Data\%FN%_DATA\%DEV%\%IDEN%_custom.ini
echo CustomIniSection  = [%IDEN%.CustomParameters]
echo CustomIniBackups  = ..\Data\%FN%_DATA\%DEV%\Custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 1
echo EncryptMethod     = RC6
echo TrustedUsers      = [TrustedUsers]
echo AnalogOutputs     = 30
echo Link AnalogOutput 0  with curve %FN%.%DEV%.%IDEN%.POLL_RATE     history 1000
echo Link AnalogOutput 1  with curve %FN%.%DEV%.%IDEN%.ERROR_CNT     history 1000
echo Link AnalogOutput 2  with curve %FN%.%DEV%.%IDEN%.ESR           history 1000
echo Link AnalogOutput 3  with curve %FN%.%DEV%.%IDEN%.INSR          history 1000
echo Link AnalogOutput 4  with curve %FN%.%DEV%.%IDEN%.DELAY_AB      history 1000
echo Link AnalogOutput 5  with curve %FN%.%DEV%.%IDEN%.DELAYCH3      history 1000
echo Link AnalogOutput 6  with curve %FN%.%DEV%.%IDEN%.DELAYCH4      history 1000
echo Link AnalogOutput 7  with curve %FN%.%DEV%.%IDEN%.DELAYCH5      history 1000
echo Link AnalogOutput 8  with curve %FN%.%DEV%.%IDEN%.DELAYCH6      history 1000
echo Link AnalogOutput 9  with curve %FN%.%DEV%.%IDEN%.DELAYCH7      history 1000
echo Link AnalogOutput 10  with curve %FN%.%DEV%.%IDEN%.DELAYCH8     history 1000
echo Link AnalogOutput 11  with curve %FN%.%DEV%.%IDEN%.DELAYCH9     history 1000
echo Link AnalogOutput 12  with curve %FN%.%DEV%.%IDEN%.LVLAMPOUT0   history 1000
echo Link AnalogOutput 13  with curve %FN%.%DEV%.%IDEN%.LVLAMPOUT1   history 1000
echo Link AnalogOutput 14  with curve %FN%.%DEV%.%IDEN%.LVLAMPOUT2   history 1000
echo Link AnalogOutput 15  with curve %FN%.%DEV%.%IDEN%.LVLAMPOUT3   history 1000
echo Link AnalogOutput 16  with curve %FN%.%DEV%.%IDEN%.LVLAMPOUT4   history 1000
echo Link AnalogOutput 17  with curve %FN%.%DEV%.%IDEN%.LVLOFFOUT0   history 1000
echo Link AnalogOutput 18  with curve %FN%.%DEV%.%IDEN%.LVLOFFOUT1   history 1000
echo Link AnalogOutput 19  with curve %FN%.%DEV%.%IDEN%.LVLOFFOUT2   history 1000
echo Link AnalogOutput 20  with curve %FN%.%DEV%.%IDEN%.LVLOFFOUT3   history 1000
echo Link AnalogOutput 21  with curve %FN%.%DEV%.%IDEN%.LVLOFFOUT4   history 1000
echo Link AnalogOutput 22  with curve %FN%.%DEV%.%IDEN%.LVLPOLOUT0   history 1000
echo Link AnalogOutput 23  with curve %FN%.%DEV%.%IDEN%.LVLPOLOUT1   history 1000
echo Link AnalogOutput 24  with curve %FN%.%DEV%.%IDEN%.LVLPOLOUT2   history 1000
echo Link AnalogOutput 25  with curve %FN%.%DEV%.%IDEN%.LVLPOLOUT3   history 1000
echo Link AnalogOutput 26  with curve %FN%.%DEV%.%IDEN%.LVLPOLOUT4   history 1000
echo Link AnalogOutput 27  with curve %FN%.%DEV%.%IDEN%.TRIGGERMODE  history 1000
echo Link AnalogOutput 28  with curve %FN%.%DEV%.%IDEN%.TRIGGERLEVEL history 1000
echo Link AnalogOutput 29  with curve %FN%.%DEV%.%IDEN%.INTERFACE    history 1000
echo []
echo [ConfigFileList]
echo ConfigFile = ..\Data\%FN%_DATA\%DEV%\%IDEN%_custom.ini
echo []
echo [%IDEN%.CustomParameters.TagList]
echo TagList = %FN%.%DEV%.%IDEN%.POLL_ENABLE
echo TagList = %FN%.%DEV%.%IDEN%.TRIGGERMODE
echo TagList = %FN%.%DEV%.%IDEN%.TRIGGERLEVEL
echo TagList = %FN%.%DEV%.%IDEN%.AB.DELAY
echo TagList = %FN%.%DEV%.%IDEN%.AB.WIDTH
echo TagList = %FN%.%DEV%.%IDEN%.AB.LVLAMP
echo TagList = %FN%.%DEV%.%IDEN%.AB.LVLOFF
echo TagList = %FN%.%DEV%.%IDEN%.AB.LVLPOL
echo TagList = %FN%.%DEV%.%IDEN%.CD.DELAY
echo TagList = %FN%.%DEV%.%IDEN%.CD.WIDTH
echo TagList = %FN%.%DEV%.%IDEN%.CD.LVLAMP
echo TagList = %FN%.%DEV%.%IDEN%.CD.LVLOFF
echo TagList = %FN%.%DEV%.%IDEN%.CD.LVLPOL
echo TagList = %FN%.%DEV%.%IDEN%.EF.DELAY
echo TagList = %FN%.%DEV%.%IDEN%.EF.WIDTH
echo TagList = %FN%.%DEV%.%IDEN%.EF.LVLAMP
echo TagList = %FN%.%DEV%.%IDEN%.EF.LVLOFF
echo TagList = %FN%.%DEV%.%IDEN%.EF.LVLPOL
echo TagList = %FN%.%DEV%.%IDEN%.GH.DELAY
echo TagList = %FN%.%DEV%.%IDEN%.GH.WIDTH
echo TagList = %FN%.%DEV%.%IDEN%.GH.LVLAMP
echo TagList = %FN%.%DEV%.%IDEN%.GH.LVLOFF
echo TagList = %FN%.%DEV%.%IDEN%.GH.LVLPOL
echo []
echo [DataStorage]
echo %FN%.%DEV%.%IDEN%.POLL_RATE                      = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.ERROR_CNT                      = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.ESR                            = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.INSR                           = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.DELAY_AB                       = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.DELAYCH3                       = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.DELAYCH4                       = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.DELAYCH5                       = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.DELAYCH6                       = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.DELAYCH7                       = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.DELAYCH8                       = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.DELAYCH9                       = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLAMPOUT0                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLAMPOUT1                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLAMPOUT2                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLAMPOUT3                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLAMPOUT4                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLOFFOUT0                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLOFFOUT1                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLOFFOUT2                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLOFFOUT3                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLOFFOUT4                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLPOLOUT0                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLPOLOUT1                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLPOLOUT2                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLPOLOUT3                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.LVLPOLOUT4                     = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.TRIGGERMODE                    = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.TRIGGERLEVEL                   = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.INTERFACE                      = Curve 0 10 Black 15 1
echo %FN%.%DEV%.%IDEN%.STATE                          = Curve 0 10 Black 15 1
echo []
echo [TagList]
echo %FN%.%DEV%.%IDEN%.DIMCMDMY                       = string  ? ; The DIM command data
echo %FN%.%DEV%.%IDEN%.DIMGUICLICK                    = string  ? ; The DIM click sensor data
echo %FN%.%DEV%.%IDEN%.POLL_ENABLE                    = integer 1 ; Enable polling flag
echo %FN%.%DEV%.%IDEN%.POLL_RATE                      = real    0 ; Polling rate, poll/sec
echo %FN%.%DEV%.%IDEN%.ERROR_CNT                      = real    0 ; Device error counter
echo %FN%.%DEV%.%IDEN%.IDN_MODEL                      = string ?  ; Device Identificator
echo %FN%.%DEV%.%IDEN%.IDN_SERIAL                     = string ?  ; Device serial number
echo %FN%.%DEV%.%IDEN%.IDN_VERSION                    = string ?  ; Device software version
echo %FN%.%DEV%.%IDEN%.TRIGGERMODE                    = integer 0 ; Device Trigger mode
echo %FN%.%DEV%.%IDEN%.TRIGGERLEVEL                   = real 0    ; Device Trigger mode
echo %FN%.%DEV%.%IDEN%.ESR                            = integer 0 ; Device Event Status Register
echo %FN%.%DEV%.%IDEN%.INSR                           = integer 0 ; Instrument Status Register
echo %FN%.%DEV%.%IDEN%.AB.DELAY                       = real 0    ; Device channel A delay
echo %FN%.%DEV%.%IDEN%.AB.WIDTH                       = real 0    ; Device channel B delay
echo %FN%.%DEV%.%IDEN%.AB.LVLAMP                      = real 0    ; Level Amplitude AB
echo %FN%.%DEV%.%IDEN%.AB.LVLOFF                      = real 0    ; Level Offset AB
echo %FN%.%DEV%.%IDEN%.AB.LVLPOL                      = integer 0 ; Level Polarit AB
echo %FN%.%DEV%.%IDEN%.CD.DELAY                       = real 0    ; Device channel C delay
echo %FN%.%DEV%.%IDEN%.CD.WIDTH                       = real 0    ; Device channel D delay
echo %FN%.%DEV%.%IDEN%.CD.LVLAMP                      = real 0    ; Level Amplitude CD
echo %FN%.%DEV%.%IDEN%.CD.LVLOFF                      = real 0    ; Level Offset CD
echo %FN%.%DEV%.%IDEN%.CD.LVLPOL                      = integer 0 ; Level Polarit CD
echo %FN%.%DEV%.%IDEN%.EF.DELAY                       = real 0    ; Device channel E delay
echo %FN%.%DEV%.%IDEN%.EF.WIDTH                       = real 0    ; Device channel F delay
echo %FN%.%DEV%.%IDEN%.EF.LVLAMP                      = real 0    ; Level Amplitude EF
echo %FN%.%DEV%.%IDEN%.EF.LVLOFF                      = real 0    ; Level Offset EF
echo %FN%.%DEV%.%IDEN%.EF.LVLPOL                      = integer 0 ; Level Polarit EF
echo %FN%.%DEV%.%IDEN%.GH.DELAY                       = real 0    ; Device channel G delay
echo %FN%.%DEV%.%IDEN%.GH.WIDTH                       = real 0    ; Device channel H delay
echo %FN%.%DEV%.%IDEN%.GH.LVLAMP                      = real 0    ; Level Amplitude GH
echo %FN%.%DEV%.%IDEN%.GH.LVLOFF                      = real 0    ; Level Offset GH
echo %FN%.%DEV%.%IDEN%.GH.LVLPOL                      = integer 0 ; Level Polarit GH
echo %FN%.%DEV%.%IDEN%.CLOCK                          = string  ? ; Host clock Date-Time
echo %FN%.%DEV%.%IDEN%.SERVID                         = string  ? ; ServerId: pid@hostname
echo %FN%.%DEV%.%IDEN%.STATE                          = integer 0 ; State device tag
echo %FN%.%DEV%.%IDEN%.SYSTEMMODE                     = integer 0 ; System Mode tag
echo []
echo [Windows]
echo %FN%.%DEV%.%IDEN%.CTRL = Circuit_Window
echo [%FN%.%DEV%.%IDEN%.CTRL]
echo Circuit = ..\Circuits\dg645_ctrl.crc
echo Link sensor @CRON+@BROWSE+WWW.THINKSRS.COM with device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor POLL_ENABLE        with tag %FN%.%DEV%.%IDEN%.POLL_ENABLE  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor ERROR_CNT          with tag %FN%.%DEV%.%IDEN%.ERROR_CNT    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor POLL_RATE          with tag %FN%.%DEV%.%IDEN%.POLL_RATE    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor POLL_MEMO          with tag %FN%.%DEV%.%IDEN%.POLL_ENABLE  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor IDN_MODEL          with tag %FN%.%DEV%.%IDEN%.IDN_MODEL    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor IDN_SERIAL         with tag %FN%.%DEV%.%IDEN%.IDN_SERIAL   device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor IDN_VERSION        with tag %FN%.%DEV%.%IDEN%.IDN_VERSION  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor SERVID             with tag %FN%.%DEV%.%IDEN%.SERVID       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor CLOCK              with tag %FN%.%DEV%.%IDEN%.CLOCK        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor HELP               with                                    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor TOOLS              with                                    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor @OpenConsole       with                                    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor LABEL_DEVICESTATUS with                                    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.TRIGGER      with                                    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.TRIGGERMODE  with tag %FN%.%DEV%.%IDEN%.TRIGGERMODE  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.TRIGGERLEVEL with tag %FN%.%DEV%.%IDEN%.TRIGGERLEVEL device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.ESR.OPC      with tag %FN%.%DEV%.%IDEN%.ESR          device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.ESR.QYE      with tag %FN%.%DEV%.%IDEN%.ESR          device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.ESR.DDE      with tag %FN%.%DEV%.%IDEN%.ESR          device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.ESR.EXE      with tag %FN%.%DEV%.%IDEN%.ESR          device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.ESR.CME      with tag %FN%.%DEV%.%IDEN%.ESR          device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.ESR.PON      with tag %FN%.%DEV%.%IDEN%.ESR          device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.INSR         with tag %FN%.%DEV%.%IDEN%.INSR         device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.AB.DELAY     with tag %FN%.%DEV%.%IDEN%.AB.DELAY     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.AB.WIDTH     with tag %FN%.%DEV%.%IDEN%.AB.WIDTH     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.AB.LVLAMP    with tag %FN%.%DEV%.%IDEN%.AB.LVLAMP    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.AB.LVLOFF    with tag %FN%.%DEV%.%IDEN%.AB.LVLOFF    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.AB.LVLPOL    with tag %FN%.%DEV%.%IDEN%.AB.LVLPOL    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.CD.DELAY     with tag %FN%.%DEV%.%IDEN%.CD.DELAY     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.CD.WIDTH     with tag %FN%.%DEV%.%IDEN%.CD.WIDTH     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.CD.LVLAMP    with tag %FN%.%DEV%.%IDEN%.CD.LVLAMP    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.CD.LVLOFF    with tag %FN%.%DEV%.%IDEN%.CD.LVLOFF    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.CD.LVLPOL    with tag %FN%.%DEV%.%IDEN%.CD.LVLPOL    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.EF.DELAY     with tag %FN%.%DEV%.%IDEN%.EF.DELAY     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.EF.WIDTH     with tag %FN%.%DEV%.%IDEN%.EF.WIDTH     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.EF.LVLAMP    with tag %FN%.%DEV%.%IDEN%.EF.LVLAMP    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.EF.LVLOFF    with tag %FN%.%DEV%.%IDEN%.EF.LVLOFF    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.EF.LVLPOL    with tag %FN%.%DEV%.%IDEN%.EF.LVLPOL    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.GH.DELAY     with tag %FN%.%DEV%.%IDEN%.GH.DELAY     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.GH.WIDTH     with tag %FN%.%DEV%.%IDEN%.GH.WIDTH     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.GH.LVLAMP    with tag %FN%.%DEV%.%IDEN%.GH.LVLAMP    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.GH.LVLOFF    with tag %FN%.%DEV%.%IDEN%.GH.LVLOFF    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor DG645.GH.LVLPOL    with tag %FN%.%DEV%.%IDEN%.GH.LVLPOL    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo []
echo [%FN%.MAIN.CTRL]
echo Link sensor @CRON+@CRON.RUN+%FN%.%DEV%.%IDEN%.CTRL.SELECT         with device ^&%FN%.MAIN.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.TRIGGERMODE   with tag %FN%.%DEV%.%IDEN%.TRIGGERMODE  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.CH1.DELAY     with tag %FN%.%DEV%.%IDEN%.AB.DELAY     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.CH1.WIDTH     with tag %FN%.%DEV%.%IDEN%.AB.WIDTH     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.CH2.DELAY     with tag %FN%.%DEV%.%IDEN%.CD.DELAY     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.CH2.WIDTH     with tag %FN%.%DEV%.%IDEN%.CD.WIDTH     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.CH3.DELAY     with tag %FN%.%DEV%.%IDEN%.EF.DELAY     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.CH3.WIDTH     with tag %FN%.%DEV%.%IDEN%.EF.WIDTH     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.CH4.DELAY     with tag %FN%.%DEV%.%IDEN%.GH.DELAY     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.CH4.WIDTH     with tag %FN%.%DEV%.%IDEN%.GH.WIDTH     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.STATE         with tag %FN%.%DEV%.%IDEN%.STATE        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor SYSTEMMODE                      with tag %FN%.%DEV%.%IDEN%.SYSTEMMODE   device ^&%FN%.%DEV%.%IDEN%.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.HOME 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinShow %FN%.%DEV%.%IDEN%.CTRL
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=820^|Height=390
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.SHOW 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.SHOW @WinShow %FN%.%DEV%.%IDEN%.CTRL
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.HIDE 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HIDE @WinHide %FN%.%DEV%.%IDEN%.CTRL
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.SELECT 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.SELECT @WinSelect %FN%.%DEV%.%IDEN%.CTRL
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.CTRL.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.CTRL.HIDE
echo []
echo [Windows]
echo %FN%.%DEV%.%IDEN%.PARAM.PLOT = Curve_Window
echo [%FN%.%DEV%.%IDEN%.PARAM.PLOT]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.25
echo AxisY = ^^CState channel^^N^^L___{Status}, 0, 1000
echo CurveList = %FN%.%DEV%.%IDEN%.POLL_RATE
echo CurveList = %FN%.%DEV%.%IDEN%.ERROR_CNT
echo CurveList = %FN%.%DEV%.%IDEN%.ESR
echo CurveList = %FN%.%DEV%.%IDEN%.INSR
echo CurveList = %FN%.%DEV%.%IDEN%.TRIGGERMODE
echo CurveList = %FN%.%DEV%.%IDEN%.TRIGGERLEVEL
echo CurveList = %FN%.%DEV%.%IDEN%.STATE
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinShow %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Left=167^|Top=120^|Height=600^|Width=1000
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Options=-Min,-Max,+Close,+VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.SHOW 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.SHOW @WinShow %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE @WinHide %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.SELECT 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.SELECT @WinSelect %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE
echo []
echo [^&DATSRV]
echo IntegrityMode = 1
echo OpenConsole   = 2
echo SavePeriod    = 300
echo FilePrefix    = %IDEN%_
echo DataPath      = ..\Data\%FN%_DATA\%DEV%_DATA
echo CurveList = %FN%.%DEV%.%IDEN%.POLL_RATE
echo CurveList = %FN%.%DEV%.%IDEN%.ERROR_CNT
echo CurveList = %FN%.%DEV%.%IDEN%.ESR
echo CurveList = %FN%.%DEV%.%IDEN%.INSR
echo CurveList = %FN%.%DEV%.%IDEN%.TRIGGERMODE
echo CurveList = %FN%.%DEV%.%IDEN%.TRIGGERLEVEL
echo CurveList = %FN%.%DEV%.%IDEN%.STATE
echo []
goto :EOF

:DG645_SIM
echo [SerialPort-COM%ComPort%]
echo PipeLine    =
echo PipeName    = %FN%.%DEV%.%IDEN%.com1.sim
echo PipePolling = 10, tpNormal
echo TimeOut     = 1000
echo FifoSize    = 16
echo []
echo [SerialPort-COM1%ComPort%]
echo PipeName    = .\%FN%.%DEV%.%IDEN%.com1.sim
echo PipePolling = 10, tpNormal
echo TimeOut     = 1000
echo FifoSize    = 16
echo []
echo [DeviceList]
echo ^&%FN%.%DEV%.%IDEN%.SIM = device software program
echo [^&%FN%.%DEV%.%IDEN%.SIM]
echo Comment        = Simulation for DG645 sensor LS.
echo InquiryPeriod  = 0
echo DevicePolling  = 10, tpNormal
echo ProgramSource  = ..\DaqPas\DG645_drv.pas
echo DebugFlags     = 15
echo OpenConsole    = 1
echo Simulator      = 1
echo ComPort        = 1%ComPort%
echo ComTimeOut     = 250
echo ComTimeGap     = 0
echo PollPeriod     = 50
echo ModelName      = Digital Delay Generator DG645
echo tagPrefix      = %FN%.%DEV%.%IDEN%
echo []
rem Include hardware config if one not done yet
if "%numhdwcfg%" == "0" ( set /a numhdwcfg=numhdwcfg+1 ) else ( goto :EOF )
echo [ConfigFileList]
echo ConfigFile = %hdwcfg%
echo []
goto :EOF

:DG645_DIS
unix dimcfg ^
  -n section "[&%FN%.%DEV%.%IDEN%.CTRL]" ^
  -n print    DimServerMode = 1 ^
  -n end ^
  -n dis_cmnd   %FCP%/%DEV%/%IDEN%/DIMCMDMY ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMCMDMY ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DIMCMDMY=%%**" ^
  -n end ^
  -n dis_cmnd   %FCP%/%DEV%/%IDEN%/DIMGUICLICK ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMGUICLICK ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DIMGUICLICK=%%**" ^
  -n end ^
  -n dic_cmnd   %FCP%/%DEV%/%IDEN%/DIMGUICLICK ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/IDN_MODEL+IDN_SERIAL+IDN_VERSION ^
  -n tag        %FN%.%DEV%.%IDEN%.IDN_MODEL ^
  -n tag        %FN%.%DEV%.%IDEN%.IDN_SERIAL ^
  -n tag        %FN%.%DEV%.%IDEN%.IDN_VERSION ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/TRIGGERMODE ^
  -n tag        %FN%.%DEV%.%IDEN%.TRIGGERMODE ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/TRIGGERLEVEL ^
  -n tag        %FN%.%DEV%.%IDEN%.TRIGGERLEVEL ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/ESR ^
  -n tag        %FN%.%DEV%.%IDEN%.ESR ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/INSR ^
  -n tag        %FN%.%DEV%.%IDEN%.INSR ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/AB_DELAY+^CD_DELAY+EF_DELAY+GH_DELAY ^
  -n tag        %FN%.%DEV%.%IDEN%.AB.DELAY ^
  -n tag        %FN%.%DEV%.%IDEN%.^CD.DELAY ^
  -n tag        %FN%.%DEV%.%IDEN%.EF.DELAY ^
  -n tag        %FN%.%DEV%.%IDEN%.GH.DELAY ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/AB_WIDTH+^CD_WIDTH+EF_WIDTH+GH_WIDTH ^
  -n tag        %FN%.%DEV%.%IDEN%.AB.WIDTH ^
  -n tag        %FN%.%DEV%.%IDEN%.^CD.WIDTH ^
  -n tag        %FN%.%DEV%.%IDEN%.EF.WIDTH ^
  -n tag        %FN%.%DEV%.%IDEN%.GH.WIDTH ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/AB_LVLAMP+^CD_LVLAMP+EF_LVLAMP+GH_LVLAMP ^
  -n tag        %FN%.%DEV%.%IDEN%.AB.LVLAMP ^
  -n tag        %FN%.%DEV%.%IDEN%.^CD.LVLAMP ^
  -n tag        %FN%.%DEV%.%IDEN%.EF.LVLAMP ^
  -n tag        %FN%.%DEV%.%IDEN%.GH.LVLAMP ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/AB_LVLOFF+^CD_LVLOFF+EF_LVLOFF+GH_LVLOFF ^
  -n tag        %FN%.%DEV%.%IDEN%.AB.LVLOFF ^
  -n tag        %FN%.%DEV%.%IDEN%.^CD.LVLOFF ^
  -n tag        %FN%.%DEV%.%IDEN%.EF.LVLOFF ^
  -n tag        %FN%.%DEV%.%IDEN%.GH.LVLOFF ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/AB_LVLPOL+^CD_LVLPOL+EF_LVLPOL+GH_LVLPOL ^
  -n tag        %FN%.%DEV%.%IDEN%.AB.LVLPOL ^
  -n tag        %FN%.%DEV%.%IDEN%.^CD.LVLPOL ^
  -n tag        %FN%.%DEV%.%IDEN%.EF.LVLPOL ^
  -n tag        %FN%.%DEV%.%IDEN%.GH.LVLPOL ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/POLL_RATE ^
  -n tag        %FN%.%DEV%.%IDEN%.POLL_RATE ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/POLL_ENABLE ^
  -n tag        %FN%.%DEV%.%IDEN%.POLL_ENABLE ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/CLOCK ^
  -n tag        %FN%.%DEV%.%IDEN%.CLOCK ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/SERVID ^
  -n tag        %FN%.%DEV%.%IDEN%.SERVID ^
  -n end ^
echo.
goto :EOF

:DG645_DIC
unix dimcfg ^
  -n section "[&%FN%.%DEV%.%IDEN%.CTRL]" ^
  -n print    DimClientMode = 1 ^
  -n end ^
  -n dic_cmnd   %FCP%/%DEV%/%IDEN%/DIMGUICLICK ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/IDN_MODEL+IDN_SERIAL+IDN_VERSION ^
  -n tag        %FN%.%DEV%.%IDEN%.IDN_MODEL ^
  -n tag        %FN%.%DEV%.%IDEN%.IDN_SERIAL ^
  -n tag        %FN%.%DEV%.%IDEN%.IDN_VERSION ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/TRIGGERMODE ^
  -n tag        %FN%.%DEV%.%IDEN%.TRIGGERMODE ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/TRIGGERLEVEL ^
  -n tag        %FN%.%DEV%.%IDEN%.TRIGGERLEVEL ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/ESR ^
  -n tag        %FN%.%DEV%.%IDEN%.ESR ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/INSR ^
  -n tag        %FN%.%DEV%.%IDEN%.INSR ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/AB_DELAY+^CD_DELAY+EF_DELAY+GH_DELAY ^
  -n tag        %FN%.%DEV%.%IDEN%.AB.DELAY ^
  -n tag        %FN%.%DEV%.%IDEN%.^CD.DELAY ^
  -n tag        %FN%.%DEV%.%IDEN%.EF.DELAY ^
  -n tag        %FN%.%DEV%.%IDEN%.GH.DELAY ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/AB_WIDTH+^CD_WIDTH+EF_WIDTH+GH_WIDTH ^
  -n tag        %FN%.%DEV%.%IDEN%.AB.WIDTH ^
  -n tag        %FN%.%DEV%.%IDEN%.^CD.WIDTH ^
  -n tag        %FN%.%DEV%.%IDEN%.EF.WIDTH ^
  -n tag        %FN%.%DEV%.%IDEN%.GH.WIDTH ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/AB_LVLAMP+^CD_LVLAMP+EF_LVLAMP+GH_LVLAMP ^
  -n tag        %FN%.%DEV%.%IDEN%.AB.LVLAMP ^
  -n tag        %FN%.%DEV%.%IDEN%.^CD.LVLAMP ^
  -n tag        %FN%.%DEV%.%IDEN%.EF.LVLAMP ^
  -n tag        %FN%.%DEV%.%IDEN%.GH.LVLAMP ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/AB_LVLOFF+^CD_LVLOFF+EF_LVLOFF+GH_LVLOFF ^
  -n tag        %FN%.%DEV%.%IDEN%.AB.LVLOFF ^
  -n tag        %FN%.%DEV%.%IDEN%.^CD.LVLOFF ^
  -n tag        %FN%.%DEV%.%IDEN%.EF.LVLOFF ^
  -n tag        %FN%.%DEV%.%IDEN%.GH.LVLOFF ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/AB_LVLPOL+^CD_LVLPOL+EF_LVLPOL+GH_LVLPOL ^
  -n tag        %FN%.%DEV%.%IDEN%.AB.LVLPOL ^
  -n tag        %FN%.%DEV%.%IDEN%.^CD.LVLPOL ^
  -n tag        %FN%.%DEV%.%IDEN%.EF.LVLPOL ^
  -n tag        %FN%.%DEV%.%IDEN%.GH.LVLPOL ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/POLL_RATE ^
  -n tag        %FN%.%DEV%.%IDEN%.POLL_RATE ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/POLL_ENABLE ^
  -n tag        %FN%.%DEV%.%IDEN%.POLL_ENABLE ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/CLOCK ^
  -n tag        %FN%.%DEV%.%IDEN%.CLOCK ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.CLOCK" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/SERVID ^
  -n tag        %FN%.%DEV%.%IDEN%.SERVID ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.SERVID" ^
  -n end ^
echo.
goto :EOF

:DG645_TABCRC
set /a YPOS=TABCRC_TOP+80
set /a YPOSCH2=YPOS+20
set /a YPOSCH3=YPOS+40
set /a YPOSCH4=YPOS+60
echo [SensorList]
echo Sensor = @cron+@cron.run+%FN%.%DEV%.%IDEN%.CTRL.SELECT
echo [@cron+@cron.run+%FN%.%DEV%.%IDEN%.CTRL.SELECT]
echo Pos = 10, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:14\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_120_30_24_silver.bmp %DevLabel%
echo Hint = Открыть панель настройки генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.STATE
echo [%FN%.%DEV%.%IDEN%.STATE]
echo Pos = 140, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:14\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_120_30_24_gray.bmp Выключен
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_120_30_24_lime.bmp Работает
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_120_30_24_yellow.bmp Timeout
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_120_30_24_red.bmp Warning
echo Tag#5 = 4, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_120_30_24_yellow.bmp Симулятор
echo Hint = Состояние генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.TRIGGERMODE
echo [%FN%.%DEV%.%IDEN%.TRIGGERMODE]
echo Pos = 270, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:8\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_170_30_24_white.bmp Внутренний
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_170_30_24_white.bmp "Вн. по переднему фронту"
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_170_30_24_white.bmp "Вн. по заднему фронту"
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_170_30_24_white.bmp "Один. вн. по пер. фронту"
echo Tag#5 = 4, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_170_30_24_white.bmp "Один. вн. по зад. фронту"
echo Tag#6 = 5, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_170_30_24_white.bmp Одиночный
echo Tag#7 = 6, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_170_30_24_white.bmp Линейный
echo Hint = Режим триггера генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.CH1.LABEL
echo [%FN%.%DEV%.%IDEN%.CH1.LABEL]
echo Pos = 450, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clDkGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_50_20_24_silver.bmp AB
echo Hint = Параметры канала AB генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.CH1.DELAY
echo [%FN%.%DEV%.%IDEN%.CH1.DELAY]
echo Pos = 500, %YPOS%
echo LED = 7, 0, 0, %%7.0F·нс, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_20_24_white.bmp
echo Hint = Задержка канала AB генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.CH1.WIDTH
echo [%FN%.%DEV%.%IDEN%.CH1.WIDTH]
echo Pos = 590, %YPOS%
echo LED = 7, 0, 0, %%7.0F·нс, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_20_24_white.bmp
echo Hint = Ширина канала AB генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.CH2.LABEL
echo [%FN%.%DEV%.%IDEN%.CH2.LABEL]
echo Pos = 450, %YPOSCH2%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clDkGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_50_20_24_silver.bmp CD
echo Hint = Параметры канала CD генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.CH2.DELAY
echo [%FN%.%DEV%.%IDEN%.CH2.DELAY]
echo Pos = 500, %YPOSCH2%
echo LED = 7, 0, 0, %%7.0F·нс, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_20_24_white.bmp
echo Hint = Задержка канала CD генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.CH2.WIDTH
echo [%FN%.%DEV%.%IDEN%.CH2.WIDTH]
echo Pos = 590, %YPOSCH2%
echo LED = 7, 0, 0, %%7.0F·нс, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_20_24_white.bmp
echo Hint = Ширина канала CD генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.CH3.LABEL
echo [%FN%.%DEV%.%IDEN%.CH3.LABEL]
echo Pos = 450, %YPOSCH3%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clDkGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_50_20_24_silver.bmp EF
echo Hint = Параметры канала EF генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.CH3.DELAY
echo [%FN%.%DEV%.%IDEN%.CH3.DELAY]
echo Pos = 500, %YPOSCH3%
echo LED = 7, 0, 0, %%7.0F·нс, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_20_24_white.bmp
echo Hint = Задержка канала EF генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.CH3.WIDTH
echo [%FN%.%DEV%.%IDEN%.CH3.WIDTH]
echo Pos = 590, %YPOSCH3%
echo LED = 7, 0, 0, %%7.0F·нс, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_20_24_white.bmp
echo Hint = Ширина канала EF генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.CH4.LABEL
echo [%FN%.%DEV%.%IDEN%.CH4.LABEL]
echo Pos = 450, %YPOSCH4%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clDkGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_50_20_24_silver.bmp GH
echo Hint = Параметры канала GH генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.CH4.DELAY
echo [%FN%.%DEV%.%IDEN%.CH4.DELAY]
echo Pos = 500, %YPOSCH4%
echo LED = 7, 0, 0, %%7.0F·нс, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_20_24_white.bmp
echo Hint = Задержка канала GH генератора %IDEN% (%DevLabel%)
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.CH4.WIDTH
echo [%FN%.%DEV%.%IDEN%.CH4.WIDTH]
echo Pos = 590, %YPOSCH4%
echo LED = 7, 0, 0, %%7.0F·нс, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_20_24_white.bmp
echo Hint = Ширина канала GH генератора %IDEN% (%DevLabel%)
echo []
set /a TABCRC_TOP+=TABCRC_STEP
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
