 {
 ***********************************************************************
 Daq Pascal application program DbQuery.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Demo ex1 ex2  - Evaluate 2 expressions, just for demo.
|********************************************************
[]
 }
program DbQuery;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_DbLibrary}             { DbLibrary constants              }
 EmptyFiller        = '??';      { String filler for empty data     }
 PageRows           = 10;        { Number of rows per result page   }
 con_OK             = 1;         {                                  }
 con_ERROR          = 0;         {                                  }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_DbLibrary}             { DbLibrary variables              }
 DbQuery           : record      { DB related data:                 }
  dbc              : Integer;    { DB Connection handle             }
  tblist           : Integer;    { Text list of tables              }
  fvlist           : Integer;    { Text list of field values        }
  ConnectionLink   : TTagRef;    { Connection string input          }
  Records          : record      { Data records per Row             }
   Data            : array [1..PageRows] of TTagRef; { Row data     }
   Selected        : array [1..PageRows] of TTagRef; { Row checkbox }
  end;                           {                                  }
  SQLQuery         : TTagRef;    { SQL query input                  }
  PageNum          : TTagRef;    { Page number to view              }
  Table            : TTagRef;    { Current Table name               }
  ConStatus        : TTagRef;    { Status of connection             }
 end;                            {                                  }
 fieldlist         : String;     { Current Table Field List         }
 cmd_Edit          : Integer;    { Command @Edit                    }
 cmd_View          : Integer;    { Command @View                    }
 cmd_Set           : Integer;    { Command @Set                     }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_DbLibrary}             { DbLibrary functions              }

 //
 // Xor bit on click (local version)
 //
 procedure ClickTagXorLocal(tag,XorMask:Integer);
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 //
 // Nice tooltip notifier.
 //
 procedure NiceAlert(aText:String; aDelay:Integer);
 begin
  if Length(aText)>0 then begin
   ShowTooltip('text "'+aText+'" preset stdAlert delay '+Str(aDelay));
  end;
 end;
 //
 // Send command (cmd) with argument (arg) to console on tag click.
 //
 procedure SendClickTagCmd(tag:Integer; cmd,arg:String);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then
  if LooksLikeCommand(cmd) then begin
   DevPostCmdLocal(Trim(cmd+' '+arg));
   bNul(Voice(snd_Click));
  end;
 end;
 //
 // Return DbQuery.SQLRESULT#i tag.
 //
 function SqlResultTag(i:Integer):Integer;
 begin
  if (i>=1) and (i<=PageRows)
  then SqlResultTag:=DbQuery.Records.Data[i].tag
  else SqlResultTag:=0;
 end;
 //
 // Set DbQuery.SQLRESULT#i tag value (sv).
 // Get DbQuery.SQLRESULT#i tag value with default (def).
 //
 procedure SetSqlResultStr(i:Integer; sv:String);
 begin
  if (i>=1) and (i<=PageRows) then bNul(sSetTag(SqlResultTag(i),sv));
 end;
 function  GetSqlResultStr(i:Integer; def:String):String;
 begin
  if (i>=1) and (i<=PageRows) then def:=sGetTag(SqlResultTag(i));
  GetSqlResultStr:=def;
 end;
 //
 // Clear table of results, use filler.
 //
 procedure ClearResultTable(filler:String);
 var i:Integer;
 begin
  for i:=1 to PageRows do bNul(sSetTag(SqlResultTag(i),filler));
 end;
 //
 // DbQuery Close connection, free and clear DB handle.
 //
 procedure DbQuery_CloseConnection;
 var tr:Integer;
 begin
  if (DbQuery.dbc<>0) then begin
   if db_active(DbQuery.dbc) then begin
    tr:=Ord(db_committrans(DbQuery.dbc));
    Success('Commit Transaction '+Str(tr));
   end;
   bNul(db_close(DbQuery.dbc));
   Success('Closed.');
  end;
  FreeAndZero(DbQuery.dbc);
 end;
 //
 // Open DB connection by Link (if empty, take from CONNECTIONLINK tag).
 // Assign connection handle to DbQuery.dbc for future use.
 //
 procedure DbQuery_OpenConnection(Link:String);
 begin
  DbQuery_CloseConnection; // Close connection if one was opened!
  if IsEmptyStr(Link) then Link:=sGetTag(DbQuery.CONNECTIONLINK.tag);
  DbQuery.dbc:=db_connection(db_engine_uses,Trim(Link));
  if (DbQuery.dbc<>0) then begin
   db_bugreport_mode(DbQuery.dbc,db_brm_uses);
   bNul(iSetTag(DbQuery.ConStatus.tag,con_OK));
   Success('Connected '+db_ctrl(DbQuery.dbc,'EngineName')+' version '+db_ctrl(DbQuery.dbc,'Version')+' with Provider '+db_ctrl(DbQuery.dbc,'Provider'));
  end else begin
   bNul(iSetTag(DbQuery.ConStatus.tag,con_ERROR));
   Problem('Could not connect!');
  end;
 end;
 //
 // Connect to DB, execute query and return recordset handle.
 //
 function DbQuery_Execute(query:String):Integer;
 var rst,tr:Integer;
 begin
  Success('QUERY => '+query);
  DbQuery_OpenConnection('');
  if db_open(DbQuery.dbc,adConnectUnspecified) then begin
   tr:=db_begintrans(DbQuery.dbc);
   Success('Begin Transaction '+Str(tr));
   rst:=db_execute(DbQuery.dbc,query,adCmdText);
  end else rst:=0;
  if (rst<>0) then begin
   Success('Query execute succeeded.');
   Success(StrFmt('%d field(s) in table.',db_fieldscount(rst)));
  end else Problem('Could not execute query.');
  DbQuery_Execute:=rst;
 end;
 //
 // Handle query like 'SELECT NAME FROM SQLITE_MASTER':
 // Read list of tables (id='NAME') from recordset (rst)
 // write result to text list (txt)
 //
 procedure ReadTableNameList(rst,txt:Integer);
 var id,sv:String;
  procedure Cleanup;
  begin
   id:=''; sv:='';
  end;
 begin
  Cleanup;
  id:='NAME';
  ClearText(txt);
  Success('ReadTableList:');
  if db_fieldscount(rst)>0 then
  while not db_eof(rst) do begin
   sv:=db_fieldsasstring(rst,id,'r','');
   bNul(text_addln(txt,sv));
   Success(' => '+sv);
   bNul(db_movenext(rst));
  end;
  DbQuery_CloseConnection;
  Cleanup;
 end;
 //
 // Menu to select a table from list of tables
 //
 procedure MenuToSelectTableFromList;
 var n,i:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Выбор таблицы:"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   for i:=0 to text_numln(DbQuery.tblist)-1 do begin
    n:=n+EditAddInputLn(text_getln(DbQuery.tblist,i));
    n:=n+EditAddCommand('@SET TABLE '+text_getln(DbQuery.tblist,i));
   end;
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TABLES'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 //
 // Format result for nice table look.
 //
 procedure NiceFormatResult;
 const MaxRowWidth=66;
 var sv,it,rs:String; ic,nc,ir,nr,cl:Integer; cw:Real;
  procedure Cleanup;
  begin
   sv:=''; it:=''; rs:='';
  end;
 begin
  nc:=WordCount(fieldlist);
  // Use Eval(colwid1,colwid2,..) to save column width
  for ic:=1 to nc do bNul(evar(StrFmt('colwid%d',ic),0));
  // Find maximal column width for all rows
  for ir:=1 to PageRows do for ic:=1 to nc do begin
   rs:=Trim(GetSqlResultStr(ir,''));
   if (rs<>'') and (rs<>EmptyFiller) then begin
    cl:=Length(Trim(ExtractWordDelims(ic,rs,Trim(';'))));
    cw:=max(eval(StrFmt('colwid%d',ic)),cl+1);
    bNul(evar(StrFmt('colwid%d',ic),cw));
   end;
  end;
  // Calculate expected summary width
  cw:=0; for ic:=1 to nc do cw:=cw+eval(StrFmt('colwid%d',ic))+1;
  if (cw<=MaxRowWidth) then // if width reasonable, format rows
  for ir:=1 to PageRows do begin
   rs:=GetSqlResultStr(ir,''); sv:='';
   if (rs<>'') and (rs<>EmptyFiller) then begin
    for ic:=1 to nc do begin
     it:=Trim(ExtractWordDelims(ic,rs,Trim(';')))+';';
     cl:=Round(eval(StrFmt('colwid%d',ic)));
     if (sv<>'') then sv:=sv+' ';
     sv:=sv+RightPad(it,cl,' ');
    end;
    SetSqlResultStr(ir,sv);
   end;
  end;
 end;
 //
 // Read all recordset (rst) rows and write result to SQLRESULT#i tags with index offset.
 //
 procedure WriteResult(rst,offset:integer);
 var id,sv:String; i,tp,index:Integer;
  procedure Cleanup;
  begin
   id:=''; sv:='';
  end;
 begin
  Cleanup;
  fieldlist:=''; index:=offset;
  ClearResultTable(EmptyFiller);
  if db_fieldscount(rst)>0 then
  while not db_eof(rst) do begin
   index:=index+1; sv:=''; id:='';
   for i:=0 to db_fieldscount(rst)-1 do begin
    id:=db_fieldsNames(rst,i); tp:=db_fieldsTypes(rst,id);
    sv:=sv+' '+id+'='+db_fieldsAsString(rst,id,'r','')+';';
    if index=1 then fieldlist:=fieldlist+id+' ';
   end;
   SetSqlResultStr(index,sv);
   bNul(db_movenext(rst));
  end;
  DbQuery_CloseConnection;
  NiceFormatResult;
  Cleanup;
 end;
 //
 // Read a single record from recordset (rst) to text buffer (txt).
 //
 procedure ReadRecordToView(rst,txt:integer);
 var id,sv:String; i:Integer;
  procedure Cleanup;
  begin
   sv:=''; id:='';
  end;
 begin
  Cleanup;
  ClearText(txt);
  for i:=0 to db_fieldscount(rst)-1 do begin
   id:=db_fieldsnames(rst,i);
   sv:=db_fieldsasstring(rst,id,'r','');
   bNul(text_addln(txt,id+'='+sv));
  end;
  Success('Read => '+StringReplace(TextToString(txt),LineEnding,';',rfReplaceAll));
  Cleanup;
 end;
 //
 // StringGridEdit to view/edit a record fields.
 //
 procedure RecordGridView;
 var n,i:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Редактировать запись:');
   for i:=0 to text_numln(DbQuery.fvlist)-1 do begin
    n:=n+EditAddInputLn(stringreplace(text_getln(DbQuery.fvlist,i),'=','|',0));
   end;
   n:=n+EditAddSetting('@set StringGrid.Font Name:PT_Mono\Size:14');
   n:=n+EditAddClosing('StringGridEdit',EditGetUID('UPDATE_TAB'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 //
 // StringGridEdit to add new record.
 //
 procedure AddRecordView;
 var n,i:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Новая запись:');
   for i:=1 to WordCount(fieldlist) do begin
    n:=n+EditAddInputLn(extractword(i,fieldlist)+'|');
   end;
   n:=n+EditAddSetting('@set StringGrid.Font Name:PT_Mono\Size:14');
   n:=n+EditAddClosing('StringGridEdit',EditGetUID('INSERT_TAB'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 //
 // Select Database file dialog
 //
 procedure SelectDatabaseFileDialog;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Укажите файл базы данных:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn(' ..\..\Data\*.db');
   n:=n+EditAddInputLn(' Database files (*.db)|*.db|');
   n:=n+EditAddInputLn(' All files (*.*)|*.*|');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('FileOpenDialog',EditGetUID('FOPEN'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 //
 // Procedure refresh table view
 //
 procedure RefreshTableView;
 begin
  if sGetTag(DbQuery.Table.tag)='' then
   NiceAlert('Не удалось: Не выбрана таблица для отображения',3000)
  else begin
   writeResult(DbQuery_Execute('SELECT * FROM '+sGetTag(DbQuery.Table.tag)+' LIMIT '+str(iGetTag(DbQuery.PageNum.tag)*10)+',10'),0);
   bNul(sSetTag(DbQuery.SQLQUERY.tag, 'SELECT * FROM '+sGetTag(DbQuery.Table.tag)));
  end;
 end;
 {
 Get connection string for given database.
 }
 function GetConnectionString(Database:String):String;
 const BuildConStr=true; var cs:String;
 begin
  cs:='';
  Database:=DaqFileRef(Database,'.db');
  if BuildConStr
  then cs:=db_build_connectionstring('SQLite3','',Database,'','','',0)
  else cs:='Provider=MSDASQL;DRIVER=SQLite3 ODBC Driver;Database='+Database+';';
  cs:=db_validate_known_providers(cs);
  GetConnectionString:=cs;
  cs:='';
 end;
 {
 GUI Handler to process user input...
 }
 procedure GUIHandler;
 var s:String; ClickCurve,i,page:Integer;
  procedure Cleanup;
  begin
   s:='';
  end;
  //
  // Edit/View Record StringGridEdit Handler
  //
  procedure RecordGridViewHandler;
  var dl,ans,item,query:String; i,Changed:Integer;
   procedure Cleanup(how:Integer);
   begin
    dl:=''; ans:=''; item:=''; query:='';
    if (how<>0) then Changed:=text_new else FreeAndZero(Changed);
   end;
  begin
   Cleanup(1);
   //
   // Find list of Changed items and save as Name = 'Value'
   //
   dl:=WordDelims('|');
   for i:=1 to EditGetAnswerCount-1 do begin
    ans:=EditGetAnswer(i);
    if (StringReplace(text_getln(DbQuery.fvlist,i-1),'=','|',0)<>ans) then begin
     item:=ExtractWord(1,ans)+' = '''+ExtractWord(2,ans)+'''';
     bNul(text_addln(Changed,item));
    end;
   end;
   sNul(WordDelims(dl));
   //
   // Build UPDATE query if has Changed items
   //
   if (text_numln(Changed)>0) then begin
    query:='UPDATE '+sGetTag(DbQuery.TABLE.tag)+' SET ';
    for i:=0 to text_numln(Changed)-1 do begin
     if i>0 then  query:=query+', ';
     item:=text_getln(Changed,i);
     query:=query+item;
    end;
    query:=query+' WHERE '+text_getln(DbQuery.fvlist,0);
    iNul(DbQuery_Execute(query));
    RefreshTableView;
   end;
   Cleanup(0);
  end;
  //
  // Edit/View Record StringGridEdit Handler
  //
  procedure AddRecordGridViewHandler;
  var fields,values,dl,query,seperator,index:String; i:Integer; hasData:boolean;
   procedure Cleanup;
   begin
    fields:=''; values:=''; dl:=''; query:=''; seperator:=''; hasData:=false;
   end;
  begin
   Cleanup;
   dl:=WordDelims('|');
   for i:=1 to EditGetAnswerCount-1 do begin
    if i<>1 then seperator:=',' else seperator:='';
    fields:=fields+seperator+ExtractWord(1,EditGetAnswer(i));
    values:=values+seperator+''''+ExtractWord(2,EditGetAnswer(i))+'''';
    if ExtractWord(2,EditGetAnswer(i))<>'' then hasData:=true;
   end;
   sNul(WordDelims(dl));
   //
   // Build INSERT query
   //
   if hasData then begin
    query:='INSERT INTO '+sGetTag(DbQuery.TABLE.tag)+' ('+fields+') VALUES('+values+');';
    iNul(DbQuery_Execute(query));
    RefreshTableView;
   end;
   Cleanup;
  end;
  //
  // Delete Records StringGridEdit Handler
  //
  procedure DelRecordsGridViewHandler;
  var rows,value,query,seperator:String; i,counter:Integer;
   procedure Cleanup;
   begin
    rows:=''; value:=''; query:=''; seperator:='';
   end;
  begin
   Cleanup;
   for i:=1 to PageRows do begin
    if iGetTag(DbQuery.Records.Selected[i].tag)=1 then begin
     value:=GetSqlResultStr(i,'');
     if value<>EmptyFiller then begin
      rows:=rows+' '+ExtractWord(2,value);
      counter:=counter+1;
     end;
    end;
   end;
   //
   // Build DELETE query
   //
   if counter>0 then begin
    query:='DELETE FROM '+sGetTag(DbQuery.Table.tag)+' WHERE ';
    for i:=1 to counter do begin
     if i<>1 then seperator:='OR ' else seperator:='';
     query:=query+seperator+'ID='+extractword(i,rows)+' ';
    end;
    iNul(DbQuery_Execute(query));
    RefreshTableView;
   end else NiceAlert('Не удалось: Нет данных для удаления',3000);
   Cleanup;
  end;
  //
  // Select Database FileDialog Handler
  //
  procedure SelectDatabaseFileDialogHandler;
  var s:String; i:Integer;
   procedure Cleanup;
   begin
    s:='';
   end;
  begin
   Cleanup;
   for i:=1 to EditGetAnswerCount-1 do begin
    writeln('Selected file ',edit('?ans '+str(i)));
    bNul(sSetTag(DbQuery.ConnectionLink.tag,GetConnectionString(edit('?ans '+str(i)))));
   end;
   Cleanup;
  end;
 begin
  Cleanup;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle sensor clicks...
     }
     page:=iGetTag(DbQuery.PageNum.tag);
     if IsSameText(ClickSensor,'HELP') then begin
      Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
      bNul(Voice(snd_Click));
     end;
     {}
     if IsSameText(ClickSensor,'btnSelectDB') then begin
      SelectDatabaseFileDialog;
      bNul(Voice(snd_Click));
     end;
     {}
     if IsSameText(ClickSensor,'btnConnect') then begin
      writeResult(DbQuery_Execute(sGetTag(DbQuery.SQLQuery.tag)),0);
      bNul(Voice(snd_Click));
     end;
     {}
     if IsSameText(ClickSensor,'btnPrevPage') then begin
      if page>=1 then bNul(iSetTag(DbQuery.PageNum.tag,page-1));
	  page:=iGetTag(DbQuery.PageNum.tag);
      writeResult(DbQuery_Execute('SELECT * FROM '+sGetTag(DbQuery.Table.tag)+' LIMIT '+str(page*10)+',10'),0);
      bNul(Voice(snd_Click));
     end;
     {}
     if IsSameText(ClickSensor,'btnNextPage') then begin
      bNul(iSetTag(DbQuery.PageNum.tag,page+1));
	  page:=iGetTag(DbQuery.PageNum.tag);
      writeResult(DbQuery_Execute('SELECT * FROM '+sGetTag(DbQuery.Table.tag)+' LIMIT '+str(page*10)+',10'),0);
      bNul(Voice(snd_Click));
     end;
     {}
     if IsSameText(ClickSensor,'btnAddRecord') then begin
      AddRecordView;
      bNul(Voice(snd_Click));
     end;
     {}
     if IsSameText(ClickSensor,'btnDelRecord') then begin
      DelRecordsGridViewHandler;
      bNul(Voice(snd_Click));
     end;
     {}
     if IsSameText(ClickSensor,'btnRefresh') then begin
      RefreshTableView;
      bNul(Voice(snd_Click));
     end;
     {
     Handle tag clicks..
     }
     for i:=1 to PageRows do begin
      ClickTagXorLocal(DbQuery.Records.Selected[i].tag,1);
     end;
     if (ClickTag<>0) then begin
      {}
      if ClickTag=DbQuery.Table.tag then begin
       ReadTableNameList(DbQuery_Execute('SELECT NAME FROM SQLITE_MASTER'),DbQuery.tblist);
       MenuToSelectTableFromList;
       bNul(Voice(snd_Click));
      end;
      {}
      for i:=1 to PageRows do
      if ClickTag=SqlResultTag(i) then begin
       s:=GetSqlResultStr(i,'');
       ReadRecordToView(DbQuery_Execute('SELECT * FROM '+sGetTag(DbQuery.TABLE.tag)+' WHERE '+ExtractWord(1,s)+' = '+extractword(2,s)),DbQuery.fvlist);
       RecordGridView;
       bNul(Voice(snd_Click));
      end;
      {}
      s:=mime_encode(SetFormUnderSensorLeftBottom(ClickParams('')));
      SendClickTagCmd(DbQuery.SQLQUERY.tag,       '@Edit SQLQUERY',   s);
      SendClickTagCmd(DbQuery.CONNECTIONLINK.tag, '@Edit SQLCONNECT', s);
     end;
     {
     Select Plot & Tab windows by curve...
     }
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     {
     Console commands: @url_encoded_sensor ...
     }
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Menu Tables.
   }
   EditMenuDefaultHandler(EditGetUID('MENU_TABLES'));
   {
   Edit/View Record StringGridEdit
   }
   if EditTestResultName(EditGetUID('UPDATE_TAB')) then  begin
    if EditTestResultCode(mr_OK) then
     RecordGridViewHandler;
    EditReset;
   end;
   {
   Add New Record StringGridEdit
   }
   if EditTestResultName(EditGetUID('INSERT_TAB')) then begin
    if EditTestResultCode(mr_OK) then
     AddRecordGridViewHandler;
    EditReset;
   end;
   {
   Select Database file dialog
   }
   if EditTestResultName(EditGetUID('FOPEN')) then begin
    if EditTestResultCode(mr_OK) then
     SelectDatabaseFileDialogHandler;
    EditReset;
   end;
   {
   If tag edit complete, send command to apply changes
   }
   if CheckEditTag(DbQuery.SQLQUERY.tag,s) then bNul(sSetTag(DbQuery.SQLQUERY.tag,s));
   if CheckEditTag(DbQuery.CONNECTIONLINK.tag,s) then bNul(sSetTag(DbQuery.CONNECTIONLINK.tag,s));
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  Cleanup;
 end;
 {
 DbQuery Cleaning
 }
 procedure DbQuery_Clear;
 begin
  fieldlist:='';
  DbQuery.dbc:=0;
  DbQuery.tblist:=0;
  DbQuery.fvlist:=0;
 end;
 {
 DbQuery Initialization
 }
 procedure DbQuery_Init;
 var i:integer;
 begin
  {
  Set uses DB engine: ADO,SQLDB.
  }
  db_engine_uses_assign(db_engine_ado);
  db_engine_uses_assign(db_engine_zeos);
  db_engine_uses_assign(db_engine_sqldb);
  {
  Register StdIn commands
  }
  cmd_Edit := RegisterStdInCmd('@Edit' , 'Edit paramerters.');
  cmd_View := RegisterStdInCmd('@view' , 'View data records.');
  cmd_Set  := RegisterStdInCmd('@Set'  , 'Set parameters.');
  {
  Initialize Vars
  }
  fieldlist:='';
  {
  Initialize tags
  }
  InitTag(DbQuery.ConnectionLink.tag, 'DbQuery.CONNECTIONLINK',   3);
  InitTag(DbQuery.SQLQuery.tag,       'DbQuery.SQLQUERY',         3);
  InitTag(DbQuery.PageNum.tag,        'DbQuery.PAGENUM',          1);
  InitTag(DbQuery.Table.tag,          'DbQuery.TABLE',            3);
  InitTag(DbQuery.ConStatus.tag,      'DbQuery.CONSTATUS',        1);

  for i:=1 to PageRows do begin
   InitTag(DbQuery.Records.Data[i].tag,     'DbQuery.SQLRESULT'+str(i),          3);
   InitTag(DbQuery.Records.Selected[i].tag, 'DbQuery.SQLRESULT'+str(i)+'.CHECK', 1);
  end;
  {
  Initialize tag values
  }
  ClearResultTable(Trim('??'));
  bNul(sSetTag(DbQuery.Table.tag,''));
  bNul(iSetTag(DbQuery.ConStatus.tag,con_ERROR));
  bNul(sSetTag(DbQuery.SQLQuery.tag, 'SELECT * FROM PEOPLE'));
  bNul(sSetTag(DbQuery.ConnectionLink.tag,GetConnectionString('..\Data\test.db')));
  {
  Initialize lists for field values and names
  }
  DbQuery.tblist:=text_new;
  DbQuery.fvlist:=text_new;
 end;
 {
 DbQuery Finalization
 }
 procedure DbQuery_Free;
 begin
  DbQuery_CloseConnection;
  FreeAndZero(DbQuery.dbc);
  FreeAndZero(DbQuery.tblist);
  FreeAndZero(DbQuery.fvlist);
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearDbLibrary;
  DbQuery_Clear;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  InitDbLibrary;
  DbQuery_Init;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  DbQuery_Free;
  FreeDbLibrary;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  if ShouldPollDbLibrary then PollDbLibrary;
  GUIHandler;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,par:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  par:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Edit SQLQUERY
   }
   if (cmdid = cmd_Edit) then begin
    par:=mime_decode(ExtractWord(2,arg));
    if IsSameText(ExtractWord(1,arg),'SQLQUERY')   then StartEditTagEx(DbQuery.SQLQuery.tag,'SQL Query',par);
    if IsSameText(ExtractWord(1,arg),'SQLCONNECT') then StartEditTagEx(DbQuery.ConnectionLink.tag,'SQL connect',par);
    Data:='';
   end else
   {
   @View Name=Value...
   }
   if (cmdid = cmd_View) then begin
    Success('View => '+arg);
    Data:='';
   end else
   {
   @SET TABLE
   }
   if (cmdid = cmd_Set) then begin
    if IsSameText(ExtractWord(1,arg),'TABLE') then begin
     bNul(sSetTag(DbQuery.Table.tag,ExtractWord(2,arg)));
     bNul(sSetTag(DbQuery.SQLQuery.tag,'SELECT * FROM '+ExtractWord(2,arg)));
     RefreshTableView;
    end;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
  par:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
