package spark.utils
{
   import mx.core.mx_internal;
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.elements.SpanElement;
   import mx.utils.StringUtil;
   import mx.resources.ResourceManager;
   import mx.resources.IResourceManager;
   import flashx.textLayout.compose.ISWFContext;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import mx.core.EmbeddedFont;
   import mx.core.IEmbeddedFontRegistry;
   import flash.text.engine.FontLookup;
   import mx.core.UIComponent;
   import mx.core.IFlexModuleFactory;
   
   use namespace mx_internal;
   
   [ResourceBundle("textLayout")]
   [ExcludeClass]
   public class TextUtil
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function TextUtil()
      {
         super();
      }
      
      public static function extractText(textFlow:TextFlow) : String
      {
         var p:ParagraphElement = null;
         var text:String = "";
         var leaf:FlowLeafElement = textFlow.getFirstLeaf();
         while(leaf)
         {
            for(p = leaf.getParagraph(); true; )
            {
               text = text + leaf.text;
               leaf = leaf.getNextLeaf(p);
               if(!leaf)
               {
                  break;
               }
            }
            leaf = p.getLastLeaf().getNextLeaf(null);
            if(leaf)
            {
               text = text + "\n";
            }
         }
         return text;
      }
      
      public static function getNumberOrPercentOf(value:Object, n:Number) : Number
      {
         var len:int = 0;
         var percent:Number = NaN;
         if(value is Number)
         {
            return Number(value);
         }
         if(value is String)
         {
            len = String(value).length;
            if(Boolean(len >= 1) && Boolean(value.charAt(len - 1) == "%"))
            {
               percent = Number(value.substring(0,len - 1));
               return percent / 100 * n;
            }
         }
         return NaN;
      }
      
      public static function obscureTextFlow(textFlow:TextFlow, obscurationChar:String) : void
      {
         var leafText:String = null;
         var leaf:FlowLeafElement = textFlow.getFirstLeaf();
         while(leaf)
         {
            if(leaf is SpanElement)
            {
               leafText = SpanElement(leaf).text;
               if(leafText)
               {
                  SpanElement(leaf).text = StringUtil.repeat(obscurationChar,leafText.length);
               }
            }
            leaf = leaf.getNextLeaf();
         }
      }
      
      public static function unobscureTextFlow(textFlow:TextFlow, text:String) : void
      {
         var span:SpanElement = null;
         var t:String = null;
         var leaf:FlowLeafElement = textFlow.getFirstLeaf();
         while(leaf)
         {
            if(leaf is SpanElement)
            {
               span = leaf as SpanElement;
               t = text.substr(leaf.getAbsoluteStart(),span.text.length);
               span.text = t;
            }
            leaf = leaf.getNextLeaf();
         }
      }
      
      public static function getResourceString(resourceName:String, args:Array = null) : String
      {
         var resourceManager:IResourceManager = ResourceManager.getInstance();
         return resourceManager.getString("textLayout",resourceName,args);
      }
      
      public static function resolveFontLookup(swfContext:ISWFContext, format:ITextLayoutFormat) : String
      {
         var name:String = null;
         var bold:Boolean = false;
         var italic:Boolean = false;
         var font:EmbeddedFont = null;
         var registry:IEmbeddedFontRegistry = null;
         if(Boolean(swfContext) && Boolean(format.fontLookup == FontLookup.EMBEDDED_CFF))
         {
            name = format.fontFamily;
            bold = format.fontWeight == "bold";
            italic = format.fontStyle == "italic";
            font = new EmbeddedFont(name,bold,italic);
            registry = UIComponent.embeddedFontRegistry;
            if(Boolean(registry) && Boolean(registry.isFontRegistered(font,IFlexModuleFactory(swfContext))))
            {
               return FontLookup.EMBEDDED_CFF;
            }
         }
         return FontLookup.DEVICE;
      }
   }
}
