package spark.accessibility
{
   import mx.accessibility.AccImpl;
   import mx.core.mx_internal;
   import spark.components.supportClasses.TextBase;
   import mx.core.UIComponent;
   import mx.accessibility.AccConst;
   import flash.events.Event;
   import flash.accessibility.Accessibility;
   
   use namespace mx_internal;
   
   public class TextBaseAccImpl extends AccImpl
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function TextBaseAccImpl(master:UIComponent)
      {
         super(master);
         role = AccConst.ROLE_SYSTEM_STATICTEXT;
      }
      
      public static function enableAccessibility() : void
      {
         TextBase.createAccessibilityImplementation = createAccessibilityImplementation;
      }
      
      mx_internal static function createAccessibilityImplementation(component:UIComponent) : void
      {
         component.accessibilityImplementation = new TextBaseAccImpl(component);
      }
      
      override protected function get eventsToHandle() : Array
      {
         return super.eventsToHandle.concat(["updateComplete"]);
      }
      
      override public function get_accState(childID:uint) : uint
      {
         var accState:uint = getState(childID);
         accState = accState & ~AccConst.STATE_SYSTEM_FOCUSABLE;
         accState = accState | AccConst.STATE_SYSTEM_READONLY;
         return accState;
      }
      
      override protected function getName(childID:uint) : String
      {
         var label:String = TextBase(master).text;
         return Boolean(label != null) && Boolean(label != "")?label:"";
      }
      
      override protected function eventHandler(event:Event) : void
      {
         $eventHandler(event);
         switch(event.type)
         {
            case "updateComplete":
               Accessibility.sendEvent(master,0,AccConst.EVENT_OBJECT_NAMECHANGE);
               Accessibility.updateProperties();
         }
      }
   }
}
